~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 17C0-154                          :LAS Program name and version
CREA.        2010/05/16 02:44                          :LAS Creation date {YYYY/MM/DD hh:mm}
DLIS_CREA.  2010-May-15 20:21                          :DLIS Creation date and time {YYYY-MMM-DD hh:mm}
SOURCE.     AIT_TLD_MCFL_CNL_016PUP.DLIS               :DLIS File Name
FILE-ID.     AIT_TLD_MCFL_CNL_016PUP                   :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      2223.2112       :START DEPTH     
STOP .M      3140.5068       :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        Nalcor Energy Oil and Gas                :COMPANY
WELL .        Nalcor et al Seamus 1                    :WELL
FLD  .        Parson's Pond                            :FIELD
LOC  .        Latitude: 49.98 N                        :LOCATION
CNTY .        Stoneham #11                             :COUNTY
STAT .        Newfoundland                             :STATE
CTRY .                                                 :COUNTRY
API  .                                                 :API NUMBER
UWI  .                                                 :UNIQUE WELL ID
DATE .        15-May-2010                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG     46 DEG 23 MIN 57.8 S                     :LATITUDE
LONG .DEG     48 DEG 27 MIN 52.1 S                     :LONGITUDE
GDAT .                                                 :GeoDetic Datum
SECT .        49.98 N                                  :Section
TOWN .        57.70 W                                  :Township
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          Run 1                    :RUN NUMBER
PDAT .        Ground Level               :Permanent Datum
EPD  .M          20.690001               :Elevation of Permanent Datum above Mean Sea Level
LMF  .          Kelly Bushing            :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           6.299999               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
AT10 .OHMM                                             :Array Induction Two Foot Resistivity A10 {F13.4}
AT20 .OHMM                                             :Array Induction Two Foot Resistivity A20 {F13.4}
AT30 .OHMM                                             :Array Induction Two Foot Resistivity A30 {F13.4}
AT60 .OHMM                                             :Array Induction Two Foot Resistivity A60 {F13.4}
AT90 .OHMM                                             :Array Induction Two Foot Resistivity A90 {F13.4}
ATCO90.MM/M                                            :Array Induction Two Foot Conductivity A90 {F13.4}
BS   .MM                                               :Bit Size {F13.4}
DPHI_DOL.V/V                                           :Density Porosity (matrix Dolomite) {F13.4}
DPHI_LIM.V/V                                           :Density Porosity (matrix Limestone) {F13.4}
DPHI_SAN.V/V                                           :Density Porosity (matrix Sandstone) {F13.4}
GDEV .DEG                                              :HGNS Deviation {F13.4}
GR   .GAPI                                             :Gamma-Ray {F13.4}
HCAL .MM                                               :HRCC Cal. Caliper {F13.4}
HDRA .K/M3                                             :HRDD Density Correction {F13.4}
HTEM .DEGC                                             :HTC Temperature {F13.4}
NPOR_DOL.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Dolomite) {F13.4}
NPOR_LIM.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Limestone) {F13.4}
NPOR_SAN.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Sandstone) {F13.4}
PEFZ .                                                 :HRDD Standard Resolution Formation Photoelectric Factor {F13.4}
RHOZ .K/M3                                             :HRDD Standard Resolution Formation Density {F13.4}
RXOZ .OHMM                                             :MCFL Standard Resolution Invaded Zone Resistivity {F13.4}
SP   .MV                                               :SP Shifted {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        AT10         AT20         AT30         AT60         AT90        ATCO90        BS         DPHI_DOL     DPHI_LIM     DPHI_SAN       GDEV         GR           HCAL         HDRA         HTEM       NPOR_DOL     NPOR_LIM     NPOR_SAN       PEFZ         RHOZ         RXOZ         SP           TENS
#
~A  
 2223.2112       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9952      49.8614     113.7238     141.6297      50.2237       0.3707       0.4259       0.4634      10.0000    2562.8354       0.2188     271.9375    3375.0000
 2223.3636       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      19.0083      47.8579     113.7238     141.6297      50.2237       0.3707       0.4259       0.4634      10.0000    2562.8354       0.2188     274.9375    3344.0000
 2223.5160       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9833      46.2333     113.7238     141.6297      50.2237       0.3707       0.4259       0.4634      10.0000    2562.8354       0.2188     271.6875    3365.0000
 2223.6684       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9774      43.3858     113.7238     141.6297      50.2237       0.3650       0.4188       0.4574      10.0000    2562.8354       0.2187     276.1250    3327.0000
 2223.8208       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9616      41.7350     113.7238     141.6297      50.2237       0.2966       0.3386       0.3848      10.0000    2562.8354       0.2186     272.8750    3368.0000
 2223.9732       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9732      40.1105     113.7238     141.6297      50.2237       0.2520       0.2873       0.3364      10.0000    2562.8354       0.2184     277.1875    3370.0000
 2224.1256       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9947      38.4605     113.7238     141.6297      50.2237       0.1965       0.2254       0.2750      10.0000    2562.8354       0.2181     270.1875    3371.0000
 2224.2780       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9762      35.8399     113.7238     141.6297      50.2237       0.2669       0.3048       0.3528      10.0000    2562.8354       0.2179     275.5000    3379.0000
 2224.4304       5.7352       0.4797       4.6515       5.3564       5.1961     192.4528     216.0000       0.1388       0.0683       0.0344      18.9841      33.5191     113.7238     131.8560      50.2237       0.3175       0.3614       0.4069      10.0000    2593.2854       0.2176     278.0000    3384.0000
 2224.5828       6.8420       0.4543       3.5804       3.1667       3.0984     322.7469     216.0000       0.0868       0.0121      -0.0239      18.9676      33.1352     113.7238     150.4798      50.2237       0.2763       0.3205       0.3641      10.0000    2689.3647       0.2178     278.0000    3370.0000
 2224.7352       3.9894       0.4313      14.9869      15.5251      11.0448      90.5406     216.0000       0.0573      -0.0199      -0.0570      18.9427      35.9827     113.7238     162.1366      50.2237       0.3454       0.3953       0.4368      10.0000    2744.0095       0.2177     285.8125    3379.0000
 2224.8876       5.6978       0.4270      10.3695       8.5973       5.6603     176.6675     216.0000       0.0478      -0.0302      -0.0676      18.9270      39.6960     113.7238     188.2043      50.2237       0.3591       0.4109       0.4511      10.0000    2761.5688       0.2177     283.6875    3354.0000
 2225.0400       5.6944       0.4288      16.9753      13.2035       9.0640     110.3266     216.0000       0.0754      -0.0003      -0.0367      18.9152      45.3584     113.7238     186.1231      50.2237       0.2730       0.3129       0.3597      10.0000    2710.4827       0.2173     289.3750    3361.0000
 2225.1924       6.2592       0.4402      66.3443      12.7071       7.5250     132.8896     216.0000       0.1078       0.0348      -0.0003      18.9340      46.9585     113.7238     177.6795      50.2237       0.2458       0.2826       0.3302      10.0000    2650.5168       0.2173     287.5000    3365.0000
 2225.3448       6.4298       0.4593     117.6785      23.7312       8.3476     119.7948     216.0000       0.1482       0.0785       0.0450      18.9257      44.4839     113.7238     138.8025      50.2237       0.2562       0.2942       0.3415      10.0000    2575.7874       0.2173     287.7500    3373.0000
 2225.4972       6.3329       0.4851     314.6322      34.1807      10.6044      94.3008     216.0000       0.1893       0.1230       0.0911      18.9127      42.5739     113.7238      89.1907      50.2237       0.3143       0.3581       0.4036      10.0000    2499.7192       0.2173     281.4375    3378.0000
 2225.6496       6.1257       0.5121     975.6501      65.5025      18.0207      55.4917     216.0000       0.2175       0.1535       0.1227      18.8857      41.7873     113.7238      42.0501      50.2237       0.3133       0.3573       0.4026      10.0000    2447.5898       0.2173     286.1250    3375.0000
 2225.8020       6.2116       0.5390    1950.0000      87.9795      17.8980      55.8723     216.0000       0.2215       0.1577       0.1271      18.8634      46.3507     113.7238      29.1152      50.2237       0.2857       0.3260       0.3731      10.0000    2440.3169       0.2174     279.5625    3377.0000
 2225.9544       6.9648       0.5613    1950.0000     157.1022      12.8818      77.6291     216.0000       0.2167       0.1525       0.1217      18.8605      44.2254     113.7238      28.7390      50.2237       0.2652       0.3051       0.3515      10.0000    2449.1533       0.2175     278.0000    3395.0000
 2226.1068       8.8266       0.5749    1950.0000     288.2460      15.8614      63.0463     216.0000       0.2135       0.1491       0.1182      18.8835      46.8392     113.7238      32.5360      50.2237       0.3107       0.3554       0.4000      10.0000    2454.9585       0.2175     281.8750    3383.0000
 2226.2592      12.8133       0.5776    1950.0000     430.3818      15.5317      64.3845     216.0000       0.1856       0.1189       0.0869      18.9041      44.0542     113.7238      80.1427      50.2237       0.3490       0.4014       0.4409      10.0000    2506.6602       0.2176     279.1875    3372.0000
 2226.4116      21.5892       0.5707    1950.0000     428.4907      15.7524      63.4823     216.0000       0.1550       0.0858       0.0526      18.9037      47.0744     113.7238     120.4844      50.2237       0.3318       0.3816       0.4228      10.0000    2563.2104       0.2177     284.6875    3389.0000
 2226.5640      42.3069       0.5584    1950.0000     302.2039      19.1865      52.1201     216.0000       0.1295       0.0583       0.0240      18.8733      47.9184     113.7238     160.1076      50.2237       0.2892       0.3338       0.3777      10.0000    2610.3665       0.2178     285.3750    3398.0000
 2226.7164      96.8105       0.5464    1950.0000     217.1528      18.9219      52.8489     216.0000       0.1303       0.0591       0.0249      18.8334      48.3825     113.7238     157.6731      50.2237       0.2614       0.2991       0.3469      10.0000    2608.8774       0.2177     287.7500    3412.0000
 2226.8688     252.2363       0.5385    1950.0000     175.4184      16.6186      60.1736     216.0000       0.1325       0.0615       0.0274      18.8025      47.1929     113.7238     166.2438      50.2237       0.2632       0.3020       0.3491      10.0000    2604.8713       0.2176     282.7500    3404.0000
 2227.0212     741.8168       0.5358    1950.0000     157.5081      15.7647      63.4330     216.0000       0.1501       0.0805       0.0471      18.7818      48.0065     113.7238     145.4315      50.2237       0.2944       0.3355       0.3823      10.0000    2572.3633       0.2175     288.4375    3394.0000
 2227.1736    1871.1144       0.5369    1950.0000     170.0457      32.8309      30.4591     216.0000       0.1846       0.1178       0.0857      18.7767      44.0612     113.7238     100.0798      50.2237       0.3242       0.3728       0.4148      10.0000    2508.5398       0.2175     281.9375    3391.0000
 2227.3260    1950.0000       0.5383    1950.0000     191.0852      38.8744      25.7239     216.0000       0.1963       0.1305       0.0988      18.7962      43.8296     113.7238      84.3658      50.2237       0.3557       0.4084       0.4478      10.0000    2486.9177       0.2176     292.6875    3381.0000
 2227.4784    1950.0000       0.5377    1950.0000     216.9117      33.7884      29.5959     216.0000       0.1801       0.1129       0.0807      18.7959      39.3298     113.7238     103.7147      50.2237       0.3958       0.4566       0.4896      10.0000    2516.8594       0.2177     281.6875    3380.0000
 2227.6308    1950.0000       0.5345    1950.0000     234.3108      18.8003      53.1907     216.0000       0.1478       0.0780       0.0445      18.8161      43.5396     113.7238     147.6076      50.2237       0.3444       0.3951       0.4358      10.0000    2576.6030       0.2177     287.7500    3400.0000
 2227.7832    1950.0000       0.5308    1950.0000     241.0165      13.7452      72.7529     216.0000       0.1376       0.0670       0.0331      18.8195      44.7577     113.7238     160.4595      50.2237       0.2510       0.2907       0.3364      10.0000    2595.3792       0.2176     285.9375    3367.0000
 2227.9356    1950.0000       0.5287    1950.0000     244.9185      12.9743      77.0754     216.0000       0.1391       0.0686       0.0347      18.7794      46.6133     113.7238     164.4862      50.2237       0.2527       0.2905       0.3378      10.0000    2592.6655       0.2176     280.5625    3384.0000
 2228.0880    1950.0000       0.5289    1950.0000     250.6823      19.8665      50.3359     216.0000       0.1557       0.0866       0.0534      18.7342      51.4547     113.7238     145.7465      50.2237       0.3228       0.3705       0.4132      10.0000    2561.9268       0.2176     283.7500    3380.0000
 2228.2404    1950.0000       0.5307    1950.0000     239.4123      41.5366      24.0752     216.0000       0.1866       0.1201       0.0881      18.7303      52.5021     113.7238     104.9378      50.2237       0.3842       0.4384       0.4769      10.0000    2504.7095       0.2176     286.1250    3380.0000
 2228.3928    1950.0000       0.5332    1950.0000     204.0801      38.5493      25.9408     216.0000       0.1987       0.1331       0.1016      18.7275      52.4736     113.7238      95.2766      50.2237       0.3664       0.4235       0.4594      10.0000    2482.3149       0.2177     286.1875    3399.0000
 2228.5452    1950.0000       0.5360    1950.0000     162.7355      27.3678      36.5393     216.0000       0.1889       0.1225       0.0906      18.7352      46.3198     113.7238     112.7741      50.2237       0.3827       0.4404       0.4760      10.0000    2500.4790       0.2178     284.7500    3403.0000
 2228.6976    1950.0000       0.5399    1950.0000     132.3167      18.0597      55.3720     216.0000       0.1643       0.0958       0.0630      18.7444      42.2597     113.7238     145.2668      50.2237       0.4068       0.4711       0.5012      10.0000    2546.0996       0.2180     287.4375    3368.0000
 2228.8500    1950.0000       0.5457    1950.0000     116.3825      18.1852      54.9898     216.0000       0.1570       0.0879       0.0548      18.7275      41.8814     113.7238     142.3328      50.2237       0.3327       0.3828       0.4238      10.0000    2559.6357       0.2181     278.0000    3395.0000
 2229.0024    1950.0000       0.5534    1950.0000     114.8577      20.5593      48.6399     216.0000       0.1547       0.0855       0.0523      18.7008      37.1275     113.7238     131.7649      50.2237       0.2721       0.3122       0.3588      10.0000    2563.7417       0.2181     286.1875    3363.0000
 2229.1548    1950.0000       0.5622    1950.0000     121.7662      28.3326      35.2950     216.0000       0.1525       0.0831       0.0498      18.6835      40.7808     113.7238     125.4947      50.2237       0.2312       0.2645       0.3138      10.0000    2567.8145       0.2180     279.8750    3372.0000
 2229.3072    1950.0000       0.5704    1950.0000     129.1336      32.0796      31.1724     216.0000       0.1553       0.0861       0.0529      18.6932      37.3230     113.7238     127.3470      50.2237       0.2250       0.2570       0.3067      10.0000    2562.7104       0.2179     293.0000    3400.0000
 2229.4596    1950.0000       0.5767    1950.0000     125.6280      38.2893      26.1170     216.0000       0.1609       0.0922       0.0592      18.6715      38.9476     113.7238     130.8219      50.2237       0.2668       0.3048       0.3527      10.0000    2552.3774       0.2179     281.6250    3390.0000
 2229.6120    1950.0000       0.5805    1950.0000     109.9807      28.6155      34.9462     216.0000       0.1648       0.0964       0.0636      18.6758      35.0588     113.7238     130.4207      50.2237       0.3210       0.3649       0.4105      10.0000    2545.0747       0.2180     287.7500    3403.0000
 2229.7644    1950.0000       0.5822    1950.0000      93.0213      23.8299      41.9640     216.0000       0.1642       0.0958       0.0629      18.6570      38.5535     113.7238     123.5223      50.2237       0.2833       0.3241       0.3707      10.0000    2546.2017       0.2181     287.7500    3409.0000
 2229.9168    1950.0000       0.5828    1950.0000      79.4171      17.5609      56.9446     216.0000       0.1636       0.0951       0.0622      18.6334      41.4799     113.7238     117.0704      50.2237       0.2398       0.2748       0.3234      10.0000    2547.3608       0.2181     283.4375    3389.0000
 2230.0692    1950.0000       0.5834    1950.0000      72.8594      15.5604      64.2655     216.0000       0.1641       0.0957       0.0628      18.6088      43.3070     113.7238     113.8170      50.2237       0.2453       0.2795       0.3290      10.0000    2546.3389       0.2182     282.0000    3378.0000
 2230.2216    1950.0000       0.5840    1950.0000      86.2389      20.2335      49.4231     216.0000       0.1624       0.0938       0.0608      18.6324      43.0666     113.7238     112.0269      50.2237       0.2777       0.3153       0.3641      10.0000    2549.6396       0.2181     278.0000    3364.0000
 2230.3740    1950.0000       0.5840    1950.0000     108.7057      38.1087      26.2407     216.0000       0.1637       0.0952       0.0623      18.6406      43.6214     113.7238     117.0228      50.2237       0.2184       0.2506       0.2997      10.0000    2547.1985       0.2181     279.5000    3370.0000
 2230.5264    1950.0000       0.5822    1950.0000     140.2392      43.3568      23.0644     216.0000       0.1706       0.1027       0.0701      18.6369      43.6492     113.7238     128.9947      50.2237       0.2535       0.2921       0.3388      10.0000    2534.3291       0.2181     278.0000    3383.0000
 2230.6788    1950.0000       0.5784    1950.0000     179.7373      34.1444      29.2873     216.0000       0.1808       0.1137       0.0815      18.6040      43.8248     113.7238     140.6035      50.2237       0.3571       0.4079       0.4488      10.0000    2515.5432       0.2182     285.9375    3364.0000
 2230.8312    1950.0000       0.5734    1950.0000     217.2736      21.7899      45.8927     216.0000       0.1878       0.1213       0.0894      18.5663      46.5182     113.7238     146.3947      50.2237       0.3795       0.4354       0.4724      10.0000    2502.5488       0.2183     278.0000    3383.0000
 2230.9836    1950.0000       0.5690    1950.0000     250.2338      18.7303      53.3894     216.0000       0.1880       0.1215       0.0895      18.5595      46.7555     113.7238     143.9929      50.2237       0.3535       0.4075       0.4458      10.0000    2502.2717       0.2183     278.0000    3365.0000
 2231.1360    1950.0000       0.5667    1950.0000     295.1892      26.8396      37.2584     216.0000       0.1848       0.1180       0.0859      18.5555      43.9357     113.7238     142.1819      50.2237       0.3686       0.4234       0.4612      10.0000    2508.1919       0.2183     278.0000    3356.0000
 2231.2884    1950.0000       0.5671    1950.0000     346.2136      32.5671      30.7059     216.0000       0.1769       0.1096       0.0772      18.5765      37.0649     113.7238     137.5909      50.2237       0.3218       0.3689       0.4120      10.0000    2522.6445       0.2182     278.0000    3370.0000
 2231.4408    1950.0000       0.5692    1950.0000     380.1187      48.3220      20.6945     216.0000       0.1675       0.0994       0.0666      18.5569      33.9800     113.7238     131.1674      50.2237       0.3064       0.3504       0.3955      10.0000    2540.0347       0.2182     281.0000    3372.0000
 2231.5932    1950.0000       0.5711    1950.0000     370.4455      45.7871      21.8402     216.0000       0.1544       0.0851       0.0519      18.5149      34.5902     113.7238     120.5077      50.2237       0.2813       0.3203       0.3682      10.0000    2564.4475       0.2183     275.5625    3358.0000
 2231.7456    1950.0000       0.5717    1950.0000     336.0949      34.2398      29.2058     216.0000       0.1437       0.0735       0.0399      18.5065      39.4639     113.7238     112.9494      50.2237       0.2020       0.2300       0.2808      10.0000    2584.2410       0.2183     280.3750    3383.0000
 2231.8980    1950.0000       0.5709    1950.0000     307.2437      26.5063      37.7269     216.0000       0.1352       0.0643       0.0303      18.4709      41.4716     113.7238     112.0143      50.2237       0.1536       0.1743       0.2251      10.0000    2599.9631       0.2183     278.0000    3366.0000
 2232.0504    1950.0000       0.5700    1950.0000     303.5157      25.0579      39.9076     216.0000       0.1322       0.0611       0.0270      18.4827      40.2300     113.7238     116.9307      50.2237       0.1760       0.1986       0.2506      10.0000    2605.5168       0.2183     283.6875    3365.0000
 2232.2028    1950.0000       0.5708    1950.0000     313.0494      35.1231      28.4713     216.0000       0.1291       0.0578       0.0235      18.4930      38.4012     113.7238     118.6564      50.2237       0.1587       0.1796       0.2308      10.0000    2611.2366       0.2182     272.0625    3380.0000
 2232.3552    1950.0000       0.5738    1950.0000     308.8720      31.9605      31.2887     216.0000       0.1306       0.0595       0.0253      18.5122      35.3559     113.7238     122.7627      50.2237       0.1457       0.1652       0.2159      10.0000    2608.3367       0.2182     283.6875    3359.0000
 2232.5076    1950.0000       0.5784    1950.0000     274.7671      30.8130      32.4539     216.0000       0.1336       0.0626       0.0285      18.5077      37.6146     113.7238     125.3409      50.2237       0.1892       0.2138       0.2657      10.0000    2602.9075       0.2182     276.5625    3383.0000
 2232.6600    1950.0000       0.5828    1950.0000     226.2309      28.8356      34.6794     216.0000       0.1352       0.0644       0.0303      18.4629      35.4980     113.7238     127.5284      50.2237       0.1998       0.2268       0.2780      10.0000    2599.9316       0.2182     278.6875    3378.0000
 2232.8124    1950.0000       0.5852    1950.0000     188.5123      28.4405      35.1611     216.0000       0.1342       0.0634       0.0293      18.4372      35.9253     113.7238     126.4761      50.2237       0.2580       0.2911       0.3422      10.0000    2601.6379       0.2181     268.2500    3365.0000
 2232.9648    1950.0000       0.5847    1950.0000     170.2338      27.1047      36.8939     216.0000       0.1339       0.0630       0.0289      18.4418      33.6667     113.7238     125.8910      50.2237       0.2097       0.2383       0.2893      10.0000    2602.2334       0.2181     280.5625    3377.0000
 2233.1172    1950.0000       0.5817    1950.0000     172.6482      25.9728      38.5019     216.0000       0.1358       0.0651       0.0311      18.4293      33.5188     113.7238     127.4769      50.2237       0.1822       0.2071       0.2582      10.0000    2598.6926       0.2181     276.5000    3365.0000
 2233.2696    1950.0000       0.5776    1950.0000     197.7080      25.9690      38.5074     216.0000       0.1383       0.0677       0.0338      18.4174      35.1529     113.7238     127.5372      50.2237       0.1858       0.2111       0.2622      10.0000    2594.2129       0.2180     277.3125    3372.0000
 2233.4220    1950.0000       0.5745    1950.0000     257.3063      25.8282      38.7173     216.0000       0.1417       0.0715       0.0377      18.4349      37.9951     113.7238     129.3995      50.2237       0.1993       0.2256       0.2773      10.0000    2587.7783       0.2182     278.0000    3378.0000
 2233.5744    1950.0000       0.5733    1950.0000     371.7925      26.9404      37.1190     216.0000       0.1478       0.0781       0.0446      18.4092      42.6934     113.7238     135.1523      50.2237       0.2215       0.2516       0.3025      10.0000    2576.4819       0.2183     278.0000    3384.0000
 2233.7268    1950.0000       0.5739    1950.0000     543.4004      25.7815      38.7875     216.0000       0.1499       0.0803       0.0468      18.4083      44.0580     113.7238     137.4381      50.2237       0.2608       0.2964       0.3458      10.0000    2572.7041       0.2185     278.0000    3396.0000
 2233.8792    1950.0000       0.5752    1950.0000     646.5073      29.3319      34.0926     216.0000       0.1499       0.0803       0.0469      18.4005      44.4914     113.7238     135.9923      50.2237       0.2747       0.3132       0.3612      10.0000    2572.6921       0.2185     270.3125    3378.0000
 2234.0316    1950.0000       0.5758    1950.0000     513.7712      30.8055      32.4618     216.0000       0.1487       0.0790       0.0455      18.4002      42.6354     113.7238     129.7941      50.2237       0.2256       0.2585       0.3076      10.0000    2574.9661       0.2183     271.7500    3381.0000
 2234.1840    1950.0000       0.5748    1950.0000     312.8647      47.0556      21.2515     216.0000       0.1523       0.0829       0.0495      18.3776      43.5637     113.7238     131.6850      50.2237       0.2597       0.2946       0.3445      10.0000    2568.3115       0.2180     267.3125    3387.0000
 2234.3364    1950.0000       0.5726    1950.0000     189.3965      38.3919      26.0472     216.0000       0.1526       0.0833       0.0499      18.3815      44.5514     113.7238     135.5186      50.2237       0.2942       0.3350       0.3821      10.0000    2567.6042       0.2179     278.0000    3387.0000
 2234.4888    1950.0000       0.5703    1950.0000     128.0831      32.6334      30.6435     216.0000       0.1464       0.0766       0.0430      18.3448      42.5429     113.7238     135.5782      50.2237       0.3085       0.3509       0.3973      10.0000    2579.0806       0.2179     269.6250    3421.0000
 2234.6412    1950.0000       0.5694    1950.0000      99.6524      22.7226      44.0091     216.0000       0.1393       0.0688       0.0350      18.3399      39.6328     114.0029     132.4263      50.2237       0.2553       0.2920       0.3403      10.0000    2592.3301       0.2181     272.2500    3411.0000
 2234.7936    1950.0000       0.5709    1950.0000      81.8724      14.7132      67.9661     216.0000       0.1384       0.0679       0.0340      18.3238      37.9254     113.7238     133.5185      50.2237       0.2100       0.2409       0.2902      10.0000    2593.8774       0.2183     268.8125    3414.0000
 2234.9460    1950.0000       0.5748    1950.0000      92.4509      18.7444      53.3491     216.0000       0.1447       0.0747       0.0411      18.3284      39.3492     113.7238     144.7096      50.2237       0.2137       0.2442       0.2942      10.0000    2582.2378       0.2184     272.8125    3407.0000
 2235.0984    1950.0000       0.5798    1950.0000     105.6022      33.9076      29.4919     216.0000       0.1792       0.1120       0.0797      18.3123      41.7951     113.7238     115.6025      50.2237       0.2523       0.2893       0.3372      10.0000    2518.5500       0.2183     268.5625    3400.0000
 2235.2508    1950.0000       0.5842    1950.0000     118.1219      28.0959      35.5924     216.0000       0.1967       0.1309       0.0993      18.3141      40.0513     113.7238     104.5940      50.2237       0.3173       0.3625       0.4070      10.0000    2486.0928       0.2182     268.5000    3391.0000
 2235.4032    1950.0000       0.5869    1950.0000     118.0787      22.6568      44.1368     216.0000       0.2002       0.1347       0.1033      18.3244      42.2601     113.7238     106.6003      50.2237       0.4023       0.4592       0.4955      10.0000    2479.6079       0.2182     271.3125    3380.0000
 2235.5556    1950.0000       0.5877    1950.0000     104.6402      17.4909      57.1726     216.0000       0.1758       0.1083       0.0758      18.3137      42.8651     113.7238     146.9476      50.2237       0.3414       0.3931       0.4330      10.0000    2524.8584       0.2182     273.1250    3383.0000
 2235.7080    1950.0000       0.5875    1950.0000      86.8587      14.4302      69.2992     216.0000       0.1617       0.0930       0.0601      18.2950      45.3052     113.7238     163.2917      50.2237       0.3463       0.3948       0.4374      10.0000    2550.9102       0.2182     271.7500    3404.0000
 2235.8604    1950.0000       0.5873    1950.0000      76.0729      15.0387      66.4951     216.0000       0.1517       0.0822       0.0489      18.2736      44.3167     113.7238     153.6157      50.2237       0.3004       0.3430       0.3889      10.0000    2569.3628       0.2181     268.5000    3450.0000
 2236.0128    1950.0000       0.5879    1950.0000      77.3136      14.4901      69.0124     216.0000       0.1385       0.0680       0.0341      18.2491      41.0396     113.7238     143.0325      50.2237       0.2796       0.3179       0.3662      10.0000    2593.7551       0.2181     273.8125    3435.0000
 2236.1652    1950.0000       0.5889    1950.0000      77.8602      13.0148      76.8354     216.0000       0.1297       0.0584       0.0242      18.2241      41.0709     113.7238     135.6404      50.2237       0.2131       0.2446       0.2938      10.0000    2610.0769       0.2182     270.0000    3408.0000
 2236.3176    1950.0000       0.5897    1950.0000      91.3409      13.0557      76.5949     216.0000       0.1290       0.0577       0.0234      18.2303      38.8111     113.7238     135.8347      50.2237       0.2194       0.2507       0.3005      10.0000    2611.3376       0.2183     270.3125    3428.0000
 2236.4700    1950.0000       0.5887    1950.0000     113.1978      14.0657      71.0951     216.0000       0.1343       0.0634       0.0293      18.2242      43.6835     113.7238     144.6555      50.2237       0.2356       0.2706       0.3189      10.0000    2601.5991       0.2183     274.3750    3391.0000
 2236.6224    1950.0000       0.5847    1950.0000     151.4902      15.0683      66.3646     216.0000       0.1595       0.0907       0.0577      18.2411      42.0485     113.7238     126.5588      50.2237       0.2730       0.3115       0.3594      10.0000    2554.8457       0.2183     266.5625    3418.0000
 2236.7748    1950.0000       0.5773    1950.0000     207.7808      23.7542      42.0978     216.0000       0.1860       0.1194       0.0873      18.2099      45.8520     113.7238     106.1554      50.2237       0.3962       0.4528       0.4893      10.0000    2505.8958       0.2183     276.6250    3419.0000
 2236.9272    1950.0000       0.5680    1950.0000     268.5298      22.2499      44.9439     216.0000       0.1834       0.1165       0.0844      18.1828      42.8330     113.7238     105.8004      50.2237       0.4370       0.4985       0.5307      10.0000    2510.7053       0.2181     268.2500    3420.0000
 2237.0796    1950.0000       0.5593    1950.0000     303.9409      23.5347      42.4905     216.0000       0.1591       0.0903       0.0572      18.1696      40.9815     113.7238     130.4786      50.2237       0.3368       0.3923       0.4290      10.0000    2555.5928       0.2180     278.0000    3405.0000
 2237.2320    1950.0000       0.5531    1744.1710     311.4169      16.9515      58.9917     216.0000       0.1462       0.0763       0.0427      18.1805      42.6433     113.7238     144.9359      50.2237       0.2261       0.2636       0.3092      10.0000    2579.5693       0.2180     272.0625    3433.0000
 2237.3844    1950.0000       0.5501     853.0485     276.3631      17.8824      55.9210     216.0000       0.1482       0.0785       0.0450      18.1891      43.8352     113.7238     145.3874      50.2237       0.3888       0.4416       0.4812      10.0000    2575.7659       0.2179     272.2500    3407.0000
 2237.5368    1950.0000       0.5494     382.6878     213.9718      30.1819      33.1324     216.0000       0.1478       0.0781       0.0445      18.1915      48.3015     113.7238     140.5501      50.2237       0.4210       0.4766       0.5138      10.0000    2576.5237       0.2179     262.7500    3432.0000
 2237.6892    1950.0000       0.5498     173.8600     135.9308      51.5134      19.4124     216.0000       0.1321       0.0611       0.0269      18.1553      45.4793     113.7238     143.9922      50.2237       0.3001       0.3467       0.3894      10.0000    2605.5508       0.2179     273.5625    3431.0000
 2237.8416    1950.0000       0.5488      89.4929      78.8369      38.0313      26.2941     216.0000       0.1277       0.0562       0.0219      18.1465      43.4739     113.7238     133.4839      50.2237       0.2480       0.2862       0.3329      10.0000    2613.8171       0.2179     261.3750    3427.0000
 2237.9940    1950.0000       0.5504      43.1533      37.0722      21.2978      46.9531     216.0000       0.1264       0.0549       0.0205      18.1259      42.4861     113.7238     137.5596      50.2237       0.2620       0.3011       0.3480      10.0000    2616.1877       0.2181     258.5000    3406.0000
 2238.1464    1950.0000       0.5432      34.3597      26.7747      20.0071      49.9824     216.0000       0.1081       0.0351       0.0000      18.1386      43.6465     113.7238     147.5728      50.2237       0.3228       0.3675       0.4125      10.0000    2649.9895       0.2183     258.5000    3402.0000
 2238.2988    1950.0000       0.5458      19.2806      30.8151      13.6750      73.1262     216.0000       0.0728      -0.0032      -0.0396      18.1501      41.1856     113.7238     170.3324      50.2237       0.3328       0.3789       0.4231      10.0000    2715.3943       0.2185     258.5000    3395.0000
 2238.4512    1950.0000       0.5311      13.0817      11.2040       9.6427     103.7052     216.0000       0.0394      -0.0392      -0.0770      18.1663      35.8799     113.7238     177.2962      50.2237       0.2230       0.2551       0.3047      10.0000    2777.0432       0.2186     270.9375    3392.0000
 2238.6036    1950.0000       0.5528      38.1205      17.4902      17.4079      57.4453     216.0000       0.0402      -0.0383      -0.0761      18.1433      33.1158     113.7238     164.4082      50.2237       0.2059       0.2357       0.2855      10.0000    2775.5569       0.2185     278.0000    3406.0000
 2238.7560    1950.0000       0.5732      45.0805      28.0393      22.8450      43.7732     216.0000       0.0749      -0.0008      -0.0372      18.1058      37.2091     113.7238     145.4358      50.2237       0.2400       0.2724       0.3229      10.0000    2711.3740       0.2183     283.4375    3461.0000
 2238.9084    1950.0000       0.5812      71.9766      36.3291      27.8959      35.8475     216.0000       0.1117       0.0390       0.0041      18.1013      41.2945     113.7238     137.7044      50.2237       0.2306       0.2626       0.3128      10.0000    2643.3032       0.2181     287.7500    3418.0000
 2239.0608    1950.0000       0.5850      94.0921      38.7610      23.3796      42.7723     216.0000       0.1291       0.0579       0.0236      18.0982      39.4170     113.7238     146.1341      50.2237       0.2263       0.2576       0.3079      10.0000    2611.0735       0.2181     292.0625    3420.0000
 2239.2132    1950.0000       0.5878     139.1532      27.7751      16.7156      59.8245     216.0000       0.1276       0.0561       0.0218      18.1014      39.0050     113.7238     146.5557      50.2237       0.3060       0.3440       0.3936      10.0000    2614.0195       0.2181     287.7500    3416.0000
 2239.3656    1950.0000       0.5890     195.9359      36.6874      15.2997      65.3606     216.0000       0.1253       0.0537       0.0193      18.1107      40.1980     113.7238     139.2236      50.2237       0.2361       0.2693       0.3190      10.0000    2618.1987       0.2180     295.5625    3407.0000
 2239.5180    1950.0000       0.5932     274.7031      40.6767      20.1224      49.6959     216.0000       0.1352       0.0644       0.0304      18.0873      40.0210     113.7238     133.9226      50.2237       0.1958       0.2235       0.2739      10.0000    2599.9014       0.2180     288.5000    3403.0000
 2239.6704    1950.0000       0.5954     383.0920      52.2141      36.6106      27.3145     216.0000       0.1511       0.0816       0.0482      18.0655      41.0379     113.7238     135.9000      50.2237       0.1906       0.2174       0.2680      10.0000    2570.4883       0.2180     293.1250    3397.0000
 2239.8228    1950.0000       0.5950     551.1436      86.8178      33.6068      29.7559     216.0000       0.1609       0.0922       0.0592      18.0367      41.2739     113.7238     142.9987      50.2237       0.2219       0.2518       0.3029      10.0000    2552.2754       0.2181     293.0000    3372.0000
 2239.9752    1950.0000       0.5928     837.9507     124.6980      28.5131      35.0716     216.0000       0.1596       0.0908       0.0577      18.0334      43.5318     113.7238     148.2997      50.2237       0.2693       0.3042       0.3546      10.0000    2554.7327       0.2182     292.3750    3380.0000
 2240.1276    1950.0000       0.5898    1237.8241     211.7216      18.7404      53.3606     216.0000       0.1504       0.0808       0.0474      18.0305      41.5344     113.7238     145.1638      50.2237       0.2666       0.3019       0.3518      10.0000    2571.7485       0.2183     298.1250    3351.0000
 2240.2800    1950.0000       0.5872    1626.3201     354.4989      17.8673      55.9681     216.0000       0.1433       0.0732       0.0395      18.0154      40.7156     113.7238     137.2292      50.2237       0.2226       0.2530       0.3037      10.0000    2584.8474       0.2183     293.6875    3382.0000
 2240.4324    1950.0000       0.5858    1893.6222     510.7151      16.1648      61.8626     216.0000       0.1404       0.0700       0.0362      18.0230      38.4577     113.7238     128.6607      50.2237       0.2240       0.2544       0.3052      10.0000    2590.3462       0.2182     297.5000    3384.0000
 2240.5848    1950.0000       0.5860    1950.0000     605.3433      22.3648      44.7131     216.0000       0.1419       0.0717       0.0379      18.0331      34.9448     113.7238     123.9779      50.2237       0.1844       0.2092       0.2606      10.0000    2587.4080       0.2181     293.0000    3399.0000
 2240.7372    1950.0000       0.5874    1950.0000     632.4175      21.9355      45.5882     216.0000       0.1442       0.0741       0.0405      18.0379      34.3711     113.7238     124.9421      50.2237       0.1733       0.1971       0.2480      10.0000    2583.2278       0.2180     297.5000    3406.0000
 2240.8896    1950.0000       0.5889    1950.0000     573.0774      35.2117      28.3997     216.0000       0.1473       0.0775       0.0440      18.0043      36.4256     114.2820     132.4680      50.2237       0.1672       0.1894       0.2408      10.0000    2577.4626       0.2179     293.1250    3447.0000
 2241.0420    1950.0000       0.5895    1950.0000     460.5863      31.7728      31.4735     216.0000       0.1475       0.0777       0.0442      17.9884      37.8680     113.7238     135.3679      50.2237       0.1690       0.1915       0.2429      10.0000    2577.0503       0.2179     297.5000    3428.0000
 2241.1944    1950.0000       0.5880    1950.0000     352.2715      23.8930      41.8533     216.0000       0.1496       0.0800       0.0465      17.9577      37.8680     113.7238     134.8829      50.2237       0.2094       0.2362       0.2884      10.0000    2573.2068       0.2180     287.7500    3423.0000
 2241.3468    1950.0000       0.5845    1950.0000     273.3017      27.0964      36.9053     216.0000       0.1514       0.0819       0.0485      17.9698      36.2409     113.7238     129.0050      50.2237       0.2564       0.2896       0.3405      10.0000    2569.9055       0.2180     295.7500    3430.0000
 2241.4992    1950.0000       0.5797    1950.0000     222.5477      21.1000      47.3933     216.0000       0.1540       0.0847       0.0514      17.9689      38.5434     113.7238     126.0223      50.2237       0.2261       0.2587       0.3081      10.0000    2565.1140       0.2181     294.5625    3419.0000
 2241.6516    1950.0000       0.5750    1950.0000     189.1600      24.1145      41.4688     216.0000       0.1549       0.0857       0.0525      17.9808      39.9029     113.7238     126.4064      50.2237       0.2322       0.2667       0.3151      10.0000    2563.3831       0.2181     290.1875    3419.0000
 2241.8040    1950.0000       0.5719    1950.0000     157.8031      25.0726      39.8842     216.0000       0.1537       0.0844       0.0511      17.9556      40.2877     113.7238     127.3325      50.2237       0.2509       0.2856       0.3351      10.0000    2565.6194       0.2182     295.1875    3420.0000
 2241.9564    1950.0000       0.5710    1950.0000     124.3458      26.2973      38.0268     216.0000       0.1544       0.0852       0.0519      17.9624      41.7124     113.7238     128.1667      50.2237       0.2851       0.3221       0.3716      10.0000    2564.3342       0.2181     295.9375    3428.0000
 2242.1088    1950.0000       0.5725    1950.0000      96.4281      24.4851      40.8411     216.0000       0.1562       0.0871       0.0539      17.9539      41.7124     113.7238     123.5027      50.2237       0.2212       0.2519       0.3023      10.0000    2561.1035       0.2181     297.3125    3380.0000
 2242.2612    1950.0000       0.5759    1950.0000      78.7581      24.0937      41.5046     216.0000       0.1605       0.0917       0.0587      17.9487      42.9549     113.7238     117.9233      50.2237       0.2236       0.2556       0.3053      10.0000    2553.1362       0.2182     289.1250    3395.0000
 2242.4136    1950.0000       0.5804    1950.0000      59.6691      16.3088      61.3165     216.0000       0.1684       0.1003       0.0676      17.9341      41.9942     113.7238     118.7797      50.2237       0.2496       0.2853       0.3340      10.0000    2538.4233       0.2183     292.3750    3412.0000
 2242.5660    1950.0000       0.5850    1950.0000      72.8423      19.6777      50.8190     216.0000       0.1759       0.1084       0.0760      17.9406      43.6492     113.7238     125.0973      50.2237       0.3198       0.3629       0.4091      10.0000    2524.6584       0.2183     287.7500    3412.0000
 2242.7184    1950.0000       0.5884    1950.0000      90.9238      24.2334      41.2653     216.0000       0.1761       0.1086       0.0762      17.9218      44.7887     113.7238     126.8642      50.2237       0.3041       0.3475       0.3929      10.0000    2524.2725       0.2183     287.7500    3402.0000
 2242.8708    1950.0000       0.5898    1950.0000     120.2253      23.8415      41.9437     216.0000       0.1690       0.1010       0.0683      17.9085      43.0390     113.7238     120.5335      50.2237       0.2809       0.3203       0.3679      10.0000    2537.3455       0.2183     285.2500    3412.0000
 2243.0232    1950.0000       0.5887    1950.0000     182.1504      25.3117      39.5074     216.0000       0.1598       0.0910       0.0580      17.9178      40.5720     113.7238     109.8590      50.2237       0.2451       0.2777       0.3283      10.0000    2554.3545       0.2183     287.7500    3385.0000
 2243.1756    1950.0000       0.5851    1950.0000     275.3843      27.0301      36.9958     216.0000       0.1587       0.0898       0.0567      17.9204      39.1795     113.7238     106.4048      50.2237       0.1851       0.2106       0.2616      10.0000    2556.3669       0.2182     284.5000    3413.0000
 2243.3280    1950.0000       0.5796    1950.0000     351.7397      31.0071      32.2506     216.0000       0.1601       0.0914       0.0583      17.9203      40.5774     113.7238     103.9288      50.2237       0.1754       0.1996       0.2505      10.0000    2553.7346       0.2182     287.7500    3420.0000
 2243.4804    1950.0000       0.5737    1950.0000     361.1990      23.6954      42.2024     216.0000       0.1614       0.0927       0.0597      17.9049      39.7901     113.7238     101.0377      50.2237       0.2055       0.2337       0.2846      10.0000    2551.4177       0.2183     285.8125    3411.0000
 2243.6328    1950.0000       0.5687    1950.0000     332.1231      19.9750      50.0625     216.0000       0.1667       0.0985       0.0657      17.8886      40.9505     113.7238     104.3229      50.2237       0.2141       0.2439       0.2944      10.0000    2541.6296       0.2183     285.8750    3400.0000
 2243.7852    1950.0000       0.5658    1950.0000     301.3908      22.7851      43.8883     216.0000       0.1741       0.1064       0.0740      17.8601      40.3661     113.7238     114.3365      50.2237       0.2602       0.2957       0.3452      10.0000    2527.9824       0.2183     286.7500    3421.0000
 2243.9376    1950.0000       0.5653    1950.0000     269.5888      32.0160      31.2343     216.0000       0.1806       0.1135       0.0813      17.8483      39.5294     113.7238     125.7494      50.2237       0.2978       0.3388       0.3859      10.0000    2515.8828       0.2182     283.8750    3391.0000
 2244.0900    1950.0000       0.5663    1950.0000     230.0981      34.3490      29.1129     216.0000       0.1769       0.1095       0.0771      17.8702      39.5592     113.7238     127.1656      50.2237       0.3066       0.3516       0.3958      10.0000    2522.7871       0.2181     278.4375    3445.0000
 2244.2424    1950.0000       0.5679    1950.0000     189.5617      36.8764      27.1176     216.0000       0.1706       0.1026       0.0700      17.8685      42.5797     113.7238     124.6870      50.2237       0.2994       0.3454       0.3886      10.0000    2534.4739       0.2180     286.2500    3420.0000
 2244.3948    1950.0000       0.5698    1950.0000     158.4132      26.5100      37.7216     216.0000       0.1693       0.1013       0.0686      17.8933      44.0008     113.7238     127.1732      50.2237       0.3166       0.3675       0.4073      10.0000    2536.7510       0.2180     284.1250    3421.0000
 2244.5472    1950.0000       0.5720    1950.0000     142.7469      23.4780      42.5931     216.0000       0.1728       0.1050       0.0725      17.8695      48.3805     113.7238     133.1296      50.2237       0.3944       0.4521       0.4877      10.0000    2530.3872       0.2181     283.3125    3427.0000
 2244.6996    1950.0000       0.5749    1950.0000     141.9468      22.3566      44.7296     216.0000       0.1765       0.1091       0.0767      17.8105      48.4109     113.7238     140.7144      50.2237       0.4084       0.4718       0.5026      10.0000    2523.4412       0.2182     287.5625    3424.0000
 2244.8520    1950.0000       0.5786    1950.0000     158.2823      26.4363      37.8268     216.0000       0.1752       0.1076       0.0752      17.7775      45.3858     113.7238     146.6560      50.2237       0.4029       0.4642       0.4969      10.0000    2525.9651       0.2182     281.2500    3457.0000
 2245.0044    1950.0000       0.5823    1950.0000     193.9336      33.7181      29.6576     216.0000       0.1681       0.1000       0.0673      17.7620      42.1367     114.2820     151.6566      50.2237       0.3596       0.4122       0.4517      10.0000    2539.0198       0.2180     283.1250    3459.0000
 2245.1568    1950.0000       0.5851    1950.0000     249.0641      44.7164      22.3631     216.0000       0.1577       0.0888       0.0556      17.7937      39.4926     113.7238     154.8240      50.2237       0.2426       0.2782       0.3264      10.0000    2558.2078       0.2179     287.5000    3456.0000
 2245.3092    1950.0000       0.5865    1950.0000     312.7258      34.5104      28.9768     216.0000       0.1468       0.0770       0.0434      17.7906      39.2694     114.0029     155.4720      50.2237       0.2302       0.2623       0.3123      10.0000    2578.3743       0.2179     286.5000    3447.0000
 2245.4616    1950.0000       0.5866    1950.0000     362.7476      26.0040      38.4556     216.0000       0.1370       0.0663       0.0324      17.8074      39.7336     113.7238     150.8658      50.2237       0.2276       0.2581       0.3091      10.0000    2596.5725       0.2179     288.8750    3435.0000
 2245.6140    1950.0000       0.5862    1950.0000     395.6435      20.5503      48.6611     216.0000       0.1315       0.0604       0.0262      17.7832      38.2870     113.7238     146.4236      50.2237       0.2049       0.2330       0.2839      10.0000    2606.7776       0.2178     287.7500    3378.0000
 2245.7664    1950.0000       0.5857    1950.0000     438.6559      22.2457      44.9526     216.0000       0.1295       0.0582       0.0240      17.7831      40.9871     113.7238     141.7179      50.2237       0.2100       0.2389       0.2897      10.0000    2610.4578       0.2177     287.7500    3420.0000
 2245.9188    1950.0000       0.5852    1950.0000     512.2492      29.0142      34.4659     216.0000       0.1299       0.0587       0.0245      17.7442      40.8669     113.7238     140.5029      50.2237       0.2382       0.2697       0.3207      10.0000    2609.5964       0.2175     287.4375    3416.0000
 2246.0712    1950.0000       0.5844    1950.0000     601.9935      32.4059      30.8586     216.0000       0.1307       0.0596       0.0254      17.7466      43.1271     113.7238     144.2983      50.2237       0.1884       0.2155       0.2657      10.0000    2608.1470       0.2175     283.4375    3440.0000
 2246.2236    1950.0000       0.5831    1950.0000     637.3167      36.6227      27.3055     216.0000       0.1307       0.0595       0.0253      17.7457      43.5629     113.7238     150.4207      50.2237       0.2418       0.2749       0.3250      10.0000    2608.1873       0.2174     278.0000    3431.0000
 2246.3760    1950.0000       0.5812    1950.0000     564.8710      29.3031      34.1260     216.0000       0.1344       0.0635       0.0295      17.7415      42.7782     113.7238     158.6037      50.2237       0.2832       0.3239       0.3706      10.0000    2601.3586       0.2175     278.0000    3414.0000
 2246.5284    1950.0000       0.5789    1950.0000     451.0394      25.2028      39.6782     216.0000       0.1484       0.0786       0.0451      17.7407      47.8266     113.7238     153.7628      50.2237       0.3474       0.3967       0.4386      10.0000    2575.5396       0.2176     277.8125    3453.0000
 2246.6808    1950.0000       0.5765    1950.0000     367.4403      21.7399      45.9983     216.0000       0.1953       0.1294       0.0977      17.7282      45.7627     113.7238     110.0070      50.2237       0.2676       0.3078       0.3540      10.0000    2488.7590       0.2177     278.0000    3426.0000
 2246.8332    1950.0000       0.5745    1950.0000     325.4740      18.9710      52.7120     216.0000       0.2421       0.1801       0.1503      17.6959      45.1002     113.7238      65.5243      50.2237       0.2708       0.3102       0.3573      10.0000    2402.0347       0.2178     279.8125    3427.0000
 2246.9856    1950.0000       0.5730    1950.0000     324.1929      21.9348      45.5897     216.0000       0.2680       0.2081       0.1793      17.6756      36.3907     113.7238      35.8131      50.5033       0.2934       0.3332       0.3810      10.0000    2354.1108       0.2178     278.0000    3454.0000
 2247.1380    1950.0000       0.5719    1950.0000     348.3470      22.7525      43.9511     216.0000       0.2336       0.1709       0.1407      17.6735      38.9187     113.7238      80.3802      50.5033       0.2970       0.3380       0.3850      10.0000    2417.7629       0.2179     284.4375    3413.0000
 2247.2904    1950.0000       0.5712    1950.0000     376.7569      22.8086      43.8431     216.0000       0.1928       0.1267       0.0950      17.6953      35.5133     113.7238     115.9921      50.2237       0.3223       0.3633       0.4112      10.0000    2493.2686       0.2180     278.0000    3392.0000
 2247.4428    1950.0000       0.5703    1950.0000     384.5397      23.6647      42.2570     216.0000       0.1616       0.0930       0.0600      17.7147      38.1575     113.7238     136.8296      50.2237       0.2214       0.2517       0.3024      10.0000    2550.9668       0.2181     279.1250    3419.0000
 2247.5952    1950.0000       0.5689    1950.0000     365.5970      23.1199      43.2528     216.0000       0.1621       0.0935       0.0605      17.7221      34.9084     113.7238     120.9183      50.2237       0.1547       0.1763       0.2267      10.0000    2550.1118       0.2182     278.9375    3412.0000
 2247.7476    1950.0000       0.5665    1950.0000     334.9615      24.4164      40.9561     216.0000       0.1678       0.0997       0.0669      17.7364      32.8584     113.7238     114.1703      50.2237       0.1549       0.1755       0.2265      10.0000    2539.5823       0.2182     278.6250    3448.0000
 2247.9000    1950.0000       0.5630    1950.0000     299.0071      21.6250      46.2429     216.0000       0.1763       0.1088       0.0764      17.6779      29.3821     113.7238     119.2322      50.5033       0.1538       0.1744       0.2253      10.0000    2523.8799       0.2182     278.0000    3424.0000
 2248.0524    1950.0000       0.5589    1950.0000     251.7964      27.6008      36.2308     216.0000       0.1837       0.1169       0.0848      17.6525      28.4751     113.7238     126.1911      50.5033       0.1842       0.2086       0.2602      10.0000    2510.1340       0.2182     280.1875    3423.0000
 2248.2048    1950.0000       0.5550    1950.0000     192.6338      22.8892      43.6888     216.0000       0.1928       0.1267       0.0949      17.6345      31.9264     113.7238     136.1318      50.2237       0.2161       0.2459       0.2966      10.0000    2493.3347       0.2180     277.3125    3456.0000
 2248.3572    1950.0000       0.5527    1950.0000     140.9372      20.9290      47.7807     216.0000       0.1995       0.1340       0.1025      17.6295      35.6061     113.7238     142.2701      50.2237       0.2525       0.2870       0.3368      10.0000    2480.8699       0.2180     279.8750    3448.0000
 2248.5096    1950.0000       0.5528    1950.0000     107.2951      22.3985      44.6458     216.0000       0.2031       0.1378       0.1065      17.6422      38.8339     113.7238     145.0369      50.2237       0.3025       0.3448       0.3911      10.0000    2474.3528       0.2181     281.1875    3464.0000
 2248.6620    1950.0000       0.5555    1950.0000      87.7032      16.2413      61.5714     216.0000       0.2044       0.1392       0.1079      17.6605      42.5174     113.7238     143.1711      50.2237       0.3474       0.3972       0.4388      10.0000    2471.9353       0.2182     278.0000    3463.0000
 2248.8144    1950.0000       0.5600    1950.0000      81.3040      16.0157      62.4386     216.0000       0.2075       0.1426       0.1114      17.6414      42.5826     113.7238     140.3163      50.5033       0.3696       0.4289       0.4631      10.0000    2466.1729       0.2184     278.0000    3448.0000
 2248.9668    1950.0000       0.5648    1950.0000      93.8971      18.8835      52.9562     216.0000       0.2109       0.1463       0.1152      17.6149      42.3714     113.7238     136.9131      50.5033       0.4191       0.4839       0.5135      10.0000    2459.8982       0.2184     279.0000    3432.0000
 2249.1192    1950.0000       0.5679    1950.0000     118.5508      22.3225      44.7979     216.0000       0.2123       0.1478       0.1168      17.5936      41.5301     113.7238     131.3167      50.5033       0.4538       0.5270       0.5488      10.0000    2457.2205       0.2184     280.1875    3444.0000
 2249.2716    1950.0000       0.5677    1950.0000     168.6810      30.5436      32.7401     216.0000       0.2091       0.1443       0.1132      17.5911      43.8756     113.7238     121.8922      50.5033       0.4690       0.5420       0.5640      10.0000    2463.1931       0.2184     283.0000    3392.0000
 2249.4240    1950.0000       0.5640    1950.0000     253.4442      28.3557      35.2663     216.0000       0.2014       0.1360       0.1046      17.5943      43.8547     113.7238     111.7253      50.5033       0.3346       0.3863       0.4260      10.0000    2477.3701       0.2184     278.0000    3411.0000
 2249.5764    1950.0000       0.5580    1950.0000     326.8553      24.7609      40.3862     216.0000       0.1965       0.1307       0.0991      17.5996      44.2893     113.7238     105.8402      50.5033       0.2387       0.2752       0.3225      10.0000    2486.5381       0.2185     282.6875    3404.0000
 2249.7288    1950.0000       0.5524    1950.0000     291.7208      15.2717      65.4807     216.0000       0.1958       0.1299       0.0983      17.5916      46.3533     113.7238     105.1064      50.5033       0.2204       0.2520       0.3017      10.0000    2487.8562       0.2185     278.0000    3394.0000
 2249.8812    1950.0000       0.5494    1950.0000     199.2392      18.5650      53.8647     216.0000       0.2017       0.1363       0.1049      17.5699      48.6115     113.7238     107.1472      50.5033       0.2560       0.2927       0.3410      10.0000    2476.8457       0.2185     283.3750    3424.0000
 2250.0336    1950.0000       0.5500    1950.0000     129.1615      19.3947      51.5604     216.0000       0.2044       0.1393       0.1080      17.5168      47.9739     113.7238     105.5810      50.5033       0.3142       0.3567       0.4032      10.0000    2471.8550       0.2185     278.0000    3414.0000
 2250.1860    1950.0000       0.5539    1950.0000      88.6938      18.8355      53.0911     216.0000       0.2023       0.1370       0.1056      17.5028      46.8498     113.7238      98.3429      50.5033       0.3326       0.3796       0.4231      10.0000    2475.7229       0.2185     287.7500    3447.0000
 2250.3384    1950.0000       0.5596    1950.0000      67.9792      19.3274      51.7400     216.0000       0.1969       0.1312       0.0996      17.5020      46.0092     113.7238      88.4111      50.5033       0.3119       0.3580       0.4016      10.0000    2485.7141       0.2184     285.1875    3426.0000
 2250.4908    1484.5767       0.5650    1950.0000      57.8618      16.4766      60.6923     216.0000       0.1908       0.1245       0.0927      17.4764      44.9941     113.7238      83.1394      50.5033       0.3035       0.3503       0.3930      10.0000    2497.1013       0.2185     286.8750    3426.0000
 2250.6432     529.5958       0.5685    1950.0000      56.1285      15.7295      63.5747     216.0000       0.1928       0.1267       0.0950      17.4814      43.3333     113.7238      85.7136      50.5033       0.2811       0.3236       0.3688      10.0000    2493.3159       0.2185     279.3125    3444.0000
 2250.7956     261.9590       0.5692     836.0970      58.9208      17.2082      58.1119     216.0000       0.1961       0.1303       0.0987      17.4783      46.8180     113.7238      89.2303      50.5033       0.2827       0.3244       0.3702      10.0000    2487.1902       0.2186     284.5625    3433.0000
 2250.9480     140.0895       0.5672     278.1115      52.8613      17.7372      56.3786     216.0000       0.2010       0.1355       0.1041      17.4592      49.0809     113.7238      93.6439      50.5033       0.3137       0.3557       0.4025      10.0000    2478.2351       0.2186     284.1875    3428.0000
 2251.1004      74.2176       0.5615     108.6686      34.1534      12.7764      78.2691     216.0000       0.1972       0.1315       0.0999      17.4600      51.0199     113.7238      98.2034      50.5033       0.2694       0.3080       0.3556      10.0000    2485.1038       0.2186     282.1250    3436.0000
 2251.2528      42.1867       0.5630      37.4674      16.7612       9.8227     101.8049     216.0000       0.1909       0.1246       0.0928      17.4590      51.2621     113.7238     106.1075      50.5033       0.2474       0.2836       0.3318      10.0000    2496.8638       0.2185     285.1875    3409.0000
 2251.4052      18.9075       0.5640      16.8309      15.8746       8.4026     119.0109     216.0000       0.1814       0.1143       0.0821      17.4569      50.6234     113.7238     114.2268      50.5033       0.2949       0.3367       0.3830      10.0000    2514.4849       0.2184     285.7500    3423.0000
 2251.5576       7.9237       0.5497      13.0455       9.9355       7.6213     131.2111     216.0000       0.1629       0.0943       0.0614      17.4198      48.9992     113.7238     122.2010      50.5033       0.2999       0.3419       0.3883      10.0000    2548.6780       0.2183     280.0625    3445.0000
 2251.7100       3.3603       0.5921      18.9749      10.7499       8.6783     115.2300     216.0000       0.1275       0.0560       0.0217      17.4161      44.0868     113.7238     132.0667      50.5033       0.2862       0.3267       0.3737      10.0000    2614.1917       0.2182     278.0000    3459.0000
 2251.8624       2.8857       0.5591       6.5183       5.4797       4.8657     205.5221     216.0000       0.0820       0.0069      -0.0292      17.3649      42.6915     113.7238     147.9652      50.5033       0.2115       0.2425       0.2919      10.0000    2698.2209       0.2189     273.5625    3460.0000
 2252.0148       2.9566       0.5509       4.0025       2.8069       2.6735     374.0418     216.0000       0.0488      -0.0291      -0.0665      17.3506      38.8563     113.7238     159.0939      50.5033       0.2327       0.2648       0.3150      10.0000    2759.7639       0.2186     261.4375    3432.0000
 2252.1672       2.3005       0.6139      13.0648       8.1198       7.2791     137.3801     216.0000       0.0448      -0.0334      -0.0710      17.3681      35.8393     113.7238     163.8710      50.5033       0.2465       0.2785       0.3297      10.0000    2767.1533       0.2184     258.5000    3445.0000
 2252.3196       2.4948       0.6432      24.9877      15.3818       9.5838     104.3427     216.0000       0.0637      -0.0130      -0.0498      17.3915      31.7531     113.7238     164.5513      50.5033       0.2061       0.2331       0.2849      10.0000    2732.1919       0.2174     258.3125    3451.0000
 2252.4720       2.7661       0.6622      50.0972      26.5126      13.4110      74.5658     216.0000       0.0802       0.0049      -0.0313      17.4008      30.6547     113.7238     163.4054      50.5033       0.1546       0.1751       0.2261      10.0000    2701.6865       0.2174     258.5000    3460.0000
 2252.6244       3.2465       0.6752      71.0616      14.2384       7.8206     127.8672     216.0000       0.0874       0.0127      -0.0232      17.3705      29.7819     113.7238     169.8163      50.5033       0.1274       0.1441       0.1940      10.0000    2688.2427       0.2175     267.6875    3454.0000
 2252.7768       4.1063       0.6791     113.0895      39.1259      11.1567      89.6320     216.0000       0.0851       0.0102      -0.0258      17.3462      29.7819     113.7238     175.1773      50.5033       0.1227       0.1387       0.1883      10.0000    2692.6326       0.2177     268.6250    3443.0000
 2252.9292       5.4723       0.6754     288.7647      50.7802      14.2460      70.1951     216.0000       0.0984       0.0246      -0.0108      17.3011      28.8307     113.7238     161.1640      50.5033       0.1207       0.1366       0.1860      10.0000    2667.8826       0.2178     274.5625    3416.0000
 2253.0816       7.5953       0.6639     880.0336      85.2618      23.9288      41.7906     216.0000       0.0989       0.0251      -0.0104      17.3073      31.0856     113.7238     160.6286      50.5033       0.1165       0.1319       0.1809      10.0000    2667.1147       0.2178     272.2500    3407.0000
 2253.2340      11.1953       0.6446    1840.4463     141.5139      36.8707      27.1218     216.0000       0.0961       0.0221      -0.0134      17.2930      30.6970     113.7238     161.9825      50.5033       0.1141       0.1292       0.1781      10.0000    2672.1616       0.2178     278.0000    3400.0000
 2253.3864      18.1631       0.6180    1950.0000     279.6118      43.1700      23.1642     216.0000       0.0807       0.0054      -0.0307      17.3003      31.3933     113.7238     179.6017      50.5033       0.1220       0.1380       0.1875      10.0000    2700.7112       0.2178     277.6875    3412.0000
 2253.5388      32.7872       0.5869    1950.0000     580.9225      31.8186      31.4281     216.0000       0.0824       0.0073      -0.0288      17.2932      33.4272     113.7238     176.2602      50.5033       0.1135       0.1284       0.1775      10.0000    2697.5234       0.2177     278.0000    3438.0000
 2253.6912      65.5512       0.5554    1950.0000    1107.7449      20.0319      49.9204     216.0000       0.0953       0.0212      -0.0144      17.2844      38.6881     113.7238     168.0601      50.5033       0.1550       0.1750       0.2263      10.0000    2673.7715       0.2178     274.1250    3428.0000
 2253.8436     148.2693       0.5283    1950.0000    1753.9794      16.4706      60.7143     216.0000       0.1101       0.0373       0.0023      17.2632      40.5448     113.7238     158.1035      50.5033       0.1813       0.2049       0.2567      10.0000    2646.2456       0.2179     278.0000    3444.0000
 2253.9960     385.3500       0.5085    1950.0000    1438.5212      21.8709      45.7228     216.0000       0.1227       0.0509       0.0164      17.2466      40.9253     113.7238     148.6814      50.5033       0.1702       0.1928       0.2442      10.0000    2622.9604       0.2180     277.5000    3446.0000
 2254.1484    1012.6301       0.4975    1950.0000     923.9011      27.5020      36.3610     216.0000       0.1287       0.0574       0.0231      17.2354      39.5289     113.7238     136.3680      50.5033       0.2058       0.2320       0.2842      10.0000    2611.8821       0.2180     278.0000    3416.0000
 2254.3008    1869.0353       0.4948    1950.0000     525.2718      26.3970      37.8831     216.0000       0.1355       0.0647       0.0307      17.2291      40.9214     113.7238     133.5514      50.5033       0.1794       0.2031       0.2547      10.0000    2599.3057       0.2180     278.0000    3423.0000
 2254.4532    1950.0000       0.4991    1950.0000     296.2634      24.5330      40.7614     216.0000       0.1415       0.0712       0.0374      17.2431      37.8967     113.7238     128.5503      50.5033       0.1963       0.2225       0.2740      10.0000    2588.2378       0.2181     278.0000    3421.0000
 2254.6056    1950.0000       0.5085    1950.0000     179.4533      26.9285      37.1354     216.0000       0.1475       0.0777       0.0442      17.2447      40.7442     113.7238     119.9288      50.5033       0.1942       0.2203       0.2717      10.0000    2577.0996       0.2181     278.0000    3428.0000
 2254.7580    1950.0000       0.5208    1950.0000     121.1257      27.1899      36.7783     216.0000       0.1544       0.0852       0.0519      17.2107      36.3347     114.2820     110.5008      50.5033       0.2048       0.2319       0.2835      10.0000    2564.3638       0.2182     278.0000    3442.0000
 2254.9104    1950.0000       0.5339    1950.0000      91.6975      24.0540      41.5731     216.0000       0.1627       0.0941       0.0612      17.1975      38.1413     113.7238     106.3559      50.5033       0.2160       0.2451       0.2962      10.0000    2549.0703       0.2183     278.0000    3407.0000
 2255.0628    1950.0000       0.5464    1950.0000      78.4509      22.7008      44.0513     216.0000       0.1738       0.1061       0.0736      17.1745      36.0811     113.7238     110.7485      50.5033       0.2380       0.2721       0.3212      10.0000    2528.5305       0.2184     278.0000    3436.0000
 2255.2152    1950.0000       0.5575    1950.0000      74.5970      21.2868      46.9774     216.0000       0.1830       0.1162       0.0840      17.1407      40.0187     114.2820     113.9724      50.5033       0.2971       0.3400       0.3856      10.0000    2511.3733       0.2184     278.0000    3439.0000
 2255.3676    1950.0000       0.5673    1950.0000      76.0987      23.4576      42.6301     216.0000       0.1869       0.1203       0.0883      17.1295      39.9931     113.7238     109.8528      50.5033       0.3348       0.3828       0.4255      10.0000    2504.2612       0.2184     275.3750    3413.0000
 2255.5200    1950.0000       0.5758    1950.0000      85.0796      23.9141      41.8163     216.0000       0.1866       0.1200       0.0880      17.1446      39.6125     113.7238     100.2016      50.5033       0.2800       0.3203       0.3671      10.0000    2504.8066       0.2185     279.8125    3421.0000
 2255.6724    1950.0000       0.5826    1950.0000      97.2676      24.7338      40.4305     216.0000       0.1859       0.1192       0.0872      17.1503      41.7091     113.7238      89.8218      50.5033       0.2907       0.3321       0.3786      10.0000    2506.1682       0.2186     278.0000    3464.0000
 2255.8248    1950.0000       0.5867    1950.0000     112.2682      23.8654      41.9016     216.0000       0.1871       0.1206       0.0886      17.1561      44.1993     113.7238      84.3048      50.5033       0.2552       0.2908       0.3399      10.0000    2503.8298       0.2187     283.0000    3437.0000
 2255.9772    1950.0000       0.5875    1950.0000     129.4211      26.0792      38.3448     216.0000       0.1876       0.1211       0.0892      17.1335      50.4674     113.7238      79.9563      50.5033       0.2478       0.2830       0.3320      10.0000    2502.8882       0.2187     278.0000    3459.0000
 2256.1296    1950.0000       0.5854    1950.0000     147.0178      22.9090      43.6510     216.0000       0.1889       0.1224       0.0905      17.0896      54.4366     113.7238      77.3401      50.5033       0.2174       0.2483       0.2982      10.0000    2500.6179       0.2188     278.1250    3452.0000
 2256.2820    1950.0000       0.5815    1950.0000     159.2950      30.5383      32.7457     216.0000       0.1933       0.1273       0.0955      17.0472      54.7312     113.7238      77.1334      50.5033       0.2016       0.2312       0.2808      10.0000    2492.3589       0.2188     278.0000    3422.0000
 2256.4344    1950.0000       0.5778    1950.0000     155.2319      27.5117      36.3482     216.0000       0.2022       0.1369       0.1055      17.0327      50.0904     113.7238      80.4248      50.5033       0.2560       0.2907       0.3405      10.0000    2475.9707       0.2188     276.1250    3418.0000
 2256.5868    1950.0000       0.5762    1950.0000     138.8988      28.9808      34.5056     216.0000       0.2105       0.1459       0.1148      17.0479      47.2816     113.7238      83.4713      50.5033       0.3047       0.3463       0.3932      10.0000    2460.5295       0.2188     279.8750    3424.0000
 2256.7392    1950.0000       0.5779    1950.0000     123.2611      22.8777      43.7108     216.0000       0.2181       0.1540       0.1233      17.0640      47.5971     113.7238      87.5444      50.5033       0.3265       0.3743       0.4170      10.0000    2446.5879       0.2188     277.1875    3437.0000
 2256.8916    1950.0000       0.5828    1950.0000     114.0945      17.0613      58.6121     216.0000       0.2190       0.1551       0.1244      17.0967      44.7496     113.7238      90.7223      50.5033       0.3636       0.4182       0.4561      10.0000    2444.8140       0.2188     278.0000    3439.0000
 2257.0440    1950.0000       0.5894    1950.0000     124.2235      25.9909      38.4750     216.0000       0.2079       0.1431       0.1119      17.0862      43.8212     113.7238      89.9415      50.5033       0.3705       0.4211       0.4623      10.0000    2465.3289       0.2188     273.1250    3424.0000
 2257.1964    1950.0000       0.5952    1950.0000     144.5451      30.6511      32.6253     216.0000       0.1920       0.1258       0.0940      17.0801      43.3856     113.7238      87.7354      50.5033       0.2590       0.2947       0.3439      10.0000    2494.8396       0.2188     278.0000    3448.0000
 2257.3488    1950.0000       0.5981    1950.0000     176.2234      31.1647      32.0876     216.0000       0.1822       0.1153       0.0831      17.0745      42.9563     113.7238      87.3954      50.5033       0.1922       0.2186       0.2696      10.0000    2512.9011       0.2188     268.2500    3429.0000
 2257.5012    1950.0000       0.5974    1950.0000     204.8385      26.0525      38.3840     216.0000       0.1811       0.1141       0.0819      17.0771      41.5942     113.7238      89.4341      50.5033       0.1852       0.2106       0.2616      10.0000    2514.9426       0.2188     276.8750    3423.0000
 2257.6536    1950.0000       0.5938    1950.0000     212.1006      25.4518      39.2899     216.0000       0.1792       0.1120       0.0797      17.0596      39.3610     114.0029      88.8805      50.5033       0.1945       0.2202       0.2719      10.0000    2518.5173       0.2187     274.0625    3432.0000
 2257.8060    1950.0000       0.5890    1950.0000     201.8439      23.8968      41.8466     216.0000       0.1730       0.1053       0.0728      17.0419      41.4174     113.7238      84.5187      50.5033       0.1841       0.2089       0.2602      10.0000    2529.9573       0.2186     278.0000    3423.0000
 2257.9584    1950.0000       0.5847    1950.0000     192.1073      24.8430      40.2528     216.0000       0.1678       0.0997       0.0669      17.0288      38.3700     113.7238      80.3645      50.5033       0.1943       0.2199       0.2716      10.0000    2539.5762       0.2186     274.1875    3431.0000
 2258.1108    1950.0000       0.5814    1950.0000     194.5148      26.1318      38.2676     216.0000       0.1691       0.1011       0.0684      16.9946      37.9880     113.7238      83.5471      50.5033       0.1761       0.1997       0.2510      10.0000    2537.1130       0.2186     270.3125    3442.0000
 2258.2632    1950.0000       0.5790    1950.0000     215.0454      28.1006      35.5864     216.0000       0.1682       0.1001       0.0674      16.9670      38.3678     113.7238      84.6009      50.5033       0.1929       0.2185       0.2701      10.0000    2538.8438       0.2186     272.3125    3409.0000
 2258.4156    1950.0000       0.5769    1950.0000     256.1155      27.7478      36.0389     216.0000       0.1657       0.0974       0.0646      16.9548      41.6477     113.7238      91.8381      50.5033       0.2045       0.2313       0.2831      10.0000    2543.4084       0.2186     271.3750    3427.0000
 2258.5680    1950.0000       0.5748    1950.0000     323.7042      26.9440      37.1141     216.0000       0.1594       0.0905       0.0575      16.9594      43.4236     113.7238      92.2968      50.5033       0.2085       0.2367       0.2878      10.0000    2555.1753       0.2185     271.1250    3415.0000
 2258.7204    1950.0000       0.5727    1950.0000     419.5273      27.8112      35.9567     216.0000       0.1560       0.0869       0.0537      16.9811      42.6370     113.7238      93.3495      50.5033       0.2030       0.2296       0.2814      10.0000    2561.4167       0.2185     267.9375    3419.0000
 2258.8728    1950.0000       0.5709    1950.0000     525.4594      29.2688      34.1661     216.0000       0.1545       0.0853       0.0520      16.9805      38.4288     113.7238      92.6201      50.5033       0.1679       0.1904       0.2416      10.0000    2564.1899       0.2185     278.0000    3437.0000
 2259.0252    1950.0000       0.5696    1950.0000     603.9654      28.2061      35.4533     216.0000       0.1556       0.0865       0.0533      16.9793      37.2630     113.7238      95.7525      50.5033       0.1845       0.2088       0.2605      10.0000    2562.0688       0.2184     266.8125    3430.0000
 2259.1776    1950.0000       0.5691    1950.0000     621.6337      28.4634      35.1328     216.0000       0.1597       0.0909       0.0579      16.9687      37.2630     113.7238     104.1856      50.5033       0.1860       0.2113       0.2625      10.0000    2554.4783       0.2183     274.9375    3418.0000
 2259.3300    1950.0000       0.5694    1950.0000     585.5767      26.1372      38.2597     216.0000       0.1615       0.0929       0.0599      16.9610      41.4405     114.0029     109.5636      50.5033       0.2281       0.2585       0.3096      10.0000    2551.2192       0.2182     270.6250    3457.0000
 2259.4824    1950.0000       0.5704    1950.0000     513.0655      30.2715      33.0343     216.0000       0.1584       0.0895       0.0564      16.9443      42.8365     114.2820     108.8538      50.5033       0.2116       0.2391       0.2910      10.0000    2556.8975       0.2182     274.1250    3459.0000
 2259.6348    1950.0000       0.5719    1950.0000     413.4687      30.1083      33.2134     216.0000       0.1543       0.0851       0.0518      16.9357      42.9310     114.2820     106.1664      50.5033       0.1913       0.2165       0.2682      10.0000    2564.4893       0.2182     271.1250    3483.0000
 2259.7872    1950.0000       0.5735    1950.0000     320.6363      31.8663      31.3811     216.0000       0.1538       0.0845       0.0513      16.9022      41.5350     114.2820     102.9308      50.5033       0.1881       0.2130       0.2647      10.0000    2565.4209       0.2184     271.5625    3492.0000
 2259.9396    1950.0000       0.5749    1950.0000     255.5280      30.7979      32.4697     216.0000       0.1543       0.0850       0.0518      16.9024      40.7230     114.2820      99.6161      50.5033       0.1879       0.2132       0.2646      10.0000    2564.6045       0.2185     276.2500    3456.0000
 2260.0920    1950.0000       0.5758    1950.0000     221.7190      23.1091      43.2729     216.0000       0.1557       0.0865       0.0533      16.9121      40.6937     114.8402      97.6567      50.5033       0.1810       0.2065       0.2571      10.0000    2562.0049       0.2185     278.0000    3456.0000
 2260.2444    1950.0000       0.5760    1950.0000     215.0475      22.7513      43.9535     216.0000       0.1588       0.0899       0.0568      16.9096      42.9554     113.1656     100.5003      50.5033       0.2482       0.2807       0.3316      10.0000    2556.2224       0.2184     275.5000    3440.0000
 2260.3968    1950.0000       0.5756    1950.0000     230.6813      27.4673      36.4070     216.0000       0.1618       0.0932       0.0602      16.9119      45.8291     112.6074     106.9710      50.5033       0.2534       0.2878       0.3377      10.0000    2550.6265       0.2182     269.3750    3436.0000
 2260.5492    1950.0000       0.5747    1950.0000     257.7468      33.0877      30.2227     216.0000       0.1588       0.0900       0.0569      16.9022      43.9725     112.6074     110.1310      50.5033       0.2447       0.2772       0.3279      10.0000    2556.1653       0.2180     278.0000    3444.0000
 2260.7016    1950.0000       0.5737    1950.0000     283.0885      30.7714      32.4978     216.0000       0.1522       0.0828       0.0494      16.8703      41.9385     112.6074     107.7847      50.5033       0.2110       0.2399       0.2908      10.0000    2568.4656       0.2180     274.0000    3460.0000
 2260.8540    1950.0000       0.5733    1950.0000     300.4034      22.6047      44.2385     216.0000       0.1470       0.0772       0.0436      16.8364      37.6437     112.6074     105.5617      50.5033       0.1942       0.2210       0.2719      10.0000    2578.0293       0.2181     278.0000    3471.0000
 2261.0064    1950.0000       0.5738    1950.0000     317.0352      17.7117      56.4598     216.0000       0.1500       0.0804       0.0470      16.8185      43.4456     112.0492     111.9766      50.5033       0.2096       0.2379       0.2891      10.0000    2572.4851       0.2182     275.7500    3455.0000
 2261.1588    1950.0000       0.5754    1950.0000     365.0548      23.9170      41.8112     216.0000       0.1510       0.0815       0.0481      16.8005      43.4209     112.6074     121.6025      50.5033       0.2085       0.2362       0.2877      10.0000    2570.6777       0.2182     278.0000    3442.0000
 2261.3112    1950.0000       0.5774    1950.0000     460.6923      35.2894      28.3371     216.0000       0.1485       0.0788       0.0453      16.8087      44.3234     112.6074     129.1077      50.5033       0.1902       0.2152       0.2669      10.0000    2575.1863       0.2182     277.3125    3446.0000
 2261.4636    1950.0000       0.5793    1950.0000     634.3422      42.3386      23.6191     216.0000       0.1417       0.0715       0.0377      16.8106      41.5055     112.0492     130.2531      50.5033       0.1828       0.2069       0.2586      10.0000    2587.7974       0.2181     278.1250    3435.0000
 2261.6160    1950.0000       0.5801    1950.0000     915.0952      33.6527      29.7153     216.0000       0.1371       0.0665       0.0325      16.8011      40.7166     112.6074     126.7247      50.5033       0.1751       0.1986       0.2499      10.0000    2596.3521       0.2181     276.3125    3444.0000
 2261.7684    1950.0000       0.5795    1950.0000    1270.8519      30.1050      33.2171     216.0000       0.1358       0.0650       0.0310      16.8087      40.6262     112.3283     126.4339      50.5033       0.1849       0.2107       0.2614      10.0000    2598.7729       0.2180     275.5625    3464.0000
 2261.9208    1950.0000       0.5777    1950.0000    1433.5104      31.3098      31.9389     216.0000       0.1369       0.0662       0.0323      16.7771      43.0167     112.6074     131.0792      50.5033       0.2433       0.2753       0.3263      10.0000    2596.7371       0.2180     272.4375    3446.0000
 2262.0732    1950.0000       0.5750    1950.0000    1159.3745      24.8683      40.2118     216.0000       0.1371       0.0664       0.0325      16.7719      44.0086     113.1656     139.8642      50.5033       0.2639       0.2987       0.3488      10.0000    2596.4072       0.2180     274.0625    3448.0000
 2262.2256    1950.0000       0.5720    1950.0000     717.1945      28.1267      35.5534     216.0000       0.1361       0.0653       0.0313      16.7664      48.0156     113.1656     146.2612      50.5033       0.2374       0.2688       0.3198      10.0000    2598.2810       0.2180     275.2500    3464.0000
 2262.3780    1950.0000       0.5693    1950.0000     401.8428      34.0459      29.3721     216.0000       0.1266       0.0551       0.0207      16.7325      43.7979     113.7238     143.8553      50.5033       0.2131       0.2417       0.2930      10.0000    2615.7664       0.2177     268.2500    3443.0000
 2262.5304    1950.0000       0.5672    1950.0000     233.1732      26.3185      37.9960     216.0000       0.1120       0.0394       0.0044      16.7291      44.4332     114.2820     138.6678      50.5033       0.1779       0.2020       0.2532      10.0000    2642.7097       0.2173     271.1250    3470.0000
 2262.6828    1950.0000       0.5659    1950.0000     149.0359      23.5086      42.5376     216.0000       0.0801       0.0048      -0.0314      16.7368      42.6887     113.7238     130.0423      50.5033       0.1716       0.1950       0.2460      10.0000    2701.7336       0.2170     270.0625    3477.0000
 2262.8352    1950.0000       0.5655    1950.0000     107.8221      18.1540      55.0842     216.0000       0.0421      -0.0364      -0.0741      16.7611      45.9413     115.3984     129.3974      50.5033       0.1995       0.2261       0.2776      10.0000    2772.2036       0.2170     273.7500    3471.0000
 2262.9876    1950.0000       0.5661    1950.0000      86.3965      16.2995      61.3516     216.0000      -0.0038      -0.0859      -0.1254      16.7379      47.1616     118.1894     144.3329      50.5033       0.2395       0.2696       0.3217      10.0000    2856.9407       0.2171     268.3125    3484.0000
 2263.1400    1950.0000       0.5678    1950.0000      75.1159      14.3211      69.8272     216.0000      -0.0400      -0.1252      -0.1661      16.7329      40.4328     124.3296     150.8112      50.5033       0.1840       0.2077       0.2597      10.0000    2924.0540       0.2173     272.7500    3467.0000
 2263.2924    1950.0000       0.5704    1950.0000      83.5966      13.6116      73.4667     216.0000      -0.1595      -0.2545      -0.3001      16.6930      35.5592     127.6788     281.1945      50.5033       0.1166       0.1319       0.1812      10.0000    3145.1267       0.2040     273.5000    3450.0000
 2263.4448    1950.0000       0.5733    1950.0000      91.6171      15.0131      66.6087     216.0000      -0.3725      -0.4848      -0.5388      16.6947      31.0643     132.7026     583.4923      50.5033       0.0975       0.1104       0.1582      10.0000    3539.0334       0.1273     268.1250    3455.0000
 2263.5972    1950.0000       0.5754    1950.0000      96.0480      14.1140      70.8517     216.0000      -0.6625      -0.7986      -0.8640      16.7008      32.3014     137.1682    1054.9291      50.5033       0.1222       0.1383       0.1878      10.0000    4075.5334       0.0867     269.5000    3436.0000
 2263.7496    1950.0000       0.5755    1950.0000     104.2618      10.9454      91.3627     216.0000      -0.8626      -1.0151      -1.0884      16.7021      36.4789     141.0756    1407.2201      50.5033       0.1427       0.1613       0.2120      10.0000    4445.8564       0.0678     268.2500    3454.0000
 2263.9020    1950.0000       0.5726    1950.0000     117.6339      13.6757      73.1223     216.0000      -0.9556      -1.1157      -1.1926      16.7150      39.7533     143.8666    1583.1292      50.5033       0.1683       0.1900       0.2417      10.0000    4617.7734       0.0674     268.6250    3453.0000
 2264.0544    1950.0000       0.5661    1894.4015     128.6192      20.4245      48.9608     216.0000      -0.9615      -1.1221      -1.1993      16.6784      45.8248     147.2159    1611.5575      50.5033       0.1755       0.1984       0.2501      10.0000    4628.7998       0.0703     264.6875    3455.0000
 2264.2068    1950.0000       0.5568    1801.7458     129.3652      29.1295      34.3295     216.0000      -0.9615      -1.1221      -1.1993      16.6677      43.6745     152.2397    1637.9395      50.5033       0.1737       0.1963       0.2481      10.0000    4628.7998       0.0678     268.0000    3464.0000
 2264.3592    1950.0000       0.5464    1692.3519     114.3273      21.2194      47.1268     216.0000      -0.9615      -1.1221      -1.1993      16.6227      44.7577     156.1471    1642.4923      50.5033       0.1722       0.1944       0.2461      10.0000    4628.7998       0.0666     265.0000    3442.0000
 2264.5116    1950.0000       0.5373    1598.2745      96.3528      10.5385      94.8898     216.0000      -0.9615      -1.1221      -1.1993      16.5792      38.4642     160.0545    1640.1350      50.5033       0.1413       0.1597       0.2103      10.0000    4628.7998       0.0688     266.4375    3440.0000
 2264.6640    1950.0000       0.5315    1548.6687      70.5033      10.9352      91.4475     216.0000      -0.9615      -1.1221      -1.1993      16.5599      37.1333     163.9619    1638.5908      50.5033       0.1128       0.1276       0.1767      10.0000    4628.7998       0.0708     265.5625    3446.0000
 2264.8164    1950.0000       0.5300     997.5508      64.7938      17.5313      57.0410     216.0000      -0.9615      -1.1221      -1.1993      16.5609      34.2196     167.5902    1635.2274      50.5033       0.1330       0.1503       0.2005      10.0000    4628.7998       0.0656     268.2500    3431.0000
 2264.9688    1950.0000       0.5320     422.1950      56.1928      17.4106      57.4364     216.0000      -0.9615      -1.1221      -1.1993      16.5755      40.1367     171.7767    1647.9552      50.5033       0.1409       0.1592       0.2099      10.0000    4628.7998       0.0617     267.9375    3454.0000
 2265.1212    1950.0000       0.5361     184.9133      45.4107      16.4231      60.8899     216.0000      -0.9615      -1.1221      -1.1993      16.6064      39.6725     176.2423    1618.2518      50.5033       0.1550       0.1754       0.2265      10.0000    4628.7998       0.0595     267.5000    3446.0000
 2265.2736    1950.0000       0.5404      89.5633      31.0051      12.8683      77.7103     216.0000      -0.9615      -1.1221      -1.1993      16.6093      43.7404     180.1497    1616.8463      50.5033       0.1868       0.2110       0.2630      10.0000    4628.7998       0.0656     268.2500    3428.0000
 2265.4260    1950.0000       0.5429      40.3876      20.0504      10.9490      91.3325     216.0000      -0.9615      -1.1221      -1.1993      16.6156      44.3198     184.0571    1608.6943      50.5033       0.1934       0.2184       0.2704      10.0000    4628.7998       0.0664     268.1875    3454.0000
 2265.5784    1950.0000       0.5417      25.6509      15.5125       9.6571     103.5504     216.0000      -0.9615      -1.1221      -1.1993      16.6166      48.7293     188.5227    1623.6237      50.5033       0.1805       0.2044       0.2559      10.0000    4628.7998       0.0702     268.2500    3439.0000
 2265.7308    1950.0000       0.5385      20.8306      15.0055       8.9790     111.3706     216.0000      -0.9615      -1.1221      -1.1993      16.6321      45.2476     192.4301    1559.3645      50.5033       0.1893       0.2138       0.2657      10.0000    4628.7998       0.0719     258.6250    3447.0000
 2265.8832    1950.0000       0.5559       8.0970      12.1440       4.6084     216.9953     216.0000      -0.9615      -1.1221      -1.1993      16.6302      38.1596     196.8957    1436.1292      50.5033       0.1547       0.1756       0.2264      10.0000    4628.7998       0.0698     258.8125    3470.0000
 2266.0356    1950.0000       0.5282      12.8297       8.9975       6.7995     147.0690     216.0000      -0.9615      -1.1221      -1.1993      16.6028      32.3159     200.8031    1291.5292      50.5033       0.1665       0.1888       0.2400      10.0000    4628.7998       0.0785     248.7500    3452.0000
 2266.1880    1950.0000       0.5291       7.8587       6.8884       4.9779     200.8867     216.0000      -0.9615      -1.1221      -1.1993      16.5664      29.7374     204.7105    1271.3153      50.5033       0.1806       0.2062       0.2567      10.0000    4628.7998       0.0856     251.8750    3459.0000
 2266.3404    1950.0000       0.5279       7.1094       4.8233       4.1466     241.1641     216.0000      -0.9615      -1.1221      -1.1993      16.5514      32.7883     209.1762    1266.8867      50.5033       0.3032       0.3445       0.3915       9.9148    4628.7998       0.0964     249.1250    3456.0000
 2266.4928    1950.0000       0.5296       9.6562       6.7596       5.4307     184.1367     216.0000      -0.9615      -1.1221      -1.1993      16.5250      32.7504     213.3627    1345.2411      50.5033       0.4102       0.4633       0.5026       9.9148    4628.7998       0.0978     248.7500    3424.0000
 2266.6452    1144.1764       0.5403       7.4882       5.3737       4.4508     224.6772     216.0000      -0.9615      -1.1221      -1.1993      16.5334      33.2374     216.9910    1371.8181      50.5033       0.3090       0.3540       0.3984       9.9148    4628.7998       0.0894     251.0000    3452.0000
 2266.7976     440.9355       0.5437      10.4059       4.6804       3.6257     275.8086     216.0000      -0.9615      -1.1221      -1.1993      16.5402      34.4323     221.4566    1445.9484      50.5033       0.2598       0.2976       0.3453      10.0000    4628.7998       0.0736     248.7500    3461.0000
 2266.9500     184.7749       0.5651      16.0317       8.8859       8.1350     122.9256     216.0000      -0.9615      -1.1221      -1.1993      16.5861      41.0460     223.9685    1513.3972      50.5033       0.2470       0.2813       0.3309      10.0000    4628.7998       0.0588     249.9375    3435.0000
 2267.1024    1644.2365       0.5636      36.9216      18.8566      12.5230      79.8530     216.0000      -0.9615      -1.1220      -1.1992      16.6122      48.2128     225.9222    1579.7217      50.5033       0.2247       0.2559       0.3062      10.0000    4628.6992       0.0623     236.5625    3464.0000
 2267.2548     165.6876       0.5545      59.1800      16.7487       9.4864     105.4138     216.0000      -0.9561      -1.1163      -1.1932      16.5916      50.8824     227.5968    1613.1039      50.5033       0.2035       0.2320       0.2825      10.0000    4618.8311       0.0660     261.4375    3472.0000
 2267.4072      24.2837       0.5422      75.5380      14.5495       8.2067     121.8512     216.0000      -0.9429      -1.1019      -1.1784      16.5829      50.9872     228.9923    1615.3364      50.5033       0.2206       0.2517       0.3018      10.0000    4594.3330       0.0565     251.6250    3456.0000
 2267.5596      13.1596       0.5317     141.9894      36.7133       6.4452     155.1554     216.0000      -0.9272      -1.0850      -1.1608      16.5138      46.6113     229.2714    1590.5581      50.5033       0.2786       0.3148       0.3647      10.0000    4565.2988       0.0531     257.0625    3479.0000
 2267.7120       8.5806       0.5253     318.3398      36.9196      15.4336      64.7939     216.0000      -0.9197      -1.0769      -1.1524      16.4873      48.9060     229.2714    1592.3179      50.5033       0.2476       0.2817       0.3314      10.0000    4551.5259       0.0515     258.5000    3470.0000
 2267.8644       6.2788       0.5242     649.8492      71.7150      13.8697      72.0994     216.0000      -0.9237      -1.0812      -1.1568      16.4804      48.5000     229.2714    1592.6731      50.5033       0.2341       0.2662       0.3165      10.0000    4558.7695       0.0615     263.0000    3459.0000
 2268.0168       4.9201       0.5277     847.0220     149.0303      19.6656      50.8503     216.0000      -0.9305      -1.0886      -1.1645      16.4967      47.5975     229.2714    1613.5762      50.5033       0.2186       0.2488       0.2994      10.0000    4571.4629       0.0625     258.8750    3459.0000
 2268.1692       4.0599       0.5340     877.9963     314.2958      32.9099      30.3860     216.0000      -0.9333      -1.0916      -1.1677      16.5092      40.8281     228.7132    1615.7507      50.5033       0.2270       0.2579       0.3086      10.0000    4576.6436       0.0615     258.5000    3459.0000
 2268.3216       3.5272       0.5415     849.7986     678.4879      24.2009      41.3208     216.0000      -0.9319      -1.0900      -1.1660      16.5144      39.9332     228.9923    1610.9674      50.5033       0.1951       0.2216       0.2728      10.0000    4573.9404       0.0638     258.5000    3483.0000
 2268.4740       3.2509       0.5488     826.8663    1435.7897      31.0519      32.2041     216.0000      -0.9281      -1.0859      -1.1618      16.5203      39.9567     228.7132    1618.0260      50.5033       0.1933       0.2192       0.2707      10.0000    4566.9160       0.0594     254.1250    3451.0000
 2268.6264       3.1943       0.5527     862.8073    1950.0000      36.2551      27.5823     216.0000      -0.9214      -1.0787      -1.1543      16.5236      41.7873     229.2714    1622.5906      50.5033       0.2050       0.2308       0.2833      10.0000    4554.6216       0.0526     262.2500    3451.0000
 2268.7788       3.3204       0.5522     932.2719    1950.0000      38.2563      26.1395     216.0000      -0.9142      -1.0709      -1.1462      16.5070      40.0430     229.2714    1590.1162      50.5033       0.1593       0.1803       0.2316      10.0000    4541.1826       0.0527     261.0000    3492.0000
 2268.9312       3.5425       0.5459     993.9589    1950.0000      49.2895      20.2883     216.0000      -0.9102      -1.0666      -1.1417      16.4563      39.0365     229.8296    1552.4557      50.5033       0.1605       0.1815       0.2329      10.0000    4533.8735       0.0594     261.6875    3464.0000
 2269.0836       3.7090       0.5349     932.5365    1950.0000      59.6554      16.7629     216.0000      -0.9149      -1.0717      -1.1470      16.4656      40.6351     228.7132    1549.8817      50.5033       0.1706       0.1927       0.2444      10.0000    4542.6050       0.0644     250.7500    3471.0000
 2269.2360       3.6927       0.5228     743.2546    1930.8252      36.1705      27.6469     216.0000      -0.9239      -1.0814      -1.1570      16.4763      41.0678     228.9923    1563.1652      50.5033       0.1471       0.1666       0.2174      10.0000    4559.1235       0.0639     263.7500    3475.0000
 2269.3884       3.5230       0.5131     554.9124    1884.1771      39.5408      25.2903     216.0000      -0.9303      -1.0883      -1.1642      16.4557      39.9074     229.2714    1563.8976      50.5033       0.1502       0.1697       0.2208      10.0000    4570.9810       0.0631     258.5000    3451.0000
 2269.5408       3.3227       0.5079     434.4404    1838.0955      29.9141      33.4291     216.0000      -0.9295      -1.0875      -1.1634      16.4516      35.4612     229.2714    1557.0266      50.5033       0.1358       0.1536       0.2040      10.0000    4569.6641       0.0630     258.5000    3457.0000
 2269.6932       3.2194       0.5079     377.5029    1809.2240      21.3482      46.8424     216.0000      -0.9265      -1.0843      -1.1601      16.4626      30.7652     229.8296    1563.1346      50.5033       0.1395       0.1577       0.2083      10.0000    4564.1108       0.0615     258.5000    3454.0000
 2269.8456       3.1902       0.5127     376.2679    1809.2253      22.2419      44.9602     216.0000      -0.9298      -1.0878      -1.1638      16.4594      30.7876     229.5505    1600.0139      50.5033       0.1317       0.1489       0.1991      10.0000    4570.1914       0.0586     258.5000    3454.0000
 2269.9980       3.2694       0.5211     433.0532    1838.1047      27.6009      36.2307     216.0000      -0.9367      -1.0953      -1.1715      16.4543      33.4066     229.8296    1628.7222      50.5033       0.1353       0.1530       0.2033      10.0000    4582.9229       0.0591     258.5000    3471.0000
 2270.1504       3.4240       0.5285     558.8843    1884.2139      31.5203      31.7256     216.0000      -0.9385      -1.0972      -1.1734      16.4155      36.1651     229.2714    1661.7079      50.5033       0.1463       0.1653       0.2162      10.0000    4586.1523       0.0628     259.3750    3460.0000
 2270.3028       3.6598       0.5326     785.2267    1930.8583      30.1801      33.1344     216.0000      -0.9308      -1.0889      -1.1648      16.4105      38.6921     229.2714    1662.9095      50.5033       0.1602       0.1812       0.2325      10.0000    4571.9600       0.0649     259.5625    3492.0000
 2270.4552       3.9678       0.5325    1122.4921    1950.0000      33.4881      29.8614     216.0000      -0.9222      -1.0796      -1.1552      16.4302      40.1410     229.2714    1636.2424      50.5033       0.2233       0.2515       0.3037      10.0000    4556.0454       0.0635     261.0000    3490.0000
 2270.6076       4.3446       0.5291    1500.5547    1950.0000      28.1447      35.5307     216.0000      -0.9178      -1.0748      -1.1502      16.3946      45.0147     229.2714    1612.8120      50.5033       0.1890       0.2145       0.2658      10.0000    4547.8833       0.0609     260.1875    3483.0000
 2270.7600       4.8110       0.5247    1789.6377    1950.0000      23.6261      42.3260     216.0000      -0.9139      -1.0706      -1.1459      16.4245      46.6662     229.2714    1593.7322      50.5033       0.1839       0.2092       0.2602      10.0000    4540.7412       0.0569     253.6250    3470.0000
 2270.9124       5.4478       0.5211    1950.0000    1950.0000      21.6747      46.1368     216.0000      -0.9097      -1.0661      -1.1412      16.3680      45.6492     228.7132    1606.4949      50.5033       0.1908       0.2172       0.2681      10.0000    4532.9966       0.0552     261.6875    3461.0000
 2271.0648       6.4231       0.5188    1950.0000    1950.0000      24.1327      41.4375     216.0000      -0.9125      -1.0690      -1.1443      16.3393      43.7015     229.2714    1637.7949      50.5033       0.2551       0.2896       0.3395      10.0000    4538.0435       0.0570     248.7500    3477.0000
 2271.2172       7.9993       0.5177    1950.0000    1950.0000      30.7502      32.5201     216.0000      -0.9285      -1.0864      -1.1623      16.3486      45.0705     229.5505    1668.5656      50.5033       0.3330       0.3761       0.4226      10.0000    4567.7368       0.0607     264.1875    3525.0000
 2271.3696      10.5606       0.5169    1950.0000    1950.0000      31.0904      32.1642     216.0000      -0.9470      -1.1064      -1.1830      16.3459      47.0748     229.2714    1695.9603      50.5033       0.2623       0.2992       0.3477      10.0000    4602.0029       0.0645     258.5000    3519.0000
 2271.5220      14.6267       0.5162    1950.0000    1950.0000      22.0440      45.3638     216.0000      -0.9591      -1.1195      -1.1966      16.3329      48.1290     229.2714    1689.7147      50.5033       0.2419       0.2758       0.3253      10.0000    4624.3203       0.0645     259.0000    3485.0000
 2271.6744      20.8986       0.5157    1872.8888    1950.0000      19.8045      50.4936     216.0000      -0.9615      -1.1221      -1.1993      16.3262      48.5597     229.2714    1666.5511      50.5033       0.2046       0.2323       0.2835      10.0000    4628.7998       0.0646     263.6875    3477.0000
 2271.8268      30.4600       0.5154    1674.0175    1894.2666      21.2563      47.0448     216.0000      -0.9604      -1.1209      -1.1981      16.2989      48.5894     229.2714    1646.8020      50.5033       0.1947       0.2208       0.2722      10.0000    4626.8125       0.0576     258.5000    3462.0000
 2271.9792      45.4738       0.5147    1362.0645    1751.3369      22.6832      44.0855     216.0000      -0.9538      -1.1138      -1.1906      16.3373      45.7696     229.2714    1638.6831      50.5033       0.1772       0.2012       0.2524      10.0000    4614.5176       0.0556     260.3125    3498.0000
 2272.1316      71.5608       0.5134    1028.0729    1535.6187      27.5916      36.2430     216.0000      -0.9434      -1.1025      -1.1789      16.3474      43.1563     229.2714    1641.1271      50.5033       0.2181       0.2468       0.2984      10.0000    4595.2471       0.0561     258.4375    3502.0000
 2272.2840     122.4618       0.5111     768.9865    1299.5126      32.5150      30.7550     216.0000      -0.9316      -1.0898      -1.1658      16.3094      40.0814     229.8296    1638.7770      50.5033       0.1973       0.2244       0.2754      10.0000    4573.4902       0.0579     259.8125    3496.0000
 2272.4364     215.3493       0.5084     610.8701    1108.4126      25.0042      39.9933     216.0000      -0.9247      -1.0822      -1.1580      16.2772      39.8777     229.2714    1620.2788      50.5033       0.2322       0.2633       0.3142      10.0000    4560.6182       0.0617     252.9375    3471.0000
 2272.5888     382.9873       0.5065     536.4191     991.9140      17.0510      58.6475     216.0000      -0.9225      -1.0799      -1.1555      16.2378      42.4603     229.5505    1621.6478      50.5033       0.2297       0.2593       0.3111      10.0000    4556.6509       0.0605     260.3125    3436.0000
 2272.7412     732.2151       0.5065     533.2114     947.1337      15.4419      64.7590     216.0000      -0.9218      -1.0791      -1.1547      16.2365      42.0775     229.2714    1623.5942      50.5033       0.1759       0.1998       0.2510      10.0000    4555.2671       0.0589     253.3125    3443.0000
 2272.8936    1187.2688       0.5086     597.4689     967.7978      22.7401      43.9751     216.0000      -0.9219      -1.0793      -1.1549      16.2265      42.4481     229.2714    1649.0686      50.5033       0.1620       0.1834       0.2347      10.0000    4555.5532       0.0559     265.6875    3439.0000
 2273.0460    1950.0000       0.5116     719.3156     995.0120      32.1715      31.0835     216.0000      -0.9207      -1.0780      -1.1535      16.2111      40.1914     229.2714    1645.9613      50.5033       0.1838       0.2075       0.2595      10.0000    4553.3091       0.0569     260.1875    3438.0000
 2273.1984    1950.0000       0.5145     864.5537     971.3028      32.8142      30.4746     216.0000      -0.9217      -1.0791      -1.1547      16.2014      38.7676     229.8296    1619.3676      50.5033       0.1554       0.1756       0.2269      10.0000    4555.2178       0.0603     261.2500    3496.0000
 2273.3508    1950.0000       0.5164     952.3552     886.6940      24.4832      40.8444     216.0000      -0.9207      -1.0779      -1.1535      16.1922      37.4404     229.2714    1596.1971      50.5033       0.1381       0.1562       0.2067      10.0000    4553.2539       0.0633     258.5000    3495.0000
 2273.5032    1950.0000       0.5174     950.6510     796.6460      22.5930      44.2614     216.0000      -0.9186      -1.0757      -1.1512      16.1714      37.6976     229.2714    1581.5447      50.5033       0.1450       0.1640       0.2148      10.0000    4549.4346       0.0632     260.6250    3503.0000
 2273.6556    1950.0000       0.5181     923.0123     749.9846      18.8142      53.1512     216.0000      -0.9143      -1.0710      -1.1463      16.1745      41.3313     229.2714    1582.3226      50.5033       0.1650       0.1868       0.2381      10.0000    4541.3750       0.0631     258.5000    3516.0000
 2273.8080    1902.2406       0.5194     941.5347     773.5513      17.8619      55.9851     216.0000      -0.9113      -1.0678      -1.1430      16.1716      46.0092     229.8296    1581.8451      50.5033       0.2176       0.2466       0.2979      10.0000    4535.9063       0.0624     258.5000    3544.0000
 2273.9604    1599.2125       0.5218    1029.6448     874.5724      22.4750      44.4938     216.0000      -0.9113      -1.0678      -1.1430      16.1701      43.9791     229.2714    1589.2651      50.5033       0.2418       0.2748       0.3250      10.0000    4535.9072       0.0573     258.5000    3535.0000
 2274.1128    1950.0000       0.5245    1197.1514    1057.2976      23.0470      43.3895     216.0000      -0.9169      -1.0739      -1.1493      16.1701      41.1589     229.2714    1612.2939      50.5033       0.2489       0.2824       0.3327      10.0000    4546.2935       0.0575     258.5000    3575.0000
 2274.2652    1403.3701       0.5265    1423.8832    1308.2834      21.4287      46.6663     216.0000      -0.9286      -1.0865      -1.1624      16.1500      38.8018     229.2714    1634.9530      50.5033       0.2068       0.2339       0.2857      10.0000    4567.9111       0.0604     260.2500    3587.0000
 2274.4176     674.7747       0.5271    1621.9744    1569.9741      22.6522      44.1458     216.0000      -0.9414      -1.1003      -1.1767      16.0871      37.1979     229.2714    1656.2838      50.5033       0.1776       0.2006       0.2524      10.0000    4591.5386       0.0641     255.5625    3559.0000
 2274.5700     320.4072       0.5258    1686.1256    1771.4399      24.9431      40.0912     216.0000      -0.9523      -1.1121      -1.1889      16.0336      35.9577     229.2714    1678.9615      50.5033       0.1372       0.1553       0.2057      10.0000    4611.7246       0.0663     258.5000    3584.0000
 2274.7224     154.9308       0.5235    1561.3209    1892.7207      27.1927      36.7746     216.0000      -0.9581      -1.1184      -1.1954      16.0399      32.2678     229.2714    1686.8162      50.5033       0.1520       0.1717       0.2229      10.0000    4622.4189       0.0644     257.1875    3560.0000
 2274.8748      78.3074       0.5214    1311.2722    1950.0000      26.6231      37.5614     216.0000      -0.9611      -1.1217      -1.1988      16.0035      27.9843     229.2714    1688.1132      50.5033       0.1271       0.1437       0.1936      10.0000    4628.0938       0.0595     258.5000    3572.0000
 2275.0272      43.1118       0.5208    1048.7517    1950.0000      24.9800      40.0320     216.0000      -0.9615      -1.1221      -1.1993      16.0575      26.7662     229.2714    1679.2955      50.5033       0.1194       0.1351       0.1845      10.0000    4628.7998       0.0582     258.9375    3567.0000
 2275.1796      26.4419       0.5225     858.4561    1950.0000      25.3289      39.4805     216.0000      -0.9615      -1.1221      -1.1993      16.0931      28.0389     229.2714    1680.3391      50.5033       0.1246       0.1410       0.1906      10.0000    4628.7998       0.0591     263.6250    3542.0000
 2275.3320      18.5071       0.5267     755.9122    1950.0000      22.2008      45.0435     216.0000      -0.9615      -1.1221      -1.1993      16.0972      33.3784     229.8296    1690.7981      50.5033       0.1254       0.1419       0.1917      10.0000    4628.7998       0.0659     266.8750    3559.0000
 2275.4844      14.9961       0.5325     736.4385    1950.0000      25.2710      39.5711     216.0000      -0.9603      -1.1208      -1.1979      16.0284      36.0401     229.2714    1686.5389      50.5033       0.1595       0.1803       0.2317      10.0000    4626.5972       0.0659     255.5000    3587.0000
 2275.6368      14.1482       0.5383     801.8201    1950.0000      26.6088      37.5815     216.0000      -0.9528      -1.1127      -1.1895      15.9949      37.7611     229.2714    1654.0665      50.5033       0.2126       0.2400       0.2920      10.0000    4612.7012       0.0611     262.1250    3554.0000
 2275.7892      15.3845       0.5415     951.1490    1950.0000      28.1324      35.5462     216.0000      -0.9439      -1.1030      -1.1795      16.0201      38.7150     229.5505    1639.3357      50.5033       0.1695       0.1925       0.2435      10.0000    4596.1309       0.0557     257.2500    3543.0000
 2275.9416      19.2200       0.5407    1187.1080    1950.0000      37.8956      26.3883     216.0000      -0.9428      -1.1018      -1.1783      15.9791      39.9715     229.8296    1653.2008      50.5033       0.2155       0.2431       0.2952      10.0000    4594.1387       0.0552     268.2500    3530.0000
 2276.0940      27.6474       0.5359    1472.7535    1950.0000      39.0141      25.6318     216.0000      -0.9503      -1.1100      -1.1867      15.9754      39.4458     229.8296    1680.6323      50.5033       0.1681       0.1909       0.2420      10.0000    4608.0347       0.0595     258.5000    3541.0000
 2276.2464      45.8609       0.5287    1727.8016    1950.0000      34.4625      29.0170     216.0000      -0.9592      -1.1197      -1.1967      15.9897      39.0398     229.8296    1694.7407      50.5033       0.2088       0.2360       0.2878      10.0000    4624.6050       0.0619     260.7500    3536.0000
 2276.3988      87.4180       0.5211    1889.7050    1950.0000      29.9268      33.4149     216.0000      -0.9599      -1.1203      -1.1974      15.9996      40.0206     229.2714    1718.4183      50.5033       0.1885       0.2145       0.2655      10.0000    4625.7383       0.0646     258.5000    3529.0000
 2276.5512     190.1879       0.5151    1950.0000    1950.0000      26.9832      37.0600     216.0000      -0.9484      -1.1079      -1.1846      15.9890      39.8501     229.2714    1760.2148      50.5033       0.2239       0.2547       0.3052      10.0000    4604.5762       0.0655     262.2500    3566.0000
 2276.7036     461.4553       0.5116    1903.6083    1849.3975      31.3037      31.9451     216.0000      -0.9317      -1.0898      -1.1658      15.9285      41.2971     229.2714    1762.2153      50.5033       0.2991       0.3374       0.3866      10.0000    4573.6045       0.0610     259.8125    3531.0000
 2276.8560    1134.5433       0.5105    1750.7083    1619.2200      32.5591      30.7134     216.0000      -0.9163      -1.0732      -1.1486      15.9523      43.7066     229.8296    1702.6000      50.5033       0.2607       0.2949       0.3453      10.0000    4545.1772       0.0578     264.1250    3566.0000
 2277.0084    1950.0000       0.5110    1497.3396    1274.1018      33.4005      29.9397     216.0000      -0.9102      -1.0666      -1.1418      15.9286      43.0372     229.5505    1626.3492      50.5033       0.1845       0.2093       0.2607      10.0000    4533.9517       0.0594     259.6875    3558.0000
 2277.1608    1950.0000       0.5121    1202.4697     926.9830      38.4154      26.0312     216.0000      -0.9068      -1.0629      -1.1379      15.8296      40.9812     229.2714    1574.0321      50.5033       0.1562       0.1769       0.2280      10.0000    4527.5342       0.0643     259.2500    3541.0000
 2277.3132    1950.0000       0.5130     952.6854     670.1441      35.7556      27.9677     216.0000      -0.9007      -1.0563      -1.1310      15.8444      34.2817     229.8296    1565.5966      50.5033       0.1327       0.1502       0.2004      10.0000    4516.2319       0.0672     258.6875    3560.0000
 2277.4656    1950.0000       0.5135     785.8748     507.2373      28.9581      34.5326     216.0000      -0.8896      -1.0443      -1.1187      15.8293      32.3982     229.2714    1564.4784      50.5033       0.1551       0.1757       0.2267      10.0000    4495.8257       0.0663     258.5000    3551.0000
 2277.6180    1950.0000       0.5143     694.4894     411.9073      20.3160      49.2223     216.0000      -0.8760      -1.0296      -1.1034      15.8650      32.8271     229.5505    1570.3728      50.5033       0.1707       0.1929       0.2445      10.0000    4470.5527       0.0639     263.6250    3547.0000
 2277.7704    1950.0000       0.5162     669.6282     350.3696      19.9686      50.0786     216.0000      -0.8614      -1.0138      -1.0870      15.8582      33.4559     229.2714    1564.3428      50.5033       0.2104       0.2374       0.2896      10.0000    4443.6030       0.0628     257.2500    3591.0000
 2277.9228    1950.0000       0.5192     667.4094     290.1649      28.7063      34.8355     216.0000      -0.8501      -1.0016      -1.0744      15.8214      41.3466     229.8296    1579.0465      50.5033       0.1775       0.2016       0.2528      10.0000    4422.7490       0.0641     264.5000    3572.0000
 2278.0752    1950.0000       0.5226     644.9526     219.2262      41.4567      24.1215     216.0000      -0.8442      -0.9952      -1.0677      15.8107      39.2936     229.8296    1600.5442      50.5033       0.2162       0.2452       0.2965      10.0000    4411.7178       0.0667     255.0000    3541.0000
 2278.2276    1950.0000       0.5260     584.5135     156.1021      31.3004      31.9484     216.0000      -0.8431      -0.9940      -1.0665      15.7748      40.2889     229.2714    1597.5675      50.5033       0.2457       0.2777       0.3288      10.0000    4409.7437       0.0697     260.6250    3563.0000
 2278.3800    1950.0000       0.5291     509.9292     112.5474      18.1897      54.9761     216.0000      -0.8428      -0.9937      -1.0661      15.8201      32.1885     229.8296    1574.6224      50.5033       0.2140       0.2428       0.2940      10.0000    4409.1426       0.0698     258.6250    3597.0000
 2278.5324    1950.0000       0.5328     440.5701      84.2788      15.3448      65.1687     216.0000      -0.8411      -0.9918      -1.0642      15.8598      33.8126     229.8296    1549.1536      50.5033       0.1841       0.2102       0.2607      10.0000    4405.9912       0.0679     260.9375    3568.0000
 2278.6848    1950.0000       0.5379     389.5762      72.0820      15.8221      63.2028     216.0000      -0.8432      -0.9941      -1.0666      15.8299      36.6819     229.2714    1553.9236      50.5033       0.2231       0.2537       0.3043      10.0000    4409.8726       0.0676     261.6875    3590.0000
 2278.8372    1950.0000       0.5444     329.4287      69.7952      17.6659      56.6064     216.0000      -0.8519      -1.0035      -1.0764      15.7791      45.4785     229.8296    1605.6998      50.5033       0.2619       0.2989       0.3473      10.0000    4426.0376       0.0679     266.6250    3536.0000
 2278.9896    1950.0000       0.5500     252.4895      70.9287      21.3611      46.8140     216.0000      -0.8653      -1.0180      -1.0914      15.7943      51.3990     229.5505    1692.0421      50.5033       0.2815       0.3243       0.3692      10.0000    4450.8394       0.0676     268.2500    3551.0000
 2279.1420    1950.0000       0.5534     184.9009      81.7590      22.2064      45.0320     216.0000      -0.8730      -1.0263      -1.1000      15.7578      50.6506     229.2714    1750.5844      50.5033       0.3398       0.3902       0.4311      10.0000    4465.0410       0.0647     261.7500    3543.0000
 2279.2944    1950.0000       0.5536     131.0127      94.7872      18.3279      54.5616     216.0000      -0.8746      -1.0280      -1.1018      15.7518      45.6257     229.8296    1721.7552      50.5033       0.3778       0.4282       0.4697      10.0000    4467.9526       0.0632     260.2500    3558.0000
 2279.4468    1950.0000       0.5503      89.8358      85.7094       9.8257     101.7734     216.0000      -0.8728      -1.0261      -1.0998      15.7280      43.1565     229.2714    1659.3285      50.5033       0.2542       0.2910       0.3391      10.0000    4464.7002       0.0646     251.3125    3583.0000
 2279.5992    1215.6997       0.5479      53.7343      61.5722       7.3167     136.6736     216.0000      -0.8696      -1.0227      -1.0963      15.7121      43.8779     229.2714    1644.1331      50.5033       0.2647       0.3018       0.3503      10.0000    4458.8188       0.0676     259.3750    3547.0000
 2279.7516     485.5244       0.5518      36.4037      31.8648       9.5254     104.9823     216.0000      -0.8875      -1.0420      -1.1162      15.7268      44.9574     229.2714    1719.9127      50.5033       0.2722       0.3117       0.3588      10.0000    4491.8091       0.0652     259.6875    3589.0000
 2279.9040    1946.6079       0.5485      24.5476      24.1741       9.4734     105.5591     216.0000      -0.9174      -1.0743      -1.1498      15.7247      46.2063     229.2714    1742.9137      50.5033       0.3349       0.3837       0.4258      10.0000    4547.1040       0.0650     258.5000    3577.0000
 2280.0564    1028.9097       0.5488      26.7266      25.1903      11.6319      85.9705     216.0000      -0.9495      -1.1091      -1.1858      15.7106      45.9491     229.2714    1599.5836      50.5033       0.3275       0.3757       0.4181      10.0000    4606.6182       0.0655     258.5000    3559.0000
 2280.2088      33.3465       0.5671      36.6964      16.1446      11.2743      88.6976     216.0000      -0.9615      -1.1221      -1.1993      15.6667      41.0050     229.2714    1388.7957      50.5033       0.2934       0.3348       0.3814      10.0000    4628.7998       0.0699     258.5000    3571.0000
 2280.3612      18.8624       0.5622       8.2507       7.2878       5.7973     172.4955     216.0000      -0.9615      -1.1221      -1.1993      15.6737      31.2420     228.7132    1248.3923      50.5033       0.1963       0.2238       0.2744      10.0000    4628.7998       0.0813     251.2500    3560.0000
 2280.5136      15.9109       0.5254       5.2102       3.7506       3.2272     309.8678     216.0000      -0.9615      -1.1221      -1.1993      15.6669      28.2250     228.1550    1324.0687      50.5033       0.1495       0.1695       0.2203      10.0000    4628.7998       0.0826     258.4375    3583.0000
 2280.6660      11.1811       0.5444      12.3977       9.4878       7.3326     136.3774     216.0000      -0.9615      -1.1221      -1.1993      15.6506      29.8297     228.7132    1466.1543      50.5033       0.1650       0.1862       0.2378      10.0000    4628.7998       0.0779     256.7500    3602.0000
 2280.8184      17.0351       0.5523      28.2439      20.9434      12.2092      81.9055     216.0000      -0.9615      -1.1221      -1.1993      15.6637      32.8859     228.7132    1586.2299      50.5033       0.1572       0.1772       0.2287      10.0000    4628.7998       0.0683     252.3750    3570.0000
 2280.9708      19.6776       0.5496      54.0386      30.1319      13.5901      73.5832     216.0000      -0.9615      -1.1221      -1.1993      15.6729      32.7089     228.7132    1642.5953      50.5033       0.1342       0.1519       0.2022      10.0000    4628.7998       0.0655     258.5000    3558.0000
 2281.1232      46.6919       0.5383      59.7187      22.9997       8.8843     112.5586     216.0000      -0.9615      -1.1221      -1.1993      15.6338      35.5841     228.7132    1663.2175      50.5033       0.1510       0.1707       0.2218      10.0000    4628.7998       0.0632     248.7500    3579.0000
 2281.2756      67.7599       0.5361     133.7903      39.1312       7.3050     136.8932     216.0000      -0.9615      -1.1221      -1.1993      15.6015      36.9817     228.7132    1711.8177      50.5033       0.1709       0.1935       0.2449      10.0000    4628.7998       0.0653     259.5000    3570.0000
 2281.4280     119.5504       0.5311     336.0165      58.0492       9.4607     105.6999     216.0000      -0.9615      -1.1221      -1.1993      15.5988      38.2226     228.7132    1757.7970      50.5033       0.1666       0.1885       0.2399      10.0000    4628.7998       0.0650     258.0000    3578.0000
 2281.5804     238.5186       0.5270     967.4028      97.7746      24.5223      40.7792     216.0000      -0.9615      -1.1221      -1.1993      15.5437      34.7414     228.7132    1780.7357      50.5033       0.1806       0.2038       0.2558      10.0000    4628.7998       0.0670     252.9375    3587.0000
 2281.7328     523.7261       0.5227    1863.3276     173.8622      34.3859      29.0817     216.0000      -0.9615      -1.1221      -1.1993      15.5383      37.4065     228.7132    1766.9940      50.5033       0.1586       0.1797       0.2308      10.0000    4628.7998       0.0690     248.7500    3586.0000
 2281.8852    1520.1108       0.5171    1950.0000     332.7609      38.0083      26.3101     216.0000      -0.9615      -1.1221      -1.1993      15.5542      37.0388     228.7132    1750.6891      50.5033       0.1782       0.2019       0.2534      10.0000    4628.7998       0.0662     255.7500    3603.0000
 2282.0376    1950.0000       0.5103    1887.1211     638.7985      24.3685      41.0366     216.0000      -0.9615      -1.1221      -1.1993      15.5776      39.9046     228.4341    1744.9884      50.5033       0.2445       0.2750       0.3271      10.0000    4628.7998       0.0668     249.6250    3564.0000
 2282.1900    1950.0000       0.5040    1700.6631     974.1086      20.3631      49.1085     216.0000      -0.9615      -1.1221      -1.1993      15.5875      40.4878     228.1550    1732.7511      50.5033       0.2082       0.2351       0.2871      10.0000    4628.7998       0.0598     251.9375    3586.0000
 2282.3424    1950.0000       0.4998    1402.0396    1015.1335      21.4880      46.5375     216.0000      -0.9615      -1.1221      -1.1993      15.6020      42.1123     228.7132    1724.9193      50.5033       0.1753       0.1994       0.2504      10.0000    4628.7998       0.0525     248.7500    3598.0000
 2282.4948    1950.0000       0.4992    1070.7233     693.7338      31.1827      32.0691     216.0000      -0.9615      -1.1221      -1.1993      15.5794      40.6646     228.7132    1708.1244      50.5033       0.1734       0.1966       0.2479      10.0000    4628.7998       0.0499     254.3125    3558.0000
 2282.6472    1950.0000       0.5024     805.3339     471.5950      27.0450      36.9754     216.0000      -0.9615      -1.1221      -1.1993      15.5468      40.4882     228.7132    1698.4744      50.5033       0.1727       0.1965       0.2474      10.0000    4628.7998       0.0535     251.7500    3559.0000
 2282.7996    1950.0000       0.5086     638.9823     351.5579      31.9123      31.3359     216.0000      -0.9615      -1.1221      -1.1993      15.5308      43.2992     228.7132    1672.5173      50.7829       0.2354       0.2644       0.3169      10.0000    4628.7998       0.0600     250.6250    3551.0000
 2282.9520    1950.0000       0.5157     559.6164     298.5629      30.8254      32.4408     216.0000      -0.9615      -1.1221      -1.1993      15.5268      44.2020     228.7132    1656.9362      50.7829       0.1933       0.2188       0.2705      10.0000    4628.7998       0.0620     252.3750    3524.0000
 2283.1044    1950.0000       0.5240     552.9238     291.1879      26.6958      37.4591     216.0000      -0.9615      -1.1221      -1.1993      15.5316      42.5748     228.4341    1662.9456      50.5033       0.1760       0.1991       0.2508      10.0000    4628.7998       0.0669     248.1250    3566.0000
 2283.2568    1950.0000       0.5312     612.8456     331.1897      31.5409      31.7048     216.0000      -0.9615      -1.1221      -1.1993      15.4925      40.1082     228.7132    1670.8534      50.5033       0.1596       0.1807       0.2319      10.0000    4628.7998       0.0668     248.7500    3592.0000
 2283.4092    1950.0000       0.5366     730.6166     426.5056      29.9150      33.4280     216.0000      -0.9615      -1.1221      -1.1993      15.5300      38.7157     228.1550    1668.2469      50.5033       0.1691       0.1912       0.2428      10.0000    4628.7998       0.0557     247.1875    3587.0000
 2283.5616    1950.0000       0.5405     858.7668     599.3970      29.1703      34.2815     216.0000      -0.9615      -1.1221      -1.1993      15.5034      39.7072     228.7132    1669.2014      50.7829       0.1770       0.1999       0.2518      10.0000    4628.7998       0.0537     255.3750    3619.0000
 2283.7140    1950.0000       0.5423     874.9601     834.9797      30.6504      32.6260     216.0000      -0.9615      -1.1221      -1.1993      15.4665      41.0197     228.1550    1673.7695      50.5033       0.1699       0.1925       0.2438      10.0000    4628.7998       0.0531     254.1875    3603.0000
 2283.8664    1950.0000       0.5417     749.8453    1014.9606      32.7343      30.5490     216.0000      -0.9615      -1.1221      -1.1993      15.4955      40.0883     228.4341    1687.7637      50.5033       0.1669       0.1888       0.2403      10.0000    4628.7998       0.0642     255.0625    3596.0000
 2284.0188    1950.0000       0.5392     602.3967    1035.8652      31.5534      31.6923     216.0000      -0.9600      -1.1205      -1.1976      15.4969      37.8764     228.7132    1694.6979      50.5033       0.1547       0.1758       0.2265      10.0000    4626.0552       0.0642     250.6250    3592.0000
 2284.1712    1950.0000       0.5362     509.7583     986.6419      25.8145      38.7380     216.0000      -0.9549      -1.1150      -1.1919      15.4809      36.2196     228.7132    1714.7429      50.5033       0.1860       0.2112       0.2625      10.0000    4616.6514       0.0656     253.1250    3597.0000
 2284.3236    1950.0000       0.5343     475.4900     950.8257      23.6006      42.3719     216.0000      -0.9492      -1.1088      -1.1855      15.4868      41.1224     228.4341    1734.3364      50.5033       0.2573       0.2920       0.3419      10.0000    4606.0034       0.0575     245.5625    3600.0000
 2284.4760    1950.0000       0.5353     510.5325     992.3710      27.8267      35.9367     216.0000      -0.9462      -1.1055      -1.1821      15.4720      46.5825     228.7132    1726.9933      50.5033       0.3327       0.3768       0.4226      10.0000    4600.4697       0.0476     258.5000    3583.0000
 2284.6284    1950.0000       0.5384     613.9115    1117.5562      34.0062      29.4064     216.0000      -0.9460      -1.1053      -1.1819      15.5073      49.8674     228.7132    1725.5144      50.5033       0.2908       0.3311       0.3784      10.0000    4600.1309       0.0465     251.1875    3592.0000
 2284.7808    1950.0000       0.5418     809.3069    1320.4393      38.0344      26.2920     216.0000      -0.9443      -1.1035      -1.1799      15.5024      51.8330     228.1550    1731.8995      50.5033       0.2305       0.2640       0.3130      10.0000    4596.8999       0.0544     251.0625    3597.0000
 2284.9332    1950.0000       0.5442    1106.5986    1560.9340      29.8694      33.4791     216.0000      -0.9431      -1.1022      -1.1786      15.4894      50.6442     228.1550    1762.4028      50.5033       0.2453       0.2792       0.3290      10.0000    4594.6948       0.0648     251.4375    3576.0000
 2285.0856    1950.0000       0.5450    1456.6913    1767.4008      29.1718      34.2797     216.0000      -0.9475      -1.1069      -1.1835      15.4628      48.2876     228.7132    1777.9786      50.5033       0.2364       0.2682       0.3189      10.0000    4602.8198       0.0670     248.7500    3594.0000
 2285.2380    1950.0000       0.5444    1746.6691    1830.8561      29.4285      33.9806     216.0000      -0.9550      -1.1150      -1.1919      15.4462      46.7288     228.1550    1764.8282      50.7829       0.2357       0.2673       0.3181      10.0000    4616.6982       0.0685     253.3750    3605.0000
 2285.3904    1950.0000       0.5432    1920.3481    1736.9094      28.2762      35.3654     216.0000      -0.9606      -1.1212      -1.1983      15.4617      46.1525     228.7132    1734.6324      50.7829       0.2365       0.2682       0.3190      10.0000    4627.1826       0.0649     248.7500    3611.0000
 2285.5428    1950.0000       0.5423    1950.0000    1486.1160      27.3614      36.5478     216.0000      -0.9615      -1.1221      -1.1993      15.4579      42.9503     228.7132    1708.7848      50.7829       0.1992       0.2272       0.2777      10.0000    4628.7998       0.0604     248.7500    3622.0000
 2285.6952    1950.0000       0.5416    1950.0000    1153.6322      29.1853      34.2638     216.0000      -0.9615      -1.1221      -1.1993      15.3223      38.0468     228.7132    1702.7147      50.7829       0.1863       0.2114       0.2627      10.0000    4628.7998       0.0567     253.9375    3582.0000
 2285.8476    1950.0000       0.5410    1950.0000     866.9965      33.5077      29.8439     216.0000      -0.9615      -1.1221      -1.1993      15.3866      34.8230     228.1550    1687.5472      50.7829       0.1900       0.2153       0.2669      10.0000    4628.7998       0.0610     249.6250    3602.0000
 2286.0000    1950.0000       0.5401    1950.0000     675.0840      32.0253      31.2253     216.0000      -0.9615      -1.1221      -1.1993      15.3415      38.6594     228.7132    1682.6294      50.7829       0.1978       0.2236       0.2755      10.0000    4628.7998       0.0612     249.3125    3627.0000
 2286.1524    1950.0000       0.5386    1950.0000     567.8340      26.4185      37.8522     216.0000      -0.9615      -1.1221      -1.1993      15.3987      40.3451     228.7132    1670.6893      50.7829       0.2044       0.2319       0.2832      10.0000    4628.7998       0.0602     255.5625    3578.0000
 2286.3048    1950.0000       0.5373    1915.6140     519.0247      22.5481      44.3496     216.0000      -0.9615      -1.1221      -1.1993      15.4712      43.1008     228.7132    1691.0613      50.7829       0.2085       0.2362       0.2877      10.0000    4628.7998       0.0630     258.8750    3566.0000
 2286.4572    1950.0000       0.5370    1787.3942     515.5729      24.7025      40.4818     216.0000      -0.9615      -1.1221      -1.1993      15.4850      39.8746     228.7132    1684.9620      50.7829       0.2163       0.2461       0.2968      10.0000    4628.7998       0.0670     259.6250    3603.0000
 2286.6096    1950.0000       0.5387    1575.6708     506.1292      27.4287      36.4582     216.0000      -0.9597      -1.1201      -1.1972      15.4662      39.8746     228.7132    1692.9102      50.7829       0.2514       0.2861       0.3356      10.0000    4625.4131       0.0617     252.3750    3606.0000
 2286.7620    1950.0000       0.5421    1323.4711     464.5555      26.2609      38.0795     216.0000      -0.9510      -1.1108      -1.1875      15.4567      44.5801     228.7132    1701.9623      50.7829       0.2493       0.2851       0.3337      10.0000    4609.4185       0.0520     246.6875    3625.0000
 2286.9144    1950.0000       0.5464    1103.0009     402.9375      30.7528      32.5174     216.0000      -0.9437      -1.1028      -1.1793      15.2879      46.6140     228.7132    1731.2455      50.7829       0.2344       0.2687       0.3174      10.0000    4595.8481       0.0547     261.6250    3652.0000
 2287.0668    1950.0000       0.5497     959.4102     356.0503      25.0895      39.8573     216.0000      -0.9450      -1.1042      -1.1808      15.4143      50.5594     228.1550    1770.1044      50.7829       0.2602       0.2970       0.3455      10.0000    4598.2598       0.0571     256.7500    3627.0000
 2287.2192    1950.0000       0.5511     900.7757     341.2350      27.7440      36.0438     216.0000      -0.9537      -1.1136      -1.1905      15.2868      45.2449     228.4341    1797.9489      50.7829       0.3463       0.3929       0.4370      10.0000    4614.2539       0.0637     256.3750    3638.0000
 2287.3716    1950.0000       0.5500     935.8986     373.0933      25.9005      38.6093     216.0000      -0.9610      -1.1215      -1.1987      15.3050      45.8281     228.7132    1813.7410      50.7829       0.3383       0.3869       0.4292      10.0000    4627.8247       0.0670     253.0625    3627.0000
 2287.5240    1950.0000       0.5476    1054.3690     459.0971      27.5124      36.3472     216.0000      -0.9591      -1.1195      -1.1966      15.3226      44.4699     228.1550    1792.1893      50.7829       0.2965       0.3423       0.3855      10.0000    4624.3760       0.0697     250.1875    3622.0000
 2287.6764    1950.0000       0.5446    1234.7836     627.4202      30.7222      32.5497     216.0000      -0.9506      -1.1103      -1.1871      15.5140      46.5000     228.7132    1775.8444      50.7829       0.2645       0.3046       0.3508      10.0000    4608.6968       0.0624     248.7500    3590.0000
 2287.8288    1950.0000       0.5418    1386.0747     908.1263      32.1347      31.1190     216.0000      -0.9413      -1.1002      -1.1766      15.4168      47.7474     228.7132    1770.6259      50.7829       0.2805       0.3206       0.3676      10.0000    4591.3867       0.0607     250.2500    3583.0000
 2287.9812    1950.0000       0.5393    1370.2865    1284.6853      35.2863      28.3396     216.0000      -0.9372      -1.0958      -1.1720      15.4534      44.6961     228.7132    1766.1741      50.7829       0.3167       0.3607       0.4061      10.0000    4583.7393       0.0640     247.8125    3602.0000
 2288.1336    1950.0000       0.5368    1146.3290    1642.7701      36.0069      27.7725     216.0000      -0.9400      -1.0988      -1.1752      15.4713      43.7091     228.1550    1744.3020      50.7829       0.3116       0.3555       0.4008      10.0000    4589.0020       0.0676     248.7500    3601.0000
 2288.2860    1950.0000       0.5345     867.7303    1870.9424      41.2176      24.2615     216.0000      -0.9421      -1.1011      -1.1775      15.3552      43.8291     228.7132    1728.6302      50.7829       0.2373       0.2736       0.3210      10.0000    4592.9238       0.0690     248.1250    3612.0000
 2288.4384    1950.0000       0.5326     658.4793    1942.7183      37.5205      26.6521     216.0000      -0.9416      -1.1006      -1.1770      15.3725      47.8859     228.1550    1738.8273      50.7829       0.2536       0.2911       0.3386      10.0000    4592.0405       0.0681     244.0625    3636.0000
 2288.5908    1950.0000       0.5322     537.3787    1877.7045      37.5710      26.6163     216.0000      -0.9452      -1.1044      -1.1809      15.2751      48.0608     228.7132    1768.9049      50.7829       0.3475       0.3958       0.4386      10.0000    4598.5356       0.0621     247.4375    3602.0000
 2288.7432    1950.0000       0.5346     488.8691    1744.8224      32.7606      30.5245     216.0000      -0.9524      -1.1122      -1.1890      15.3262      51.5832     228.7132    1766.7024      50.7829       0.3538       0.4050       0.4456      10.0000    4611.9248       0.0563     240.6250    3598.0000
 2288.8956    1950.0000       0.5402     508.5896    1568.7649      28.9889      34.4960     216.0000      -0.9594      -1.1198      -1.1969      15.3408      48.7410     228.4341    1734.0250      50.7829       0.3291       0.3769       0.4197      10.0000    4624.8804       0.0583     245.5625    3595.0000
 2289.0480    1950.0000       0.5471     597.1813    1377.9014      30.8995      32.3630     216.0000      -0.9615      -1.1221      -1.1993      15.2621      44.9050     228.1550    1675.8931      50.7829       0.2935       0.3343       0.3813      10.0000    4628.7998       0.0653     241.1875    3599.0000
 2289.2004    1950.0000       0.5530     771.4159    1201.0282      28.8163      34.7025     216.0000      -0.9615      -1.1221      -1.1993      15.4346      36.0448     228.1550    1630.1112      50.7829       0.1973       0.2235       0.2751      10.0000    4628.7998       0.0706     243.1250    3599.0000
 2289.3528    1950.0000       0.5554    1046.7452    1053.7496      23.7666      42.0759     216.0000      -0.9615      -1.1221      -1.1992      15.3303      34.6476     228.1550    1615.7834      50.7829       0.1332       0.1510       0.2011      10.0000    4628.7397       0.0685     248.7500    3637.0000
 2289.5052    1950.0000       0.5545    1389.8091     910.5469      27.9030      35.8384     216.0000      -0.9565      -1.1166      -1.1936      15.3070      35.2354     228.1550    1642.4283      50.7829       0.1216       0.1377       0.1873      10.0000    4619.4561       0.0664     243.0000    3618.0000
 2289.6576    1950.0000       0.5516    1697.1021     753.6093      23.5509      42.4612     216.0000      -0.9493      -1.1089      -1.1856      15.3137      38.9789     227.8759    1640.4036      50.7829       0.1793       0.2022       0.2542      10.0000    4606.2656       0.0646     243.7500    3643.0000
 2289.8100    1950.0000       0.5485    1892.3390     610.8340      24.6453      40.5756     216.0000      -0.9449      -1.1041      -1.1807      15.3093      35.5037     227.5968    1632.6699      50.7829       0.1884       0.2128       0.2648      10.0000    4598.0791       0.0645     245.8125    3605.0000
 2289.9624    1950.0000       0.5462    1950.0000     512.4794      21.8978      45.6667     216.0000      -0.9497      -1.1093      -1.1860      15.2464      33.2706     227.5968    1612.0420      50.7829       0.1728       0.1954       0.2470      10.0000    4606.9277       0.0698     245.7500    3574.0000
 2290.1148    1950.0000       0.5445    1950.0000     466.2142      25.0866      39.8619     216.0000      -0.9568      -1.1170      -1.1940      15.1385      27.9024     227.5968    1618.4495      50.7829       0.1658       0.1875       0.2390      10.0000    4620.1191       0.0681     246.0000    3600.0000
 2290.2672    1950.0000       0.5431    1950.0000     476.9710      26.7218      37.4226     216.0000      -0.9591      -1.1195      -1.1966      15.2540      28.1233     227.5968    1633.4493      50.7829       0.1382       0.1564       0.2069      10.0000    4624.3540       0.0701     248.7500    3628.0000
 2290.4196    1950.0000       0.5414    1950.0000     544.2601      35.1987      28.4101     216.0000      -0.9490      -1.1086      -1.1853      15.3298      33.0230     227.5968    1635.5944      50.7829       0.1292       0.1465       0.1965      10.0000    4605.6636       0.0662     248.7500    3619.0000
 2290.5720    1950.0000       0.5395    1872.5098     678.8472      37.3918      26.7438     216.0000      -0.9328      -1.0911      -1.1671      15.3073      38.5930     227.5968    1618.9792      50.7829       0.1838       0.2071       0.2593      10.0000    4575.7441       0.0634     251.6250    3637.0000
 2290.7244    1950.0000       0.5374    1691.3783     845.6569      36.4804      27.4120     216.0000      -0.9187      -1.0758      -1.1513      15.2198      44.0846     227.5968    1598.1371      50.7829       0.2047       0.2311       0.2832      10.0000    4549.6392       0.0576     246.4375    3594.0000
 2290.8768    1950.0000       0.5350    1419.2352     850.4946      42.5935      23.4778     216.0000      -0.9166      -1.0735      -1.1489      15.0962      42.2063     227.5968    1577.8010      50.7829       0.2112       0.2383       0.2905      10.0000    4545.6855       0.0595     248.7500    3636.0000
 2291.0292     818.3951       0.5318    1125.5309     589.1775      45.2399      22.1044     216.0000      -0.9227      -1.0801      -1.1557      15.0226      42.7022     227.5968    1578.8202      50.7829       0.1662       0.1879       0.2394      10.0000    4556.9868       0.0606     249.1250    3595.0000
 2291.1816     151.4637       0.5278     863.2142     314.9102      55.5366      18.0061     216.0000      -0.9278      -1.0857      -1.1615      15.0886      39.6289     227.5968    1567.7485      50.7829       0.1384       0.1566       0.2071      10.0000    4566.4697       0.0631     248.7500    3594.0000
 2291.3340      43.1905       0.5234     633.8763     154.3350      35.0469      28.5332     216.0000      -0.9255      -1.0832      -1.1589      15.0514      39.6767     227.0386    1555.2393      50.7829       0.1325       0.1498       0.2000      10.0000    4562.2637       0.0656     251.7500    3637.0000
 2291.4864      16.1033       0.5194     436.4194      75.5853      28.3044      35.3301     216.0000      -0.9161      -1.0729      -1.1483      15.0326      37.0920     227.0386    1548.4641      50.7829       0.1304       0.1475       0.1976      10.0000    4544.7368       0.0639     248.7500    3620.0000
 2291.6388       6.8906       0.5174     285.1232      43.9612      21.7660      45.9431     216.0000      -0.9000      -1.0555      -1.1303      15.0091      36.9110     227.0386    1541.4404      50.7829       0.1346       0.1522       0.2025      10.0000    4514.9185       0.0627     248.7500    3595.0000
 2291.7912       3.3311       0.5180     176.5076      31.3841      20.0235      49.9414     216.0000      -0.8811      -1.0352      -1.1092      14.9947      34.4509     227.3177    1517.3635      50.7829       0.1294       0.1463       0.1964      10.0000    4480.1128       0.0609     246.5000    3640.0000
 2291.9436       1.8111       0.5235     111.7595      15.6879      16.3986      60.9809     216.0000      -0.8625      -1.0150      -1.0883      14.8793      34.4772     227.5968    1486.6133      50.7829       0.1376       0.1557       0.2062      10.0000    4445.7080       0.0674     248.7500    3631.0000
 2292.0960       1.0898       0.5405      81.8000      17.5112      12.0506      82.9837     216.0000      -0.8481      -0.9994      -1.0721      15.0536      37.9064     227.5968    1454.5479      50.7829       0.1719       0.1949       0.2462      10.0000    4418.9404       0.0679     248.7500    3626.0000
 2292.2484       0.7154       0.5783      59.2948      15.0109       9.2268     108.3805     216.0000      -0.8379      -0.9884      -1.0607      15.1116      43.5661     228.1550    1455.6555      50.7829       0.2398       0.2733       0.3230      10.0000    4400.1216       0.0691     255.5625    3607.0000
 2292.4008       0.5138       0.6615      36.5410       5.3135       5.6596     176.6913     216.0000      -0.8317      -0.9817      -1.0538      15.1370      45.8567     228.1550    1479.0532      50.7829       0.3123       0.3586       0.4021      10.0000    4388.7349       0.0669     247.6250    3591.0000
 2292.5532       0.3963       0.8344      51.9126       5.1672       5.4769     182.5843     216.0000      -0.8327      -0.9827      -1.0548      15.0429      41.4105     228.1550    1539.7244      50.7829       0.3993       0.4547       0.4922      10.0000    4390.4634       0.0647     250.7500    3633.0000
 2292.7056       0.3281       1.1795      79.2980      25.6671      25.3555      39.4392     216.0000      -0.8360      -0.9863      -1.0586      15.0695      41.6426     228.7132    1585.9525      50.7829       0.4633       0.5317       0.5577      10.0000    4396.6401       0.0601     248.2500    3613.0000
 2292.8580       0.2890       1.8784     114.0435      31.8425      32.8112      30.4774     216.0000      -0.8407      -0.9914      -1.0638      14.9579      40.6530     230.3878    1574.0071      50.7829       0.3752       0.4333       0.4685      10.0000    4405.3506       0.0623     246.0625    3616.0000
 2293.0104       0.2646       3.3316     428.1500     224.3752     220.5864       4.5334     216.0000      -0.8462      -0.9973      -1.0700      14.8754      42.6869     229.8296    1517.5693      50.7829       0.3302       0.3829       0.4217      10.0000    4415.4229       0.0680     244.3125    3687.0000
 2293.1628       0.2461       6.3262     407.3868     327.7247    1836.3047       0.5446     216.0000      -0.8489      -1.0002      -1.0730      14.9228      36.4208     230.3878    1458.9398      50.7829       0.2473       0.2848       0.3319      10.0000    4420.4097       0.0681     245.3125    3627.0000
 2293.3152       0.2272      12.0574      76.6767      41.0190    1950.0000       0.5000     216.0000      -0.8452      -0.9963      -1.0689      14.6720      34.9742     231.5042    1424.7361      50.7829       0.2574       0.2934       0.3423      10.0000    4413.6602       0.0684     245.6875    3643.0000
 2293.4676       0.2047      17.1699      46.3324       8.7113      20.5251      48.7209     216.0000      -0.8332      -0.9833      -1.0554      14.6494      34.7472     231.5042    1411.1724      50.7829       0.2591       0.2932       0.3436      10.0000    4391.4712       0.0627     238.9375    3623.0000
 2293.6200       0.1821      35.5441       6.9395       5.5615       4.9589     201.6564     216.0000      -0.8196      -0.9686      -1.0402      14.6413      37.5817     230.9460    1401.0262      50.7829       0.2206       0.2514       0.3017      10.0000    4366.2896       0.0628     241.5625    3611.0000
 2293.7724       0.1606      60.0594       4.0670       2.4340       2.7765     360.1682     216.0000      -0.8054      -0.9532      -1.0242      14.7730      37.9331     231.5042    1402.5190      50.7829       0.2515       0.2865       0.3358      10.0000    4339.9810       0.0606     238.9375    3594.0000
 2293.9248       0.1562      11.6038       3.6285       2.7748       2.1148     472.8558     216.0000      -0.8303      -0.9801      -1.0522      14.8394      37.3465     232.0624    1438.6777      50.7829       0.2213       0.2527       0.3026      10.0000    4386.0542       0.0566     243.7500    3600.0000
 2294.0772       0.1504       3.9281       3.8001       2.2522       1.8033     554.5323     216.0000      -0.8816      -1.0357      -1.1097      14.7426      34.2773     232.6206    1477.1418      50.7829       0.2424       0.2754       0.3256      10.0000    4480.9805       0.0548     238.9375    3590.0000
 2294.2296       0.1490       1.8460       6.1374       3.7735       1.8631     536.7491     216.0000      -0.9391      -1.0978      -1.1741      14.7149      33.3739     233.1788    1464.9830      50.7829       0.2153       0.2439       0.2953      10.0000    4587.2642       0.0605     240.5000    3614.0000
 2294.3820       0.2132       1.2756       5.7874       2.7062       2.0174     495.6819     216.0000      -0.9615      -1.1221      -1.1993      14.7014      34.1635     234.2952    1396.5177      50.7829       0.1781       0.2032       0.2538       9.9420    4628.7998       0.0705     234.3750    3564.0000
 2294.5344       0.3212       1.0542       3.4230       2.4553       1.5837     631.4141     216.0000      -0.8457      -0.9969      -1.0695      14.6947      39.6449     235.9698    1211.6429      50.7829       0.2287       0.2579       0.3099       9.6741    4414.6299       0.0713     243.2500    3579.0000
 2294.6868       0.5294       0.7001      10.3048       3.2112       2.4373     410.2981     216.0000      -0.5151      -0.6391      -0.6987      14.7174      45.8862     235.1325     773.6580      50.7829       0.2682       0.3016       0.3530       8.7438    3802.8574       0.0919     235.8750    3590.0000
 2294.8392       0.7640       0.4891       2.7996       1.6906       1.2083     827.6409     216.0000      -0.1178      -0.2093      -0.2532      14.7546      49.9781     236.5280     365.6940      50.7829       0.2064       0.2323       0.2848       7.4574    3067.8562       0.1981     233.0000    3577.0000
 2294.9916       0.8635       0.3754       2.7574       0.5080       0.4193    2384.7622     216.0000       0.1554       0.0863       0.0530      14.6401      50.0692     246.0174      91.5060      50.7829       0.1150       0.1304       0.1796       6.2035    2562.4990       1.3123     229.5625    3602.0000
 2295.1440       0.9096       0.3548       2.1827       0.8271       0.6645    1504.7943     216.0000       0.2052       0.1402       0.1089      14.4071      52.7420     256.0650     128.9330      50.7829       0.1058       0.1198       0.1684       5.5493    2470.3164       9.9723     229.1875    3566.0000
 2295.2964       0.9906       0.4184       6.5123       2.1678       1.5909     628.5577     216.0000       0.1979       0.1322       0.1006      14.6092      52.5386     262.7634     149.2379      50.7829       0.1845       0.2088       0.2605       5.3272    2483.9495      10.6586     229.1875    3582.0000
 2295.4488       1.2304       0.5634      10.3350       5.8245       4.8578     205.8560     216.0000       0.2200       0.1561       0.1254      14.6696      58.8047     263.8798     138.2277      50.7829       0.2677       0.3012       0.3525       5.3224    2443.0732       9.3512     224.8125    3581.0000
 2295.6012       1.6124       0.8224      19.7792       5.3886       7.0366     142.1145     216.0000       0.2455       0.1837       0.1540      14.6880      57.1422     266.1126     129.9331      50.7829       0.2450       0.2770       0.3281       5.4465    2395.8372       7.3891     230.2500    3579.0000
 2295.7536       2.2283       1.2563       6.4673       9.8668       2.2053     453.4619     216.0000       0.2590       0.1983       0.1692      14.6841      55.6899     264.9962     132.7937      50.7829       0.1672       0.1890       0.2405       5.6112    2370.8289       6.9377     229.1875    3591.0000
 2295.9060       3.6005       2.0446      12.9214      17.8811       6.2221     160.7179     216.0000       0.2718       0.2122       0.1836      14.6226      53.6325     265.5544     152.9753      50.7829       0.1121       0.1269       0.1758       5.8795    2347.0874       7.3545     229.1875    3596.0000
 2296.0584       6.1810       3.2540      13.2558      14.0126       4.9262     202.9972     216.0000       0.3135       0.2573       0.2303      14.5519      49.3731     273.3693     171.1600      50.7829       0.0780       0.0882       0.1343       6.2758    2270.0093       6.2807     232.1875    3573.0000
 2296.2108      13.4172       5.9517      19.3470      18.9550       6.5258     153.2374     216.0000       0.3298       0.2750       0.2486      14.4558      52.0457     291.2317     219.3778      50.7829       0.1247       0.1411       0.1908       6.6600    2239.8235       6.1619     229.5625    3580.0000
 2296.3632      36.4163      14.1276      36.2217      46.8818      14.4264      69.3172     216.0000       0.3751       0.3239       0.2993      14.3643      53.4303     307.4195     226.5425      50.7829       0.2032       0.2291       0.2814       6.9953    2156.1306       5.0352     229.1875    3605.0000
 2296.5156      74.8251      26.2537     189.1865     103.5771      40.9370      24.4278     216.0000       0.4195       0.3720       0.3492      14.4555      57.4155     353.7502     193.7743      50.7829       0.2685       0.3010       0.3530       7.0704    2073.8713       3.6190     228.6250    3564.0000
 2296.6680      78.2828      35.3589      83.1181     120.5893      45.7459      21.8599     216.0000       0.4534       0.4087       0.3872      14.4616      59.2091     334.7714     124.1869      50.7829       0.2419       0.2745       0.3250       6.9093    2011.1823       2.4149     231.3750    3616.0000
 2296.8204      47.5315      29.4219      75.2913     152.5493      49.2976      20.2850     216.0000       0.3805       0.3298       0.3054      14.5755      54.3463     339.7951     105.1383      50.7829       0.1815       0.2060       0.2573       6.4505    2146.0562       2.7256     228.9375    3567.0000
 2296.9728      30.6044      23.7344      47.2544     246.5699      34.6322      28.8749     216.0000       0.2819       0.2231       0.1948      14.5152      51.9511     364.3560     128.6235      50.7829       0.1649       0.1867       0.2380       6.0371    2328.5439       4.0325     229.1875    3598.0000
 2297.1252      46.4990      27.8764      65.5609     321.1663      77.1892      12.9552     216.0000       0.2438       0.1819       0.1521      14.5299      49.7507     314.6761     162.5457      50.7829       0.1644       0.1854       0.2371       5.9957    2399.0146      10.1737     229.1875    3624.0000
 2297.2776      52.5592      34.2194      68.2750     286.6147     112.3594       8.9000     216.0000       0.2625       0.2021       0.1731      14.4626      52.2119     317.4671     200.4397      50.7829       0.1214       0.1374       0.1870       6.2943    2364.3376       9.8174     229.1875    3582.0000
 2297.4300      65.2160      43.3721      92.2124     233.8109      98.1598      10.1875     216.0000       0.2650       0.2049       0.1760      14.4485      51.3182     331.7012     252.1481      50.7829       0.1197       0.1355       0.1850       6.6231    2359.6807      12.1402     229.1875    3598.0000
 2297.5824     149.0246      83.2960     159.4969     415.7997     181.5194       5.5091     216.0000       0.2891       0.2309       0.2029      14.6463      50.0978     354.3084     253.1609      50.7829       0.1234       0.1396       0.1892       6.8265    2315.2146      11.7681     230.3125    3609.0000
 2297.7348     148.4834      87.9367     486.3942     744.9438     395.6870       2.5273     216.0000       0.3417       0.2878       0.2619      14.4636      48.9948     365.4724     198.0426      50.7829       0.1439       0.1628       0.2135       6.9196    2217.8210       4.9371     223.0000    3571.0000
 2297.8872     133.2131      77.5931     803.1623    1051.8895     261.0903       3.8301     216.0000       0.4035       0.3547       0.3312      14.3959      53.7761     358.2158     119.6064      50.7829       0.2284       0.2576       0.3096       6.9633    2103.4678       3.1948     223.1875    3575.0000
 2298.0396      86.2578      53.3552     199.2164     278.8418     254.5173       3.9290     216.0000       0.3969       0.3475       0.3238      14.4173      58.4150     369.3798      97.6589      50.7829       0.2675       0.3015       0.3525       6.8952    2115.7615       3.2343     207.1875    3552.0000
 2298.1920      57.0940      34.6555     123.9330     174.9653      50.3752      19.8510     216.0000       0.3647       0.3127       0.2877      14.5221      63.3364     397.2899     121.0756      50.7829       0.1904       0.2157       0.2673       6.7926    2175.2456       3.6445     195.0000    3542.0000
 2298.3444      32.2729      25.6176      87.9819     123.7902      63.0563      15.8588     216.0000       0.3475       0.2941       0.2685      14.4468      61.7123     360.4486     154.7310      50.7829       0.1575       0.1780       0.2293       6.7801    2207.0500       4.0251     180.5000    3568.0000
 2298.4968      48.8013      28.8593     115.7345     129.3080      94.8848      10.5391     216.0000       0.3659       0.3140       0.2891      14.6016      58.4971     354.3084     165.8800      50.7829       0.1550       0.1752       0.2264       6.8087    2173.0332       2.8627     170.6250    3552.0000
 2298.6492      54.3782      37.9203     103.4722     105.4003      89.9466      11.1177     216.0000       0.3740       0.3228       0.2981      14.5586      51.4870     365.4724     170.9285      50.7829       0.1500       0.1693       0.2204       6.7726    2158.0618       2.8218     160.8750    3579.0000
 2298.8016      49.0647      36.1448      95.0690      88.9135      83.9969      11.9052     216.0000       0.3690       0.3173       0.2925      14.5494      51.1148     349.2846     175.1860      50.7829       0.1315       0.1489       0.1990       6.6560    2167.3384       2.7099     158.0000    3621.0000
 2298.9540      36.5566      33.5102      84.1629      77.1130      76.9610      12.9936     216.0000       0.3529       0.2999       0.2745      14.5654      49.4576     360.4486     194.1426      50.7829       0.1220       0.1381       0.1877       6.5623    2197.0898       3.4022     155.3125    3596.0000
 2299.1064      36.0168      47.5837     195.7472     150.4836     119.5802       8.3626     216.0000       0.3626       0.3104       0.2854      14.6481      53.6768     368.2634     202.9337      50.7829       0.1487       0.1679       0.2190       6.5592    2179.1606       4.2767     150.0000    3581.0000
 2299.2588      37.7338      63.7132     227.9711     234.9099     111.8041       8.9442     216.0000       0.3831       0.3326       0.3084      14.5835      54.0490     353.7502     188.1077      50.7829       0.1583       0.1787       0.2302       6.5682    2141.2124       4.4469     146.3125    3594.0000
 2299.4112      37.1091      70.5961     277.8135     218.5080     124.9672       8.0021     216.0000       0.3684       0.3167       0.2919      14.6284      60.1395     376.0782     169.8004      50.7829       0.1727       0.1947       0.2466       6.4179    2168.4263       3.4341     142.1250    3556.0000
 2299.5636      33.1904      57.6794     200.8650     233.1019     177.5537       5.6321     216.0000       0.3264       0.2713       0.2448      14.3728      60.5619     354.0293     163.3210      50.7829       0.2040       0.2294       0.2820       6.1549    2246.1550       3.9664     141.3125    3568.0000
 2299.7160      30.5311      38.1706     223.3684     350.4530      98.1858      10.1848     216.0000       0.2645       0.2043       0.1754      14.2512      63.2406     363.2396     197.4270      50.7829       0.2130       0.2386       0.2917       5.8586    2360.5903       5.1480     136.8750    3558.0000
 2299.8684      32.4078      29.6074     171.0534     559.4627      70.4468      14.1951     216.0000       0.2016       0.1362       0.1048      14.2699      61.2481     294.0227     255.7375      50.7829       0.1403       0.1585       0.2091       5.6329    2477.0515       9.5762     141.3125    3557.0000
 2300.0208      32.9343      34.1932     233.5598     642.9331     119.0756       8.3980     216.0000       0.1438       0.0737       0.0400      14.3631      61.9443     316.3507     290.5824      50.7829       0.0661       0.0745       0.1195       5.4158    2583.9658      13.7490     135.5000    3558.0000
 2300.1732      35.7559      38.5929     205.5337     498.1462     129.5377       7.7198     216.0000       0.1151       0.0426       0.0078      14.3684      64.1380     271.6946     263.1984      50.7829       0.0874       0.0992       0.1459       5.1718    2637.1082      17.0604     138.3750    3562.0000
 2300.3256      34.3000      48.4960     170.8153     339.7068     127.5107       7.8425     216.0000       0.1371       0.0665       0.0325      14.4597      70.3938     271.6946     185.1358      50.7829       0.1067       0.1212       0.1691       4.9909    2596.2942      18.2386     134.8750    3594.0000
 2300.4780      36.0568      49.4180     187.0863     309.2025     162.8561       6.1404     216.0000       0.1600       0.0912       0.0582      14.5891      72.5312     288.9989     131.1958      50.7829       0.1175       0.1335       0.1819       4.9115    2554.0244      15.5891     134.3750    3609.0000
 2300.6304      29.0316      48.8469     128.6560     374.4560     194.8347       5.1326     216.0000       0.1707       0.1028       0.0702      14.6050      71.9222     264.1589     137.0063      50.7829       0.0892       0.1014       0.1479       5.0122    2534.1411      21.8209     140.1250    3578.0000
 2300.7828      21.4596      31.4838      46.0007      71.2564      44.1401      22.6552     216.0000       0.1746       0.1070       0.0745      14.6831      65.2595     268.3454     189.4250      50.7829       0.0564       0.0637       0.1073       5.2643    2527.0107      23.5421     139.0000    3635.0000
 2300.9352      25.1983      47.4676     106.0983     132.6301      51.1026      19.5685     216.0000       0.2015       0.1361       0.1047      14.6380      64.9788     276.7184     242.2216      50.7829       0.0814       0.0925       0.1384       5.6118    2477.2209      27.0483     140.0625    3572.0000
 2301.0876      28.1960      67.7319     131.3928     118.6115      81.3637      12.2905     216.0000       0.2395       0.1772       0.1473      14.4613      63.5976     280.0677     258.0609      50.7829       0.1487       0.1679       0.2186       5.8755    2407.0071      12.2692     141.0000    3571.0000
 2301.2400      39.2343      59.2903     150.7594     100.9855      74.3463      13.4506     216.0000       0.2362       0.1736       0.1436      14.2744      63.5607     278.9513     259.1364      50.7829       0.1451       0.1640       0.2144       5.8732    2413.0591       7.6400     141.3125    3611.0000
 2301.3924      47.2552      62.7929     167.6098      93.3596      74.2852      13.4616     216.0000       0.2096       0.1449       0.1138      14.2466      67.3301     271.6946     238.7922      50.7829       0.0849       0.0962       0.1428       5.6400    2462.2937       7.8031     143.1875    3613.0000
 2301.5448      53.7964      59.4617     145.9299      39.1773      40.0476      24.9703     216.0000       0.1625       0.0939       0.0610      14.3927      71.5535     300.7211     228.3621      50.7829       0.0903       0.1027       0.1493       5.3298    2549.4214      12.5836     144.6250    3632.0000
 2301.6972      56.7421      81.4338     130.2352      50.5109      39.7863      25.1343     216.0000       0.1528       0.0835       0.0501      14.4315      76.0199     281.7422     207.8567      50.7829       0.1065       0.1206       0.1690       5.1743    2567.2639      19.8091     147.1875    3685.0000
 2301.8496      59.2205     100.5174     249.5670      92.4791      59.2593      16.8750     216.0000       0.1912       0.1250       0.0931      14.5741      73.4108     290.6735     179.6646      50.7829       0.1008       0.1144       0.1621       5.2305    2496.3032      15.8452     148.3750    3607.0000
 2302.0020      59.7746     154.8768     423.7758     152.0075     110.3628       9.0610     216.0000       0.2382       0.1758       0.1459      14.4064      71.2214     278.3931     156.8072      50.7829       0.1070       0.1212       0.1696       5.3312    2409.3201       6.6408     147.3125    3626.0000
 2302.1544      51.1663     130.6965     305.4554     209.7870      97.2118      10.2868     216.0000       0.2508       0.1894       0.1600      14.4705      69.2327     273.3693     144.8777      50.7829       0.1199       0.1360       0.1849       5.2910    2386.0562       6.7104     149.4375    3591.0000
 2302.3068      44.2961     101.1260     229.8038     138.9834      71.4286      14.0000     216.0000       0.2219       0.1582       0.1275      14.3765      72.7646     273.3693     140.5373      50.7829       0.1228       0.1390       0.1884       5.0488    2439.5486       7.1148     151.6250    3603.0000
 2302.4592      49.2929      36.5484      68.5004      64.4230      38.4116      26.0338     216.0000       0.1990       0.1334       0.1019      14.4580      72.1179     298.4883     121.9590      50.7829       0.1489       0.1680       0.2190       4.7872    2481.8264      15.6006     152.5000    3630.0000
 2302.6116      51.3522      55.9554     156.4194     123.2350      51.1890      19.5355     216.0000       0.2273       0.1640       0.1336      14.5117      73.4976     286.2079      66.5493      50.7829       0.1533       0.1731       0.2243       4.5785    2429.5239      14.5962     160.2500    3662.0000
 2302.7640      77.1642      77.4233     192.7510     181.0837      87.7962      11.3900     216.0000       0.2665       0.2064       0.1776      14.3373      73.3451     278.3931      29.9988      50.7829       0.1167       0.1321       0.1813       4.6216    2356.9915      14.9878     152.5625    3715.0000
 2302.9164      54.0219      68.3235     220.6467     205.9220     120.4857       8.2997     216.0000       0.2978       0.2403       0.2127      14.1266      71.4885     277.8349      44.5116      50.7829       0.1130       0.1280       0.1768       5.0405    2299.0842      10.5449     160.1250    3702.0000
 2303.0688      58.3191      75.6391     245.7425     209.3470     171.5655       5.8287     216.0000       0.3065       0.2497       0.2224      13.9876      68.2783     275.6021     117.4991      50.7829       0.1180       0.1336       0.1826       5.6730    2283.0388       9.4236     159.9375    3675.0000
 2303.2212      53.6627      72.0794     247.6266     209.4880     207.9194       4.8096     216.0000       0.3194       0.2636       0.2369      14.0415      62.5832     275.0439     195.3228      50.7829       0.0962       0.1092       0.1566       6.2493    2259.1973       7.9677     155.5625    3705.0000
 2303.3736      49.6876      96.6252     353.3328     256.2245     300.3005       3.3300     216.0000       0.3377       0.2835       0.2574      14.0903      66.9927     320.5372     222.0948      50.7829       0.0710       0.0806       0.1256       6.4293    2225.2927       6.8623     158.7500    3709.0000
 2303.5260      54.4257     132.8178     428.5077     257.0462     342.1704       2.9225     216.0000       0.3137       0.2576       0.2306      14.3374      66.7517     320.2581     200.5422      50.7829       0.0884       0.1005       0.1471       6.1594    2269.5881       5.3171     155.0625    3598.0000
 2303.6784      66.7522     171.6939     284.9239     250.8165     334.9727       2.9853     216.0000       0.2404       0.1782       0.1483      14.4862      70.9786     307.9777     144.3915      50.7829       0.1668       0.1878       0.2393       5.4135    2405.2302       6.1980     153.5625    3625.0000
 2303.8308      71.5614     193.0374    1160.7926     782.6834     566.6031       1.7649     216.0000       0.1598       0.0911       0.0580      14.5268      68.8257     289.5571      78.3057      50.7829       0.1879       0.2107       0.2633       4.4256    2554.2939      11.5254     151.8750    3709.0000
 2303.9832      77.6964     186.8474     731.6521     498.9980     429.9056       2.3261     216.0000       0.1268       0.0553       0.0210      14.4205      67.0614     287.3243      24.2209      50.7829       0.1021       0.1158       0.1637       3.6918    2615.4246      62.0956     146.6250    3645.0000
 2304.1356      77.7978     163.0985     602.8254     456.2383     323.2442       3.0936     216.0000       0.1257       0.0541       0.0198      14.1273      61.9826     273.9275       6.4094      50.7829       0.0760       0.0865       0.1318       3.5823    2617.4094     282.3113     146.5000    3787.0000
 2304.2880      68.3120     120.9235     443.4705     387.2998     322.2234       3.1034     216.0000       0.1310       0.0598       0.0256      13.9343      53.6867     280.6259      45.2161      50.7829       0.0521       0.0603       0.1019       4.0129    2607.7017     147.3115     149.3750    3739.0000
 2304.4404      57.3956     121.9126     315.1213     342.3424     248.3588       4.0264     216.0000       0.1534       0.0841       0.0508      13.8862      53.6580     270.5782     102.1473      50.7829       0.0421       0.0490       0.0892       4.7253    2566.2490     101.8191     145.7500    3854.0000
 2304.5928      58.8458     104.6823     256.8650     133.1286     233.5188       4.2823     216.0000       0.1583       0.0894       0.0562      13.8581      50.0952     270.5782     176.8837      50.7829       0.0458       0.0533       0.0939       5.3322    2557.1897      26.8158     144.1250    3824.0000
 2304.7452      44.9325      63.8766     126.0417     150.6889     105.4674       9.4816     216.0000       0.1884       0.1219       0.0900      14.1134      53.5530     277.5558     202.1847      50.7829       0.0881       0.1017       0.1467       5.7974    2501.4836      23.8904     142.6250    3755.0000
 2304.8976      33.9167      50.5104      94.3501     140.6657      86.8723      11.5111     216.0000       0.2193       0.1554       0.1247      14.4361      54.2779     266.1126     205.6668      50.7829       0.0917       0.1053       0.1510       6.1228    2444.2385      11.0608     140.6875    3807.0000
 2305.0500      29.9886      47.1137      78.8100      96.1182      59.7752      16.7293     216.0000       0.2560       0.1951       0.1658      14.5563      56.4195     280.0677     212.4226      50.7829       0.0488       0.0559       0.0976       6.4102    2376.3589      10.3885     145.1250    3739.0000
 2305.2024      29.2396      48.3763      75.3932      81.1023      56.9604      17.5560     216.0000       0.3181       0.2623       0.2354      14.6874      57.1974     280.6259     215.0552      50.7829       0.0641       0.0739       0.1170       6.7630    2261.5156       5.3034     148.3125    3718.0000
 2305.3548      24.7369      38.3748      70.7132      69.4633      59.2678      16.8726     216.0000       0.3908       0.3409       0.3169      14.4968      60.3370     290.1153     219.3662      50.7829       0.0732       0.0843       0.1284       7.1566    2127.1042       3.1840     142.8125    3748.0000
 2305.5072      18.1691      53.6558      63.8986      63.3520      62.0335      16.1203     216.0000       0.4868       0.4448       0.4246      14.0885      67.4785     306.3031     176.0745      50.7829       0.0863       0.0981       0.1444       7.3921    1949.4529       2.0831     141.3125    3724.0000
 2305.6596      19.0520      42.8124      40.0312      44.2229      36.9893      27.0348     216.0000       0.5226       0.4835       0.4647      13.5854      74.0229     320.8163     131.3071      50.7829       0.1283       0.1451       0.1951       7.2496    1883.2360       1.8309     137.6250    3732.0000
 2305.8120      21.7912      25.2019      34.6239      48.2401      46.4339      21.5360     216.0000       0.4732       0.4300       0.4093      13.7269      76.6207     334.2131      87.7323      50.7829       0.2859       0.3206       0.3719       6.5856    1974.6150       2.0150     140.3750    3749.0000
 2305.9644      29.2663      36.5032      63.2577      78.8562      63.9266      15.6429     216.0000       0.3490       0.2957       0.2701      13.5972      79.7003     352.3546      56.9205      50.7829       0.3829       0.4207       0.4718       5.5965    2204.2954       3.0146     141.0000    3806.0000
 2306.1168      40.0845      78.0748      83.3874      96.6144     105.3994       9.4877     216.0000       0.2050       0.1399       0.1087      13.5238      79.2464     376.0782      35.7547      50.7829       0.1039       0.1176       0.1659       4.6348    2470.6997       6.6487     138.9375    3777.0000
 2306.2692      48.7245      97.6456     228.6962     298.5658     258.5871       3.8672     216.0000       0.1334       0.0625       0.0284      13.5130      82.0886     296.8137      18.4419      50.7829       0.0412       0.0456       0.0878       4.0484    2603.1523      43.8731     140.4375    3744.0000
 2306.4216      36.7723      85.4180     201.1580     177.1414     198.2298       5.0447     216.0000       0.1346       0.0638       0.0297      13.4424      78.0050     288.9989      21.0695      50.7829       0.0872       0.0990       0.1456       3.9858    2600.9768      85.4784     139.6875    3777.0000
 2306.5740      30.1408      57.7953     120.9399     104.9009     107.7224       9.2831     216.0000       0.1565       0.0874       0.0542      13.6549      79.7523     292.3481      53.4825      50.7829       0.1619       0.1823       0.2338       4.1919    2560.5317      12.8238     137.6250    3805.0000
 2306.7264      25.5662      33.0186      54.6956      41.0410      40.2396      24.8511     216.0000       0.1607       0.0920       0.0589      13.5642      77.1599     291.2317      94.2461      50.7829       0.1601       0.1806       0.2321       4.4591    2552.7390      12.3359     139.3750    3820.0000
 2306.8788      32.5288      57.0823     141.7725     126.4225      63.5485      15.7360     216.0000       0.1562       0.0871       0.0539      13.5798      74.2705     305.4658     125.6356      50.7829       0.1484       0.1676       0.2186       4.5958    2561.1045      12.8871     133.8750    3863.0000
 2307.0312      43.3902      98.7152     201.5706     145.5558     137.4789       7.2738     216.0000       0.1580       0.0890       0.0559      13.6885      75.5684     292.3481     135.2937      50.7829       0.1241       0.1405       0.1902       4.5887    2557.7292      23.1626     139.4375    3801.0000
 2307.1836      43.1323      82.0150     279.1193     199.7104     138.6250       7.2137     216.0000       0.1578       0.0889       0.0557      13.8906      76.7888     280.6259     111.8934      50.7829       0.1487       0.1678       0.2188       4.3721    2558.0513      21.5676     137.5625    3789.0000
 2307.3360      42.1777      86.8006     350.6041     228.1505     191.0750       5.2335     216.0000       0.1692       0.1012       0.0685      13.9581      75.3443     287.8825      62.3415      50.7829       0.1544       0.1745       0.2250       4.0261    2536.9106      28.4643     139.0000    3742.0000
 2307.4884      45.9648     103.2763     553.4077     347.4061     263.0213       3.8020     216.0000       0.1852       0.1185       0.0865      14.0920      62.5832     277.8349      19.5839      50.7829       0.0663       0.0767       0.1198       3.7043    2507.3521      57.2132     137.4375    3822.0000
 2307.6408      47.4218     122.6395     721.4435     494.2704     322.4233       3.1015     216.0000       0.1999       0.1344       0.1030      13.8561      48.7291     292.3481       0.2933      50.7829       0.0273       0.0328       0.0701       3.5640    2480.1323      51.3432     138.8750    3760.0000
 2307.7932      49.5448     139.9429    1567.3842    1351.3573     699.0671       1.4305     216.0000       0.1986       0.1330       0.1015      13.4455      42.2560     285.6496       1.3905      50.7829       0.0187       0.0236       0.0590       3.5984    2482.6038      56.4055     134.2500    3795.0000
 2307.9456      50.3763     141.7091     777.3354     564.7084     420.3136       2.3792     216.0000       0.1948       0.1288       0.0972      13.1944      38.1942     273.3693      11.6029      50.7829       0.0276       0.0338       0.0706       3.8692    2489.6772      62.3268     138.7500    3750.0000
 2308.0980      46.6787     114.1045     391.8029     311.7331     171.9374       5.8161     216.0000       0.1812       0.1141       0.0819      13.1983      45.5028     287.3243      55.2540      50.7829       0.0335       0.0401       0.0782       4.3139    2514.8264      57.3297     133.7500    3731.0000
 2308.2504      46.4727     106.9322     315.8759     246.3147     105.4447       9.4836     216.0000       0.1568       0.0878       0.0546      13.2106      48.5807     281.7422     120.6641      50.7829       0.0737       0.0851       0.1289       4.8309    2559.9255      53.9567     134.9375    3700.0000
 2308.4028      52.2853     134.9624     414.3268     236.1328     174.6725       5.7250     216.0000       0.1169       0.0446       0.0098      13.3551      55.6935     291.5108     174.2945      50.7829       0.1107       0.1262       0.1739       5.1817    2633.7727      43.9648     131.5625    3709.0000
 2308.5552      61.2357     193.4189     390.7669     203.3160     160.2091       6.2418     216.0000       0.0919       0.0176      -0.0181      13.5962      59.3477     287.3243     181.1218      50.7829       0.1068       0.1213       0.1692       5.3072    2679.9128      50.0471     126.6250    3781.0000
 2308.7076      65.8243     266.6616     525.6727     217.8584     211.2956       4.7327     216.0000       0.0849       0.0100      -0.0260      13.4874      67.2326     275.0439     159.1666      50.7829       0.1016       0.1153       0.1630       5.2469    2692.8960      39.4363     126.1875    3848.0000
 2308.8600      62.1425     271.8512     355.9718     264.3790     165.0594       6.0584     216.0000       0.0901       0.0156      -0.0202      13.3765      70.5391     263.8798     123.9567      50.7829       0.0917       0.1042       0.1511       5.0486    2683.2722      22.5259     121.7500    3887.0000
 2309.0124      61.7869     314.0947     450.1138     227.9647     201.0372       4.9742     216.0000       0.1011       0.0275      -0.0078      13.3093      69.1591     270.5782      78.3863      50.7829       0.1005       0.1142       0.1617       4.7698    2662.9158      21.0955     123.8750    3901.0000
 2309.1648      80.6778     379.0135     447.8112     178.1843     141.7036       7.0570     216.0000       0.1044       0.0311      -0.0041      13.1876      65.9523     270.5782      33.7579      50.7829       0.1101       0.1251       0.1732       4.5286    2656.8228      28.6892     121.9375    3925.0000
 2309.3172      82.7537     513.2571     715.9189     299.4294     203.1009       4.9237     216.0000       0.1060       0.0328      -0.0024      13.3011      61.7991     258.2978       8.0326      50.7829       0.1159       0.1313       0.1802       4.4773    2653.9126      93.7204     122.3125    3932.0000
 2309.4696      81.2707     249.8545     443.5831     251.9319     174.8613       5.7188     216.0000       0.1237       0.0519       0.0175      13.3676      56.0736     257.7396      14.0204      50.7829       0.0932       0.1059       0.1528       4.7398    2621.1953     190.9322     121.7500    3912.0000
 2309.6220      58.4059     104.6817     156.5227     104.1672      82.6068      12.1055     216.0000       0.1425       0.0723       0.0385      13.4461      54.7907     253.2740      41.3249      50.7829       0.0648       0.0737       0.1178       5.1120    2586.4297      21.0888     123.8125    3779.0000
 2309.7744      52.6048      97.4316     139.6519      81.5125      59.2137      16.8880     216.0000       0.1239       0.0521       0.0177      13.4262      58.6883     254.3904      83.9550      50.7829       0.0872       0.0998       0.1456       5.3457    2620.8572      17.9945     124.4375    3742.0000
 2309.9268      96.0960     231.7971     444.8555     266.3565     155.0277       6.4505     216.0000       0.0873       0.0126      -0.0233      13.3028      59.5323     271.1364      92.3491      50.7829       0.1045       0.1194       0.1664       5.2451    2688.5132      17.8440     121.9375    3772.0000
 2310.0792      96.0625     306.4607     820.3397     487.6380     343.1797       2.9139     216.0000       0.0531      -0.0245      -0.0617      13.2293      59.7587     248.2502      71.7020      50.7829       0.1136       0.1288       0.1775       4.9661    2751.8201     129.2431     122.5000    3793.0000
 2310.2316      98.2837     452.9323    1950.0000    1607.0472    1177.9703       0.8489     216.0000       0.0651      -0.0114      -0.0482      13.0672      59.1094     247.1338      24.0433      50.7829       0.1131       0.1281       0.1768       4.6871    2729.5051     435.6712     121.7500    3902.0000
 2310.3840     101.8030     501.8133    1950.0000    1950.0000    1950.0000       0.5025     216.0000       0.0721      -0.0039      -0.0404      12.8744      60.3977     247.1338       2.6588      50.7829       0.0868       0.0989       0.1451       4.5448    2716.5984     485.2007     120.5625    3851.0000
 2310.5364     101.1271     486.6654    1500.6472     819.6644     712.0170       1.4045     216.0000       0.0791       0.0037      -0.0325      13.0039      57.1494     247.6920      -4.4343      50.7829       0.0651       0.0759       0.1184       4.4885    2703.6567     555.1592     116.2500    3866.0000
 2310.6888     102.9440     465.1236    1455.2330     682.6266     630.5411       1.5859     216.0000       0.0817       0.0065      -0.0297      12.9364      54.7479     247.6920      -2.0330      50.7829       0.0419       0.0497       0.0890       4.4844    2698.9236     737.7093     118.1250    3866.0000
 2310.8412     105.7454     469.5923    1557.0253     612.7801     573.1969       1.7446     216.0000       0.0840       0.0090      -0.0270      12.9636      56.4728     248.2502      11.5023      50.7829       0.0393       0.0469       0.0857       4.4853    2694.6287     941.9602     118.3125    3828.0000
 2310.9936     110.3352     517.7117    1644.2546     381.3127     381.7849       2.6193     216.0000       0.0825       0.0074      -0.0287      12.7884      56.2698     247.4129      21.1022      50.7829       0.0481       0.0567       0.0970       4.4585    2697.4260    1053.0798     116.3750    3851.0000
 2311.1460     120.9602     663.0311    1014.1310     511.6040     458.4272       2.1814     216.0000       0.0803       0.0050      -0.0312      12.6422      58.3038     246.5756      16.2816      50.7829       0.0489       0.0577       0.0980       4.4213    2701.4868    1059.7861     116.3750    3814.0000
 2311.2984     122.1475     747.9926    1934.8411     571.6384     486.3463       2.0561     216.0000       0.0731      -0.0028      -0.0392      12.8016      55.6112     246.0174       3.6705      50.7829       0.0476       0.0562       0.0963       4.3360    2714.7427    1067.1083     118.6875    3773.0000
 2311.4508     129.5347     921.3284    1609.2427     647.5282     508.8474       1.9652     216.0000       0.0765       0.0009      -0.0355      12.8041      55.2375     243.7846      -5.9924      50.7829       0.0468       0.0558       0.0954       4.3420    2708.5134    1035.7391     116.8750    3810.0000
 2311.6032     136.6056     899.9659    1950.0000     857.2932     582.7099       1.7161     216.0000       0.0804       0.0051      -0.0311      13.0313      51.5764     242.6682      -4.3070      50.7829       0.0503       0.0601       0.0999       4.3654    2701.3191     808.6258     114.3125    3862.0000
 2311.7556     139.5455     749.2324    1950.0000     572.9362     470.9403       2.1234     216.0000       0.0860       0.0111      -0.0248      12.9967      53.0508     242.1100      -3.9651      50.7829       0.0465       0.0556       0.0950       4.4097    2690.9597     854.2827     117.8750    3918.0000
 2311.9080     140.8776     627.5379    1881.7671     501.4670     372.2977       2.6860     216.0000       0.0828       0.0077      -0.0284      13.0868      52.6125     241.5518      -2.2049      50.7829       0.0403       0.0480       0.0870       4.3771    2696.8125     838.0933     112.0000    4006.0000
 2312.0604     142.5682     568.0184    1950.0000     499.7026     318.7264       3.1375     216.0000       0.0801       0.0048      -0.0314      12.9535      54.8498     244.3428      -2.3935      50.7829       0.0459       0.0546       0.0942       4.3217    2701.7917    1128.6150     113.2500    4011.0000
 2312.2128     143.3334     562.6918    1950.0000     359.3234     289.0588       3.4595     216.0000       0.0792       0.0038      -0.0324      12.8790      53.6075     243.2264      -3.6235      50.7829       0.0460       0.0545       0.0943       4.2523    2703.4534    1074.5535     115.1875    3993.0000
 2312.3652     142.6704     596.1420    1950.0000     406.0193     319.9113       3.1259     216.0000       0.0829       0.0078      -0.0283      12.5797      57.0967     243.7846      -5.8343      50.7829       0.0547       0.0644       0.1053       4.2020    2696.6853     970.0061     115.1250    3947.0000
 2312.5176     139.2670     642.9210    1950.0000     534.0977     390.2837       2.5622     216.0000       0.0773       0.0017      -0.0346      12.3049      56.0459     244.0637      -4.7600      50.7829       0.0614       0.0722       0.1138       4.0859    2707.0093     908.8101     115.0625    3842.0000
 2312.6700     132.7629     671.6675    1950.0000     556.2988     316.8598       3.1560     216.0000       0.0744      -0.0014      -0.0378      11.9482      55.4612     244.3428      -4.2977      50.7829       0.0451       0.0529       0.0931       3.9984    2712.3445     846.4157     115.6875    3744.0000
 2312.8224     124.2077     670.4310    1950.0000     554.9824     272.8277       3.6653     216.0000       0.0736      -0.0022      -0.0387      12.0643      56.2409     244.3428      -4.2207      50.7829       0.0532       0.0624       0.1034       3.9262    2713.7747     839.6100     113.5000    3777.0000
 2312.9748     115.0475     651.4910    1950.0000     534.4117     245.2196       4.0780     216.0000       0.0793       0.0039      -0.0323      12.3619      58.1053     244.9010      -4.6058      50.7829       0.0550       0.0649       0.1058       3.8890    2703.3000     742.8804     113.6250    3757.0000
 2313.1272     106.2362     629.1586    1950.0000     610.1046     240.8254       4.1524     216.0000       0.0790       0.0036      -0.0326      12.6315      59.3576     246.0174      -2.8884      50.7829       0.0510       0.0606       0.1007       3.7809    2703.8276     682.3602     118.4375    3773.0000
 2313.2796      98.1040     601.5259    1950.0000     735.2661     273.4014       3.6576     216.0000       0.0750      -0.0007      -0.0371      12.6416      56.3067     246.0174      -0.7620      50.7829       0.0454       0.0548       0.0937       3.6587    2711.1917     684.3660     114.8125    3782.0000
 2313.4320      90.6808     556.0057    1950.0000     623.2170     279.1306       3.5826     216.0000       0.0727      -0.0032      -0.0397      12.7150      53.5846     246.0174      -0.4637      50.7829       0.0325       0.0394       0.0770       3.5692    2715.5361     789.7711     120.5000    3744.0000
 2313.5844      83.9238     484.8836    1950.0000     504.9048     253.6161       3.9430     216.0000       0.0791       0.0037      -0.0325      12.6893      50.7081     245.4592      -0.5710      50.7829       0.0384       0.0466       0.0847       3.5865    2703.6970     841.9149     113.3125    3762.0000
 2313.7368      77.7354     395.6392    1950.0000     882.7289     377.3247       2.6502     216.0000       0.0838       0.0088      -0.0273      12.7892      49.0840     245.4592       6.3519      50.7829       0.0395       0.0475       0.0860       3.5764    2695.0110     823.7567     118.3125    3747.0000
 2313.8892      72.0709     308.4971    1950.0000    1215.6398     379.6998       2.6337     216.0000       0.0892       0.0146      -0.0212      12.6884      45.5009     246.0174      10.6921      50.7829       0.0424       0.0511       0.0899       3.5483    2685.0405     777.8036     119.3125    3775.0000
 2314.0416      67.0404     239.7348    1950.0000    1108.5156     568.2196       1.7599     216.0000       0.0957       0.0217      -0.0139      12.4302      44.6888     244.9010       9.7222      50.7829       0.0365       0.0445       0.0823       3.4758    2672.9497     751.2691     121.6250    3772.0000
 2314.1940      62.8505     193.2826    1950.0000    1250.8989     552.5177       1.8099     216.0000       0.1118       0.0391       0.0041      12.5370      43.0647     245.4592       7.1058      50.7829       0.0314       0.0391       0.0758       3.4673    2643.2217     688.0034     121.7500    3777.0000
 2314.3464      59.6490     165.9039    1950.0000    1533.5406     686.3034       1.4571     216.0000       0.1301       0.0589       0.0247      12.4320      44.8952     244.9010      13.8400      50.7829       0.0331       0.0415       0.0781       3.5651    2609.2468     488.3494     121.7500    3814.0000
 2314.4988      57.4025     153.3128    1950.0000    1734.4135     737.9247       1.3552     216.0000       0.1448       0.0748       0.0412      12.3828      43.7387     248.8084      49.2194      50.7829       0.0282       0.0357       0.0716       3.8170    2582.0393     468.5167     121.7500    3773.0000
 2314.6512      55.9076     152.5502    1950.0000    1788.4602     810.8207       1.2333     216.0000       0.1527       0.0834       0.0500      11.9790      45.1903     257.7396      87.7981      50.7829       0.0286       0.0368       0.0724       4.1162    2567.4387     459.9189     123.3750    3769.0000
 2314.8036      54.9064     161.9593    1950.0000    1697.0012     768.0002       1.3021     216.0000       0.1480       0.0782       0.0447      11.8037      46.0038     259.4142     129.5874      50.7829       0.0231       0.0300       0.0651       4.3614    2576.2009     648.5652     125.3750    3728.0000
 2314.9560      54.2239     180.1819    1950.0000    1571.0660     701.5146       1.4255     216.0000       0.1391       0.0686       0.0347      11.7353      46.1453     256.9023     150.7442      50.7829       0.0247       0.0315       0.0671       4.4789    2592.7058     641.6464     127.1250    3739.0000
 2315.1084      53.8337     204.5874    1950.0000    1413.3657     628.5253       1.5910     216.0000       0.1305       0.0593       0.0251      12.0432      44.2626     259.9724     161.6228      50.7829       0.0283       0.0360       0.0718       4.5249    2608.6353     735.9651     130.6250    3777.0000
 2315.2608      53.7989     229.1818    1950.0000    1280.9447     552.8486       1.8088     216.0000       0.1248       0.0532       0.0187      12.5064      38.7507     259.4142     163.8198      50.7829       0.0277       0.0349       0.0710       4.5524    2619.0950     737.5161     123.8125    3804.0000
 2315.4132      54.0817     242.9741    1950.0000    1186.5132     609.1617       1.6416     216.0000       0.1191       0.0469       0.0123      12.5337      37.3524     259.9724     162.2021      50.7829       0.0344       0.0433       0.0798       4.5662    2629.7378     691.8375     131.5625    3841.0000
 2315.5656      54.4512     236.0101    1950.0000    1064.0638     459.9959       2.1739     216.0000       0.1138       0.0412       0.0064      12.5343      35.1672     259.4142     158.8533      50.7829       0.0296       0.0369       0.0734       4.5591    2639.4702     548.5053     131.5625    3870.0000
 2315.7180      54.5525     211.3952    1843.6978    1128.7947     538.8414       1.8558     216.0000       0.1025       0.0290      -0.0063      12.4018      38.2125     259.4142     167.8641      50.7829       0.0179       0.0225       0.0578       4.5469    2660.4619     423.3434     133.1875    3780.0000
 2315.8704      54.1115     182.9005    1562.8221     955.0765     473.4092       2.1123     216.0000       0.0900       0.0155      -0.0203      12.0034      41.7901     259.9724     178.5786      50.7829       0.0355       0.0433       0.0810       4.5453    2683.5178     400.0691     134.0000    3791.0000
 2316.0228      53.1809     160.5839    1121.5500     597.1831     271.5930       3.6820     216.0000       0.0747      -0.0010      -0.0374      11.7821      45.6246     255.5068     200.5706      50.7829       0.0495       0.0601       0.0990       4.6151    2711.7305     450.7245     135.2500    3774.0000
 2316.1752      51.0952     144.9034     801.4234     516.0988     267.0726       3.7443     216.0000       0.0751      -0.0006      -0.0370      11.8514      46.4641     259.4142     211.7779      50.7829       0.0419       0.0512       0.0893       4.7684    2711.1021     598.1234     134.8750    3733.0000
 2316.3276      50.4299     130.8614     609.4612     414.0902     225.2735       4.4390     216.0000       0.0807       0.0055      -0.0307      12.1857      51.5698     261.0888     227.8869      50.7829       0.0409       0.0495       0.0880       4.9888    2700.6782     151.4579     137.9375    3794.0000
 2316.4800      45.9276     111.7481     558.9777     362.6926     251.1217       3.9821     216.0000       0.0943       0.0201      -0.0155      12.4136      59.1255     269.4618     237.9577      50.7829       0.0479       0.0570       0.0968       5.2272    2675.6042      88.0808     138.2500    3743.0000
 2316.6324      45.4567      99.5110     426.1013     284.0302     146.9099       6.8069     216.0000       0.1126       0.0399       0.0050      12.3646      72.9564     265.2753     243.3681      50.7829       0.0468       0.0552       0.0953       5.4012    2641.7209      42.0277     141.3125    3810.0000
 2316.7848      46.6091      76.8304     283.3362     193.1480      99.3220      10.0683     216.0000       0.0972       0.0233      -0.0122      12.1276      83.3336     285.9287     264.4079      50.7829       0.0535       0.0627       0.1038       5.4347    2670.0996      31.6778     139.9375    3851.0000
 2316.9372      42.9771      88.1134     407.0861     227.8527      91.5667      10.9210     216.0000       0.0781       0.0026      -0.0336      11.7407      88.3649     296.8137     280.1144      50.7829       0.0602       0.0698       0.1122       5.3621    2705.4873      33.4619     141.3125    3815.0000
 2317.0896      45.0293      93.8139     535.9998     351.6120     110.0724       9.0849     216.0000       0.0499      -0.0279      -0.0653      11.4571      92.3806     284.5333     303.8485      50.7829       0.0963       0.1098       0.1566       5.2681    2757.7046      53.4416     143.6875    3818.0000
 2317.2420      48.0004     106.2986     734.7107     476.6431     151.2920       6.6097     216.0000       0.0529      -0.0247      -0.0619      11.3010      87.1509     292.0690     310.3848      50.7829       0.1196       0.1355       0.1845       5.2612    2752.1616     121.9655     134.9375    3733.0000
 2317.3944      49.9859     112.9462     978.7147     704.3613     170.0358       5.8811     216.0000       0.0598      -0.0171      -0.0541      11.3501      82.3230     280.6259     309.6349      50.7829       0.1420       0.1604       0.2110       5.3010    2739.3232     138.3664     141.3125    3625.0000
 2317.5468      50.5841     116.3020    1024.0110     978.1782     162.7911       6.1428     216.0000       0.0803       0.0050      -0.0312      11.3819      74.8028     280.0677     288.3296      50.7829       0.1303       0.1473       0.1972       5.3459    2701.4338     128.8984     142.1875    3640.0000
 2317.6992      49.3625     117.4386     788.2839    1214.1777     193.7917       5.1602     216.0000       0.1037       0.0304      -0.0049      11.9090      81.9555     280.0677     255.9361      50.7829       0.0910       0.1033       0.1502       5.3409    2658.0791     109.4514     144.9375    3661.0000
 2317.8516      46.4302     112.5241     497.3583    1316.4000     278.8146       3.5866     216.0000       0.1117       0.0390       0.0041      12.2467      81.7080     282.8586     244.6959      50.7829       0.0768       0.0873       0.1328       5.3204    2643.2778      87.1866     141.3125    3670.0000
 2318.0040      40.6582     105.9594     303.3903    1200.2439     265.7155       3.7634     216.0000       0.1154       0.0429       0.0081      12.1842      83.1785     292.3481     242.3201      50.7829       0.0757       0.0861       0.1314       5.3124    2636.5579      58.6046     148.1875    3693.0000
 2318.1564      33.9753      80.9547     202.2276    1011.4532     270.7697       3.6932     216.0000       0.1258       0.0543       0.0199      12.1534      74.1952     290.6735     245.7066      50.7829       0.1152       0.1305       0.1793       5.3616    2617.2192      25.0347     143.5000    3709.0000
 2318.3088      30.0134      57.4283     176.7455     915.9678     320.9939       3.1153     216.0000       0.1607       0.0920       0.0590      11.9534      81.3008     305.1867     230.1114      50.7829       0.1639       0.1846       0.2360       5.4630    2552.6797      13.8993     149.4375    3694.0000
 2318.4612      31.4039      57.1988     105.5497     539.0666     205.0177       4.8776     216.0000       0.1662       0.0980       0.0652      11.8927      80.4393     303.5121     232.1189      50.7829       0.1082       0.1228       0.1709       5.5085    2542.4468      11.7291     143.8125    3719.0000
 2318.6136      29.3035      43.1721     104.0312     570.1854     298.2190       3.3532     216.0000       0.1473       0.0775       0.0439      11.6898      80.1906     304.0703     248.4028      50.7829       0.0639       0.0726       0.1167       5.4902    2577.5522      15.9092     149.5625    3705.0000
 2318.7660      29.4569      47.4783     159.3515     420.2406     370.2663       2.7008     216.0000       0.1234       0.0516       0.0172      11.3439      73.6941     310.7687     269.5711      50.7829       0.0869       0.0991       0.1451       5.4451    2621.6948      28.9434     142.1250    3740.0000
 2318.9184      34.1450      48.4027     214.5076     302.4260     433.8575       2.3049     216.0000       0.1318       0.0607       0.0265      11.5816      69.8775     306.0240     270.3889      50.7829       0.0803       0.0914       0.1370       5.4708    2606.2395      39.2355     141.6250    3771.0000
 2319.0708      33.2573      58.2379     382.9177     314.9670     518.2091       1.9297     216.0000       0.1694       0.1014       0.0687      11.3338      73.3292     314.6761     232.7404      50.7829       0.0862       0.0982       0.1443       5.5081    2536.5896      16.7587     144.6250    3755.0000
 2319.2232      31.8217      52.9223     540.0275     128.1246     446.0936       2.2417     216.0000       0.1531       0.0837       0.0504      11.6267      81.0438     304.0703     219.7368      50.7829       0.0872       0.0990       0.1455       5.4400    2566.7996      13.2173     146.8125    3767.0000
 2319.3756      29.0302      45.0670     580.2230     251.2769     227.8601       4.3887     216.0000       0.1151       0.0426       0.0078      11.8619      83.0777     328.0729     215.5175      50.7829       0.1129       0.1279       0.1767       5.2869    2637.1357      14.5621     145.5000    3678.0000
 2319.5280      27.4933      36.9462     569.0555     147.3021     150.0650       6.6638     216.0000       0.0654      -0.0111      -0.0479      11.7536      80.5032     307.9777     239.8877      50.7829       0.1709       0.1922       0.2442       5.1333    2728.9993      30.3248     146.0000    3630.0000
 2319.6804      25.3867      32.8642     508.6384     196.3284     116.3199       8.5970     216.0000       0.0488      -0.0290      -0.0665      11.3732      71.8168     315.2343     267.5746      50.7829       0.1759       0.1982       0.2503       5.0984    2759.6528      62.2217     144.5000    3631.0000
 2319.8328      23.9101      31.5558     435.5465     273.7679      91.5650      10.9212     216.0000       0.0468      -0.0312      -0.0687      11.0165      73.2406     306.3031     297.6689      50.7829       0.1550       0.1749       0.2262       5.1568    2763.4045      75.7537     141.3125    3679.0000
 2319.9852      24.7512      36.2720     436.2083     399.9419      67.5434      14.8053     216.0000       0.0570      -0.0202      -0.0573      10.9661      72.7700     309.6523     297.2527      50.7829       0.1131       0.1280       0.1770       5.2546    2744.5110      57.7710     143.0625    3719.0000
 2320.1376      25.3291      42.6207     574.0109     606.9209      72.7897      13.7382     216.0000       0.0854       0.0105      -0.0255      10.9829      77.6645     316.3507     240.5281      50.7829       0.1042       0.1180       0.1662       5.2799    2692.0374      23.6724     141.3125    3770.0000
 2320.2900      26.8146      61.4534     723.2399     843.3880     119.3510       8.3787     216.0000       0.1188       0.0466       0.0120      11.1189      76.1962     310.7687     158.9901      50.7829       0.1179       0.1335       0.1826       5.2275    2630.2307      13.4691     141.3125    3750.0000
 2320.4424      28.5575      91.6184    1580.2147    1517.7159     321.8299       3.1072     216.0000       0.1435       0.0734       0.0397      11.2323      74.6147     315.2343     107.8532      50.7829       0.1248       0.1412       0.1907       5.1942    2584.4490      13.0384     141.3125    3711.0000
 2320.5948      30.5837     131.5985    1950.0000    1877.2045     330.5824       3.0250     216.0000       0.1435       0.0733       0.0396      11.7337      65.4488     314.1179     120.7468      50.7829       0.1070       0.1212       0.1697       5.2738    2584.6050      20.3452     138.5625    3616.0000
 2320.7472      31.2327     147.7074    1950.0000     695.4703     241.9352       4.1333     216.0000       0.1289       0.0575       0.0233      11.9539      65.6519     320.2581     177.3651      50.7829       0.1214       0.1373       0.1867       5.4593    2611.5989      32.7022     141.3125    3536.0000
 2320.8996      30.5460     117.3961    1950.0000     221.1155     281.9953       3.5462     216.0000       0.1028       0.0294      -0.0059      12.0117      69.7928     313.5597     248.0266      50.7829       0.1055       0.1197       0.1677       5.6406    2659.7444      28.7129     142.7500    3515.0000
 2321.0520      29.2306      77.8203     381.9242     297.5607     533.5817       1.8741     216.0000       0.1089       0.0359       0.0009      11.7518      76.1779     310.7687     280.5746      50.7829       0.0888       0.1009       0.1475       5.7523    2648.5723      30.1876     141.3125    3554.0000
 2321.2044      25.2792      57.1819     192.2407     148.4053     297.1696       3.3651     216.0000       0.1283       0.0569       0.0226      11.1121      77.9829     290.6735     278.7905      50.7829       0.1209       0.1374       0.1860       5.7727    2612.7222      19.9311     140.5625    3798.0000
 2321.3568      23.6162      34.6752     127.4783     104.8424     256.0279       3.9058     216.0000       0.1309       0.0597       0.0255      11.0519      79.5371     307.4195     252.5413      50.7829       0.1077       0.1225       0.1703       5.6935    2607.8787      16.8050     141.3125    4016.0000
 2321.5092      21.9601      26.1277      93.5397     122.8496     197.5192       5.0628     216.0000       0.1156       0.0432       0.0084      10.8484      81.6432     301.2793     207.4749      50.7829       0.0737       0.0838       0.1290       5.5003    2636.1108      17.0273     142.7500    4325.0000
 2321.6616      20.1753      24.0174     105.7633     148.8143     163.9518       6.0994     216.0000       0.1021       0.0286      -0.0067      10.7538      83.6955     310.7687     165.3292      50.7829       0.0847       0.0964       0.1425       5.3217    2661.1196      39.9362     147.0000    4353.0000
 2321.8140      20.5968      22.2759      75.7032     123.3889      77.9018      12.8367     216.0000       0.1032       0.0298      -0.0055      11.0035      78.0126     299.3256     144.7067      50.7829       0.0795       0.0907       0.1361       5.2707    2659.0525      86.4293     144.7500    4273.0000
 2321.9664      18.5906      21.4085      95.6322     163.5776      78.6894      12.7082     216.0000       0.1292       0.0579       0.0236      11.0617      72.7342     288.4407     152.4773      50.7829       0.0694       0.0794       0.1235       5.4262    2611.0374     102.6521     144.9375    4145.0000
 2322.1188      21.1100      25.8579     134.8643     164.4041      79.4526      12.5861     216.0000       0.1882       0.1217       0.0898      11.3512      71.5659     289.5571     157.2261      50.7829       0.0671       0.0761       0.1207       5.6869    2501.8787      19.3524     147.5625    4084.0000
 2322.2712      24.8015      35.8257     161.9009     138.7310      62.3733      16.0325     216.0000       0.2529       0.1917       0.1623      11.0747      74.1504     297.3719     143.1441      50.7829       0.1269       0.1435       0.1934       5.8526    2382.1597       7.8809     144.1250    3999.0000
 2322.4236      28.8324      50.1769     296.4120     153.4295      94.4454      10.5881     216.0000       0.2808       0.2219       0.1936      10.9696      79.9309     288.4407     122.3855      50.7829       0.2982       0.3329       0.3847       5.8212    2330.6060       5.3579     144.1875    3816.0000
 2322.5760      31.0207      68.1446     285.6459     163.1402      68.5227      14.5937     216.0000       0.2385       0.1762       0.1462      10.5342      82.5203     289.8362     128.0117      50.7829       0.2002       0.2265       0.2782       5.6029    2408.7554       6.5063     145.9375    3846.0000
 2322.7284      36.1383     101.6342     379.2305     200.7021      70.3336      14.2180     216.0000       0.1742       0.1065       0.0741      10.5074      85.5655     299.0465     155.7326      50.7829       0.1555       0.1757       0.2270       5.3565    2527.8140      11.0114     147.3125    3830.0000
 2322.8808      29.6768     129.3984     313.8895     133.1315      64.1072      15.5989     216.0000       0.1244       0.0527       0.0183      10.7956      88.3690     301.2793     198.6012      50.7829       0.1536       0.1734       0.2246       5.1981    2619.8298      18.9168     147.0000    3791.0000
 2323.0332      30.2967     131.3039     418.6796     149.6065      74.0607      13.5024     216.0000       0.1238       0.0521       0.0176      10.8255      89.6442     320.2581     211.5025      50.7829       0.1458       0.1646       0.2155       5.1296    2620.9436      15.6341     148.5000    3728.0000
 2323.1856      32.0917      92.8668     294.0956     118.2336      86.5422      11.5551     216.0000       0.1421       0.0718       0.0381      10.9794      87.2080     295.6973     194.2570      50.7829       0.1558       0.1759       0.2272       5.0297    2587.1558      11.2999     147.0000    3694.0000
 2323.3380      34.6876      88.1791     367.6323     173.9625     131.8333       7.5853     216.0000       0.1371       0.0665       0.0325      11.1849      80.1674     295.6973     164.4993      50.7829       0.1828       0.2056       0.2579       4.7982    2596.3342      11.9047     150.2500    3746.0000
 2323.4904      37.9385      70.4944     410.5370     236.5832     164.6389       6.0739     216.0000       0.1247       0.0530       0.0186      11.1108      70.5686     300.7211     131.3157      50.7829       0.1498       0.1690       0.2199       4.5067    2619.3760      20.4430     148.0000    3786.0000
 2323.6428      40.8007      70.4075     481.5277     456.2985     227.3324       4.3988     216.0000       0.1107       0.0379       0.0029      10.9869      64.7188     306.3031     114.8789      50.7829       0.0826       0.0944       0.1398       4.3266    2645.1553      32.9199     147.9375    3993.0000
 2323.7952      44.2884      69.9541     492.5669     655.2406     240.3618       4.1604     216.0000       0.1299       0.0586       0.0244      10.3535      62.8100     304.0703     119.4725      50.7829       0.0396       0.0459       0.0859       4.4139    2609.7561      35.6966     152.1875    4139.0000
 2323.9476      42.6766      66.2359     338.9055     578.2490     179.7163       5.5643     216.0000       0.1220       0.0501       0.0156       9.9779      63.0130     322.2119     184.2456      50.7829       0.0458       0.0530       0.0939       4.7057    2624.3113      34.9160     146.5000    4119.0000
 2324.1000      47.6058      74.9212     275.8630     314.3028     132.5567       7.5439     216.0000       0.1224       0.0505       0.0160      10.0728      59.1572     304.3494     257.9413      50.7829       0.0927       0.1064       0.1523       5.0712    2623.6121      78.1942     151.0625    4069.0000
 2324.2524      45.8306     112.6004     205.1497     159.2596     151.8216       6.5867     216.0000       0.1035       0.0301      -0.0052      10.2787      58.6707     288.9989     317.0197      50.7829       0.0912       0.1038       0.1505       5.3556    2658.5400      41.8953     151.3750    4011.0000
 2324.4048      47.7362     260.5207     153.1703     100.4980     133.2319       7.5057     216.0000       0.1215       0.0496       0.0150      10.5954      60.9476     283.4169     306.9417      50.7829       0.0810       0.0923       0.1380       5.5090    2625.2188      37.7009     152.1250    3875.0000
 2324.5572      60.9413     844.5549     165.0076      83.6549     167.1948       5.9810     216.0000       0.1574       0.0884       0.0553      10.7257      61.7525     288.9989     273.7503      50.7829       0.0622       0.0714       0.1146       5.5865    2558.8110      30.7704     152.1875    3805.0000
 2324.7096      66.2862      81.4094      64.9940      35.1060      65.8944      15.1758     216.0000       0.2066       0.1416       0.1104      11.0224      61.1832     263.8798     232.1496      50.7829       0.0674       0.0780       0.1211       5.6336    2467.7830      41.2224     153.0625    3834.0000
 2324.8620      31.4534      41.4053      56.6127      29.4505      88.6338      11.2824     216.0000       0.2651       0.2049       0.1760      11.1548      60.9365     273.9275     183.5094      50.7829       0.0696       0.0805       0.1239       5.6670    2359.6516       8.3468     151.1250    3793.0000
 2325.0144      24.9419      38.7816      26.6607      24.3198      33.7843      29.5996     216.0000       0.3128       0.2565       0.2295      10.9410      69.4347     286.2079     121.7761      50.7829       0.0540       0.0611       0.1042       5.5733    2271.3835       4.2439     154.3750    3804.0000
 2325.1668      16.7898      14.5093      15.9117      16.8877      25.2639      39.5821     216.0000       0.3610       0.3087       0.2836      10.2679      72.2769     276.1603      50.6570      50.7829       0.1664       0.1874       0.2392       5.4162    2182.1106       3.0658     156.6875    3807.0000
 2325.3192      22.8451      18.0810      37.8781      36.5621      46.7839      21.3749     216.0000       0.3635       0.3114       0.2863       9.9455      73.9474     289.5571      22.6653      50.7829       0.2350       0.2620       0.3157       5.0816    2177.5483       3.3670     152.3750    3716.0000
 2325.4716      25.7064      22.6642      48.7956      47.9174      57.7043      17.3297     216.0000       0.3257       0.2705       0.2440       9.8017      72.1613     294.5809      31.1794      50.7829       0.1228       0.1390       0.1886       4.8689    2247.4377       4.6159     155.6250    3763.0000
 2325.6240      53.2431      31.0268      75.5329      93.5288      86.9647      11.4989     216.0000       0.2539       0.1928       0.1635       9.9800      75.7648     304.6285      82.9561      50.7829       0.1073       0.1215       0.1700       4.8122    2380.2551       7.1891     151.0625    3798.0000
 2325.7764      66.8816      49.7415     158.7460     205.2723     133.5835       7.4860     216.0000       0.2002       0.1348       0.1033      10.1576      75.8362     326.3983     144.2320      50.7829       0.1153       0.1305       0.1795       5.0735    2479.5400      14.7499     153.3750    3915.0000
 2325.9288      64.6359      69.7787    1950.0000    1783.5457      97.2723      10.2804     216.0000       0.1964       0.1306       0.0990      10.4811      83.1003     283.4169     195.4641      50.7829       0.1251       0.1415       0.1913       5.4454    2486.6792      18.1495     153.9375    3952.0000
 2326.0812      56.2643      94.9747     842.1455     578.1558     146.8726       6.8086     216.0000       0.2036       0.1384       0.1071      10.7849      84.2190     263.3217     243.6120      50.7829       0.1363       0.1541       0.2044       5.7582    2473.2759      14.5989     155.1875    3995.0000
 2326.2336      57.8865     123.3602    1950.0000    1740.7681     205.2688       4.8717     216.0000       0.2058       0.1408       0.1096      10.9539      82.1136     273.9275     283.5992      50.7829       0.1239       0.1402       0.1898       5.9681    2469.2131      14.4456     155.0625    4112.0000
 2326.3860      54.3617     120.6317     868.3083     799.2172     234.7893       4.2591     216.0000       0.1848       0.1181       0.0860      10.6851      75.0080     275.8812     332.2880      50.7829       0.1310       0.1481       0.1982       6.0925    2508.0925      13.8509     153.8125    4073.0000
 2326.5384      60.9954      84.6652     232.0699     200.0224     126.8137       7.8856     216.0000       0.1710       0.1031       0.0705      10.2579      69.2478     294.0227     365.6611      50.7829       0.1565       0.1765       0.2279       6.1597    2533.6663      15.6029     154.5000    4023.0000
 2326.6908      44.9328      55.6479     154.2867     146.9007      59.7383      16.7397     216.0000       0.1624       0.0938       0.0609       9.7529      73.4685     303.5121     382.9169      50.7829       0.1661       0.1870       0.2387       6.1973    2549.5884      14.1819     154.5625    3950.0000
 2326.8432      43.2465      38.9532      81.8123      69.6762      36.2968      27.5506     216.0000       0.1729       0.1052       0.0726       9.3159      79.6153     305.1867     352.9797      50.7829       0.0870       0.0986       0.1454       6.1469    2530.1604      10.5717     157.6250    3877.0000
 2326.9956      49.8687      58.1512     119.5138      82.2908      72.7170      13.7519     216.0000       0.1694       0.1014       0.0688       9.6576      83.3416     308.5359     299.5956      50.7829       0.0803       0.0912       0.1371       5.9860    2536.5364       9.4491     151.5000    3854.0000
 2327.1480      58.9229     121.7428     210.5036     212.9026     115.1348       8.6855     216.0000       0.1277       0.0563       0.0220      10.0124      78.8752     307.1404     261.1356      50.7829       0.0928       0.1056       0.1524       5.6904    2613.6992      12.9507     151.0625    3781.0000
 2327.3004      52.2301     169.5428     296.9139     272.9282     176.7095       5.6590     216.0000       0.1292       0.0579       0.0237      10.2204      71.5652     293.4644     225.0323      50.7829       0.0864       0.0982       0.1445       5.4886    2610.9224      26.6386     150.4375    3722.0000
 2327.4528      57.5503     239.8012     537.3719     883.6999     265.8216       3.7619     216.0000       0.1629       0.0944       0.0614      10.3785      68.0225     285.0915     222.2252      50.7829       0.0944       0.1075       0.1543       5.5693    2548.6604      52.0639     151.6875    3686.0000
 2327.6052      54.9522     210.5332     297.4471     286.0368     132.6908       7.5363     216.0000       0.2037       0.1385       0.1072      10.4583      67.8613     276.1603     256.1340      50.7829       0.0940       0.1069       0.1538       5.8705    2473.1177      36.3517     153.0000    3697.0000
 2327.7576      50.1520     100.1775      94.4799     180.8854      64.0310      15.6174     216.0000       0.1796       0.1124       0.0801      10.3060      70.1334     275.0439     337.1763      50.7829       0.0963       0.1094       0.1566       6.1686    2517.8049      31.6941     152.5625    3733.0000
 2327.9100      46.4108      94.3923      99.1670     105.2563      65.2902      15.3162     216.0000       0.1540       0.0847       0.0514      10.1201      72.0489     290.1153     400.8965      50.7829       0.1048       0.1189       0.1669       6.3545    2565.1702      33.6828     154.2500    3755.0000
 2328.0624      49.4520     142.6522     188.7096     195.2477      83.4005      11.9903     216.0000       0.1730       0.1053       0.0727       9.6490      70.6251     288.4407     411.4833      50.7829       0.1015       0.1151       0.1630       6.5033    2529.9883      15.7432     153.0000    3753.0000
 2328.2148      66.1044     237.8688     218.8781     262.1797     126.8129       7.8856     216.0000       0.2372       0.1747       0.1447       9.3109      74.3887     291.2317     377.9824      50.7829       0.1248       0.1411       0.1908       6.6634    2411.2476       6.9069     152.3750    3705.0000
 2328.3672      66.6702     162.7543     178.0797     184.2094      91.3212      10.9504     216.0000       0.3004       0.2431       0.2156       9.1576      70.2824     311.8851     319.7501      50.7829       0.1386       0.1565       0.2069       6.7356    2294.2141       4.4373     152.1250    3746.0000
 2328.5196     115.6487     118.3064     142.7202     122.0800      77.5788      12.8901     216.0000       0.2658       0.2057       0.1768       9.4657      68.8587     288.7198     315.4030      50.7829       0.1995       0.2234       0.2763       6.5767    2358.2551       4.8715     151.0625    3815.0000
 2328.6720      84.0902      83.2955     114.3077      99.2598      65.6588      15.2303     216.0000       0.1754       0.1079       0.0754       9.9716      55.0818     291.2317     325.8967      50.7829       0.1115       0.1273       0.1749       6.2253    2525.5735       8.4675     151.0625    3926.0000
 2328.8244      66.6857      54.1905      57.3808      45.0240      37.6798      26.5394     216.0000       0.0961       0.0221      -0.0135      10.0308      55.2323     289.2780     339.6680      50.7829       0.0229       0.0248       0.0639       5.9026    2672.2014      29.3831     151.0625    3948.0000
 2328.9768      63.6300     100.5607      59.7493      54.8870      48.2778      20.7134     216.0000       0.1044       0.0310      -0.0042      10.1188      57.4289     286.7661     318.9392      50.7829       0.0384       0.0433       0.0842       5.8499    2656.9500      34.9039     149.5625    4008.0000
 2329.1292      93.3889     122.2555     159.6164      83.1772      53.3427      18.7467     216.0000       0.1338       0.0629       0.0288      10.1683      65.5214     309.6523     327.9071      50.7829       0.1156       0.1308       0.1798       6.0228    2602.4399      18.6304     149.8125    3992.0000
 2329.2816      77.7427     111.0150      93.8436      49.0156      36.0505      27.7389     216.0000       0.1600       0.0912       0.0581       9.9710      67.2399     302.9539     354.9604      50.7829       0.1962       0.2200       0.2729       6.2568    2554.0623      10.1077     151.0625    3869.0000
 2329.4340      30.4736      87.8751      61.3666      38.5901      25.1683      39.7326     216.0000       0.2144       0.1501       0.1192       9.8597      72.4384     293.4644     340.0312      50.7829       0.2192       0.2454       0.2986       6.4540    2453.3914       6.1761     151.0625    3889.0000
 2329.5864      23.4740      17.3488      15.9402      11.4305      10.5100      95.1472     216.0000       0.3004       0.2431       0.2156       9.5674      79.8040     302.9539     272.0499      50.7829       0.1936       0.2178       0.2703       6.5941    2294.3232       3.9178     150.5000    3849.0000
 2329.7388      50.3799      19.1970      18.5738      15.7487      13.6255      73.3921     216.0000       0.3242       0.2689       0.2423       9.8045      87.8828     307.9777     214.9513      50.7829       0.2371       0.2672       0.3191       6.5376    2250.1965       3.3107     148.5000    3867.0000
 2329.8912      47.9038      55.4236      62.3395      34.5038      22.9580      43.5579     216.0000       0.2653       0.2051       0.1762       9.6176      87.1506     316.3507     207.7389      50.7829       0.2514       0.2841       0.3351       6.3088    2359.2288       4.2710     145.9375    3801.0000
 2330.0436      70.5378      97.1626      74.4147      51.1883      38.7053      25.8363     216.0000       0.2172       0.1532       0.1224       9.7786      82.0657     342.0280     212.3120      50.7829       0.1807       0.2042       0.2560       6.0638    2448.1079       7.8502     146.6875    3769.0000
 2330.1960      55.9101     238.9732      88.3973      65.8191      48.1308      20.7767     216.0000       0.3126       0.2563       0.2292       9.6031      69.1054     293.4644     157.3472      50.7829       0.1190       0.1346       0.1840       6.0960    2271.7554       6.8381     144.8750    3795.0000
 2330.3484      52.4989     175.3036     402.2964     470.7736     137.1164       7.2931     216.0000       0.4252       0.3781       0.3555       9.4281      69.1414     289.8362     104.8576      50.7829       0.0781       0.0882       0.1345       6.2595    2063.4492       3.7229     145.9375    3807.0000
 2330.5008      43.8274      70.2994     113.3676     120.9045      99.0135      10.0996     216.0000       0.4377       0.3917       0.3695       9.4142      69.5482     287.8825      98.8772      50.7829       0.0693       0.0780       0.1235       6.1966    2040.2770       3.5019     142.4375    3800.0000
 2330.6532      25.0045      48.5077      78.4905      82.2527      33.1185      30.1946     216.0000       0.3477       0.2943       0.2686       9.4135      73.3330     351.5174     127.4364      50.7829       0.1813       0.2038       0.2562       5.8284    2206.7427       5.5354     143.3750    3810.0000
 2330.8056      14.7973      18.9763      25.2936      33.6611      29.2959      34.1345     216.0000       0.2830       0.2243       0.1961       9.3763      71.9223     377.7528     131.1243      50.7829       0.2883       0.3196       0.3732       5.3699    2326.3999      10.4308     141.3125    3784.0000
 2330.9580      26.9964      20.5636      30.2216      32.9633      58.3672      17.1329     216.0000       0.2517       0.1905       0.1610       9.3941      66.0238     387.2422     124.6309      50.7829       0.1950       0.2200       0.2722       5.1371    2384.3269      13.4663     144.3750    3721.0000
 2331.1104      47.0851      65.2136      79.0157      63.0011      91.6495      10.9111     216.0000       0.2259       0.1625       0.1320       9.3785      61.9208     388.9168     135.6838      50.7829       0.1952       0.2211       0.2727       5.1291    2432.1519      17.0187     141.3125    3740.0000
 2331.2628      57.7565      61.7752     119.5478      63.9843     293.0999       3.4118     216.0000       0.2233       0.1597       0.1291       9.6344      56.4292     403.1509     150.6362      50.7829       0.1577       0.1783       0.2296       5.3350    2436.9658      19.5688     141.3125    3760.0000
 2331.4152      33.2710      75.5997      94.7858      69.5127    1930.4001       0.5180     216.0000       0.2590       0.1983       0.1692       9.7097      55.1738     411.2449     156.2996      50.7829       0.0958       0.1086       0.1561       5.6710    2370.9004      10.4729     141.3125    3892.0000
 2331.5676      43.5990      81.5650      97.4892     103.5040    1950.0000       0.5000     216.0000       0.2952       0.2375       0.2098       9.6158      63.5799     309.0941     169.0845      50.7829       0.0851       0.0964       0.1430       6.0289    2303.8792       7.1673     140.9375    3885.0000
 2331.7200      70.3494      76.5196     214.5750     150.1594     912.4822       1.0959     216.0000       0.3333       0.2787       0.2525       9.4306      68.1615     330.8639     171.3660      50.7829       0.0991       0.1124       0.1601       6.3093    2233.3853       4.6595     141.3125    4008.0000
 2331.8724      69.6743      65.6085     170.3892     114.7831     388.3706       2.5749     216.0000       0.3259       0.2707       0.2442       9.2851      72.8746     302.1166     192.0395      50.7829       0.1736       0.1953       0.2469       6.4325    2247.1062       4.0805     138.5000    3979.0000
 2332.0248      54.5652      53.1532     168.4322     181.3528     302.3826       3.3071     216.0000       0.3183       0.2625       0.2357       9.2459      69.6681     291.5108     206.6762      50.7829       0.0663       0.0752       0.1197       6.4984    2261.0564       4.4138     141.1250    3936.0000
 2332.1772      80.9124      72.0011     244.5223     292.4692     209.5065       4.7731     216.0000       0.2907       0.2326       0.2047       9.0221      61.8022     299.0465     240.8047      50.7829       0.0382       0.0432       0.0840       6.5437    2312.2312       6.7211     136.3125    3804.0000
 2332.3296      80.8769      80.9568     316.9007     496.8582     339.1050       2.9489     216.0000       0.2808       0.2219       0.1936       8.8597      56.4800     302.9539     281.2750      50.7829       0.0928       0.1064       0.1523       6.6589    2330.5664       8.9197     140.6875    3704.0000
 2332.4820      77.0210     109.1867     359.6344     532.8195     214.6387       4.6590     216.0000       0.3290       0.2741       0.2477       8.9936      50.3782     282.8586     282.6210      50.7829       0.0888       0.1019       0.1475       6.8980    2241.3423       5.9130     136.8750    3729.0000
 2332.6344      67.3377      96.0030     220.4318     444.4181      99.2301      10.0776     216.0000       0.3743       0.3231       0.2985       9.2685      54.7630     313.0015     279.6642      50.7829       0.0738       0.0848       0.1290       7.1127    2157.5313       3.8578     138.5000    3804.0000
 2332.7868      98.2742     164.2518     314.9514     312.2208      92.0559      10.8630     216.0000       0.3772       0.3262       0.3017       9.3949      59.0681     312.7224     284.7000      50.7829       0.1047       0.1188       0.1667       7.1086    2152.2144       3.6140     136.2500    3938.0000
 2332.9392      83.4520     199.9264     254.1464     256.2631      87.8723      11.3802     216.0000       0.2945       0.2367       0.2090       9.3788      66.9553     291.2317     338.5653      50.7829       0.1932       0.2170       0.2696       6.8093    2305.2312       5.3481     139.3750    4070.0000
 2333.0916     110.1543     435.0147     274.7123     169.1150      67.5571      14.8023     216.0000       0.2005       0.1350       0.1036       9.1945      68.8640     341.4698     387.8138      50.7829       0.1843       0.2070       0.2594       6.3734    2479.1064      11.3346     135.8125    4047.0000
 2333.2440     104.0322     479.3367     408.1848     165.5508      56.7547      17.6197     216.0000       0.1650       0.0966       0.0638       9.1279      63.5757     353.1920     386.4331      50.7829       0.0723       0.0818       0.1271       6.0574    2544.7803      22.0683     134.0000    4035.0000
 2333.3964     106.2904     290.3356     212.4341     141.8816      62.9786      15.8784     216.0000       0.1591       0.0903       0.0572       8.9041      58.3326     353.4711     351.3558      50.7829       0.0487       0.0549       0.0975       5.8637    2555.6592      19.2446     138.3125    3948.0000
 2333.5488      54.8096     131.4407     105.6109      83.7436      49.3397      20.2677     216.0000       0.1664       0.0981       0.0653       8.6775      52.0144     337.0042     303.0439      50.7829       0.0971       0.1108       0.1576       5.7786    2542.2075      15.0580     131.5625    3845.0000
 2333.7012      33.0382      72.4801      57.2806      46.9740      31.6802      31.5654     216.0000       0.1725       0.1047       0.0722       8.5488      54.0484     359.3322     265.2585      50.7829       0.1134       0.1288       0.1772       5.7725    2530.9397      13.6478     138.3125    3712.0000
 2333.8536      97.0363     145.9458     112.3223      72.7210      47.2777      21.1516     216.0000       0.2046       0.1395       0.1082       8.5516      52.9980     372.7290     239.0618      50.7829       0.1244       0.1408       0.1902       5.9100    2471.4016      12.7216     135.0625    3731.0000
 2334.0060     110.8799     143.0263     171.2250     137.2122      59.1572      16.9041     216.0000       0.2551       0.1941       0.1648       9.0084      57.0830     362.1232     221.6923      50.7829       0.1209       0.1368       0.1862       6.1416    2378.1189       7.8186     131.5625    3721.0000
 2334.1584     334.9116     168.4165     398.2635     145.4310      89.7503      11.1420     216.0000       0.2894       0.2312       0.2033       9.2691      56.8796     408.1747     225.3613      50.7829       0.1146       0.1297       0.1786       6.3058    2314.6055       6.2787     131.5625    3824.0000
 2334.3108     258.6812      79.4487     256.9273     469.6017      74.8748      13.3556     216.0000       0.3079       0.2512       0.2240       9.1657      60.5339     411.8031     218.7214      50.7829       0.1372       0.1550       0.2054       6.2958    2280.4001       6.0386     131.6250    3932.0000
 2334.4632     172.6810      48.3045     241.7937     258.5658      38.3296      26.0895     216.0000       0.2983       0.2408       0.2132       9.0657      67.4142     313.0015     199.2452      50.7829       0.1408       0.1591       0.2097       6.0817    2298.2014       5.8165     132.0625    3975.0000
 2334.6156      48.2795      22.2960      61.1852     328.4732      24.5274      40.7708     216.0000       0.3014       0.2442       0.2167       8.8057      67.7849     284.5333     143.1594      50.7829       0.1276       0.1443       0.1942       5.8002    2292.4185       5.2108     134.5000    3993.0000
 2334.7680     100.9231      33.6295     117.7374     268.5461      55.2839      18.0885     216.0000       0.2985       0.2411       0.2135       8.9540      71.2362     283.4169     104.6100      50.7829       0.1204       0.1362       0.1855       5.6016    2297.7097       5.4884     134.0000    3934.0000
 2334.9204     162.4864      47.7659     102.6075     155.2465      64.2544      15.5631     216.0000       0.2856       0.2272       0.1991       8.6449      68.6648     285.6496     125.0181      50.7829       0.0901       0.1022       0.1492       5.6851    2321.5510       8.1181     134.8750    3876.0000
 2335.0728     141.9434      59.4422      83.8476      92.5888      88.3787      11.3149     216.0000       0.2699       0.2101       0.1814       8.7445      71.3450     287.8825     193.6712      50.7829       0.0816       0.0924       0.1388       6.0519    2350.7668       8.1618     135.1250    3859.0000
 2335.2252     163.8867      86.3410     126.5688      92.0910     262.8683       3.8042     216.0000       0.2923       0.2343       0.2065       8.5940      68.0968     307.4195     237.8726      50.7829       0.1034       0.1171       0.1653       6.5492    2309.2642       5.3770     134.5000    3791.0000
 2335.3776      76.7432      39.0913      49.3349      58.6264     118.4381       8.4432     216.0000       0.3269       0.2718       0.2453       8.6645      69.6822     359.3322     244.0975      50.7829       0.1633       0.1838       0.2355       6.9037    2245.3047       3.8668     139.1875    3759.0000
 2335.5300      47.3998      22.6413      42.3352      34.8002     116.3997       8.5911     216.0000       0.3542       0.3013       0.2759       8.7930      73.4984     333.0967     224.6064      50.7829       0.1913       0.2148       0.2674       7.0418    2194.7649       3.8309     131.5625    3840.0000
 2335.6824      36.4233      21.8179      19.5337      22.1246      39.7470      25.1591     216.0000       0.3924       0.3427       0.3188       8.7547      72.7255     261.0888     182.5179      50.7829       0.2035       0.2292       0.2816       7.0413    2124.0383       3.2142     134.6875    4003.0000
 2335.8348      18.2285      11.9073      16.7430      28.9174      85.2593      11.7289     216.0000       0.4287       0.3819       0.3595       8.6377      72.7673     264.9962     144.1801      50.7829       0.1508       0.1713       0.2220       7.0219    2056.8752       2.6674     131.5625    3903.0000
 2335.9872      42.2501      19.7803      39.5887      46.4274     101.8286       9.8204     216.0000       0.4680       0.4244       0.4035       8.6819      71.5492     285.0915     107.0669      50.7829       0.1308       0.1486       0.1985       6.9788    1984.2900       2.2017     133.1875    3980.0000
 2336.1396      49.0958      20.2337      40.2516      62.8918     142.1179       7.0364     216.0000       0.4220       0.3746       0.3519       8.7591      73.7432     304.0703     157.0759      50.7829       0.1778       0.2013       0.2529       6.9070    2069.3513       2.5033     135.5000    3957.0000
 2336.2920      93.8913      24.0205      72.0869     107.9437     196.7803       5.0818     216.0000       0.3460       0.2925       0.2668       8.6948      69.0599     304.6285     248.0942      50.7829       0.2746       0.3066       0.3593       6.8398    2209.8403       3.4640     135.9375    3828.0000
 2336.4444     133.1234      35.4512     139.3241     160.1131     234.5258       4.2639     216.0000       0.2842       0.2256       0.1974       8.5716      71.3432     332.2594     333.6951      50.7829       0.1701       0.1923       0.2439       6.8396    2324.2122       5.6417     135.8750    3788.0000
 2336.5968     114.7648      51.8946     480.1557     355.0883     369.5004       2.7064     216.0000       0.2421       0.1801       0.1503       8.4759      75.8613     275.0439     384.2995      50.7829       0.1471       0.1667       0.2174       6.8178    2402.0732       9.7515     136.4375    3719.0000
 2336.7492     121.6366      79.0435     413.0327     286.1226     173.4707       5.7647     216.0000       0.2388       0.1765       0.1466       8.3207      86.1804     283.9751     379.8098      50.7829       0.1534       0.1731       0.2244       6.7573    2408.1301      12.7914     138.1250    3671.0000
 2336.9016      92.0921     137.3529    1055.7357     275.6053     152.7182       6.5480     216.0000       0.1996       0.1341       0.1026       8.2050      91.8146     311.3269     396.0385      50.7829       0.1408       0.1590       0.2097       6.6180    2480.7737      14.9625     140.6875    3829.0000
 2337.0540      86.7328     228.4310    1451.0417     239.1339     164.3972       6.0828     216.0000       0.1735       0.1059       0.0734       8.4959      88.1535     284.2542     410.1598      50.7829       0.1281       0.1449       0.1946       6.5336    2528.9438      23.0014     143.0000    4065.0000
 2337.2064      90.4399     192.8483     602.8961     335.1690     121.5264       8.2287     216.0000       0.1833       0.1164       0.0843       8.4049      80.4838     256.6232     413.9247      50.7829       0.0789       0.0892       0.1354       6.5693    2510.8882      20.5918     142.1250    4142.0000
 2337.3588      59.5195     133.9715     352.5640     215.5009      72.9537      13.7073     216.0000       0.2709       0.2112       0.1825       8.3923      74.2263     265.5544     363.5213      50.7829       0.0810       0.0917       0.1380       6.7814    2348.8599       9.1660     146.1250    4117.0000
 2337.5112      56.5015      64.2130     114.5682      75.9156      41.1613      24.2947     216.0000       0.3315       0.2768       0.2505       8.3746      75.8055     272.8111     322.1242      50.7829       0.1826       0.2049       0.2572       6.9102    2236.6995       5.5185     143.1250    4049.0000
 2337.6636      81.5222      77.1589     175.9674     113.8896      50.7295      19.7124     216.0000       0.3156       0.2596       0.2327       8.4014      71.2943     273.9275     323.4748      50.7829       0.1639       0.1845       0.2361       6.7711    2266.0620       5.8716     145.1250    3953.0000
 2337.8160      76.4302      91.8333     321.1101     216.6352      95.6162      10.4585     216.0000       0.2484       0.1868       0.1573       8.4930      65.0021     270.0200     352.1183      50.7829       0.0911       0.1036       0.1503       6.4036    2390.5166      10.3100     145.0625    3899.0000
 2337.9684     111.0831     177.3600     447.4076     296.6890     137.3012       7.2833     216.0000       0.1962       0.1303       0.0987       8.2564      59.1489     274.4857     351.1462      50.7829       0.0761       0.0872       0.1318       5.9613    2487.1064      32.1478     147.2500    3755.0000
 2338.1208     105.5311     269.9239    1805.9395    1388.3741     363.6058       2.7502     216.0000       0.1729       0.1051       0.0726       8.2550      53.0328     275.6021     315.8262      50.7829       0.0619       0.0719       0.1143       5.6005    2530.2136      44.4369     146.1875    3838.0000
 2338.2732      99.2223     380.2905    1832.0363     746.4680     463.9508       2.1554     216.0000       0.1532       0.0839       0.0505       8.3661      47.2872     261.0888     285.8412      50.7829       0.0483       0.0559       0.0971       5.3119    2566.5938      60.4098     147.5000    3851.0000
 2338.4256      90.3593     349.8725    1035.0325     286.6064     227.0703       4.4039     216.0000       0.1451       0.0751       0.0414       8.4248      45.0198     256.6232     287.0350      50.7829       0.0480       0.0563       0.0968       5.2092    2581.6179      84.7726     148.3125    3876.0000
 2338.5780      83.3706     317.7198     605.9682     367.3025     248.0148       4.0320     216.0000       0.1531       0.0838       0.0505       8.4182      44.6394     263.3217     298.3410      50.7829       0.0426       0.0507       0.0899       5.2411    2566.7075      92.4209     151.0625    3870.0000
 2338.7304      84.7676     335.9739     681.1630     483.5325     260.1965       3.8432     216.0000       0.1567       0.0876       0.0545       8.1118      46.1137     258.8560     308.1903      50.7829       0.0454       0.0548       0.0938       5.2842    2560.1382      79.6611     151.5000    3781.0000
 2338.8828      82.7462     257.2268     907.4993     425.9569     286.5004       3.4904     216.0000       0.1589       0.0901       0.0570       8.0688      47.5348     256.0650     287.9670      50.7829       0.0436       0.0523       0.0913       5.2240    2555.9993      59.8924     151.0625    3773.0000
 2339.0352      81.5853     200.4011     724.6243     313.3544     258.5769       3.8673     216.0000       0.1532       0.0839       0.0506       8.2669      52.6102     250.4830     250.1371      50.7829       0.0428       0.0505       0.0902       5.0422    2566.4885      48.4421     158.7500    3772.0000
 2339.1876      79.2256     159.1615     669.0753     417.2885     287.6361       3.4766     216.0000       0.1544       0.0852       0.0519       8.2123      53.2204     244.9010     213.7346      50.7829       0.0586       0.0684       0.1102       4.8969    2564.3923      51.1100     150.0000    3819.0000
 2339.3400      77.4023     147.6035     697.3904     469.9056     377.6757       2.6478     216.0000       0.1643       0.0958       0.0630       8.1922      48.9844     254.3904     199.0311      50.7829       0.0586       0.0688       0.1102       4.8980    2546.0984      62.0281     151.0625    3904.0000
 2339.4924      79.8632     157.6278     715.8569     468.1693     419.5043       2.3838     216.0000       0.1795       0.1123       0.0800       8.1930      50.4107     258.2978     214.0155      50.7829       0.0488       0.0579       0.0980       5.0895    2517.9375      72.5666     153.5000    3912.0000
 2339.6448      82.5127     196.4547     701.3934     340.7686     381.2080       2.6232     216.0000       0.1775       0.1101       0.0778       8.0488      48.7836     261.0888     257.5238      50.7829       0.0426       0.0510       0.0900       5.3514    2521.6790      77.7282     155.8125    3936.0000
 2339.7972      92.7710     275.3784    1475.7802     644.4504    1334.9910       0.7491     216.0000       0.1603       0.0915       0.0585       8.1668      48.5532     265.5544     311.8362      50.7829       0.0395       0.0468       0.0859       5.5591    2553.5295      82.8054     158.3750    3957.0000
 2339.9496      98.3462     377.4778    1117.2827     348.0648     535.1829       1.8685     216.0000       0.1542       0.0850       0.0517       8.1487      46.4645     263.3217     354.5844      50.7829       0.0481       0.0568       0.0970       5.7022    2564.6785      72.0291     150.5000    3897.0000
 2340.1020      76.9984     341.4080     376.0314     239.3190     206.5726       4.8409     216.0000       0.1617       0.0931       0.0601       8.1339      45.8281     268.3454     378.4578      50.7829       0.0572       0.0667       0.1084       5.8115    2550.8667      38.9485     157.3750    3916.0000
 2340.2544      74.4781     230.6419     252.2374     149.1252     135.6719       7.3707     216.0000       0.1656       0.0973       0.0645       8.0620      51.3467     264.4380     387.8720      50.7829       0.0692       0.0804       0.1235       5.8421    2543.6555      23.7984     155.5625    3854.0000
 2340.4068      83.6169     194.2101     199.6667     130.5031     110.8212       9.0235     216.0000       0.1658       0.0975       0.0647       8.0153      56.1109     261.0888     378.9263      50.7829       0.0807       0.0928       0.1376       5.7937    2543.2075      17.1382     158.5625    3771.0000
 2340.5592      87.7880     206.5774     219.9386     134.6503     100.8835       9.9124     216.0000       0.1659       0.0976       0.0648       8.1021      60.5772     268.9037     347.9543      50.7829       0.0828       0.0948       0.1401       5.6511    2543.0586      15.3782     154.2500    3811.0000
 2340.7116      84.0386     290.4455     340.2531     199.9679     123.1507       8.1201     216.0000       0.1587       0.0899       0.0568       7.9173      62.5701     260.5306     307.6255      50.7829       0.1033       0.1179       0.1650       5.4487    2556.3245      17.6076     161.6875    3735.0000
 2340.8640      93.3404     515.2158     498.1949     266.8550     155.8458       6.4166     216.0000       0.1450       0.0750       0.0413       8.0688      56.8750     257.1814     270.1352      50.7829       0.0816       0.0934       0.1387       5.2399    2581.7859      27.4511     154.4375    3748.0000
 2341.0164      91.0171     712.1688    1209.1241     443.2776     157.9911       6.3295     216.0000       0.1411       0.0708       0.0370       8.0783      56.0961     247.1338     240.4613      50.7829       0.0609       0.0700       0.1130       5.1214    2588.9043      39.4841     160.1250    3878.0000
 2341.1688      81.9472     383.7676     580.6708     279.0959     140.4479       7.1201     216.0000       0.1558       0.0866       0.0534       7.9347      50.4160     251.5994     218.5752      50.7829       0.0601       0.0693       0.1120       5.1707    2561.8311      48.3868     160.2500    3907.0000
 2341.3212      73.8152     235.9448     417.2841     191.2028     134.8482       7.4157     216.0000       0.1844       0.1176       0.0855       7.8468      50.5882     254.9486     221.6051      50.7829       0.0554       0.0640       0.1060       5.4000    2508.9468      50.4059     163.2500    3913.0000
 2341.4736      67.4608     181.1670     314.2037     142.7670     129.3660       7.7300     216.0000       0.2251       0.1617       0.1312       7.8078      54.2094     252.7158     245.3837      50.7829       0.0615       0.0704       0.1137       5.7475    2433.5046      22.1200     160.8125    3820.0000
 2341.6260      61.2900     106.0260     185.4561     142.4899     151.7376       6.5903     216.0000       0.2497       0.1882       0.1587       7.9378      57.0830     247.4129     296.6199      50.7829       0.1157       0.1314       0.1799       6.0444    2388.1226      13.7178     164.1875    3769.0000
 2341.7784      70.4124     124.2711     275.9152     209.5740     208.0438       4.8067     216.0000       0.2407       0.1786       0.1487       7.8871      59.4663     256.6232     339.1957      50.7829       0.1479       0.1671       0.2175       6.1280    2404.6655      12.8164     160.8125    3717.0000
 2341.9308      88.4159     195.8905     431.7901     253.6366     279.0403       3.5837     216.0000       0.2133       0.1489       0.1180       8.0367      57.2688     268.3454     341.5265      50.7829       0.0918       0.1046       0.1511       5.9608    2455.3706      17.1063     162.6875    3662.0000
 2342.0832      93.4332     188.3785     518.0836     314.2841     372.9189       2.6815     216.0000       0.1833       0.1164       0.0843       8.0070      58.2482     258.2978     310.5032      50.7829       0.0830       0.0949       0.1404       5.6514    2510.8850      20.4306     160.8125    3704.0000
 2342.2356      89.1518     267.5154     637.0146     253.9253     392.8772       2.5453     216.0000       0.1724       0.1046       0.0720       7.8640      58.3011     262.2052     267.9698      50.7829       0.0766       0.0876       0.1325       5.3668    2531.1228      21.1632     158.7500    3780.0000
 2342.3880      84.7810     348.7537     867.9443     295.0203     584.4911       1.7109     216.0000       0.1581       0.0892       0.0561       7.8828      56.2671     256.3441     258.9545      50.7829       0.0656       0.0755       0.1189       5.1959    2557.4871      35.6967     166.1875    3912.0000
 2342.5404      83.2743     317.0052     567.4454     451.6422     494.8887       2.0207     216.0000       0.1534       0.0840       0.0507       7.6886      55.8980     246.2965     273.1218      50.7829       0.0601       0.0695       0.1120       5.1808    2566.2913      48.7091     160.8125    4046.0000
 2342.6928      82.2166     261.3219     565.9508     353.5650     271.7967       3.6792     216.0000       0.1447       0.0746       0.0410       7.8309      50.0105     248.2502     299.8846      50.7829       0.0615       0.0719       0.1138       5.2266    2582.3650      51.6863     163.1875    4059.0000
 2342.8452      80.5728     264.9729     621.6380     350.2295     240.7104       4.1544     216.0000       0.1232       0.0514       0.0169       7.8212      49.7756     247.1338     324.6274      50.7829       0.0554       0.0645       0.1061       5.2163    2622.1335      47.8946     160.8125    3915.0000
 2342.9976      80.3981     249.0733     462.5399     345.0622     203.4285       4.9157     216.0000       0.1082       0.0352       0.0001       7.7249      46.7917     253.2740     327.1429      50.7829       0.0543       0.0636       0.1048       5.1489    2649.8186      49.8955     163.7500    3873.0000
 2343.1500      82.1549     222.6602     439.9357     302.1880     199.9770       5.0006     216.0000       0.1026       0.0291      -0.0062       7.7573      47.1978     252.1576     323.5054      50.7829       0.0602       0.0703       0.1122       5.0665    2660.2334      57.2301     160.8125    3784.0000
 2343.3024      80.2974     197.1686     421.1238     266.1288     202.4179       4.9403     216.0000       0.1143       0.0418       0.0070       7.9533      47.6361     259.9724     323.8814      50.7829       0.0538       0.0629       0.1042       5.0596    2638.5142      56.5433     166.2500    3798.0000
 2343.4548      79.9724     175.7076     394.1516     244.7147     202.2583       4.9442     216.0000       0.1310       0.0599       0.0257       8.2513      48.5529     258.0187     327.5518      50.7829       0.0585       0.0681       0.1100       5.1069    2607.5601      56.9765     160.8125    3773.0000
 2343.6072      77.9508     175.7034     367.3775     224.3360     212.3453       4.7093     216.0000       0.1413       0.0710       0.0372       8.1814      56.8131     250.2039     324.5506      50.7829       0.0567       0.0655       0.1077       5.1516    2588.6377      55.1739     163.2500    3851.0000
 2343.7596      79.3545     188.5599     360.2615     210.5683     215.0367       4.6504     216.0000       0.1393       0.0689       0.0350       8.1816      59.0139     252.1576     302.0997      50.7829       0.0686       0.0793       0.1227       5.0975    2592.2566      56.9270     164.1250    3886.0000
 2343.9120      80.8216     207.5978     391.8440     235.3049     316.0827       3.1637     216.0000       0.1233       0.0516       0.0171       7.6021      59.8260     257.7396     273.0570      50.7829       0.0795       0.0914       0.1362       4.9337    2621.8379      61.0332     163.2500    3909.0000
 2344.0644      80.2927     218.2277     332.5963     217.6499     206.2926       4.8475     216.0000       0.0965       0.0225      -0.0130       7.2561      59.3203     247.6920     256.5989      50.7829       0.0841       0.0965       0.1417       4.7330    2671.4702      79.3451     164.8125    3849.0000
 2344.2168      79.0901     213.3481     304.0558     194.3378     172.8159       5.7865     216.0000       0.0906       0.0162      -0.0196       7.3817      60.1704     249.9248     242.0950      50.7829       0.0752       0.0862       0.1307       4.6050    2682.3660      90.5496     160.2500    3859.0000
 2344.3692      80.6249     210.7995     335.3615     201.1416     168.4931       5.9350     216.0000       0.1011       0.0275      -0.0079       7.4038      60.7795     246.5756     237.3033      50.7829       0.0640       0.0736       0.1169       4.5919    2662.9834      99.9607     162.9375    3773.0000
 2344.5216      79.0958     202.5640     306.0084     214.6405     170.7987       5.8548     216.0000       0.1182       0.0460       0.0114       7.6745      58.9176     251.0412     232.8568      50.7829       0.0774       0.0892       0.1336       4.6266    2631.2639      74.2945     163.3750    3769.0000
 2344.6740      78.6237     176.6562     268.8873     201.0016     164.9685       6.0618     216.0000       0.1210       0.0491       0.0145       7.8575      56.2404     240.9936     239.6607      50.7829       0.0734       0.0845       0.1286       4.6335    2626.0974      63.5714     162.2500    3767.0000
 2344.8264      76.7292     167.6277     246.2791     173.5783     142.7967       7.0030     216.0000       0.1188       0.0467       0.0120       7.8779      56.2761     248.2502     237.3586      50.7829       0.0677       0.0780       0.1215       4.5737    2630.2151      61.7180     160.8125    3786.0000
 2344.9788      80.6219     177.5388     248.8521     155.8186     142.3792       7.0235     216.0000       0.1235       0.0517       0.0172       7.8488      54.8837     248.2502     218.6451      50.7829       0.0719       0.0830       0.1268       4.4725    2621.5649      58.4100     163.1875    3762.0000
 2345.1312      81.5393     204.5712     312.7575     199.5094     161.2194       6.2027     216.0000       0.1293       0.0580       0.0237       7.7022      55.3235     244.9010     195.7474      50.7829       0.0823       0.0946       0.1395       4.3658    2610.8665      65.4183     160.8125    3783.0000
 2345.2836      83.0089     232.4148     351.0985     227.7746     179.3960       5.5743     216.0000       0.1352       0.0644       0.0304       7.3707      53.2576     243.7846     174.3376      50.7829       0.0759       0.0873       0.1317       4.2872    2599.8164      60.6738     161.0625    3750.0000
 2345.4360      84.1155     244.0812     365.0908     237.5886     176.7402       5.6580     216.0000       0.1327       0.0617       0.0276       7.3883      50.1786     252.1576     164.0263      50.7829       0.0543       0.0628       0.1047       4.2483    2604.5339      63.1822     161.6875    3776.0000
 2345.5884      84.7804     243.7190     432.5431     221.1001     172.5305       5.7961     216.0000       0.1334       0.0625       0.0284       7.4698      49.7718     245.1801     158.5181      50.7829       0.0575       0.0673       0.1089       4.2724    2603.1362      58.1582     160.8125    3801.0000
 2345.7408      83.2897     209.7509     505.3954     297.1554     210.2366       4.7565     216.0000       0.1349       0.0641       0.0300       7.3967      48.5833     246.0174     158.5512      50.7829       0.0559       0.0662       0.1069       4.3287    2600.4395      71.4997     162.6875    3808.0000
 2345.8932      87.8904     210.7967     559.7808     348.7636     256.8594       3.8932     216.0000       0.1382       0.0676       0.0337       7.4260      52.4406     239.3190     154.2914      50.7829       0.0468       0.0552       0.0953       4.3676    2594.4001      83.0648     152.0000    3831.0000
 2346.0456      83.0753     183.5230     510.6338     317.5258     225.4455       4.4357     216.0000       0.1343       0.0635       0.0294       7.5593      49.7684     243.2264     136.1899      50.7829       0.0462       0.0548       0.0946       4.3199    2601.4766      90.3920     160.8125    3842.0000
 2346.1980      77.2605     163.8752     456.7068     296.6620     209.3572       4.7765     216.0000       0.1313       0.0602       0.0260       7.7334      50.6490     243.7846     110.0397      50.7829       0.0508       0.0600       0.1004       4.2103    2607.1289      66.6795     160.8125    3810.0000
 2346.3504      78.0148     168.6421     443.1329     298.9792     234.4050       4.2661     216.0000       0.1384       0.0679       0.0340       7.6178      47.8068     244.6219      98.1903      50.7829       0.0384       0.0452       0.0845       4.2028    2593.9639      73.0933     160.8125    3795.0000
 2346.5028      77.9755     176.2905     482.2613     314.0083     337.5577       2.9625     216.0000       0.1513       0.0818       0.0484       7.3146      50.4791     247.6920     120.3253      50.7829       0.0520       0.0603       0.1018       4.3802    2570.1201      58.8189     160.5000    3779.0000
 2346.6552      73.1455     166.3430     370.1338     275.2521     306.4240       3.2635     216.0000       0.1571       0.0881       0.0549       7.2962      51.5989     252.1576     175.5903      50.7829       0.0793       0.0911       0.1359       4.7044    2559.3540      56.6661     163.3750    3750.0000
 2346.8076      70.1489     155.6051     298.2183     266.7328     233.0822       4.2903     216.0000       0.1547       0.0855       0.0523       7.4309      54.0351     248.2502     225.7426      50.7829       0.1066       0.1210       0.1690       5.0047    2563.7515      38.0209     160.8125    3814.0000
 2346.9600      68.7030     146.2189     270.7174     239.5707     212.6250       4.7031     216.0000       0.1565       0.0874       0.0542       7.4247      57.0860     247.6920     245.6067      50.7829       0.1273       0.1441       0.1937       5.1535    2560.5420      33.6796     160.8750    3819.0000
 2347.1124      70.4669     148.7847     218.6553     218.7685     166.1498       6.0187     216.0000       0.1703       0.1024       0.0697       7.6685      63.3570     251.5994     235.2867      50.7829       0.1111       0.1260       0.1744       5.1718    2534.9578      20.1679     160.8750    3814.0000
 2347.2648      81.5442     185.7085     257.3880     331.3076     203.0654       4.9245     216.0000       0.1731       0.1054       0.0729       7.5271      64.8153     250.2039     214.7706      50.7829       0.1172       0.1331       0.1817       5.0418    2529.7498      13.4545     162.1875    3795.0000
 2347.4172      85.5249     204.6338     328.7742     371.9774     216.4831       4.6193     216.0000       0.1529       0.0835       0.0502       7.4276      64.2051     242.1100     182.3711      50.7829       0.1190       0.1350       0.1838       4.7793    2567.1760      14.5911     160.8125    3799.0000
 2347.5696     116.8637     402.7675     490.9184     424.4589     489.5723       2.0426     216.0000       0.1291       0.0578       0.0235       7.3371      63.4156     266.1126     134.9895      50.7829       0.0742       0.0843       0.1296       4.4268    2611.1462      27.1259     156.9375    3820.0000
 2347.7220     117.7987     350.3015    1464.4880     797.3764     932.1734       1.0728     216.0000       0.1233       0.0515       0.0171       7.2122      69.0116     247.1338      82.9408      50.7829       0.0642       0.0729       0.1170       4.1197    2621.8560      91.5225     160.8125    3834.0000
 2347.8744     108.1113     302.2032     724.2673     416.2420     859.5484       1.1634     216.0000       0.1390       0.0685       0.0347       7.2499      71.4102     252.1576      41.5089      50.7829       0.0960       0.1098       0.1562       3.9025    2592.8091      28.0232     160.8125    3818.0000
 2348.0268     107.3129     170.0513     284.3640     181.9212     221.0862       4.5231     216.0000       0.1461       0.0761       0.0425       7.4171      71.8607     251.3203      26.5534      50.7829       0.1083       0.1234       0.1710       3.8434    2579.7927      28.4111     163.4375    3805.0000
 2348.1792     102.2658     143.1138     207.4905     127.7037     156.8503       6.3755     216.0000       0.1540       0.0847       0.0515       7.4464      65.0443     253.2740      40.8022      50.7829       0.0762       0.0868       0.1320       3.9959    2565.0957      32.1072     160.8125    3791.0000
 2348.3316      77.5922     110.7494     152.9035     112.5523     111.7618       8.9476     216.0000       0.1744       0.1068       0.0743       7.0921      62.4051     253.2740      76.3545      50.7829       0.0692       0.0787       0.1233       4.3864    2527.3997      39.4210     165.8125    3777.0000
 2348.4840      59.2656      99.7810     105.6844      95.7061      77.4616      12.9096     216.0000       0.1870       0.1205       0.0885       7.0777      58.5667     259.9724     134.8975      50.7829       0.0723       0.0827       0.1271       4.8412    2504.0203      16.0367     160.8125    3777.0000
 2348.6364      44.0708      84.8433      91.7821      79.7880      65.4545      15.2778     216.0000       0.1859       0.1192       0.0872       7.2189      67.6674     263.3217     183.9590      50.7829       0.0791       0.0904       0.1356       5.1904    2506.1409      12.5251     162.8125    3780.0000
 2348.7888      51.6683     120.0186     141.6072     154.1647      85.1323      11.7464     216.0000       0.1688       0.1008       0.0681       7.0972      77.0609     264.4380     214.8614      50.7829       0.0978       0.1115       0.1584       5.3529    2537.6399      11.5328     167.6875    3777.0000
 2348.9412      63.2710     240.7677     324.5577     276.2906     124.9042       8.0061     216.0000       0.1652       0.0969       0.0640       7.2633      89.2385     269.4618     224.3066      50.7829       0.1096       0.1240       0.1727       5.4374    2544.3625      12.8253     169.3750    3804.0000
 2349.0936      62.4068     314.6685     251.1026     346.3551     152.3689       6.5630     216.0000       0.2003       0.1349       0.1034       7.1912      87.4114     280.9049     202.2867      50.7829       0.1756       0.1980       0.2500       5.5364    2479.3950      10.5488     161.7500    3776.0000
 2349.2460      62.0994     163.0266     262.4333     209.0217     150.0755       6.6633     216.0000       0.2237       0.1601       0.1296       7.3383      81.0631     294.0227     191.0660      50.7829       0.2438       0.2724       0.3257       5.6370    2436.1785       9.0311     160.8125    3751.0000
 2349.3984      76.9168     127.7458     246.8013     184.0718     154.8926       6.4561     216.0000       0.2237       0.1601       0.1296       6.9547      74.7426     289.5571     188.5641      50.7829       0.1647       0.1855       0.2373       5.6709    2436.1719       9.3303     164.7500    3770.0000
 2349.5508      70.5151     126.5107     263.2774     156.8080     190.6698       5.2447     216.0000       0.2023       0.1369       0.1056       6.9120      71.6974     313.5597     197.5701      51.0625       0.1045       0.1183       0.1666       5.5894    2475.8162       8.5879     166.3125    3751.0000
 2349.7032      74.7845     119.5998     260.9396     237.4189     247.2252       4.0449     216.0000       0.1718       0.1040       0.0714       7.0763      79.2660     251.0412     204.8519      50.7829       0.1223       0.1385       0.1881       5.4358    2532.1631      10.2377     169.4375    3793.0000
 2349.8556      73.1904     189.8518     181.5269     172.8269     177.5271       5.6329     216.0000       0.1602       0.0915       0.0584       7.0258      78.0149     255.2277     166.0454      50.7829       0.1422       0.1611       0.2117       5.1639    2553.6196      11.2756     164.1875    3787.0000
 2350.0080      70.8040     218.7296     284.2134     292.7297     279.7016       3.5752     216.0000       0.1433       0.0731       0.0394       7.0662      80.0450     251.0412     122.3862      50.7829       0.1616       0.1827       0.2341       4.8099    2584.9265      16.6608     168.8125    3794.0000
 2350.1604      58.8161     381.8922     237.8883     262.8191     157.4408       6.3516     216.0000       0.1761       0.1087       0.0763       7.0405      70.2820     260.5306      77.8880      50.7829       0.1388       0.1570       0.2075       4.6051    2524.1802      30.0562     165.8125    3847.0000
 2350.3128      59.4162     145.6001     204.9696     259.9494     125.3249       7.9793     216.0000       0.2227       0.1590       0.1285       7.1958      68.4610     255.5068      73.4901      50.7829       0.1094       0.1238       0.1726       4.6527    2438.0461      10.7004     169.2500    3805.0000
 2350.4652      47.3517      86.6494     154.4371     397.7619     127.4830       7.8442     216.0000       0.2309       0.1679       0.1376       7.1739      70.7451     267.2290     103.2445      50.7829       0.1783       0.2007       0.2529       4.7917    2422.8955       7.9169     169.0625    3791.0000
 2350.6176      43.7813      36.0860      51.1893      51.0672      41.2658      24.2332     216.0000       0.2022       0.1368       0.1054       7.1151      73.9994     270.0200     118.2659      50.7829       0.1927       0.2167       0.2693       4.7547    2476.0134       8.5779     172.9375    3770.0000
 2350.7700      44.1656      55.2268     112.3941      71.1153      37.8978      26.3868     216.0000       0.1757       0.1082       0.0758       6.8744      78.2567     249.6457     112.3507      51.0625       0.1263       0.1430       0.1929       4.5791    2524.9565      26.6119     170.1875    3746.0000
 2350.9224      44.6112      76.2805     149.5795     123.2599      75.0718      13.3206     216.0000       0.1760       0.1085       0.0761       6.3766      72.7243     252.1576      88.9330      50.7829       0.1363       0.1540       0.2043       4.4012    2524.4653      13.4640     167.7500    3803.0000
 2351.0748      54.1075      87.3401     188.8107     142.5131      95.6912      10.4503     216.0000       0.1724       0.1046       0.0721       6.3042      70.3070     247.6920      69.6554      50.7829       0.1473       0.1662       0.2171       4.2262    2531.0981      10.0290     169.9375    3779.0000
 2351.2272      68.1642     159.5188     245.6274     199.0089     124.9865       8.0009     216.0000       0.1511       0.0816       0.0482       6.0775      65.0693     251.3203      44.1656      50.7829       0.1334       0.1508       0.2009       3.9354    2570.4531      10.8597     170.0000    3823.0000
 2351.3796      63.0864     158.4211     470.8922     122.3973     200.5861       4.9854     216.0000       0.1303       0.0591       0.0249       6.8554      64.0930     255.5068      18.0137      50.7829       0.0985       0.1117       0.1594       3.6336    2608.9658      40.6223     171.5000    3841.0000
 2351.5320      54.1621     185.1881     207.5342     179.9368     143.4659       6.9703     216.0000       0.1202       0.0481       0.0135       7.2051      63.6232     242.1100      11.0798      51.0625       0.0764       0.0866       0.1323       3.6389    2627.6812     100.7061     170.6250    3786.0000
 2351.6844      51.9506     178.6958     235.8492     191.0850     145.4687       6.8743     216.0000       0.1345       0.0637       0.0296       7.1279      65.4097     254.9486      49.1745      50.7829       0.0815       0.0925       0.1386       4.0521    2601.0957     109.1304     173.9375    3762.0000
 2351.8368      47.0786     144.6573     358.3972     206.5436     170.6195       5.8610     216.0000       0.1615       0.0928       0.0598       7.3630      69.2742     259.4142     115.2792      51.0625       0.1139       0.1291       0.1778       4.7011    2551.2485      18.4956     167.6875    3770.0000
 2351.9892      43.6387     104.7139     118.3197     123.3167      87.8505      11.3830     216.0000       0.1795       0.1123       0.0800       6.7973      74.3986     253.8322     178.2065      51.0625       0.1541       0.1737       0.2249       5.1422    2517.9292      10.2090     170.6250    3726.0000
 2352.1416      48.2558      79.8573     134.8500     146.1247      82.7413      12.0859     216.0000       0.1748       0.1073       0.0748       6.6819      74.0568     257.1814     197.3300      50.7829       0.1400       0.1581       0.2085       5.2048    2526.5566       8.5306     170.6250    3780.0000
 2352.2940      66.3790      89.4086     211.3731     187.0598     107.8682       9.2706     216.0000       0.1612       0.0925       0.0595       6.7703      75.6349     252.9949     167.9802      50.7829       0.1160       0.1312       0.1804       4.9185    2551.8022      15.0664     171.3750    3822.0000
 2352.4464      77.7723     105.7900     253.6308     242.7467     185.6633       5.3861     216.0000       0.1557       0.0865       0.0533       6.6256      73.5557     264.7171     123.7321      51.0625       0.0996       0.1130       0.1606       4.5755    2562.0107      32.6226     170.6250    3821.0000
 2352.5988      70.0537     130.0930     258.1583     241.7353     165.2497       6.0514     216.0000       0.1437       0.0736       0.0399       6.7747      73.7383     256.0650      93.8430      51.0625       0.0997       0.1131       0.1607       4.3399    2584.0938      50.9355     170.6250    3861.0000
 2352.7512      60.8331     103.4395     252.0764     216.7380     160.2213       6.2414     216.0000       0.1401       0.0696       0.0358       6.9082      72.1497     256.0650      72.6783      51.0625       0.0870       0.0988       0.1453       4.2429    2590.9014      29.8067     170.6250    3847.0000
 2352.9036      56.3359     110.6527     214.8696     184.0844     145.0260       6.8953     216.0000       0.1293       0.0580       0.0237       6.9297      70.1610     267.2290      71.5237      51.0625       0.1061       0.1202       0.1685       4.2535    2610.8748      33.5711     173.8125    3818.0000
 2353.0560      56.1684     115.7233     201.8641     224.6696     130.3293       7.6729     216.0000       0.1468       0.0769       0.0434       6.5290      70.9293     270.5782      66.0358      51.0625       0.1454       0.1641       0.2148       4.4092    2578.4353      32.5806     169.7500    3781.0000
 2353.2084      59.7393     102.0785     193.5339     202.0878     121.7072       8.2164     216.0000       0.1503       0.0807       0.0473       6.5676      70.0817     263.6007      86.8237      51.0625       0.1207       0.1366       0.1860       4.7301    2571.9231      38.3181     171.7500    3760.0000
 2353.3608      58.8785     132.3055     188.8227     217.9382     112.0259       8.9265     216.0000       0.1579       0.0889       0.0558       6.7611      72.5224     253.8322      99.4000      51.0625       0.0975       0.1104       0.1581       5.0906    2557.9465      26.7590     170.6250    3774.0000
 2353.5132      54.6187     120.5528     181.9006     203.9509     126.1100       7.9296     216.0000       0.1500       0.0804       0.0469       6.5843      71.5716     255.5068     121.6500      51.0625       0.0962       0.1090       0.1566       5.3334    2572.5444      22.3336     167.7500    3805.0000
 2353.6656      58.9623     100.2406     165.9713     170.9231     135.0989       7.4020     216.0000       0.1686       0.1005       0.0678       6.5432      73.6500     255.5068     122.4840      51.0625       0.1162       0.1316       0.1806       5.3762    2538.1709      11.8129     170.6250    3744.0000
 2353.8180      62.4404      81.3877     147.8951     134.7445     137.0409       7.2971     216.0000       0.1654       0.0971       0.0643       6.5482      77.7179     256.0650     128.3059      51.0625       0.1898       0.2128       0.2655       5.1951    2543.9792       8.3361     172.0000    3768.0000
 2353.9704      58.1600      89.8958     150.7694     140.2303     140.0665       7.1395     216.0000       0.1478       0.0780       0.0445       6.6068      78.4658     277.2766     122.7784      51.0625       0.1764       0.1982       0.2504       4.8651    2576.5391       8.9803     170.6250    3766.0000
 2354.1228      59.5339     110.2175     164.0298     125.2533     158.9734       6.2904     216.0000       0.1379       0.0673       0.0334       6.6704      69.4848     248.8084     106.5447      51.0625       0.0741       0.0837       0.1295       4.6033    2594.9561      16.6484     164.5625    3748.0000
 2354.2752      47.7634     122.4145     132.9044     183.8128     202.8523       4.9297     216.0000       0.1641       0.0957       0.0628       6.5786      63.0857     244.9010      94.8074      51.0625       0.0578       0.0651       0.1090       4.6565    2546.3245      22.4415     166.7500    3768.0000
 2354.4276      34.3460      82.9375      95.4234      92.5090      85.4702      11.7000     216.0000       0.1967       0.1310       0.0994       6.5352      63.9441     239.3190     131.2721      51.0625       0.0864       0.0980       0.1445       5.0495    2486.0562      10.6732     169.0625    3772.0000
 2354.5800      26.3129      37.7621      59.2290      80.4010      80.6559      12.3984     216.0000       0.2006       0.1351       0.1037       6.2851      75.4076     251.0412     214.5009      51.0625       0.1416       0.1599       0.2105       5.5185    2478.9453       8.2622     170.7500    3801.0000
 2354.7324      19.0493      18.8666      27.7550      38.1589      31.6238      31.6218     216.0000       0.1999       0.1344       0.1029       6.2325      81.6818     264.9962     280.7732      51.0625       0.2157       0.2419       0.2949       5.8137    2480.2366       7.6266     169.6250    3828.0000
 2354.8848      26.6065      27.4176      39.6395      59.4146      41.6735      23.9961     216.0000       0.1968       0.1310       0.0994       6.6778      79.6113     284.5333     290.8623      51.0625       0.3092       0.3452       0.3964       5.8175    2485.9248       6.4637     170.6250    3777.0000
 2355.0372      62.3277      63.8768      82.2633      93.6370      91.5032      10.9286     216.0000       0.2013       0.1359       0.1045       6.9637      73.0203     297.9301     252.9323      51.0625       0.2020       0.2281       0.2802       5.6061    2477.5261       7.1631     167.3750    3806.0000
 2355.1896     101.1142     104.4555     212.4205     231.3291     229.5102       4.3571     216.0000       0.2150       0.1508       0.1199       7.1616      68.0603     258.2978     203.8603      51.0625       0.1096       0.1242       0.1730       5.3007    2452.1990       7.7437     170.0625    3811.0000
 2355.3420     112.6793     129.3879     845.7102     171.0792     905.2070       1.1047     216.0000       0.2237       0.1602       0.1296       7.0499      66.2662     245.1801     166.9910      51.0625       0.1641       0.1848       0.2365       5.0059    2436.0828       8.7059     170.6250    3822.0000
 2355.4944     109.9774     164.2857     363.9740     170.2885     326.3445       3.0642     216.0000       0.2135       0.1491       0.1181       6.2895      66.3591     243.5055     139.0533      51.0625       0.1502       0.1695       0.2204       4.7322    2455.1025       8.1993     171.0625    3856.0000
 2355.6468      96.9292     195.6594     260.3817     169.0157     131.4971       7.6047     216.0000       0.1837       0.1169       0.0848       6.2095      61.6810     256.6232     136.3666      51.0625       0.0753       0.0852       0.1309       4.5735    2510.0786      15.9170     170.6250    3805.0000
 2355.7992      67.7235     152.2111     177.1736     163.1161      80.8752      12.3647     216.0000       0.1785       0.1113       0.0789       6.2184      65.0931     249.3666     147.9480      51.0625       0.0575       0.0649       0.1086       4.6303    2519.7527      24.9468     170.6250    3815.0000
 2355.9516      54.0886     115.7723     152.6095     179.6033      74.3191      13.4555     216.0000       0.1776       0.1103       0.0780       6.7548      69.2636     240.9936     190.1143      51.0625       0.0972       0.1102       0.1578       4.8776    2521.3572      16.8055     163.9375    3841.0000
 2356.1040      48.7741      72.9369     105.4564     150.8180      59.7903      16.7251     216.0000       0.1746       0.1071       0.0746       6.3660      79.3577     241.5518     225.0771      51.0625       0.1488       0.1679       0.2188       5.1290    2526.9390      13.3137     170.4375    3782.0000
 2356.2564      71.5326      73.2574     134.6820     193.7731      60.1822      16.6162     216.0000       0.1571       0.0881       0.0549       6.2206      82.0475     261.6470     235.2292      51.0625       0.1605       0.1808       0.2324       5.1837    2559.4043      10.4784     170.6250    3869.0000
 2356.4088      83.7096      89.2220     155.5919     192.8347      92.3033      10.8339     216.0000       0.1390       0.0685       0.0346       5.9214      85.1471     253.8322     223.5382      51.0625       0.1754       0.1973       0.2494       5.0929    2592.8452      13.9642     170.3750    3835.0000
 2356.5612     100.0378      77.7278     147.6861     156.8943     109.9874       9.0919     216.0000       0.1180       0.0457       0.0110       6.1593      75.4236     256.0650     203.2330      51.0625       0.1269       0.1435       0.1933       4.9516    2631.7900      18.2588     170.6250    3843.0000
 2356.7136      97.3902     153.5751     121.5418     136.0698     126.0657       7.9324     216.0000       0.1168       0.0444       0.0097       6.2760      69.2826     248.2502     189.9965      51.0625       0.0925       0.1047       0.1521       4.9409    2634.0107      34.7105     165.0000    3804.0000
 2356.8660      61.1852      74.3235     197.1633     130.4802     292.0190       3.4244     216.0000       0.1505       0.0810       0.0476       6.8104      62.4766     251.5994     194.3686      51.0625       0.0796       0.0900       0.1363       5.1385    2571.4983      23.0270     168.0625    3786.0000
 2357.0184      39.6017      48.4514      83.9454     124.8801     139.6340       7.1616     216.0000       0.2384       0.1760       0.1461       6.6939      70.4452     258.8560     196.7554      51.0625       0.1028       0.1164       0.1646       5.5279    2408.9634       9.4709     169.3125    3808.0000
 2357.1708      24.5107      36.4556      42.4747      35.9797      60.4040      16.5552     216.0000       0.3003       0.2430       0.2154       6.8197      74.5523     264.4380     198.2534      51.0625       0.1547       0.1744       0.2256       5.8356    2294.5325       4.3228     160.8125    3847.0000
 2357.3232      15.5793      15.6709      20.3274      26.5428      40.7508      24.5394     216.0000       0.2861       0.2277       0.1996       6.6878      72.5742     279.7886     181.1745      51.0625       0.2244       0.2505       0.3041       5.7775    2320.6521       4.1069     170.6250    3851.0000
 2357.4756      25.8813      25.9728      42.2954      76.7824     107.3625       9.3142     216.0000       0.2190       0.1551       0.1244       6.0137      66.2297     274.4857     154.1312      51.0625       0.2141       0.2400       0.2930       5.3374    2444.8127       4.9596     154.5000    3844.0000
 2357.6280      56.2306      70.7716      74.3009      93.9271     133.3905       7.4968     216.0000       0.1733       0.1056       0.0730       5.6548      59.9245     242.3891     126.7738      51.0625       0.1793       0.2018       0.2540       4.8067    2529.4695      11.1197     162.4375    3791.0000
 2357.7804      88.5661      79.4008     129.1097     198.8342     265.3745       3.7683     216.0000       0.1787       0.1115       0.0792       5.4523      58.1893     243.7846     121.2971      51.0625       0.1130       0.1283       0.1766       4.5357    2519.3379      15.4114     161.3125    3810.0000
 2357.9328     121.7098     135.8508    1527.0015    1950.0000    1950.0000       0.5030     216.0000       0.1831       0.1162       0.0840       5.8135      51.7198     245.4592     154.4206      51.0625       0.0434       0.0497       0.0907       4.5658    2511.3328      32.2560     160.8125    3744.0000
 2358.0852     118.8606     216.9994    1950.0000    1458.5684    1934.7448       0.5169     216.0000       0.1686       0.1005       0.0678       6.0196      50.8728     247.4129     198.6916      51.0625       0.0406       0.0476       0.0873       4.7209    2538.1445      36.0861     160.8125    3771.0000
 2358.2376      95.1909     296.1677    1950.0000     806.2234     631.3719       1.5839     216.0000       0.1488       0.0791       0.0456       5.8776      48.1416     240.9936     229.7482      51.0625       0.0461       0.0541       0.0944       4.8268    2574.6787      48.5010     160.8125    3787.0000
 2358.3900      93.5753     289.4134    1950.0000     582.7723     349.6750       2.8598     216.0000       0.1378       0.0672       0.0333       5.9234      48.5854     243.7846     233.7070      51.0625       0.0552       0.0650       0.1060       4.8257    2595.0354      71.1761     160.8125    3818.0000
 2358.5424      84.0515     214.1877     847.2766     742.1577     174.9709       5.7152     216.0000       0.1354       0.0646       0.0306       5.7777      45.7432     244.9010     223.2356      51.0625       0.0525       0.0617       0.1025       4.7641    2599.4990      63.0035     157.8750    3813.0000
 2358.6948      77.0206     140.7494     466.8917     414.7127     116.3912       8.5917     216.0000       0.1360       0.0653       0.0313       6.0509      46.1796     240.9936     207.4201      51.0625       0.0512       0.0605       0.1009       4.6939    2598.3704      56.1782     160.8125    3829.0000
 2358.8472      70.4772     107.8772     326.1662     306.0643      87.2812      11.4572     216.0000       0.1420       0.0718       0.0380       5.9619      47.1596     242.9473     195.0705      51.0625       0.0482       0.0568       0.0971       4.6626    2587.2629      52.6553     160.8125    3796.0000
 2358.9996      85.8079      95.3477     277.8969     243.4307      93.0157      10.7509     216.0000       0.1371       0.0664       0.0325       6.5958      47.3626     243.2264     194.1450      51.0625       0.0489       0.0581       0.0981       4.6665    2596.4353      59.6097     159.2500    3750.0000
 2359.1520      85.4264     113.6050     312.9349     206.6719     138.0695       7.2427     216.0000       0.1287       0.0573       0.0231       6.8383      46.8724     248.8084     197.3085      51.0625       0.0476       0.0563       0.0963       4.6722    2611.9431      70.6997     155.4375    3717.0000
 2359.3044     100.3609     137.9999     295.2824     165.8872     151.0417       6.6207     216.0000       0.1175       0.0452       0.0105       6.4998      49.4819     243.7846     205.4434      51.0625       0.0506       0.0596       0.1001       4.6623    2632.6567      85.1091     153.1875    3685.0000
 2359.4568     108.0366     297.1185     265.6106     145.7934     151.9831       6.5797     216.0000       0.1164       0.0441       0.0093       6.1302      50.1206     240.9936     216.4958      51.0625       0.0539       0.0631       0.1043       4.6987    2634.5896      91.4265     159.3750    3696.0000
 2359.6092      85.7910     428.0892     252.9911     167.1554     139.6071       7.1630     216.0000       0.1102       0.0374       0.0024       5.4894      49.5939     237.6444     233.6216      51.0625       0.0571       0.0670       0.1084       4.7783    2646.1150      87.5018     158.7500    3772.0000
 2359.7616      66.6997     216.5110     238.0126     156.7560     104.8558       9.5369     216.0000       0.1056       0.0323      -0.0028       4.9590      51.8270     240.4354     246.9428      51.0625       0.0549       0.0644       0.1056       4.9115    2654.6941     106.8873     158.8750    3884.0000
 2359.9140      63.4823     199.3923     143.3412     127.5539      92.5106      10.8096     216.0000       0.1121       0.0394       0.0044       5.3455      56.1964     237.6444     258.8882      51.0625       0.0508       0.0597       0.1003       5.0845    2642.7046     122.0057     159.6250    4124.0000
 2360.0664      56.3089     118.2952      99.8042      98.1815      78.0059      12.8195     216.0000       0.1650       0.0966       0.0638       5.5059      62.8264     239.8772     259.5899      51.0625       0.0514       0.0599       0.1011       5.3814    2544.7874      67.7477     155.1250    4053.0000
 2360.2188      42.8896     123.4965     133.9438     139.0136      94.5496      10.5765     216.0000       0.2752       0.2158       0.1873       5.5919      64.4924     238.7608     223.1767      51.0625       0.0603       0.0695       0.1123       5.7259    2340.9229       8.1855     156.5625    3957.0000
 2360.3712      43.5114     151.1758     179.2467     161.2602     120.9098       8.2706     216.0000       0.3448       0.2911       0.2653       6.0467      66.8351     244.9010     188.9005      51.0625       0.0658       0.0748       0.1190       5.8844    2212.2070       4.3731     158.6250    3896.0000
 2360.5236      45.6189      81.8309     145.9041     159.7082     127.7564       7.8274     216.0000       0.3219       0.2664       0.2397       6.0670      69.7183     238.7608     159.6959      51.0625       0.1477       0.1666       0.2175       5.6198    2254.4961       3.9843     160.8125    3746.0000
 2360.6760      65.2917      83.3576     145.9686     115.6965     129.9618       7.6946     216.0000       0.2355       0.1729       0.1428       6.1421      72.3156     253.8322     151.1927      51.0625       0.2408       0.2678       0.3212       5.0807    2414.3628       7.0923     160.8125    3760.0000
 2360.8284      75.7626     119.6946     208.7130     215.2391     235.9343       4.2385     216.0000       0.1783       0.1110       0.0787       5.5157      65.4002     252.1576     148.1571      51.0625       0.0827       0.0956       0.1401       4.7064    2520.2178      19.9405     151.3125    3819.0000
 2360.9808      89.0799     185.1547     298.4812     288.4226     374.5691       2.6697     216.0000       0.1648       0.0964       0.0635       5.4526      55.9496     241.8309     171.3698      51.0625       0.0137       0.0152       0.0518       4.7423    2545.1665      50.0170     156.3750    3842.0000
 2361.1332      76.2830     168.3053     249.9059     628.0521     493.9541       2.0245     216.0000       0.1504       0.0809       0.0474       5.6052      49.6911     238.2026     234.4472      51.0625       0.0413       0.0477       0.0881       5.0664    2571.7332     139.8834     160.4375    3890.0000
 2361.2856      64.1011     186.9646     217.8369     218.6819     195.1092       5.1253     216.0000       0.1390       0.0686       0.0347       5.5455      57.1734     248.2502     297.1790      51.0625       0.0739       0.0848       0.1292       5.3879    2592.7773     163.2589     160.8125    3882.0000
 2361.4380      52.6670     160.1047     185.8264     169.2116     123.9178       8.0699     216.0000       0.1845       0.1177       0.0856       5.6029      66.0149     244.9010     311.0113      51.0625       0.0774       0.0882       0.1335       5.6807    2508.7480      35.0999     159.0000    3872.0000
 2361.5904      42.2139     186.1750     154.4827     117.0219      90.1980      11.0867     216.0000       0.2854       0.2269       0.1988       6.0216      68.0019     258.2978     254.7634      51.0625       0.1375       0.1556       0.2056       5.9723    2322.0413       7.2861     161.3750    3782.0000
 2361.7428      36.1160     139.4012     144.7738     107.2138      74.9589      13.3407     216.0000       0.3088       0.2523       0.2251       5.9304      67.3928     263.3217     210.6767      51.0625       0.1972       0.2210       0.2739       6.0197    2278.6406       4.5698     160.2500    3798.0000
 2361.8952      44.1864      96.0860     121.1572     118.9181      76.5579      13.0620     216.0000       0.2656       0.2055       0.1766       5.8441      64.5905     237.6444     184.3655      51.0625       0.1452       0.1646       0.2153       5.8420    2358.6191       5.1916     157.9375    3782.0000
 2362.0476      57.4967     139.6061     131.5012     155.8497     120.1678       8.3217     216.0000       0.2142       0.1499       0.1190       5.4439      65.8579     262.2052     194.3398      51.0625       0.1321       0.1500       0.2000       5.6441    2453.6777      11.8853     158.5625    3803.0000
 2362.2000      47.3425      91.7620     149.7818     189.2197     134.3917       7.4409     216.0000       0.2848       0.2262       0.1981       5.4274      68.6199     253.5531     179.9967      51.0625       0.1314       0.1490       0.1990       5.8300    2323.1772       7.1321     160.8125    3807.0000
 2362.3524      37.9995      52.4272      90.2451     138.1917     101.3494       9.8669     216.0000       0.3754       0.3243       0.2997       4.7578      74.2644     257.1814     164.1197      51.0625       0.1799       0.2027       0.2548       6.1190    2155.4973       3.7568     163.2500    3827.0000
 2362.5048      40.7406      37.2433      66.8260     180.9212     149.2731       6.6991     216.0000       0.3543       0.3014       0.2760       4.6945      75.2384     274.4857     172.0726      51.0625       0.2460       0.2734       0.3274       5.9904    2194.5928       3.3538     155.8125    3866.0000
 2362.6572      65.8716      58.8269     139.3697     259.9030     232.2388       4.3059     216.0000       0.2523       0.1911       0.1616       4.8217      75.3662     295.1391     156.2026      51.0625       0.1051       0.1196       0.1672       5.3203    2383.2886       5.4527     150.5000    3829.0000
 2362.8096      91.4012     101.0496     232.3934     458.8896     421.5111       2.3724     216.0000       0.1556       0.0865       0.0533       4.6841      67.2809     283.9751     108.2869      51.0625       0.0488       0.0558       0.0976       4.4208    2562.0720      14.1313     156.5625    3798.0000
 2362.9620     106.0014     171.8308    1375.3901    1842.8961    1950.0000       0.5027     216.0000       0.1276       0.0562       0.0218       5.1196      67.8900     267.2290      43.9219      51.0625       0.0606       0.0697       0.1126       3.7842    2613.9531      36.7270     156.5000    3798.0000
 2363.1144      81.2270     284.6551    1391.1887     953.4118     988.1664       1.0120     216.0000       0.1305       0.0593       0.0251       5.0019      61.5368     259.6933       8.5523      51.0625       0.0750       0.0859       0.1305       3.4813    2608.6672     101.9907     156.1875    3795.0000
 2363.2668      77.2321     257.5397     699.9210     407.8763     316.1528       3.1630     216.0000       0.1291       0.0578       0.0236       5.5695      67.5453     247.1338       9.8593      51.0625       0.0807       0.0920       0.1375       3.4230    2611.1018     183.6575     159.2500    3820.0000
 2363.4192      69.4133     226.1431     268.4434     298.4448     166.5254       6.0051     216.0000       0.1234       0.0516       0.0171       5.1750      64.5385     253.8322      15.5118      51.0625       0.0876       0.1000       0.1460       3.4225    2621.7522     195.1644     153.9375    3841.0000
 2363.5716      68.8965     145.2389     297.7068     360.4967     140.4136       7.1218     216.0000       0.1176       0.0454       0.0107       5.5912      66.0102     248.8084      12.4631      51.0625       0.0882       0.1005       0.1467       3.4337    2632.3616     182.7744     152.1250    3859.0000
 2363.7240      72.8636     137.5311     253.2678     264.7350     119.0727       8.3982     216.0000       0.1112       0.0384       0.0034       5.8033      62.8085     254.1113       4.6787      51.0625       0.0880       0.1007       0.1464       3.4219    2644.3662     169.5933     153.7500    3905.0000
 2363.8764      79.4504     110.3779     237.5782     240.6541      95.7709      10.4416     216.0000       0.1087       0.0357       0.0007       5.4097      60.8717     246.0174      -4.6771      51.0625       0.0843       0.0961       0.1419       3.3791    2648.8694     171.3981     153.8750    3855.0000
 2364.0288      84.4460     105.9982     275.0123     259.1205     163.6598       6.1102     216.0000       0.1121       0.0394       0.0045       4.7685      58.1941     239.3190      -7.0646      51.0625       0.0887       0.1013       0.1473       3.3336    2642.6042     112.4760     151.0625    3808.0000
 2364.1812      98.1498     115.1588     326.5121     240.4891     185.0096       5.4051     216.0000       0.1225       0.0507       0.0161       4.5348      55.7579     239.8772      -8.1899      51.0625       0.0856       0.0978       0.1435       3.3205    2623.3635      92.6483     152.0625    3858.0000
 2364.3336     119.4740     149.3254     403.7686     212.2237     220.4144       4.5369     216.0000       0.1449       0.0749       0.0413       4.0114      57.0846     250.4830      -8.9550      51.0625       0.0703       0.0806       0.1247       3.3925    2581.8882      78.2451     151.0625    3829.0000
 2364.4860     151.1811     204.3442     761.1868     232.2673     483.6201       2.0677     216.0000       0.1706       0.1027       0.0700       4.7854      57.5535     240.9936      -8.2715      51.0625       0.0702       0.0808       0.1246       3.4912    2534.4458      43.0689     142.1875    3862.0000
 2364.6384     151.4587     262.8224    1768.9364     183.3175     396.0170       2.5251     216.0000       0.1845       0.1177       0.0856       4.9868      54.7421     250.4830       9.7482      51.0625       0.0514       0.0597       0.1010       3.6526    2508.7195      43.0303     151.0625    3848.0000
 2364.7908     135.4968     243.2056    1100.0294     167.3425     248.6740       4.0213     216.0000       0.1784       0.1111       0.0788       5.3873      51.0505     247.6920      43.8507      51.0625       0.0517       0.0601       0.1015       3.8437    2520.0122      38.4060     148.1875    3829.0000
 2364.9432      97.3890     148.8972     470.8391     140.7750     153.0361       6.5344     216.0000       0.1667       0.0985       0.0657       5.9546      48.9575     247.1338      74.0185      51.0625       0.0642       0.0735       0.1171       4.0679    2541.5303      28.1009     150.6875    3840.0000
 2365.0956      74.2589     109.1146     203.4991     135.9082      91.1431      10.9718     216.0000       0.1720       0.1042       0.0716       5.9493      51.1948     247.6920      89.8652      51.0625       0.1105       0.1253       0.1737       4.3068    2531.7937      20.7938     148.6875    3830.0000
 2365.2480      53.8551      77.5354     162.9102      75.9128      57.5372      17.3801     216.0000       0.2000       0.1345       0.1030       5.3018      52.5916     247.6920     101.1803      51.0625       0.1357       0.1533       0.2035       4.6201    2480.0430      11.7757     149.4375    3840.0000
 2365.4004      51.0859      72.4935     145.9463      86.9344      58.9429      16.9656     216.0000       0.2258       0.1624       0.1319       4.6058      58.7239     252.7158     127.3501      51.0625       0.1283       0.1452       0.1949       4.9826    2432.3108       7.8910     148.7500    3843.0000
 2365.5528      44.3338      70.9396     117.5188     109.7745      58.1528      17.1961     216.0000       0.2291       0.1660       0.1356       4.1668      71.2759     249.9248     159.8387      51.0625       0.1258       0.1424       0.1919       5.2794    2426.2051       6.8290     151.0625    3846.0000
 2365.7052      37.0226      57.4017      91.5156     106.9317      55.8808      17.8952     216.0000       0.2179       0.1539       0.1231       4.3800      80.2329     259.9724     156.7705      51.0625       0.1211       0.1370       0.1864       5.4223    2446.8535       6.5376     148.5000    3795.0000
 2365.8576      31.8464      46.1364      71.9151      94.4553      54.3927      18.3848     216.0000       0.2043       0.1392       0.1079       5.3025      81.8600     269.4618     114.7394      51.0625       0.1220       0.1380       0.1876       5.4133    2471.9600       6.7627     151.0625    3828.0000
 2366.0100      34.4262      91.9466     160.1314     218.7955      52.1413      19.1787     216.0000       0.2434       0.1815       0.1517       5.6135      76.6303     288.4407      55.2268      51.0625       0.1219       0.1381       0.1878       5.4748    2399.6252       8.1881     151.0625    3840.0000
 2366.1624      25.7501      53.5766      53.2720      65.1684      50.9234      19.6373     216.0000       0.3700       0.3184       0.2936       5.8441      72.3670     287.0452      15.2712      51.0625       0.1573       0.1797       0.2299       6.0299    2165.5796       3.9335     144.1875    3828.0000
 2366.3148      13.8548      39.9839      47.8111      50.0927      47.7748      20.9315     216.0000       0.4663       0.4227       0.4017       5.9218      74.7583     286.4870      35.8524      51.0625       0.3509       0.3968       0.4415       6.5588    1987.2670       2.6308     147.1250    3781.0000
 2366.4672       9.7617      13.2555      17.2126      20.8582      20.6818      48.3518     216.0000       0.4576       0.4132       0.3918       4.4656      73.0920     286.4870     112.0770      51.0625       0.5325       0.6010       0.6247       6.8350    2003.4780       2.1074     146.2500    3794.0000
 2366.6196       9.9010      11.1445      13.9949      14.9913      16.0666      62.2410     216.0000       0.3175       0.2616       0.2347       3.6460      77.8119     338.6787     225.8482      51.0625       0.4168       0.4778       0.5107       6.4816    2262.6653       3.2492     142.8125    3798.0000
 2366.7720      15.8315      19.1918      29.5575      28.9719      44.7218      22.3604     216.0000       0.2019       0.1366       0.1052       2.9521      73.3867     314.1179     304.5921      51.0625       0.3332       0.3809       0.4238       6.1377    2476.4436       4.5410     141.1250    3792.0000
 2366.9244      32.3434      43.8630      53.9853      58.4006      59.5174      16.8018     216.0000       0.1538       0.0845       0.0512       3.4705      75.4103     283.9751     325.7532      51.0625       0.2602       0.2957       0.3451       5.9250    2565.4609       5.8387     142.8125    3784.0000
 2367.0768      43.4254      77.0844      88.4288      93.7419     119.1214       8.3948     216.0000       0.1453       0.0753       0.0416       4.2330      71.5024     291.2317     319.1297      51.0625       0.1915       0.2157       0.2680       5.8313    2581.2798       7.0477     141.3125    3846.0000
 2367.2292      47.4953     146.7856    1155.4137    1286.6259    1892.5999       0.5284     216.0000       0.1493       0.0796       0.0462       5.2945      73.5364     294.5809     316.0937      51.0625       0.1168       0.1322       0.1815       5.8364    2573.8135      10.4224     141.3125    3841.0000
 2367.3816      47.4780     220.9470    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.1458       0.0759       0.0423       5.8013      71.0486     288.4407     327.7779      51.0625       0.0894       0.1011       0.1484       5.8572    2580.2087      15.2262     137.2500    3875.0000
 2367.5340      44.4451     232.9532    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.1622       0.0936       0.0606       5.5791      69.2614     280.0677     316.5436      51.0625       0.1384       0.1564       0.2070       5.8708    2550.0151      15.7011     140.3750    3846.0000
 2367.6864      44.3328     177.5770    1950.0000    1950.0000    1950.0000       0.5001     216.0000       0.1966       0.1308       0.0992       5.5275      68.8546     272.5320     273.0670      51.0625       0.1894       0.2128       0.2654       5.7843    2486.3311       8.5451     134.0000    3797.0000
 2367.8388      46.4989     123.3393     880.4296     853.1140     857.7191       1.1659     216.0000       0.2283       0.1651       0.1347       4.2142      71.0905     281.7422     209.0928      51.0625       0.1992       0.2238       0.2765       5.5922    2427.6912       6.3774     141.3125    3777.0000
 2367.9912      47.8150      80.6031     251.5619     224.6821     228.2408       4.3813     216.0000       0.2035       0.1383       0.1070       5.0372      72.9211     279.5095     152.7081      51.0625       0.1604       0.1813       0.2327       5.2218    2473.4331       5.8422     136.8125    3768.0000
 2368.1436      60.9207      56.0769     173.1958     141.2798     148.9279       6.7147     216.0000       0.1597       0.0909       0.0579       4.0398      73.2314     266.1126     109.4644      51.0625       0.1063       0.1204       0.1691       4.8253    2554.5259       9.2240     137.1875    3770.0000
 2368.2960      46.9193      50.8947     115.7664      99.2253     103.7649       9.6372     216.0000       0.1486       0.0789       0.0454       3.7742      72.9225     264.7171      75.3872      51.0625       0.0788       0.0890       0.1354       4.6576    2575.1040      18.8172     135.1250    3807.0000
 2368.4484      50.0794      48.7426      77.2183      63.4269      63.2939      15.7993     216.0000       0.1632       0.0947       0.0618       3.8828      75.9734     301.5584      88.0897      51.0625       0.0963       0.1094       0.1566       4.9134    2548.0181      22.6345     131.5625    3855.0000
 2368.6008      37.8644      66.3634     106.7990      79.3881      76.1205      13.1371     216.0000       0.2020       0.1366       0.1052       4.0360      76.2281     287.6034     113.7359      51.0625       0.1403       0.1586       0.2087       5.4168    2476.3679      15.9186     135.8750    3856.0000
 2368.7532      49.9831      70.3539     108.7423      70.2291      63.1114      15.8450     216.0000       0.2655       0.2053       0.1764       4.5715      79.1747     313.5597     118.4883      51.0625       0.1336       0.1511       0.2011       5.8838    2358.8784       7.3129     132.0000    3853.0000
 2368.9056      55.3486      93.0406     216.0488     108.3595     128.6414       7.7735     216.0000       0.3364       0.2820       0.2559       4.7868      76.0804     283.9751      81.7142      51.0625       0.1207       0.1366       0.1861       6.0863    2227.7068       4.7886     134.0000    3867.0000
 2369.0580      79.7441      75.9763     115.0054      75.2895      72.2614      13.8386     216.0000       0.3692       0.3176       0.2928       4.3926      75.3121     285.9287      33.1006      51.0625       0.1375       0.1556       0.2060       6.0489    2166.9512       3.8882     131.3750    3914.0000
 2369.2104      73.0932      77.4378      80.0697      52.9950      54.0920      18.4870     216.0000       0.3309       0.2761       0.2498       4.6130      70.7383     297.0928      13.0558      51.0625       0.2087       0.2337       0.2869       5.7756    2237.9060       4.6771     140.3125    3823.0000
 2369.3628      29.7628      21.2952      29.5937      26.5117      17.1861      58.1866     216.0000       0.2865       0.2281       0.2000       4.6705      65.6968     305.1867      13.2658      51.0625       0.1504       0.1699       0.2210       5.4893    2319.9441       7.2053     126.1875    3816.0000
 2369.5152      39.0645      20.2579      31.1280      24.5950      23.0042      43.4704     216.0000       0.2387       0.1764       0.1464       4.7652      66.7137     320.2581      65.2497      51.0625       0.1158       0.1311       0.1803       5.4350    2408.3640      13.4841     131.5625    3926.0000
 2369.6676      44.0133      39.1433      94.2795      83.3983      57.2141      17.4782     216.0000       0.2110       0.1464       0.1153       4.3311      66.6685     347.6099     122.6425      51.0625       0.1211       0.1370       0.1865       5.5647    2459.6792      13.2613     131.5625    3852.0000
 2369.8200      47.9973      48.8321     112.6469      64.0337      70.7909      14.1261     216.0000       0.1646       0.0962       0.0633       4.1979      71.3040     280.0677     185.4775      51.0625       0.1088       0.1231       0.1718       5.7250    2545.5618      13.6725     132.9375    3836.0000
 2369.9724      33.1072      49.8049     110.4953      83.9705      77.4493      12.9117     216.0000       0.1587       0.0899       0.0568       3.8743      70.2870     288.9989     194.7939      51.0625       0.1134       0.1285       0.1772       5.7562    2556.3213      13.8042     134.8750    3786.0000
 2370.1248      22.4523      29.3804      52.1534      49.0057      25.8718      38.6521     216.0000       0.1768       0.1094       0.0770       4.1361      68.6629     292.9063     195.6959      51.0625       0.1080       0.1224       0.1708       5.8234    2522.9407      20.6861     135.6250    3803.0000
 2370.2772      17.3396      22.2330      38.0828      71.5057      19.3339      51.7227     216.0000       0.2301       0.1671       0.1368       4.7776      68.9503     299.6047     185.4398      51.0625       0.1099       0.1246       0.1734       5.9510    2424.2490       8.3825     134.1875    3805.0000
 2370.4296      24.3950      26.6630      54.0226      79.6039      28.9759      34.5114     216.0000       0.2631       0.2028       0.1738       5.1209      68.5005     334.2131     187.0520      51.0625       0.2348       0.2662       0.3171       6.0451    2363.2595       6.1122     139.1875    3781.0000
 2370.5820      33.4011      49.8098      66.3640      84.7948      58.4334      17.1135     216.0000       0.2729       0.2134       0.1848       5.1025      69.9216     357.0994     192.5659      51.0625       0.3930       0.4470       0.4856       6.0789    2345.0933       5.5586     137.6875    3795.0000
 2370.7344      35.0855      50.9259      62.3968      74.7671      63.0084      15.8709     216.0000       0.2770       0.2178       0.1894       4.3654      69.8802     370.4962     195.0142      51.0625       0.3616       0.4126       0.4534       6.0958    2337.5715       6.7721     134.1875    3759.0000
 2370.8868      24.8744      48.2395      52.3241      52.8954      66.8384      14.9615     216.0000       0.3088       0.2523       0.2251       3.4810      69.6833     334.4922     187.2025      51.0625       0.3204       0.3654       0.4101       6.2625    2278.6423       5.2855     132.5000    3679.0000
 2371.0392      16.8232      19.6493      27.2497      29.6786      58.0233      17.2345     216.0000       0.3336       0.2790       0.2528       3.6228      69.1180     352.0755     191.4451      51.0625       0.2480       0.2829       0.3321       6.4309    2232.8872       4.3852     131.5625    3741.0000
 2371.1916      11.0740      10.9578      13.4122      13.3826      28.6189      34.9419     216.0000       0.3368       0.2825       0.2564       3.9501      69.8871     390.0332     209.1796      51.0625       0.2880       0.3274       0.3753       6.5178    2226.8931       4.2167     125.1875    3805.0000
 2371.3440      16.0265      13.9353      17.5294      25.2700      51.4621      19.4318     216.0000       0.2906       0.2325       0.2046       4.8775      68.6629     359.3322     238.6444      51.0625       0.3441       0.3909       0.4348       6.3313    2312.4375       5.3471     129.6875    3908.0000
 2371.4964      32.1690      40.6825      57.3716      59.4119      82.1168      12.1778     216.0000       0.2536       0.1925       0.1631       5.2855      68.4595     283.9751     244.1778      51.0625       0.3147       0.3553       0.4032       6.0802    2380.8137       7.3063     125.6875    4014.0000
 2371.6488      41.1319      92.1654      66.5212      77.3538      95.2670      10.4968     216.0000       0.2160       0.1518       0.1210       5.3872      70.0034     313.0015     237.4666      51.0625       0.1619       0.1833       0.2346       5.8466    2450.3574       9.5669     126.8750    3974.0000
 2371.8012      42.7188     153.1478     118.3387     145.6269     133.4767       7.4919     216.0000       0.1906       0.1243       0.0925       5.0114      72.4844     333.3759     233.9053      51.0625       0.0959       0.1086       0.1565       5.7734    2497.4297      10.7337     123.8750    3936.0000
 2371.9536      43.5088     232.2273    1950.0000    1950.0000     115.9750       8.6226     216.0000       0.1913       0.1251       0.0932       3.8507      72.0351     341.4698     223.9964      51.0625       0.1500       0.1700       0.2209       5.8276    2496.1589      11.2366     127.1250    3835.0000
 2372.1060      39.4690     234.5494    1950.0000    1950.0000     211.1150       4.7368     216.0000       0.2509       0.1896       0.1601       3.0946      74.3485     343.1443     186.2311      51.0625       0.2482       0.2800       0.3315       5.9968    2385.7832       7.1605     125.6875    3924.0000
 2372.2584      33.8275     152.9141     819.7255    1297.2490     180.7114       5.5337     216.0000       0.3187       0.2630       0.2362       2.0924      73.6055     347.6099     143.2502      51.0625       0.2158       0.2434       0.2955       6.1187    2260.3376       4.9270     124.5000    3986.0000
 2372.4108      28.4443      79.6980     164.4799     295.1167     161.5842       6.1887     216.0000       0.3345       0.2800       0.2538       3.3163      73.8085     316.3507     127.3987      51.0625       0.1779       0.2021       0.2532       6.0711    2231.1907       4.4953     121.7500    3913.0000
 2372.5632      25.9514      43.8247     105.2640     178.2713     169.5960       5.8964     216.0000       0.2901       0.2320       0.2041       3.7546      73.0466     329.1893     145.4234      51.0625       0.1850       0.2097       0.2612       5.8525    2313.2522       4.9388     124.1875    3827.0000
 2372.7156      26.5388      21.7494      47.1372      97.5273     118.7750       8.4193     216.0000       0.2142       0.1499       0.1190       4.6550      69.7217     342.3071     187.7637      51.0625       0.2292       0.2578       0.3102       5.5911    2453.7114       7.1351     120.6250    3825.0000
 2372.8680      35.0640      33.8488      97.0000     197.9460     214.8484       4.6544     216.0000       0.1785       0.1112       0.0789       5.0773      69.7217     384.4512     218.1032      51.0625       0.1414       0.1598       0.2104       5.4847    2519.7859      11.1195     120.6875    3757.0000
 2373.0204      55.3925      54.4293     131.2254     246.5627     243.3909       4.1086     216.0000       0.1895       0.1232       0.0913       4.9836      60.5115     385.5676     226.7868      51.0625       0.0945       0.1076       0.1544       5.5838    2499.3616      22.9022     116.2500    3886.0000
 2373.1728      54.3299      66.8467     349.2435     677.7944     559.6398       1.7869     216.0000       0.2172       0.1531       0.1223       4.9526      61.2864     357.6576     229.9719      51.0625       0.0697       0.0803       0.1239       5.7574    2448.1924      18.3275     116.0000    3905.0000
 2373.3252      54.6029      81.3506    1429.5441    1950.0000    1474.2424       0.6783     216.0000       0.2272       0.1639       0.1335       3.8311      59.7021     322.4909     239.6710      51.0625       0.0611       0.0709       0.1133       5.8742    2429.7163      13.8492     112.6250    3983.0000
 2373.4776      45.9892      80.3611     239.5462     577.1523     180.4814       5.5407     216.0000       0.2155       0.1513       0.1204       3.6785      61.5901     320.2581     254.7467      51.0625       0.0609       0.0704       0.1130       5.8552    2451.3579      12.0484     113.5000    4121.0000
 2373.6300      37.9763      68.0960     161.9303     392.3156     105.3645       9.4909     216.0000       0.2097       0.1450       0.1139       3.1071      56.5147     325.2819     258.8572      51.0625       0.0621       0.0724       0.1146       5.8166    2462.0610      11.8439     116.5000    4108.0000
 2373.7824      32.1357      46.5109      87.6790     288.4610      44.0452      22.7040     216.0000       0.2084       0.1436       0.1124       2.5425      52.4145     323.6073     258.2250      51.0625       0.0500       0.0578       0.0992       5.7827    2464.4614      14.0293     116.5000    4006.0000
 2373.9348      48.4204      69.7969      62.5329     149.7364      37.4351      26.7129     216.0000       0.2015       0.1362       0.1047       3.8118      50.9907     307.4195     259.8565      51.0625       0.0630       0.0734       0.1157       5.7865    2477.1626      16.1075     118.5625    3882.0000
 2374.0872      56.8009      95.9731     260.5563     462.8234     134.2189       7.4505     216.0000       0.1703       0.1024       0.0697       4.0456      48.9860     297.9301     261.4594      51.0625       0.0667       0.0770       0.1203       5.7494    2534.9392      20.5195     119.6875    3828.0000
 2374.2396      65.6515     279.6774     190.9938     143.0400      87.0840      11.4832     216.0000       0.1698       0.1019       0.0692       5.0200      48.4082     299.3256     236.0919      51.0625       0.0611       0.0708       0.1133       5.7510    2535.8018      20.3799     121.7500    3818.0000
 2374.3920      59.9031     206.2758     177.1362     149.7322      78.8787      12.6777     216.0000       0.2032       0.1380       0.1067       4.9874      52.5856     285.0915     198.0369      51.0625       0.0644       0.0740       0.1174       5.8224    2473.9927       9.6029     116.6250    3830.0000
 2374.5444      76.5243     180.6603     240.8612      76.1213      66.1131      15.1256     216.0000       0.2714       0.2118       0.1831       4.7890      57.2637     271.1364     149.3182      51.0625       0.0661       0.0751       0.1194       5.9738    2347.8882       5.7095     122.6875    3811.0000
 2374.6968      66.4082     160.4184     113.6439      64.5891      57.5127      17.3875     216.0000       0.3111       0.2547       0.2276       4.0128      67.1803     301.8375     114.6691      51.0625       0.1143       0.1294       0.1783       6.0423    2274.4631       4.2845     123.1875    3828.0000
 2374.8492      71.6413     113.2252      84.3819      52.1052      42.8654      23.3289     216.0000       0.3179       0.2620       0.2352       2.9970      71.6987     311.3269      89.0553      51.0625       0.1831       0.2056       0.2580       5.9836    2261.9624       4.3158     124.3125    3796.0000
 2375.0016     131.9655     191.3487      98.0559      99.8515      58.3284      17.1443     216.0000       0.2730       0.2135       0.1849       3.0883      80.8515     312.4433     101.3651      51.0625       0.1197       0.1355       0.1849       5.8833    2344.8672       5.2225     127.1250    3745.0000
 2375.1540      86.6695     110.1447      81.2565      70.0350      43.6169      22.9269     216.0000       0.2419       0.1799       0.1501       3.0467      79.7852     316.9089     119.7896      51.0625       0.1266       0.1432       0.1930       5.8692    2402.4106       7.9980     124.5000    3810.0000
 2375.3064      41.0441      33.2468      36.6947      55.8855      26.4236      37.8449     216.0000       0.2100       0.1453       0.1142       4.1890      76.9878     312.4433     158.6926      51.0625       0.1785       0.2007       0.2530       5.9476    2461.5156       9.1065     131.0625    3889.0000
 2375.4588      67.9095      22.1874      24.5906      35.1174      21.3407      46.8589     216.0000       0.2160       0.1518       0.1210       3.5513      76.3275     327.5147     183.7761      51.0625       0.1544       0.1744       0.2256       6.0599    2450.3621      10.3917     131.5625    4020.0000
 2375.6112      70.2598     109.0225      66.1246      78.7513      43.2850      23.1027     216.0000       0.2476       0.1860       0.1564       4.7008      77.7998     318.3044     196.0898      51.0625       0.1491       0.1685       0.2195       6.2291    2391.9858       6.5631     138.0000    4102.0000
 2375.7636      95.1035     113.5968      92.1009     102.3916      56.5057      17.6973     216.0000       0.3000       0.2427       0.2151       5.0885      80.4439     315.7925     181.3273      51.0625       0.1291       0.1463       0.1963       6.3993    2295.0378       4.7727     131.5625    4011.0000
 2375.9160      38.5546     122.7165      90.0474      79.7189      52.1449      19.1773     216.0000       0.3518       0.2988       0.2733       5.0881      78.9426     330.3058     145.3283      51.0625       0.1312       0.1488       0.1989       6.5029    2199.0784       3.2468     137.8750    3975.0000
 2376.0684      33.1730      52.4862      56.1788      46.4675      39.1480      25.5441     216.0000       0.3677       0.3160       0.2911       4.5025      78.1795     343.1443     114.8849      51.0625       0.2102       0.2378       0.2895       6.4467    2169.7019       2.9251     135.2500    3902.0000
 2376.2208      42.6155      40.1292      33.2514      29.3690      28.8469      34.6657     216.0000       0.3665       0.3146       0.2897       3.5588      77.1147     335.8877      94.5225      51.0625       0.2839       0.3208       0.3704       6.2807    2171.9734       2.8172     133.0000    3810.0000
 2376.3732      40.1251      48.9155      37.3496      32.8439      33.0941      30.2169     216.0000       0.3542       0.3014       0.2760       3.8660      75.5708     337.0042      99.9396      51.0625       0.3266       0.3666       0.4153       6.1341    2194.6775       3.0213     134.3750    3879.0000
 2376.5256      33.8698      65.5962      56.2682      47.8609      47.3376      21.1248     216.0000       0.3266       0.2715       0.2450       3.4966      73.5207     337.0042     131.4974      51.0625       0.1912       0.2184       0.2688       6.0748    2245.7437       3.7515     134.6875    3860.0000
 2376.6780      48.2831      78.1951      73.5431      60.9906      67.5030      14.8141     216.0000       0.2670       0.2070       0.1781       2.8474      73.5207     361.5650     192.6823      51.0625       0.1750       0.1990       0.2500       6.0479    2356.0620       4.9302     136.2500    3911.0000
 2376.8304      79.1181      67.4586     106.8762      94.8111     109.0664       9.1687     216.0000       0.2381       0.1757       0.1457       3.2411      76.6161     316.9089     232.5442      51.0625       0.2345       0.2653       0.3166       6.0753    2409.5713       7.2212     130.0000    4031.0000
 2376.9828      88.9686     121.4976     164.3193     168.6366     203.0803       4.9242     216.0000       0.2412       0.1791       0.1492       3.9600      73.3388     367.4261     255.5659      51.0625       0.2250       0.2533       0.3056       6.1323    2403.7417       9.6728     134.1250    3896.0000
 2377.1352      93.2784     228.4249     316.3181     396.3118     484.7571       2.0629     216.0000       0.2630       0.2026       0.1736       4.5024      71.9176     331.9803     272.7342      51.0625       0.1952       0.2194       0.2720       6.2347    2363.5007      12.9821     132.0000    3900.0000
 2377.2876      85.3617     189.3558    1591.3226    1811.1469    1860.9017       0.5374     216.0000       0.2623       0.2019       0.1729       4.8029      66.0192     290.6735     292.0337      51.0625       0.0981       0.1110       0.1589       6.2609    2364.7905      12.9989     137.1875    3873.0000
 2377.4400      75.3980     135.0435     842.3160    1844.3717    1908.7832       0.5239     216.0000       0.2378       0.1754       0.1454       4.5188      64.3712     311.3269     309.0019      51.0625       0.0641       0.0728       0.1170       6.1915    2410.0374      15.5472     131.5625    3835.0000
 2377.5924      55.9073      97.8548     313.9703    1055.8184    1261.6187       0.7926     216.0000       0.2354       0.1729       0.1428       4.0965      62.3825     309.6523     287.2305      51.0625       0.0768       0.0879       0.1327       6.0718    2414.4197      15.4627     135.8750    3840.0000
 2377.7448      44.5642      54.4703     150.5376     552.6471     684.0294       1.4619     216.0000       0.2302       0.1672       0.1369       3.3090      62.3825     317.7462     266.2742      51.0625       0.0824       0.0943       0.1397       5.9478    2424.1267      15.9027     131.0625    3913.0000
 2377.8972      40.9312      50.2188     143.8117     276.4388     346.1943       2.8886     216.0000       0.2091       0.1443       0.1132       3.0822      62.2033     318.8626     264.2095      51.0625       0.0915       0.1045       0.1508       5.8355    2463.2312      19.2556     131.5625    3974.0000
 2378.0496      44.0050      47.4688     135.1401     147.3956     180.6282       5.5362     216.0000       0.2198       0.1560       0.1253       3.5970      62.1619     324.1655     241.3423      51.0625       0.0881       0.1002       0.1466       5.8016    2443.2998      17.6188     131.0625    4045.0000
 2378.2020      47.3797      49.4066     122.9662      88.3624     104.6981       9.5513     216.0000       0.2284       0.1652       0.1349       3.5519      64.1958     324.7237     213.2294      51.0625       0.0967       0.1098       0.1571       5.7471    2427.4832       8.7303     131.2500    3961.0000
 2378.3544      45.1095      50.6555     117.9665      62.1591      68.3964      14.6206     216.0000       0.2325       0.1696       0.1394       4.3213      64.1429     309.3732     164.9370      51.0625       0.1173       0.1328       0.1818       5.5892    2419.9155       7.2699     129.0000    4016.0000
 2378.5068      53.7793      88.3242      72.5363      45.1197      40.3700      24.7709     216.0000       0.1894       0.1230       0.0911       4.1905      62.9640     302.6748     154.6996      51.0625       0.1170       0.1325       0.1815       5.3074    2499.6758       6.8172     126.5625    3925.0000
 2378.6592      75.8518     116.8511     133.4653      50.1722      49.8583      20.0568     216.0000       0.1757       0.1082       0.0758       4.1492      61.9059     301.8375     146.0645      51.0625       0.1005       0.1138       0.1618       5.1507    2525.0066       9.1840     127.1875    3913.0000
 2378.8116     136.3992     205.4605     168.0289      45.9536      38.5888      25.9143     216.0000       0.1869       0.1203       0.0883       3.7833      68.8614     313.0015     150.7201      51.0625       0.1221       0.1381       0.1876       5.2173    2504.2759      10.4969     124.7500    3951.0000
 2378.9640     100.9902     828.7094     342.1222      43.9802      36.1675      27.6492     216.0000       0.2062       0.1412       0.1100       3.2140      72.1157     333.6549     151.4411      51.0625       0.1205       0.1363       0.1858       5.4013    2468.4893      12.1554     126.1875    3951.0000
 2379.1164     165.9112     417.1868     401.4414      56.0654      37.1189      26.9405     216.0000       0.2101       0.1454       0.1143       3.1550      71.7735     308.5359     156.1155      51.0625       0.1359       0.1537       0.2041       5.5356    2461.3699      13.2753     127.0625    3904.0000
 2379.2688     212.8612     305.6116     429.1286      74.6724      39.5444      25.2880     216.0000       0.2009       0.1354       0.1040       3.1919      69.5848     312.1642     181.5734      51.0625       0.1790       0.2016       0.2538       5.6201    2478.4026      11.8480     125.1875    3772.0000
 2379.4212     250.4163     213.3433    1006.9539      93.7770      44.6937      22.3745     216.0000       0.2029       0.1377       0.1063       3.8916      69.7425     319.1417     212.9521      51.0625       0.1873       0.2106       0.2631       5.7210    2474.5559       8.3754     121.7500    3775.0000
 2379.5736     252.8985     136.2099    1148.4437     150.1666      51.6763      19.3512     216.0000       0.1951       0.1292       0.0975       3.7678      69.6788     325.8401     256.1073      51.0625       0.1923       0.2159       0.2686       5.8270    2489.0959       7.0984     125.3750    3839.0000
 2379.7260     220.6948      98.0143     582.1591     179.9019      47.5041      21.0508     216.0000       0.1875       0.1210       0.0890       4.2133      64.5939     322.4909     284.9760      51.0625       0.1465       0.1654       0.2163       5.8771    2503.0742       8.0194     121.7500    3931.0000
 2379.8784     153.5071      79.5250     385.7615     218.2785      47.3057      21.1391     216.0000       0.1765       0.1090       0.0766       3.6210      64.2327     305.1867     314.2042      51.0625       0.0937       0.1061       0.1535       5.9021    2523.5413      16.1890     126.1875    3984.0000
 2380.0308     112.1103      62.3504     235.6232     189.9589      97.4608      10.2605     216.0000       0.1901       0.1238       0.0919       3.7975      63.6003     289.8362     316.2126      51.0625       0.0445       0.0500       0.0921       5.9535    2498.3398      26.5963     127.9375    3993.0000
 2380.1832     124.3487      55.8289     145.7509     134.3750     123.2209       8.1155     216.0000       0.2066       0.1416       0.1104       3.9607      66.4075     287.3243     295.6877      51.0625       0.0668       0.0764       0.1204       5.9686    2467.8225      12.8238     126.3750    3882.0000
 2380.3356      81.3329      51.8166      97.2201      97.4489     147.7034       6.7703     216.0000       0.2072       0.1423       0.1111       3.5781      69.2048     279.5095     263.0701      51.0625       0.1115       0.1269       0.1748       5.8448    2466.6394      10.5843     126.9375    3806.0000
 2380.4880      63.8997      44.6976      54.3836      47.3875     117.7268       8.4942     216.0000       0.1880       0.1215       0.0896       3.7494      76.9965     285.0915     225.7407      51.0625       0.1418       0.1602       0.2107       5.5353    2502.1719      10.0034     122.0000    3799.0000
 2380.6404      61.7878      62.1266      63.3444      49.3467     154.2300       6.4838     216.0000       0.1658       0.0976       0.0647       3.5594      82.3250     292.9063     182.8382      51.0625       0.1679       0.1890       0.2409       5.1485    2543.1787      13.2730     130.0000    3685.0000
 2380.7928      63.0129      76.2495     108.6823      63.2961     132.3282       7.5570     216.0000       0.1549       0.0857       0.0525       3.3927      81.2878     314.1179     129.4465      51.0625       0.1681       0.1892       0.2411       4.7876    2563.3914      14.8690     121.7500    3779.0000
 2380.9452      30.8955      82.2619      72.6217      66.8713     130.8234       7.6439     216.0000       0.1561       0.0870       0.0538       3.4630      73.5588     280.6259     103.7056      51.0625       0.1075       0.1217       0.1702       4.6601    2561.2170      30.7221     129.8750    3899.0000
 2381.0976      26.6044      71.2797      63.9026      73.5761     112.7531       8.8689     216.0000       0.1736       0.1060       0.0735       3.6477      67.6212     277.8349     120.7318      51.0625       0.0696       0.0788       0.1239       4.8438    2528.7852      52.9248     122.3125    4001.0000
 2381.2500      75.9266      70.0949      78.6375      63.3651     122.3423       8.1738     216.0000       0.1875       0.1210       0.0891       3.6324      60.5378     267.2290     169.0703      51.0625       0.0649       0.0730       0.1179       5.2100    2503.0396      15.2869     121.7500    4086.0000
 2381.4024      71.5379      64.0802      67.7501      63.4824      76.8206      13.0173     216.0000       0.1924       0.1263       0.0945       3.4743      63.7921     277.8349     200.3860      51.0625       0.1407       0.1590       0.2096       5.4761    2494.0342       7.9829     126.4375    4030.0000
 2381.5548      42.4855      38.0271      69.2321      63.1800      65.3394      15.3047     216.0000       0.1951       0.1292       0.0975       3.7872      70.2886     313.0015     190.0647      51.0625       0.2401       0.2687       0.3218       5.4671    2489.1289       6.8115     126.2500    3932.0000
 2381.7072      35.5943      25.1264      44.9516      47.6376      30.8505      32.4144     216.0000       0.1996       0.1341       0.1026       3.3524      76.7294     310.2105     169.9064      51.0625       0.2823       0.3154       0.3677       5.3154    2480.6624       8.2452     119.1250    3834.0000
 2381.8596      85.7132      33.0240      74.1381      60.3042      48.0126      20.8279     216.0000       0.1943       0.1283       0.0966       3.3861      75.4661     304.0703     158.2718      51.0625       0.2382       0.2681       0.3202       5.1179    2490.6201       8.3280     121.7500    3721.0000
 2382.0120     115.2455      59.2071     155.5995     229.8723     110.4158       9.0567     216.0000       0.1594       0.0905       0.0575       3.5597      72.4209     314.6761     159.9767      51.0625       0.1833       0.2071       0.2590       4.8961    2555.1851       9.5823     121.7500    3751.0000
 2382.1644     335.6209     105.7819     488.1684     275.9832     224.0495       4.4633     216.0000       0.1326       0.0616       0.0274       3.5759      70.6931     336.4459     156.0526      51.0625       0.1019       0.1153       0.1636       4.6922    2604.7410      15.8495     121.7500    3865.0000
 2382.3168     281.5423     194.1583    1867.5273    1392.9470     232.7207       4.2970     216.0000       0.1397       0.0693       0.0354       3.9637      71.9564     275.6021     155.1857      51.0625       0.1020       0.1156       0.1636       4.6184    2591.5442      33.5784     122.2500    3897.0000
 2382.4692     205.2377     273.8135    1950.0000    1950.0000     114.6913       8.7191     216.0000       0.1635       0.0951       0.0621       3.7454      68.3021     270.0200     175.3099      51.0625       0.1120       0.1270       0.1754       4.7119    2547.4600      22.8133     126.4375    4068.0000
 2382.6216     142.7832     267.1070    1539.5228    1445.7201     159.6156       6.2651     216.0000       0.1514       0.0819       0.0485       3.4388      69.5121     276.1603     213.3892      51.0625       0.1181       0.1341       0.1826       4.8127    2569.9172      22.9948     126.6250    4133.0000
 2382.7740      99.4600     192.1636     400.7919     338.5791     121.1140       8.2567     216.0000       0.1241       0.0524       0.0179       3.3449      67.0307     280.0677     247.1359      51.0625       0.0906       0.1033       0.1496       4.8651    2620.4624      34.8683     121.7500    4101.0000
 2382.9264      83.7254     133.3699     249.2035     211.0140     121.2711       8.2460     216.0000       0.1170       0.0447       0.0100       3.2459      68.6966     278.1140     268.7943      51.0625       0.0578       0.0658       0.1090       4.9645    2633.4885      73.4451     125.8750    4047.0000
 2383.0788      84.1381      80.3778     169.9317     149.1902     104.3310       9.5849     216.0000       0.1492       0.0795       0.0460       2.6705      64.8425     260.5306     274.2328      51.0625       0.0625       0.0714       0.1150       5.1679    2574.0430      50.6385     125.7500    3944.0000
 2383.2312      47.2411      44.7408      97.7727      79.4715      79.7730      12.5356     216.0000       0.1699       0.1019       0.0692       3.2090      65.3995     270.0200     281.0052      51.0625       0.0920       0.1054       0.1513       5.3918    2535.7690      22.2704     126.1250    3772.0000
 2383.3836      38.8074      30.5553      53.7599      44.3579      48.3194      20.6956     216.0000       0.1581       0.0891       0.0560       3.2859      68.4029     270.5782     277.9589      51.0625       0.0989       0.1131       0.1597       5.4811    2557.5962      17.9848     123.3750    3829.0000
 2383.5360      47.1381      45.5414      83.6568      57.5281      68.7347      14.5487     216.0000       0.1319       0.0608       0.0267       3.6059      69.9883     277.8349     273.4585      51.0625       0.1055       0.1204       0.1677       5.4399    2605.9907      22.8009     123.6250    3854.0000
 2383.6884      52.7278      85.7119     156.3066     127.9370     117.6304       8.5012     216.0000       0.1272       0.0558       0.0214       3.8838      67.2346     286.4870     279.6204      51.0625       0.0702       0.0799       0.1246       5.4067    2614.6106      48.1590     125.0000    3965.0000
 2383.8408      63.1192     116.0452     222.3005     182.7430     140.5612       7.1143     216.0000       0.1588       0.0899       0.0568       3.0736      64.2312     261.6470     278.5041      51.0625       0.0574       0.0650       0.1086       5.4400    2556.2068      29.7418     123.3750    4099.0000
 2383.9932      73.8295     188.8866     689.8541     889.7864     308.3468       3.2431     216.0000       0.1780       0.1107       0.0783       3.1815      69.0528     271.4155     270.7062      51.0625       0.0748       0.0852       0.1303       5.4247    2520.7241      15.0847     123.6250    4008.0000
 2384.1456      86.8044     261.6549    1950.0000    1569.4475     185.0987       5.4025     216.0000       0.1633       0.0948       0.0619       3.4039      76.1717     273.9275     238.3976      51.0625       0.1360       0.1539       0.2037       5.2080    2547.9456      13.2859     122.2500    4126.0000
 2384.2980     103.5503     309.3059    1950.0000    1950.0000     302.1083       3.3101     216.0000       0.1301       0.0589       0.0246       3.5129      85.2655     278.9513     200.3953      51.0625       0.1437       0.1623       0.2127       4.8322    2609.3513      17.2915     128.1250    4085.0000
 2384.4504     118.3153     312.0747    1384.5797    1057.4055     174.4896       5.7310     216.0000       0.1244       0.0527       0.0182       3.1299      87.9555     292.3481     173.0518      51.0625       0.1169       0.1323       0.1814       4.5657    2619.9346      26.7154     121.7500    3977.0000
 2384.6028     121.1182     288.2008     822.6204     623.2217     253.8576       3.9392     216.0000       0.1267       0.0552       0.0208       2.9933      85.2149     290.9526     170.7735      51.0625       0.1250       0.1415       0.1910       4.4891    2615.5979      26.8440     121.7500    3877.0000
 2384.7552     111.5480     190.2863     478.2893     424.6173     260.9606       3.8320     216.0000       0.1351       0.0643       0.0302       3.1244      77.6026     287.8825     180.9630      51.0625       0.0988       0.1121       0.1597       4.5888    2600.1006      29.9459     122.5000    3816.0000
 2384.9076      94.5691     221.6915     306.9167     290.7119     267.1937       3.7426     216.0000       0.1355       0.0648       0.0308       3.4438      71.7147     281.7422     195.1206      51.0625       0.0888       0.1010       0.1475       4.7741    2599.2563      31.2598     122.9375    3788.0000
 2385.0600      77.4552     140.7463     426.8694     420.0681     464.8538       2.1512     216.0000       0.2107       0.1460       0.1150       3.1808      69.3302     274.4857     176.3325      51.0625       0.0850       0.0968       0.1428       5.1595    2460.2729      28.3993     123.8125    3818.0000
 2385.2124      76.8267      64.7984     158.5031     206.1134     179.1053       5.5833     216.0000       0.3404       0.2863       0.2604       3.5274      67.6037     278.3931     154.2711      51.0625       0.0643       0.0728       0.1172       5.7807    2220.3494       5.3263     125.6875    3829.0000
 2385.3648      34.2458      39.0944      59.4450      56.9855      58.7835      17.0116     216.0000       0.4369       0.3908       0.3686       3.4563      67.0388     286.2079     158.3947      51.0625       0.1021       0.1159       0.1636       6.3609    2041.7814       3.0899     121.7500    3900.0000
 2385.5172      21.5251      22.6396      34.2707      59.2562      48.5493      20.5976     216.0000       0.4022       0.3533       0.3298       3.0928      62.2289     274.4857     223.9783      51.0625       0.1693       0.1905       0.2423       6.5323    2105.9026       2.9401     121.7500    3995.0000
 2385.6696      40.5617      33.7856      64.9223     128.0165     109.3172       9.1477     216.0000       0.3063       0.2495       0.2223       3.4464      62.2704     296.2555     284.7494      51.0625       0.1721       0.1935       0.2454       6.3203    2283.2776       4.7676     121.9375    4015.0000
 2385.8220      67.1163      67.6874     112.5649     153.3834     140.0208       7.1418     216.0000       0.2362       0.1737       0.1436       2.9413      62.0236     285.6496     303.0524      51.0625       0.0782       0.0885       0.1346       5.9572    2412.9812       7.7019     123.0625    3987.0000
 2385.9744     112.7241     105.2285     327.1992     556.0137     533.5453       1.8743     216.0000       0.2089       0.1441       0.1130       2.8113      70.0818     264.4380     283.7546      51.0625       0.0996       0.1130       0.1607       5.6359    2463.6211       7.7410     125.1250    3897.0000
 2386.1268     123.2556     198.3496    1676.8638     998.9189    1629.6293       0.6136     216.0000       0.1622       0.0936       0.0606       2.4278      75.3700     276.1603     280.3581      51.0625       0.0990       0.1127       0.1599       5.3149    2549.9907      10.1043     116.8125    3837.0000
 2386.2792     112.3444     318.2207     964.3733     308.6272     488.2415       2.0482     216.0000       0.1147       0.0422       0.0074       2.9110      81.3119     286.4870     277.8039      51.0625       0.0886       0.1011       0.1473       5.0170    2637.8225      16.0103     121.7500    3823.0000
 2386.4316      98.9203     251.9425     434.7441     402.7075     270.2272       3.7006     216.0000       0.1030       0.0295      -0.0058       3.5218      78.2666     277.5558     263.9921      51.0625       0.0756       0.0859       0.1313       4.8752    2659.5261      26.3662     121.7500    3832.0000
 2386.5840      62.6107     206.4277     289.1488     274.9427     248.0489       4.0315     216.0000       0.1243       0.0526       0.0181       3.5715      74.9671     282.8586     228.2724      51.0625       0.0897       0.1019       0.1486       4.8673    2620.0996      22.6189     121.7500    3846.0000
 2386.7364      58.3613     162.2220     265.7028     227.0951     189.4488       5.2785     216.0000       0.1328       0.0618       0.0277       3.5168      70.0178     280.0677     214.9234      51.0625       0.1129       0.1279       0.1766       4.9453    2604.2925      19.0896     121.0625    3901.0000
 2386.8888      72.4943     131.4486     342.4458     343.5540     279.3882       3.5792     216.0000       0.1310       0.0599       0.0257       3.2211      73.9230     296.8137     215.9305      51.0625       0.1188       0.1347       0.1836       5.0239    2607.5791      18.5262     118.8125    3879.0000
 2387.0412      95.4372     133.3155     461.2873     461.4680     317.7149       3.1475     216.0000       0.1309       0.0597       0.0255       2.9799      68.2731     282.5796     236.4635      51.0625       0.1240       0.1404       0.1897       5.1214    2607.8464      17.3329     120.6875    3864.0000
 2387.1936     113.0518     178.7023     618.1962     673.2250     349.0137       2.8652     216.0000       0.1388       0.0683       0.0344       2.8700      66.8746     275.3229     257.7634      51.0625       0.1183       0.1340       0.1830       5.2397    2593.2214      13.1336     117.4375    3823.0000
 2387.3460     123.5661     207.1289     954.4604    1118.6689     666.9241       1.4994     216.0000       0.1559       0.0868       0.0536       3.1311      63.1724     283.4169     266.6817      51.0625       0.1098       0.1246       0.1728       5.3596    2561.6123      12.8093     119.5000    3763.0000
 2387.4984     124.6210     288.5082    1927.5490    1939.3406    1688.1216       0.5924     216.0000       0.1594       0.0906       0.0576       3.1259      67.0369     283.9751     286.3503      51.0625       0.0788       0.0895       0.1352       5.4716    2555.0400      15.1901     121.7500    3837.0000
 2387.6508     119.7740     382.9111    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.1715       0.1037       0.0711       2.8749      68.4355     277.8349     307.7178      51.0625       0.0762       0.0868       0.1320       5.5714    2532.6472      23.5383     121.7500    3837.0000
 2387.8032     113.5474     438.3139    1950.0000    1950.0000     946.3366       1.0567     216.0000       0.2127       0.1483       0.1173       3.0615      70.7139     275.6021     305.9921      51.0625       0.0852       0.0972       0.1431       5.7071    2456.4575      18.0742     118.1875    3915.0000
 2387.9556     107.8694     394.4758    1950.0000    1950.0000     535.4186       1.8677     216.0000       0.2151       0.1508       0.1200       3.3248      68.6419     272.5320     307.3924      51.0625       0.1023       0.1167       0.1638       5.6855    2452.0735      16.2863     117.8750    3924.0000
 2388.1080     104.0741     310.2858    1666.9189    1087.1554     267.4314       3.7393     216.0000       0.1908       0.1245       0.0927       3.1637      61.9650     259.9724     283.2556      51.0625       0.0993       0.1136       0.1602       5.4818    2497.0759      20.3005     121.5625    3907.0000
 2388.2604     100.1319     238.0020    1300.6888     589.7320     196.9745       5.0768     216.0000       0.1305       0.0593       0.0251       3.0639      55.4563     268.9037     264.4255      51.0625       0.0676       0.0776       0.1214       5.1023    2608.5352      41.5434     117.8750    3885.0000
 2388.4128      97.3920     203.7349    1136.6406     506.1039     175.7700       5.6893     216.0000       0.1151       0.0426       0.0078       2.4498      50.2060     271.6946     226.7718      51.0625       0.0463       0.0534       0.0945       4.8641    2637.1299      58.5307     121.0000    3837.0000
 2388.5652      95.3727     183.3246     740.7989     223.6934     158.0540       6.3270     216.0000       0.1108       0.0380       0.0030       2.5533      52.7055     269.4618     220.5648      51.0625       0.0538       0.0625       0.1040       4.8598    2645.0325      40.4926     121.4375    3829.0000
 2388.7176     110.5345     234.0039     748.5544     267.6469     213.5102       4.6836     216.0000       0.1119       0.0392       0.0042       3.0334      56.1633     272.8111     255.5933      51.0625       0.0654       0.0760       0.1187       5.0868    2643.0310      46.5610     121.4375    3793.0000
 2388.8700     137.8526     346.1999     869.2183     408.0461     265.5675       3.7655     216.0000       0.1326       0.0616       0.0275       3.0506      61.8196     271.1364     299.4699      51.0625       0.0668       0.0769       0.1204       5.3971    2604.6934      27.6369     117.8750    3794.0000
 2389.0224     148.1440     399.2242     703.1094     310.9644     249.0879       4.0146     216.0000       0.1868       0.1202       0.0882       3.4276      60.3351     280.0677     316.2465      51.0625       0.0783       0.0897       0.1346       5.6867    2504.4221      11.6743     121.7500    3807.0000
 2389.1748     143.1139     438.0225     532.2108     299.6747     191.2685       5.2283     216.0000       0.2019       0.1366       0.1052       3.2607      57.0808     275.0439     319.5067      51.0625       0.1092       0.1244       0.1720       5.7650    2476.4783       9.2676     121.7500    3813.0000
 2389.3272     124.8906     256.8821     252.7227     179.8171     160.6252       6.2257     216.0000       0.1709       0.1030       0.0704       3.2867      57.2604     275.3229     293.6497      51.0625       0.0994       0.1131       0.1603       5.5783    2533.8503      12.2308     126.5000    3819.0000
 2389.4796     123.8207     750.9958     437.0216     294.2910     178.7516       5.5944     216.0000       0.1260       0.0545       0.0201       3.2411      60.5493     283.9751     242.2075      51.0625       0.0787       0.0895       0.1351       5.2284    2616.8542      24.7420     119.9375    3823.0000
 2389.6320     127.4281     690.3507     849.4863     454.1524     234.3416       4.2673     216.0000       0.1299       0.0587       0.0244       3.4004      61.7339     279.5095     187.4394      51.0625       0.0804       0.0915       0.1372       5.0323    2609.7046      20.8923     122.3750    3877.0000
 2389.7844     114.7081     289.4565     494.5257     336.5807     225.4107       4.4363     216.0000       0.1499       0.0803       0.0469       2.7880      60.9453     248.8084     189.1799      51.0625       0.0901       0.1027       0.1491       5.1051    2572.6169      15.3274     126.3750    3851.0000
 2389.9368     124.9809     152.9912     200.3153     154.2352     127.8790       7.8199     216.0000       0.1607       0.0920       0.0590       3.0890      63.0862     264.9962     248.3449      51.0625       0.1025       0.1166       0.1641       5.3584    2552.6577      15.8472     121.7500    3880.0000
 2390.0892     142.8109     101.7932     140.4983      80.8558      76.6361      13.0487     216.0000       0.1631       0.0946       0.0617       3.3902      65.7661     283.9751     315.0015      51.0625       0.1102       0.1252       0.1733       5.5724    2548.2146      22.7257     129.2500    3855.0000
 2390.2416     151.6794     148.4399     351.4754     218.5004     178.2822       5.6091     216.0000       0.1870       0.1205       0.0885       3.3140      67.0241     322.2119     336.9548      51.0625       0.0953       0.1084       0.1554       5.6788    2503.9854      24.7868     121.6250    3781.0000
 2390.3940     155.9015     271.5970     499.4801     308.5053     246.9415       4.0495     216.0000       0.2023       0.1370       0.1056       3.3148      64.0305     285.6496     310.5910      51.0625       0.0875       0.0996       0.1459       5.6076    2475.7024      14.6430     129.8750    3835.0000
 2390.5464     175.9315     474.1359    1837.9352     999.8171     508.1522       1.9679     216.0000       0.1786       0.1114       0.0790       3.2088      65.8169     266.1126     247.3991      51.0625       0.1033       0.1175       0.1650       5.3128    2519.5859      11.2504     126.8125    3846.0000
 2390.6988     191.3172     641.3314    1950.0000     880.3718     511.5148       1.9550     216.0000       0.1436       0.0735       0.0398       3.0813      64.4620     258.8560     168.5929      51.0625       0.0934       0.1064       0.1531       4.8545    2584.2937      14.1914     130.2500    3845.0000
 2390.8512     190.9308     792.8156    1950.0000     615.2912     309.5594       3.2304     216.0000       0.1280       0.0566       0.0223       3.1018      67.3042     260.5306     128.3228      51.0625       0.0718       0.0818       0.1266       4.5293    2613.1663      30.5171     131.5625    3846.0000
 2391.0036     185.7224     856.4206    1886.1587     669.8668     310.6125       3.2194     216.0000       0.1364       0.0656       0.0317       3.1525      64.0940     262.7634     147.9011      51.0625       0.0744       0.0850       0.1297       4.5195    2597.7522      83.0400     133.1250    3804.0000
 2391.1560     176.8828     814.7065    1872.4225    1013.1927     248.3668       4.0263     216.0000       0.1289       0.0576       0.0234       3.4065      63.3788     277.8349     211.6981      51.0625       0.0900       0.1031       0.1490       4.7258    2611.4680      59.5715     128.9375    3834.0000
 2391.3084     169.2475     727.9054    1885.2931     900.3132     384.9657       2.5976     216.0000       0.1212       0.0493       0.0147       3.2058      61.5517     272.8111     253.0124      51.0625       0.0763       0.0877       0.1322       4.9129    2625.7351      59.3221     128.8750    3838.0000
 2391.4608     165.2901     689.9989    1598.5975     638.5637     308.0954       3.2457     216.0000       0.1291       0.0577       0.0235       3.0908      62.3766     259.9724     246.4340      51.0625       0.0723       0.0826       0.1271       4.9339    2611.2539      45.9281     131.5625    3816.0000
 2391.6132     160.5482     635.7191    1192.1370     483.1549     303.9298       3.2902     216.0000       0.1280       0.0566       0.0223       3.3288      64.0007     248.8084     225.1809      51.0625       0.0901       0.1032       0.1491       4.7818    2613.2148      31.7110     131.5625    3844.0000
 2391.7656     172.2088     738.7674    1112.0079     453.2976     383.7123       2.6061     216.0000       0.0998       0.0262      -0.0093       2.7780      60.7875     260.5306     202.2130      51.0625       0.0827       0.0948       0.1400       4.4757    2665.2808      25.9804     131.5625    3865.0000
 2391.9180     175.1536     892.3801    1719.4490     497.4920     722.4152       1.3842     216.0000       0.0609      -0.0160      -0.0529       3.3978      57.3184     242.1100     173.7967      51.0625       0.0768       0.0880       0.1328       4.0829    2737.3123      37.8509     131.5625    3872.0000
 2392.0704     146.1016     856.9020    1050.8827     438.0332     644.1154       1.5525     216.0000       0.0481      -0.0298      -0.0673       3.3049      57.2950     230.3878     111.8965      51.0625       0.0744       0.0852       0.1297       3.6702    2761.0125      85.7697     131.9375    3941.0000
 2392.2228     137.8319     594.3323     604.5278     336.0760     414.1716       2.4145     216.0000       0.0616      -0.0152      -0.0521       3.2365      59.0871     230.3878      47.3044      51.0625       0.0720       0.0826       0.1268       3.3712    2736.0139     333.3042     131.5625    3920.0000
 2392.3752     148.4223     412.5662     393.3956     287.3926     386.3485       2.5883     216.0000       0.0678      -0.0085      -0.0452       3.0275      58.0390     235.4116       5.6546      51.0625       0.0779       0.0900       0.1342       3.1810    2724.5537     414.4276     131.5625    3865.0000
 2392.5276     155.5032     499.7779     724.3029     350.5212     353.5976       2.8281     216.0000       0.0722      -0.0038      -0.0403       3.3401      54.8472     242.1100      -4.7109      51.0625       0.0551       0.0640       0.1057       3.1660    2716.4150     426.7203     133.7500    3880.0000
 2392.6800     164.1562     608.8447    1069.5195     383.5482     329.5684       3.0343     216.0000       0.0819       0.0068      -0.0294       3.3151      53.6053     229.2714      -0.9665      51.0625       0.0473       0.0548       0.0957       3.2554    2698.4487     911.1141     140.9375    3852.0000
 2392.8324     147.5621     549.5762     658.7523     345.5286     333.6183       2.9974     216.0000       0.0815       0.0063      -0.0298       3.3030      52.8229     229.2714      21.4849      51.0625       0.0580       0.0674       0.1094       3.4397    2699.2441     387.4496     131.5625    3828.0000
 2392.9848     149.6109     419.8286     946.8165     402.8138     319.2187       3.1326     216.0000       0.0727      -0.0033      -0.0398       3.3392      53.0263     229.8296      48.9082      51.0625       0.0753       0.0870       0.1309       3.5710    2715.5972     206.7658     131.5625    3822.0000
 2393.1372     143.0206     386.4758    1046.7195     390.2032     309.5438       3.2306     216.0000       0.0581      -0.0190      -0.0561       3.2043      48.5562     229.2714      60.7851      51.0625       0.0855       0.0984       0.1434       3.6053    2742.5090     202.2696     138.1250    3803.0000
 2393.2896     143.9519     358.6525    1211.7813     406.6685     349.2042       2.8637     216.0000       0.0692      -0.0071      -0.0437       3.4014      47.3436     231.5042      42.9609      51.0625       0.0688       0.0794       0.1229       3.5527    2722.0693     195.7809     138.7500    3856.0000
 2393.4420     141.8312     364.1827    1168.9823     461.5272     342.0109       2.9239     216.0000       0.0860       0.0111      -0.0248       3.4692      48.9343     233.7370      18.5280      51.0625       0.0577       0.0665       0.1090       3.4792    2690.9675     293.8615     141.0625    3864.0000
 2393.5944     146.9686     440.4679    1323.1769     637.7684     398.1193       2.5118     216.0000       0.0895       0.0150      -0.0209       3.5348      53.8712     240.4354      13.1917      51.0625       0.0680       0.0787       0.1219       3.4025    2684.4333     211.9697     141.3125    3891.0000
 2393.7468     149.1481     550.1205    1950.0000    1704.4584     614.3220       1.6278     216.0000       0.0932       0.0189      -0.0168       3.0147      57.9313     244.9010       9.6240      51.0625       0.0711       0.0821       0.1257       3.3200    2677.6609     253.1331     141.3125    3885.0000
 2393.8992     148.2156     686.1732    1950.0000    1926.6646     661.0331       1.5128     216.0000       0.0861       0.0113      -0.0246       2.9474      51.2318     230.1087       9.3088      51.0625       0.0658       0.0760       0.1192       3.2484    2690.6384     269.0401     139.8750    3847.0000
 2394.0516     147.9241     758.8985    1568.1538    1409.4626     780.1643       1.2818     216.0000       0.0873       0.0126      -0.0233       2.4632      52.1575     232.0624       4.9391      51.0625       0.0672       0.0778       0.1209       3.2008    2688.4790     390.5125     141.3125    3860.0000
 2394.2040     148.6122     730.3394    1409.3019    1378.5770     950.2385       1.0524     216.0000       0.0710      -0.0051      -0.0416       2.8212      53.5436     232.6206      23.4990      51.0625       0.0548       0.0633       0.1053       3.2026    2718.6545     369.6678     142.0625    3822.0000
 2394.3564     152.1822     558.6540    1297.6061    1318.8573    1070.6376       0.9340     216.0000       0.0651      -0.0115      -0.0482       3.1819      61.5000     234.8534      27.3645      51.0625       0.0663       0.0771       0.1198       3.1929    2729.6023     154.9712     141.8125    3806.0000
 2394.5088     138.0462     331.3113     663.3366     598.0209     583.3948       1.7141     216.0000       0.0603      -0.0166      -0.0536       3.5376      59.9641     240.4354      23.9255      51.0625       0.0664       0.0772       0.1199       3.1165    2738.3696     175.4320     144.8125    3856.0000
 2394.6612     140.0771     227.4754     375.7993     378.9117     365.1792       2.7384     216.0000       0.0638      -0.0128      -0.0497       3.2874      56.8074     236.2489       4.0939      51.0625       0.0630       0.0739       0.1158       2.9860    2731.9248     197.1494     147.8125    3847.0000
 2394.8136     133.0314     248.4745     404.2973     325.8359     376.5134       2.6559     216.0000       0.0677      -0.0086      -0.0453       3.2544      53.7564     231.5042      -3.2935      51.0625       0.0473       0.0551       0.0958       2.8808    2724.7454     671.3711     149.3125    3886.0000
 2394.9660     136.2110     256.8390     421.2538     276.1037     328.4149       3.0449     216.0000       0.0769       0.0013      -0.0350       3.1332      52.5074     231.5042      -2.5742      51.0625       0.0413       0.0480       0.0881       2.8907    2707.7168     609.0111     151.0625    3913.0000
 2395.1184     120.1106     328.4720     353.9991     228.5638     274.0395       3.6491     216.0000       0.0906       0.0162      -0.0196       3.3986      55.2580     231.5042      18.0979      51.0625       0.0557       0.0646       0.1065       3.0656    2682.3459     530.3442     151.0625    3921.0000
 2395.2708     120.2670     330.6758     312.0057     209.2338     252.2208       3.9648     216.0000       0.0999       0.0262      -0.0092       3.4212      58.2702     232.6206      45.3718      51.0625       0.0754       0.0872       0.1311       3.3159    2665.2183      84.9080     152.1250    3895.0000
 2395.4232     123.7450     308.6846     348.6346     215.1896     238.7160       4.1891     216.0000       0.1056       0.0323      -0.0028       3.2031      62.7736     235.9698      69.2437      51.0625       0.0965       0.1109       0.1568       3.5388    2654.6902      35.9763     151.3750    3860.0000
 2395.5756     130.5172     318.7852     425.6279     202.1187     223.5131       4.4740     216.0000       0.0995       0.0258      -0.0097       3.4595      66.8784     236.5280      78.6555      51.0625       0.0764       0.0876       0.1323       3.6386    2665.9395      34.5246     152.7500    3825.0000
 2395.7280     131.5881     299.9385     296.0958     202.2589     194.5209       5.1408     216.0000       0.0864       0.0116      -0.0243       3.4701      65.6655     238.7608      94.0330      51.0625       0.0825       0.0942       0.1397       3.7157    2690.1409      73.8719     151.6250    3839.0000
 2395.8804     124.3828     214.1752     241.5358     190.1749     140.5964       7.1126     216.0000       0.0637      -0.0129      -0.0498       3.5581      64.6086     240.4354     111.7008      51.0625       0.0882       0.1007       0.1468       3.8265    2732.1162     120.9280     154.8750    3820.0000
 2396.0328     142.7903     246.8656     358.3545     242.5850     208.9274       4.7864     216.0000       0.0628      -0.0140      -0.0508       3.5394      65.3762     235.6907     120.8076      51.0625       0.0782       0.0889       0.1344       4.0033    2733.9006     136.4656     152.0625    3815.0000
 2396.1852     132.6680     366.7086     453.3969     360.5796     289.3651       3.4558     216.0000       0.0630      -0.0137      -0.0506       3.3730      64.4876     234.2952     131.6824      51.0625       0.0854       0.0972       0.1433       4.1907    2733.4133      55.9872     151.0625    3822.0000
 2396.3376     120.2942     271.2120     314.6527     314.5497     244.1896       4.0952     216.0000       0.0790       0.0036      -0.0326       3.6248      62.2545     234.8534     144.5768      51.0625       0.1107       0.1257       0.1738       4.3563    2703.7869      43.5136     153.1250    3852.0000
 2396.4900     103.1208     168.6661     271.0809     233.3843     174.0829       5.7444     216.0000       0.0889       0.0143      -0.0216       3.2854      57.2156     246.0174     156.3456      51.0625       0.1208       0.1372       0.1859       4.4388    2685.5632      41.8202     157.9375    3927.0000
 2396.6424     150.1487     240.8032     621.1370     369.4409     228.4558       4.3772     216.0000       0.1136       0.0411       0.0062       3.2479      63.2203     252.7158     156.7307      51.0625       0.0946       0.1077       0.1546       4.4824    2639.7654      45.9959     160.8125    3914.0000
 2396.7948     162.0076     476.4894     762.8544     511.0207     390.6929       2.5596     216.0000       0.1162       0.0438       0.0090       3.1975      68.5052     254.3904     161.7956      51.0625       0.0866       0.0985       0.1447       4.4797    2635.1113      45.2872     157.8750    3853.0000
 2396.9472     161.7310     521.0754    1365.3361    1119.9506     787.4955       1.2698     216.0000       0.1128       0.0402       0.0053       3.3770      73.5441     257.1814     159.5921      51.0625       0.0812       0.0926       0.1382       4.4299    2641.2939      41.7739     157.1875    3870.0000
 2397.0996     144.2106     520.9258    1411.4736     586.1669     649.2708       1.5402     216.0000       0.1032       0.0298      -0.0055       3.2855      71.6710     257.7396     142.9751      51.0625       0.0802       0.0913       0.1369       4.3243    2659.0989      71.6911     158.3750    3876.0000
 2397.2520     124.5788     388.8810     958.4942     642.3832     394.4330       2.5353     216.0000       0.1341       0.0632       0.0291       3.4545      68.8625     254.9486     107.1367      51.0625       0.0911       0.1040       0.1502       4.3245    2601.9536      81.8866     159.9375    3885.0000
 2397.4044     113.8252     350.0015     958.2853     549.0081     368.3124       2.7151     216.0000       0.1612       0.0925       0.0595       3.2457      65.8811     256.6232     112.9048      51.0625       0.0788       0.0900       0.1352       4.5279    2551.7830      34.6220     155.9375    3862.0000
 2397.5568     115.2708     328.8480     844.3774     503.8778     343.9635       2.9073     216.0000       0.1665       0.0982       0.0654       3.1022      62.0591     257.7396     173.1255      51.0625       0.0790       0.0905       0.1355       4.8814    2542.0149      25.9451     158.9375    3852.0000
 2397.7092     120.0270     305.2226     715.3177     447.3276     315.7343       3.1672     216.0000       0.1376       0.0670       0.0331       3.5758      64.2520     254.9486     254.0643      51.0625       0.0856       0.0978       0.1435       5.1752    2595.4521      22.8857     160.1250    3839.0000
 2397.8616     127.6014     389.3830     600.0338     378.6078     280.7810       3.5615     216.0000       0.1085       0.0355       0.0004       3.3738      66.8274     254.9486     303.9322      51.0625       0.0836       0.0955       0.1411       5.2934    2649.2852      25.3429     159.2500    3902.0000
 2398.0140     122.0925     248.0740     491.0178     326.5433     247.3612       4.0427     216.0000       0.1001       0.0264      -0.0090       3.6417      66.2852     261.0888     299.0034      51.0625       0.1007       0.1145       0.1619       5.2258    2664.8643      24.6954     160.0625    3914.0000
 2398.1664     120.4028     187.5557     251.8832     191.5695     150.2871       6.6539     216.0000       0.0896       0.0151      -0.0208       3.2693      63.4430     261.0888     267.3514      51.0625       0.1125       0.1281       0.1760       4.9766    2684.2612      31.4820     159.0625    3961.0000
 2398.3188     137.0970     321.7432     482.4420     301.1592     225.6510       4.4316     216.0000       0.0847       0.0098      -0.0262       3.4407      58.4033     263.3217     210.9251      51.0625       0.0756       0.0864       0.1313       4.5964    2693.3008      75.3438     160.8125    3905.0000
 2398.4712     190.7503     370.1370     761.2469     286.2574     200.3689       4.9908     216.0000       0.0829       0.0078      -0.0282       3.1364      59.1490     259.4142     154.0871      51.0625       0.0591       0.0679       0.1107       4.2170    2696.5923     250.6966     160.5000    3929.0000
 2398.6236     160.8659     457.3615    1426.9132     608.6697     401.0287       2.4936     216.0000       0.0998       0.0261      -0.0093       3.0918      56.7128     246.5756     112.6358      51.0625       0.0590       0.0678       0.1105       4.0495    2665.3694     332.6881     160.8125    3943.0000
 2398.7760     132.0766     317.9413     489.7032     356.0569     232.2891       4.3050     216.0000       0.1084       0.0354       0.0003       3.3085      61.9620     246.0174     123.9948      51.3421       0.0705       0.0813       0.1250       4.1563    2649.4670      99.7150     160.8125    3931.0000
 2398.9284     116.3259     166.4466     302.9929     244.0178     161.4242       6.1949     216.0000       0.1116       0.0389       0.0039       3.4714      64.3624     254.3904     162.2741      51.0625       0.0728       0.0838       0.1278       4.4246    2643.5164      89.9218     160.8125    3883.0000
 2399.0808     114.9631     132.0168     204.3056     187.7362     122.1971       8.1835     216.0000       0.1036       0.0302      -0.0051       3.5544      64.8038     255.5068     197.0863      51.0625       0.0840       0.0964       0.1416       4.6367    2658.3533      81.1667     160.0625    3840.0000
 2399.2332     112.2185      96.0926     140.8722     123.8375      91.1714      10.9684     216.0000       0.1035       0.0301      -0.0051       3.6522      57.3773     258.8560     199.9249      51.0625       0.0814       0.0935       0.1384       4.7364    2658.4670     189.0109     160.8125    3829.0000
 2399.3856     106.0699     141.0242     209.1574     165.4746     121.5399       8.2278     216.0000       0.1123       0.0397       0.0047       3.0792      56.6040     263.8798     186.7054      51.3421       0.0539       0.0616       0.1041       4.7956    2642.1890     119.7657     160.3125    3870.0000
 2399.5380      99.8113     236.4196     341.5557     217.0760     146.4726       6.8272     216.0000       0.1193       0.0472       0.0126       3.2608      61.0350     271.6946     187.5143      51.0625       0.0648       0.0742       0.1178       4.9087    2629.2498      48.5915     160.8125    3846.0000
 2399.6904      86.1689     229.7271     382.8899     220.7842     330.0038       3.0303     216.0000       0.1298       0.0585       0.0243       3.3295      66.0188     271.6946     199.7678      51.3421       0.0885       0.1009       0.1471       5.0950    2609.9424      23.4790     160.8125    3876.0000
 2399.8428      95.1081     162.3470     210.8489     181.4660     150.4562       6.6465     216.0000       0.1184       0.0462       0.0116       3.2987      69.2278     267.7872     221.1642      51.0625       0.1196       0.1356       0.1845       5.2387    2630.9167      18.4095     160.8125    3934.0000
 2399.9952      89.8857     115.5104     157.7786     156.3660     133.5022       7.4905     216.0000       0.1184       0.0462       0.0115       3.5451      69.0248     282.3004     221.6227      51.0625       0.1500       0.1693       0.2200       5.3067    2630.9517      19.1817     160.8125    3880.0000
 2400.1476      86.4018      92.4178     135.5624     134.9440     104.2760       9.5899     216.0000       0.1105       0.0377       0.0027       3.4476      66.8285     289.5571     210.5176      51.3421       0.1119       0.1266       0.1755       5.2661    2645.5974      19.5067     161.5625    3884.0000
 2400.3000      88.7570      87.0353      92.2342      87.4961      76.8367      13.0146     216.0000       0.1148       0.0423       0.0075       3.5409      65.2467     290.6735     188.9434      51.3421       0.1184       0.1340       0.1832       5.2091    2637.5818      20.4671     161.4375    3914.0000
 2400.4524      55.4605      61.7617      77.6744      58.2205      50.5885      19.7674     216.0000       0.1100       0.0371       0.0021       3.3681      64.4346     302.9539     187.1259      51.3421       0.1204       0.1362       0.1856       5.1879    2646.4878      19.4578     159.6875    3911.0000
 2400.6048      92.4143     139.2092     146.9653     130.7000      97.8054      10.2244     216.0000       0.1167       0.0444       0.0096       3.5216      64.6007     303.2330     193.4464      51.3421       0.1097       0.1242       0.1729       5.2121    2634.1323      17.1524     161.7500    3923.0000
 2400.7572     117.7036     161.3450     221.8965     189.7657     125.8381       7.9467     216.0000       0.1197       0.0476       0.0130       3.5202      60.1260     283.9751     209.5153      51.3421       0.1136       0.1286       0.1775       5.2502    2628.6243      14.6429     160.8125    3880.0000
 2400.9096      76.5502     123.1214     169.6752     197.1444     141.7232       7.0560     216.0000       0.1187       0.0466       0.0119       2.9496      55.8965     295.1391     217.3896      51.0625       0.1420       0.1604       0.2111       5.2581    2630.3372      13.0997     161.1875    3867.0000
 2401.0620      63.5307      68.4606      77.6314      76.5961      63.8699      15.6568     216.0000       0.1106       0.0378       0.0028       3.4530      57.5610     313.5597     218.2059      51.3421       0.1351       0.1527       0.2030       5.2473    2645.4111      15.0410     164.1250    3870.0000
 2401.2144      77.8460     115.0788     152.9822     117.3024      82.8150      12.0751     216.0000       0.1083       0.0352       0.0002       3.5649      59.5577     304.6285     217.2708      51.3421       0.1401       0.1583       0.2090       5.2286    2649.7363      16.4277     154.9375    3876.0000
 2401.3668     113.9929     207.3996     222.1265     205.2855     148.7007       6.7249     216.0000       0.1090       0.0361       0.0010       3.7254      61.4143     302.3957     216.0187      51.3421       0.1180       0.1335       0.1829       5.2320    2648.3289      20.7660     158.6875    3924.0000
 2401.5192      76.2813     210.8292     219.9634     204.2993     144.6080       6.9152     216.0000       0.1046       0.0313      -0.0039       3.9438      61.7800     295.6973     211.7305      51.3421       0.1300       0.1470       0.1971       5.2120    2656.5085      22.9389     160.8125    3919.0000
 2401.6716      84.7647     116.4013     216.9328     213.5594     174.7771       5.7216     216.0000       0.1026       0.0292      -0.0061       3.9302      64.6648     306.0240     194.6385      51.3421       0.1287       0.1456       0.1954       5.1810    2660.1101      26.6395     160.8125    3912.0000
 2401.8240      91.0904      99.4970     158.6017     176.7314     202.4851       4.9386     216.0000       0.1043       0.0310      -0.0042       3.7151      65.0455     298.4883     169.8153      51.3421       0.1206       0.1364       0.1858       5.1254    2657.0125      27.3931     159.1250    3933.0000
 2401.9764      79.8726      83.5183     139.9308     147.6649     145.9056       6.8537     216.0000       0.1064       0.0333      -0.0019       2.7328      63.0154     309.0941     153.8272      51.3421       0.1302       0.1472       0.1972       5.1044    2653.1082      28.1642     160.8125    3910.0000
 2402.1288      73.4508      99.7352     242.5410     271.4041     268.3469       3.7265     216.0000       0.1056       0.0324      -0.0028       3.5202      64.1905     302.3957     147.3184      51.3421       0.1460       0.1649       0.2158       5.0925    2654.5903      26.6627     158.5625    3902.0000
 2402.2812      78.9282     167.3695     334.1970     371.8449     346.9267       2.8825     216.0000       0.0996       0.0258      -0.0096       3.2916      64.9645     298.7674     155.8626      51.3421       0.1027       0.1163       0.1646       5.0725    2665.8093      30.8116     159.9375    3866.0000
 2402.4336      61.1739     137.9034     527.4446     438.1475     549.7222       1.8191     216.0000       0.0999       0.0262      -0.0092       3.4361      66.3856     296.2555     166.9254      51.3421       0.1198       0.1355       0.1849       5.0072    2665.2512      25.8501     155.4375    3862.0000
 2402.5860      60.7097      99.2660     198.5870     269.5556     195.3447       5.1192     216.0000       0.1017       0.0282      -0.0072       3.6270      66.5665     304.0703     177.4592      51.3421       0.1324       0.1496       0.1998       4.9307    2661.8159      17.5986     152.3750    3813.0000
 2402.7384      52.4814      70.6483     132.3515     232.7240     142.1581       7.0344     216.0000       0.1019       0.0284      -0.0069       3.5533      72.7079     298.4883     174.0389      51.3421       0.1394       0.1575       0.2080       4.8535    2661.3967      13.3053     155.8750    3870.0000
 2402.8908      66.7338      76.2498     150.4696     288.0416     110.9337       9.0144     216.0000       0.0889       0.0143      -0.0216       3.0014      79.8667     296.8137     171.2491      51.3421       0.1500       0.1693       0.2203       4.7782    2685.5786      13.5126     150.3125    3893.0000
 2403.0432     107.3833     145.4176     257.6476     365.8910     241.0323       4.1488     216.0000       0.0850       0.0100      -0.0260       2.8280      80.9043     292.6272     163.7762      51.3421       0.1465       0.1655       0.2164       4.6881    2692.8245      17.6066     150.3750    3904.0000
 2403.1956     112.9174     183.6209     627.2280     839.6315     551.4521       1.8134     216.0000       0.0945       0.0204      -0.0152       3.0599      78.2497     301.8375     156.3401      51.3421       0.1410       0.1593       0.2100       4.5648    2675.1248      18.3542     151.0625    3885.0000
 2403.3480      91.0555     217.5391     780.5845     702.8984     781.0685       1.2803     216.0000       0.1025       0.0290      -0.0063       3.5430      73.9332     315.2343     143.1022      51.3421       0.1413       0.1596       0.2102       4.3825    2660.4343      15.8928     151.0625    3883.0000
 2403.5004      89.1407     167.4804     426.0294     369.1365     417.7260       2.3939     216.0000       0.0961       0.0221      -0.0134       3.6669      74.3871     272.2528     126.3909      51.3421       0.1340       0.1515       0.2016       4.1093    2672.1343      19.5246     149.4375    3913.0000
 2403.6528      94.7890     184.9946     336.8187     198.1722     186.7024       5.3561     216.0000       0.0898       0.0153      -0.0205       3.9329      71.5500     280.0677     115.3824      51.3421       0.0779       0.0883       0.1341       3.8423    2683.8889      32.8063     147.0000    3908.0000
 2403.8052     113.6451     313.6765     743.4462     632.7121     619.1452       1.6151     216.0000       0.0862       0.0113      -0.0246       3.8477      68.0988     291.2317     113.9195      51.3421       0.0776       0.0885       0.1338       3.6734    2690.6025      80.9439     150.0000    3818.0000
 2403.9576     124.2066     366.4169    1787.0182    1112.8408     530.4688       1.8851     216.0000       0.0905       0.0160      -0.0198       3.6034      65.7286     285.0915     118.6073      51.3421       0.0856       0.0981       0.1436       3.6623    2682.6128      85.5264     148.5000    3892.0000
 2404.1100     127.4969     406.2554    1023.1854     953.7919     221.5413       4.5138     216.0000       0.0874       0.0127      -0.0232       3.7153      67.7181     278.1140     122.1108      51.3421       0.0915       0.1048       0.1508       3.7173    2688.3047      71.8564     147.8750    3950.0000
 2404.2624     127.4575     317.5440     664.4318     355.0209     248.7514       4.0201     216.0000       0.0898       0.0152      -0.0206       3.9310      68.5301     281.7422     116.6360      51.3421       0.0771       0.0887       0.1331       3.7738    2683.9551      71.0183     148.6250    3973.0000
 2404.4148     140.4144     280.8080     488.1990     322.8191     234.5010       4.2644     216.0000       0.0833       0.0083      -0.0278       3.3425      63.1426     278.3931     107.2369      51.3421       0.0593       0.0681       0.1110       3.7778    2695.8101      99.0268     149.7500    3974.0000
 2404.5672     166.6443     422.4260     431.5050     258.0360     192.3852       5.1979     216.0000       0.0697      -0.0065      -0.0431       2.7407      56.2716     267.2290     101.6180      51.3421       0.0537       0.0623       0.1039       3.7694    2721.0879     139.6670     150.0625    3853.0000
 2404.7196     116.6420     302.8683     464.8860     223.4356     155.0395       6.4500     216.0000       0.0662      -0.0103      -0.0470       3.4084      53.2610     267.7872     101.7842      51.3421       0.0503       0.0585       0.0997       3.8436    2727.5457     179.6403     150.0000    3865.0000
 2404.8720      82.5120     142.2038     145.8217     107.4691      91.0989      10.9771     216.0000       0.0665      -0.0099      -0.0466       3.4342      54.8803     262.2052     118.5491      51.3421       0.0558       0.0649       0.1066       4.1009    2726.8926     123.1133     151.0625    3841.0000
 2405.0244      88.2317     121.2472     113.3943      93.8337      79.2161      12.6237     216.0000       0.0713      -0.0047      -0.0412       3.6188      58.5031     277.2766     147.2120      51.3421       0.0720       0.0833       0.1269       4.5012    2718.0234      53.0563     151.0625    3823.0000
 2405.1768     125.5024     350.4926     303.4740     227.1050     147.8738       6.7625     216.0000       0.0771       0.0015      -0.0348       3.6058      64.5945     268.3454     179.5986      51.3421       0.0655       0.0750       0.1187       4.9072    2707.3677      44.6602     151.0625    3829.0000
 2405.3292     113.2406     306.2030     479.9428     277.4757     152.2205       6.5694     216.0000       0.0866       0.0118      -0.0242       3.4108      68.2921     281.4631     196.8203      51.3421       0.0808       0.0922       0.1376       5.1577    2689.8550      24.8689     151.0625    3888.0000
 2405.4816     114.9512     216.3905     354.6314     217.0135     129.1525       7.7428     216.0000       0.0900       0.0155      -0.0203       3.5030      67.9237     279.5095     191.4458      51.3421       0.1234       0.1399       0.1890       5.2124    2683.4346      18.3111     151.0625    3935.0000
 2405.6340     113.4861     115.6178     199.2902     141.5014      89.7344      11.1440     216.0000       0.0764       0.0008      -0.0356       3.4810      62.4067     281.1841     175.1389      51.3421       0.1357       0.1535       0.2034       5.1162    2708.6770      18.4963     152.0000    3929.0000
 2405.7864     127.1567     165.8140     316.8349     198.6978      96.2765      10.3868     216.0000       0.0707      -0.0054      -0.0420       3.4552      61.7796     299.0465     153.9023      51.3421       0.0963       0.1093       0.1566       4.9838    2719.2461      32.5210     155.3125    3890.0000
 2405.9388     171.2617     225.7510     304.8656     203.2975     164.5528       6.0771     216.0000       0.0669      -0.0095      -0.0462       3.6832      61.3359     294.0227     151.4456      51.3421       0.0865       0.0983       0.1446       4.8874    2726.2554      61.9317     154.7500    3926.0000
 2406.0912     106.3449     166.9717     285.6736     177.5630     157.9948       6.3293     216.0000       0.0788       0.0034      -0.0328       3.3835      61.9449     278.1140     149.8253      51.3421       0.0927       0.1054       0.1523       4.8536    2704.1567      47.9988     153.2500    3916.0000
 2406.2436      88.3316     124.5615     170.2131     128.3849     121.9145       8.2025     216.0000       0.0801       0.0048      -0.0314       3.5355      60.3348     288.4407     158.3142      51.3421       0.0971       0.1103       0.1576       4.8440    2701.8005      42.3538     155.5625    3884.0000
 2406.3960      84.9410     144.3750     175.9868     115.6255     127.4728       7.8448     216.0000       0.0882       0.0135      -0.0223       3.6952      61.1852     290.6735     152.7612      51.3421       0.1104       0.1251       0.1736       4.8299    2686.8623      32.6031     155.0625    3926.0000
 2406.5484      87.9760     179.4830     191.5106     144.8289     114.5670       8.7285     216.0000       0.0851       0.0102      -0.0258       3.8130      63.3082     299.6047     145.4692      51.3421       0.1148       0.1301       0.1789       4.7720    2692.5813      29.8429     157.0000    3902.0000
 2406.7008      84.7505     193.1052     175.5410     142.2187     111.8842       8.9378     216.0000       0.0870       0.0123      -0.0236       3.6711      64.6902     295.6973     127.7459      51.3421       0.1223       0.1384       0.1878       4.7084    2688.9583      27.2732     155.3125    3888.0000
 2406.8532      80.9267     152.6082     175.9921     159.9487     133.7093       7.4789     216.0000       0.0851       0.0102      -0.0258       3.4837      63.6367     294.8600     114.5780      51.3421       0.1229       0.1390       0.1885       4.7025    2692.5366      30.8125     154.8750    3918.0000
 2407.0056      82.5670     204.8325     230.0850     232.1222     140.5636       7.1142     216.0000       0.1039       0.0306      -0.0047       3.8071      62.9743     291.2317     107.0332      51.3421       0.1058       0.1199       0.1681       4.8258    2657.7314      36.2425     155.0625    3893.0000
 2407.1580      90.9165     201.6584     368.3082     390.6380     274.5957       3.6417     216.0000       0.1284       0.0571       0.0228       3.5340      61.9940     301.2793     121.9184      51.3421       0.1013       0.1148       0.1627       5.0606    2612.4124      26.0522     154.7500    3929.0000
 2407.3104      89.9884     122.1378     324.7615     324.1864     287.8132       3.4745     216.0000       0.1510       0.0815       0.0481       3.7462      64.8780     291.7899     148.1597      51.3421       0.1268       0.1434       0.1932       5.2812    2570.5959      14.0054     156.3125    3972.0000
 2407.4628      59.8901      54.8407     108.1573     114.8528     137.7079       7.2617     216.0000       0.1353       0.0645       0.0304       3.3442      67.0716     292.9063     179.2803      51.3421       0.1348       0.1523       0.2026       5.3543    2599.7576      13.4428     155.0625    3955.0000
 2407.6152      96.2412      69.4126     139.1066     133.3325     182.7479       5.4720     216.0000       0.1086       0.0356       0.0006       3.5700      70.0822     309.6523     187.5174      51.3421       0.1133       0.1283       0.1771       5.2720    2649.0735      17.4315     157.0000    3955.0000
 2407.7676     159.1023     119.7320     202.8347     207.4174     214.3859       4.6645     216.0000       0.0774       0.0019      -0.0344       3.4023      69.8034     286.7661     173.7943      51.3421       0.1273       0.1439       0.1937       5.1001    2706.7954      32.3027     153.2500    3918.0000
 2407.9200     161.0089     162.6356     281.6034     275.1072     234.1624       4.2705     216.0000       0.0693      -0.0069      -0.0435       3.7543      67.2395     278.3931     140.5730      51.3421       0.1132       0.1283       0.1769       4.9482    2721.8079      45.5300     156.2500    3891.0000
 2408.0724     106.7155     144.9096     426.9209     562.0740     303.5974       3.2938     216.0000       0.0662      -0.0103      -0.0470       3.6278      63.0686     288.7198     116.3957      51.3421       0.0893       0.1014       0.1481       4.8540    2727.5642      70.2675     156.6875    3913.0000
 2408.2248      84.0861     148.2792     194.6053     197.3553     113.6606       8.7981     216.0000       0.0746      -0.0012      -0.0376       3.6438      64.7711     294.5809     111.4914      51.3421       0.0715       0.0811       0.1262       4.8378    2712.0205      78.3471     157.5000    3884.0000
 2408.3772      62.0084     149.4091     222.4503     201.1047     105.2004       9.5057     216.0000       0.0932       0.0189      -0.0168       4.1343      67.8994     283.9751     128.5925      51.3421       0.0900       0.1019       0.1490       4.8713    2677.6697      46.4216     154.1875    3884.0000
 2408.5296      46.1107     101.6459     215.7503     165.4189      84.8319      11.7880     216.0000       0.1209       0.0489       0.0144       3.6636      73.7570     283.4169     145.1843      51.3421       0.1392       0.1573       0.2077       4.9313    2626.3074      15.5623     154.8125    3890.0000
 2408.6820      38.8707      70.8238      88.0409      79.2546      53.5833      18.6625     216.0000       0.1315       0.0604       0.0262       3.9929      74.7276     286.4870     153.7745      51.3421       0.1681       0.1892       0.2410       4.9574    2606.6895       9.9099     153.1250    3863.0000
 2408.8344      36.6337      52.8759      76.2742      62.9472      49.5017      20.2013     216.0000       0.1193       0.0472       0.0125       3.6042      70.7492     294.8600     153.8098      51.3421       0.1467       0.1655       0.2164       4.9304    2629.3362      10.0204     151.1250    3899.0000
 2408.9868      79.6661      60.5102     111.1686      86.0938      78.8983      12.6745     216.0000       0.1046       0.0313      -0.0039       3.6256      66.8708     294.0227     153.5020      51.3421       0.1361       0.1538       0.2042       4.8820    2656.4634      15.4224     151.1875    3900.0000
 2409.1392      75.5974      84.9488     189.6366     167.2198     155.4559       6.4327     216.0000       0.1215       0.0496       0.0150       3.5741      67.3996     292.3481     145.2942      51.3421       0.1352       0.1528       0.2032       4.8819    2625.2197      19.0278     153.2500    3905.0000
 2409.2916      51.9556      88.2141     141.8518     103.9277     102.8071       9.7270     216.0000       0.1432       0.0731       0.0394       3.7334      76.4980     294.0227     141.6256      51.3421       0.1497       0.1689       0.2199       4.9143    2585.0620      15.4770     147.8125    3957.0000
 2409.4440      51.4196      80.8232     123.0452      97.2495     102.7693       9.7305     216.0000       0.1438       0.0737       0.0400       4.6713      73.4114     299.8838     146.2104      51.3421       0.1281       0.1449       0.1947       4.9204    2583.9385      15.9231     148.7500    3936.0000
 2409.5964      70.1258     135.4191     184.2446     168.9069     146.2744       6.8365     216.0000       0.1398       0.0694       0.0356       3.9745      71.3018     287.8825     160.9299      51.3421       0.0664       0.0749       0.1199       4.9309    2591.3318      27.1631     152.1875    3956.0000
 2409.7488      71.9251     116.0443     305.2135     396.0155     208.7955       4.7894     216.0000       0.1440       0.0740       0.0403       3.7475      65.0509     264.4380     176.6725      51.3421       0.0950       0.1076       0.1551       4.9771    2583.5376      17.1831     145.7500    3935.0000
 2409.9012      52.9502      81.6112     185.3547     276.8273     125.4085       7.9739     216.0000       0.1454       0.0754       0.0418       3.7678      73.3528     265.5544     180.2318      51.3421       0.1634       0.1840       0.2357       4.9764    2581.0452      13.5367     151.0625    3843.0000
 2410.0536      49.4170      59.8262     141.3537     277.2833      65.1488      15.3495     216.0000       0.1336       0.0627       0.0286       3.8643      78.8445     290.6735     155.7405      51.3421       0.1656       0.1865       0.2383       4.8131    2602.8491      10.6413     151.0625    3894.0000
 2410.2060      55.7159      73.5572     205.7919     286.7082     117.5201       8.5092     216.0000       0.1412       0.0709       0.0371       3.8716      82.8622     285.6496     106.5357      51.3421       0.1299       0.1470       0.1970       4.5349    2588.7124      15.8452     145.9375    3867.0000
 2410.3584      65.5702      74.4249     178.5722     224.2945     142.7831       7.0036     216.0000       0.1690       0.1010       0.0683       4.3485      77.1995     278.3931      79.1049      51.3421       0.1279       0.1446       0.1945       4.4659    2537.2974      20.9043     148.5625    3832.0000
 2410.5108      68.1865     122.0339     156.4158     184.6414     158.7017       6.3011     216.0000       0.1971       0.1314       0.0998       4.5766      78.0131     279.2304      99.1023      51.3421       0.1170       0.1324       0.1817       4.6883    2485.2815      17.8722     147.3750    3870.0000
 2410.6632      47.9093     109.6372     226.0300     137.4764     143.3372       6.9766     216.0000       0.1913       0.1251       0.0933       4.3629      79.2967     293.1854     148.0100      51.3421       0.1004       0.1136       0.1616       5.0515    2496.0815      13.1725     148.0000    3868.0000
 2410.8156      34.6298      57.7748      98.5460     123.3262     180.8496       5.5295     216.0000       0.1700       0.1021       0.0694       3.8171      80.9645     280.6259     192.0011      51.3421       0.1370       0.1548       0.2052       5.2775    2535.4907      10.6104     147.6250    3846.0000
 2410.9680      30.1860      48.2016      53.7770      84.6248      83.8307      11.9288     216.0000       0.1916       0.1254       0.0936       3.6046      79.6913     269.4618     189.2078      51.3421       0.1627       0.1835       0.2351       5.3923    2495.5012       9.8211     150.9375    3861.0000
 2411.1204      23.0820      29.0699      39.4213      68.3421      42.9262      23.2958     216.0000       0.2316       0.1687       0.1385       3.4586      76.5806     287.3243     157.6464      51.3421       0.1424       0.1610       0.2117       5.4089    2421.4937       6.4317     147.6250    3840.0000
 2411.2728      21.2377      30.5350      45.3282      79.5001      54.3766      18.3902     216.0000       0.2491       0.1876       0.1580       3.3518      79.2247     262.7634     115.4330      51.3421       0.1937       0.2179       0.2704       5.2924    2389.2363       5.2991     147.1875    3879.0000
 2411.4252      24.0014      34.9435      53.6090      91.2173      84.4262      11.8447     216.0000       0.2288       0.1656       0.1353       3.8520      73.9893     274.4857      93.7808      51.3421       0.1700       0.1917       0.2435       5.0666    2426.7529       7.2760     145.3125    3875.0000
 2411.5776      32.1307      47.1746      79.8824     107.1700     130.5473       7.6601     216.0000       0.1906       0.1243       0.0925       4.1701      75.7075     296.8137     110.1148      51.3421       0.1217       0.1379       0.1875       4.9247    2497.4421      15.6344     140.4375    3904.0000
 2411.7300      40.3216      62.1934      97.3806     125.4016     185.7475       5.3837     216.0000       0.1780       0.1107       0.0783       3.8041      74.4408     307.9777     135.0808      51.3421       0.1506       0.1699       0.2210       4.9421    2520.7620      16.7366     140.0625    3934.0000
 2411.8824      58.3957      89.8230     144.4624     163.7187     307.9403       3.2474     216.0000       0.1747       0.1071       0.0746       4.0027      78.0521     337.5623     155.2758      51.3421       0.1557       0.1755       0.2269       5.0193    2526.8481      13.0328     141.3125    3897.0000
 2412.0348     100.9390     216.1120     237.7650     265.3952     476.5014       2.0986     216.0000       0.1964       0.1306       0.0990       4.4035      72.9925     347.8890     149.1690      51.3421       0.1290       0.1458       0.1958       5.0491    2486.5930      11.5219     140.7500    3921.0000
 2412.1872     128.1594     336.2033     920.7309     862.7319    1476.0461       0.6775     216.0000       0.2071       0.1422       0.1110       4.2100      72.5865     334.7714     132.4141      51.3421       0.1166       0.1320       0.1811       4.9825    2466.7783      10.4259     140.7500    3879.0000
 2412.3396     124.7727     456.7805    1950.0000    1950.0000    1673.2937       0.5976     216.0000       0.2052       0.1401       0.1089       4.1793      67.9582     276.1603     100.8546      51.3421       0.1220       0.1381       0.1876       4.8000    2470.3940      10.0323     141.3125    3820.0000
 2412.4920      87.0524     388.9976    1280.7917    1684.7837     363.3671       2.7520     216.0000       0.1802       0.1131       0.0809       4.2527      68.4573     271.1364     111.7306      51.3421       0.1072       0.1214       0.1699       4.6991    2516.5903      15.1096     141.3125    3859.0000
 2412.6444      68.1080     280.7291     327.5748     358.1799     171.0774       5.8453     216.0000       0.1812       0.1142       0.0819       3.7562      66.1902     275.6021     141.4220      51.3421       0.1048       0.1187       0.1670       4.8136    2514.7878      38.3344     141.3125    3907.0000
 2412.7968      57.8054     118.6267     178.7929     211.0603      86.2375      11.5959     216.0000       0.1723       0.1046       0.0720       4.1267      66.7582     278.3931     204.8731      51.3421       0.1190       0.1347       0.1839       5.1003    2531.2190      18.7931     141.5000    3934.0000
 2412.9492      52.0521      68.0669     106.5060     114.6927      63.7801      15.6789     216.0000       0.1687       0.1007       0.0679       3.3998      71.6306     272.2528     232.6536      51.3421       0.1420       0.1603       0.2109       5.3118    2537.8862      12.1437     141.3125    3941.0000
 2413.1016      43.5306      73.8242     115.8055     106.4304      71.5225      13.9816     216.0000       0.1999       0.1344       0.1029       3.9101      73.7399     280.0677     215.9874      51.3421       0.1215       0.1375       0.1870       5.4564    2480.1670      11.9554     141.3125    3909.0000
 2413.2540      40.9127      85.9241      95.9650     125.1419      97.2716      10.2805     216.0000       0.2601       0.1995       0.1704       4.2453      80.6975     270.5782     177.5808      51.3421       0.1046       0.1184       0.1668       5.5785    2368.8696       6.6603     140.6875    3914.0000
 2413.4064      27.8870      43.4340      76.4087      82.1450      80.2955      12.4540     216.0000       0.2913       0.2333       0.2054       4.2810      79.4573     257.4605     164.4902      51.3421       0.1316       0.1488       0.1990       5.6717    2311.1106       5.7261     138.9375    3945.0000
 2413.5588      18.3729      20.6600      29.9846      36.4345      49.4972      20.2032     216.0000       0.2599       0.1993       0.1702       4.6860      79.6151     285.0915     176.5285      51.3421       0.1662       0.1872       0.2390       5.6037    2369.2048       4.9115     136.4375    3859.0000
 2413.7112      31.9392      31.6960      47.7081      62.6433      83.7327      11.9428     216.0000       0.1981       0.1324       0.1009       4.5602      77.9358     296.2555     200.5351      51.3421       0.1610       0.1817       0.2332       5.4724    2483.5110       9.4714     136.2500    3843.0000
 2413.8636      67.8361      88.3854      98.4710     119.9778     132.1682       7.5661     216.0000       0.1580       0.0891       0.0560       4.3324      81.4640     254.9486     202.6629      51.3421       0.1807       0.2038       0.2558       5.3655    2557.6221      12.6106     137.1250    3873.0000
 2414.0160      97.8688     109.3951     207.7317     262.2111     338.7881       2.9517     216.0000       0.1299       0.0587       0.0245       3.7883      85.3741     264.9962     233.3300      51.3421       0.1488       0.1681       0.2191       5.3768    2609.6531      20.9846     138.8750    3880.0000
 2414.1684     127.4900     209.3984    1557.1703    1753.7943    1887.9092       0.5297     216.0000       0.1249       0.0532       0.0188       4.0364      80.3048     277.8349     283.4225      51.3421       0.1323       0.1496       0.1998       5.5181    2618.9714      26.2469     139.6250    3872.0000
 2414.3208     115.8366     363.3805    1950.0000    1950.0000    1016.4059       0.9839     216.0000       0.1313       0.0602       0.0260       4.5182      74.1596     272.8111     326.8843      51.3421       0.1243       0.1407       0.1903       5.6765    2607.1199      22.3981     136.9375    3889.0000
 2414.4732      92.2526     573.7277    1950.0000    1511.4858     380.7310       2.6265     216.0000       0.1252       0.0536       0.0192       4.0573      70.6555     287.3243     334.7225      51.3421       0.1002       0.1135       0.1614       5.6990    2618.4019      17.8910     141.0000    3913.0000
 2414.6256      86.8667     683.1723    1950.0000     935.4457     209.2040       4.7800     216.0000       0.1105       0.0377       0.0027       4.4171      77.2006     275.6021     298.6119      51.3421       0.0970       0.1100       0.1575       5.5202    2645.6001      22.4797     138.5625    3926.0000
 2414.7780      81.7044     547.1097    1950.0000     640.9782     209.4638       4.7741     216.0000       0.1037       0.0303      -0.0050       4.3435      79.4813     268.3454     243.4630      51.3421       0.1143       0.1294       0.1784       5.2106    2658.2026      26.9402     140.5625    3890.0000
 2414.9304      80.6105     347.4696    1709.3003     415.4929     160.2617       6.2398     216.0000       0.1122       0.0395       0.0045       4.2606      79.8874     277.2766     175.2741      51.3421       0.1583       0.1784       0.2299       4.8555    2642.5002      25.7091     140.8125    3901.0000
 2415.0828      83.7280     224.4561     865.7461     541.9673     178.6571       5.5973     216.0000       0.1141       0.0416       0.0067       4.2881      79.9030     262.7634     105.9101      51.3421       0.1561       0.1761       0.2275       4.4354    2638.8831      22.8703     141.3125    3902.0000
 2415.2352      91.6843     164.8308     676.1488     399.8673     160.5930       6.2269     216.0000       0.1031       0.0297      -0.0056       4.4395      78.4344     275.3229      51.7600      51.3421       0.1356       0.1533       0.2036       4.0141    2659.2820      32.6863     141.3125    3941.0000
 2415.3876      99.0886     162.8071     673.5500     245.3994     184.6139       5.4167     216.0000       0.1008       0.0271      -0.0082       4.4456      77.6223     268.3454      15.6395      51.3421       0.1204       0.1363       0.1856       3.6526    2663.5950      73.1464     141.3125    3917.0000
 2415.5400     111.9523     179.2879     739.4254     364.7619     247.1342       4.0464     216.0000       0.0956       0.0216      -0.0140       4.4901      70.5973     241.5518      16.2766      51.3421       0.1020       0.1156       0.1636       3.5519    2673.1304     180.5692     141.5000    3856.0000
 2415.6924     124.7294     230.1522     906.3774     500.7409     360.4680       2.7742     216.0000       0.0977       0.0238      -0.0117       4.2975      71.0490     251.0412      34.8842      51.3421       0.0843       0.0959       0.1420       3.7085    2669.3101     212.1535     144.4375    3839.0000
 2415.8448     121.5180     273.2680     936.2413     737.1078     526.7745       1.8983     216.0000       0.1125       0.0398       0.0049       4.1611      68.4505     256.3441      64.7311      51.3421       0.0704       0.0803       0.1249       4.1039    2641.8662     161.3145     144.0625    3917.0000
 2415.9972     107.9699     247.5224     502.8065     261.3470     356.3586       2.8062     216.0000       0.1267       0.0552       0.0209       4.3258      70.9387     249.9248     100.7037      51.3421       0.0848       0.0964       0.1426       4.5332    2615.5828      30.1008     145.3125    3843.0000
 2416.1496      97.5163     173.3776     244.5031     227.9702     172.7984       5.7871     216.0000       0.1259       0.0543       0.0199       3.9779      73.9383     246.0174     153.0449      51.3421       0.1275       0.1442       0.1938       4.9202    2617.1189      25.4805     145.0625    3844.0000
 2416.3020     111.3539     204.2469     446.8797     453.2876     222.3929       4.4965     216.0000       0.1059       0.0327      -0.0024       4.1036      78.6320     253.2740     204.2613      51.3421       0.1212       0.1371       0.1865       5.1776    2654.0342      27.3786     149.4375    3880.0000
 2416.4544     121.6828     171.6252     540.8190     478.9892     555.2510       1.8010     216.0000       0.1041       0.0308      -0.0045       4.3190      82.9497     270.5782     224.4637      51.3421       0.1526       0.1721       0.2232       5.3215    2657.3730      34.4937     141.6875    3891.0000
 2416.6068      93.3819      94.5519     176.6426     191.2103     162.4505       6.1557     216.0000       0.1065       0.0333      -0.0018       4.3615      86.0520     254.3904     219.3141      51.3421       0.1653       0.1862       0.2380       5.3613    2653.0378      22.6847     146.8750    3905.0000
 2416.7592      94.8255     108.6567     204.0775     242.5635     231.3179       4.3231     216.0000       0.1243       0.0526       0.0182       4.4321      84.8916     275.0439     198.2388      51.3421       0.1268       0.1435       0.1934       5.4157    2620.0222      24.0535     144.4375    3949.0000
 2416.9116     136.2264     177.2996     309.5617     304.7258     320.8391       3.1168     216.0000       0.1135       0.0409       0.0060       4.1642      77.3660     257.7396     194.3443      51.3421       0.0985       0.1115       0.1595       5.4221    2640.0811      25.6893     148.3125    3859.0000
 2417.0640     137.1524     261.3852     432.9974     378.1434     420.7664       2.3766     216.0000       0.1175       0.0452       0.0105       4.3604      71.0154     285.0915     192.8370      51.3421       0.1071       0.1212       0.1698       5.4285    2632.6650      26.9677     148.1875    3937.0000
 2417.2164     124.8825     254.6911     397.0107     290.4812     791.1611       1.2640     216.0000       0.1075       0.0345      -0.0006       4.6212      72.5168     268.9037     205.5209      51.3421       0.1516       0.1710       0.2222       5.3902    2651.0356      22.4922     141.3125    3852.0000
 2417.3688      78.0415     340.7466     637.4339     295.0452     630.5870       1.5858     216.0000       0.1153       0.0428       0.0080       4.5226      75.5677     271.6946     218.4582      51.3421       0.1585       0.1791       0.2305       5.4056    2636.7493      20.6381     147.3125    3846.0000
 2417.5212      66.9425     782.1531     257.2737     313.2830     205.5910       4.8640     216.0000       0.1166       0.0442       0.0095       4.0111      79.4905     283.1378     221.8709      51.3421       0.1740       0.1964       0.2482       5.4443    2634.3330      18.2152     148.2500    3883.0000
 2417.6736      78.9125     131.4369     107.6544     164.8035      85.3129      11.7216     216.0000       0.1183       0.0461       0.0114       3.9987      79.1339     309.0941     218.0200      51.3421       0.1900       0.2144       0.2665       5.4926    2631.1870      13.8837     147.1875    3849.0000
 2417.8260      47.0149      81.0618      51.1959      87.9294      48.4472      20.6410     216.0000       0.1096       0.0367       0.0017       3.9958      79.2909     286.2079     221.1182      51.3421       0.1972       0.2229       0.2748       5.5213    2647.1990      14.3118     147.3750    3920.0000
 2417.9784      41.5764      33.1638      28.4507      30.5753      25.4824      39.2428     216.0000       0.1007       0.0271      -0.0083       3.9182      81.0526     292.9063     229.6617      51.3421       0.2003       0.2263       0.2782       5.5217    2663.7014      15.2454     151.0625    3948.0000
 2418.1308      58.8394      52.0325      43.1818      33.6025      25.4712      39.2601     216.0000       0.0887       0.0141      -0.0217       4.3825      85.0136     294.3018     247.5605      51.3421       0.1854       0.2095       0.2614       5.5075    2685.8242      15.7381     141.3125    3872.0000
 2418.2832     168.6093     125.8886      95.7084     120.8569      55.5300      18.0083     216.0000       0.1298       0.0585       0.0243       4.9923      90.7550     306.5822     229.4080      51.3421       0.1645       0.1862       0.2376       5.5836    2609.9241      16.1635     145.5000    3911.0000
 2418.4356     388.5636     349.9124     280.1601     155.1814      71.8236      13.9230     216.0000       0.1537       0.0845       0.0512       5.2765      85.9294     293.4644     224.3261      51.3421       0.1911       0.2153       0.2676       5.7010    2565.5688      14.2272     141.3125    3864.0000
 2418.5880     284.0800     529.1676     688.4870     143.0878      83.8108      11.9316     216.0000       0.1699       0.1020       0.0693       5.3128      76.4376     297.9301     217.6356      51.3421       0.1659       0.1872       0.2388       5.8254    2535.6260      17.5008     143.8750    3848.0000
 2418.7404      96.1178     139.2255     255.1581      95.5206      59.7812      16.7277     216.0000       0.1712       0.1034       0.0708       5.0838      66.6276     283.9751     219.5535      51.3421       0.1215       0.1377       0.1872       5.8519    2533.2456      11.9156     141.8125    3877.0000
 2418.8928      53.9642      69.7281     128.8302      67.1228      45.9892      21.7442     216.0000       0.2106       0.1460       0.1149       4.3407      68.6110     281.1841     199.6965      51.3421       0.0967       0.1097       0.1576       5.8356    2460.4077       7.3128     142.3750    3916.0000
 2419.0452      30.3956      38.7161      68.2430      70.6297      40.1576      24.9019     216.0000       0.2425       0.1805       0.1507       3.5301      76.9346     251.0412     174.1786      51.3421       0.2064       0.2329       0.2850       5.7128    2401.3672       4.7551     145.1875    3911.0000
 2419.1976      35.2733      38.4957      79.1538     122.3709      72.7971      13.7368     216.0000       0.2194       0.1555       0.1248       3.6047      86.3378     257.1814     155.0891      51.3421       0.3057       0.3409       0.3926       5.4447    2444.1353       5.1723     138.8750    3854.0000
 2419.3500      42.0121      42.1391      95.0699     150.9815      78.3011      12.7712     216.0000       0.1611       0.0924       0.0594       4.3861      89.3831     280.6259     142.7052      51.3421       0.2286       0.2571       0.3095       5.1318    2552.0378       7.9724     137.1875    3828.0000
 2419.5024      60.8805      50.3531      97.5650     157.4003      92.1414      10.8529     216.0000       0.1413       0.0710       0.0372       4.7650      84.8020     282.5796     136.9503      51.3421       0.1348       0.1531       0.2032       5.0537    2588.6580      19.1700     139.0625    3848.0000
 2419.6548     104.0552      51.6702     122.9797     167.7873     136.0427       7.3506     216.0000       0.1592       0.0904       0.0573       4.4512      81.7005     302.9539     161.2339      51.3421       0.1087       0.1231       0.1719       5.3002    2555.4832      20.5819     141.3125    3843.0000
 2419.8072     135.0850     119.7030     141.0736     152.9431     189.0104       5.2907     216.0000       0.1762       0.1088       0.0764       4.6016      78.6552     295.1391     223.2401      51.3421       0.1379       0.1559       0.2064       5.6868    2524.0122      13.8084     135.7500    3834.0000
 2419.9596      89.9629     107.4688     137.0599     255.1420     302.4163       3.3067     216.0000       0.2032       0.1379       0.1066       4.4954      80.6469     307.4195     257.7350      51.3421       0.1734       0.1956       0.2475       5.9916    2474.1675      10.8162     134.5000    3925.0000
 2420.1120      75.2645     113.6679     136.2145     153.4926     124.2211       8.0502     216.0000       0.2339       0.1712       0.1410       4.7174      80.9009     321.3745     247.7217      51.3421       0.1844       0.2087       0.2604       6.0858    2417.2878       8.4201     131.5625    3901.0000
 2420.2644     129.9181     151.9768     131.2871     106.4043     199.8755       5.0031     216.0000       0.2565       0.1957       0.1664       4.7329      76.8757     304.0703     206.9254      51.3421       0.2152       0.2426       0.2948       5.9897    2375.4189       7.4943     133.6875    3923.0000
 2420.4168      86.7941     183.7939     165.6602     136.8503     164.2856       6.0870     216.0000       0.2266       0.1633       0.1329       5.0772      79.6681     327.5147     189.7836      51.3421       0.1744       0.1974       0.2490       5.7650    2430.7212       8.6560     130.9375    4001.0000
 2420.5692      48.8217      85.1068     130.3670     133.2156      87.6179      11.4132     216.0000       0.1715       0.1037       0.0711       5.1455      79.4142     324.7237     204.9818      51.3421       0.1719       0.1942       0.2459       5.5686    2532.7197      13.4619     130.5625    3934.0000
 2420.7216      30.6336      39.9009      51.0948      62.5831      42.3391      23.6188     216.0000       0.1675       0.0993       0.0666       4.5199      85.5239     326.9565     209.8758      51.3421       0.1609       0.1828       0.2337       5.5662    2540.1729      14.0605     127.6250    3909.0000
 2420.8740      44.3327      26.9446      37.3552      41.2088      20.8648      47.9277     216.0000       0.1854       0.1187       0.0866       4.3694      84.8645     338.1205     221.8673      51.3421       0.1883       0.2123       0.2644       5.6732    2507.0852       8.8292     123.8750    3868.0000
 2421.0264      81.7562      46.2721      86.6462      98.6945      60.1032      16.6381     216.0000       0.1933       0.1272       0.0955       4.2812      84.7117     323.6073     244.5028      51.3421       0.1664       0.1881       0.2397       5.7806    2492.4570       8.7880     129.0000    3828.0000
 2421.1788     138.6756      72.0826     110.9567     135.5710      86.3719      11.5778     216.0000       0.1621       0.0935       0.0606       4.3713      84.4543     301.2793     272.8763      51.3421       0.1764       0.1989       0.2509       5.7758    2550.0388      10.8935     125.4375    3890.0000
 2421.3312      75.7448     118.7812     152.1601     191.1480     119.3539       8.3784     216.0000       0.1318       0.0607       0.0266       4.4303      81.2564     296.8137     286.2751      51.3421       0.1310       0.1483       0.1984       5.7584    2606.1321      14.3806     131.1250    3871.0000
 2421.4836      82.9445      94.9483     159.1667     248.9637     204.1181       4.8991     216.0000       0.1332       0.0622       0.0281       4.8044      80.8496     314.6761     262.5239      51.3421       0.1358       0.1536       0.2040       5.7633    2603.6675      13.6070     120.8750    3863.0000
 2421.6360      91.3772     147.0767     140.2011     202.7459     167.0292       5.9870     216.0000       0.1545       0.0853       0.0520       4.6660      76.1577     331.1430     232.7592      51.3421       0.1578       0.1780       0.2295       5.8172    2564.1450      12.3886     121.6250    3868.0000
 2421.7884      69.9820     164.5120     306.6305     592.4946     295.2000       3.3875     216.0000       0.1850       0.1183       0.0862       4.6155      73.7648     332.2594     214.5445      51.3421       0.1283       0.1453       0.1953       5.9589    2507.6885      13.0817     119.1250    3888.0000
 2421.9408      67.4363     195.8622     340.2208     654.4849     434.2281       2.3029     216.0000       0.2647       0.2045       0.1756       4.7584      74.7818     345.3771     195.7703      51.3421       0.1640       0.1852       0.2367       6.2603    2360.3140       9.3811     117.9375    3880.0000
 2422.0932      49.3136      86.9788     178.2099     236.8668     267.0036       3.7453     216.0000       0.4169       0.3692       0.3462       4.6155      77.2405     329.1893     148.1339      51.3421       0.1649       0.1869       0.2381       6.7950    2078.6938       3.6333     117.8125    3902.0000
 2422.2456      39.5943      61.7624      51.2807      99.6838     146.4418       6.8286     216.0000       0.5420       0.5045       0.4865       4.6822      72.8519     326.1192      88.6383      51.3421       0.2569       0.2888       0.3407       7.1452    1847.2417       2.0622     113.1250    3876.0000
 2422.3980      62.2547      32.5870      53.1913      91.6166     101.8013       9.8231     216.0000       0.5218       0.4827       0.4639       4.8575      65.0860     320.5372      63.4854      51.3421       0.4093       0.4540       0.4999       6.7549    1884.6205       1.6890     112.0000    3885.0000
 2422.5504     106.1980      45.1881     134.6005     205.7919     218.3672       4.5794     216.0000       0.3711       0.3196       0.2948       4.7949      58.0169     337.0042      68.2373      51.3421       0.2361       0.2634       0.3170       5.7477    2163.5010       2.5877     112.0000    3863.0000
 2422.7028     186.0827      81.9207     191.2768     276.9056     252.4087       3.9618     216.0000       0.2305       0.1675       0.1373       4.6790      59.3547     282.8586      82.4442      51.3421       0.0484       0.0543       0.0971       4.7187    2423.4993       6.0808     112.0000    3882.0000
 2422.8552     264.6126     154.4806    1477.1781    1746.1575    1590.2703       0.6288     216.0000       0.1665       0.0982       0.0654       4.7002      58.2285     285.3705      98.9676      51.3421       0.0382       0.0438       0.0840       4.3296    2542.0212      65.6414     112.8125    3904.0000
 2423.0076     190.7403     251.3189    1950.0000    1945.1624     712.6093       1.4033     216.0000       0.1529       0.0835       0.0502       4.6840      58.6353     288.4407     129.4892      51.3421       0.0557       0.0654       0.1065       4.3706    2567.1563      77.0431     118.2500    3902.0000
 2423.1600     139.4321     374.5848    1216.6038     745.6626     214.8991       4.6533     216.0000       0.1610       0.0923       0.0593       5.1152      55.3180     238.2026     165.1196      51.3421       0.0562       0.0649       0.1071       4.6069    2552.2065      79.3956     110.9375    3936.0000
 2423.3124     113.2857     313.7946     723.1547     395.3501     114.7573       8.7140     216.0000       0.1842       0.1174       0.0853       5.1990      56.7532     232.6206     193.3014      51.3421       0.0724       0.0838       0.1273       4.8275    2509.2847      31.2505     114.8750    3887.0000
 2423.4648     101.5843     248.0833     310.4041     227.3099      85.0027      11.7643     216.0000       0.1848       0.1181       0.0860       5.0085      55.7009     235.4116     222.8720      51.3421       0.0677       0.0783       0.1215       4.9256    2508.1296      18.6979     111.4375    3921.0000
 2423.6172      95.2619     143.9109     222.9655     165.6620      67.5883      14.7955     216.0000       0.1583       0.0894       0.0563       5.0619      59.6284     240.9936     235.0540      51.3421       0.0664       0.0769       0.1199       4.8262    2557.1755      17.6166     112.0000    3909.0000
 2423.7696     112.6964     153.9270     277.3520     173.5467      62.0334      16.1203     216.0000       0.1277       0.0563       0.0220       4.7471      55.8985     243.7846     222.9939      51.3421       0.0681       0.0790       0.1220       4.5975    2613.7483      25.1147     114.4375    3902.0000
 2423.9220     133.2681     176.1458     345.8955     165.1849      86.6495      11.5408     216.0000       0.1159       0.0435       0.0087       4.6153      52.3353     241.5518     198.3731      51.3421       0.0606       0.0701       0.1126       4.3928    2635.6270      45.0875     114.1875    3882.0000
 2424.0744     165.4171     261.3036     474.8998     201.3908     122.1230       8.1885     216.0000       0.1186       0.0464       0.0117       4.7903      48.0332     247.1338     176.8846      51.3421       0.0603       0.0704       0.1123       4.2806    2630.6577      62.9613     115.7500    3889.0000
 2424.2268     200.8144     406.5016     728.3947     297.1473     202.1613       4.9465     216.0000       0.1148       0.0423       0.0074       4.5663      49.6269     252.1576     165.6721      51.3421       0.0576       0.0671       0.1089       4.2173    2637.7080      56.3173     114.8125    3841.0000
 2424.3792     190.5927     578.3890    1421.0760     763.5663     392.3929       2.5485     216.0000       0.1144       0.0419       0.0071       4.6537      53.1483     242.9473     161.4027      51.3421       0.0549       0.0640       0.1055       4.1913    2638.3198      46.7326     115.6875    3877.0000
 2424.5316     192.5311     964.0643    1840.1970     828.4875     567.7200       1.7614     216.0000       0.1008       0.0272      -0.0082       4.7781      53.5544     246.0174     170.4042      51.3421       0.0587       0.0683       0.1103       4.1628    2663.4880      53.0808     121.3125    3900.0000
 2424.6840     186.9847     825.3278     932.6082     733.1567     564.9435       1.7701     216.0000       0.0805       0.0052      -0.0310       4.8201      53.5878     238.7608     182.0800      51.3421       0.0660       0.0768       0.1195       4.0949    2701.0957      73.7693     122.0000    3877.0000
 2424.8364     164.7776     693.6461     529.4227     443.2636     326.0482       3.0670     216.0000       0.0779       0.0024      -0.0338       4.9747      53.4615     237.6444     164.7892      51.3421       0.0674       0.0785       0.1212       3.9872    2705.8467     123.4232     113.6875    3876.0000
 2424.9888     172.4128     808.1981     672.2670     500.4466     342.8977       2.9163     216.0000       0.0810       0.0058      -0.0304       5.3635      54.6459     226.2013     130.6753      51.3421       0.0576       0.0667       0.1089       3.8617    2700.0825     166.8393     123.1250    3869.0000
 2425.1412     179.7670     783.7635     669.6349     429.7691     329.3765       3.0360     216.0000       0.0922       0.0178      -0.0179       5.4179      52.3297     225.3640     106.8611      51.3421       0.0569       0.0659       0.1080       3.8036    2679.4917     138.8646     121.7500    3872.0000
 2425.2936     190.5690     712.2556     823.7339     396.4293     331.9853       3.0122     216.0000       0.0952       0.0211      -0.0145       5.2853      52.2947     224.8058     102.6232      51.3421       0.0705       0.0812       0.1249       3.7952    2673.9521     193.8338     124.7500    3896.0000
 2425.4460     186.2039     611.8052     806.2914     383.8982     319.6852       3.1281     216.0000       0.1049       0.0317      -0.0036       5.0828      50.5317     224.8058     105.7029      51.3421       0.0762       0.0878       0.1320       3.8086    2655.8687     211.6556     122.9375    3859.0000
 2425.5984     178.4619     443.3352     620.4852     282.8687     243.0056       4.1151     216.0000       0.1200       0.0480       0.0134       4.5567      50.4984     225.3640      98.4230      51.3421       0.0649       0.0748       0.1180       3.8092    2627.9585     199.5236     127.6875    3933.0000
 2425.7508     180.2262     443.3115     674.8117     298.7575     265.6803       3.7639     216.0000       0.1179       0.0457       0.0110       4.1972      50.5334     226.4804      91.6054      51.3421       0.0646       0.0748       0.1177       3.7515    2631.9021      85.7814     131.5625    3932.0000
 2425.9032     199.7017     528.8510     812.9589     432.1445     340.7456       2.9347     216.0000       0.1116       0.0389       0.0039       4.2550      52.5331     230.9460      66.7403      51.3421       0.0640       0.0744       0.1170       3.6234    2643.5542      85.5662     130.7500    3842.0000
 2426.0556     199.3638     591.2692     876.1179     426.7938     392.2363       2.5495     216.0000       0.1000       0.0264      -0.0090       4.4360      54.4431     223.1312      34.5836      51.3421       0.0681       0.0789       0.1220       3.4455    2664.9309     121.4351     127.9375    3879.0000
 2426.2080     179.2133     455.7970     639.5667     356.5835     336.6447       2.9705     216.0000       0.0977       0.0239      -0.0116       4.8678      54.8499     228.1550       3.4549      51.3421       0.0644       0.0749       0.1174       3.2776    2669.1873     474.4927     134.6875    3886.0000
 2426.3604     178.9678     516.7264     682.3640     385.3779     331.4885       3.0167     216.0000       0.0976       0.0237      -0.0118       5.6972      51.8958     223.4103      -6.0754      51.3421       0.0590       0.0687       0.1107       3.1637    2669.5061     521.9421     136.8750    3873.0000
 2426.5128     169.1933     436.8688     834.5700     437.8546     346.2872       2.8878     216.0000       0.0970       0.0231      -0.0124       6.1384      54.5726     223.6894      -7.9150      51.3421       0.0489       0.0573       0.0979       3.1096    2670.4663     449.0775     130.3125    3953.0000
 2426.6652     173.1128     490.8400     807.1534     440.9902     321.0508       3.1148     216.0000       0.0958       0.0218      -0.0138       5.9633      53.7590     225.3640      -8.1110      51.3421       0.0497       0.0582       0.0989       3.0923    2672.7583     554.3582     134.5625    3968.0000
 2426.8176     176.3697     518.5280     973.3534     402.4796     350.4470       2.8535     216.0000       0.0938       0.0196      -0.0161       5.3695      57.9313     224.8058      -3.2089      51.3421       0.0663       0.0779       0.1199       3.0964    2676.5515     619.3519     131.5625    3967.0000
 2426.9700     173.0968     431.4750     686.5200     457.0837     291.6962       3.4282     216.0000       0.0954       0.0213      -0.0143       4.7075      59.8427     224.5267       6.2051      51.3421       0.0521       0.0608       0.1020       3.1095    2673.5952     588.2500     133.5625    3963.0000
 2427.1224     154.5096     382.1501     639.4572     507.2363     348.0879       2.8728     216.0000       0.0936       0.0194      -0.0163       4.4796      57.7783     224.5267       6.2721      51.3421       0.0491       0.0575       0.0981       3.0881    2676.8743     490.4487     135.1875    3939.0000
 2427.2748     153.1496     342.2415     579.7321     595.1649     367.9959       2.7174     216.0000       0.0919       0.0176      -0.0181       4.7262      57.4080     223.6894      -0.6101      51.3421       0.0566       0.0661       0.1077       3.0716    2679.9070     482.7778     135.1875    3911.0000
 2427.4272     154.6953     393.7101     396.9044     376.5485     283.0312       3.5332     216.0000       0.0864       0.0116      -0.0243       5.1057      51.4287     224.2476      -8.9617      51.3421       0.0569       0.0668       0.1080       3.0552    2690.1592     481.0635     138.8750    3867.0000
 2427.5796     134.3611     342.8589     378.4055     296.1926     300.5268       3.3275     216.0000       0.0859       0.0110      -0.0249       5.1935      49.8085     223.1312      -5.7175      51.3421       0.0510       0.0599       0.1006       3.0828    2691.1499     475.7185     133.7500    3903.0000
 2427.7320     108.6357     243.9339     385.2667     297.9662     269.3564       3.7126     216.0000       0.0962       0.0222      -0.0134       5.1594      51.3969     222.5730       6.9537      51.3421       0.0469       0.0551       0.0954       3.2611    2672.0435     183.9876     137.2500    3926.0000
 2427.8844     101.9770     254.2955     402.0022     379.9997     341.0694       2.9320     216.0000       0.1412       0.0709       0.0372       5.2855      58.0663     223.1312      13.3138      51.3421       0.0464       0.0539       0.0947       3.5860    2588.6985      86.9039     141.6875    3939.0000
 2428.0368     108.3284     232.3261     233.3550     201.3550     206.4601       4.8436     216.0000       0.1632       0.0947       0.0618       5.0519      63.7849     221.4566      41.1191      51.3421       0.0781       0.0896       0.1343       3.9314    2548.0645      34.8245     144.7500    3918.0000
 2428.1892      99.7829     168.3324     314.2497     236.4945     227.8980       4.3879     216.0000       0.1789       0.1117       0.0794       5.1403      66.6712     219.7820      40.3912      51.3421       0.1057       0.1202       0.1679       4.0300    2518.9451      33.8630     133.0000    3937.0000
 2428.3416      91.3389     136.3143     343.0101     265.2728     262.3511       3.8117     216.0000       0.1565       0.0874       0.0543       5.3278      67.0772     226.4804      43.2286      51.3421       0.1312       0.1484       0.1981       3.8769    2560.4841      49.9300     145.5000    3894.0000
 2428.4940     100.6222     158.6441     369.7252     307.5634     291.8359       3.4266     216.0000       0.1461       0.0762       0.0426       5.2326      70.9256     237.6444      17.4091      51.3421       0.1502       0.1696       0.2203       3.6012    2579.7480     122.9279     138.3750    3903.0000
 2428.6464     109.4709     117.3682     294.5212     379.6398     320.7615       3.1176     216.0000       0.1229       0.0511       0.0166       5.2751      66.4152     246.0174       6.6595      51.3421       0.0954       0.1088       0.1555       3.3655    2622.5977     287.2980     141.3125    3915.0000
 2428.7988     140.1460     179.7748     482.3331     518.9570     410.7384       2.4346     216.0000       0.1048       0.0315      -0.0037       5.3194      58.2946     256.6232      -0.3858      51.3421       0.0536       0.0616       0.1037       3.2313    2656.1604     541.6381     141.3125    3913.0000
 2428.9512     168.8780     282.4269     748.2436     839.0077     791.7470       1.2630     216.0000       0.0953       0.0213      -0.0143       5.3141      53.8360     229.2714       4.6608      51.3421       0.0405       0.0465       0.0871       3.2261    2673.6602     712.4742     141.3125    3914.0000
 2429.1036     175.9882     440.1968    1592.9752    1596.0889    1847.5791       0.5412     216.0000       0.1001       0.0264      -0.0090       5.3306      57.6933     222.5730       7.1867      51.3421       0.0587       0.0674       0.1102       3.3174    2664.8286     837.6920     143.1875    3821.0000
 2429.2560     122.9674     441.1365     911.0491     620.6382    1096.3553       0.9121     216.0000       0.1189       0.0468       0.0121       5.2799      64.9975     222.8521       6.8731      51.3421       0.0967       0.1105       0.1570       3.4818    2629.9766     625.9988     141.3750    3812.0000
 2429.4084     113.1538     299.6970     364.6355     257.1867     309.0237       3.2360     216.0000       0.1142       0.0417       0.0068       5.2510      71.2541     225.3640      30.5459      51.3421       0.1182       0.1342       0.1828       3.6838    2638.7700      65.2551     142.1250    3817.0000
 2429.5608     100.0798     202.6896     242.3062     218.8509     189.0916       5.2884     216.0000       0.1033       0.0298      -0.0054       5.2863      69.4269     224.8058      63.3328      51.3421       0.0928       0.1054       0.1523       3.8636    2658.9697      42.8992     147.3125    3804.0000
 2429.7132      92.2980     189.1334     184.6346     167.1423     140.9747       7.0935     216.0000       0.0938       0.0196      -0.0161       5.3315      70.8969     224.8058      80.1075      51.3421       0.0959       0.1088       0.1562       3.9454    2676.5493      41.2184     139.5625    3851.0000
 2429.8656      79.2876     134.8529     173.7903     152.7078     118.6091       8.4311     216.0000       0.1053       0.0321      -0.0031       5.4026      68.8151     223.6894      67.8627      51.3421       0.1226       0.1391       0.1881       3.9290    2655.1201      37.6536     139.5625    3913.0000
 2430.0180      80.8957     142.4758     194.6898     148.0354     114.2110       8.7557     216.0000       0.1152       0.0427       0.0079       5.3721      72.9226     224.2476      48.0661      51.3421       0.1140       0.1291       0.1779       3.8557    2636.9661      34.2647     143.5625    3894.0000
 2430.1704      92.7338     169.2653     262.4403     185.0143     180.1318       5.5515     216.0000       0.1061       0.0329      -0.0022       5.4675      67.5997     223.6894      30.8189      51.3421       0.1226       0.1389       0.1881       3.6577    2653.6643      36.5113     141.3125    3891.0000
 2430.3228     104.2769     223.0740     481.5568     440.3719     264.6181       3.7790     216.0000       0.0952       0.0212      -0.0144       5.3486      64.1622     227.5968      10.3548      51.3421       0.0990       0.1123       0.1598       3.4275    2673.7957     121.3738     141.3125    3880.0000
 2430.4752     128.1434     228.0825    1252.6146    1016.5088     412.0703       2.4268     216.0000       0.0898       0.0153      -0.0205       5.4433      58.0246     223.6894       0.0460      51.3421       0.0794       0.0908       0.1359       3.2270    2683.8347     365.2711     141.3125    3848.0000
 2430.6276     126.0953     188.6236    1063.4436     739.5755     174.7424       5.7227     216.0000       0.0911       0.0167      -0.0190       4.9542      60.4608     225.3640       3.5713      51.3421       0.0675       0.0777       0.1212       3.2009    2681.3760     516.6027     143.0625    3877.0000
 2430.7800     117.9319     143.4832     696.5082     464.3502     150.0275       6.6654     216.0000       0.0963       0.0223      -0.0132       4.9409      57.8929     238.7608       4.3316      51.3421       0.0526       0.0606       0.1025       3.2612    2671.7969     584.5601     141.6875    3901.0000
 2430.9324     103.7293     136.9299     556.8928     342.7591     133.7426       7.4771     216.0000       0.1008       0.0272      -0.0082       5.2194      63.1713     223.1312       2.9950      51.3421       0.0559       0.0643       0.1067       3.3639    2663.5176     643.1497     142.6875    3909.0000
 2431.0848      90.0301     126.3608     417.8859     246.2788      92.9917      10.7536     216.0000       0.1085       0.0355       0.0004       5.1856      63.5773     223.1312      10.2904      51.3421       0.0851       0.0979       0.1430       3.5326    2649.2886     714.6700     145.8125    3914.0000
 2431.2372      71.4828     112.7082     319.1507     185.6557      60.1126      16.6354     216.0000       0.1078       0.0347      -0.0004       5.5604      69.6339     224.2476      36.3863      51.3421       0.0878       0.1011       0.1462       3.6821    2650.6484      29.8112     147.1875    3910.0000
 2431.3896      60.2821     116.5501     253.6939     157.2597      53.1115      18.8283     216.0000       0.1104       0.0375       0.0025       5.6092      66.1826     223.6894      42.5124      51.3421       0.0930       0.1067       0.1526       3.7150    2645.8491      28.4236     146.6875    3856.0000
 2431.5420      56.9486     150.9929     198.6367     136.0496      47.7973      20.9217     216.0000       0.1090       0.0361       0.0010       5.6002      64.3920     224.2476      44.4717      51.3421       0.0717       0.0818       0.1264       3.6458    2648.2688      28.6088     141.3125    3877.0000
 2431.6944      46.7307     138.8939     182.9547     166.5449      51.0602      19.5847     216.0000       0.1447       0.0747       0.0410       5.6517      59.5558     225.0849      30.6611      51.3421       0.0608       0.0691       0.1128       3.6767    2582.3254     417.7600     146.1875    3886.0000
 2431.8468      35.9016     171.7520     277.0560     158.2138      56.7703      17.6149     216.0000       0.1602       0.0915       0.0585       5.4866      55.6985     222.5730      49.1786      51.3421       0.0951       0.1081       0.1552       3.8512    2553.5459      18.8341     145.1250    3914.0000
 2431.9992      32.3821     107.2103     164.0556     212.8248      59.2233      16.8852     216.0000       0.1581       0.0892       0.0561       5.2915      60.7729     222.0148      60.4160      51.3421       0.1257       0.1429       0.1917       3.9734    2557.5142      14.5708     144.5625    3893.0000
 2432.1516      25.7435      69.7735     121.9126     264.1637      64.1500      15.5885     216.0000       0.1343       0.0634       0.0294       5.2495      62.7673     220.3402      49.8748      51.3421       0.0709       0.0804       0.1255       3.8046    2601.5327      15.4564     144.6250    3877.0000
 2432.3040      23.3405      43.6980     106.9265     312.2335      69.8912      14.3080     216.0000       0.1712       0.1033       0.0707       5.1776      63.0027     221.4566      25.8789      51.3421       0.0607       0.0684       0.1127       3.8264    2533.2925     101.6255     145.4375    3848.0000
 2432.4564      15.4681      19.2574      43.7999     309.2298      48.9558      20.4266     216.0000       0.2829       0.2242       0.1960       5.4319      61.1460     223.1312      11.7428      51.3421       0.1675       0.1885       0.2404       4.3983    2326.6467      10.8857     146.1250    3817.0000
 2432.6088      16.5613      16.6364      39.9103     236.1748      50.3800      19.8491     216.0000       0.3563       0.3036       0.2783       5.9178      62.2026     229.2714      67.8635      51.3421       0.1988       0.2228       0.2758       5.3900    2190.8838       4.2958     146.2500    3825.0000
 2432.7612      14.8247      27.8080      58.1848     169.6324      91.8282      10.8899     216.0000       0.3678       0.3160       0.2911       6.1803      66.6366     244.9010     136.8961      51.3421       0.1428       0.1612       0.2118       6.1430    2169.6479       3.1321     142.6875    3837.0000
 2432.9136      11.7944      26.4770      48.7618     114.8658     102.4103       9.7646     216.0000       0.3491       0.2958       0.2702       6.2796      70.6908     259.4142     183.6774      51.3421       0.1157       0.1310       0.1801       6.4837    2204.2520       3.2812     147.3750    3834.0000
 2433.0660      11.6860      22.3721      49.4700      89.7371     113.4081       8.8177     216.0000       0.3346       0.2802       0.2540       6.1526      75.9791     263.3217     214.3300      51.3421       0.1467       0.1662       0.2169       6.5487    2230.9067       4.1410     150.9375    3880.0000
 2433.2184      10.9680      23.8441      40.1287      63.1554     113.2268       8.8318     216.0000       0.3411       0.2872       0.2613       5.6690      77.2402     273.0901     229.8021      51.3421       0.2305       0.2615       0.3124       6.5802    2218.8899       4.2288     138.3750    3851.0000
 2433.3708      11.7844      33.4651      37.2191      60.4292     104.7893       9.5430     216.0000       0.3393       0.2852       0.2592       4.8579      74.5784     293.4644     224.0435      51.3421       0.3163       0.3588       0.4054       6.4748    2222.2959       3.6224     141.3125    3852.0000
 2433.5232      12.7035      33.2547      52.5410      77.8777     158.5361       6.3077     216.0000       0.3238       0.2684       0.2418       4.7310      67.0528     281.7422     181.3262      51.3421       0.3282       0.3725       0.4180       6.1882    2250.9719       3.1693     140.0625    3879.0000
 2433.6756      14.0390      42.6733      67.3296     103.9008     209.6891       4.7690     216.0000       0.2693       0.2095       0.1807       4.5196      65.5887     250.4830     130.8539      51.3421       0.3434       0.3880       0.4336       5.7195    2351.8279       3.9202     140.8125    3821.0000
 2433.8280      14.9009      65.6864      94.8963     161.0683     287.2456       3.4813     216.0000       0.2084       0.1436       0.1125       5.0189      63.7841     241.8309     113.5135      51.3421       0.2520       0.2879       0.3366       5.3157    2464.4216       8.5658     140.9375    3829.0000
 2433.9804      15.5142     150.3858     150.6944     295.5658     354.7752       2.8187     216.0000       0.2428       0.1808       0.1510       4.6407      68.8690     227.5968      85.5904      51.3421       0.1625       0.1860       0.2360       5.2895    2400.9038      11.6762     135.8125    3803.0000
 2434.1328      16.6934     161.0309     320.8723     728.7627     461.2272       2.1681     216.0000       0.2862       0.2277       0.1996       5.2409      71.5082     223.6894      86.6189      51.3421       0.1640       0.1858       0.2370       5.5332    2320.5898       4.9696     138.3750    3760.0000
 2434.2852      17.1955     147.5735    1283.7905    1950.0000     491.5085       2.0346     216.0000       0.2814       0.2226       0.1943       5.3726      70.1084     232.0624     117.6665      51.3421       0.1725       0.1946       0.2465       5.7580    2329.3528       4.9296     137.1250    3788.0000
 2434.4376      19.7012     105.6190     492.5599     709.1671     229.2109       4.3628     216.0000       0.3054       0.2486       0.2212       5.9571      64.7832     245.4592     120.0922      51.3421       0.1683       0.1897       0.2416       5.9432    2284.9539       5.4088     135.5000    3844.0000
 2434.5900      20.4195      79.1329     149.0425     404.1485      96.8536      10.3249     216.0000       0.3526       0.2996       0.2741       6.1429      64.7832     223.9685     101.6002      51.3421       0.1191       0.1353       0.1846       6.0279    2197.7397       4.0269     137.8750    3904.0000
 2434.7424      19.4198      48.9525     102.7756     268.9472      73.2929      13.6439     216.0000       0.3680       0.3163       0.2914       5.7395      71.3098     226.4804      66.5429      51.3421       0.1569       0.1778       0.2289       5.8196    2169.1980       3.1181     131.5625    3983.0000
 2434.8948      16.9543      29.8427      57.1810     196.6608      67.5830      14.7966     216.0000       0.2848       0.2262       0.1981       5.2500      76.0247     223.6894      48.9802      51.3421       0.2878       0.3220       0.3737       5.1868    2323.1187       4.4186     124.3750    4044.0000
 2435.0472      15.0022      23.2848      42.4628     143.4380      67.7489      14.7604     216.0000       0.1952       0.1293       0.0977       5.3146      76.4663     223.1312      54.6434      51.3421       0.2473       0.2779       0.3301       4.5947    2488.8440      15.4130     131.0625    4083.0000
 2435.1996      18.7119      36.3719      70.7491     121.2035      92.3063      10.8335     216.0000       0.1765       0.1091       0.0767       5.2850      76.6180     231.5042      59.7217      51.3421       0.1366       0.1552       0.2053       4.3740    2523.4473      45.8328     128.5625    3950.0000
 2435.3520      26.2693      83.2422     115.5110     174.2921     127.0655       7.8700     216.0000       0.1566       0.0875       0.0544       5.2552      73.3242     223.6894      96.9706      51.3421       0.1517       0.1716       0.2227       4.4444    2560.3203      12.6079     130.2500    3875.0000
 2435.5044      28.9634     127.3232     175.0587     264.4779     169.8074       5.8890     216.0000       0.1398       0.0694       0.0356       5.0825      73.7414     223.6894      89.6447      51.3421       0.1614       0.1818       0.2335       4.4210    2591.3167      12.5878     128.5000    3841.0000
 2435.6568      31.8791     180.3024     412.1514     425.5486     223.7007       4.4703     216.0000       0.1179       0.0457       0.0110       5.4193      69.5713     234.8534      64.8739      51.3421       0.1089       0.1232       0.1719       4.3311    2631.7939      16.6609     127.9375    3847.0000
 2435.8092      31.5941     124.4579     192.2749     231.2459     112.8121       8.8643     216.0000       0.1647       0.0963       0.0634       5.8791      72.0516     222.2939      27.2059      51.3421       0.1173       0.1328       0.1820       4.4189    2545.3318      74.7312     127.1875    3829.0000
 2435.9616      33.0765     102.2039     156.5960     169.7993     115.4691       8.6603     216.0000       0.2418       0.1797       0.1499       6.1133      67.9445     220.8984       8.9362      51.3421       0.1037       0.1174       0.1657       4.7426    2402.7090       7.7790     124.5000    3853.0000
 2436.1140      34.7058     127.1224     171.3523     271.4877     117.4597       8.5136     216.0000       0.3060       0.2492       0.2219       6.2452      67.8513     223.1312      -2.4135      51.3421       0.1005       0.1138       0.1620       5.1126    2283.8811       4.0324     130.3750    3847.0000
 2436.2664      34.3634      78.6589      72.5302      89.4887      70.0546      14.2746     216.0000       0.3016       0.2444       0.2169       6.1648      66.6309     235.4116      -0.7792      51.3421       0.1851       0.2079       0.2604       5.4105    2292.0676       3.0116     131.5625    3870.0000
 2436.4188      20.1763      28.1367      38.6524      63.0857      57.0893      17.5164     216.0000       0.2565       0.1956       0.1663       5.7021      63.1263     257.7396       8.2576      51.3421       0.2519       0.2801       0.3340       5.3916    2375.5627       4.5520     127.1875    3885.0000
 2436.5712      13.1064      13.6750      18.1389      28.7181      27.8255      35.9383     216.0000       0.1971       0.1314       0.0998       5.3312      56.4579     267.7872      13.1817      51.3421       0.1664       0.1875       0.2393       4.9492    2485.2964      10.3484     121.7500    3864.0000
 2436.7236      34.1148      27.2735      53.3027      61.3873      52.4218      19.0760     216.0000       0.1459       0.0760       0.0424       4.9593      51.3731     274.4857      13.4773      51.3421       0.0815       0.0924       0.1385       4.2316    2580.0396      51.3964     125.0000    3921.0000
 2436.8760      50.4824      62.7288      80.7524     108.6383     100.4005       9.9601     216.0000       0.1190       0.0469       0.0123       4.9179      51.6051     220.3402       3.9346      51.3421       0.0565       0.0643       0.1073       3.6626    2629.7783     677.9178     123.0000    3909.0000
 2437.0284     107.6221     134.9223     423.3144     490.2373     426.9734       2.3421     216.0000       0.1176       0.0453       0.0106       5.1401      51.3709     219.7820      -0.6640      51.3421       0.0610       0.0703       0.1131       3.4484    2632.4758     658.7992     129.0000    3909.0000
 2437.1808     135.9520     275.9731    1827.6471    1941.6310    1418.0220       0.7052     216.0000       0.1201       0.0480       0.0134       4.9158      50.3235     219.2238      -2.4896      51.3421       0.0660       0.0761       0.1194       3.3655    2627.8352     582.6847     129.6250    3919.0000
 2437.3332     101.0052     407.0640    1165.6079    1950.0000     442.6222       2.2593     216.0000       0.1108       0.0380       0.0030       4.9104      49.5673     218.6656       0.3324      51.3421       0.0811       0.0935       0.1381       3.3314    2645.0222     462.5839     131.3750    3855.0000
 2437.4856     114.2326     301.2553     655.6200    1876.6849     162.6662       6.1476     216.0000       0.1049       0.0316      -0.0036       4.9935      51.8355     218.6656       2.6417      51.3421       0.0745       0.0859       0.1300       3.2983    2656.0012     393.1839     131.5625    3904.0000
 2437.6380     120.9098     234.7999     266.6932    1139.4740     132.3569       7.5553     216.0000       0.1031       0.0297      -0.0056       5.4093      49.2869     216.9910       1.8306      51.3421       0.0684       0.0787       0.1224       3.3108    2659.1926     356.8928     131.5625    3877.0000
 2437.7904     124.4315     163.4457     310.5933     451.9340     113.7527       8.7910     216.0000       0.1065       0.0334      -0.0018       6.0180      53.7616     218.1073      -2.1811      51.3421       0.0810       0.0929       0.1380       3.3156    2652.9209     399.6155     131.5625    3858.0000
 2437.9428     141.8806     142.9938     291.3149     341.5331      98.6531      10.1365     216.0000       0.1046       0.0313      -0.0039       6.3734      55.1103     219.2238       0.7591      51.3421       0.0811       0.0930       0.1381       3.3147    2656.5063     499.6628     137.8125    3868.0000
 2438.0952     121.1480     122.6607     282.1722     280.5989     135.3111       7.3904     216.0000       0.1034       0.0300      -0.0053       6.5333      59.9266     218.1073       9.4013      51.3421       0.0786       0.0904       0.1350       3.2941    2658.7688     521.9220     131.5625    3894.0000
 2438.2476     126.1214     125.3445     220.5679     181.2068     160.0822       6.2468     216.0000       0.0991       0.0253      -0.0101       5.7734      56.9043     219.2238      20.9403      51.3421       0.0538       0.0626       0.1041       3.2400    2666.6638     479.0783     132.1250    3878.0000
 2438.4000     165.8662     159.7675     218.9065     187.1215     179.8289       5.5608     216.0000       0.1008       0.0272      -0.0082       4.9973      51.8946     219.2238      14.4286      51.3421       0.0472       0.0555       0.0957       3.2150    2663.4595     462.9692     132.7500    3912.0000
 2438.5524     154.4459     185.2321     263.9063     217.9407     264.7665       3.7769     216.0000       0.1035       0.0301      -0.0052       5.0994      46.8097     215.8746       2.7642      51.3421       0.0433       0.0505       0.0907       3.2247    2658.5381     510.6013     133.5625    3937.0000
 2438.7048     188.0485     232.0961     483.6031     358.3978     511.7964       1.9539     216.0000       0.1034       0.0300      -0.0053       4.9773      42.2804     215.8746      -8.0626      51.3421       0.0590       0.0680       0.1106       3.2387    2658.7217     518.3246     136.6250    3895.0000
 2438.8572     159.8125     331.5619     622.8031     446.0274     379.2237       2.6370     216.0000       0.0994       0.0257      -0.0097       4.9184      46.0276     216.1537      -6.4385      51.3421       0.0847       0.0969       0.1424       3.2543    2666.0508     534.2599     135.8125    3870.0000
 2439.0096     170.7272     205.5567     301.9695     223.2794     156.8370       6.3760     216.0000       0.0955       0.0215      -0.0141       4.7285      48.8447     216.4328      -3.7873      51.3421       0.0932       0.1070       0.1529       3.2627    2673.2969     467.0670     136.8125    3878.0000
 2439.1620     190.6097     186.8743     273.9196     187.8849     108.0664       9.2536     216.0000       0.1042       0.0309      -0.0043       4.8645      55.9716     216.9910      -1.7698      51.3421       0.0769       0.0887       0.1330       3.3446    2657.1653     426.6815     137.6875    3871.0000
 2439.3144     166.6108     177.8027     290.2008     149.5248     101.7446       9.8285     216.0000       0.1185       0.0463       0.0116       4.9811      59.7078     216.9910      -0.0403      51.3421       0.0686       0.0791       0.1226       3.4546    2630.8035     229.3853     139.6875    3927.0000
 2439.4668     138.0762     157.3690     273.5751     164.1949      91.7748      10.8962     216.0000       0.1186       0.0465       0.0118       5.2168      65.5142     216.4328       9.9683      51.3421       0.0871       0.0994       0.1454       3.5483    2630.5171     107.8012     141.3125    3931.0000
 2439.6192     135.3208     159.1945     293.8992     214.5297      89.3517      11.1917     216.0000       0.1098       0.0369       0.0018       5.2865      64.3117     215.8746      11.0710      51.3421       0.1141       0.1297       0.1779       3.5089    2646.9485     105.7362     145.0625    3998.0000
 2439.7716     132.5840     166.8506     262.8984     172.0819      80.7955      12.3769     216.0000       0.0986       0.0248      -0.0106       5.2345      59.0656     217.2701       9.7351      51.3421       0.0921       0.1048       0.1515       3.4331    2667.5518     202.5249     141.3125    4021.0000
 2439.9240     110.0503     143.7022     387.2396     210.5978      89.0225      11.2331     216.0000       0.1056       0.0324      -0.0028       4.6611      53.2636     215.8746      -1.6141      51.3421       0.0675       0.0770       0.1212       3.4101    2654.6375     503.0340     144.8750    3945.0000
 2440.0764     108.7674     143.9214     365.8567     232.0805      92.4388      10.8180     216.0000       0.1112       0.0384       0.0035       4.0725      56.9247     215.3164      -4.3523      51.3421       0.0774       0.0886       0.1335       3.4613    2644.2507     447.3731     141.3125    3971.0000
 2440.2288      93.0519     157.7757     367.9081     247.9337     119.0107       8.4026     216.0000       0.1095       0.0366       0.0016       3.8406      58.5165     216.4328      -4.7960      51.3421       0.0959       0.1096       0.1561       3.4583    2647.4326     347.3214     146.0000    3953.0000
 2440.3812      79.2882     136.8490     286.2454     257.9409     131.4478       7.6076     216.0000       0.1067       0.0336      -0.0016       3.8874      62.5725     216.9910      -2.7158      51.3421       0.0834       0.0952       0.1409       3.4186    2652.5764     275.5370     146.0000    3945.0000
 2440.5336      69.0750     117.0199     184.1279     203.0888     171.1968       5.8412     216.0000       0.1061       0.0329      -0.0023       4.4448      55.0468     218.6656      -3.2036      51.3421       0.0852       0.0974       0.1431       3.3735    2653.7227     311.2539     148.6250    3950.0000
 2440.6860      74.6631     191.8203     127.3150     277.1157     182.5013       5.4794     216.0000       0.1100       0.0372       0.0022       5.0985      56.0127     218.9447      -2.9638      51.3421       0.0613       0.0703       0.1134       3.3601    2646.4409     415.8501     149.8125    3923.0000
 2440.8384      60.4719     102.6584      96.7051     164.1072     149.7359       6.6784     216.0000       0.1130       0.0404       0.0055       5.6413      52.7964     217.5492       3.1722      51.3421       0.0557       0.0645       0.1064       3.4322    2640.9150     300.0647     151.0625    3868.0000
 2440.9908      39.4710      53.7803      57.3542     242.6449     261.0359       3.8309     216.0000       0.1557       0.0866       0.0534       5.6369      52.0869     218.1073       6.7189      51.3421       0.0544       0.0629       0.1048       3.6379    2561.9128     118.0374     151.0625    3900.0000
 2441.1432      34.9529      34.0297      36.1962      75.0772      60.7330      16.4655     216.0000       0.1918       0.1256       0.0938       5.6413      48.8669     218.1073      25.5988      51.3421       0.0604       0.0696       0.1123       4.0024    2495.1802      52.0850     153.8750    3913.0000
 2441.2956      31.6213      29.5847      35.5152     116.5991     107.4079       9.3103     216.0000       0.2220       0.1583       0.1277       4.8206      52.0224     220.8984      29.2559      51.3421       0.0970       0.1105       0.1574       4.2415    2439.2542       8.1217     160.3750    3967.0000
 2441.4480      32.6402      43.7284      71.4369     118.1744     105.0899       9.5157     216.0000       0.2107       0.1461       0.1151       5.0809      58.5175     220.8984      37.4985      51.3421       0.1587       0.1790       0.2300       4.3101    2460.1587       6.2198     151.0625    3967.0000
 2441.6004      46.2748      77.7442     105.7084     131.4834     116.1602       8.6088     216.0000       0.1781       0.1108       0.0785       4.8651      61.5898     222.0148      31.5671      51.3421       0.1280       0.1458       0.1943       3.9683    2520.5557       7.1872     151.0625    3999.0000
 2441.7528      85.4650     154.8989     679.1064     148.4201     134.9405       7.4107     216.0000       0.1391       0.0686       0.0348       5.8785      61.9986     227.5968      30.4177      51.3421       0.0455       0.0522       0.0934       3.5502    2592.6130      29.7953     151.0625    3950.0000
 2441.9052      89.1569     196.9508    1950.0000     179.9420     128.4477       7.7853     216.0000       0.1227       0.0509       0.0164       5.6427      63.6611     229.5505      22.2623      51.3421       0.0319       0.0363       0.0759       3.2903    2623.0215     321.2723     151.0625    3883.0000
 2442.0576      82.8599     200.5018    1087.8885     143.6006     123.8991       8.0711     216.0000       0.1862       0.1196       0.0876       5.6788      69.7627     219.7820      13.9787      51.3421       0.0797       0.0908       0.1363       3.7274    2505.5376     180.6382     154.7500    3880.0000
 2442.2100      57.4536     174.7002     271.7741     150.5918      93.5889      10.6850     216.0000       0.2918       0.2338       0.2059       5.8809      76.9168     217.5492      42.6352      51.3421       0.1077       0.1223       0.1703       4.7629    2310.2551      11.9735     155.6250    3860.0000
 2442.3624      48.4343      87.4802     153.6655     110.4152      82.4542      12.1280     216.0000       0.3490       0.2957       0.2700       6.0394      79.7649     225.6431     129.7884      51.3421       0.1138       0.1291       0.1777       5.7843    2204.4375       5.1518     156.5000    3897.0000
 2442.5148      39.4963      59.1434      97.7857      93.2242      57.6422      17.3484     216.0000       0.3292       0.2743       0.2479       5.7934      79.1669     240.4354     252.1346      51.3421       0.1052       0.1195       0.1673       6.3605    2240.9312       3.7212     157.5625    3933.0000
 2442.6672      29.9196      55.3721      90.4693     105.7147      69.9256      14.3009     216.0000       0.2725       0.2130       0.1843       5.9287      80.0702     283.4169     350.1301      51.3421       0.1001       0.1137       0.1612       6.4157    2345.8481       3.9176     156.3750    4014.0000
 2442.8196      27.7663      46.6766      96.7991     110.1239      70.2823      14.2283     216.0000       0.2469       0.1852       0.1556       5.7602      83.5015     286.2079     382.0002      51.3421       0.1049       0.1189       0.1670       6.3284    2393.3220       4.3195     155.3125    4072.0000
 2442.9720      22.5139      33.2325      53.7948      85.6843      74.1806      13.4806     216.0000       0.2331       0.1704       0.1402       6.1520      85.3849     286.7661     365.6604      51.3421       0.1333       0.1507       0.2008       6.1904    2418.6890       4.2979     153.7500    4119.0000
 2443.1244      21.0413      27.3604      42.2637      98.5818     102.2483       9.7801     216.0000       0.2425       0.1805       0.1507       5.8317      83.4249     285.0915     313.9932      51.3421       0.1557       0.1758       0.2271       6.0583    2401.3333       4.4617     149.2500    4022.0000
 2443.2768      30.8720      36.4211      64.6287     150.1963     148.2850       6.7438     216.0000       0.2574       0.1966       0.1674       5.7875      80.9048     273.3693     261.6541      51.3421       0.2324       0.2606       0.3135       5.9245    2373.7705       5.2970     145.3125    3937.0000
 2443.4292      46.1551      64.6780     106.3888     205.2438     220.9545       4.5258     216.0000       0.2554       0.1945       0.1652       5.3168      77.5368     294.0227     235.4453      51.3421       0.1776       0.1996       0.2518       5.7830    2377.4795       6.6912     151.0625    3908.0000
 2443.5816      61.5272     118.6074     185.0091     340.9793     335.1959       2.9833     216.0000       0.2091       0.1443       0.1132       4.8501      74.2726     254.3904     235.3680      51.3421       0.0841       0.0960       0.1417       5.5505    2463.1814       8.9041     151.0625    3895.0000
 2443.7340      71.0410     224.0576    1422.5754    1850.2417    1889.3411       0.5293     216.0000       0.1536       0.0843       0.0510       4.3673      66.3197     235.9698     235.0099      51.3421       0.0624       0.0723       0.1149       5.2574    2565.8445      11.8075     146.4375    3914.0000
 2443.8864      69.0573     429.0670    1950.0000     629.3258     308.0395       3.2463     216.0000       0.1231       0.0514       0.0169       4.9129      59.2494     242.1100     220.9807      51.3421       0.0439       0.0506       0.0914       5.0006    2622.1909      15.9040     151.0625    3917.0000
 2444.0388      67.4340     511.0375     939.4861     253.4381     114.9543       8.6991     216.0000       0.1107       0.0379       0.0029       5.5286      51.8142     224.8058     219.8303      51.3421       0.0645       0.0739       0.1174       4.8723    2645.2737      18.7616     151.0625    3895.0000
 2444.1912      64.1167     317.7089     515.4547     183.8042      62.8391      15.9137     216.0000       0.1036       0.0303      -0.0050       6.4842      54.6207     219.7820     237.4215      51.3421       0.0898       0.1023       0.1486       4.8617    2658.2595      51.2937     151.0625    3944.0000
 2444.3436      60.7933     212.1924     290.5699     158.4534      53.3151      18.7564     216.0000       0.1007       0.0270      -0.0083       7.2487      57.2599     232.6206     254.6821      51.3421       0.0873       0.0997       0.1456       4.8927    2663.7505     120.1123     148.5625    3917.0000
 2444.4960      56.6794     137.7345     438.9037     148.6769      39.0725      25.5935     216.0000       0.1021       0.0286      -0.0067       7.6168      61.9585     234.8534     243.4948      51.3421       0.0667       0.0766       0.1202       4.8407    2661.0559     159.5737     148.6250    3899.0000
 2444.6484      50.6087      91.6373     233.1491      98.8997      33.5435      29.8120     216.0000       0.1006       0.0269      -0.0084       7.7594      58.5072     225.9222     214.9548      51.3421       0.0795       0.0912       0.1361       4.6685    2663.9226     111.5911     156.1250    3915.0000
 2444.8008      45.5624      66.8278     183.0369     137.0945      29.2837      34.1487     216.0000       0.1064       0.0332      -0.0020       7.4562      55.9663     218.6656     171.5915      51.3421       0.0839       0.0960       0.1415       4.4522    2653.2422      87.0898     151.0625    3872.0000
 2444.9532      48.6339      71.4985     215.1856     165.6800      29.5534      33.8371     216.0000       0.1166       0.0443       0.0096       5.7250      52.2732     219.7820     131.7258      51.3421       0.0842       0.0962       0.1419       4.3119    2634.2019      79.8268     141.3125    3879.0000
 2445.1056      59.3269      86.8797     214.8913     204.1976      49.3951      20.2449     216.0000       0.1156       0.0432       0.0084       5.2223      51.0551     232.6206     117.7650      51.3421       0.0761       0.0871       0.1318       4.3863    2636.1189      85.1457     151.0625    3885.0000
 2445.2580      55.7880      77.7658     314.7747     448.3299     151.2242       6.6127     216.0000       0.1402       0.0698       0.0359       4.6095      54.0390     228.7132     130.3306      51.3421       0.0787       0.0896       0.1351       4.7733    2590.7092      95.3938     145.7500    3882.0000
 2445.4104      48.8210      57.1776     131.3809     266.5857      99.7335      10.0267     216.0000       0.2721       0.2125       0.1839       3.9825      53.6954     223.1312     103.0741      51.3421       0.0884       0.1000       0.1473       5.4675    2346.6204      12.0770     151.3125    3880.0000
 2445.5628      26.0959      39.5799      83.2391     179.6063      94.7180      10.5577     216.0000       0.3361       0.2817       0.2556       3.9461      61.6602     229.8296     157.6004      51.3421       0.1972       0.2259       0.2758       6.2151    2228.2883       5.3919     151.0625    3894.0000
 2445.7152      23.9944      24.4613      47.0171     140.8398      73.1345      13.6734     216.0000       0.3141       0.2579       0.2309       5.0713      64.2625     233.4579     254.2658      51.3421       0.6386       0.7055       0.7244       6.6795    2268.9565       5.0308     151.0625    3923.0000
 2445.8676      17.2016      15.7846      37.4564      85.4312      66.1563      15.1157     216.0000       0.1991       0.1335       0.1020       5.8076      71.1025     244.3428     393.9655      51.3421       0.3328       0.3735       0.4219       6.8617    2481.6826       8.0703     151.0625    3932.0000
 2446.0200      15.4726      19.6681      53.1339     109.0971     121.6107       8.2230     216.0000       0.1900       0.1237       0.0918       6.4831      65.6505     288.4407     416.6222      51.3421       0.1801       0.2029       0.2551       6.9641    2498.5330      10.2031     151.0625    3873.0000
 2446.1724      15.6691      27.5514      57.6994      95.2167     144.7067       6.9105     216.0000       0.2651       0.2049       0.1760       6.4512      63.2143     314.1179     343.2260      51.3421       0.1746       0.1972       0.2490       7.1468    2359.5706       5.4666     152.6875    3933.0000
 2446.3248      18.0657      24.4788      69.9404     134.5474     180.9550       5.5262     216.0000       0.3310       0.2762       0.2499       6.3362      61.6313     321.9327     258.9604      51.3421       0.1569       0.1776       0.2288       7.2832    2237.6821       4.0067     150.2500    3952.0000
 2446.4772      21.7825      21.0028      38.6730      42.3527     160.4670       6.2318     216.0000       0.3535       0.3006       0.2752       6.3184      63.5849     327.5147     200.5703      51.3421       0.1524       0.1727       0.2236       7.2908    2195.9536       3.8336     151.0625    3934.0000
 2446.6296      26.3374      46.9824      99.2599     124.6518     162.7508       6.1444     216.0000       0.3131       0.2569       0.2299       6.4376      62.7607     337.5623     207.3855      51.3421       0.1444       0.1634       0.2141       7.2231    2270.6853       5.2130     152.3750    3985.0000
 2446.7820      31.9150      68.3286     151.2116     132.7276     232.0573       4.3093     216.0000       0.2672       0.2072       0.1783       6.4015      64.5467     343.1443     240.2709      51.3421       0.1706       0.1921       0.2441       7.2314    2355.7422       8.3007     151.0625    3937.0000
 2446.9344      27.5454      79.9849      86.2825      96.7912      67.5733      14.7987     216.0000       0.2717       0.2121       0.1835       6.4432      71.6523     324.1655     255.8622      51.3421       0.1369       0.1549       0.2053       7.4183    2347.2739       8.3704     151.0625    3963.0000
 2447.0868      19.3253      31.1580      71.6281     103.9143      42.7610      23.3858     216.0000       0.3374       0.2832       0.2571       6.3951      81.3589     277.8349     228.0210      51.3421       0.1512       0.1710       0.2220       7.7540    2225.7888       4.2150     151.0625    3940.0000
 2447.2392      14.4393      34.0896      40.8369      53.0909      24.6359      40.5912     216.0000       0.3755       0.3243       0.2998       6.5651      79.9796     276.1603     220.0563      51.3421       0.1786       0.2022       0.2537       8.0587    2155.3984       3.4788     154.8750    3903.0000
 2447.3916      17.2118      23.9340      34.5727      60.7620      18.6575      53.5978     216.0000       0.4745       0.4315       0.4108       6.4462      75.3555     357.6576     166.6726      51.3421       0.1763       0.2002       0.2514       8.4467    1972.1085       2.5165     152.5625    3876.0000
 2447.5440      21.3431      28.4866      46.0526     104.8994      18.6434      53.6381     216.0000       0.5548       0.5184       0.5009       6.2926      69.3153     339.7951     132.0802      51.3421       0.2833       0.3213       0.3701       8.8022    1823.5519       1.9573     151.0625    3904.0000
 2447.6964      25.3736      37.8703      57.6925     131.4758      22.3668      44.7091     216.0000       0.6566       0.6285       0.6150       6.5286      71.3037     392.8242      74.5572      51.3421       0.2827       0.3213       0.3696       9.1437    1635.2931       1.4434     151.0625    3914.0000
 2447.8488      34.2876      55.4137     115.6235     177.8453      26.7767      37.3460     216.0000       0.6601       0.6322       0.6189       6.4792      74.0785     406.7792      75.3713      51.3421       0.2527       0.2866       0.3368       9.2394    1628.8831       1.3965     151.0625    3956.0000
 2448.0012      37.1675      91.4477     257.8309     900.8638      50.9543      19.6254     216.0000       0.6515       0.6230       0.6093       6.5721      71.8453     406.7792      74.4030      51.3421       0.1833       0.2081       0.2593       9.1687    1644.6368       1.4071     145.0625    3955.0000
 2448.1536      31.0685     108.5235     236.9038     495.8767     116.3388       8.5956     216.0000       0.6492       0.6205       0.6067       6.6426      67.2128     407.3374      66.9165      51.3421       0.1444       0.1650       0.2149       9.0379    1648.9769       1.4161     143.3125    3888.0000
 2448.3060      43.5633      61.2743      56.5691      84.0913      80.5855      12.4092     216.0000       0.6477       0.6188       0.6050       6.6317      60.1928     408.4539      58.2103      51.3421       0.2612       0.2974       0.3464       8.8725    1651.7836       1.4226     141.3125    3892.0000
 2448.4584      26.2002      23.8133      33.6369      51.2517      91.1008      10.9768     216.0000       0.6492       0.6205       0.6067       6.5578      59.2142     408.4539      48.0971      51.6218       0.4100       0.4629       0.5024       8.7048    1648.9626       1.4247     142.1250    3787.0000
 2448.6108      35.1038      11.6898      13.3877      19.9402      72.3151      13.8284     216.0000       0.6502       0.6215       0.6078       6.4328      59.9894     408.4539      39.8779      51.6218       0.3501       0.3967       0.4408       8.4984    1647.2026       1.4251     138.6250    3825.0000
 2448.7632      42.4528      17.3006      21.2395      32.4217      72.9666      13.7049     216.0000       0.6487       0.6199       0.6061       6.3074      59.9261     408.4539      39.1809      51.3421       0.2289       0.2594       0.3105       8.2536    1649.9672       1.4426     134.5000    3911.0000
 2448.9156      57.6502      56.6022      47.5379      65.9840     140.2736       7.1289     216.0000       0.6361       0.6063       0.5920       6.5584      61.7514     407.8956      45.6121      51.3421       0.1368       0.1551       0.2054       7.9339    1673.2136       1.5735     131.5625    4023.0000
 2449.0680      41.0127     101.9049      77.0100     110.3294     207.1650       4.8271     216.0000       0.4876       0.4457       0.4255       6.6205      58.3321     407.8956     151.6888      51.3421       0.1090       0.1233       0.1721       7.3982    1947.9323       2.4822     132.1250    4165.0000
 2449.2204      53.6490     416.3977     741.1813    1345.7993    1818.9127       0.5498     216.0000       0.2726       0.2130       0.1844       5.8861      58.9795     408.0352     305.9011      51.3421       0.1280       0.1447       0.1946       6.7137    2345.7019       5.9521     130.6250    4289.0000
 2449.3728      68.2481    1256.3401     442.2509     308.2340     667.7656       1.4975     216.0000       0.0787       0.0033      -0.0330       5.8509      59.9599     271.6946     444.6359      51.3421       0.1567       0.1769       0.2283       6.0948    2704.4399     403.4949     129.8750    4311.0000
 2449.5252      87.9705     158.5157     117.4341      85.2251     113.6814       8.7965     216.0000       0.0240      -0.0559      -0.0943       5.8099      65.6672     273.3693     479.0876      51.6218       0.1546       0.1750       0.2261       5.7583    2805.6504     797.8613     128.9375    4133.0000
 2449.6776      71.2270      38.4741      41.5066      43.2162      38.8368      25.7488     216.0000       0.0380      -0.0408      -0.0786       5.7834      68.0650     274.4857     460.9108      51.6218       0.1581       0.1794       0.2303       5.6778    2779.6909     789.2369     131.4375    3997.0000
 2449.8300      26.6415      27.4986      17.8212      17.7176      17.9149      55.8194     216.0000       0.0413      -0.0372      -0.0749       5.7451      68.8770     276.7184     453.9111      51.3421       0.1942       0.2194       0.2714       5.6832    2773.5505     782.7621     123.6250    3955.0000
 2449.9824      27.3630       9.0011       9.2693       9.1065       9.3728     106.6912     216.0000       0.0374      -0.0414      -0.0793       5.8163      68.4580     278.3931     457.3696      51.3421       0.1926       0.2158       0.2685       5.6894    2780.8748     781.6277     123.3750    3942.0000
 2450.1348      65.8894      14.6875      30.6930      28.0605      28.4259      35.1792     216.0000       0.0384      -0.0403      -0.0781       5.6503      60.7434     281.7422     458.3955      51.3421       0.0867       0.0983       0.1449       5.7073    2778.8838     784.0261     128.9375    3928.0000
 2450.2872     111.4530      42.3339      39.8456      39.3489      36.5719      27.3434     216.0000       0.0368      -0.0420      -0.0799       6.1786      53.6475     282.8586     455.9326      51.6218       0.0731       0.0835       0.1282       5.6781    2781.8569     786.4510     127.1875    3973.0000
 2450.4396     664.3124     115.3086     221.3207     222.4103     123.3518       8.1069     216.0000       0.0347      -0.0444      -0.0823       5.7400      50.5604     283.4169     457.2968      51.3421       0.0807       0.0915       0.1376       5.6653    2785.8494     788.1316     130.8750    3931.0000
 2450.5920    1817.1235     186.0244     214.5252     170.6766     158.6568       6.3029     216.0000       0.0362      -0.0427      -0.0806       5.9364      57.8690     283.4169     448.2999      51.3421       0.0824       0.0936       0.1396       5.6502    2783.0359     784.9205     131.3125    3938.0000
 2450.7444    1091.0758     124.6975      76.1902      63.5695      55.5056      18.0162     216.0000       0.0402      -0.0384      -0.0762       5.4132      59.7200     282.8586     440.3908      51.6218       0.1107       0.1258       0.1739       5.6866    2775.7048     571.2783     131.5625    3997.0000
 2450.8968     948.9459      59.0263      58.5142      44.3153      39.7922      25.1306     216.0000       0.0726      -0.0034      -0.0399       5.7948      63.4094     283.4169     401.3071      51.6218       0.0974       0.1108       0.1579       5.7854    2715.7607     161.8156     131.5625    3964.0000
 2451.0492     161.7378      80.5317      51.0357      36.8187      34.4838      28.9991     216.0000       0.1232       0.0514       0.0169       6.0919      61.6211     282.3004     360.3420      51.6218       0.0996       0.1134       0.1606       5.9606    2622.1313      24.4852     131.5625    3939.0000
 2451.2016     151.9172      60.5117      46.7616      35.3820      32.7510      30.5334     216.0000       0.1659       0.0976       0.0648       6.5948      64.4298     289.5571     333.2894      51.3421       0.0752       0.0859       0.1308       6.1780    2543.1616      14.9659     138.6875    3942.0000
 2451.3540     108.7764      48.0411      34.2619      29.3080      24.2518      41.2340     216.0000       0.1899       0.1236       0.0917       6.7716      64.5977     262.7634     333.3735      51.6218       0.0782       0.0894       0.1344       6.4014    2498.6541      10.5494     136.3125    3925.0000
 2451.5064      69.2327      34.8284      49.0577      38.6878      28.2368      35.4147     216.0000       0.2171       0.1530       0.1222       6.5818      63.6204     264.4380     328.1291      51.6218       0.0841       0.0961       0.1418       6.6154    2448.3423      10.8097     135.4375    3927.0000
 2451.6588      64.8577      35.8538      50.7604      38.9972      26.8918      37.1861     216.0000       0.2706       0.2109       0.1822       5.8176      66.8686     282.0214     300.6611      51.6218       0.1043       0.1182       0.1663       6.8203    2349.3613       5.4816     136.1875    3859.0000
 2451.8112      86.3863      34.5696      63.5877      51.9707      22.3918      44.6592     216.0000       0.3229       0.2674       0.2408       4.3154      64.8780     286.7661     264.1358      51.6218       0.1636       0.1846       0.2362       7.0270    2252.6689       4.1233     137.8125    3817.0000
 2451.9636      81.8804      36.5041      96.4707      87.3012      18.9050      52.8960     216.0000       0.3486       0.2953       0.2696       2.8993      70.0799     273.3693     234.3261      51.6218       0.1579       0.1792       0.2301       7.1055    2205.1184       3.4336     137.2500    3912.0000
 2452.1160      79.8486      41.6571     137.7889     152.5098      50.9072      19.6436     216.0000       0.3580       0.3055       0.2802       2.9538      66.1256     294.3018     219.0348      51.6218       0.1720       0.1951       0.2464       7.1147    2187.6787       3.7015     141.3125    3925.0000
 2452.2684     150.5425      54.2320     190.8801     297.2126      77.0230      12.9831     216.0000       0.3696       0.3180       0.2932       4.0745      69.9434     315.7925     205.2104      51.6218       0.2274       0.2554       0.3081       7.0724    2166.1775       3.8416     141.3125    4040.0000
 2452.4208     119.7592      60.0138     209.6730     704.5488     164.1346       6.0926     216.0000       0.3688       0.3172       0.2923       6.9897      67.7102     352.0755     211.3522      51.6218       0.2023       0.2278       0.2803       7.0881    2167.6702       4.3762     141.3125    4152.0000
 2452.5732     140.8100      66.4971     408.4057     966.3559     224.8436       4.4475     216.0000       0.3836       0.3331       0.3089       7.4728      69.0652     361.5650     198.2599      51.6218       0.1466       0.1662       0.2169       7.1436    2140.3633       3.6738     137.4375    4177.0000
 2452.7256     109.6678      63.9383     187.9751    1310.1595     436.6869       2.2900     216.0000       0.4195       0.3720       0.3491       7.5771      61.3829     348.1682     176.5536      51.6218       0.1371       0.1557       0.2059       7.2501    2073.9211       3.2929     141.3125    4153.0000
 2452.8780     121.3906      81.1720     212.3503    1101.3740     835.0138       1.1976     216.0000       0.4817       0.4393       0.4189       7.4227      60.2286     303.5121     153.8271      51.6218       0.1882       0.2126       0.2645       7.4424    1958.8054       2.6006     140.9375    4127.0000
 2453.0304     169.7909      80.2644     209.6098     655.1065    1317.0426       0.7593     216.0000       0.5194       0.4800       0.4611       6.3328      60.1887     299.0465     170.7901      51.6218       0.1891       0.2135       0.2655       7.6353    1889.1672       2.3651     140.4375    3999.0000
 2453.1828     183.3276      81.6810     173.3266     335.1590    1339.6482       0.7465     216.0000       0.5344       0.4963       0.4780       5.9730      61.7805     296.2555     200.5204      51.6218       0.1943       0.2193       0.2714       7.7669    1861.2684       2.1451     139.3125    3948.0000
 2453.3352     363.8691      73.0374     123.8367     173.7258     989.3762       1.0107     216.0000       0.5188       0.4794       0.4604       5.8553      65.2147     295.6973     220.9582      51.6218       0.1828       0.2062       0.2583       7.6951    1890.2836       2.0617     141.8125    3917.0000
 2453.4876     325.5182      96.3909      91.0162     100.7811     636.6337       1.5708     216.0000       0.4448       0.3993       0.3775       5.1034      67.8988     294.0227     245.4947      51.6218       0.1955       0.2202       0.2726       7.3459    2027.2019       2.4435     134.6875    3798.0000
 2453.6400     174.9923      40.7088      51.0903      77.1017     414.9483       2.4099     216.0000       0.3512       0.2981       0.2725       5.1666      70.8338     290.6735     276.2258      51.6218       0.1379       0.1558       0.2063       6.8682    2200.2966       3.6242     136.2500    3773.0000
 2453.7924     233.0069      32.1103      31.7467      27.9307     245.0076       4.0815     216.0000       0.2320       0.1692       0.1389       5.4982      70.5841     288.9989     335.4609      51.6218       0.0964       0.1092       0.1569       6.3743    2420.7410       8.6736     135.8125    3757.0000
 2453.9448     355.5311      81.9088      51.7507      34.5376     127.5207       7.8419     216.0000       0.1790       0.1118       0.0795       6.1221      69.5241     275.0439     360.9936      51.6218       0.1006       0.1141       0.1619       6.1157    2518.8250      16.3779     136.8125    3819.0000
 2454.0972     515.4168     123.2508      95.8960      56.5326     207.0010       4.8309     216.0000       0.1377       0.0671       0.0332       5.9194      69.5708     253.2740     391.2554      51.6218       0.1239       0.1402       0.1897       5.9964    2595.1807      31.0870     137.9375    4029.0000
 2454.2496    1754.1642    1024.5029     209.7805      46.4804      90.3192      11.0718     216.0000       0.1193       0.0472       0.0125       6.0446      68.3527     255.5068     429.0354      51.6218       0.1092       0.1238       0.1722       6.0125    2629.3481      45.7034     136.7500    4317.0000
 2454.4020    1950.0000    1950.0000     244.9096      50.8794      49.3147      20.2779     216.0000       0.0889       0.0143      -0.0215       5.3987      66.9719     266.6708     490.7918      51.6218       0.0928       0.1055       0.1524       6.0317    2685.5032      84.4300     141.3125    4434.0000
 2454.5544    1804.3232    1257.3210     263.8221      60.3735      37.8468      26.4223     216.0000       0.0647      -0.0119      -0.0487       5.9157      61.3814     267.2290     536.6430      51.6218       0.0752       0.0860       0.1308       6.0366    2730.3599      90.8514     141.3125    4330.0000
 2454.7068    1639.3821     869.9775     241.3101      67.9493      32.1963      31.0595     216.0000       0.0572      -0.0200      -0.0571       5.9695      57.9301     267.7872     547.2379      51.6218       0.0639       0.0729       0.1167       6.0165    2744.1704      86.8826     143.7500    4245.0000
 2454.8592    1413.6196     580.4318     337.5865      76.4572      31.1982      32.0532     216.0000       0.0637      -0.0130      -0.0498       6.1520      51.6875     267.2290     534.0281      51.6218       0.0777       0.0885       0.1338       6.0013    2732.2119      76.8342     142.5000    4180.0000
 2455.0116     938.6646     304.8643     291.9256     101.7752      34.4939      28.9906     216.0000       0.0727      -0.0032      -0.0396       6.3861      56.3264     267.2290     519.2146      51.6218       0.1113       0.1262       0.1746       6.0166    2715.4131      55.3709     141.2500    4084.0000
 2455.1640     784.3017     185.8671     355.4797      97.1142      35.5314      28.1441     216.0000       0.1021       0.0286      -0.0068       6.0330      60.6353     267.5081     475.7752      51.6218       0.1065       0.1206       0.1690       6.0742    2661.1445      20.8930     138.6875    3999.0000
 2455.3164    1514.2271     136.7197     568.8887     232.7505      63.5751      15.7294     216.0000       0.1465       0.0766       0.0430       5.7115      73.9969     267.2290     404.1109      51.6218       0.1380       0.1559       0.2063       6.1322    2579.0569       9.8104     142.6250    3927.0000
 2455.4688     311.1985      75.3577     190.0429     126.0905      76.6924      13.0391     216.0000       0.1831       0.1163       0.0841       5.8392      82.3283     279.5095     316.9394      51.6218       0.1829       0.2055       0.2579       6.0660    2511.1990       7.6003     141.3125    3783.0000
 2455.6212     145.5231      45.3106     122.3658     118.6685      56.9886      17.5474     216.0000       0.1782       0.1110       0.0786       5.6836      86.8030     272.8111     257.3841      51.6218       0.1566       0.1769       0.2282       5.8443    2520.2610       8.8860     141.3125    3757.0000
 2455.7736      72.2162      33.0904      77.4150      72.8460      45.8960      21.7884     216.0000       0.1403       0.0699       0.0361       5.6513      91.3566     258.5769     230.8340      51.6218       0.1511       0.1715       0.2222       5.5674    2590.4063      13.9354     143.3125    3660.0000
 2455.9260      75.9785      39.4274     102.4360     109.5399      87.8803      11.3791     216.0000       0.1249       0.0532       0.0188       5.8732      91.4193     273.9275     207.5963      51.6218       0.1785       0.2021       0.2537       5.4032    2618.9431      20.6829     148.8750    3526.0000
 2456.0784     121.8896      58.3604     137.3630     139.2903     129.3684       7.7299     216.0000       0.1426       0.0724       0.0386       5.8391      94.6135     256.0650     193.3417      51.6218       0.1755       0.1992       0.2504       5.4208    2586.2632      20.5301     141.3125    3371.0000
 2456.2308      79.1837      64.5640     149.7292     164.7175     179.3339       5.5762     216.0000       0.1863       0.1197       0.0877       5.9965      91.6870     274.7647     188.0422      51.6218       0.2002       0.2264       0.2782       5.5555    2505.2549      14.1365     150.7500    4814.0000
 2456.3832      71.0022      53.7447     105.6320     131.7274     243.8037       4.1017     216.0000       0.1931       0.1270       0.0953       5.9235      93.7053     269.1827     227.7052      51.6218       0.2241       0.2529       0.3049       5.6791    2492.7578      11.2630     148.7500    4710.0000
 2456.5356      72.3013      58.6048      83.2666     102.7920     215.7267       4.6355     216.0000       0.1863       0.1197       0.0876       6.0491      93.4238     267.2290     263.9897      51.6218       0.2209       0.2502       0.3015       5.7531    2505.3926      10.4521     149.8125    4668.0000
 2456.6880      94.8048     104.5909     143.7563     196.1871     293.6676       3.4052     216.0000       0.1740       0.1064       0.0739       5.9622      91.5400     283.4169     279.0496      51.6218       0.2018       0.2291       0.2803       5.7565    2528.0442      11.2887     150.4375    4535.0000
 2456.8404     102.5029     112.4390     191.5856     334.0516     285.9155       3.4975     216.0000       0.1860       0.1194       0.0873       6.0678      86.2031     268.9037     251.5790      51.6218       0.1805       0.2049       0.2561       5.7301    2505.8918      12.4922     151.0625    4468.0000
 2456.9928      96.5947     133.8228     121.4997     202.7413     173.2295       5.7727     216.0000       0.2013       0.1359       0.1045       5.7777      80.6462     273.6484     215.0855      51.6218       0.1941       0.2199       0.2715       5.6810    2477.5830      10.3211     151.0625    4342.0000
 2457.1452      91.7023     158.0193     154.4088     196.1681     163.1660       6.1287     216.0000       0.1926       0.1265       0.0947       5.8487      84.2510     287.8825     199.4960      51.6218       0.1916       0.2170       0.2686       5.6222    2493.6746      10.6518     151.0625    4246.0000
 2457.2976     102.1648     228.9771     149.4342     227.5262      98.0943      10.1943     216.0000       0.1973       0.1316       0.1000       6.0481      83.6895     280.0677     194.3905      51.6218       0.2089       0.2372       0.2884       5.6377    2484.9426      10.2518     150.3125    4195.0000
 2457.4500     137.8422     279.7313     167.9839     126.0050     115.9888       8.6215     216.0000       0.2196       0.1557       0.1250       6.0660      88.7744     283.9751     197.7417      51.6218       0.1984       0.2247       0.2764       5.7434    2443.7390       8.9817     151.0625    4079.0000
 2457.6024     213.3178     268.8604     203.3187     117.8567      89.1562      11.2163     216.0000       0.2282       0.1650       0.1346       6.0918      88.0118     292.3481     226.2502      51.6218       0.1913       0.2167       0.2683       5.8890    2427.8369       7.6158     149.2500    3974.0000
 2457.7548     905.3791     486.8431     320.2650     108.6333     124.2873       8.0459     216.0000       0.2006       0.1352       0.1037       5.6058      96.7030     281.7422     263.9623      51.6218       0.2014       0.2279       0.2796       5.9463    2478.8574       7.7286     151.0625    3914.0000
 2457.9072     347.1010     127.3408     215.9944      78.2927     103.6679       9.6462     216.0000       0.1635       0.0950       0.0621       5.8268      95.8324     265.5544     287.9491      51.6218       0.2436       0.2762       0.3268       5.9076    2547.4648      12.9590     156.6250    3917.0000
 2458.0596     191.7737      66.6508     101.2943      45.9064      58.0408      17.2293     216.0000       0.1593       0.0904       0.0574       5.9508      92.4332     273.3693     270.0634      51.6218       0.2071       0.2353       0.2863       5.8424    2555.3523      13.4532     151.0625    3923.0000
 2458.2120     128.4483      36.8150      66.7349      53.0767      61.6530      16.2198     216.0000       0.1702       0.1022       0.0696       6.0788      91.2728     276.4393     235.5096      51.6218       0.2024       0.2301       0.2811       5.7964    2535.1797      10.6974     142.3750    3926.0000
 2458.3644     114.4888      38.1174      85.7169      77.8104      96.8047      10.3301     216.0000       0.1586       0.0897       0.0566       5.9297      92.3468     277.2766     217.6435      51.6218       0.2079       0.2352       0.2869       5.7598    2556.6519      10.4956     141.3125    3956.0000
 2458.5168      88.5593      37.8160      99.4728     106.9367     125.6761       7.9570     216.0000       0.1670       0.0988       0.0661       5.8137     101.2274     270.0200     209.2342      51.6218       0.2110       0.2388       0.2904       5.8471    2540.9783      11.8502     141.3125    3999.0000
 2458.6692     122.4112      43.3679      96.5602     148.0530     169.9911       5.8827     216.0000       0.1981       0.1324       0.1009       5.7784     102.5817     268.3454     224.8027      51.6218       0.1855       0.2103       0.2618       6.0970    2483.5540      12.7561     141.3125    4004.0000
 2458.8216     214.4163      60.6249      90.0736     183.7655     156.0387       6.4087     216.0000       0.2416       0.1795       0.1496       5.4981      97.0901     260.5306     258.7340      51.6218       0.1933       0.2185       0.2704       6.4677    2403.1077       8.7966     144.1250    3968.0000
 2458.9740     289.9097      85.5048     227.9938     492.4377     476.1021       2.1004     216.0000       0.2622       0.2018       0.1728       5.4979      87.4976     266.3917     291.3058      51.6218       0.1817       0.2061       0.2575       6.7391    2364.8906       7.3703     141.3125    3939.0000
 2459.1264    1355.5453     218.4312     400.1969     202.0719     886.5151       1.1280     216.0000       0.2595       0.1989       0.1698       5.8355      78.4090     287.8825     303.8273      51.6218       0.1627       0.1848       0.2357       6.8432    2369.8853       7.0412     142.8750    3937.0000
 2459.2788    1640.3054     404.0054     429.2688      93.7786     585.4870       1.7080     216.0000       0.2463       0.1846       0.1550       6.2871      80.8498     257.7396     282.5835      51.6218       0.1916       0.2166       0.2685       6.7714    2394.2922       7.3086     141.3125    3912.0000
 2459.4312     496.0862     184.0504     221.9400     105.1313     254.1602       3.9345     216.0000       0.2127       0.1483       0.1173       6.3880      79.8855     252.7158     269.3760      51.6218       0.1917       0.2161       0.2683       6.6459    2456.4463       7.9554     145.4375    4024.0000
 2459.5836     302.6861     124.3483     139.4467      96.9646     142.5360       7.0158     216.0000       0.1976       0.1319       0.1004       6.3381      79.4323     280.6259     247.0284      51.6218       0.1597       0.1804       0.2318       6.5661    2484.4136      10.2467     142.5000    4035.0000
 2459.7360     202.1636      80.4665     166.7996      79.1141     163.3456       6.1220     216.0000       0.1902       0.1239       0.0921       5.9492      77.4140     286.2079     227.8218      51.6218       0.1343       0.1522       0.2024       6.5228    2498.0820      11.4670     141.3125    4013.0000
 2459.8884     164.0674      50.4539     109.3991      70.0421      94.5299      10.5787     216.0000       0.1854       0.1187       0.0867       5.0720      80.1072     269.4618     202.0860      51.6218       0.1817       0.2052       0.2571       6.4744    2507.0176      12.2751     139.3125    3948.0000
 2460.0408     104.1769      49.1157     147.6633     110.0005     125.7338       7.9533     216.0000       0.1578       0.0888       0.0557       4.5089      81.9841     283.9751     196.4509      51.6218       0.1720       0.1943       0.2460       6.3951    2558.1113      13.8340     141.7500    3818.0000
 2460.1932     114.9202      48.0181     206.1815     159.2065     180.8059       5.5308     216.0000       0.1445       0.0745       0.0408       4.4041      84.1522     256.3441     210.5644      51.6218       0.1532       0.1738       0.2246       6.4121    2582.6316      21.7339     141.3125    3738.0000
 2460.3456     139.8443      63.4692     277.8877     255.7571     245.0157       4.0814     216.0000       0.1553       0.0862       0.0529       4.7514      84.5042     270.0200     242.0833      51.6218       0.1617       0.1831       0.2343       6.5581    2562.6731      19.0766     141.3125    3716.0000
 2460.4980     166.1036      68.2531     384.4395     412.9894     329.0796       3.0388     216.0000       0.1855       0.1189       0.0868       6.0733      85.2448     279.5095     269.6283      51.6218       0.2008       0.2270       0.2789       6.8132    2506.7366      13.5423     141.3125    3832.0000
 2460.6504     159.3815      85.1313     484.7244     543.8948     407.1095       2.4563     216.0000       0.2040       0.1389       0.1075       6.3867      77.5694     268.3454     290.5219      51.6218       0.1991       0.2251       0.2770       7.0537    2472.5574       9.8078     141.3125    3972.0000
 2460.8028     137.1983     122.3297     491.5366     494.8315     327.2778       3.0555     216.0000       0.2669       0.2069       0.1781       6.2818      68.8781     285.6496     265.1145      51.6218       0.1624       0.1838       0.2352       7.3329    2356.1438       7.0212     143.4375    4356.0000
 2460.9552     122.8577     175.9833     823.1088     727.3629     680.3547       1.4698     216.0000       0.3296       0.2747       0.2484       6.4184      62.2003     266.1126     236.3021      51.6218       0.1694       0.1911       0.2429       7.5855    2240.2205       4.6652     145.0625    4585.0000
 2461.1076      86.2466     189.9422     414.0395     267.3955     344.9218       2.8992     216.0000       0.3837       0.3333       0.3090       6.3783      65.4385     248.2502     202.1373      51.6218       0.2025       0.2283       0.2806       7.8107    2140.0935       3.7014     148.0625    4522.0000
 2461.2600      70.5583     158.4365     294.9622     243.0322     150.0895       6.6627     216.0000       0.3856       0.3353       0.3112       6.2679      66.8212     247.1338     190.0175      51.6218       0.1890       0.2145       0.2659       7.9226    2136.5632       3.7154     141.3125    4437.0000
 2461.4124      80.8701     133.9488     220.1688     158.9861     118.7046       8.4243     216.0000       0.3498       0.2966       0.2710       5.8281      65.6031     255.7859     202.8478      51.6218       0.1805       0.2052       0.2562       7.9403    2202.8125       4.4043     148.3125    4365.0000
 2461.5648      82.1213      79.1496     185.4648     158.0003     109.6305       9.1215     216.0000       0.3128       0.2566       0.2295       5.8624      64.6023     264.9962     231.7669      51.6218       0.1821       0.2072       0.2581       7.9644    2271.2600       5.8244     141.6875    4279.0000
 2461.7172      79.4159      96.6718     142.3956     134.6607     104.2582       9.5916     216.0000       0.2964       0.2388       0.2111       5.7161      63.5872     286.7661     255.7194      51.6218       0.1725       0.1950       0.2467       8.0895    2301.7170       7.0188     149.1875    4188.0000
 2461.8696      46.4684      71.1126     145.6279     106.1766      73.2092      13.6595     216.0000       0.3208       0.2652       0.2384       6.1803      67.8205     290.6735     250.5579      51.6218       0.1684       0.1903       0.2419       8.3136    2256.5776       6.5393     148.5000    4100.0000
 2462.0220      27.9864      46.1526      79.3378     103.1579      73.2845      13.6454     216.0000       0.3976       0.3483       0.3246       5.6645      67.9802     287.6034     212.6895      51.6218       0.1753       0.1976       0.2496       8.6774    2114.4148       3.6387     144.5000    3933.0000
 2462.1744      39.6489      51.6782      85.9005     141.8164     124.9630       8.0024     216.0000       0.5043       0.4637       0.4442       5.3189      71.2285     290.1153     164.0533      51.6218       0.1954       0.2209       0.2728       9.0867    1917.1211       2.4112     146.1875    4009.0000
 2462.3268      62.5076      70.8707      95.4970     145.1604     138.1656       7.2377     216.0000       0.6052       0.5729       0.5574       5.4300      70.6928     305.7449     115.3580      51.6218       0.1682       0.1910       0.2421       9.4702    1730.3210       1.7433     147.2500    4015.0000
 2462.4792      45.1350      65.4868     115.4638     168.8825     177.3349       5.6390     216.0000       0.6557       0.6275       0.6140       5.3637      69.9229     251.5994      89.2953      51.6218       0.2191       0.2487       0.2997       9.6780    1636.9515       1.5626     147.5625    3974.0000
 2462.6316      33.8629      48.5303      78.3671     126.4486     181.7460       5.5022     216.0000       0.6593       0.6314       0.6180       5.4469      68.0437     273.0901      84.9987      51.6218       0.2586       0.2909       0.3426       9.6676    1630.2366       1.5863     144.3750    3950.0000
 2462.7840      34.1506      43.4668      61.7750     102.6515     170.2157       5.8749     216.0000       0.6484       0.6196       0.6058       5.8189      67.1883     275.0439      92.3368      51.6218       0.1837       0.2084       0.2598       9.4944    1650.4590       1.6167     147.5625    3969.0000
 2462.9364      40.3799      45.9861      68.1455     114.9465     199.2024       5.0200     216.0000       0.6283       0.5979       0.5832       5.4908      68.3642     275.0439     106.0197      51.6218       0.1492       0.1692       0.2199       9.1973    1687.6748       1.6997     144.5000    3968.0000
 2463.0888      41.7606      61.2443      92.5765     164.5833     283.9961       3.5212     216.0000       0.5745       0.5397       0.5229       5.7649      70.0852     275.0439     143.2121      51.6218       0.1899       0.2143       0.2664       8.7713    1787.1837       1.8998     146.1250    3984.0000
 2463.2412      53.0219     128.4108     148.8205     251.3054     329.7121       3.0329     216.0000       0.4790       0.4364       0.4159       5.8038      69.3369     286.2079     213.5726      51.6218       0.2132       0.2404       0.2926       8.2706    1963.7998       2.4546     140.2500    3939.0000
 2463.3936      78.6590     242.2153     277.8368     526.9597     505.7110       1.9774     216.0000       0.3822       0.3316       0.3073       5.6930      67.9576     309.6523     279.2320      51.6218       0.1381       0.1565       0.2069       7.7274    2142.9827       3.4527     142.4375    4000.0000
 2463.5460      80.2519     389.3459     349.4271     538.5067     361.6337       2.7652     216.0000       0.3038       0.2468       0.2194       5.8663      66.6947     301.2793     323.3389      51.6218       0.1470       0.1662       0.2171       7.2561    2288.0273       5.4039     141.3125    3988.0000
 2463.6984      76.5203     194.4944     207.2156     519.4323     326.2831       3.0648     216.0000       0.2557       0.1948       0.1655       5.7201      67.0370     319.1417     331.7208      51.6218       0.1277       0.1444       0.1943       6.8860    2376.9016       7.8381     141.3125    3947.0000
 2463.8508      76.3028     313.7594     465.5566     636.8571     330.6855       3.0240     216.0000       0.2492       0.1878       0.1582       5.5925      66.8336     295.1391     314.9865      51.6218       0.1380       0.1560       0.2065       6.6851    2388.9043      10.1566     141.3125    4008.0000
 2464.0032      71.3874     331.5390     456.1186     333.7803     444.7314       2.2485     216.0000       0.2687       0.2089       0.1801       5.4914      63.8226     315.7925     298.7833      51.6218       0.1395       0.1576       0.2082       6.6465    2352.8433       8.4112     141.7500    3950.0000
 2464.1556      69.9447     346.8423     992.4193     276.0402     362.8499       2.7560     216.0000       0.2775       0.2184       0.1899       5.4968      62.4399     288.9989     302.7346      51.6218       0.1163       0.1317       0.1810       6.6316    2336.5916       7.5642     141.9375    3979.0000
 2464.3080      71.6106     201.3890    1107.2709     241.4276     862.8198       1.1590     216.0000       0.2486       0.1870       0.1575       5.5142      62.0331     280.6259     333.1654      51.6218       0.1403       0.1585       0.2092       6.5742    2390.1504       7.0008     141.3125    3977.0000
 2464.4604      84.1088     177.5127     243.4952     126.5372     320.5814       3.1193     216.0000       0.1977       0.1320       0.1004       5.7828      59.4802     290.6735     371.9194      51.6218       0.1656       0.1865       0.2382       6.4624    2484.2749      10.3526     143.3125    3975.0000
 2464.6128      87.9267     123.2777     245.9433     178.4891     258.4699       3.8689     216.0000       0.1846       0.1178       0.0857       5.7601      58.4268     288.4407     389.8284      51.6218       0.1585       0.1786       0.2301       6.4700    2508.5728      12.5722     141.3125    3992.0000
 2464.7652     115.5871      95.9137     195.0681     159.2753     184.4351       5.4220     216.0000       0.2141       0.1498       0.1189       5.5032      57.1680     280.6259     380.2009      51.6218       0.0948       0.1072       0.1549       6.6013    2453.8267      12.4071     143.8125    3984.0000
 2464.9176      92.5100     101.9831     128.1800     159.1823     113.3267       8.8240     216.0000       0.2557       0.1947       0.1655       5.5398      60.7404     301.8375     354.8424      51.6218       0.0870       0.0985       0.1453       6.7621    2376.9954       8.0542     141.3125    3908.0000
 2465.0700      56.3392     105.5328     135.8729     131.0340      97.9148      10.2130     216.0000       0.2584       0.1977       0.1686       5.7171      61.1837     288.1616     350.5733      51.6218       0.1287       0.1455       0.1953       6.8413    2371.8896       7.5424     146.5000    3940.0000
 2465.2224      66.4749      87.8252     159.1240     125.5291      83.9082      11.9178     216.0000       0.2534       0.1923       0.1629       5.7394      59.9656     301.8375     353.1973      51.6218       0.1284       0.1452       0.1951       6.8761    2381.2087       8.8515     133.3125    3960.0000
 2465.3748     145.8513     252.8100     147.6529     105.4381      64.3799      15.5328     216.0000       0.2967       0.2391       0.2115       5.8167      62.8914     302.9539     329.9120      51.6218       0.1119       0.1267       0.1757       6.9710    2301.0767       6.8791     143.6875    3973.0000
 2465.5272     126.0309     133.5394     167.8036     111.5122      68.6281      14.5713     216.0000       0.3809       0.3302       0.3058       5.6928      61.8391     304.0703     268.8350      51.6218       0.1298       0.1468       0.1969       7.1266    2145.3608       4.0078     141.3125    4011.0000
 2465.6796     115.5333     140.3890      98.8200      68.6449      44.2560      22.5958     216.0000       0.3783       0.3274       0.3030       5.6129      62.4854     315.7925     255.2437      51.6218       0.1963       0.2204       0.2732       7.1010    2150.1094       3.2481     141.3125    3975.0000
 2465.8320     103.9212      88.4032     115.0359      48.6235      32.6580      30.6203     216.0000       0.3142       0.2581       0.2311       5.6534      58.5426     324.1655     270.1929      51.6218       0.2213       0.2475       0.3008       6.9096    2268.6870       3.9128     141.3125    4006.0000
 2465.9844      76.9216     100.6795     137.5857      92.5993      56.1470      17.8104     216.0000       0.2572       0.1964       0.1672       5.4770      59.9637     270.5782     289.8498      51.6218       0.1406       0.1590       0.2096       6.6597    2374.1318       5.3638     141.3125    4030.0000
 2466.1368      86.5402     148.9574     156.4208     111.9351      71.0259      14.0794     216.0000       0.2854       0.2269       0.1988       5.5807      62.8235     270.0200     266.1655      51.6218       0.0976       0.1104       0.1584       6.5466    2322.0103       4.9899     143.0000    3938.0000
 2466.2892      81.1355      97.4697     243.1278     241.3407     198.7489       5.0315     216.0000       0.3176       0.2617       0.2349       5.5752      66.6439     258.8560     236.3355      51.6218       0.1237       0.1399       0.1896       6.4523    2262.4126       3.9944     142.8125    3942.0000
 2466.4416      62.6404      58.8373     149.8286     100.2748      73.1083      13.6783     216.0000       0.2766       0.2174       0.1889       5.7275      71.3132     251.5994     222.8718      51.6218       0.1725       0.1944       0.2464       6.1549    2338.2517       4.1092     143.7500    3982.0000
 2466.5940      38.9379      30.1718      51.1564      81.2714      54.9313      18.2046     216.0000       0.2112       0.1466       0.1155       5.4781      72.7248     267.7872     204.8089      51.6218       0.1826       0.2056       0.2579       5.7445    2459.3477       5.7592     141.9375    3953.0000
 2466.7464      41.8242      32.5930      61.8558     164.6222     111.1522       8.9967     216.0000       0.1467       0.0768       0.0432       5.4723      72.1509     259.9724     191.4678      51.6218       0.1556       0.1760       0.2272       5.3309    2578.6428      10.4333     151.7500    3976.0000
 2466.8988      57.3716      44.6358      93.2191     183.1853     154.5330       6.4711     216.0000       0.1231       0.0513       0.0168       5.6823      69.9603     268.9037     176.0929      51.6218       0.1399       0.1582       0.2088       5.0823    2622.2795      15.9938     141.3125    3973.0000
 2467.0512      90.6327      55.1261      96.1308     196.2942     213.0345       4.6941     216.0000       0.1089       0.0359       0.0008       5.7894      75.5995     268.3454     157.9859      51.6218       0.1242       0.1405       0.1903       4.8775    2648.6157      18.1533     151.0625    3939.0000
 2467.2036      46.4468      56.6900     102.7257     186.8971     281.4675       3.5528     216.0000       0.0987       0.0249      -0.0105       5.8741      86.5272     253.8322     140.1110      51.6218       0.1389       0.1571       0.2076       4.6992    2667.3806      22.5602     146.9375    3974.0000
 2467.3560      41.3503      51.5136      86.6231     161.5811     315.4053       3.1705     216.0000       0.1027       0.0292      -0.0061       5.7439      98.5275     261.3680     118.3422      51.6218       0.1561       0.1764       0.2277       4.5859    2660.0388      27.9705     152.3125    3973.0000
 2467.5084      36.8236      54.9773      70.6772     102.4803     310.0774       3.2250     216.0000       0.1151       0.0427       0.0079       5.6223     103.0581     272.2528     110.0736      51.6218       0.1649       0.1862       0.2378       4.5862    2636.9939      39.2208     151.7500    4005.0000
 2467.6608      39.0846      84.5606      98.4774     139.3377     278.0055       3.5971     216.0000       0.1273       0.0559       0.0215       5.4979     103.0382     269.4618     113.8284      51.6218       0.1504       0.1703       0.2212       4.6475    2614.4934      17.7286     154.8125    4085.0000
 2467.8132      45.6025     114.8521     132.5535     185.1747     276.0726       3.6222     216.0000       0.1219       0.0500       0.0155       5.5484     100.5370     263.3217     119.9448      51.6218       0.1661       0.1877       0.2393       4.6507    2624.4387      16.1451     151.7500    4063.0000
 2467.9656      50.9260     159.8749     243.5889     278.7706     401.1856       2.4926     216.0000       0.1016       0.0281      -0.0073       5.6795      97.6305     276.1603     118.6228      51.6218       0.1822       0.2054       0.2575       4.5461    2662.0269      18.1142     151.0625    4016.0000
 2468.1180      72.1046     193.2612     567.0440     739.6685     440.5813       2.2697     216.0000       0.0962       0.0223      -0.0133       5.7590      97.1038     273.6484      98.2268      51.6218       0.1653       0.1868       0.2383       4.3870    2671.9412      37.2776     152.3750    3953.0000
 2468.2704      85.7010     228.4815     355.9380     442.0134     396.6950       2.5208     216.0000       0.1001       0.0265      -0.0089       5.9188      94.1133     280.0677      75.3222      51.6218       0.1592       0.1800       0.2313       4.2334    2664.7268      37.1339     152.0625    3853.0000
 2468.4228      88.9871     114.0897     254.5381     231.8608     221.1445       4.5219     216.0000       0.1098       0.0369       0.0019       5.7789      97.4578     284.5333      60.9040      51.6218       0.1494       0.1687       0.2198       4.1186    2646.8618      32.6368     154.4375    3834.0000
 2468.5752      77.1878      94.5808     236.7236     215.3488     196.5916       5.0867     216.0000       0.1058       0.0326      -0.0026       5.8474      94.9593     280.3468      56.8702      51.6218       0.1399       0.1583       0.2089       4.0464    2654.2085      31.2499     146.4375    3892.0000
 2468.7276      61.9656      72.1701     163.0569     142.6694     138.5836       7.2159     216.0000       0.1089       0.0359       0.0009       5.6452     100.7920     285.9287      57.2970      51.6218       0.1265       0.1431       0.1929       4.0527    2648.5854      38.8444     156.3125    4013.0000
 2468.8800      55.7337      67.5301     132.9326     134.9189     110.3574       9.0615     216.0000       0.1032       0.0298      -0.0055       5.5008     100.3539     283.4169      68.7199      51.6218       0.1561       0.1761       0.2275       4.1316    2659.1077      35.1762     154.6250    4179.0000
 2469.0324      60.4322      80.9741     150.1501     188.4156     122.0185       8.1955     216.0000       0.1002       0.0265      -0.0089       5.4622     107.3271     287.3243      86.1642      51.6218       0.1420       0.1604       0.2111       4.2366    2664.6577      38.4705     156.2500    4480.0000
 2469.1848      68.1360     134.3036     239.4034     237.8621     196.7225       5.0833     216.0000       0.0909       0.0165      -0.0192       5.5979     103.0721     289.5571      95.8476      51.6218       0.1238       0.1401       0.1899       4.2762    2681.7485      33.4659     154.8750    4418.0000
 2469.3372      65.3734     145.5653     259.6821     238.0092     230.0966       4.3460     216.0000       0.0932       0.0190      -0.0167       5.7206     105.1060     289.5571      88.2902      51.6218       0.1538       0.1738       0.2250       4.2262    2677.4927      33.1101     156.9375    4351.0000
 2469.4896      64.9808     101.9347     188.8073     202.6635     134.5573       7.4318     216.0000       0.1025       0.0291      -0.0062       5.8285     104.2232     289.2780      67.0996      51.6218       0.1640       0.1851       0.2367       4.1176    2660.2959      27.6787     155.8125    4239.0000
 2469.6420      66.1120      81.1377     137.8983     143.9808      89.4734      11.1765     216.0000       0.1210       0.0490       0.0144       5.9237     104.0120     294.5809      39.9151      51.6218       0.1674       0.1891       0.2407       4.0116    2626.1702      28.0542     157.5000    4200.0000
 2469.7944      70.5329      97.2122     183.1745     140.5613     106.7840       9.3647     216.0000       0.1224       0.0505       0.0160       5.7224      95.4537     301.8375      26.8366      51.6218       0.1419       0.1607       0.2112       3.9510    2623.6311      31.6476     154.9375    4012.0000
 2469.9468      81.2700     128.5730     213.5034     163.5067     118.3554       8.4491     216.0000       0.1103       0.0374       0.0024       5.8150      91.6584     294.5809      28.0287      51.6218       0.1563       0.1769       0.2281       3.9084    2646.0137      35.0211     156.9375    3966.0000
 2470.0992      61.3639      95.1083     161.9335     123.0797     105.9552       9.4380     216.0000       0.0955       0.0214      -0.0141       5.7708      99.4448     284.5333      34.0803      51.6218       0.1650       0.1861       0.2378       3.8724    2673.3276      40.2407     158.0000    4025.0000
 2470.2516      51.9891      85.1449     162.4219     123.4162      99.7695      10.0231     216.0000       0.0940       0.0198      -0.0158       5.7972     103.0627     293.4644      22.9156      51.6218       0.1505       0.1700       0.2211       3.7965    2676.0967      40.4321     151.0625    4006.0000
 2470.4040      51.8984      84.0852     167.3452     145.7175     104.5555       9.5643     216.0000       0.0985       0.0247      -0.0108       5.9586     111.5273     304.6285       6.8107      51.6218       0.1322       0.1495       0.1997       3.7542    2667.7900      43.7094     153.4375    4084.0000
 2470.5564      53.3589      88.0018     161.5280     148.1997      89.3037      11.1977     216.0000       0.0944       0.0202      -0.0154       5.7962     111.6108     301.8375      11.0824      51.6218       0.1393       0.1577       0.2082       3.8113    2675.3733      41.6549     151.0625    3977.0000
 2470.7088      46.7112      88.6048     143.6760     139.7729      89.4224      11.1829     216.0000       0.0870       0.0123      -0.0236       5.8192     113.9071     295.6973      36.0789      51.6218       0.1570       0.1773       0.2286       3.9542    2688.9700      40.1539     153.0000    4000.0000
 2470.8612      45.1596      77.9853     159.2311     165.8471      98.8139      10.1200     216.0000       0.0896       0.0151      -0.0207       5.8016     107.2729     301.5584      60.0455      51.6218       0.1549       0.1752       0.2264       4.1262    2684.1909      37.3517     152.7500    4016.0000
 2471.0136      55.0097      85.8803     191.9768     213.1559     135.3495       7.3883     216.0000       0.0964       0.0225      -0.0131       5.8470      99.2001     295.1391      72.7887      51.6218       0.1726       0.1946       0.2465       4.2558    2671.5901      34.0569     152.0625    4043.0000
 2471.1660      54.9474      85.5993     215.1750     266.1427     165.5884       6.0391     216.0000       0.1015       0.0279      -0.0074       5.9215      98.7309     304.6285      82.7661      51.6218       0.1587       0.1794       0.2307       4.3602    2662.2751      30.2319     151.0625    4132.0000
 2471.3184      66.5947     102.7102     227.1943     333.2755     239.7031       4.1718     216.0000       0.1019       0.0283      -0.0070       5.7551      97.9356     314.6761      89.6010      51.6218       0.1666       0.1886       0.2400       4.3815    2661.5457      24.8719     151.0625    4104.0000
 2471.4708      79.5320     120.2408     280.8583     397.3110     294.8679       3.3913     216.0000       0.1008       0.0272      -0.0082       5.7102     100.9809     315.7925      91.3212      51.6218       0.1857       0.2098       0.2617       4.2862    2663.5239      24.5090     146.5000    4080.0000
 2471.6232      82.7886     116.5947     380.7836     484.1288     364.2149       2.7456     216.0000       0.1003       0.0266      -0.0088       5.9586     102.0602     330.3058      83.9987      51.6218       0.1908       0.2152       0.2674       4.1137    2664.4600      29.4084     150.0625    4151.0000
 2471.7756      89.5665     190.6139     391.4283     469.1976     334.1640       2.9925     216.0000       0.0915       0.0171      -0.0186       5.9310      98.5842     312.4433      79.1090      51.6218       0.1458       0.1649       0.2157       3.9591    2680.7559      38.1683     149.3125    4087.0000
 2471.9280      74.6174     190.7738     816.1993     858.5691     520.8618       1.9199     216.0000       0.0804       0.0051      -0.0311       6.0382      96.2927     315.2343      73.1525      51.6218       0.1209       0.1368       0.1864       3.8439    2701.2847      43.7057     148.5625    4072.0000
 2472.0804      60.3844     180.3577     270.7092     236.0403     156.1253       6.4051     216.0000       0.0793       0.0039      -0.0323       5.9831      98.2007     312.4433      55.2454      51.6218       0.1365       0.1542       0.2046       3.7396    2703.2637      41.0202     149.4375    4079.0000
 2472.2328      58.7857      99.5179     200.3026     199.4443     133.2323       7.5057     216.0000       0.0798       0.0045      -0.0317       5.8912      97.7373     305.1867      31.1983      51.6218       0.1509       0.1702       0.2214       3.6414    2702.3533      41.9251     146.4375    4027.0000
 2472.3852      70.2199      84.1580     136.4190     115.5228      82.1416      12.1741     216.0000       0.0890       0.0144      -0.0215       5.9142     102.3289     307.9777      10.4525      51.6218       0.1244       0.1407       0.1905       3.6048    2685.4270      50.7815     148.6875    3950.0000
 2472.5376      53.6732      82.3874     148.5725     122.2949      82.7028      12.0915     216.0000       0.0946       0.0205      -0.0151       5.5380      98.5902     318.0253      15.5694      51.6218       0.1320       0.1493       0.1995       3.6974    2674.9829      62.3535     148.2500    3988.0000
 2472.6900      48.2125      81.9514     171.0788     147.3149      92.1398      10.8531     216.0000       0.1011       0.0275      -0.0079       5.8440      97.3722     308.5359      44.7049      51.6218       0.1249       0.1413       0.1911       3.8806    2663.0161      74.3737     151.0625    4027.0000
 2472.8424      52.6803     117.9447     219.4048     176.5665      99.8656      10.0135     216.0000       0.1012       0.0277      -0.0077       5.8569      97.7113     318.0253      78.9483      51.6218       0.1327       0.1501       0.2003       4.0671    2662.7146      44.0374     145.6250    4038.0000
 2472.9948      49.0395      87.3493     161.0096     166.9561      90.8732      11.0043     216.0000       0.0973       0.0234      -0.0121       5.8608      96.6943     317.4671      93.0886      51.6218       0.1904       0.2146       0.2669       4.1567    2669.9780      28.1218     151.0625    4083.0000
 2473.1472      53.1490      69.5968     163.1108     182.3750      63.6966      15.6994     216.0000       0.0994       0.0257      -0.0098       5.8566     101.7788     323.8864      77.6296      51.6218       0.2140       0.2415       0.2936       4.1451    2666.1238      23.9171     142.6250    4013.0000
 2473.2996      65.1374      80.4979     266.5806     315.7918     121.4222       8.2357     216.0000       0.0970       0.0231      -0.0124       5.8503     100.4227     328.6311      68.3289      51.6218       0.1761       0.1995       0.2510       4.1332    2670.5002      25.4998     144.8750    4055.0000
 2473.4520      68.0937     108.4521     355.1765     428.3989     268.5280       3.7240     216.0000       0.1032       0.0298      -0.0055       6.1094     103.8150     340.3533      82.3560      51.6218       0.1472       0.1672       0.2178       4.2227    2659.0530      30.2498     145.9375    4076.0000
 2473.6044      63.0200     114.0597     339.5384     445.3501     221.3567       4.5176     216.0000       0.1029       0.0294      -0.0059       5.9663      99.3396     332.5385     125.1647      51.6218       0.1895       0.2135       0.2658       4.4020    2659.6775      23.3571     141.3125    4053.0000
 2473.7568      59.8734      77.3785     319.1994     432.8954     236.4126       4.2299     216.0000       0.1038       0.0304      -0.0048       5.9516      96.3538     346.4936     156.2483      51.6218       0.1844       0.2083       0.2603       4.5575    2657.9614      21.1410     144.0625    4071.0000
 2473.9092      71.2440      80.5272     234.6821     364.9696     224.4928       4.4545     216.0000       0.0972       0.0233      -0.0123       6.0788      94.3853     342.5862     163.1658      51.6218       0.1605       0.1817       0.2329       4.5883    2670.2161      17.2311     141.3125    4009.0000
 2474.0616      62.2110      66.8753     173.2236     258.5814     162.6191       6.1493     216.0000       0.0923       0.0180      -0.0177       6.0907      94.0340     345.3771     154.1436      51.6218       0.1683       0.1903       0.2418       4.5549    2679.1772      17.8482     143.3125    3980.0000
 2474.2140      66.6872      78.5638     260.6472     263.3674     191.4029       5.2246     216.0000       0.0894       0.0148      -0.0210       6.1179      92.2854     347.6099     146.3487      51.6218       0.1611       0.1819       0.2334       4.5134    2684.6851      16.9998     142.5000    3992.0000
 2474.3664      74.8613     134.7865     267.0887     251.9092     185.7744       5.3829     216.0000       0.0882       0.0135      -0.0224       5.9751      89.9906     348.1682     145.5708      51.6218       0.1467       0.1660       0.2168       4.5104    2686.9026      17.9374     143.7500    4038.0000
 2474.5188      60.0435     109.2203     301.8823     251.1699     150.7378       6.6340     216.0000       0.0891       0.0145      -0.0213       6.0772      90.8042     352.3546     137.7931      51.6218       0.1662       0.1877       0.2393       4.4724    2685.1699      16.5801     142.5000    4035.0000
 2474.6712      45.9122      70.9853     128.1553     116.4801      88.3402      11.3199     216.0000       0.0982       0.0243      -0.0112       6.0334      90.2503     342.0280     125.0525      51.6218       0.1632       0.1847       0.2361       4.4068    2668.4170      16.9829     148.7500    4087.0000
 2474.8236      70.1318      91.1968     185.9945     129.3865      86.8346      11.5161     216.0000       0.1053       0.0320      -0.0032       5.9544      88.8370     362.1232     107.6653      51.6218       0.1818       0.2055       0.2573       4.3005    2655.2312      17.0486     141.3125    4045.0000
 2474.9760      95.8958     135.6186     250.5176     205.4147     128.7704       7.7658     216.0000       0.1032       0.0298      -0.0055       5.8112      86.3962     357.6576     101.2485      51.6218       0.1748       0.1977       0.2493       4.2134    2659.0979      19.8594     141.3125    3998.0000
 2475.1284      92.2093     102.1818     285.0269     250.0806     139.3369       7.1768     216.0000       0.0950       0.0209      -0.0147       5.9701      87.2994     357.6576      99.2308      51.6218       0.1712       0.1937       0.2452       4.1578    2674.2437      19.0181     141.3125    3984.0000
 2475.2808      77.8895      91.7158     265.6098     277.0186     140.3955       7.1227     216.0000       0.0846       0.0096      -0.0264       6.0265      91.8210     357.3785     101.9375      51.6218       0.1800       0.2034       0.2553       4.1433    2693.5242      19.6712     139.6875    4022.0000
 2475.4332      91.2808     114.0159     350.3028     395.1708     181.6720       5.5044     216.0000       0.0832       0.0082      -0.0279       6.0285      93.4482     352.0755      98.1567      51.6218       0.1629       0.1842       0.2356       4.1580    2696.0483      21.7058     139.3125    3997.0000
 2475.5856     105.7407     184.0238     547.4813     638.6516     278.4893       3.5908     216.0000       0.0830       0.0079      -0.0282       5.9358      96.9363     359.8904     101.6092      51.6218       0.1498       0.1696       0.2205       4.1964    2696.4570      25.8921     136.3125    4014.0000
 2475.7380     121.0895     183.4839    1469.9774    1562.6106     700.7832       1.4270     216.0000       0.0832       0.0081      -0.0279       5.9645      93.2752     364.0769     111.8846      51.6218       0.1529       0.1727       0.2239       4.2569    2696.0811      24.6100     137.5625    4023.0000
 2475.8904     117.3078     165.9541     815.5236    1012.1620     499.3571       2.0026     216.0000       0.0812       0.0060      -0.0302       6.0422      95.4536     367.1470     122.7956      51.6218       0.1576       0.1780       0.2294       4.3102    2699.7656      21.0861     135.6250    4028.0000
 2476.0428     104.6949     124.5091     541.1583     738.9637     233.9014       4.2753     216.0000       0.0846       0.0097      -0.0263       6.1002      91.0072     365.1933     126.8771      51.6218       0.1587       0.1793       0.2306       4.3639    2693.4050      20.9317     140.2500    4005.0000
 2476.1952      86.3095     101.9817     409.6194     539.9423     137.5675       7.2692     216.0000       0.0902       0.0157      -0.0201       6.2074      92.2276     363.7978     135.0043      51.6218       0.1480       0.1676       0.2184       4.4296    2683.1719      21.9943     131.5625    4008.0000
 2476.3476      78.2554      92.1112     375.1009     501.5601     184.4534       5.4214     216.0000       0.0959       0.0219      -0.0137       6.1486      89.3060     368.2634     141.1092      51.6218       0.1598       0.1808       0.2321       4.4791    2672.5293      20.9497     133.3125    3989.0000
 2476.5000      81.3167      99.7951     401.4707     410.2855     168.5815       5.9318     216.0000       0.0945       0.0204      -0.0152       6.1947      85.2932     374.9618     136.6022      51.6218       0.1701       0.1921       0.2438       4.4448    2675.1064      18.1363     131.5625    4022.0000
 2476.6524      76.0572      94.8062     368.3980     332.4183     161.7085       6.1840     216.0000       0.0922       0.0178      -0.0179       6.2881      86.2497     366.0306     114.2871      51.6218       0.1755       0.1980       0.2499       4.3049    2679.5049      20.1639     132.0625    4079.0000
 2476.8048      67.1166      98.3974     378.7622     320.9602     157.7867       6.3377     216.0000       0.1064       0.0332      -0.0019       6.3292      91.1950     364.9142      73.1800      51.6218       0.1477       0.1673       0.2181       4.1356    2653.1528      22.4152     132.3125    4017.0000
 2476.9572      76.0073     111.1569     420.7127     422.5918     193.5853       5.1657     216.0000       0.1057       0.0325      -0.0027       6.2467     101.5012     363.5187      54.0662      51.6218       0.1606       0.1814       0.2328       4.0021    2654.4094      26.0563     133.8125    4023.0000
 2477.1096      80.8974     137.9027     513.3060     439.5434     199.2374       5.0191     216.0000       0.1022       0.0287      -0.0067       6.2172     103.3284     374.9618      51.6674      51.6218       0.1684       0.1904       0.2420       3.9301    2660.9797      23.6874     131.5625    4008.0000
 2477.2620      90.8565     128.4141     610.7006     538.1195     264.1012       3.7864     216.0000       0.0840       0.0090      -0.0271       6.2426     102.7874     364.3560      66.5338      51.6218       0.1605       0.1814       0.2328       3.8876    2694.6870      23.8759     131.5625    4025.0000
 2477.4144      83.1364      98.2160     489.3325     558.2854     200.4619       4.9885     216.0000       0.0890       0.0144      -0.0215       6.1754      98.3211     366.5888      64.4917      51.6218       0.1647       0.1858       0.2375       3.8856    2685.4221      24.8725     133.3125    3990.0000
 2477.5668      85.2054     103.5572     576.4876     824.0143     209.8933       4.7643     216.0000       0.1023       0.0288      -0.0066       6.2755      95.8449     360.7277      57.6811      51.6218       0.1311       0.1483       0.1984       3.9266    2660.8198      28.3403     133.0625    4011.0000
 2477.7192      93.5025     110.2035     667.5275     958.4848     317.7312       3.1473     216.0000       0.1070       0.0338      -0.0013       6.3556      90.7079     363.7978      56.2906      51.6218       0.1322       0.1495       0.1997       3.9875    2652.1406      31.1808     133.1250    4015.0000
 2477.8716      90.5959     106.2813     673.4063    1020.7458     368.4097       2.7144     216.0000       0.1086       0.0356       0.0005       6.4605      93.7532     364.9142      55.5644      51.6218       0.1422       0.1606       0.2114       4.0205    2649.1667      28.9001     131.7500    4111.0000
 2478.0240      91.8869      98.4364     553.6719     859.3735     338.7744       2.9518     216.0000       0.1047       0.0315      -0.0038       6.3810      93.6491     364.3560      50.8947      51.6218       0.1413       0.1597       0.2104       4.0172    2656.2151      26.8142     136.7500    4105.0000
 2478.1764      85.2047      98.0304     444.5241     632.9804     269.5769       3.7095     216.0000       0.1077       0.0346      -0.0005       6.3984      99.1928     368.8216      46.4728      51.6218       0.1587       0.1792       0.2306       4.0006    2650.8254      27.4787     132.6250    4035.0000
 2478.3288      76.3170      84.1604     372.9547     478.6174     211.4955       4.7282     216.0000       0.0970       0.0231      -0.0125       6.3525      95.2787     372.1708      65.4054      51.6218       0.1686       0.1903       0.2420       4.0346    2670.5642      30.2617     136.0625    4067.0000
 2478.4812      68.6102      87.9921     241.3923     340.0726     128.2347       7.7982     216.0000       0.0833       0.0082      -0.0278       6.2770      92.8245     369.6589      83.2379      51.6218       0.1502       0.1706       0.2212       4.0863    2695.8943      31.6893     131.5625    4049.0000
 2478.6336      69.1737      98.4141     222.4270     246.6838     135.9204       7.3572     216.0000       0.0732      -0.0026      -0.0391       6.2951      92.1531     374.6827      97.2493      51.6218       0.1742       0.1966       0.2485       4.1583    2714.4895      31.6573     134.8750    4029.0000
 2478.7860     131.9645     199.8489     270.7175     284.6964     160.3365       6.2369     216.0000       0.0741      -0.0017      -0.0381       6.2976      93.6907     369.3798      94.6567      51.6218       0.1758       0.1985       0.2503       4.1910    2712.9321      32.4072     134.6875    4006.0000
 2478.9384     195.2539     235.2965     407.9527     371.5632     192.3272       5.1995     216.0000       0.0775       0.0019      -0.0343       6.3854      97.7721     373.8454      93.8792      51.6218       0.1616       0.1826       0.2340       4.1867    2706.6726      29.9446     136.2500    4008.0000
 2479.0908     163.1153     178.5699     277.2432     235.6511     138.9452       7.1971     216.0000       0.0806       0.0053      -0.0309       6.3533      97.1631     376.0782      77.2038      51.6218       0.1694       0.1920       0.2433       4.1091    2700.9485      27.0565     136.8750    3992.0000
 2479.2432     117.0504     107.7549     135.7765     121.3440      78.4923      12.7401     216.0000       0.0815       0.0064      -0.0298       6.3318      98.1853     379.4274      54.9080      51.6218       0.1911       0.2167       0.2682       4.0115    2699.1401      28.5173     136.8125    3999.0000
 2479.3956     121.8604      56.3018      73.4526      68.2772      53.9557      18.5337     216.0000       0.0778       0.0023      -0.0340       6.4020      92.2358     386.6840      38.2855      51.6218       0.1958       0.2214       0.2733       3.9473    2706.1396      34.6964     139.1875    4000.0000
 2479.5480      84.6266      89.8306     182.0394     138.3088      67.6173      14.7891     216.0000       0.0754      -0.0003      -0.0367       6.4086      88.8382     383.8930      43.8766      51.6218       0.1567       0.1777       0.2286       3.9575    2710.5444      41.1531     134.1250    4043.0000
 2479.7004     124.1791     150.4608     208.3005     201.8570     101.2951       9.8722     216.0000       0.0751      -0.0006      -0.0370       6.4729      84.1549     385.0094      63.2899      51.6218       0.1684       0.1908       0.2421       4.0279    2711.0867      34.6965     137.6250    4009.0000
 2479.8528     116.8905     150.8103     262.9327     275.3215     118.9112       8.4096     216.0000       0.0819       0.0067      -0.0294       6.5597      87.6061     393.3824      85.0339      51.6218       0.2039       0.2305       0.2824       4.1389    2698.5774      26.0326     136.6250    4001.0000
 2480.0052     116.3406     103.7456     206.1584     241.5231      78.6394      12.7163     216.0000       0.0856       0.0108      -0.0252       6.6434      87.0691     386.9631     112.9761      51.9014       0.2227       0.2516       0.3034       4.2849    2691.6055      22.0436     133.3125    3965.0000
 2480.1576     133.5049      85.3744     174.4535     288.0600      57.6788      17.3374     216.0000       0.0909       0.0164      -0.0193       6.5275      87.4223     383.8930     133.3122      51.9014       0.2061       0.2334       0.2850       4.4110    2681.9077      18.8808     135.7500    3972.0000
 2480.3100     147.9669      83.8754     187.8108     427.0142      78.1872      12.7898     216.0000       0.0945       0.0203      -0.0153       6.4807      88.2344     388.9168     146.3842      51.9014       0.2228       0.2534       0.3040       4.4748    2675.2263      16.8865     137.0000    3963.0000
 2480.4624     153.0875     118.2016     292.3869     578.9683     120.3809       8.3070     216.0000       0.0933       0.0191      -0.0166       6.5645      86.1272     402.3136     150.0571      51.9014       0.2274       0.2584       0.3090       4.4709    2677.3176      14.7068     136.7500    3990.0000
 2480.6148     150.1562     198.2971     386.2404     864.8631     189.9814       5.2637     216.0000       0.0910       0.0166      -0.0192       6.5955      87.3453     397.2899     143.2137      51.9014       0.2479       0.2813       0.3316       4.4239    2681.6260      13.9929     137.5625    3966.0000
 2480.7672     178.8148     177.5412     783.2543    1605.3831     512.4717       1.9513     216.0000       0.0916       0.0172      -0.0185       6.4534      82.1591     400.6390     129.0345      51.6218       0.1800       0.2042       0.2556       4.3644    2680.5754      15.2200     135.2500    3997.0000
 2480.9196     140.4562     156.1276     482.5627    1498.5576     417.5026       2.3952     216.0000       0.0902       0.0157      -0.0201       6.5214      89.8250     416.2687     114.3026      51.9014       0.1729       0.1961       0.2474       4.3110    2683.2153      15.9719     135.9375    3952.0000
 2481.0720     134.9874     108.2974     306.5035    1711.4285     550.8297       1.8154     216.0000       0.0922       0.0179      -0.0178       6.5860      88.6069     416.5478     100.3802      51.9014       0.2133       0.2408       0.2928       4.2663    2679.3428      17.4135     134.5000    3980.0000
 2481.2244     169.2835      93.6345     249.8259    1890.5643     660.6131       1.5137     216.0000       0.0922       0.0179      -0.0178       6.8565      93.2419     404.5464     102.3090      51.9014       0.2159       0.2452       0.2962       4.2519    2679.3748      18.1558     131.5625    3996.0000
 2481.3768     154.4932     121.1883     390.4780    1868.1223     790.9495       1.2643     216.0000       0.0981       0.0243      -0.0112       6.8243      92.0846     400.0808     105.1238      51.9014       0.2121       0.2410       0.2920       4.2553    2668.4531      18.3868     138.0000    3985.0000
 2481.5292     178.9041     176.8006     491.3222    1682.0498     822.8948       1.2152     216.0000       0.0900       0.0155      -0.0203       6.9646      95.5359     388.6377     119.5922      51.9014       0.2244       0.2549       0.3057       4.2789    2683.5193      16.7037     131.5625    4063.0000
 2481.6816     161.3197     185.0034     636.4775    1483.8352     798.7204       1.2520     216.0000       0.0837       0.0087      -0.0273       6.9252      90.1485     391.4287     124.2225      51.9014       0.1944       0.2207       0.2720       4.3026    2695.1157      16.7611     131.5625    4022.0000
 2481.8340     142.1994     173.8521     632.8028    1207.4829     630.7889       1.5853     216.0000       0.0716      -0.0044      -0.0409       6.7118      85.2153     389.7541     125.1719      51.9014       0.1840       0.2089       0.2602       4.2936    2717.4631      18.3395     131.5625    4049.0000
 2481.9864     133.4862     131.8931     365.5597     648.4285     275.9302       3.6241     216.0000       0.0750      -0.0007      -0.0371       6.3514      84.6652     386.6840     111.1248      51.9014       0.1983       0.2242       0.2761       4.2418    2711.2063      18.9966     135.1250    4067.0000
 2482.1388     129.8154     100.1074     256.3454     430.5155     212.0920       4.7149     216.0000       0.0746      -0.0012      -0.0376       6.2322      89.8492     408.4539      91.8021      51.9014       0.1928       0.2181       0.2699       4.1352    2711.9836      19.5832     128.8750    4035.0000
 2482.2912     140.1648      95.1510     229.2885     316.4493     114.9310       8.7009     216.0000       0.0764       0.0007      -0.0356       6.7102      98.5788     399.5226      81.5365      51.9014       0.2046       0.2312       0.2832       4.0563    2708.7419      21.6238     132.7500    4035.0000
 2482.4436     148.3900      89.4054     212.8186     156.4021      72.3375      13.8241     216.0000       0.0678      -0.0086      -0.0452       6.9665      98.6154     391.1496      81.0001      51.9014       0.1837       0.2081       0.2596       4.0197    2724.6404      26.5068     131.3125    3979.0000
 2482.5960     122.5902     108.9329     287.2308     181.8810     105.5870       9.4709     216.0000       0.0672      -0.0092      -0.0459       6.9730      97.5429     387.8004      83.0622      51.9014       0.1759       0.1994       0.2508       4.0334    2725.6553      29.7299     133.1875    3984.0000
 2482.7484     145.8930     170.1989     357.8882     391.7778     153.4776       6.5156     216.0000       0.0734      -0.0025      -0.0389       6.8176      88.0513     388.3586      72.8028      51.9014       0.1808       0.2049       0.2563       4.0345    2714.1985      25.7766     131.5625    3997.0000
 2482.9008     115.4451     177.4667     526.2460     415.8639     148.1850       6.7483     216.0000       0.0926       0.0183      -0.0174       6.8210      83.9469     378.8692      58.9514      51.9014       0.1858       0.2108       0.2622       4.0334    2678.7742      21.7553     131.5625    3979.0000
 2483.0532     117.8598     108.6722     265.7926     236.6608      88.9237      11.2456     216.0000       0.0965       0.0225      -0.0130       7.0060      83.5487     378.8692      59.7162      51.9014       0.2176       0.2466       0.2980       4.0484    2671.5212      20.3925     131.5625    3990.0000
 2483.2056     145.5182      99.2504     172.6837     176.7444      76.0797      13.1441     216.0000       0.0929       0.0187      -0.0170       6.9664      88.0234     379.9856      70.8609      51.9014       0.2227       0.2518       0.3034       4.0748    2678.0908      20.6978     131.5625    4041.0000
 2483.3580     133.5920     119.6974     258.6995     285.8746      85.2886      11.7249     216.0000       0.0824       0.0073      -0.0288       6.8509      88.5811     385.5676      76.3412      51.9014       0.1990       0.2255       0.2770       4.0678    2697.5691      21.5884     131.5625    4028.0000
 2483.5104     153.9641     137.4199     352.3388     362.2028     114.5489       8.7299     216.0000       0.0807       0.0055      -0.0307       6.8159      86.9492     377.1946      64.2037      51.9014       0.1852       0.2095       0.2613       4.0062    2700.6487      22.9748     131.5625    4068.0000
 2483.6628     165.0564     129.4266     444.1890     450.3154     149.7318       6.6786     216.0000       0.0866       0.0118      -0.0241       6.9952      87.7628     367.1470      49.7956      51.9014       0.1755       0.1995       0.2505       3.9502    2689.8008      22.6878     130.3125    4043.0000
 2483.8152     167.5721     119.3063     473.8538     466.7503     203.8495       4.9056     216.0000       0.0954       0.0213      -0.0143       7.0459      89.2207     365.4724      45.1696      51.9014       0.2023       0.2291       0.2807       3.9539    2673.5891      23.2710     131.0625    3969.0000
 2483.9676     158.0158     122.6160     442.6141     412.1649     261.3105       3.8269     216.0000       0.0988       0.0251      -0.0104       6.9488      90.4928     385.5676      49.7465      51.9014       0.2035       0.2301       0.2820       4.0002    2667.1567      23.0313     130.6250    3995.0000
 2484.1200     201.4234     110.4610     383.7411     419.3839     271.0122       3.6899     216.0000       0.0976       0.0237      -0.0118       7.0322      87.1845     376.6364      57.3981      51.9014       0.1781       0.2015       0.2531       4.0483    2669.4258      26.8585     131.5625    3992.0000
 2484.2724     188.5802     143.3835     328.1016     364.2482     236.3392       4.2312     216.0000       0.0925       0.0182      -0.0175       7.0243      89.3808     375.5200      69.6320      51.9014       0.1830       0.2068       0.2586       4.0966    2678.9180      26.5072     129.2500    3995.0000
 2484.4248     115.7915     115.4219     231.3344     272.2767     171.9690       5.8150     216.0000       0.0875       0.0128      -0.0231       7.0199      87.1878     392.8242      95.3803      51.9014       0.1551       0.1761       0.2269       4.1912    2688.0535      25.0325     131.5625    3967.0000
 2484.5772     147.8714      98.6089     176.2536     194.9351     134.8197       7.4173     216.0000       0.0862       0.0114      -0.0245       7.0259      89.8859     400.3599     111.8567      51.9014       0.1822       0.2058       0.2577       4.2760    2690.4971      22.4783     127.1250    4040.0000
 2484.7296     209.0200     124.3359     264.3512     274.9673     159.1770       6.2823     216.0000       0.0743      -0.0015      -0.0379       7.1188      88.5215     391.1496     127.1927      51.9014       0.1721       0.1947       0.2463       4.2920    2712.5977      22.8932     131.5625    4033.0000
 2484.8820     211.1299     270.5930     323.0196     294.5344     149.0725       6.7081     216.0000       0.0771       0.0015      -0.0348       7.0363      88.2243     372.7290     112.6323      51.9014       0.1653       0.1868       0.2383       4.2308    2707.4041      23.1528     126.4375    4041.0000
 2485.0344     143.3529     205.0398     401.6744     293.1444     142.3549       7.0247     216.0000       0.0773       0.0018      -0.0345       7.1212      85.7701     368.2634      98.5708      51.9014       0.1856       0.2099       0.2617       4.1769    2706.9258      24.6387     130.5625    4037.0000
 2485.1868      93.7186     158.5292     197.2738     185.0499     106.0408       9.4303     216.0000       0.0886       0.0140      -0.0219       7.1678      87.7436     374.4036      79.8218      51.9014       0.2034       0.2300       0.2818       4.1896    2686.1150      23.6030     131.3750    4049.0000
 2485.3392      93.5181      75.6859     116.4346      97.0413      75.2018      13.2976     216.0000       0.0888       0.0142      -0.0216       6.8701      91.6009     385.8467      78.6920      51.9014       0.1788       0.2032       0.2543       4.2463    2685.7188      20.4624     131.5625    4045.0000
 2485.4916     135.7242     116.5492     212.2658     168.0621     105.7518       9.4561     216.0000       0.0910       0.0166      -0.0192       6.9799      88.9702     387.2422      88.9277      51.9014       0.1926       0.2183       0.2698       4.2954    2681.6545      21.4939     131.0000    4013.0000
 2485.6440     112.7263     114.8635     215.2925     181.9973     123.5845       8.0916     216.0000       0.0965       0.0226      -0.0130       6.8980      87.5491     374.4036     104.4567      51.9014       0.1995       0.2259       0.2775       4.3206    2671.3872      20.7451     130.4375    4023.0000
 2485.7964      90.2115      80.6707     189.1031     199.5983     135.5175       7.3791     216.0000       0.1019       0.0284      -0.0069       7.0408      90.7908     374.9618     113.7276      51.9014       0.2505       0.2831       0.3341       4.3141    2661.4268      20.9762     129.5625    4004.0000
 2485.9488      83.7410      51.7745     108.9975     114.3096      95.4693      10.4746     216.0000       0.1055       0.0323      -0.0029       6.9739      95.8168     377.1946     111.9099      51.9014       0.2201       0.2508       0.3011       4.3045    2654.8472      19.0258     127.9375    3975.0000
 2486.1012      88.6465      82.8934     200.5908     212.2370     143.3061       6.9781     216.0000       0.1020       0.0285      -0.0068       7.1487      92.7716     385.5676     104.0938      51.9014       0.2315       0.2635       0.3137       4.2756    2661.2622      18.9002     129.9375    3995.0000
 2486.2536      93.5765     150.2481     331.2943     340.5526     263.2614       3.7985     216.0000       0.0930       0.0187      -0.0170       7.2490      86.5355     381.1020      94.0237      51.9014       0.2182       0.2481       0.2989       4.2143    2678.0027      21.8240     126.9375    3964.0000
 2486.4060     111.2246     167.0501     685.4734     707.4998     523.5059       1.9102     216.0000       0.0782       0.0027      -0.0335       7.3196      86.1668     381.6602      95.5872      51.9014       0.2240       0.2548       0.3054       4.1551    2705.3345      23.8193     127.6250    3969.0000
 2486.5584     118.5823     184.4890     984.1774    1010.5771     799.3241       1.2511     216.0000       0.0759       0.0002      -0.0362       7.1637      90.4902     375.5200      91.1407      51.9014       0.2068       0.2350       0.2860       4.1353    2709.6643      25.3057     124.1875    3982.0000
 2486.7108     134.9347     177.1867    1084.9503    1113.6793     823.2834       1.2146     216.0000       0.0910       0.0166      -0.0192       7.1279      94.9056     378.8692      87.2836      51.9014       0.2537       0.2873       0.3377       4.1844    2681.6738      23.1388     126.1875    3989.0000
 2486.8632     144.5695     175.7062    1429.1516    1466.4960    1064.6582       0.9393     216.0000       0.1107       0.0378       0.0029       7.0796      94.6653     382.2184      77.0183      51.9014       0.2330       0.2643       0.3152       4.2320    2645.2778      22.4329     125.5625    4012.0000
 2487.0156     146.5864     175.5345    1664.9531    1737.1959    1118.9185       0.8937     216.0000       0.1175       0.0453       0.0106       7.0580      98.1230     386.4049      81.1071      51.9014       0.2015       0.2294       0.2802       4.2449    2632.5625      24.1133     125.5000    4014.0000
 2487.1680     137.8723     184.1327    1608.3237    1765.1254     914.0862       1.0940     216.0000       0.1060       0.0328      -0.0024       7.2692      96.7585     369.6589      93.3692      51.9014       0.1958       0.2216       0.2733       4.2330    2653.9021      29.7181     126.5000    4015.0000
 2487.3204     123.9752     199.1884    1446.5889    1646.6332     652.3594       1.5329     216.0000       0.0947       0.0206      -0.0150       7.1187      96.7668     366.5888     100.3652      51.9014       0.1733       0.1956       0.2475       4.2324    2674.7639      34.2409     126.5000    4019.0000
 2487.4728     110.9423     212.8487    1215.2460    1431.9878     441.7831       2.2636     216.0000       0.0826       0.0075      -0.0286       7.2477      93.6550     361.5650     101.1179      51.9014       0.1432       0.1618       0.2126       4.2568    2697.1536      36.3731     128.6875    3971.0000
 2487.6252      98.2402     209.8903    1041.5499    1217.5439     335.7385       2.9785     216.0000       0.0869       0.0122      -0.0238       7.2625      95.6285     355.4248      92.3207      51.9014       0.1290       0.1461       0.1961       4.2974    2689.1953      37.9809     130.6875    3944.0000
 2487.7776      95.9869     177.1904     651.3489     976.1017     192.7325       5.1885     216.0000       0.0959       0.0219      -0.0136       7.2258      93.6014     357.0994      87.7123      51.9014       0.1644       0.1858       0.2373       4.3795    2672.4990      36.1261     131.5625    3957.0000
 2487.9300      97.5866     151.1191     473.0575     499.0348     152.2439       6.5684     216.0000       0.1028       0.0293      -0.0060       7.1593      93.8045     350.4009      94.9423      51.9014       0.1804       0.2045       0.2559       4.5058    2659.8984      37.4757     131.5625    3956.0000
 2488.0824     119.8680     167.6252     649.2215     635.4959     265.4248       3.7675     216.0000       0.1052       0.0319      -0.0033       7.2656      92.2378     359.3322     124.9487      51.9014       0.1645       0.1871       0.2379       4.6862    2655.4299      38.9277     131.5625    4029.0000
 2488.2348     124.5131     178.8360     819.0875     695.3893     312.4143       3.2009     216.0000       0.1025       0.0290      -0.0063       7.4755      93.7042     350.4009     163.7402      51.9014       0.2024       0.2290       0.2807       4.8374    2660.4246      41.3648     131.5625    4037.0000
 2488.3872     116.0147     147.2687     578.6602     476.3035     305.4359       3.2740     216.0000       0.0949       0.0208      -0.0148       7.3739      91.8771     361.0068     193.5499      51.9014       0.2149       0.2416       0.2943       4.8768    2674.4944      29.6246     133.8125    4013.0000
 2488.5396      86.7923      99.2852     283.1960     189.9987     201.9165       4.9525     216.0000       0.0785       0.0031      -0.0332       7.2997      92.0309     358.4949     192.4987      51.9014       0.1761       0.1997       0.2510       4.7553    2704.7532      23.2515     133.5625    4054.0000
 2488.6920      95.8590      98.1841     286.9853     191.8599     191.6742       5.2172     216.0000       0.0620      -0.0148      -0.0517       7.1715      95.8316     351.7965     171.3510      51.9014       0.1964       0.2221       0.2739       4.5329    2735.3513      23.9532     133.5000    4025.0000
 2488.8444     104.9885     118.1749     399.7056     296.8837     243.9016       4.1000     216.0000       0.0662      -0.0103      -0.0470       6.9676      96.9063     357.0994     136.4760      51.9014       0.1952       0.2214       0.2728       4.3484    2727.5537      30.5486     136.3125    4022.0000
 2488.9968     129.9227     161.3283     492.1495     316.1797     214.4431       4.6632     216.0000       0.0712      -0.0048      -0.0413       6.8390      95.3287     358.7740     117.7888      51.9014       0.1890       0.2138       0.2656       4.2811    2718.1887      29.5556     137.6875    4015.0000
 2489.1492     169.6369     242.4572    1486.3275     222.8031     178.3093       5.6082     216.0000       0.0768       0.0012      -0.0351       6.9187      88.4262     359.3322     113.6415      51.9014       0.1672       0.1895       0.2408       4.3146    2707.9924      27.5226     137.8125    4033.0000
 2489.3016     204.8432     358.0194    1943.8438     485.1696     308.9237       3.2370     216.0000       0.0659      -0.0106      -0.0473       7.3691      87.1276     359.3322     124.4175      51.9014       0.1805       0.2044       0.2559       4.3631    2728.0625      26.3905     141.3125    4024.0000
 2489.4540     214.6194     398.1886    1823.8844     801.8416     234.9927       4.2555     216.0000       0.0613      -0.0156      -0.0525       7.4629      88.9000     363.7978     127.8284      51.9014       0.1598       0.1806       0.2320       4.3715    2736.5945      23.5389     138.9375    4004.0000
 2489.6064     223.0602     301.8056     967.0464    1208.2830     187.5045       5.3332     216.0000       0.0644      -0.0122      -0.0490       7.7553      89.1543     366.5888     123.0388      51.9014       0.1722       0.1945       0.2462       4.3580    2730.8364      21.5995     140.7500    3990.0000
 2489.7588     200.0161     215.5754     569.4327     345.0010     185.7332       5.3841     216.0000       0.0796       0.0043      -0.0320       7.3092      86.9952     353.7502     111.9041      51.9014       0.1738       0.1960       0.2479       4.3386    2702.7275      21.8857     141.2500    3996.0000
 2489.9112     184.8150     193.8433     519.2007     473.7657     267.8005       3.7341     216.0000       0.0877       0.0130      -0.0229       7.4087      88.4250     352.6338     114.8999      51.9014       0.1679       0.1903       0.2416       4.3426    2687.7571      27.5328     141.3125    3974.0000
 2490.0636     191.8742     155.6316     413.3280     351.7751     202.5728       4.9365     216.0000       0.0872       0.0125      -0.0234       7.2974      92.4929     353.7502     129.7281      51.9014       0.1699       0.1923       0.2438       4.3722    2688.6521      24.1528     141.3125    3961.0000
 2490.2160     141.0359     154.6497     275.8184     225.3540     160.3458       6.2365     216.0000       0.0830       0.0079      -0.0282       7.1398      98.7331     350.9591     143.2276      51.9014       0.1989       0.2247       0.2767       4.4081    2696.4976      20.6384     142.3125    4014.0000
 2490.3684     111.2743      87.8443     159.6029     164.6674     143.5989       6.9638     216.0000       0.0790       0.0036      -0.0326       7.2978     103.5968     370.4962     136.8651      51.9014       0.2116       0.2392       0.2911       4.3856    2703.8696      17.3448     144.0000    4017.0000
 2490.5208     117.0630      74.8128     118.7195      90.7702      76.1116      13.1386     216.0000       0.0835       0.0084      -0.0276       7.1993      98.9917     360.4486     115.8788      51.9014       0.1853       0.2102       0.2616       4.3005    2695.5537      19.3667     142.0625    4029.0000
 2490.6732      93.4339     112.6952     208.1681     149.7939      92.3432      10.8292     216.0000       0.0856       0.0107      -0.0253       7.2748      92.9549     362.9605     105.9775      51.9014       0.1530       0.1739       0.2245       4.2170    2691.7295      21.2134     149.3125    4076.0000
 2490.8256      98.3927     125.7672     248.8854     134.8408      81.7020      12.2396     216.0000       0.0935       0.0193      -0.0163       7.3308      82.4483     352.0755     108.8855      51.9014       0.1684       0.1908       0.2422       4.2038    2676.9729      22.0484     141.3125    4116.0000
 2490.9780      90.7136     188.1405     300.4117     156.2270     185.6910       5.3853     216.0000       0.0925       0.0182      -0.0175       7.3973      85.5733     354.3084     124.0680      51.9014       0.2147       0.2419       0.2942       4.2910    2678.8494      21.0800     148.1875    4121.0000
 2491.1304      74.2183     110.2283     173.6771     146.6048      85.6316      11.6779     216.0000       0.1002       0.0266      -0.0088       7.2213      89.7830     357.9367     131.2442      51.9014       0.2008       0.2278       0.2792       4.4669    2664.5955      19.5860     141.3125    4083.0000
 2491.2828      90.3290      79.4630     125.8622     147.7547      69.8603      14.3143     216.0000       0.1048       0.0316      -0.0037       7.3160      99.3713     277.5558     146.9774      51.9014       0.2488       0.2831       0.3328       4.7044    2656.0415      18.6499     143.5625    4051.0000
 2491.4352      99.3208      45.5488      82.0572      98.3687      43.7526      22.8558     216.0000       0.1111       0.0384       0.0034       7.5259     103.2921     304.0703     168.2575      51.9014       0.2673       0.3046       0.3531       4.9299    2644.3728      19.0574     144.5000    4064.0000
 2491.5876     103.4153      76.9275     155.0124     130.5813      44.1975      22.6257     216.0000       0.0995       0.0258      -0.0096       7.0545     100.7095     325.8401     206.2998      51.9014       0.2286       0.2607       0.3106       5.0674    2665.8748      19.7894     141.3125    4023.0000
 2491.7400     215.8381     124.7037     195.2197     244.7167     147.3374       6.7871     216.0000       0.0937       0.0195      -0.0162       7.1071      92.6952     353.1920     225.3449      51.9014       0.2180       0.2473       0.2984       5.0961    2676.6843      20.9186     145.3125    4049.0000
 2491.8924      96.5849     145.3790     411.6260     405.6300     228.3332       4.3796     216.0000       0.0951       0.0210      -0.0146       7.4364      87.1503     337.5623     217.3278      51.9014       0.1771       0.2011       0.2523       5.0091    2674.1328      18.8372     137.5000    4016.0000
 2492.0448     106.2908     118.5606     195.4068     287.5832     342.6882       2.9181     216.0000       0.0994       0.0256      -0.0098       7.3503      89.8702     350.4009     191.2904      51.9014       0.2053       0.2328       0.2842       4.8467    2666.1406      17.2888     144.5000    4001.0000
 2492.1972      80.4665      86.8848     147.8745     159.2633     106.7888       9.3643     216.0000       0.0965       0.0226      -0.0130       7.2381      91.2913     358.2158     163.9574      51.9014       0.2058       0.2327       0.2845       4.6513    2671.4092      16.5710     141.3125    4019.0000
 2492.3496     108.9818      95.6100     168.5029     180.0083      94.1756      10.6185     216.0000       0.0946       0.0205      -0.0151       7.4608      96.2261     352.0755     145.8273      51.9014       0.2002       0.2273       0.2785       4.4949    2674.9844      16.9517     144.8125    4077.0000
 2492.5020     163.8661     133.9301     213.8552     220.6007     178.0475       5.6165     216.0000       0.0990       0.0253      -0.0102       7.3523      93.8555     357.6576     137.3298      51.9014       0.2084       0.2359       0.2875       4.4307    2666.7717      18.6873     143.1250    4009.0000
 2492.6544     134.6155     142.3358     226.7637     221.2252     177.3970       5.6371     216.0000       0.1085       0.0355       0.0004       7.2830      97.1038     348.7264     134.8729      51.9014       0.2102       0.2386       0.2898       4.4238    2649.2949      16.7242     145.5000    4031.0000
 2492.8068     100.6955     113.2125     212.3488     186.3718     164.1220       6.0930     216.0000       0.1097       0.0369       0.0018       7.3980      93.9818     343.1443     136.7409      51.9014       0.2162       0.2454       0.2965       4.4344    2646.9734      15.6677     142.5000    4023.0000
 2492.9592      70.6444      81.8235     130.8390     127.2679     147.8389       6.7641     216.0000       0.1103       0.0374       0.0024       7.3458      95.8090     349.8428     126.1303      51.9014       0.2192       0.2492       0.2999       4.4383    2646.0229      14.3263     145.4375    4035.0000
 2493.1116      70.8103      93.0978     132.9145     121.1410     100.9822       9.9027     216.0000       0.1077       0.0346      -0.0005       7.1323      93.0234     355.9829     114.0358      51.9014       0.2369       0.2701       0.3198       4.4733    2650.8271      15.5288     143.0000    4084.0000
 2493.2640      87.2624     141.2516     230.8673     156.3494     134.7055       7.4236     216.0000       0.1084       0.0354       0.0003       7.3202      91.5663     355.4248     104.5704      51.9014       0.2398       0.2725       0.3228       4.5916    2649.4382      17.5405     141.3125    4014.0000
 2493.4164      80.6700     246.7785     294.3894     337.8653     215.1821       4.6472     216.0000       0.1258       0.0543       0.0199       7.4383      88.3728     352.0755     103.6584      51.9014       0.2380       0.2702       0.3207       4.8160    2617.2056      17.6334     144.1875    4014.0000
 2493.5688      97.0006     197.9562     272.2794     298.5435     208.3440       4.7998     216.0000       0.1780       0.1107       0.0784       7.4048      89.9403     355.4248     111.1405      51.9014       0.1991       0.2262       0.2774       5.1840    2520.6616      13.3569     139.1875    4020.0000
 2493.7212     101.7374     135.4900     289.7399     279.2742     209.0935       4.7825     216.0000       0.2575       0.1967       0.1675       7.4717      91.2087     342.0280     121.9380      51.9014       0.2402       0.2724       0.3231       5.6276    2373.6667       6.4057     144.1875    3984.0000
 2493.8736      53.0385      52.3571      91.3094     161.1393      90.2741      11.0774     216.0000       0.2879       0.2296       0.2016       7.3193      89.9883     344.5399     157.2421      51.9014       0.2042       0.2323       0.2831       5.9124    2317.3845       4.5786     141.3125    4016.0000
 2494.0260      70.9526      64.9782     119.7874     170.3636      99.1139      10.0894     216.0000       0.2403       0.1781       0.1483       7.4940      88.8276     337.5623     201.1116      51.9014       0.2467       0.2789       0.3299       5.8785    2405.3777       4.6358     144.3750    4012.0000
 2494.1784     124.7811     124.1271     260.3001     347.5667     256.9349       3.8920     216.0000       0.1554       0.0862       0.0530       7.4148      84.0780     324.7237     219.4221      51.9014       0.1991       0.2262       0.2774       5.5363    2562.5969       7.5701     141.3125    4053.0000
 2494.3308      95.5680     139.5593     286.5282     386.3455     300.4666       3.3282     216.0000       0.1143       0.0418       0.0070       7.3930      87.5358     329.1893     192.0760      51.9014       0.1776       0.2021       0.2530       5.1478    2638.4924      13.8161     145.5625    4078.0000
 2494.4832     106.8151     140.3311     344.4866     363.6528     321.6969       3.1085     216.0000       0.1157       0.0433       0.0085       7.3555      89.4475     339.2369     151.3345      51.9014       0.1868       0.2114       0.2631       4.8677    2635.9441      16.3256     141.8125    4071.0000
 2494.6356     154.2129     159.8235     358.9691     317.2442     305.6946       3.2712     216.0000       0.1171       0.0448       0.0101       7.1885     100.1519     329.4684     132.6582      51.9014       0.2147       0.2428       0.2945       4.7142    2633.3154      16.4671     148.0000    4070.0000
 2494.7880     137.9025     167.3160     272.6302     205.0061     206.4719       4.8433     216.0000       0.1098       0.0369       0.0018       7.2514     102.0450     333.3759     119.9055      51.9014       0.2262       0.2551       0.3071       4.5901    2646.9573      19.4510     145.8125    4079.0000
 2494.9404     144.8211     160.1620     228.5018     151.6119     150.4147       6.6483     216.0000       0.1088       0.0358       0.0008       7.3572      97.8959     329.7475     101.5048      51.9014       0.1677       0.1905       0.2415       4.4690    2648.7263      24.8311     144.5000    4020.0000
 2495.0928      93.0162     183.3425     177.9887     122.0021     109.5005       9.1324     216.0000       0.1144       0.0419       0.0071       7.4708      97.0823     331.9803      91.2716      51.9014       0.1505       0.1706       0.2214       4.3962    2638.2817      26.1519     142.3750    4017.0000
 2495.2452      80.4898     175.1446     197.7505     147.8185     136.8026       7.3098     216.0000       0.1275       0.0560       0.0217       7.5188     100.0026     320.8163      96.0186      51.9014       0.1831       0.2074       0.2589       4.4288    2614.1926      21.5281     141.3125    4016.0000
 2495.3976      57.5087     157.2880     150.7139     102.0977      81.0637      12.3360     216.0000       0.1285       0.0572       0.0229       7.5250      99.9494     325.8401     115.8958      51.9014       0.2312       0.2613       0.3128       4.5332    2612.2034      15.4289     142.6875    3976.0000
 2495.5500      65.8400     113.0016     122.5049      81.4658      70.1096      14.2634     216.0000       0.1314       0.0603       0.0262       7.5302      92.4238     325.8401     127.5470      51.9014       0.2192       0.2494       0.3000       4.6414    2606.8320      15.0550     141.2500    4020.0000
 2495.7024     133.4756     185.9708     222.7551     163.6872     106.8673       9.3574     216.0000       0.1330       0.0620       0.0279       7.2711      88.1110     329.7475     140.2812      51.9014       0.2107       0.2385       0.2901       4.7539    2603.9736      14.3542     141.3125    4024.0000
 2495.8548     115.1118     126.6743     199.4268     170.1961     108.1083       9.2500     216.0000       0.1424       0.0722       0.0384       7.3459      91.6219     330.5849     146.4062      51.9014       0.2034       0.2302       0.2819       4.8620    2586.5623      14.5994     141.3125    4033.0000
 2496.0072      78.1885      95.2395     157.9318     157.2844      98.9479      10.1063     216.0000       0.1517       0.0822       0.0488       7.2355      92.3823     320.8163     153.3454      51.9014       0.1713       0.1946       0.2456       4.9577    2569.4365      14.7412     141.3125    4095.0000
 2496.1596      69.7043      62.4442     137.3681     152.0929      87.3432      11.4491     216.0000       0.1460       0.0761       0.0425       7.4415      93.2438     327.5147     163.5399      51.9014       0.2040       0.2310       0.2826       4.9950    2579.9360      14.0054     141.3125    4017.0000
 2496.3120      73.1848      57.2247     127.6481     145.1048      91.6373      10.9126     216.0000       0.1380       0.0674       0.0335       7.5681      89.5827     326.3983     167.6204      51.9014       0.2117       0.2401       0.2914       4.9745    2594.6628      15.0324     141.3125    4043.0000
 2496.4644      62.6956      75.1185     129.5977     137.8762     100.7154       9.9290     216.0000       0.1348       0.0639       0.0299       7.6832      89.2291     331.4221     166.0614      51.9014       0.1963       0.2227       0.2741       4.9255    2600.7087      14.3261     140.0625    4023.0000
 2496.6168      64.7376      87.4763     163.5072     167.7899     117.4214       8.5163     216.0000       0.1352       0.0644       0.0304       7.6279      87.4393     337.0042     159.0388      51.9014       0.1887       0.2138       0.2654       4.8604    2599.8142      11.1113     138.2500    4047.0000
 2496.7692      54.6486     151.6002     212.8711     280.3708     174.7962       5.7209     216.0000       0.1394       0.0689       0.0351       7.5293      86.3714     310.4896     149.7180      51.9014       0.2243       0.2541       0.3054       4.7791    2592.1440      11.4012     139.7500    4060.0000
 2496.9216      68.6209     106.7659     300.7396     199.1356     180.1456       5.5511     216.0000       0.1395       0.0691       0.0352       7.4893      89.7701     320.2581     143.6236      51.9014       0.2196       0.2493       0.3003       4.7064    2591.8601      10.6766     140.8125    4033.0000
 2497.0740      54.2803      71.0995     127.0066     136.7117     123.2352       8.1146     216.0000       0.1446       0.0745       0.0409       7.2829      88.1638     322.4909     129.7095      51.9014       0.2131       0.2423       0.2931       4.6623    2582.5374      12.3680     141.3125    4011.0000
 2497.2264      42.1345      47.6825      74.0405      84.8910      53.5386      18.6781     216.0000       0.1376       0.0670       0.0331       7.4112      86.7910     321.3745     126.8785      51.9014       0.1854       0.2102       0.2616       4.6692    2595.3479      10.9518     140.3125    3998.0000
 2497.3788      62.1578      51.3798      82.1289      95.3180      80.3530      12.4451     216.0000       0.1376       0.0669       0.0330       7.2930      84.7609     323.0491     128.7570      51.9014       0.1838       0.2081       0.2597       4.7418    2595.5212      12.8606     141.3125    3997.0000
 2497.5312      53.8286      60.2185     103.5492     126.2401     108.5882       9.2091     216.0000       0.1408       0.0705       0.0367       7.4529      84.1080     318.8626     139.3983      51.9014       0.1990       0.2246       0.2767       4.8440    2589.4807      13.6230     139.6875    4041.0000
 2497.6836      53.7314      58.6869     103.2414     129.8630     116.4571       8.5869     216.0000       0.1503       0.0807       0.0473       7.8805      84.2143     320.2581     161.0231      51.9014       0.1732       0.1963       0.2477       4.9866    2571.9988      12.7592     141.3125    4072.0000
 2497.8360      51.8806      69.1693     115.3963     153.9016     132.2298       7.5626     216.0000       0.1600       0.0912       0.0582       7.6921      88.9475     299.6047     175.0064      51.9014       0.1825       0.2084       0.2589       5.1297    2554.0356      14.0661     141.3125    4145.0000
 2497.9884      48.0218      80.0637     127.6120     165.3104     135.3175       7.3900     216.0000       0.1703       0.1024       0.0697       7.5171      90.4139     328.0729     181.7417      51.9014       0.2497       0.2829       0.3334       5.2680    2534.9316      11.7046     141.3125    4211.0000
 2498.1408      58.2971      90.8559     138.7413     187.6611     122.7934       8.1438     216.0000       0.1850       0.1183       0.0863       7.6033      93.9137     330.3058     177.9084      51.9014       0.2504       0.2837       0.3342       5.3921    2507.6814      10.9286     137.8125    4153.0000
 2498.2932      86.1121     152.1889     179.7186     225.6614     215.5902       4.6384     216.0000       0.1843       0.1175       0.0854       7.5476      86.2569     320.8163     188.7896      51.9014       0.2004       0.2276       0.2788       5.4849    2509.0916       8.4976     138.6875    4083.0000
 2498.4456      80.1525     131.0341     318.4658     393.3116     330.8246       3.0227     216.0000       0.1874       0.1209       0.0889       7.5578      84.9822     313.0015     202.2011      51.9014       0.2433       0.2762       0.3266       5.5674    2503.2407       9.1089     139.0625    4093.0000
 2498.5980      61.1989      87.8242     150.8013     187.1516     179.5057       5.5709     216.0000       0.2084       0.1436       0.1125       7.3070      83.9671     324.7237     199.3666      51.9014       0.2370       0.2694       0.3197       5.6370    2464.4570       7.6392     137.1250    4040.0000
 2498.7504      52.3555      57.9603     105.2146     137.5016     150.1243       6.6611     216.0000       0.2142       0.1499       0.1189       7.5301      87.5559     331.4221     198.0338      51.9014       0.2223       0.2538       0.3037       5.6279    2453.7441       6.7464     137.8125    4072.0000
 2498.9028      60.2467      62.2964      60.2768     100.2495      94.0370      10.6341     216.0000       0.1994       0.1339       0.1024       7.4272      88.0171     320.8163     192.3134      51.9014       0.2479       0.2809       0.3315       5.5093    2481.0952       7.1822     135.5625    4053.0000
 2499.0552      42.6098      45.9163      82.9424     110.7814     108.2207       9.2404     216.0000       0.1635       0.0950       0.0621       7.7636      93.7106     325.8401     181.6363      51.9014       0.2411       0.2747       0.3244       5.2869    2547.4971       7.4153     138.7500    4041.0000
 2499.2076      42.6043      60.5338     116.6551     152.2631     130.9383       7.6372     216.0000       0.1512       0.0817       0.0483       7.8250      98.7297     299.0465     160.3241      51.9014       0.2263       0.2575       0.3079       5.1344    2570.2258      10.5133     131.8125    4049.0000
 2499.3600      44.0040      92.2199     128.7188     198.3673     117.9709       8.4767     216.0000       0.1679       0.0998       0.0671       7.6284      95.0203     305.1867     149.1685      51.9014       0.1955       0.2228       0.2735       5.1506    2539.3083      12.4871     135.9375    4061.0000
 2499.5124      39.5587      85.0972     142.3063     164.6828     142.0791       7.0383     216.0000       0.2101       0.1455       0.1144       7.7501      91.2106     304.9076     154.6195      51.9014       0.2162       0.2456       0.2966       5.3687    2461.2764       9.6044     134.6875    4032.0000
 2499.6648      36.1802      67.0754     104.4404     155.5278      93.7924      10.6618     216.0000       0.2217       0.1580       0.1273       7.5804      80.6998     300.4420     174.6655      51.9014       0.2776       0.3138       0.3636       5.5751    2439.9023       6.8020     138.8750    4040.0000
 2499.8172      40.1924      77.8376      98.9565     144.2133      70.2000      14.2450     216.0000       0.2179       0.1539       0.1231       7.5440      82.7664     298.4883     181.5860      51.9014       0.2419       0.2763       0.3255       5.6982    2446.9131       6.3845     132.6875    4067.0000
 2499.9696      32.2890      65.5372     107.1688     144.5611      75.2031      13.2973     216.0000       0.2043       0.1392       0.1079       7.5356      85.7550     306.3031     185.9117      51.9014       0.2373       0.2716       0.3205       5.7262    2471.9880       8.3688     131.5625    4087.0000
 2500.1220      34.9975      67.5607     127.6262     130.2910      96.1619      10.3991     216.0000       0.2336       0.1709       0.1407       7.5490      97.0778     309.0941     179.7500      51.9014       0.2752       0.3128       0.3615       5.8121    2417.8140       6.8467     131.5625    4068.0000
 2500.2744      35.4942      80.3913     127.0021     188.3852     108.3177       9.2321     216.0000       0.2948       0.2371       0.2094       7.6674      99.9410     306.5822     154.3865      51.9014       0.2494       0.2837       0.3334       5.9286    2304.5417       4.7103     131.5625    4081.0000
 2500.4268      45.5546      50.8142     173.9406     213.2950     131.4282       7.6087     216.0000       0.3184       0.2626       0.2358       7.6732      95.1219     306.8613     131.6917      51.9014       0.2341       0.2644       0.3160       5.8892    2260.8975       3.4057     131.6250    4105.0000
 2500.5792      36.5410      28.3735      80.5851     132.2938     133.1072       7.5127     216.0000       0.2828       0.2241       0.1959       7.9126      84.1590     283.9751     116.6999      51.9014       0.2674       0.3000       0.3519       5.6460    2326.7397       3.8894     131.5625    4075.0000
 2500.7316      29.5997      33.0799      84.8792     145.6443     118.4873       8.4397     216.0000       0.2206       0.1568       0.1262       7.7695      75.5411     296.8137     123.8880      51.9014       0.1669       0.1883       0.2400       5.3196    2441.8042       6.3949     131.6875    4099.0000
 2500.8840      39.0821      45.1523      95.4946     163.1877     162.7780       6.1433     216.0000       0.1849       0.1181       0.0861       7.7794      76.5029     259.4142     153.2223      51.9014       0.0751       0.0848       0.1311       5.1996    2508.0166      23.3392     131.5625    4103.0000
 2501.0364      40.7666      44.7510     155.6034     167.0050     157.1960       6.3615     216.0000       0.1922       0.1261       0.0943       8.0948      85.0296     252.9949     176.6341      51.9014       0.1358       0.1538       0.2041       5.2329    2494.4243      11.1379     134.5000    4056.0000
 2501.1888      22.6331      30.1286      44.6333     132.6411     124.4708       8.0340     216.0000       0.1673       0.0991       0.0663       8.1468      96.0883     273.3693     215.3542      51.9014       0.2481       0.2783       0.3308       5.2585    2540.5288       8.9100     131.7500    4108.0000
 2501.3412      28.1067      53.7701      78.3738      80.3981      93.6978      10.6726     216.0000       0.1562       0.0871       0.0539       8.2311     100.5546     294.5809     198.0863      51.9014       0.2134       0.2415       0.2931       5.1227    2561.0671       8.3553     135.7500    4149.0000
 2501.4936      37.7967      81.2281     169.9210     219.5634     197.6995       5.0582     216.0000       0.1341       0.0632       0.0291       7.9774     101.3667     248.8084     177.3934      51.9014       0.2222       0.2512       0.3029       4.9265    2601.9763      12.2950     131.5625    4124.0000
 2501.6460      42.5945      93.8195      93.8514      89.8272      96.7729      10.3335     216.0000       0.1326       0.0616       0.0274       7.5512     100.5531     263.8798     149.9038      51.9014       0.1874       0.2127       0.2641       4.8068    2604.7336      13.1550     135.5625    4084.0000
 2501.7984      49.7146     135.4230     144.2992     103.2630     101.1273       9.8885     216.0000       0.1315       0.0604       0.0263       7.4086     102.6219     279.2304     157.5859      51.9014       0.1763       0.2004       0.2514       4.8524    2606.6765      15.0981     132.1250    4103.0000
 2501.9508      47.4199      99.5451     139.9214     127.5049      94.1190      10.6248     216.0000       0.1679       0.0998       0.0670       7.4623      99.0250     285.6496     166.7752      51.9014       0.1897       0.2153       0.2666       5.0910    2539.3872      14.4877     135.7500    4051.0000
 2502.1032      49.6209     105.3047     158.4709     111.7356     105.6786       9.4627     216.0000       0.2298       0.1668       0.1365       7.8566      98.6182     289.2780     167.9676      51.9014       0.2273       0.2566       0.3084       5.4208    2424.8420       8.8758     135.3750    4067.0000
 2502.2556      47.7083     165.9998     150.3099     125.9842     104.3589       9.5823     216.0000       0.2442       0.1823       0.1526       7.9915      96.9555     293.4644     176.5106      51.9014       0.2083       0.2359       0.2875       5.6348    2398.2761       7.3315     138.3750    4054.0000
 2502.4080      66.4492     161.5662     189.7466     131.7390     179.7218       5.5642     216.0000       0.2200       0.1562       0.1255       7.8397      97.5071     293.4644     173.8386      51.9014       0.2094       0.2369       0.2886       5.6175    2442.9497       8.1231     140.2500    4072.0000
 2502.5604      81.4197     169.6607     200.0890     251.9617     199.8940       5.0027     216.0000       0.1742       0.1066       0.0741       7.9267      98.0652     291.7899     187.4318      51.9014       0.1714       0.1942       0.2456       5.5104    2527.7866      13.6784     137.6875    4113.0000
 2502.7128      60.3609     234.8881     191.4486     235.4239     212.4330       4.7074     216.0000       0.1637       0.0952       0.0623       7.8785      99.9600     299.6047     205.5163      51.9014       0.1560       0.1764       0.2276       5.5143    2547.1704      16.3895     140.4375    4048.0000
 2502.8652      67.6124     119.6549     180.2792     210.9827     221.8386       4.5078     216.0000       0.1706       0.1027       0.0701       7.8609     102.6627     270.0200     233.2044      51.9014       0.1767       0.1996       0.2514       5.6595    2534.3767      12.8040     141.3125    4100.0000
 2503.0176      69.6719      75.7136     152.1425     178.3576     217.4728       4.5983     216.0000       0.1656       0.0973       0.0645       7.7102     100.8268     280.0677     251.9345      51.9014       0.1842       0.2079       0.2599       5.7566    2543.5703      10.1285     141.3125    4069.0000
 2503.1700      81.4386      62.7827     117.5522     144.3775     205.7679       4.8598     216.0000       0.1586       0.0898       0.0567       7.8902      93.4506     292.9063     249.2244      51.9014       0.1596       0.1809       0.2320       5.7576    2556.5046      10.9219     142.0000    4081.0000
 2503.3224      86.6186      78.5518      92.6118      95.0562     120.1547       8.3226     216.0000       0.1728       0.1051       0.0725       7.8341      92.4389     266.6708     233.4397      51.9014       0.1557       0.1763       0.2274       5.7644    2530.3457      11.9772     147.1250    4127.0000
 2503.4748      76.7713      87.8806     132.2218     129.6853     133.4813       7.4917     216.0000       0.1835       0.1167       0.0846       7.9816      91.4793     274.4857     240.7146      51.9014       0.1767       0.1995       0.2514       5.8327    2510.4617      11.3824     145.4375    4120.0000
 2503.6272     132.0710      98.2713     317.5216     208.7946     286.4703       3.4908     216.0000       0.1799       0.1127       0.0805       7.8634      95.6012     272.5320     256.4843      51.9014       0.1694       0.1912       0.2430       5.8607    2517.2156      11.3869     141.3125    4126.0000
 2503.7796      87.6381     115.8728     317.1283     285.1300     231.9561       4.3112     216.0000       0.1512       0.0817       0.0483       7.8273      94.7223     267.2290     264.0569      51.9014       0.1452       0.1650       0.2154       5.7376    2570.3269      12.8223     146.8750    4127.0000
 2503.9320      62.4960      82.3421     164.4127     163.0657     125.8982       7.9429     216.0000       0.1438       0.0737       0.0400       7.8203      97.5873     264.9962     238.4875      51.9014       0.1788       0.2021       0.2539       5.5419    2583.9583      16.9470     149.7500    4111.0000
 2504.0844      53.5744      55.3750     124.8611     139.2506      71.1176      14.0612     216.0000       0.1543       0.0850       0.0518       7.8224      94.0744     280.6259     214.1955      51.9014       0.1889       0.2132       0.2653       5.4205    2564.5991      15.9205     151.0625    4094.0000
 2504.2368      49.2948      44.9842     103.8937     117.0986      67.2236      14.8757     216.0000       0.1734       0.1057       0.0732       7.7346      90.4202     277.8349     209.0492      51.9014       0.1767       0.1999       0.2516       5.4163    2529.2544      15.5350     151.0625    4083.0000
 2504.3892      59.1072      56.9106     111.8991     118.2065      80.5002      12.4223     216.0000       0.1795       0.1124       0.0801       7.8823      86.7416     304.3494     212.5487      51.9014       0.1755       0.1986       0.2502       5.4534    2517.8438      12.5280     150.2500    4073.0000
 2504.5416      77.0590      62.4474     150.0377     161.9667     127.5523       7.8399     216.0000       0.1673       0.0991       0.0664       7.8135      89.3808     293.7436     217.8662      51.9014       0.1879       0.2125       0.2643       5.4514    2540.5010      12.3871     149.4375    4105.0000
 2504.6940      77.9295     129.0211     148.9099     226.4553     135.1537       7.3990     216.0000       0.1746       0.1070       0.0745       8.1149      94.0502     281.7422     211.5915      51.9014       0.1726       0.1953       0.2469       5.5035    2527.0442      12.1815     152.5000    4096.0000
 2504.8464      66.7226      77.3576     260.5896     415.6933     257.4643       3.8840     216.0000       0.2021       0.1367       0.1053       7.8497      95.0672     267.2290     207.2160      51.9014       0.1752       0.1986       0.2500       5.6473    2476.1846      10.1518     150.5000    4123.0000
 2504.9988      45.1546      66.4653     118.7244     222.7591     170.5808       5.8623     216.0000       0.2505       0.1892       0.1597       7.9052      97.1064     276.1603     197.7122      51.9014       0.1781       0.2020       0.2533       5.8573    2386.5459       6.8962     151.0625    4133.0000
 2505.1512      32.8921      47.7011      70.0109     123.6030      62.2421      16.0663     216.0000       0.2628       0.2024       0.1734       7.4754      96.9650     288.9989     204.0195      51.9014       0.1975       0.2235       0.2752       5.9902    2363.8811       6.6175     150.3750    4078.0000
 2505.3036      39.1169      52.0091      93.9547     119.9179      71.3209      14.0211     216.0000       0.2399       0.1777       0.1478       7.4961     101.2363     274.2066     217.3259      51.9014       0.2338       0.2640       0.3157       5.9710    2406.1543       6.4460     151.0625    4096.0000
 2505.4560      39.1490      57.4444      96.2283     117.6731      89.7041      11.1478     216.0000       0.2116       0.1471       0.1160       7.9340     102.0393     278.3931     222.2245      51.9014       0.2042       0.2315       0.2829       5.8653    2458.5371       7.3882     150.6250    4128.0000
 2505.6084      42.9388      52.9199      99.7956     118.2037      84.7226      11.8032     216.0000       0.1938       0.1278       0.0961       7.8214      99.4916     274.4857     218.6923      51.9014       0.2029       0.2305       0.2816       5.7497    2491.4685       6.7425     151.0625    4084.0000
 2505.7608      46.3354      60.0291      97.2006     113.5557      78.2027      12.7873     216.0000       0.2057       0.1406       0.1094       8.0174      96.1795     280.6259     196.8994      51.9014       0.2171       0.2457       0.2973       5.6975    2469.5398       7.0996     151.0625    4128.0000
 2505.9132      45.2793      62.4838      87.2390     119.3309      73.7021      13.5681     216.0000       0.2149       0.1506       0.1197       7.8647      89.9396     287.0452     187.6478      51.9014       0.2065       0.2338       0.2854       5.7134    2452.4717       7.2784     150.8125    4126.0000
 2506.0656      47.4836      79.9821     111.8242     145.6800      78.1478      12.7963     216.0000       0.2184       0.1544       0.1237       8.1291      89.2329     272.2528     180.7475      51.9014       0.1950       0.2211       0.2726       5.7615    2445.9189       8.4943     149.4375    4144.0000
 2506.2180      43.5892     111.9602     111.7839     165.9869     101.6564       9.8371     216.0000       0.2140       0.1496       0.1187       7.7297      88.2179     274.4857     187.2356      51.9014       0.1716       0.1947       0.2460       5.8344    2454.1174       8.0677     146.5000    4169.0000
 2506.3704      48.4429     184.7599     263.1321     367.2636      97.9654      10.2077     216.0000       0.2222       0.1585       0.1279       7.8499      91.5661     269.4618     202.8885      51.9014       0.1502       0.1705       0.2212       5.9965    2439.0183       7.8740     151.0625    4147.0000
 2506.5228      56.6868     235.6403     186.6246     530.3473     150.4826       6.6453     216.0000       0.2446       0.1827       0.1530       7.7415      94.3528     266.1126     226.1322      51.9014       0.1837       0.2081       0.2597       6.2119    2397.5051       6.5047     150.3750    4120.0000
 2506.6752      41.5734     130.9713      95.4573     188.8999     110.8919       9.0178     216.0000       0.2816       0.2228       0.1945       7.8439      98.8834     267.7872     229.3496      51.9014       0.2536       0.2854       0.3371       6.4381    2329.0298       4.7769     150.0625    4179.0000
 2506.8276      40.7374      78.1087      81.0683     164.4391     137.6766       7.2634     216.0000       0.2686       0.2087       0.1799       7.8100      92.4842     271.1364     237.3996      51.9014       0.2331       0.2619       0.3144       6.4850    2353.1741       4.4728     148.0000    4113.0000
 2506.9800      40.2562      71.1951      50.7505      96.1995      79.4162      12.5919     216.0000       0.2514       0.1901       0.1607       7.8190      87.2058     283.6960     229.3522      51.9014       0.1261       0.1430       0.1928       6.4339    2384.8875       4.9872     148.2500    4139.0000
 2507.1324      34.9201      53.2299      63.3430      69.6532      83.4480      11.9835     216.0000       0.2348       0.1722       0.1421       7.9571      80.5086     283.1378     233.0809      51.9014       0.1215       0.1377       0.1873       6.3561    2415.5964       5.7753     147.6250    4226.0000
 2507.2848      33.2732      45.6978      62.9789      95.6550      91.1557      10.9702     216.0000       0.2646       0.2044       0.1755       7.9293      80.6637     265.5544     224.6411      51.9014       0.1871       0.2112       0.2632       6.4153    2360.4233       5.4687     148.5625    4109.0000
 2507.4372      35.3696      48.4730      56.0004      96.5789      72.6421      13.7661     216.0000       0.2922       0.2342       0.2064       7.9817      84.9270     274.4857     221.5185      51.9014       0.2020       0.2283       0.2802       6.4851    2309.4329       4.2636     146.5625    4200.0000
 2507.5896      42.7263      62.1606      80.4222      98.2638      60.1811      16.6165     216.0000       0.3320       0.2773       0.2510       7.8400      82.0647     301.8375     203.9185      51.9014       0.1657       0.1881       0.2392       6.5826    2235.8796       4.0718     144.6250    4199.0000
 2507.7420      34.5367      49.2911      93.7552     100.4897      79.7222      12.5436     216.0000       0.3676       0.3158       0.2909       7.8685      88.7642     259.4142     168.5512      51.9014       0.2017       0.2289       0.2802       6.5797    2169.9531       3.1907     147.6875    4088.0000
 2507.8944      26.9290      36.0071      58.0866      72.3405      38.9574      25.6691     216.0000       0.3801       0.3294       0.3050       7.8363      93.3462     275.0439     140.2829      51.9014       0.2160       0.2450       0.2962       6.5065    2146.7288       2.9171     144.1875    4101.0000
 2508.0468      28.6584      32.3840      52.0579      77.6998      34.8263      28.7140     216.0000       0.3436       0.2899       0.2641       8.0115      95.3299     263.8798     150.0480      51.9014       0.2462       0.2797       0.3298       6.3318    2214.2783       3.0051     144.9375    4092.0000
 2508.1992      56.0982      63.9736      88.7869     105.5894      49.1591      20.3421     216.0000       0.3330       0.2783       0.2521       7.8785      95.9390     278.9513     163.2845      51.9014       0.2402       0.2749       0.3237       6.2489    2234.0342       3.6184     143.8750    4118.0000
 2508.3516      46.9767      54.7924     106.9378     121.4915      64.1680      15.5841     216.0000       0.3364       0.2820       0.2559       7.9244      87.9582     273.3693     179.2769      51.9014       0.3190       0.3628       0.4084       6.2588    2227.7446       3.3792     146.3125    4089.0000
 2508.5040      59.9785      66.4193     119.8982     129.8791      95.1444      10.5103     216.0000       0.3186       0.2628       0.2360       7.4033      93.4192     292.3481     204.8326      51.9014       0.3036       0.3426       0.3915       6.2512    2260.6008       3.6100     144.0000    4104.0000
 2508.6564      53.7317      94.9855      93.4877      92.1709     126.4352       7.9092     216.0000       0.2728       0.2132       0.1846       7.4199      87.7861     302.6748     229.0018      51.9014       0.2385       0.2696       0.3209       6.1346    2345.3884       4.4876     141.3125    4126.0000
 2508.8088      47.6165      83.2330     250.3293     148.2622     123.7996       8.0776     216.0000       0.2118       0.1472       0.1162       7.2252      86.7186     305.7449     261.5952      51.9014       0.1602       0.1819       0.2328       5.9520    2458.2524       8.6982     141.3125    4152.0000
 2508.9612      45.6448      73.2202     147.9931     212.1785     356.9135       2.8018     216.0000       0.2156       0.1514       0.1205       7.5333      80.4455     286.2079     247.7884      51.9014       0.1410       0.1606       0.2107       5.8663    2451.1909      11.9118     141.3125    4198.0000
 2509.1136      28.5635      47.2014      96.3785     119.6009     213.4693       4.6845     216.0000       0.2464       0.1847       0.1551       7.9432      75.9708     288.9989     229.7068      51.9014       0.1572       0.1784       0.2293       5.8994    2394.1143       7.9391     141.3125    4145.0000
 2509.2660      19.5143      24.9886      41.3015     110.5319     135.6315       7.3729     216.0000       0.2920       0.2340       0.2061       8.0086      80.9029     295.6973     202.4751      51.9014       0.2189       0.2471       0.2991       6.0265    2309.8574       5.3176     141.3125    4105.0000
 2509.4184      21.7573      29.2597      61.2057     144.1917     131.2944       7.6165     216.0000       0.3045       0.2475       0.2201       8.1550      83.9268     270.0200     196.2700      51.9014       0.2211       0.2500       0.3017       6.1172    2286.7607       4.1685     141.3125    4156.0000
 2509.5708      24.6785      31.3828      67.6631     138.8548      95.9064      10.4268     216.0000       0.2869       0.2285       0.2005       7.8082      92.0045     276.1603     211.1337      51.9014       0.2359       0.2677       0.3184       6.1643    2319.1995       4.3973     140.4375    4077.0000
 2509.7232      27.4248      39.0656      81.9701     106.0094      65.5638      15.2523     216.0000       0.2798       0.2208       0.1925       7.7590      91.1328     282.8586     226.0935      51.9014       0.2305       0.2609       0.3122       6.2252    2332.4189       4.5887     139.9375    4069.0000
 2509.8756      30.0178      40.5451     102.2763     196.8264     159.1360       6.2839     216.0000       0.2886       0.2304       0.2024       7.9702      91.4118     275.0439     243.6383      51.9014       0.2298       0.2611       0.3117       6.3519    2316.0715       4.3828     137.3125    4110.0000
 2510.0280      31.2733      61.3939     130.8810     229.1712     207.4253       4.8210     216.0000       0.2884       0.2302       0.2022       7.6495      94.1141     265.5544     261.9441      51.9014       0.2371       0.2694       0.3198       6.4208    2316.3701       3.8733     137.6875    4111.0000
 2510.1804      33.7857      87.8218     112.5898     187.9976     320.5744       3.1194     216.0000       0.2657       0.2056       0.1767       7.7174      94.1141     275.0439     277.5385      51.9014       0.2547       0.2896       0.3392       6.3445    2358.4744       3.8556     136.0625    4136.0000
 2510.3328      35.8931     129.9384     158.2311     198.3954     281.2988       3.5549     216.0000       0.2370       0.1746       0.1445       7.7776      94.1298     248.8084     267.6585      51.9014       0.2391       0.2740       0.3226       6.1053    2411.5166       4.2282     137.3125    4156.0000
 2510.4852      36.5945     176.6213     216.0673     484.2610     397.9793       2.5127     216.0000       0.2240       0.1605       0.1300       7.7293      92.0365     253.2740     228.5316      51.9014       0.2398       0.2737       0.3231       5.7765    2435.5603       4.7257     134.0000    4187.0000
 2510.6376      41.1099     265.0766     428.1330     489.7444     788.4470       1.2683     216.0000       0.1917       0.1256       0.0938       7.7417      89.3973     229.8296     194.0138      51.9014       0.2397       0.2728       0.3228       5.3587    2495.2683       6.1121     132.8125    4148.0000
 2510.7900      40.6022     195.4177     884.0258     609.3724     982.5056       1.0178     216.0000       0.1734       0.1057       0.0732       7.7600      85.1103     262.7634     139.2722      51.9014       0.2206       0.2495       0.3011       4.8651    2529.3013       8.1718     134.1250    4143.0000
 2510.9424      38.2345     118.2871     272.0971     170.7542     262.6996       3.8066     216.0000       0.1561       0.0870       0.0538       7.6868      77.5987     218.1073      86.5617      51.9014       0.2200       0.2488       0.3004       4.3549    2561.2024      12.9041     131.5625    4069.0000
 2511.0948      44.5540      93.8200     301.8988     215.2144     227.1527       4.4023     216.0000       0.1731       0.1054       0.0729       7.5947      68.2600     225.9222      30.5398      51.9014       0.2069       0.2329       0.2854       4.0043    2529.7654       8.9953     131.5625    4084.0000
 2511.2472      40.9103      85.6550     284.7631     232.5419     180.2258       5.5486     216.0000       0.1777       0.1104       0.0781       7.6347      62.9717     234.2952      12.4052      51.9014       0.1401       0.1583       0.2089       3.8441    2521.1738       7.9727     131.5625    4126.0000
 2511.3996      54.7402     108.4131     204.9083     195.9268     126.0834       7.9313     216.0000       0.1782       0.1109       0.0786       7.6699      59.5592     238.2026      27.3917      51.9014       0.0858       0.0970       0.1440       4.0630    2520.3589      11.0012     133.8750    4152.0000
 2511.5520      50.3660     107.8822     149.8286     160.2949     127.1084       7.8673     216.0000       0.1772       0.1099       0.0775       7.6527      63.0105     246.0174      72.4785      51.9014       0.0966       0.1094       0.1570       4.5650    2522.1064      18.3833     132.7500    4169.0000
 2511.7044      54.8494     142.3958     371.1491     498.4553     169.1697       5.9112     216.0000       0.1927       0.1266       0.0948       7.6736      65.6128     231.5042     141.0034      51.9014       0.1226       0.1387       0.1883       5.2503    2493.5522      16.0567     139.4375    4159.0000
 2511.8568      55.5338     160.8541     168.0983     133.3394      91.8799      10.8838     216.0000       0.2220       0.1583       0.1277       7.6492      71.3802     247.1338     201.6978      51.9014       0.1485       0.1677       0.2187       5.8001    2439.2537       8.7270     131.5625    4179.0000
 2512.0092      47.8418      70.3036     155.4552     103.6065      78.4493      12.7471     216.0000       0.2569       0.1961       0.1668       7.7106      77.8767     250.4830     227.0734      51.9014       0.1734       0.1954       0.2473       6.0907    2374.7456       5.5873     135.7500    4185.0000
 2512.1616      61.2827      44.6926      59.5885      44.6688      40.1291      24.9196     216.0000       0.2605       0.2000       0.1709       7.5413      84.0204     265.5544     229.5890      51.9014       0.1781       0.2006       0.2527       6.1564    2368.0076       5.1496     133.1875    4083.0000
 2512.3140      55.1755      88.7110      77.3780      60.8923      56.9824      17.5493     216.0000       0.2342       0.1716       0.1414       7.8425      83.6957     260.5306     219.1124      51.9014       0.1804       0.2032       0.2554       6.0290    2416.6440       6.2411     135.5625    4079.0000
 2512.4664      58.8438     141.3492     205.6192     108.0981     102.1506       9.7895     216.0000       0.2018       0.1365       0.1051       7.7879      75.5750     240.4354     210.9268      51.9014       0.1418       0.1603       0.2110       5.8644    2476.6409       7.9643     136.0625    4101.0000
 2512.6188      54.7435     125.7488     152.8154     100.0505     108.9121       9.1817     216.0000       0.2079       0.1430       0.1119       7.8691      71.1003     234.2952     201.9012      51.9014       0.1121       0.1269       0.1758       5.8144    2465.4211       9.8811     134.3750    4128.0000
 2512.7712      51.4739     160.3947     166.7193     120.2466     183.9586       5.4360     216.0000       0.2388       0.1765       0.1466       7.9395      71.1494     245.4592     203.1944      51.9014       0.1203       0.1362       0.1857       5.8949    2408.1711       6.9766     138.3750    4193.0000
 2512.9236      60.6430     157.5464     296.3930     343.1454     342.6609       2.9183     216.0000       0.2453       0.1835       0.1538       7.6210      76.6308     242.1100     208.1768      51.9014       0.1762       0.1986       0.2506       5.9118    2396.1646       6.0915     138.6875    4156.0000
 2513.0760      78.2732     205.1929     302.0829     267.5921     241.1831       4.1462     216.0000       0.2177       0.1536       0.1228       7.6484      83.8945     256.6232     202.0068      51.9014       0.1695       0.1913       0.2431       5.7408    2447.3091       5.9105     138.2500    4161.0000
 2513.2284      90.1445     132.8845     334.3283     319.3259     185.5345       5.3898     216.0000       0.1684       0.1003       0.0676       7.4788      85.5656     265.8335     194.4180      51.9014       0.1480       0.1674       0.2183       5.4556    2538.4233       7.4758     139.0625    4183.0000
 2513.3808      90.1705     127.0227     320.2542     309.1677     220.1057       4.5433     216.0000       0.1392       0.0687       0.0349       7.5018      88.8139     263.6007     198.1213      51.9014       0.1486       0.1680       0.2189       5.2876    2592.4465      10.3967     141.3125    4137.0000
 2513.5332      88.4110     112.0769     257.2791     251.7476     236.8186       4.2226     216.0000       0.1305       0.0593       0.0251       7.5341      86.4317     260.5306     220.8967      51.9014       0.1512       0.1711       0.2221       5.3095    2608.5156      13.1648     140.0625    4132.0000
 2513.6856      66.8654     115.3651     199.4778     174.2210     203.0004       4.9261     216.0000       0.1353       0.0645       0.0305       7.6600      88.5688     255.5068     250.6244      51.9014       0.1759       0.1987       0.2505       5.4807    2599.6235      21.5043     141.7500    4085.0000
 2513.8380      53.5432     118.7018     147.7411     155.5944     172.6261       5.7929     216.0000       0.1352       0.0644       0.0304       7.5807      88.1627     268.3454     271.6532      51.9014       0.1605       0.1818       0.2330       5.6368    2599.8159      23.9379     140.6250    4142.0000
 2513.9904      44.1347     110.0580     143.8502     160.8209     163.0960       6.1314     216.0000       0.1230       0.0512       0.0167       7.6225      88.1627     259.4142     283.8132      51.9014       0.1831       0.2075       0.2590       5.7162    2622.5244      25.8727     143.1250    4204.0000
 2514.1428      44.6211     146.3666     145.6350     176.8746     167.9869       5.9528     216.0000       0.1151       0.0426       0.0078       7.4012      87.6088     282.8586     281.6360      51.9014       0.1814       0.2053       0.2570       5.7080    2637.1477      23.9003     142.0000    4208.0000
 2514.2952      49.1231     157.3476     138.2070     193.2233     127.7652       7.8269     216.0000       0.1345       0.0636       0.0296       7.4302      88.4209     266.6708     281.0779      51.9014       0.1921       0.2174       0.2691       5.7515    2601.1606      16.0901     145.8750    4148.0000
 2514.4476      69.4399     151.5199     176.8015     195.1361     164.5895       6.0757     216.0000       0.1533       0.0840       0.0507       7.4199      89.5411     284.5333     294.8005      51.9014       0.2124       0.2387       0.2914       5.8385    2566.3669      12.5898     141.9375    4195.0000
 2514.6000     115.8421     174.8184     185.2275     182.2816     177.8061       5.6241     216.0000       0.1581       0.0892       0.0560       7.5610      85.4256     267.2290     311.5885      51.9014       0.1962       0.2215       0.2736       5.9055    2557.5420      11.4411     141.3750    4194.0000
 2514.7524     127.2906     220.6863     189.4202     155.4248     178.5581       5.6004     216.0000       0.1434       0.0733       0.0396       7.5470      82.5834     275.0439     314.1053      51.9014       0.1658       0.1874       0.2389       5.8738    2584.6199      11.1375     142.6250    4163.0000
 2514.9048     125.8850     236.5358     290.8629     215.7496     218.1730       4.5835     216.0000       0.1321       0.0611       0.0269       7.4408      76.9885     265.5544     298.3131      51.9014       0.1302       0.1474       0.1975       5.7811    2605.5857      12.4238     141.3125    4175.0000
 2515.0572      56.4326     101.4598      95.7161      82.4671      87.3116      11.4532     216.0000       0.1325       0.0614       0.0273       7.6110      78.0036     252.1576     282.5716      51.9014       0.1474       0.1668       0.2176       5.7129    2604.9668      13.5963     141.3125    4070.0000
 2515.2096      52.4959     152.0012     129.0689      95.5110      97.2810      10.2795     216.0000       0.1267       0.0552       0.0208       7.4505      77.3133     263.3217     289.0851      51.9014       0.1527       0.1726       0.2238       5.7082    2615.6721      25.4292     141.3125    4119.0000
 2515.3620     106.5665     308.7063     275.0686     149.5142     127.7061       7.8305     216.0000       0.1190       0.0469       0.0122       7.3248      79.2978     254.9486     302.7716      51.9014       0.1707       0.1930       0.2446       5.7380    2629.8069      41.7123     141.3125    4128.0000
 2515.5144     100.6868    1112.0302     605.5421     253.8572     125.6036       7.9616     216.0000       0.1031       0.0296      -0.0057       7.1471      77.8767     250.4830     324.2462      51.9014       0.1642       0.1854       0.2370       5.7657    2659.3301      68.3314     141.5000    4144.0000
 2515.6668     101.5930     976.4999    1362.4900     414.3434     120.8805       8.2726     216.0000       0.0991       0.0253      -0.0101       7.1953      74.7534     253.2740     331.1067      51.9014       0.1462       0.1654       0.2162       5.7536    2666.6846      59.1786     142.3125    4213.0000
 2515.8192     104.4121     475.4007     844.8641     343.2327     119.0986       8.3964     216.0000       0.1037       0.0303      -0.0050       7.1737      76.2266     256.9023     322.8156      51.9014       0.1539       0.1737       0.2250       5.6960    2658.1753      34.3042     141.3125    4116.0000
 2515.9716     115.8580     327.9809    1279.2108     750.3731     106.4690       9.3924     216.0000       0.1116       0.0388       0.0039       7.4876      72.5724     261.0888     298.2688      51.9014       0.1615       0.1820       0.2336       5.5991    2643.6323      19.1869     143.0625    4160.0000
 2516.1240     114.4700     252.6297     840.5052     349.6463     136.2682       7.3385     216.0000       0.1209       0.0489       0.0143       7.3831      74.9648     277.8349     262.3887      51.9014       0.1419       0.1603       0.2110       5.4936    2626.3254      16.0052     140.6875    4109.0000
 2516.2764     102.6534     211.4995     715.9404     379.9612     195.8967       5.1047     216.0000       0.1239       0.0521       0.0177       7.3556      70.0833     262.2052     245.4543      51.9014       0.1233       0.1395       0.1892       5.4264    2620.8555      16.3971     141.3125    4116.0000
 2516.4288      84.7177     193.7090     562.0469     277.4975     275.3153       3.6322     216.0000       0.1267       0.0553       0.0209       7.2786      71.9747     240.4354     246.5887      51.9014       0.1470       0.1661       0.2170       5.4390    2615.5217      25.1188     141.3125    4116.0000
 2516.5812      75.8678     159.9098     448.4389     298.2078     408.0612       2.4506     216.0000       0.1272       0.0557       0.0214       7.3726      68.3618     239.3190     258.2352      51.9014       0.1336       0.1511       0.2014       5.4978    2614.7622      35.1831     141.3125    4133.0000
 2516.7336      69.0738     157.9176     456.1744     366.0143     375.0456       2.6663     216.0000       0.1224       0.0506       0.0160       7.3468      69.5370     245.4592     278.1847      51.9014       0.1242       0.1406       0.1903       5.5756    2623.5386      43.1782     141.3125    4070.0000
 2516.8860      68.1513     146.6170     353.6235     317.2211     269.5870       3.7094     216.0000       0.1174       0.0451       0.0104       7.4154      71.0969     252.4367     303.0970      51.9014       0.1347       0.1523       0.2027       5.6447    2632.8020      36.1916     141.3750    4071.0000
 2517.0384      69.2685     147.7223     372.9183     287.7534     177.9495       5.6196     216.0000       0.1144       0.0419       0.0070       7.4060      73.7593     238.7608     326.3369      51.9014       0.1449       0.1637       0.2146       5.7019    2638.3914      33.2059     141.3125    4060.0000
 2517.1908      75.0878     164.6598     315.2304     232.7340     178.6688       5.5969     216.0000       0.1108       0.0380       0.0030       7.2668      76.7538     244.3428     327.5192      51.9014       0.1608       0.1815       0.2330       5.7056    2645.0017      27.6082     141.3125    4092.0000
 2517.3432      77.3478     170.8109     327.3658     201.0874     190.3087       5.2546     216.0000       0.0970       0.0231      -0.0124       7.1701      76.1222     246.0174     309.3417      51.9014       0.1689       0.1905       0.2423       5.6259    2670.4875      30.1430     141.3125    4168.0000
 2517.4956      79.0909     179.5191     296.9264     182.8617     168.3991       5.9383     216.0000       0.0884       0.0138      -0.0221       7.2857      75.2455     251.5994     281.2204      51.9014       0.1446       0.1634       0.2142       5.5317    2686.3831      40.1483     142.5000    4322.0000
 2517.6480      70.7549     168.5617     253.5252     175.2994     151.5841       6.5970     216.0000       0.0913       0.0169      -0.0189       7.1314      67.9877     249.9248     263.2504      51.9014       0.1404       0.1588       0.2094       5.5081    2681.1172      65.4045     144.2500    4386.0000
 2517.8004      59.5654     119.2434     246.6081     159.6885     128.4341       7.7861     216.0000       0.1102       0.0374       0.0024       7.0451      68.2589     237.6444     265.0390      51.9014       0.1482       0.1676       0.2185       5.6157    2646.0750      61.6806     145.4375    4346.0000
 2517.9528      48.8934     111.7664     186.3178     146.0370     114.2326       8.7541     216.0000       0.1335       0.0625       0.0284       7.2851      69.1173     241.8309     283.5541      51.9014       0.1445       0.1639       0.2145       5.8051    2603.1160      32.6964     145.5000    4261.0000
 2518.1052      46.7558      89.4644     161.9497     131.7381     103.1585       9.6938     216.0000       0.1516       0.0822       0.0488       7.2914      77.7676     252.7158     309.0515      51.9014       0.1777       0.2012       0.2528       5.9908    2569.4993      19.0203     146.6250    4157.0000
 2518.2576      53.5911      90.7724     204.9163     147.2958     128.3962       7.7884     216.0000       0.1676       0.0995       0.0667       7.3235      79.9551     271.1364     316.0224      51.9014       0.2141       0.2415       0.2937       6.1008    2539.8931      15.9248     145.4375    4152.0000
 2518.4100      66.9032     111.2936     210.4012     162.8233     132.6769       7.5371     216.0000       0.1704       0.1025       0.0698       7.2792      80.9238     274.4857     316.2005      51.9014       0.1884       0.2132       0.2649       6.1112    2534.8015      16.7415     147.6250    4175.0000
 2518.5624      58.2135      85.6649     227.5766     169.8910     146.9802       6.8036     216.0000       0.1612       0.0926       0.0596       7.2056      78.4127     262.7634     323.2651      51.9014       0.1880       0.2123       0.2643       6.0633    2551.7114      18.8961     145.8750    4080.0000
 2518.7148      59.9253      69.6477     190.5034     150.9475     134.8565       7.4153     216.0000       0.1430       0.0728       0.0391       7.2232      79.0727     274.4857     344.2142      51.9014       0.1861       0.2102       0.2622       6.0174    2585.4277      18.1198     146.9375    4097.0000
 2518.8672      58.5484      95.6477     306.3733     218.5654     192.4093       5.1973     216.0000       0.1350       0.0641       0.0301       7.1552      79.0505     282.8586     347.2428      51.9014       0.1837       0.2077       0.2595       5.9793    2600.3110      17.0202     146.5625    4128.0000
 2519.0196      57.1560     110.8768     298.1475     251.3503     222.6482       4.4914     216.0000       0.1345       0.0636       0.0295       7.0469      82.1015     278.3931     326.3564      51.9014       0.1592       0.1806       0.2316       5.9179    2601.2485      17.6874     147.1875    4161.0000
 2519.1720      52.7946      95.9893     306.1235     298.2708     239.8896       4.1686     216.0000       0.1351       0.0643       0.0302       7.0459      86.3138     286.2079     297.1587      51.9014       0.1557       0.1764       0.2274       5.8408    2600.0964      18.2247     146.8125    4135.0000
 2519.3244      44.1836      88.3978     264.5168     290.4782     199.6341       5.0092     216.0000       0.1374       0.0668       0.0328       7.0717      89.7872     271.4155     279.3076      51.9014       0.1776       0.2008       0.2525       5.7984    2595.8228      17.2090     145.9375    4149.0000
 2519.4768      56.4793     112.1286     288.0692     345.3268     210.6170       4.7480     216.0000       0.1386       0.0681       0.0342       7.2654      87.5499     286.7661     283.0741      51.9014       0.2155       0.2427       0.2951       5.8396    2593.5042      19.0925     145.1250    4137.0000
 2519.6292      58.1061     193.8979     271.7041     332.2065     171.5461       5.8293     216.0000       0.1536       0.0844       0.0511       7.1387      79.8353     295.1391     287.7817      51.9014       0.1852       0.2095       0.2613       5.9210    2565.7559      17.9926     146.2500    4107.0000
 2519.7816      54.5789     135.8305     489.9904     495.8111     200.4417       4.9890     216.0000       0.1584       0.0895       0.0564       7.0081      79.4293     287.8825     309.4633      51.9014       0.1610       0.1830       0.2338       5.9935    2556.9243      17.6873     146.5000    4129.0000
 2519.9340      42.5023     147.0916     139.5325     150.8663     100.8720       9.9136     216.0000       0.1603       0.0916       0.0586       6.9181      78.3970     277.8349     326.0183      51.9014       0.1919       0.2172       0.2689       6.0379    2553.3628      12.7042     144.1250    4095.0000
 2520.0864      36.5646      91.3859     154.3431     131.0616      68.6823      14.5598     216.0000       0.1595       0.0907       0.0576       7.0600      82.0513     299.6047     335.4006      51.9014       0.1847       0.2089       0.2606       6.0514    2554.8914      11.8049     144.1250    4159.0000
 2520.2388      42.3676      97.0036     245.6624     211.9175     139.1674       7.1856     216.0000       0.1730       0.1053       0.0727       6.9046      81.0883     290.1153     326.5824      51.9014       0.1673       0.1901       0.2411       6.0822    2530.0054      10.4867     142.3750    4152.0000
 2520.3912      42.8111     111.9115     252.4335     198.4673     159.5192       6.2688     216.0000       0.1868       0.1203       0.0883       7.0601      86.3918     288.7198     312.5780      51.9014       0.2430       0.2737       0.3256       6.0714    2504.3501      12.1400     141.3125    4182.0000
 2520.5436      38.7955     144.4249     277.0513     241.8940     198.8850       5.0280     216.0000       0.1856       0.1189       0.0869       7.1116      87.0009     302.6748     298.7273      51.9014       0.2156       0.2441       0.2956       5.9850    2506.6462      14.0041     141.4375    4177.0000
 2520.6960      43.1855     100.6551     657.7595     145.6997     365.8797       2.7331     216.0000       0.1513       0.0818       0.0484       7.0796      85.9337     284.5333     294.7979      51.9014       0.1943       0.2203       0.2717       5.7664    2570.1775      13.2026     139.9375    4151.0000
 2520.8484      44.3897      56.6711     115.1221      93.1812     100.6015       9.9402     216.0000       0.1201       0.0481       0.0135       7.1504      82.6794     278.3931     283.4094      51.9014       0.1984       0.2240       0.2760       5.5365    2627.7310      14.3199     141.3125    4155.0000
 2521.0008      43.8680      82.8168     189.4039     218.1436     206.2688       4.8480     216.0000       0.0961       0.0221      -0.0134       7.0678      85.9940     282.8586     267.7760      51.9014       0.1581       0.1788       0.2301       5.3484    2672.1863      17.4631     139.1875    4141.0000
 2521.1532      47.3607     133.0774     311.9739     278.5914     231.8755       4.3127     216.0000       0.0941       0.0200      -0.0157       7.0269      87.0612     261.0888     238.7559      51.9014       0.1392       0.1579       0.2083       5.2652    2675.8652      45.8648     141.3125    4183.0000
 2521.3056      47.4640     155.7420    1068.3728    1286.9822     770.6132       1.2977     216.0000       0.0983       0.0244      -0.0110       7.0883      88.8362     252.1576     204.9868      51.9014       0.1638       0.1853       0.2367       5.2063    2668.2224      62.7004     141.3125    4115.0000
 2521.4580      47.6398     155.0963    1101.5547     983.0903     686.1376       1.4574     216.0000       0.1039       0.0305      -0.0048       7.1419      83.0854     249.3666     198.5316      51.9014       0.1715       0.1942       0.2457       5.2246    2657.8403      39.9593     141.1250    4081.0000
 2521.6104      48.4684     132.2777     934.0579     944.9315     222.4717       4.4950     216.0000       0.1111       0.0383       0.0033       7.0499      83.8990     265.2753     206.7592      51.9014       0.1910       0.2151       0.2675       5.2493    2644.5332      35.3659     140.5625    4096.0000
 2521.7628      50.2624     106.0108     993.0281     904.1071     174.4772       5.7314     216.0000       0.1139       0.0414       0.0065       7.0439      82.5725     248.2502     227.0703      51.9014       0.1715       0.1938       0.2455       5.2663    2639.1982      30.7745     141.3125    4133.0000
 2521.9152      52.1085      96.4536     796.7209     632.7628     154.6999       6.4641     216.0000       0.0993       0.0255      -0.0099       6.8116      80.9932     263.8798     230.2971      51.9014       0.1553       0.1754       0.2267       5.1649    2666.3826      45.7675     140.0000    4133.0000
 2522.0676      53.7324      98.2330     576.1608     404.8816     186.4516       5.3633     216.0000       0.0910       0.0166      -0.0192       6.8912      73.0220     253.2740     220.6602      51.9014       0.1321       0.1493       0.1995       5.0444    2681.6062      53.2850     140.8125    4184.0000
 2522.2200      53.7345     117.2193     401.1719     268.8908     165.5635       6.0400     216.0000       0.1098       0.0370       0.0019       6.7032      62.9797     264.4380     209.4538      51.9014       0.1106       0.1252       0.1740       5.0734    2646.7856      56.5608     141.3125    4159.0000
 2522.3724      56.3639     121.4701     581.2031     316.5085     290.3199       3.4445     216.0000       0.1391       0.0686       0.0347       6.8199      64.6069     252.1576     225.5189      51.9014       0.1166       0.1319       0.1811       5.3056    2592.6853      35.2526     141.3125    4145.0000
 2522.5248      56.1626     160.1859     204.3925     170.6016     115.5402       8.6550     216.0000       0.1553       0.0862       0.0529       6.6565      75.0188     253.5531     261.3885      51.9014       0.1546       0.1746       0.2258       5.6196    2562.6377      27.0307     141.3125    4094.0000
 2522.6772      55.5414     146.2419     204.6799     148.6358     121.4534       8.2336     216.0000       0.1303       0.0591       0.0249       6.6490      85.5253     256.0650     304.8241      51.9014       0.1837       0.2071       0.2592       5.8081    2608.8811      21.9553     141.3125    4096.0000
 2522.8296      55.3882     224.9702     270.8971     190.7710     135.6299       7.3730     216.0000       0.1266       0.0551       0.0207       6.9841      90.5528     266.1126     309.5534      51.9014       0.1533       0.1737       0.2247       5.8707    2615.7817      32.5688     141.3125    4096.0000
 2522.9820      58.3518     182.4635     287.5310     220.4429     133.1945       7.5078     216.0000       0.1468       0.0770       0.0434       6.9922      87.0433     263.3217     297.3101      51.9014       0.1762       0.1991       0.2508       5.9189    2578.4106      23.5577     141.3125    4133.0000
 2523.1344      55.7279     142.2078     263.2273     190.7903     116.1442       8.6100     216.0000       0.1689       0.1009       0.0682       7.0319      88.5714     267.2290     293.9932      51.9014       0.1824       0.2065       0.2581       5.9731    2537.4697      16.3300     142.3750    4126.0000
 2523.2868      65.8529     127.9684     284.0963     220.6541     123.6064       8.0902     216.0000       0.1630       0.0945       0.0616       7.0348      86.1881     285.0915     305.6273      51.9014       0.1941       0.2190       0.2712       5.9899    2548.3889      14.8024     141.3125    4110.0000
 2523.4392      76.0598     121.0962     389.4460     301.8002     168.4924       5.9350     216.0000       0.1356       0.0648       0.0308       6.7079      90.6050     275.3229     316.1180      51.9014       0.1674       0.1895       0.2409       5.9095    2599.1089      16.8034     142.3125    4159.0000
 2523.5916      74.1829     130.6970     511.4825     393.7783     202.1869       4.9459     216.0000       0.1216       0.0497       0.0152       6.6491      89.3846     282.3004     304.1456      51.9014       0.1622       0.1835       0.2349       5.8015    2624.9709      20.0846     143.5000    4145.0000
 2523.7440      69.5615     113.5942     605.4197     520.0931     278.9420       3.5850     216.0000       0.1234       0.0517       0.0172       6.7572      89.3317     278.9513     293.9887      51.9014       0.1862       0.2106       0.2624       5.7333    2621.6663      18.2022     141.9375    4145.0000
 2523.8964      66.7473     125.0530     751.3753     664.2427     328.7445       3.0419     216.0000       0.1314       0.0603       0.0261       6.6855      84.7118     283.4169     291.9807      51.9014       0.1922       0.2178       0.2693       5.7464    2606.8630      21.2129     147.1875    4152.0000
 2524.0488      65.6654     134.5496     760.0244     691.0601     320.9885       3.1154     216.0000       0.1411       0.0708       0.0370       6.7130      84.3051     288.1616     284.9929      51.9014       0.1934       0.2187       0.2705       5.7480    2588.9573      23.4548     146.1250    4120.0000
 2524.2012      61.3574     156.7239     798.2742     685.0191     329.7556       3.0325     216.0000       0.1392       0.0688       0.0349       6.7117      85.3279     290.1153     284.3881      51.9014       0.1681       0.1904       0.2418       5.7488    2592.4238      26.1153     149.7500    4136.0000
 2524.3536      56.0928     179.8886     621.0568     530.4482     278.1865       3.5947     216.0000       0.1404       0.0701       0.0363       6.5829      86.1928     280.3468     279.2018      52.1810       0.1773       0.2006       0.2523       5.7359    2590.1851      24.5049     147.1875    4180.0000
 2524.5060      54.2223     154.8143     654.8867     569.4785     241.9798       4.1326     216.0000       0.1517       0.0822       0.0489       6.5429      85.7332     293.4644     283.9258      51.9014       0.1776       0.2013       0.2527       5.8019    2569.3923      18.6285     146.6250    4151.0000
 2524.6584      56.1843     208.0465     934.3044     645.8275     266.3093       3.7550     216.0000       0.1711       0.1033       0.0707       6.6581      78.4168     290.6735     291.1556      51.9014       0.1823       0.2065       0.2580       5.8909    2533.4143      17.0868     146.6875    4194.0000
 2524.8108      58.1510     219.9242    1013.1439     465.0253     258.6996       3.8655     216.0000       0.1744       0.1068       0.0743       6.6202      77.1965     287.8825     321.4481      51.9014       0.1742       0.1968       0.2486       5.9728    2527.4373      16.4408     147.9375    4139.0000
 2524.9632      59.3973     216.8553    1091.3669     504.4391     289.1682       3.4582     216.0000       0.1660       0.0977       0.0649       6.4763      78.2663     290.6735     351.1274      51.9014       0.1661       0.1874       0.2391       6.0118    2542.8708      14.6435     146.9375    4139.0000
 2525.1156      59.2476     208.4189    1177.8824     563.6727     334.2224       2.9920     216.0000       0.1493       0.0796       0.0462       6.7130      80.4995     292.3481     358.4521      51.9014       0.1788       0.2014       0.2535       5.9740    2573.8203      11.9653     147.1875    4191.0000
 2525.2680      57.1017     195.2043    1191.8717     559.9561     337.1915       2.9657     216.0000       0.1226       0.0508       0.0163       6.6143      78.5125     291.2317     341.5718      51.9014       0.1560       0.1764       0.2277       5.8297    2623.1123      13.2874     146.5000    4134.0000
 2525.4204      53.2517     172.8316    1043.3982     602.6405     357.7058       2.7956     216.0000       0.0992       0.0255      -0.0099       6.3578      71.5552     263.3217     312.1960      51.9014       0.1429       0.1617       0.2124       5.6492    2666.3943      18.6645     147.6250    4095.0000
 2525.5728      47.1166     155.4914     668.2727     575.4398     338.7169       2.9523     216.0000       0.0921       0.0178      -0.0179       6.3528      71.1936     256.6232     290.1201      51.9014       0.1199       0.1356       0.1850       5.5412    2679.5635      34.8940     149.3125    4108.0000
 2525.7252      45.0562     119.4096     590.0804     354.7143     214.6976       4.6577     216.0000       0.1157       0.0433       0.0085       6.3233      71.3501     259.9724     271.9521      52.1810       0.1016       0.1150       0.1631       5.5835    2636.0083      35.1980     150.0000    4073.0000
 2525.8776      41.9497     100.1145     446.3267     366.0893     207.1007       4.8286     216.0000       0.1414       0.0711       0.0373       6.3647      78.2526     270.0200     261.5507      52.1810       0.1390       0.1570       0.2075       5.6841    2588.3896      29.1132     149.7500    4131.0000
 2526.0300      42.1961      83.9363     361.2899     337.1561     183.8940       5.4379     216.0000       0.1439       0.0739       0.0402       6.4667      80.6803     278.3931     263.7715      51.9014       0.1543       0.1744       0.2256       5.7480    2583.7080      27.9147     147.8750    4126.0000
 2526.1824      35.7799      62.7089     230.2491     280.5728     126.1380       7.9278     216.0000       0.1563       0.0872       0.0540       6.4119      82.6633     275.6021     253.7932      51.9014       0.1817       0.2048       0.2569       5.7783    2560.8572      23.6835     149.9375    4070.0000
 2526.3348      36.0667      64.6919     211.5630     217.0781      91.6623      10.9096     216.0000       0.1677       0.0995       0.0668       6.3002      83.7351     278.3931     250.3948      51.9014       0.1760       0.1991       0.2507       5.8096    2539.7888      14.5441     150.0000    4135.0000
 2526.4872      45.9329     101.7090     364.0726     389.7561     208.0860       4.8057     216.0000       0.1638       0.0953       0.0624       6.5096      83.3413     283.4169     259.6147      51.9014       0.1604       0.1816       0.2328       5.8305    2546.9836      15.3463     151.0625    4160.0000
 2526.6396      48.1404     126.8081     567.8704     553.1143     314.6567       3.1781     216.0000       0.1315       0.0604       0.0262       6.3096      83.5443     274.4857     283.4268      52.1810       0.1770       0.2000       0.2518       5.7860    2606.7854      23.6204     150.4375    4168.0000
 2526.7920      49.4174     150.2472     867.0159     801.4050     489.6320       2.0424     216.0000       0.1171       0.0448       0.0100       6.1189      77.1942     276.7184     295.7490      52.1810       0.1538       0.1738       0.2250       5.7357    2633.4482      86.3587     151.0625    4163.0000
 2526.9444      45.8403     157.0026     525.5695     450.8866     286.5147       3.4902     216.0000       0.1439       0.0738       0.0401       6.0663      78.8214     280.0677     279.2158      52.1810       0.1316       0.1489       0.1990       5.7292    2583.8579      87.0025     151.0625    4183.0000
 2527.0968      45.7592     124.6377     401.4256     333.5351     200.9394       4.9766     216.0000       0.1546       0.0854       0.0521       6.0924      76.7110     279.5095     269.7382      52.1810       0.1451       0.1639       0.2148       5.7158    2563.9829      49.3866     149.0625    4157.0000
 2527.2492      45.3460     116.4507     327.8116     244.8031     150.0101       6.6662     216.0000       0.1360       0.0652       0.0312       6.1534      80.8237     282.8586     261.5955      52.1810       0.1608       0.1817       0.2331       5.6430    2598.4683      37.5073     151.0625    4136.0000
 2527.4016      47.3863     137.0715     307.4610     244.7182     163.1389       6.1297     216.0000       0.1031       0.0297      -0.0056       6.1612      81.7875     287.8825     252.4474      52.1810       0.1658       0.1876       0.2390       5.5135    2659.2668      39.6522     151.0625    4113.0000
 2527.5540      46.7308     135.7909     257.5898     202.8168     140.3663       7.1242     216.0000       0.1101       0.0373       0.0023       6.2712      81.2587     275.0439     244.7863      52.1810       0.1818       0.2058       0.2575       5.5332    2646.2610      44.0621     152.3125    4139.0000
 2527.7064      42.2333     113.1513     254.0753     179.4451     135.5700       7.3763     216.0000       0.1475       0.0777       0.0441       6.1138      82.2622     270.5782     249.3546      52.1810       0.1858       0.2106       0.2621       5.7084    2577.1814      32.7336     151.8750    4113.0000
 2527.8588      39.1573     115.4983     213.6823     167.6068     115.0257       8.6937     216.0000       0.1884       0.1219       0.0900       5.8872      87.7436     272.2528     275.9864      52.1810       0.1792       0.2033       0.2546       5.9947    2501.5178      15.1732     153.6875    4163.0000
 2528.0112      38.5698      86.1444     167.5100     149.2123     104.2081       9.5962     216.0000       0.1860       0.1193       0.0873       5.6892      91.8579     276.7184     313.3161      52.1810       0.2050       0.2315       0.2836       6.1635    2505.9919      12.7630     153.5625    4120.0000
 2528.1636      44.3617     132.6604     221.2018     188.9468     138.3008       7.2306     216.0000       0.1601       0.0913       0.0583       5.9267      92.4816     282.8586     347.8124      52.1810       0.1819       0.2054       0.2573       6.2052    2553.8379      14.9983     155.4375    4097.0000
 2528.3160      42.5684     121.9216     222.3887     216.3601     172.5825       5.7943     216.0000       0.1433       0.0731       0.0394       5.8792      88.0152     273.3693     363.5833      52.1810       0.1487       0.1684       0.2192       6.1659    2584.9521      23.8551     156.9375    4126.0000
 2528.4684      40.6295      90.7448     198.4403     172.9636     145.2020       6.8870     216.0000       0.1692       0.1012       0.0685       5.9526      87.2147     275.0439     339.7815      52.1810       0.1646       0.1862       0.2377       6.1323    2536.9307      18.9468     157.8750    4108.0000
 2528.6208      37.6747      73.1501     172.7331     164.7829     156.6335       6.3843     216.0000       0.1786       0.1113       0.0790       6.0242      82.6928     289.5571     316.5762      52.1810       0.1804       0.2038       0.2557       6.0333    2519.6716      13.9441     158.3125    4120.0000
 2528.7732      37.4440      63.2366     142.0896     143.8140     133.5543       7.4876     216.0000       0.1666       0.0983       0.0655       5.8210      85.1887     287.6034     293.5453      52.1810       0.1899       0.2150       0.2667       5.8696    2541.8679      16.4531     155.6250    4137.0000
 2528.9256      36.8914      89.0951     160.7958     176.2417     103.1753       9.6922     216.0000       0.1300       0.0588       0.0245       5.7461      82.1247     280.0677     282.0017      52.1810       0.1948       0.2203       0.2722       5.6547    2609.4980      30.2194     158.0000    4145.0000
 2529.0780      38.1085     101.9330     311.4291     287.9196     155.8373       6.4169     216.0000       0.1115       0.0388       0.0038       5.8155      82.9368     274.4857     261.1580      52.1810       0.1723       0.1950       0.2466       5.4874    2643.6750     106.1313     159.3125    4137.0000
 2529.2304      38.6288      99.0300     376.5074     337.4010     199.9436       5.0014     216.0000       0.1131       0.0405       0.0056       5.6927      79.2228     284.5333     243.7668      52.1810       0.1472       0.1665       0.2174       5.4053    2640.7043      68.2504     159.6250    4207.0000
 2529.3828      39.9023     122.0267     539.9977     401.9007     210.1973       4.7574     216.0000       0.1362       0.0655       0.0315       5.8364      84.6076     281.7422     229.3124      52.1810       0.1364       0.1543       0.2047       5.4062    2597.9812      39.3493     155.9375    4170.0000
 2529.5352      41.6128     118.4184    1372.6903     802.2544     441.3981       2.2655     216.0000       0.1529       0.0835       0.0502       5.7457      87.5038     283.1378     227.1507      52.1810       0.1508       0.1704       0.2215       5.4280    2567.2092      27.4694     160.5000    4165.0000
 2529.6876      43.4258     110.4565     697.7023     425.1602     143.2636       6.9801     216.0000       0.1408       0.0704       0.0366       5.8251      88.9804     286.2079     227.7319      52.1810       0.1870       0.2107       0.2629       5.3873    2589.5522      26.2591     158.7500    4190.0000
 2529.8400      44.4225     100.3587     564.9448     213.7881     123.4132       8.1029     216.0000       0.1163       0.0439       0.0092       5.8174      85.5790     283.9751     219.1682      52.1810       0.1743       0.1967       0.2486       5.2725    2634.8733      35.6135     155.1250    4167.0000
 2529.9924      42.5727      94.8419     435.9272     207.3410     174.3433       5.7358     216.0000       0.1059       0.0327      -0.0025       5.8027      81.8708     275.6021     197.1459      52.1810       0.1462       0.1658       0.2165       5.1532    2654.0645      68.6771     159.6875    4192.0000
 2530.1448      42.7047     103.9512     365.1456     269.9609     206.6462       4.8392     216.0000       0.1187       0.0466       0.0119       5.8377      82.8751     279.5095     177.4075      52.1810       0.1518       0.1717       0.2227       5.0907    2630.3848      96.1292     159.1250    4185.0000
 2530.2972      40.6453     106.2083     355.4727     263.7211     359.6787       2.7803     216.0000       0.1276       0.0562       0.0219       5.5740      82.4691     275.8812     173.0893      52.1810       0.1584       0.1793       0.2305       5.0866    2613.9338      86.0357     159.4375    4184.0000
 2530.4496      40.7263     109.9867     345.5481     346.7477     154.3383       6.4793     216.0000       0.1257       0.0542       0.0198       5.5276      82.3128     272.5320     183.7234      52.1810       0.1569       0.1775       0.2287       5.1331    2617.3687      86.4659     158.6250    4196.0000
 2530.6020      41.9503      93.2209     314.1215     300.3480     176.0502       5.6802     216.0000       0.1251       0.0535       0.0191       5.3622      79.4258     281.7422     202.0879      52.1810       0.1650       0.1866       0.2380       5.2492    2618.5330     103.6534     160.2500    4170.0000
 2530.7544      42.9300      88.5732     243.0180     244.0985     188.6849       5.2998     216.0000       0.1456       0.0756       0.0420       5.4460      79.8319     291.7899     215.8618      52.1810       0.1712       0.1932       0.2450       5.4190    2580.6418      30.3096     160.8125    4165.0000
 2530.9068      43.6080      72.7108     192.4760     199.0383     165.1302       6.0558     216.0000       0.1517       0.0822       0.0489       5.4900      83.8863     291.7899     242.5902      52.1810       0.1675       0.1893       0.2409       5.5525    2569.3669      16.2573     158.6875    4191.0000
 2531.0592      45.6176      61.6274     149.0673     140.4485     149.6749       6.6811     216.0000       0.1547       0.0855       0.0523       5.4774      85.7134     286.2079     251.9283      52.1810       0.1804       0.2037       0.2556       5.6109    2563.7441      15.4642     158.2500    4171.0000
 2531.2116      44.6803      65.0670     146.6458     119.1106     125.6258       7.9601     216.0000       0.1451       0.0751       0.0415       5.5483      80.2723     296.8137     254.4138      52.1810       0.1819       0.2059       0.2576       5.6019    2581.5745      16.0936     158.7500    4231.0000
 2531.3640      42.5060      75.0906     148.0875     114.4624      98.1961      10.1837     216.0000       0.1423       0.0721       0.0383       5.6189      77.2349     290.6735     249.8009      52.1810       0.1633       0.1849       0.2362       5.6030    2586.7852      20.4394     156.3750    4256.0000
 2531.5164      39.7726      92.2814     177.4091     167.6167     114.5769       8.7278     216.0000       0.1499       0.0803       0.0468       5.3697      76.4228     301.0002     247.5817      52.1810       0.1593       0.1803       0.2316       5.6180    2572.7285      20.4230     157.8750    4208.0000
 2531.6688      38.3486     125.1150     163.3410     208.6429     118.6691       8.4268     216.0000       0.1576       0.0887       0.0555       5.5243      83.6407     296.2555     255.3153      52.1810       0.1541       0.1748       0.2256       5.7017    2558.3748      23.1572     159.0625    4214.0000
 2531.8212      41.3884     167.8521     210.6514     262.1727     113.2251       8.8320     216.0000       0.1665       0.0983       0.0655       5.4356      88.4644     309.0941     255.3995      52.1810       0.1938       0.2193       0.2710       5.8116    2541.9280      12.8261     158.3125    4126.0000
 2531.9736      45.6856     180.3801     266.9295     262.1779     123.3264       8.1086     216.0000       0.1623       0.0937       0.0608       5.4067      89.9422     311.8851     265.6650      52.1810       0.2331       0.2633       0.3149       5.9281    2549.7588      10.5528     153.6875    4115.0000
 2532.1260      63.3457     176.5088     437.6635     442.4585     185.4516       5.3922     216.0000       0.1853       0.1186       0.0866       5.4641      93.0974     315.7925     272.7637      52.1810       0.2061       0.2336       0.2851       6.0548    2507.1680      10.7882     158.0625    4182.0000
 2532.2784      63.1758     134.8654     170.4893     140.0655      90.1889      11.0878     216.0000       0.2623       0.2019       0.1729       5.2624      89.4432     326.6774     248.3993      52.1810       0.2079       0.2366       0.2874       6.2000    2364.6697       8.3832     158.4375    4176.0000
 2532.4308      70.0220      77.7988     177.9602     154.5895     150.5178       6.6437     216.0000       0.2883       0.2300       0.2020       5.4558      86.1383     335.8877     239.3701      52.1810       0.2858       0.3211       0.3719       6.1830    2316.6433       6.7992     153.7500    4183.0000
 2532.5832      69.7965      88.6516     378.2651     343.9729     240.0701       4.1654     216.0000       0.2288       0.1657       0.1354       5.3729      81.8226     331.4221     233.0897      52.1810       0.2204       0.2506       0.3013       5.8791    2426.6672       7.5822     152.0000    4182.0000
 2532.7356      54.7758     115.8940     417.3205     406.7509     293.7501       3.4043     216.0000       0.1333       0.0624       0.0283       5.3495      84.3143     294.5809     220.1896      52.1810       0.1776       0.2020       0.2530       5.3831    2603.3206      16.5751     156.3125    4170.0000
 2532.8880      50.6099     125.1334     493.5232     557.5379     336.4436       2.9723     216.0000       0.1061       0.0329      -0.0022       5.5915      88.6362     289.5571     186.1839      52.1810       0.1714       0.1944       0.2457       5.1154    2653.6748      45.7439     151.0625    4164.0000
 2533.0404      47.7108     122.6287     475.8378     619.4941     289.3110       3.4565     216.0000       0.1296       0.0583       0.0241       5.2887      90.2529     298.4883     184.9108      52.1810       0.1591       0.1803       0.2314       5.2361    2610.2954      40.2156     157.7500    4152.0000
 2533.1928      50.7929     108.8662     430.9130     516.6127     247.1527       4.0461     216.0000       0.1681       0.1000       0.0673       5.1973      91.4155     300.4420     216.2406      52.1810       0.1860       0.2106       0.2622       5.6024    2539.0090      22.5566     157.5000    4190.0000
 2533.3452      45.1368      75.1216     251.5743     354.6895     134.1639       7.4536     216.0000       0.2146       0.1503       0.1194       5.1604      88.5680     306.8613     233.9079      52.1810       0.2223       0.2508       0.3028       5.9079    2452.9585      13.3882     159.0000    4170.0000
 2533.4976      50.7389      64.1261     184.1268     269.3501      70.6027      14.1638     216.0000       0.2275       0.1643       0.1339       5.2543      86.5888     303.5121     240.9022      52.1810       0.1997       0.2253       0.2775       5.9484    2429.0425       9.8720     152.5625    4182.0000
 2533.6500      49.3505      74.5920     229.0304     162.6506      77.1624      12.9597     216.0000       0.1963       0.1305       0.0989       5.3501      81.4912     308.5359     247.5977      52.1810       0.1580       0.1790       0.2301       5.7743    2486.7834      12.2669     155.4375    4206.0000
 2533.8024      47.1234      81.4493     268.0981     180.4658     141.0117       7.0916     216.0000       0.1468       0.0769       0.0434       5.3493      82.8591     292.6272     253.2582      52.1810       0.1559       0.1763       0.2275       5.5138    2578.4500      16.4048     156.6250    4174.0000
 2533.9548      50.9988     119.9137     313.8378     325.9812     164.9799       6.0613     216.0000       0.1327       0.0617       0.0276       5.4092      89.1017     304.6285     236.8343      52.1810       0.1451       0.1644       0.2151       5.3354    2604.5244      26.5718     158.8750    4185.0000
 2534.1072      47.0079     109.9954     438.9288     328.5602     197.9471       5.0519     216.0000       0.1392       0.0687       0.0348       5.4065      98.1215     301.8375     223.7389      52.1810       0.1770       0.2001       0.2518       5.2672    2592.5337      19.1245     156.2500    4195.0000
 2534.2596      46.3302      96.1360     230.5798     194.0990     127.3344       7.8533     216.0000       0.1292       0.0579       0.0237       5.3949      96.5502     313.0015     227.7122      52.1810       0.1968       0.2223       0.2743       5.2682    2610.9260      17.9549     154.8750    4235.0000
 2534.4120      54.5165      98.0958     209.5852     194.1065      70.9587      14.0927     216.0000       0.1177       0.0455       0.0108       5.1969      91.5984     314.1179     239.6679      52.1810       0.2123       0.2404       0.2919       5.3346    2632.2336      18.9212     151.0625    4207.0000
 2534.5644      68.0161     141.4370     301.4666     248.9806     124.6305       8.0237     216.0000       0.1041       0.0308      -0.0045       5.2126      87.5305     303.5121     270.5648      52.1810       0.1790       0.2031       0.2544       5.5000    2657.4128      26.7226     154.9375    4255.0000
 2534.7168      68.7201     162.4591     460.2312     356.8568     225.3649       4.4372     216.0000       0.1373       0.0666       0.0327       5.0645      93.7712     306.8613     280.8807      52.1810       0.1794       0.2036       0.2549       5.7496    2596.0840      25.1926     154.7500    4211.0000
 2534.8692      61.1011     157.0938     392.5318     275.1543     197.2557       5.0696     216.0000       0.1455       0.0755       0.0419       4.8655      99.1290     306.8613     307.5645      52.1810       0.2163       0.2443       0.2962       5.9151    2580.8413      22.6488     153.0625    4160.0000
 2535.0216      58.7398     128.1946     282.4620     182.0735     158.5925       6.3055     216.0000       0.1621       0.0935       0.0605       4.8226     102.1799     308.5359     296.7818      52.1810       0.2034       0.2307       0.2821       5.9342    2550.1958      19.5344     155.2500    4192.0000
 2535.1740      58.8075     114.9822     278.8357     169.0721     153.4849       6.5153     216.0000       0.1469       0.0771       0.0435       5.1070      96.4955     295.1391     284.5643      52.1810       0.2117       0.2409       0.2916       5.7927    2578.2419      18.1711     157.0625    4143.0000
 2535.3264      55.2479     108.4094     257.9178     189.5557     153.9570       6.4953     216.0000       0.1477       0.0779       0.0444       5.3226      96.7806     299.6047     250.1800      52.1810       0.2169       0.2459       0.2972       5.6392    2576.7695      16.3493     155.3125    4168.0000
 2535.4788      54.6611     102.8422     231.0387     233.1561     120.1495       8.3230     216.0000       0.1405       0.0701       0.0363       5.4811      96.1085     303.5121     223.4321      52.1810       0.1727       0.1958       0.2471       5.4967    2590.0925      17.5825     160.8125    4152.0000
 2535.6312      59.5725     108.3229     145.6689     112.9613      96.1695      10.3983     216.0000       0.1272       0.0558       0.0214       5.2089     103.8231     299.0465     221.9882      52.1810       0.1749       0.1979       0.2495       5.4212    2614.6494      23.4224     152.1875    4173.0000
 2535.7836      54.0651      99.3156     228.5547     135.0435     107.6770       9.2870     216.0000       0.1471       0.0773       0.0437       5.1165      99.5335     304.0703     212.1635      52.1810       0.2040       0.2301       0.2823       5.4705    2577.8811      23.1271     160.8125    4188.0000
 2535.9360      59.8461     120.3068     298.6074     192.9907     140.8550       7.0995     216.0000       0.1698       0.1018       0.0691       4.8380      95.7309     309.0941     219.2624      52.1810       0.1993       0.2266       0.2776       5.6216    2535.9258      17.0203     156.6250    4196.0000
 2536.0884      65.0508     161.0720     569.6246     370.2232     249.2216       4.0125     216.0000       0.1735       0.1058       0.0733       5.0498      86.3415     304.0703     251.1094      52.1810       0.2082       0.2361       0.2874       5.8259    2529.0176      13.6259     160.8125    4195.0000
 2536.2408      62.4948     187.7530     385.1521     208.6230     140.3776       7.1236     216.0000       0.1468       0.0769       0.0434       5.0829      87.7067     301.5584     302.6221      52.1810       0.1961       0.2228       0.2740       5.9587    2578.4514      14.7715     160.8125    4216.0000
 2536.3932      59.5512     164.2775     549.1118     369.9108     239.3418       4.1781     216.0000       0.1335       0.0625       0.0284       4.9136      91.3062     299.8838     335.5589      52.1810       0.2188       0.2474       0.2991       6.0410    2603.0623      14.4689     160.8125    4159.0000
 2536.5456      57.9561     171.7754     561.3864     379.0190     192.1102       5.2053     216.0000       0.1535       0.0842       0.0509       4.9500     101.9845     286.2079     316.5338      52.1810       0.2212       0.2510       0.3020       6.0779    2566.0237      12.8243     160.8125    4207.0000
 2536.6980      56.5875     157.8199     521.0108     376.7425     249.4911       4.0082     216.0000       0.1483       0.0786       0.0451       5.0311     104.4838     297.9301     303.6246      52.1810       0.2156       0.2445       0.2957       6.0465    2575.6345      10.2027     160.8125    4180.0000
 2536.8504      64.1701     203.7777     561.6892     360.8092     273.1259       3.6613     216.0000       0.1348       0.0639       0.0299       5.1677      99.9090     295.1391     300.6954      52.1810       0.2275       0.2576       0.3089       5.9793    2600.6782      12.2297     160.8125    4219.0000
 2537.0028      66.7864     170.9003     435.5790     290.9064     267.0257       3.7450     216.0000       0.1303       0.0591       0.0249       4.8747      95.4343     277.5558     312.9499      52.1810       0.1638       0.1867       0.2373       5.9342    2608.8550      16.5761     159.0000    4236.0000
 2537.1552      71.5824     142.6128     326.7054     209.6744     217.1751       4.6046     216.0000       0.1467       0.0769       0.0433       5.0072      94.7004     269.1827     310.4277      52.1810       0.1845       0.2090       0.2606       5.9240    2578.5642      20.3109     162.2500    4173.0000
 2537.3076      60.0121     117.6526     245.1295     127.3328     168.7784       5.9249     216.0000       0.1314       0.0603       0.0261       4.9819     100.3538     283.9751     299.0446      52.1810       0.2142       0.2410       0.2935       5.8010    2606.9539      21.9456     160.8125    4231.0000
 2537.4600      56.1255      92.6314     167.5855     112.9863     128.7678       7.7659     216.0000       0.0987       0.0249      -0.0106       5.0526      97.3028     271.1364     265.7561      52.1810       0.1757       0.1987       0.2503       5.5206    2667.4553      36.0137     160.8750    4247.0000
 2537.6124      54.6808     130.5930     190.4410     131.2806     114.0458       8.7684     216.0000       0.0779       0.0024      -0.0339       4.7880      88.0258     269.4618     218.8170      52.1810       0.1670       0.1895       0.2407       5.2044    2705.9160      67.8643     162.1250    4221.0000
 2537.7648      54.1621     121.4552     212.9404     151.2530     113.8433       8.7840     216.0000       0.0850       0.0101      -0.0259       4.7421      79.8748     265.5544     191.4544      52.1810       0.1586       0.1795       0.2307       5.0729    2692.7642     114.0145     164.1875    4228.0000
 2537.9172      49.3595     133.7478     214.9446     166.9985     108.8538       9.1866     216.0000       0.0972       0.0233      -0.0122       4.6491      79.6151     267.7872     201.7906      52.1810       0.1437       0.1628       0.2134       5.1676    2670.1704     138.9279     163.8750    4284.0000
 2538.0696      53.0823     129.7019     228.0988     176.4677     112.3136       8.9036     216.0000       0.1187       0.0466       0.0119       4.8484      88.3448     266.9500     229.2850      52.1810       0.1548       0.1750       0.2262       5.3997    2630.3762      47.3281     164.7500    4252.0000
 2538.2220      52.1179     107.1400     189.8025     173.0967      97.6434      10.2413     216.0000       0.1268       0.0554       0.0210       4.7607      91.6143     282.8586     257.9355      52.1810       0.1967       0.2221       0.2741       5.5948    2615.3491      29.3147     165.4375    4280.0000
 2538.3744      63.6619      93.9515     175.4125     153.0818      79.5410      12.5721     216.0000       0.1282       0.0568       0.0225       4.8702      88.7721     292.9063     270.2889      52.1810       0.1942       0.2199       0.2716       5.6821    2612.9202      23.1414     162.5000    4273.0000
 2538.5268      76.1984     118.1667     246.3834     170.1341     126.5881       7.8996     216.0000       0.1281       0.0567       0.0224       4.7688      84.4314     286.7661     274.0664      52.1810       0.1934       0.2191       0.2707       5.7085    2612.9934      20.7286     165.1875    4218.0000
 2538.6792      77.8547     193.4405     289.5349     225.9880     181.7659       5.5016     216.0000       0.1375       0.0669       0.0330       4.8237      83.5650     275.8812     270.6826      52.1810       0.1816       0.2057       0.2572       5.7251    2595.5732      19.2405     165.1250    4182.0000
 2538.8316      63.7912     140.3270     257.3545     148.7640     174.8319       5.7198     216.0000       0.1341       0.0632       0.0291       4.4421      95.7459     271.6946     275.9120      52.1810       0.1790       0.2025       0.2542       5.7335    2601.9429      17.3563     166.3125    4184.0000
 2538.9840      54.4513     119.4956     287.3775     171.2518     159.0778       6.2862     216.0000       0.1159       0.0436       0.0088       4.7019     100.7577     285.0915     273.8373      52.1810       0.1922       0.2175       0.2692       5.6884    2635.5005      23.7278     166.7500    4201.0000
 2539.1364      59.9066     121.3138     232.6189     149.8207     144.2591       6.9320     216.0000       0.1153       0.0429       0.0081       4.5764     101.2173     283.4169     257.4742      52.1810       0.2077       0.2344       0.2865       5.6718    2636.6794      34.1938     167.7500    4201.0000
 2539.2888      59.8854     132.9145     248.5669     170.8641     128.9749       7.7534     216.0000       0.1187       0.0465       0.0118       4.2706      92.8937     285.6496     257.9501      52.1810       0.1978       0.2242       0.2757       5.7482    2630.4773      55.8876     168.4375    4193.0000
 2539.4412      54.7083     133.7717     256.9886     191.7981     115.1653       8.6832     216.0000       0.1262       0.0547       0.0203       4.6535      83.6444     269.4618     290.8545      52.1810       0.1649       0.1873       0.2383       5.9356    2616.4380      82.3731     169.6250    4263.0000
 2539.5936      52.7179     111.2409     245.9852     204.9474     111.4788       8.9703     216.0000       0.1301       0.0589       0.0247       4.6136      83.9968     277.2766     345.0360      52.1810       0.1877       0.2128       0.2642       6.1704    2609.2832      60.4937     169.6250    4268.0000
 2539.7460      53.6926     102.0657     250.6293     219.3688     112.1125       8.9196     216.0000       0.1510       0.0815       0.0481       4.8276      89.3433     283.6960     372.5476      52.1810       0.1937       0.2192       0.2710       6.3589    2570.6624      38.2380     169.6875    4244.0000
 2539.8984      57.5386     119.1623     368.6636     308.6386     139.7976       7.1532     216.0000       0.1606       0.0918       0.0588       4.7903      96.7620     287.6034     376.9076      52.1810       0.2207       0.2500       0.3013       6.4021    2552.9697      26.6919     168.9375    4278.0000
 2540.0508      62.9427     147.2347     457.0539     410.4029     251.5930       3.9747     216.0000       0.1485       0.0788       0.0453       4.4286     101.4313     287.8825     365.5274      52.1810       0.2098       0.2385       0.2894       6.2973    2575.3096      27.2470     169.0625    4274.0000
 2540.2032      56.8508     133.5409     562.3500     424.0592     272.5450       3.6691     216.0000       0.1400       0.0696       0.0358       4.2666      95.6789     287.8825     336.2513      52.1810       0.1901       0.2164       0.2673       6.1158    2590.9849      28.1522     169.4375    4209.0000
 2540.3556      56.5806     106.7671     482.4319     352.7395     276.9138       3.6112     216.0000       0.1344       0.0635       0.0294       4.2909     103.5774     292.9063     316.4685      52.1810       0.2278       0.2570       0.3090       5.9925    2601.4456      32.6291     170.3125    4262.0000
 2540.5080      59.1738     123.1150     563.4088     307.3744     283.4753       3.5276     216.0000       0.1410       0.0706       0.0368       4.5740     105.4710     304.6285     301.4011      52.1810       0.1870       0.2114       0.2632       5.9533    2589.2185      35.6056     170.6250    4209.0000
 2540.6604      62.4579     131.6243     570.2919     305.1957     267.7320       3.7351     216.0000       0.1457       0.0758       0.0422       4.3564     109.1896     295.1391     303.9341      52.1810       0.1827       0.2069       0.2585       5.9850    2580.4294      39.5605     167.7500    4241.0000
 2540.8128      57.3601     164.7802     543.9104     269.6014     218.5421       4.5758     216.0000       0.1505       0.0809       0.0475       4.4435     103.8717     284.5333     301.2500      52.1810       0.1887       0.2138       0.2653       6.0220    2571.6252      40.4686     170.6250    4216.0000
 2540.9652      57.0217     169.7737     347.3545     191.1918     150.6733       6.6369     216.0000       0.1388       0.0683       0.0344       4.2320     100.1509     272.2528     299.7189      52.1810       0.2074       0.2349       0.2865       6.0154    2593.2466      42.8402     170.6250    4190.0000
 2541.1176      53.1444     162.6474     430.9163     195.0256     150.6036       6.6399     216.0000       0.1163       0.0439       0.0091       4.0720      99.3373     272.8111     304.5611      52.1810       0.1972       0.2235       0.2750       5.9671    2634.9243      72.1193     170.8750    4224.0000
 2541.2700      53.0142     154.2901     420.0386     227.5620     142.6093       7.0122     216.0000       0.1051       0.0318      -0.0034       4.1195      99.8076     269.4618     317.3540      52.1810       0.1723       0.1958       0.2468       5.9543    2655.5984      70.5735     170.6250    4219.0000
 2541.4224      48.3820     109.5022     243.4243     177.6097     116.3292       8.5963     216.0000       0.1097       0.0368       0.0017       3.8945     102.6498     268.3454     334.2595      52.1810       0.1938       0.2197       0.2712       6.0098    2647.1289      44.0203     171.1250    4247.0000
 2541.5748      44.2728      84.5563     184.8541     156.0813      90.3128      11.0726     216.0000       0.1002       0.0266      -0.0088       4.1258     106.3018     286.4870     360.6608      52.1810       0.2020       0.2284       0.2802       6.0633    2664.5647      34.8243     170.7500    4246.0000
 2541.7272      43.7851      76.7806     172.1157     129.9990      82.9202      12.0598     216.0000       0.0885       0.0139      -0.0219       4.3287     105.5656     275.3229     372.8137      52.1810       0.2054       0.2328       0.2843       6.0937    2686.2029      35.2229     170.7500    4241.0000
 2541.8796      45.1605      80.4716     189.4745     136.1169      97.4878      10.2577     216.0000       0.0898       0.0152      -0.0206       4.2726     101.3593     279.5095     373.1454      52.1810       0.2064       0.2332       0.2851       6.1136    2683.9590      43.3003     171.4375    4231.0000
 2542.0320      45.7054      93.9432     229.7583     170.2962     130.1499       7.6834     216.0000       0.1061       0.0329      -0.0023       4.2979      99.7413     278.3931     370.8503      52.1810       0.1735       0.1971       0.2482       6.1886    2653.7310      47.9216     171.6875    4239.0000
 2542.1844      45.1085     105.1482     246.0793     167.9070     153.2725       6.5243     216.0000       0.1139       0.0413       0.0065       4.5165     100.4132     277.2766     383.0075      52.1810       0.1956       0.2217       0.2732       6.2670    2639.3269      40.8674     170.6250    4201.0000
 2542.3368      45.0485     115.0695     276.2751     185.0456     162.4203       6.1569     216.0000       0.0987       0.0249      -0.0105       4.6284     103.8600     279.5095     401.3002      52.1810       0.2105       0.2382       0.2898       6.3026    2667.4021      38.3906     170.6250    4213.0000
 2542.4892      45.1541     124.5525     310.2899     254.9760     189.3286       5.2818     216.0000       0.0798       0.0045      -0.0317       4.3317     106.8387     269.4618     414.0642      52.1810       0.2040       0.2317       0.2828       6.2901    2702.3308      40.0723     171.8750    4165.0000
 2542.6416      44.6134      99.5463     273.9074     245.0069     151.8933       6.5836     216.0000       0.0864       0.0116      -0.0244       4.0610     102.7784     271.1364     406.2579      52.1810       0.1851       0.2105       0.2615       6.2849    2690.1887      49.9101     172.8125    4244.0000
 2542.7940      43.3774      86.8857     214.0165     195.7161     140.8571       7.0994     216.0000       0.1045       0.0311      -0.0041       3.8483     104.0097     280.0677     402.2734      52.1810       0.2312       0.2613       0.3129       6.3097    2656.7349      43.9320     172.6250    4244.0000
 2542.9464      40.8650      75.3351     200.2521     187.5788     138.1839       7.2367     216.0000       0.1090       0.0361       0.0011       3.2658     104.2853     279.5095     413.7347      52.1810       0.2017       0.2283       0.2800       6.3447    2648.2666      47.0562     171.7500    4249.0000
 2543.0988      41.8769      77.2499     206.5048     172.2290     145.3051       6.8821     216.0000       0.1056       0.0324      -0.0028       3.7943     106.4579     276.7184     424.3312      52.1810       0.1940       0.2197       0.2714       6.3669    2654.5896      46.4581     173.8750    4245.0000
 2543.2512      43.4805      86.2432     215.5155     157.4702     157.4926       6.3495     216.0000       0.0916       0.0172      -0.0185       3.9852     105.4409     272.5320     437.4008      52.1810       0.1742       0.1974       0.2488       6.3583    2680.5386      60.9135     173.1875    4241.0000
 2543.4036      45.9069     103.4012     228.8120     169.3391     162.8441       6.1408     216.0000       0.0893       0.0148      -0.0210       4.2917     102.1866     271.6946     431.7472      52.1810       0.1715       0.1942       0.2456       6.3312    2684.7134      59.4956     174.6250    4192.0000
 2543.5560      48.5609     127.3715     287.8236     171.6085     198.9930       5.0253     216.0000       0.0778       0.0023      -0.0339       3.7608      99.7030     270.0200     427.8841      52.1810       0.1663       0.1880       0.2395       6.2551    2706.0100      65.6369     174.4375    4241.0000
 2543.7084      49.7258     160.4078     345.8013     259.7356     207.6868       4.8149     216.0000       0.0754      -0.0003      -0.0367       3.9282     100.9233     276.1603     412.4381      52.1810       0.1833       0.2067       0.2588       6.1699    2710.5220      58.6928     175.0000    4303.0000
 2543.8608      52.3847     141.7230     311.8615     279.7266     164.5077       6.0787     216.0000       0.0779       0.0024      -0.0338       3.5985      96.3905     276.1603     395.4373      52.1810       0.1747       0.1977       0.2493       6.0748    2705.8127      48.8454     174.5625    4283.0000
 2544.0132      51.4017     119.6074     262.0507     205.6414     130.1463       7.6837     216.0000       0.0866       0.0118      -0.0241       3.6959      98.9347     275.8812     381.5925      52.1810       0.1835       0.2080       0.2595       6.0220    2689.7371      36.4448     174.5625    4271.0000
 2544.1656      51.1490     112.7095     250.6242     187.1579     102.9985       9.7089     216.0000       0.0910       0.0166      -0.0191       3.8705      94.0532     272.8111     369.8730      52.1810       0.1833       0.2078       0.2592       5.9569    2681.5737      31.2507     173.2500    4230.0000
 2544.3180      59.3498     133.7746     337.4465     179.6294     124.6566       8.0220     216.0000       0.0897       0.0152      -0.0206       3.7624      89.9929     277.8349     354.2442      52.1810       0.1807       0.2044       0.2561       5.8674    2684.0410      30.9613     173.3125    4197.0000
 2544.4704      68.6201     162.6272     406.2303     207.3114     156.3174       6.3972     216.0000       0.0776       0.0020      -0.0342       3.8706      84.0241     281.1841     331.3687      52.1810       0.1769       0.1997       0.2516       5.7176    2706.4968      38.3668     173.6250    4205.0000
 2544.6228      76.9803     218.6033     523.1094     213.7683     275.4702       3.6302     216.0000       0.0643      -0.0123      -0.0491       3.6646      84.5762     275.6021     297.6653      52.1810       0.1331       0.1506       0.2008       5.5330    2730.9827      61.8078     172.9375    4207.0000
 2544.7752      73.5416     212.6772     508.1101     204.9141     209.4227       4.7750     216.0000       0.0613      -0.0156      -0.0525       3.8149      86.6063     273.9275     265.0666      52.1810       0.1540       0.1739       0.2252       5.4065    2736.6016      98.3996     172.2500    4223.0000
 2544.9276      69.1156     187.9057     424.1590     218.8396     147.9386       6.7596     216.0000       0.0627      -0.0141      -0.0510       3.9048      85.1103     273.6484     255.0290      52.1810       0.1454       0.1643       0.2152       5.3895    2734.0842     165.4206     170.6250    4229.0000
 2545.0800      63.1337     167.2294     378.3738     221.7146     121.6779       8.2184     216.0000       0.0805       0.0052      -0.0310       4.2327      78.6598     273.3693     268.2512      52.1810       0.1445       0.1635       0.2143       5.5326    2701.0676     149.3086     170.6250    4241.0000
 2545.2324      55.5456     180.3767     255.9562     175.5952     112.3503       8.9007     216.0000       0.0867       0.0119      -0.0240       3.9637      79.6748     277.2766     307.6877      52.1810       0.1378       0.1561       0.2065       5.7212    2689.5884      82.9528     170.6250    4281.0000
 2545.3848      53.1612     127.7134     253.3948     173.2350     109.9297       9.0967     216.0000       0.0835       0.0085      -0.0275       4.0244      85.7185     281.1841     353.4293      52.1810       0.1686       0.1910       0.2423       5.8947    2695.4487      42.9757     170.6250    4240.0000
 2545.5372      61.2734     150.1569     366.2078     237.4613     140.8933       7.0976     216.0000       0.0949       0.0208      -0.0148       3.6236      95.4555     303.5121     370.7056      52.1810       0.1976       0.2230       0.2751       6.0204    2674.4177      28.9540     170.6250    4276.0000
 2545.6896      71.8587     189.6017     436.3599     347.2375     235.9577       4.2380     216.0000       0.1266       0.0551       0.0208       3.4056      99.3762     294.0227     354.3689      52.1810       0.2114       0.2387       0.2907       6.1120    2615.7136      21.8962     170.1875    4279.0000
 2545.8420      73.6175     157.0556     426.1611     335.0548     187.0107       5.3473     216.0000       0.1500       0.0804       0.0470       3.3988     102.6887     296.8137     328.0797      52.1810       0.1996       0.2255       0.2775       6.1225    2572.5198      22.5537     170.6250    4224.0000
 2545.9944      76.6228     138.8085     392.0994     311.6469     208.0089       4.8075     216.0000       0.1419       0.0716       0.0379       3.7637     108.1320     304.0703     314.9543      52.1810       0.2100       0.2377       0.2894       6.0375    2587.5339      24.4890     166.1250    4209.0000
 2546.1468      84.8443     158.8061     483.9551     321.8336     303.8176       3.2914     216.0000       0.1203       0.0483       0.0137       3.5874     112.5348     292.3481     310.3006      52.1810       0.2057       0.2331       0.2846       5.9276    2627.4673      27.3344     170.4375    4241.0000
 2546.2992      84.9363     209.1999     446.8522     374.1996     303.5156       3.2947     216.0000       0.1073       0.0342      -0.0009       3.8995     111.1163     293.4644     304.9879      52.1810       0.1944       0.2211       0.2721       5.8507    2651.5449      29.6299     168.5625    4239.0000
 2546.4516      69.0485     227.6451     455.2429     434.8367     269.1354       3.7156     216.0000       0.1249       0.0532       0.0188       3.8044     107.3263     272.2528     296.1919      52.1810       0.2058       0.2334       0.2848       5.8792    2618.9583      37.0173     168.8125    4281.0000
 2546.6040      64.6670     153.4898     242.7735     208.4869     194.1874       5.1497     216.0000       0.1398       0.0694       0.0355       3.6602     104.1438     290.6735     306.3738      52.1810       0.1940       0.2198       0.2714       5.9667    2591.3857      32.5513     170.6250    4195.0000
 2546.7564      56.4550     115.2072     172.7892     145.6153     113.1957       8.8343     216.0000       0.1486       0.0789       0.0454       3.9092     107.1222     289.8362     322.7558      52.1810       0.1611       0.1828       0.2338       6.0780    2575.0386      29.0490     169.0625    4240.0000
 2546.9088      57.6979     107.9981     156.8131     139.4202      96.5914      10.3529     216.0000       0.1346       0.0637       0.0296       3.4784     107.0549     276.1603     345.4432      52.1810       0.1987       0.2243       0.2764       6.1277    2601.0786      24.8465     170.6250    4253.0000
 2547.0612      56.2019     101.3386     146.4108     116.7976      84.5579      11.8262     216.0000       0.1278       0.0564       0.0221       3.1301     106.2888     278.3931     359.5724      52.1810       0.1793       0.2030       0.2546       6.1536    2613.4951      26.5654     170.6250    4182.0000
 2547.2136      57.8147      99.4716     143.1149      98.9684      79.5104      12.5770     216.0000       0.1388       0.0683       0.0344       3.1486     106.8979     287.8825     367.8081      52.1810       0.1897       0.2146       0.2664       6.1859    2593.2014      21.4520     170.6250    4205.0000
 2547.3660      62.0590     107.2754     159.2029     106.2362      92.8068      10.7751     216.0000       0.1472       0.0774       0.0438       3.3003     102.6938     279.5095     375.9463      52.1810       0.1897       0.2149       0.2665       6.2343    2577.6570      16.6891     170.6250    4269.0000
 2547.5184      70.3603     127.5277     183.8600     122.6532     102.8507       9.7228     216.0000       0.1409       0.0705       0.0367       3.3486     101.4260     290.1153     369.3056      52.1810       0.1909       0.2162       0.2678       6.1727    2589.3923      14.2749     170.6250    4221.0000
 2547.6708      70.3627     138.3817     207.5411     122.6958     120.2121       8.3186     216.0000       0.1251       0.0535       0.0191       3.8230      94.8735     290.1153     359.2417      52.1810       0.1851       0.2096       0.2612       6.0320    2618.5242      16.6345     170.6250    4268.0000
 2547.8232      65.1652     122.1960     187.8390     125.4080     110.1608       9.0776     216.0000       0.1073       0.0343      -0.0009       3.3641      98.3312     276.1603     339.3376      52.1810       0.1905       0.2160       0.2674       5.8241    2651.4263      27.7967     170.6250    4221.0000
 2547.9756      68.4221     127.3116     195.9530     140.2234     112.3924       8.8974     216.0000       0.0913       0.0169      -0.0189       3.3997      99.7576     280.6259     313.8220      52.1810       0.1962       0.2218       0.2737       5.6315    2681.1438      62.9417     170.6250    4221.0000
 2548.1280      76.9656     175.5642     236.1753     147.9416     122.9355       8.1343     216.0000       0.0925       0.0182      -0.0175       3.7800     102.3106     282.3004     253.0367      52.1810       0.1631       0.1848       0.2360       5.4278    2678.8994      48.3181     171.3125    4231.0000
 2548.2804      70.5131     172.9451     251.0898     156.8289     124.1872       8.0524     216.0000       0.1063       0.0332      -0.0020       3.5661     104.1412     286.7661     192.8928      52.1810       0.1858       0.2099       0.2618       5.2581    2653.3049      32.1467     172.2500    4238.0000
 2548.4328      76.8208     192.9512     275.7808     156.0139     124.9962       8.0002     216.0000       0.1399       0.0695       0.0356       3.5500     102.2468     286.2079     162.1351      52.1810       0.1906       0.2161       0.2676       5.2444    2591.2312      20.3621     172.4375    4215.0000
 2548.5852      78.9337     223.3731     338.4395     185.3728     137.0620       7.2960     216.0000       0.1571       0.0881       0.0549       3.6667     104.4192     283.9751     183.8703      52.1810       0.2044       0.2316       0.2831       5.3785    2559.3826      14.8787     171.8750    4236.0000
 2548.7376      88.2974     262.6534     337.4084     209.7881     137.3737       7.2794     216.0000       0.1461       0.0762       0.0426       3.3482     101.3682     282.8586     227.1955      52.1810       0.2076       0.2351       0.2867       5.5522    2579.7356      15.8440     172.1250    4218.0000
 2548.8900     100.1253     309.5011     470.7190     230.1495     164.3239       6.0855     216.0000       0.1162       0.0439       0.0091       3.1287      99.3955     288.7198     248.0652      52.1810       0.1793       0.2032       0.2546       5.6191    2634.9429      22.8025     170.6250    4270.0000
 2549.0424     102.6669     328.8928     562.3701     273.2387     167.6624       5.9644     216.0000       0.0973       0.0234      -0.0121       3.3620      88.1857     273.9275     251.8911      52.1810       0.1868       0.2110       0.2629       5.6378    2669.9998      54.0680     171.0625    4276.0000
 2549.1948      92.4600     477.5588     680.0458     352.7918     243.3375       4.1095     216.0000       0.1255       0.0539       0.0194       3.4996      80.9649     279.5095     250.5140      52.1810       0.1502       0.1700       0.2210       5.7545    2617.9153      69.1044     174.5625    4274.0000
 2549.3472      93.5237     341.2766    1102.7622     634.1557     346.9164       2.8825     216.0000       0.1962       0.1304       0.0988       3.4955      79.0804     265.5544     253.1850      52.1810       0.1706       0.1928       0.2445       6.0385    2486.9998      17.3321     175.2500    4309.0000
 2549.4996      79.5869     253.2096     544.0063     243.1226     196.0990       5.0995     216.0000       0.2144       0.1500       0.1191       3.5258      86.0839     272.8111     300.2465      52.1810       0.1548       0.1756       0.2265       6.2793    2453.4397      12.0584     176.6875    4214.0000
 2549.6520      67.6750     125.3365     236.2053     173.7936     133.5610       7.4872     216.0000       0.1778       0.1105       0.0781       3.2098      91.0673     281.1841     352.1507      52.1810       0.1888       0.2135       0.2654       6.3380    2521.0652      12.7668     172.3750    4220.0000
 2549.8044      71.2688     122.5218     242.2173     195.6890     138.7237       7.2086     216.0000       0.1033       0.0299      -0.0053       3.0312      93.8019     282.5796     398.3750      52.1810       0.1941       0.2197       0.2714       6.1809    2658.8269      28.8636     172.3750    4273.0000
 2549.9568      73.0161     116.4784     247.5582     189.8380     160.1843       6.2428     216.0000       0.0877       0.0130      -0.0229       3.2026      98.8203     271.6946     383.1491      52.1810       0.2040       0.2307       0.2825       6.0212    2687.8469      50.9281     172.4375    4207.0000
 2550.1092      68.2927     103.0016     197.4860     153.1702     135.5070       7.3797     216.0000       0.0936       0.0194      -0.0163       3.5390      99.1670     279.5095     359.4756      52.1810       0.1890       0.2138       0.2656       5.9027    2676.9099      52.7775     172.5625    4284.0000
 2550.2616      66.3619     102.7619     169.1548     115.7029     121.3523       8.2405     216.0000       0.1016       0.0281      -0.0072       3.4484     105.6391     267.2290     335.1090      52.1810       0.1650       0.1870       0.2382       5.8223    2661.9517      47.4586     172.1250    4318.0000
 2550.4140      75.9675     130.3138     175.0672     109.3740     122.2320       8.1812     216.0000       0.0870       0.0123      -0.0236       3.8564     101.0276     278.9513     314.4000      52.1810       0.1663       0.1882       0.2396       5.7060    2688.9795      46.4483     172.1875    4336.0000
 2550.5664      81.1468     162.9862     256.5447     141.9843     153.0590       6.5334     216.0000       0.0744      -0.0014      -0.0378       3.2236     100.5140     270.0200     278.6374      52.1810       0.1819       0.2056       0.2574       5.5836    2712.3462      47.5063     172.3750    4326.0000
 2550.7188      82.5231     182.6563     256.7609     131.0573     113.9977       8.7721     216.0000       0.0695      -0.0067      -0.0433       3.1851      98.2766     267.7872     247.1087      52.1810       0.1780       0.2013       0.2530       5.5086    2721.4341      60.8005     172.8125    4317.0000
 2550.8712      78.7124     175.7893     202.5498     117.2153     101.4365       9.8584     216.0000       0.0854       0.0105      -0.0254       3.2840      95.7296     263.8798     240.1369      52.1810       0.1782       0.2019       0.2534       5.5928    2691.9766      59.7063     170.8750    4255.0000
 2551.0236      72.7921     155.3326     193.9148     125.6535     109.3617       9.1440     216.0000       0.1097       0.0368       0.0018       3.2618      95.8965     266.6708     265.4889      52.1810       0.1809       0.2050       0.2565       5.8113    2647.0222      36.4711     171.3125    4248.0000
 2551.1760      66.8107     122.2493     184.0959     127.6673     110.9838       9.0103     216.0000       0.1469       0.0770       0.0435       3.3882      93.2524     263.3217     299.2242      52.1810       0.1894       0.2147       0.2662       6.1005    2578.2737      21.0732     171.0625    4219.0000
 2551.3284      64.6668     101.9669     163.8203     127.8293     108.4769       9.2185     216.0000       0.1644       0.0959       0.0631       3.5998      96.5536     262.7634     336.2260      52.1810       0.2012       0.2280       0.2796       6.3095    2545.9292      14.3316     170.6250    4216.0000
 2551.4808      62.2277      92.4050     133.6806     135.9493      94.2692      10.6079     216.0000       0.1558       0.0867       0.0535       3.7376     100.1755     280.6259     360.5993      52.1810       0.2242       0.2524       0.3047       6.3764    2561.7400      13.5798     172.0000    4240.0000
 2551.6332      77.5915      80.4843     138.9702     103.8080      86.5694      11.5514     216.0000       0.1180       0.0458       0.0111       3.0626      98.0834     271.9737     376.9727      52.1810       0.1821       0.2070       0.2581       6.2891    2631.6804      16.6876     170.6250    4244.0000
 2551.7856      72.2288     104.5568     177.1184      86.1973      87.5940      11.4163     216.0000       0.0996       0.0259      -0.0095       2.6643     100.9256     286.2079     366.8580      52.1810       0.1795       0.2036       0.2550       6.1483    2665.7373      23.4320     171.6875    4300.0000
 2551.9380      87.8562     165.3826     260.7127     187.1084     138.1855       7.2366     216.0000       0.1028       0.0293      -0.0060       2.5845      95.0664     292.9063     349.7880      52.1810       0.1972       0.2237       0.2751       6.0631    2659.8860      24.9267     171.0000    4250.0000
 2552.0904     101.7607     224.5874     391.3278     242.9830     172.1415       5.8092     216.0000       0.1093       0.0364       0.0013       3.1910     100.0060     293.4644     339.7453      52.1810       0.2157       0.2438       0.2956       6.0550    2647.7944      23.8694     171.5000    4242.0000
 2552.2428      98.7648     240.6806     543.8189     379.8459     204.3669       4.8932     216.0000       0.1078       0.0347      -0.0004       2.6435      97.5204     294.5809     338.5489      52.1810       0.2028       0.2295       0.2812       6.0669    2650.6609      27.8054     170.6250    4281.0000
 2552.3952      73.9558     160.2224     309.5940     192.8582     124.9091       8.0058     216.0000       0.1059       0.0327      -0.0025       2.5620     101.5256     283.6960     339.3028      52.1810       0.1828       0.2071       0.2586       6.1001    2654.0669      45.3714     170.3750    4238.0000
 2552.5476      57.7488     108.3678     171.4309     124.2864      83.2143      12.0172     216.0000       0.1019       0.0283      -0.0070       2.7581      98.6161     291.7899     334.5027      52.1810       0.1715       0.1940       0.2456       6.1197    2661.5334      66.1705     170.6250    4247.0000
 2552.7000      66.6675     139.0951     335.4601     188.6075     132.0882       7.5707     216.0000       0.1208       0.0489       0.0143       2.9721      97.9120     295.1391     301.5728      52.1810       0.1559       0.1767       0.2277       6.1551    2626.4338      68.4487     167.3125    4261.0000
 2552.8524      78.5147     225.8284     385.5887     282.1790     170.7637       5.8560     216.0000       0.1467       0.0768       0.0432       3.2901      91.2627     294.0227     260.9384      52.1810       0.1888       0.2137       0.2654       6.1594    2578.6804      19.3692     170.6250    4209.0000
 2553.0048      81.7521     211.1101     315.8940     168.6468     162.7963       6.1426     216.0000       0.1714       0.1035       0.0709       3.6422      92.0548     293.4644     245.7089      52.1810       0.1851       0.2099       0.2613       6.2296    2532.9663      12.0540     169.0625    4222.0000
 2553.1572      74.9309     167.7191     317.0559     168.8205     141.0054       7.0919     216.0000       0.1554       0.0863       0.0531       3.8638      96.0565     298.7674     292.3427      52.1810       0.2267       0.2558       0.3077       6.3426    2562.4485      11.1111     169.6875    4249.0000
 2553.3096      74.7558     142.4493     303.9960     208.3829     173.9098       5.7501     216.0000       0.1415       0.0712       0.0374       3.4920     100.4727     291.7899     358.2258      52.1810       0.2015       0.2275       0.2795       6.5296    2588.2266      17.1890     166.5625    4238.0000
 2553.4620      61.3546     138.0051     269.0337     205.3855     144.2252       6.9336     216.0000       0.1506       0.0811       0.0476       3.1791      96.6916     282.3004     397.1219      52.1810       0.1561       0.1774       0.2281       6.6988    2571.3853      18.0953     166.1250    4278.0000
 2553.6144      53.2857     116.8805     239.4756     206.3176     150.2691       6.6547     216.0000       0.1953       0.1295       0.0978       2.5228      93.7068     287.8825     384.3911      52.1810       0.1863       0.2114       0.2627       6.8723    2488.6353      10.9958     164.8125    4319.0000
 2553.7668      65.5641     132.8578     316.8562     239.8283     197.4497       5.0646     216.0000       0.2190       0.1551       0.1244       2.7290      96.5491     301.8375     358.2661      52.1810       0.2116       0.2388       0.2909       6.9217    2444.7720       7.5174     161.1250    4302.0000
 2553.9192      73.5606     205.7834     329.9236     249.6471     203.4374       4.9155     216.0000       0.2054       0.1404       0.1091       3.1022      96.9140     299.0465     352.7451      52.1810       0.2142       0.2428       0.2942       6.8564    2469.9382       8.3455     162.9375    4278.0000
 2554.0716      86.6450     191.6880     404.4306     294.0058     268.3986       3.7258     216.0000       0.1728       0.1051       0.0725       3.3003     100.5079     307.6986     365.7248      52.1810       0.1724       0.1961       0.2470       6.6940    2530.3486      10.7804     163.1250    4246.0000
 2554.2240      64.3177     131.0279     228.9120     139.7725     127.5429       7.8405     216.0000       0.1448       0.0748       0.0411       3.3491      98.8838     311.3269     385.6585      52.1810       0.2242       0.2535       0.3051       6.5600    2582.1677      16.5222     162.2500    4247.0000
 2554.3764      80.7629     160.3529     341.4526     234.4206     214.6440       4.6589     216.0000       0.1407       0.0703       0.0365       3.4589      97.7052     304.0703     388.2954      52.1810       0.2075       0.2353       0.2867       6.5003    2589.7781      17.0101     161.0000    4257.0000
 2554.5288      89.7214     289.2658     770.9542     331.6772     325.8302       3.0691     216.0000       0.1267       0.0552       0.0209       3.3638      98.4400     292.3481     395.6246      52.1810       0.1913       0.2166       0.2683       6.4596    2615.5581      24.3571     161.0000    4213.0000
 2554.6812      75.2580     342.2813     989.8976     411.8776     461.3759       2.1674     216.0000       0.1164       0.0441       0.0093       3.2032     102.3654     274.4857     396.6599      52.1810       0.1987       0.2251       0.2767       6.4098    2634.5820      27.1192     160.8125    4230.0000
 2554.8336      72.5380     318.4101     562.8058     232.5736     344.8228       2.9000     216.0000       0.1175       0.0452       0.0105       2.7094     106.3709     268.9037     399.9576      52.1810       0.1903       0.2159       0.2673       6.3825    2632.6982      18.1310     160.8125    4249.0000
 2554.9860      72.2066     161.3016     303.5815     216.0130     169.3117       5.9063     216.0000       0.1222       0.0503       0.0158       2.8674     102.5909     270.0200     403.6603      52.1810       0.2202       0.2499       0.3009       6.3824    2623.9734      17.4467     160.8125    4230.0000
 2555.1384      71.3084     131.5624     241.1872     216.4338     121.3336       8.2417     216.0000       0.1202       0.0482       0.0136       3.0302      95.6754     274.7647     411.3617      52.1810       0.2236       0.2533       0.3046       6.3875    2627.6072      18.9245     160.8125    4237.0000
 2555.2908      78.3683     129.7253     242.2567     179.7662      93.8697      10.6531     216.0000       0.1103       0.0374       0.0024       3.1900      98.1211     281.1841     408.8454      52.1810       0.1943       0.2204       0.2718       6.3602    2645.9924      29.4723     159.5625    4183.0000
 2555.4432      81.8235     169.2508     319.0511     190.6275     137.4561       7.2751     216.0000       0.0919       0.0176      -0.0182       3.2644      96.1488     273.9275     409.1292      52.1810       0.1826       0.2069       0.2584       6.3020    2679.9570      35.4275     160.8125    4167.0000
 2555.5956      96.4063     245.7576     594.3567     297.5397     192.5951       5.1922     216.0000       0.0823       0.0071      -0.0290       3.0916      96.9057     261.6470     406.4009      52.1810       0.1919       0.2172       0.2689       6.2517    2697.7932      41.8758     160.8125    4187.0000
 2555.7480      86.7062     267.0375     480.0151     379.8919     265.5091       3.7663     216.0000       0.0857       0.0109      -0.0251       2.8839      89.1816     271.6946     403.4629      52.1810       0.1698       0.1928       0.2439       6.2184    2691.4219      34.0829     160.8125    4131.0000
 2555.9004      80.3962     194.2824     314.2892     180.9139     157.4065       6.3530     216.0000       0.1204       0.0484       0.0138       3.2543      90.1985     269.4618     377.1825      52.1810       0.1828       0.2075       0.2588       6.2229    2627.2268      23.2386     160.8125    4205.0000
 2556.0528      73.7107     130.3332     184.0265     102.4526      94.1227      10.6244     216.0000       0.1404       0.0701       0.0362       2.9471     100.2216     277.2766     356.6360      52.1810       0.2203       0.2489       0.3007       6.1995    2590.1948      20.4918     153.6875    4252.0000
 2556.2052      78.4988     155.0488     218.7033     129.7174     112.0944       8.9211     216.0000       0.1529       0.0835       0.0502       3.0486     105.0939     278.3931     337.2681      52.1810       0.2111       0.2389       0.2906       6.1488    2567.2246      20.3297     160.0000    4219.0000
 2556.3576      84.4455     198.2052     303.1033     158.7914     126.9229       7.8788     216.0000       0.1523       0.0829       0.0496       3.2805     111.4540     275.0439     321.6970      52.1810       0.2049       0.2323       0.2837       6.0579    2568.2178      18.6167     160.1250    4222.0000
 2556.5100      93.1746     192.8289     552.4704     191.5334     151.8121       6.5871     216.0000       0.1466       0.0768       0.0432       2.7666     107.7244     265.5544     293.3593      52.1810       0.1892       0.2143       0.2659       5.9230    2578.7473      17.3067     158.6250    4237.0000
 2556.6624      84.4018     231.4011     333.1925     203.5794     156.8240       6.3766     216.0000       0.1252       0.0535       0.0191       2.8109     106.3622     273.0901     262.8238      52.1810       0.1716       0.1944       0.2458       5.7252    2618.4517      23.1430     159.9375    4244.0000
 2556.8148      70.7939     124.5510     212.7626     157.8189     120.8046       8.2778     216.0000       0.1044       0.0311      -0.0041       2.8952      99.5954     262.2052     248.8945      52.1810       0.1940       0.2192       0.2711       5.5798    2656.7847      33.3077     160.5000    4218.0000
 2556.9672      60.4729      91.9869     174.5599     135.9118     102.6786       9.7391     216.0000       0.1026       0.0292      -0.0062       2.6078      95.9411     260.2515     267.5524      52.1810       0.1876       0.2126       0.2641       5.6092    2660.1519      32.9789     160.8125    4214.0000
 2557.1196      62.9625      93.1124     181.5588     153.3139     111.3710       8.9790     216.0000       0.1044       0.0311      -0.0042       2.6992     100.2316     270.5782     311.6691      52.1810       0.1846       0.2101       0.2610       5.7691    2656.8528      29.0025     160.8125    4256.0000
 2557.2720      63.2308      95.7394     216.6689     171.8883     133.5649       7.4870     216.0000       0.1086       0.0356       0.0006       3.0177     101.3908     271.1364     338.1081      52.1810       0.2152       0.2432       0.2950       5.9064    2649.0520      26.4025     160.8125    4236.0000
 2557.4244      68.8536     111.7955     231.8378     176.8223     142.8024       7.0027     216.0000       0.1025       0.0290      -0.0063       2.9851     100.7817     281.1841     336.3438      52.1810       0.1882       0.2132       0.2648       5.9079    2660.4448      28.5794     160.0625    4200.0000
 2557.5768      68.5506     111.8855     231.2211     178.0189     137.1655       7.2905     216.0000       0.0952       0.0211      -0.0145       2.9310      97.5082     277.5558     317.8079      52.1810       0.1914       0.2164       0.2683       5.8386    2673.8440      31.1534     160.8125    4255.0000
 2557.7292      73.3102     153.2506     307.0176     242.1970     157.2301       6.3601     216.0000       0.0852       0.0103      -0.0257       2.8986      98.1173     287.3243     311.6078      52.1810       0.1827       0.2070       0.2586       5.7969    2692.3281      36.6917     160.8125    4220.0000
 2557.8816      81.5774     252.7591     535.5226     397.9146     235.7801       4.2412     216.0000       0.0825       0.0074      -0.0287       2.8996      98.5233     283.9751     324.4677      52.1810       0.1665       0.1885       0.2399       5.8535    2697.4116      39.7313     160.8125    4255.0000
 2558.0340      69.7914     273.9550     747.2265     604.4913     415.1714       2.4086     216.0000       0.0892       0.0146      -0.0212       3.0409      96.8961     291.2317     353.8633      52.1810       0.1552       0.1757       0.2268       5.9985    2685.0002      34.1060     159.7500    4256.0000
 2558.1864      69.2635     262.7653     535.0511     340.9180     296.2165       3.3759     216.0000       0.1108       0.0380       0.0030       2.5477      99.3419     265.5544     374.4958      52.1810       0.1730       0.1955       0.2472       6.1616    2645.1030      21.2977     160.8125    4194.0000
 2558.3388      64.7798     168.4966     330.2931     195.5838     186.6289       5.3582     216.0000       0.1200       0.0479       0.0133       2.5986     100.2167     273.3693     384.8412      52.1810       0.1994       0.2249       0.2771       6.2501    2628.0862      13.9121     160.8125    4257.0000
 2558.4912      66.4539     169.9327     305.9638     172.0897     182.8256       5.4697     216.0000       0.1029       0.0295      -0.0058       2.8095     105.5049     274.4857     384.9366      52.1810       0.1746       0.1975       0.2492       6.2164    2659.5955      11.4189     161.1875    4263.0000
 2558.6436      66.3502     152.0370     279.2659     176.3432     171.8560       5.8188     216.0000       0.0802       0.0049      -0.0313       2.4518     105.9014     255.5068     379.4198      52.1810       0.1890       0.2145       0.2658       6.1692    2701.6919      13.5147     160.3125    4247.0000
 2558.7960      63.6438     153.3553     281.0575     182.8818     212.8691       4.6977     216.0000       0.0812       0.0059      -0.0302       2.8494      97.9211     270.5782     363.9254      52.1810       0.1918       0.2177       0.2691       6.1792    2699.8291      14.6497     160.8125    4263.0000
 2558.9484      56.5511     115.2984     248.6961     214.8784     168.4364       5.9370     216.0000       0.1173       0.0450       0.0103       2.1111      97.1075     255.5068     342.8621      52.1810       0.2017       0.2294       0.2804       6.3097    2633.0579      17.4806     161.5000    4221.0000
 2559.1008      51.7009     118.6421     177.6398     163.1145     115.3472       8.6695     216.0000       0.1451       0.0751       0.0415       2.5722      92.0321     260.5306     330.3702      52.4606       0.2252       0.2543       0.3061       6.4470    2581.5454      14.5393     161.8125    4179.0000
 2559.2532      49.5836      90.2809     169.1501     114.9949      84.6905      11.8077     216.0000       0.1597       0.0909       0.0578       3.0492     102.9950     255.5068     327.6083      52.4606       0.1947       0.2206       0.2722       6.5455    2554.5559      16.9752     160.8125    4208.0000
 2559.4056      56.6313     108.6752     234.6155     136.0992     117.4904       8.5113     216.0000       0.1919       0.1258       0.0940       3.0310     100.3508     261.6470     308.7742      52.4606       0.1742       0.1979       0.2490       6.6132    2494.9536      11.7428     160.8125    4185.0000
 2559.5580      59.6744     142.5723     260.8345     172.6015     135.1343       7.4000     216.0000       0.2525       0.1913       0.1619       2.5881     100.8158     265.5544     271.8687      52.1810       0.2027       0.2293       0.2811       6.6890    2382.8391       8.5686     164.5000    4191.0000
 2559.7104      69.4205     149.3258     350.4906     243.2870     190.4792       5.2499     216.0000       0.2784       0.2194       0.1910       2.9016      97.1096     283.9751     256.7136      52.1810       0.2046       0.2315       0.2833       6.7267    2334.8906       7.1498     161.0000    4226.0000
 2559.8628      66.2405     133.2684     257.0079     177.9779     146.4773       6.8270     216.0000       0.2486       0.1871       0.1576       2.8172     102.1945     275.0439     272.1942      52.4606       0.2043       0.2315       0.2830       6.6627    2390.0383       8.6228     160.8125    4220.0000
 2560.0152      67.8770     125.5495     214.7484     141.8483     123.9932       8.0650     216.0000       0.2000       0.1345       0.1030       2.3872     103.3243     273.3693     299.7274      52.1810       0.1885       0.2137       0.2652       6.5420    2479.9800      15.1093     160.8125    4200.0000
 2560.1676      62.1165     168.8049     290.4376     189.1527     126.7215       7.8913     216.0000       0.1996       0.1340       0.1025       2.7414     102.6242     266.1126     293.2761      52.4606       0.1713       0.1942       0.2455       6.4915    2480.8096      18.1182     162.4375    4211.0000
 2560.3200      54.7359     216.6770     372.0219     287.7206     177.8216       5.6236     216.0000       0.2150       0.1507       0.1199       2.4439      96.0054     266.1126     273.6318      52.4606       0.1836       0.2076       0.2594       6.4846    2452.2373      15.1847     164.4375    4192.0000
 2560.4724      54.9244     127.2691     263.3453     178.7967     158.1827       6.3218     216.0000       0.2336       0.1708       0.1407       2.4239      98.7706     257.7396     255.0216      52.4606       0.1970       0.2228       0.2746       6.4983    2417.9182      10.9170     159.7500    4231.0000
 2560.6248      54.7194     100.7747     194.6475     156.2666     121.4983       8.2306     216.0000       0.2267       0.1634       0.1330       2.7737     102.3648     283.4169     265.0602      52.4606       0.2014       0.2280       0.2797       6.5139    2430.5168      10.4364     160.8125    4204.0000
 2560.7772      57.6625      86.2051     181.8821     147.4451      98.5640      10.1457     216.0000       0.2175       0.1534       0.1226       3.6042     106.1098     273.3693     285.1222      52.4606       0.2079       0.2359       0.2872       6.5620    2447.6807      10.8945     159.6250    4236.0000
 2560.9296      71.0875      96.5522     248.6987     223.2580     154.0473       6.4915     216.0000       0.2370       0.1745       0.1445       3.6788     106.2906     294.5809     283.4380      52.4606       0.1834       0.2081       0.2594       6.6743    2411.5625       8.2545     156.8750    4212.0000
 2561.0820      58.9333     127.5046     264.7599     234.9947     174.5060       5.7305     216.0000       0.2852       0.2267       0.1986       2.9644     101.4182     279.5095     264.4177      52.4606       0.2055       0.2331       0.2844       6.7896    2322.3574       5.2877     160.8125    4256.0000
 2561.2344      54.0676     114.2861     274.6382     253.8233     194.6056       5.1386     216.0000       0.3113       0.2550       0.2279       2.1966     100.6052     271.1364     268.0614      52.4606       0.2371       0.2679       0.3194       6.8609    2274.0334       4.4298     153.6875    4289.0000
 2561.3868      53.7494     110.5124     228.8823     210.6355     205.5901       4.8640     216.0000       0.2620       0.2016       0.1726       1.7313      97.3522     277.8349     301.3687      52.4606       0.2128       0.2420       0.2928       6.7413    2365.2319       5.4409     155.9375    4287.0000
 2561.5392      72.6263     252.1575     396.4279     357.5057     311.4853       3.2104     216.0000       0.1819       0.1149       0.0827       1.7086      96.3128     285.6496     333.3623      52.4606       0.2091       0.2378       0.2886       6.4984    2513.5278       8.9109     153.5625    4270.0000
 2561.6916      80.5111     263.9183     725.9319     496.0963     398.8681       2.5071     216.0000       0.1606       0.0919       0.0589       1.7187      94.0365     267.2290     322.0561      52.4606       0.2128       0.2413       0.2926       6.3462    2552.8042      12.8469     153.6875    4268.0000
 2561.8440      70.1785     282.8389     377.0331     258.0128     208.2934       4.8009     216.0000       0.1782       0.1109       0.0786       2.6138      97.0499     275.0439     312.0620      52.4606       0.2022       0.2285       0.2804       6.3575    2520.3279      12.7762     154.7500    4204.0000
 2561.9964      79.1769     226.6868     318.0775     170.5781     160.0459       6.2482     216.0000       0.1790       0.1118       0.0795       2.5092      98.4492     273.9275     324.0128      52.4606       0.1703       0.1929       0.2443       6.4062    2518.7664      14.8465     154.3750    4187.0000
 2562.1488      85.8512     312.3929     428.5948     227.4296     173.4470       5.7654     216.0000       0.1487       0.0790       0.0455       2.4897      96.4980     263.3217     339.4837      52.4606       0.1758       0.1986       0.2504       6.3427    2574.9138      18.5605     152.8750    4211.0000
 2562.3012      85.8835     348.3786     479.7035     273.1339     174.3629       5.7352     216.0000       0.1046       0.0313      -0.0039       2.3814      96.1372     256.0650     357.6682      52.4606       0.1555       0.1762       0.2272       6.2070    2656.5090      46.0095     152.7500    4181.0000
 2562.4536      68.4913     207.9565     302.1713     199.7784     146.2753       6.8364     216.0000       0.1006       0.0270      -0.0084       2.5565      98.7387     258.8560     350.6312      52.4606       0.1403       0.1588       0.2094       6.1727    2663.8474      41.2640     153.7500    4241.0000
 2562.6060      61.2298     148.5832     308.6817     202.4295     133.8177       7.4729     216.0000       0.1074       0.0344      -0.0007       2.2899      99.5517     261.0888     357.8429      52.4606       0.1527       0.1727       0.2238       6.2396    2651.2324      35.0693     152.5625    4268.0000
 2562.7584      63.7279     132.9586     287.7955     219.3969     138.7940       7.2049     216.0000       0.1315       0.0604       0.0262       2.5172      95.2805     268.9037     369.3178      52.4606       0.1602       0.1811       0.2324       6.3918    2606.7051      27.0882     151.6875    4233.0000
 2562.9108      64.4020     134.7238     278.1928     212.9034     144.2141       6.9341     216.0000       0.1776       0.1103       0.0779       2.0023      92.0286     281.7422     364.0361      52.4606       0.1862       0.2101       0.2622       6.5642    2521.4285      17.6857     151.1250    4278.0000
 2563.0632      67.4455     108.6256     203.3018     144.8354     113.5465       8.8070     216.0000       0.2021       0.1367       0.1053       1.9811      96.0934     278.9513     360.6758      52.4606       0.1937       0.2190       0.2709       6.6620    2476.1799      12.9171     151.1875    4262.0000
 2563.2156      56.7184      84.5144     187.8587     167.1154     123.1301       8.1215     216.0000       0.1968       0.1311       0.0995       2.8249     101.3707     283.9751     358.2578      52.4606       0.1728       0.1956       0.2471       6.6448    2485.8430      13.1094     151.8750    4233.0000
 2563.3680      73.0439     107.7988     291.1526     235.4081     193.3599       5.1717     216.0000       0.1724       0.1047       0.0721       2.3305     109.8681     289.8362     360.6382      52.4606       0.1848       0.2088       0.2607       6.5320    2531.0383      16.7269     151.0625    4242.0000
 2563.5204      72.5656     148.2416     305.0443     248.8063     215.9550       4.6306     216.0000       0.1587       0.0898       0.0567       2.1856     111.9819     279.2304     354.5873      52.4606       0.1821       0.2061       0.2577       6.4351    2556.4033      23.2074     150.1250    4230.0000
 2563.6728      59.3245     154.0825     371.6881     292.5338     292.1589       3.4228     216.0000       0.1500       0.0804       0.0469       2.4493     107.9974     268.9037     346.3051      52.4606       0.1800       0.2044       0.2556       6.3626    2572.5498      18.6405     151.0625    4244.0000
 2563.8252      55.3907     105.9911     193.2234     153.6483     149.9641       6.6683     216.0000       0.1521       0.0827       0.0494       2.4580     103.1143     269.4618     341.1083      52.4606       0.1882       0.2133       0.2648       6.3441    2568.5269      15.5426     151.8125    4250.0000
 2563.9776      60.3826     131.7769     237.2298     178.8508     156.4562       6.3916     216.0000       0.1596       0.0908       0.0577       2.7865      99.2615     280.6259     339.9215      52.4606       0.1987       0.2247       0.2766       6.3648    2554.7437      10.4269     152.6875    4226.0000
 2564.1300      66.9169     166.0305     321.4349     231.0833     177.4751       5.6346     216.0000       0.1683       0.1003       0.0675       2.7272     102.0123     285.6496     340.4803      52.4606       0.1966       0.2222       0.2741       6.4089    2538.5601       9.5068     151.0625    4279.0000
 2564.2824      71.7186     165.3828     315.1791     215.4537     161.8045       6.1803     216.0000       0.1552       0.0860       0.0528       2.6026      96.4468     278.6721     349.3137      52.4606       0.2021       0.2285       0.2804       6.4240    2562.9512      10.3091     151.4375    4254.0000
 2564.4348      75.7698     178.3613     334.7736     213.9000     161.3354       6.1983     216.0000       0.1381       0.0675       0.0336       2.0743      97.0371     277.2766     355.7036      52.4606       0.1822       0.2070       0.2582       6.4356    2594.5701      15.3666     152.0625    4226.0000
 2564.5872      76.4598     185.8598     341.6841     219.1536     159.0959       6.2855     216.0000       0.1174       0.0452       0.0105       2.2477      98.0161     274.7647     372.0815      52.4606       0.1936       0.2190       0.2708       6.4700    2632.7493      21.6173     153.5000    4264.0000
 2564.7396      74.2988     188.3879     358.1937     221.5367     175.7394       5.6902     216.0000       0.1200       0.0479       0.0133       2.4820     101.3619     272.2528     381.1188      52.4606       0.1772       0.2006       0.2522       6.5584    2628.0264      30.6284     154.0625    4235.0000
 2564.8920      73.3826     202.5883     361.5660     213.7134     150.7063       6.6354     216.0000       0.1392       0.0687       0.0348       2.4368     102.0998     270.2991     382.9822      52.4606       0.1581       0.1792       0.2302       6.6652    2592.5527      29.8971     154.1875    4276.0000
 2565.0444      68.7233     182.2086     360.5057     274.8836     161.2338       6.2022     216.0000       0.1774       0.1100       0.0777       2.1090      99.3912     276.7184     363.7595      52.4606       0.1707       0.1931       0.2446       6.7730    2521.8467      17.6795     154.1250    4246.0000
 2565.1968      66.3401     185.8307     352.9872     216.0019     155.3257       6.4381     216.0000       0.2022       0.1369       0.1055       2.4023      98.2075     286.7661     340.1785      52.4606       0.1811       0.2048       0.2565       6.8217    2475.8433      10.4492     154.1875    4263.0000
 2565.3492      72.7455     174.2018     338.8795     164.6647     135.7254       7.3678     216.0000       0.2111       0.1465       0.1155       2.4342      98.5693     300.1629     324.5213      52.4606       0.1923       0.2172       0.2692       6.8099    2459.4104       7.0980     152.8750    4255.0000
 2565.5016      79.0070     153.4103     384.6267     225.2902     171.6947       5.8243     216.0000       0.2053       0.1402       0.1089       2.3563     100.5471     269.4618     323.6380      52.4606       0.1985       0.2243       0.2762       6.7750    2470.2327       7.3426     153.1875    4247.0000
 2565.6540      80.9784     175.4980     332.9881     266.0703     183.9155       5.4373     216.0000       0.2075       0.1426       0.1114       2.6838     104.8050     275.6021     326.2482      52.4606       0.1699       0.1925       0.2439       6.7507    2466.1411       8.3407     152.5625    4276.0000
 2565.8064      86.0846     180.8216     400.2971     239.5385     192.1796       5.2035     216.0000       0.1927       0.1267       0.0949       2.5954      99.7175     288.4407     349.0620      52.4606       0.1682       0.1902       0.2417       6.7446    2493.4255      12.9154     151.0625    4293.0000
 2565.9588      85.8787     183.4700     479.4012     229.5746     196.6662       5.0848     216.0000       0.1879       0.1214       0.0895       2.5061      99.5665     275.0439     359.6795      52.4606       0.1638       0.1851       0.2366       6.7318    2502.3640      13.5295     151.0625    4257.0000
 2566.1112      79.0621     229.2408     497.5906     294.4843     255.4285       3.9150     216.0000       0.1553       0.0862       0.0529       2.6452      96.4750     272.2528     387.7690      52.4606       0.1770       0.1997       0.2516       6.6735    2562.6631      18.7491     151.0625    4276.0000
 2566.2636      75.4074     220.1054     553.3106     459.3654     392.4553       2.5481     216.0000       0.1513       0.0818       0.0484       2.6414     102.8124     277.2766     380.9938      52.4606       0.1526       0.1730       0.2239       6.6060    2570.1104      19.6209     152.3125    4285.0000
 2566.4160      74.4123     165.9393     375.4930     184.6202     195.2989       5.1204     216.0000       0.1450       0.0750       0.0413       2.8626      99.5627     266.3917     372.8726      52.4606       0.1693       0.1922       0.2433       6.5397    2581.8123      20.3295     154.3750    4283.0000
 2566.5684      65.3892     121.5090     240.3174     181.7826     148.2794       6.7440     216.0000       0.1492       0.0795       0.0460       2.3924     101.6537     269.4618     359.4794      52.4606       0.1945       0.2197       0.2717       6.5179    2574.0249      19.8607     151.8750    4293.0000
 2566.7208      72.3150     127.9946     272.0648     206.6766     172.0144       5.8135     216.0000       0.1629       0.0943       0.0614       2.3302     102.1330     289.2780     346.6997      52.4606       0.1840       0.2083       0.2600       6.5399    2548.6860      19.6617     153.1250    4260.0000
 2566.8732      72.6508     143.0177     245.1080     192.4275     153.9036       6.4976     216.0000       0.1656       0.0973       0.0645       2.7661     104.9472     288.7198     350.8932      52.4606       0.1869       0.2111       0.2630       6.5722    2543.5979      22.4620     153.7500    4295.0000
 2567.0256      61.1495     139.4932     201.4297     147.8588     124.9965       8.0002     216.0000       0.1646       0.0962       0.0634       2.6026     106.3411     271.1364     356.3833      52.4606       0.1763       0.1994       0.2510       6.6102    2545.4514      21.7462     151.7500    4340.0000
 2567.1780      60.0197     117.7627     209.6178     149.0297     127.6199       7.8358     216.0000       0.1731       0.1054       0.0729       2.5596     101.9510     257.1814     348.4380      52.4606       0.1791       0.2027       0.2543       6.6423    2529.7642      21.4247     152.0625    4293.0000
 2567.3304      62.7425     125.3613     236.0603     154.6656     126.0649       7.9324     216.0000       0.1908       0.1246       0.0927       2.5318     100.1426     273.9275     334.7349      52.4606       0.1690       0.1915       0.2428       6.6847    2497.0017      13.2588     154.5000    4304.0000
 2567.4828      61.4565     145.0253     236.9847     166.2293     133.9089       7.4678     216.0000       0.2217       0.1580       0.1274       2.7475      98.3903     276.7184     313.4565      52.4606       0.1884       0.2134       0.2650       6.7241    2439.8474       9.6815     151.0625    4302.0000
 2567.6352      60.7994     156.0667     251.9431     173.0856     134.3057       7.4457     216.0000       0.2484       0.1868       0.1573       2.7578      99.6911     277.2766     301.5413      52.4606       0.1936       0.2188       0.2707       6.7527    2390.5288       6.9715     153.5000    4348.0000
 2567.7876      64.8032     143.6891     198.1666     149.9929     110.5017       9.0496     216.0000       0.2353       0.1727       0.1427       3.0058     102.7989     286.2079     321.1949      52.4606       0.1896       0.2145       0.2663       6.7351    2414.6099       7.7573     151.0625    4380.0000
 2567.9400      69.7231      98.0135     165.8870     132.7546     105.6914       9.4615     216.0000       0.2182       0.1542       0.1235       2.0097     101.5318     272.2528     341.4500      52.4606       0.1959       0.2218       0.2735       6.7180    2446.2524       9.6843     151.0625    4311.0000
 2568.0924      68.7831     152.4870     285.4321     250.2029     121.9654       8.1990     216.0000       0.1823       0.1153       0.0831       1.2940     103.0493     277.2766     370.8141      52.4606       0.2132       0.2412       0.2929       6.6852    2512.8127      15.1004     151.0625    4264.0000
 2568.2448      85.4606     279.6190     384.6500     300.3834     205.6127       4.8635     216.0000       0.1888       0.1224       0.0905       1.4836      99.8331     271.4155     361.3443      52.4606       0.1861       0.2117       0.2627       6.6695    2500.6675      14.8086     151.0625    4273.0000
 2568.3972      70.5889     290.5983     891.7868     789.8525     368.0832       2.7168     216.0000       0.2017       0.1363       0.1049       0.0000     100.2667     260.2515     344.6262      52.4606       0.1931       0.2190       0.2705       6.6526    2476.8777      12.0980     151.0625    4269.0000
 2568.5496      70.7385     232.7882     451.2794     341.9500     332.0732       3.0114     216.0000       0.2006       0.1352       0.1037       2.1907     101.6013     266.3917     336.1025      52.4606       0.1883       0.2134       0.2649       6.6178    2478.8667      10.7914     151.0625    4318.0000
 2568.7020      66.0424     154.4302     325.3097     246.6562     174.2585       5.7386     216.0000       0.1958       0.1299       0.0983       2.9500     104.5123     285.9287     324.1980      52.4606       0.1882       0.2126       0.2645       6.5891    2487.8591      10.8689     151.0625    4329.0000
 2568.8544      72.6318     190.3038     484.3149     296.4727     195.0130       5.1279     216.0000       0.1785       0.1113       0.0789       2.9205     104.7907     284.5333     330.0736      52.4606       0.1800       0.2037       0.2553       6.5446    2519.7336      13.4128     151.0625    4296.0000
 2569.0068      82.4280     229.9832     487.6966     303.9177     235.0147       4.2551     216.0000       0.1771       0.1097       0.0774       3.0933     101.9385     284.5333     334.4633      52.4606       0.1821       0.2059       0.2577       6.5491    2522.3403      14.8562     149.2500    4277.0000
 2569.1592      75.9062     171.0800     388.9158     245.9829     179.9491       5.5571     216.0000       0.1793       0.1121       0.0799       3.1584      98.7023     270.5782     340.4007      52.4606       0.1814       0.2050       0.2568       6.5803    2518.2444      12.5070     146.2500    4304.0000
 2569.3116      72.0295     160.7256     319.3864     182.6808     167.8891       5.9563     216.0000       0.1693       0.1012       0.0686       1.9837     104.0222     268.3454     345.6581      52.4606       0.1782       0.2015       0.2532       6.6068    2536.8787      12.1108     150.6250    4312.0000
 2569.4640      67.0679     139.3499     290.2431     176.1340     150.8981       6.6270     216.0000       0.1468       0.0769       0.0433       2.5894     107.8161     255.5068     352.3922      52.4606       0.1764       0.1993       0.2511       6.5908    2578.4868      14.3471     145.3125    4390.0000
 2569.6164      63.0454     137.6309     241.1368     147.7993     142.7551       7.0050     216.0000       0.1413       0.0710       0.0372       2.4020     107.7840     262.4843     353.1465      52.4606       0.1560       0.1767       0.2277       6.5877    2588.5967      21.6396     144.3750    4355.0000
 2569.7688      61.3585     144.3546     217.2242     141.0631     121.4109       8.2365     216.0000       0.1624       0.0938       0.0608       3.1182     108.5811     258.8560     348.2516      52.4606       0.1532       0.1736       0.2245       6.6403    2549.6326      19.4799     146.0000    4333.0000
 2569.9212      57.1122     131.3746     207.2068     133.2659     107.0586       9.3407     216.0000       0.2026       0.1373       0.1059       2.9798     106.4869     268.0663     338.7957      52.4606       0.1720       0.1948       0.2463       6.7499    2475.1924      15.0010     147.2500    4303.0000
 2570.0736      56.1235     129.7408     193.6480     152.8950     118.3212       8.4516     216.0000       0.2498       0.1883       0.1588       2.1435     109.4107     259.4142     319.4563      52.4606       0.1863       0.2104       0.2624       6.8587    2387.9490      10.1907     145.8750    4286.0000
 2570.2260      53.6674     130.8308     178.5191     150.9936     120.4816       8.3000     216.0000       0.2847       0.2261       0.1980       1.9545     108.1099     280.6259     304.0693      52.4606       0.1762       0.1989       0.2508       6.9449    2323.3027      10.0922     143.1875    4279.0000
 2570.3784      45.9919     108.0802     166.2811     182.3432     122.1550       8.1863     216.0000       0.3138       0.2577       0.2307       2.6505     108.0013     278.6721     281.6933      52.4606       0.1786       0.2018       0.2536       7.0048    2269.4053      10.5451     143.8750    4316.0000
 2570.5308      67.2610     124.6661     210.0203     236.9127     176.6965       5.6594     216.0000       0.3155       0.2594       0.2325       2.7986     105.8684     252.4367     272.5634      52.4606       0.2026       0.2293       0.2810       7.0081    2266.3594      12.8124     141.3125    4331.0000
 2570.6832      94.2087     161.4639     283.3791     262.8957     220.7741       4.5295     216.0000       0.3207       0.2651       0.2383       2.5792      99.3646     255.2277     253.8595      52.4606       0.1963       0.2226       0.2740       6.9813    2256.7529      13.4288     142.4375    4346.0000
 2570.8356     103.3237     220.0862     419.7540     334.0564     288.9775       3.4605     216.0000       0.3042       0.2472       0.2198       2.4995      97.0019     257.7396     256.0935      52.4606       0.1889       0.2141       0.2656       6.8758    2287.2949      14.0619     141.3125    4362.0000
 2570.9880      99.0378     234.9881     438.7010     329.2018     261.1227       3.8296     216.0000       0.2573       0.1965       0.1673       2.7343      98.3768     257.7396     295.5530      52.4606       0.1786       0.2020       0.2537       6.7283    2374.0347      16.6282     140.0625    4292.0000
 2571.1404      93.7968     206.0058     375.1927     246.4109     215.8245       4.6334     216.0000       0.1974       0.1317       0.1002       2.8945     105.3142     259.9724     347.0409      52.4606       0.1734       0.1958       0.2476       6.5287    2484.7256      19.9598     141.3125    4293.0000
 2571.2928      89.1218     197.4567     299.8556     174.0863     158.5255       6.3081     216.0000       0.1537       0.0844       0.0511       2.3960     110.9637     268.9037     382.6122      52.4606       0.1501       0.1698       0.2208       6.3403    2565.6465      21.3317     140.1250    4271.0000
 2571.4452      67.3520     126.9510     214.7215     165.4444     111.5069       8.9681     216.0000       0.1518       0.0823       0.0490       1.9008     109.8056     257.7396     373.6887      52.4606       0.1332       0.1511       0.2012       6.1954    2569.1965      19.1603     136.5000    4232.0000
 2571.5976      56.3966     113.9582     158.9015     146.2558      89.3465      11.1924     216.0000       0.1809       0.1139       0.0816       2.0413     110.7812     270.5782     330.5988      52.4606       0.1710       0.1933       0.2449       6.1033    2515.2915      15.2313     136.9375    4321.0000
 2571.7500      50.9485      96.4180     120.8189     110.6901      69.3830      14.4127     216.0000       0.1995       0.1340       0.1025       2.2646     111.9022     283.6960     284.8291      52.4606       0.1812       0.2047       0.2566       5.9918    2480.9167      11.8487     134.7500    4259.0000
 2571.9024      45.7821      67.3281     102.4710      94.4934      60.7389      16.4639     216.0000       0.1837       0.1169       0.0848       2.8169     114.2869     276.7184     253.1109      52.4606       0.2016       0.2280       0.2798       5.7944    2510.1167      10.4888     134.6875    4297.0000
 2572.0548      53.4739      77.8582     137.7835     124.1453      75.8060      13.1916     216.0000       0.1350       0.0642       0.0301       2.8784     109.6259     273.9275     239.8372      52.4606       0.2077       0.2350       0.2867       5.5024    2600.2917      12.1234     134.0000    4300.0000
 2572.2072      63.7579     109.1743     191.5677     185.8867     120.5304       8.2967     216.0000       0.1072       0.0341      -0.0010       2.7435     107.7461     290.4874     222.5754      52.4606       0.1745       0.1981       0.2493       5.2327    2651.6265      15.4804     131.5625    4313.0000
 2572.3596      59.8772     105.7147     209.8017     201.3773     141.9646       7.0440     216.0000       0.1122       0.0395       0.0046       2.7228     105.4697     282.3004     205.7569      52.4606       0.1775       0.2009       0.2525       5.0963    2642.4250      15.2452     131.5625    4327.0000
 2572.5120      58.5304      85.9814     203.9809     209.9313     180.5130       5.5398     216.0000       0.1370       0.0663       0.0324       2.6019     103.6270     293.1854     195.5330      52.4606       0.1864       0.2106       0.2625       5.1117    2596.5588      14.3155     130.0625    4308.0000
 2572.6644      71.5125     104.3570     239.8747     199.2008     253.9664       3.9375     216.0000       0.1491       0.0795       0.0460       1.9186     100.3299     305.5588     190.7365      52.4606       0.1839       0.2076       0.2596       5.1789    2574.0979      14.1603     129.3750    4343.0000
 2572.8168      74.9918     176.4975     327.1407     370.2720     383.0813       2.6104     216.0000       0.1478       0.0781       0.0445       2.0003     102.4978     304.0703     186.8103      52.4606       0.1912       0.2160       0.2679       5.2324    2576.4932      14.5303     126.4375    4343.0000
 2572.9692      73.6681     170.5288     342.0199     391.2709     470.7302       2.1244     216.0000       0.1386       0.0681       0.0342       2.5229     107.9177     299.3256     182.7807      52.4606       0.1728       0.1958       0.2472       5.2402    2593.5991      13.1398     124.3750    4328.0000
 2573.1216      54.3803     132.9256     294.9080     363.0118     402.9477       2.4817     216.0000       0.1337       0.0628       0.0287       2.4973     108.8300     282.5796     181.5124      52.4606       0.1861       0.2110       0.2624       5.2411    2602.6074      12.6719     124.3750    4297.0000
 2573.2740      46.2803      96.4239     231.0658     393.4658     382.4750       2.6146     216.0000       0.1346       0.0637       0.0297       2.2735     109.5211     289.2780     182.1761      52.4606       0.1742       0.1975       0.2488       5.2555    2601.0598      13.3468     121.7500    4279.0000
 2573.4264      43.9258      81.0676     162.0116     320.5340     263.6052       3.7936     216.0000       0.1311       0.0599       0.0257       2.5662     106.5944     289.7431     189.5673      52.4606       0.1877       0.2125       0.2642       5.3020    2607.5559      14.1811     120.9375    4241.0000
 2573.5788      43.2679      68.4595     149.5735     364.7034     344.3915       2.9037     216.0000       0.1143       0.0418       0.0069       2.2133     106.0189     297.6509     199.7612      52.4606       0.1916       0.2163       0.2683       5.3588    2638.5481      15.8797     121.7500    4266.0000
 2573.7312      47.7094      79.6090     195.8073     327.7006     452.1606       2.2116     216.0000       0.1026       0.0292      -0.0061       2.0333     101.7110     301.2793     197.1292      52.4606       0.1904       0.2153       0.2672       5.4209    2660.1475      18.7665     121.7500    4330.0000
 2573.8836      58.7992      89.2801     265.9403     268.3077     515.5746       1.9396     216.0000       0.0973       0.0234      -0.0121       2.1008     102.5782     283.9751     196.8479      52.4606       0.1697       0.1921       0.2436       5.5005    2669.9993      20.5957     112.0000    4304.0000
 2574.0360      59.6760     111.6828     288.0051     217.7450     503.2697       1.9870     216.0000       0.1104       0.0376       0.0026       2.8707     107.2153     283.9751     207.8297      52.4606       0.1610       0.1824       0.2336       5.6332    2645.7598      19.8773     115.0625    4337.0000
 2574.1884      55.1979     183.2416     369.2448     117.8042     411.9726       2.4273     216.0000       0.1423       0.0720       0.0383       2.7201     106.3877     296.2555     217.2499      52.4606       0.1726       0.1949       0.2467       5.8060    2586.8123      15.1871     114.5000    4317.0000
 2574.3408      48.5179     143.2633     512.6434     146.7209     817.1574       1.2238     216.0000       0.1626       0.0940       0.0610       2.6310     107.0381     307.4195     222.0521      52.4606       0.1617       0.1828       0.2343       5.9093    2549.2815      12.6531     112.7500    4325.0000
 2574.4932      46.8472     126.3152     259.3348     133.8259     229.1943       4.3631     216.0000       0.1574       0.0884       0.0552       2.5404     107.7460     285.6496     223.8457      52.4606       0.1637       0.1853       0.2366       5.9007    2558.8672      12.0894     112.0000    4322.0000
 2574.6456      39.6557      96.0926     116.7748      77.8682      97.8680      10.2178     216.0000       0.1300       0.0587       0.0245       2.4079     112.8407     298.4883     233.2723      52.4606       0.1817       0.2050       0.2571       5.8066    2609.5908      15.0041     112.0000    4310.0000
 2574.7980      34.6665      57.7741      70.1141      49.6944      45.4064      22.0233     216.0000       0.1135       0.0410       0.0061       2.5365     106.3367     272.5320     240.7484      52.4606       0.1706       0.1932       0.2446       5.7658    2639.9558      15.3836     112.0000    4349.0000
 2574.9504      36.0792      58.0656      83.3723      61.5819      49.5256      20.1916     216.0000       0.1311       0.0599       0.0258       2.4467      98.8573     287.8825     230.9263      52.4606       0.1712       0.1941       0.2454       5.8269    2607.4995      14.5812     108.6250    4340.0000
 2575.1028      51.2307      82.1728     121.7850      83.9201      57.6133      17.3571     216.0000       0.1530       0.0837       0.0503       2.5253      91.2696     287.0452     229.6333      52.4606       0.1887       0.2134       0.2652       5.9512    2566.9509      11.1142     107.9375    4383.0000
 2575.2552      74.2032      97.4459     183.8220     137.0166      69.5984      14.3682     216.0000       0.1755       0.1080       0.0755       1.8715      94.4163     301.2793     238.8487      52.4606       0.2037       0.2302       0.2821       6.0811    2525.3755      11.6442     102.2500    4382.0000
 2575.4076      90.4890     131.8037     253.1885     179.7002     105.2736       9.4991     216.0000       0.1795       0.1123       0.0800       2.9225      94.7415     281.7422     268.4884      52.4606       0.1924       0.2176       0.2694       6.1867    2517.9619      10.9634     106.1875    4356.0000
 2575.5600      93.5154     302.7986     411.2678     263.2876     153.3710       6.5201     216.0000       0.2028       0.1376       0.1062       2.8161     100.3781     313.0015     279.6710      52.4606       0.1824       0.2063       0.2580       6.3015    2474.7402      14.1895     108.8750    4298.0000
 2575.7124      89.4251     760.5941    1101.7491     403.1846     238.5654       4.1917     216.0000       0.2253       0.1618       0.1314       1.3218     101.4591     294.3018     286.4230      52.4606       0.1628       0.1845       0.2357       6.4082    2433.2708      12.7238     102.2500    4293.0000
 2575.8648      73.6154     427.3655     322.9132     203.4963     185.6835       5.3855     216.0000       0.2322       0.1693       0.1391       2.0023     101.2362     299.8838     298.7454      52.4606       0.1704       0.1929       0.2444       6.4797    2420.5100      14.9999     110.1250    4273.0000
 2576.0172      55.1469     249.3139     164.6258     127.3343     151.4771       6.6017     216.0000       0.1956       0.1298       0.0981       3.2244      97.8452     273.7414     337.9643      52.4606       0.1965       0.2219       0.2739       6.4701    2488.0613      18.1067     102.5625    4310.0000
 2576.1696      48.5109     229.7094     162.5683     120.9492     152.1821       6.5711     216.0000       0.1516       0.0821       0.0487       3.1449      96.8696     284.1611     381.2168      52.4606       0.1673       0.1891       0.2407       6.4224    2569.5969      28.6942     102.9375    4293.0000
 2576.3220      44.9072     203.5768     172.6287     109.4313     194.6147       5.1384     216.0000       0.1539       0.0846       0.0513       2.9801     101.7535     288.9989     386.5700      52.4606       0.1440       0.1630       0.2137       6.4245    2565.2808      17.9830     102.2500    4268.0000
 2576.4744      46.1251     164.7975     127.5486     131.1762     150.4944       6.6448     216.0000       0.1764       0.1090       0.0766       2.0482     102.1094     275.3229     371.3715      52.4606       0.1554       0.1759       0.2271       6.4378    2523.5945      11.4220     103.3750    4257.0000
 2576.6268      46.8970     108.1177     100.0475     132.3840     162.6015       6.1500     216.0000       0.1948       0.1289       0.0972       1.7473     104.2774     282.3004     343.3306      52.4606       0.1677       0.1899       0.2413       6.4317    2489.6494       8.9951     102.2500    4188.0000
 2576.7792      63.3243     122.0994     129.1251     131.9332     105.1844       9.5071     216.0000       0.1709       0.1030       0.0704       2.3280     104.6414     278.1140     337.1982      52.4606       0.2052       0.2315       0.2836       6.3331    2533.8594       9.9716     106.8750    4241.0000
 2576.9316      98.4860     274.3581     224.3986     205.6512     162.7872       6.1430     216.0000       0.1590       0.0902       0.0571       2.4507     107.5682     299.0465     333.5507      52.4606       0.1817       0.2056       0.2573       6.2727    2555.8381      11.3899      99.3125    4310.0000
 2577.0840     130.3397     367.5658     570.9833     449.7603     536.2311       1.8649     216.0000       0.1707       0.1028       0.0702       2.4662     105.1834     277.4627     323.5500      52.4606       0.1713       0.1939       0.2454       6.2607    2534.1741      12.4705     102.2500    4544.0000
 2577.2364     152.7412     704.5660    1950.0000     553.9240    1077.6219       0.9280     216.0000       0.1895       0.1231       0.0913       2.0105     103.9995     293.1854     314.5745      52.4606       0.1688       0.1908       0.2424       6.2960    2499.4146      11.8225     102.7500    4673.0000
 2577.3888     161.3341    1039.0623    1950.0000     373.8429     622.8325       1.6056     216.0000       0.1791       0.1119       0.0796       2.2267     104.9402     269.4618     318.5926      52.4606       0.1695       0.1913       0.2431       6.2863    2518.6880      12.4798     101.3125    4583.0000
 2577.5412     167.3641     881.0031    1125.5524     355.8935     385.8065       2.5920     216.0000       0.1830       0.1162       0.0840       2.8561     107.8669     273.3693     314.8739      52.4606       0.1632       0.1844       0.2359       6.2878    2511.3579      10.0259     102.2500    4561.0000
 2577.6936     130.7451     369.9309     464.8007     375.7258     189.3087       5.2824     216.0000       0.1930       0.1270       0.0952       2.9450     103.5281     282.4865     324.7714      52.4606       0.1473       0.1666       0.2175       6.3245    2492.8950       8.5420     101.0000    4444.0000
 2577.8460      94.9657     190.1538     317.0745     291.7038     110.1153       9.0814     216.0000       0.2088       0.1440       0.1129       2.3998     101.2742     288.8128     346.1468      52.4606       0.1482       0.1677       0.2186       6.3949    2463.6826       7.5265     102.6875    4252.0000
 2577.9984      51.7825      82.8960     118.0824     141.7561      76.9969      12.9875     216.0000       0.2001       0.1346       0.1031       2.1087     100.6239     293.6506     382.9355      52.4606       0.1733       0.1955       0.2474       6.4467    2479.8162       8.5880      99.1250    4376.0000
 2578.1508      68.7620     109.8084     174.7858     168.9362      79.6059      12.5619     216.0000       0.1869       0.1204       0.0884       2.0358     101.9551     298.7674     398.6683      52.4606       0.1506       0.1705       0.2215       6.4301    2504.1584       9.8806      98.0625    4340.0000
 2578.3032      84.4150     152.2727     224.4067     166.2339     108.5812       9.2097     216.0000       0.1970       0.1312       0.0996       2.4626     100.7753     300.7211     370.9855      52.4606       0.1578       0.1784       0.2297       6.3682    2485.6396       8.3862      99.9375    4362.0000
 2578.4556     102.6006     164.1053     384.3292     241.5291     188.5235       5.3044     216.0000       0.2044       0.1393       0.1080       2.3898      98.7156     302.7678     333.4620      52.4606       0.1565       0.1768       0.2281       6.2366    2471.8538       6.9477     100.3125    4348.0000
 2578.6080      86.5051     126.5390     390.0647     142.0049     104.1598       9.6006     216.0000       0.1991       0.1336       0.1021       2.4509      98.7491     283.6029     298.8339      52.4606       0.1459       0.1649       0.2158       6.0502    2481.6069       6.5248     100.6875    4293.0000
 2578.7604      66.1899      82.5886     147.1324      67.8544      65.0605      15.3703     216.0000       0.1746       0.1071       0.0746       2.9067     100.9171     292.1620     278.3048      52.4606       0.1605       0.1813       0.2328       5.8113    2526.9158       6.6247     100.0000    4295.0000
 2578.9128      53.3627      71.3643     131.3291      66.1220      76.8646      13.0099     216.0000       0.1622       0.0936       0.0607       2.6825     101.3193     286.2079     261.6687      52.4606       0.1684       0.1903       0.2419       5.6199    2549.9231       8.5211      97.1250    4271.0000
 2579.0652      55.1274      94.8552     163.0992     144.8903     164.7690       6.0691     216.0000       0.1778       0.1105       0.0782       1.9808      99.0429     287.6034     237.7498      52.4606       0.1622       0.1836       0.2349       5.5166    2520.9927       8.9400      96.0625    4274.0000
 2579.2176      63.5779     117.9785     274.9355     203.8881     221.3503       4.5177     216.0000       0.1935       0.1275       0.0958       2.4452      99.0429     292.5341     216.8198      52.4606       0.1580       0.1790       0.2301       5.4548    2491.9421      11.2121      92.1875    4252.0000
 2579.3700      65.7450     144.9183     347.9318     329.3163     356.5207       2.8049     216.0000       0.2046       0.1395       0.1082       2.7022      97.3400     306.6752     186.3792      52.4606       0.1746       0.1976       0.2492       5.3474    2471.5188      11.9302      95.0000    4264.0000
 2579.5224      61.3762     131.9832     446.9277     534.1701     567.7576       1.7613     216.0000       0.1892       0.1228       0.0909       2.2783     102.6577     285.9287     163.3971      52.4606       0.2080       0.2349       0.2869       5.1696    2500.0632      14.8844      92.5000    4279.0000
 2579.6748      59.0873     112.9650     410.2135     878.7457     906.1018       1.1036     216.0000       0.1704       0.1025       0.0699       1.8951     103.1997     286.4870     145.7083      52.4606       0.1983       0.2239       0.2760       4.9951    2534.6707      15.8982      90.9375    4268.0000
 2579.8272      65.1452     144.9029     586.0038    1314.8129    1275.9596       0.7837     216.0000       0.1420       0.0718       0.0380       2.1076     105.1508     291.5108     158.8955      52.4606       0.1731       0.1956       0.2473       4.8977    2587.2935      17.2502      89.9375    4202.0000
 2579.9796      70.5522     189.6435     918.1716    1533.4695    1392.9951       0.7179     216.0000       0.1414       0.0711       0.0373       2.4886     102.3262     304.8145     189.7240      52.4606       0.1512       0.1709       0.2220       4.9636    2588.4343      22.2186      84.1250    4223.0000
 2580.1320      71.2267     230.1759    1950.0000    1950.0000    1950.0000       0.5011     216.0000       0.1545       0.0853       0.0520       2.8723     103.4102     296.4416     233.0668      52.4606       0.1309       0.1482       0.1983       5.1445    2564.2100      17.1287      87.5625    4261.0000
 2580.2844      67.9773     236.3931    1950.0000    1950.0000    1950.0000       0.5109     216.0000       0.1599       0.0911       0.0580       2.9053     104.2786     279.8816     260.7124      52.4606       0.1607       0.1816       0.2330       5.2819    2554.2722      13.2608      84.5625    4294.0000
 2580.4368      67.2714     209.9478    1376.1300     805.0091     706.4023       1.4156     216.0000       0.1364       0.0657       0.0317       2.4465     106.0129     297.0928     261.2085      52.4606       0.1543       0.1744       0.2256       5.2255    2597.6206      11.8512      82.6875    4399.0000
 2580.5892      67.4259     177.1403     691.3661     263.9873     217.9106       4.5890     216.0000       0.1147       0.0422       0.0073       2.4139     106.3381     285.3705     229.8107      52.4606       0.1578       0.1785       0.2297       5.0276    2637.8911      15.6913      74.4375    4391.0000
 2580.7416      67.8092     158.1870     485.7433     189.7173     155.0939       6.4477     216.0000       0.1077       0.0347      -0.0004       2.6100     109.6972     281.9283     195.6935      52.4606       0.1711       0.1933       0.2450       4.8612    2650.7292      19.9671      82.2500    4256.0000
 2580.8940      70.5214     124.8208     361.2025     103.0277      86.8690      11.5116     216.0000       0.1264       0.0549       0.0205       2.5376     112.2987     286.2079     172.3082      52.4606       0.1687       0.1907       0.2423       4.8458    2616.1118      18.5366      67.3750    4237.0000
 2581.0464      62.7682     123.4410     264.0804      98.6162      93.1153      10.7394     216.0000       0.1414       0.0711       0.0374       2.5395     112.6239     294.3018     171.8175      52.4606       0.1614       0.1824       0.2338       4.9306    2588.3425      14.8568      79.2500    4229.0000
 2581.1988      61.5829     143.9312     291.9558     133.6806     106.1497       9.4207     216.0000       0.1524       0.0830       0.0496       2.5538     109.6708     273.7414     177.2327      52.4606       0.1426       0.1614       0.2121       5.0219    2568.0994      12.1997      72.9375    4256.0000
 2581.3512      56.4625     102.7977     246.5347     137.0372     123.1463       8.1204     216.0000       0.1485       0.0788       0.0453       2.4452     101.5411     277.2766     187.7983      52.4606       0.1585       0.1791       0.2304       5.0849    2575.2437      12.3734      72.9375    4220.0000
 2581.5036      73.5576     168.0155     493.2262     279.8781     201.8165       4.9550     216.0000       0.1601       0.0914       0.0583       2.4919      97.5304     277.6488     189.4779      52.4606       0.1702       0.1920       0.2438       5.1831    2553.7241      13.8122      72.6250    4205.0000
 2581.6560      63.4308     132.3384     668.7898     561.4103     394.2249       2.5366     216.0000       0.2061       0.1411       0.1099       2.5334      95.4972     270.2991     171.5739      52.4606       0.1383       0.1568       0.2072       5.3376    2468.7268       9.2564      69.1875    4204.0000
 2581.8084      59.0745      88.4635     304.7174     259.0090     254.1150       3.9352     216.0000       0.2469       0.1853       0.1556       2.5098      99.4765     294.5809     155.3237      52.4606       0.1447       0.1640       0.2147       5.4296    2393.1787       6.2741      64.8750    4220.0000
 2581.9608      54.0058      70.2258     284.6187     256.6306     311.0832       3.2146     216.0000       0.2683       0.2084       0.1796       2.2709     100.4521     319.5138     148.3126      52.4606       0.1949       0.2195       0.2719       5.4103    2353.6189       5.1124      65.8750    4177.0000
 2582.1132      47.9022      58.7624     220.4171     228.1669     346.5750       2.8854     216.0000       0.2426       0.1806       0.1508       2.3488     100.7773     323.6073     180.0659      52.4606       0.1791       0.2020       0.2540       5.3264    2401.1055       6.5553      69.0000    4206.0000
 2582.2656      56.5619      58.2098     208.7810     152.5336     284.0845       3.5201     216.0000       0.2318       0.1689       0.1387       2.5645      98.6754     324.1655     210.2311      52.4606       0.1458       0.1649       0.2157       5.3349    2421.1394       7.7182      65.3125    4212.0000
 2582.4180      55.7864      87.9884     408.8998     194.2711     404.6156       2.4715     216.0000       0.2086       0.1438       0.1127       2.5741      98.2094     333.0967     240.2818      52.4606       0.1584       0.1787       0.2302       5.3837    2464.0186       8.7834      62.5000    4292.0000
 2582.5704      59.0312     141.3476     619.7086     485.8277     414.3667       2.4133     216.0000       0.1744       0.1068       0.0743       2.4826      96.9087     311.3269     254.9102      52.4606       0.1705       0.1924       0.2442       5.3485    2527.3928      10.3113      63.1875    4367.0000
 2582.7228      54.3797     216.7961     646.1661     433.8579     218.7437       4.5716     216.0000       0.1414       0.0711       0.0373       2.3962      97.3076     306.1170     251.4479      52.4606       0.1276       0.1446       0.1945       5.2208    2588.4268      15.4815      58.1250    4346.0000
 2582.8752      52.0384     293.7116     843.8854     673.8224     180.2983       5.5464     216.0000       0.1201       0.0480       0.0134       2.4812      96.4195     291.2317     232.5325      52.4606       0.1393       0.1577       0.2082       5.0486    2627.8967      15.1060      61.2500    4354.0000
 2583.0276      46.5145     279.1225     839.5590     866.1161     115.4954       8.6584     216.0000       0.1271       0.0556       0.0213       2.4363     100.2854     284.5333     193.6297      52.4606       0.1604       0.1812       0.2326       4.9180    2614.8862      14.9282      53.4375    4273.0000
 2583.1800      46.9373     180.3171     429.1938     551.9568     124.6282       8.0239     216.0000       0.1264       0.0549       0.0205       2.7057     102.3450     287.1382     174.3662      52.4606       0.1473       0.1668       0.2176       4.8446    2616.1899      15.6791      57.3750    4265.0000
 2583.3324      44.3991     106.3334     427.5526     798.7864      94.8274      10.5455     216.0000       0.1443       0.0743       0.0406       2.9716     102.7235     280.6259     166.2440      52.4606       0.1561       0.1765       0.2277       4.8839    2583.0066      17.6983      53.9375    4250.0000
 2583.4848      38.0930      62.8864     301.0878     299.0046     116.9417       8.5513     216.0000       0.1698       0.1018       0.0691       2.1336     101.0255     277.2766     168.1736      52.4606       0.1805       0.2035       0.2556       5.0051    2535.9619      12.1036      53.6250    4297.0000
 2583.6372      30.2669      35.9693      86.2125     156.3675      78.2105      12.7860     216.0000       0.1619       0.0933       0.0603       1.2700      99.9415     292.6272     185.6203      52.4606       0.1713       0.1932       0.2450       5.0810    2550.4319      10.4009      49.6875    4241.0000
 2583.7896      40.3167      36.8914      94.4875     135.0744     104.7836       9.5435     216.0000       0.1434       0.0733       0.0396       2.0756     101.8926     298.7674     196.4109      52.4606       0.1560       0.1764       0.2276       5.0819    2584.6294      12.3740      53.4375    4297.0000
 2583.9420      41.4024      47.4395     132.7428     142.1310     150.3411       6.6515     216.0000       0.1123       0.0396       0.0047       2.8364      98.2671     287.5103     211.0655      52.4606       0.1663       0.1880       0.2395       5.0382    2642.2573      18.8709      43.6250    4319.0000
 2584.0944      48.9641      77.1094     154.3257     160.0919     217.9426       4.5884     216.0000       0.1228       0.0510       0.0165       2.9524      95.8824     273.1832     209.7347      52.4606       0.1492       0.1692       0.2199       5.0685    2622.7737      14.3965      43.6250    4296.0000
 2584.2468      41.8589      74.4557     210.2157     153.5427     369.3837       2.7072     216.0000       0.1448       0.0748       0.0412       2.5191      97.6167     300.3489     207.2272      52.4606       0.1733       0.1966       0.2479       5.1836    2582.0991      10.5877      43.6250    4213.0000
 2584.3992      38.9524      81.5870     138.5655     139.9262     283.2300       3.5307     216.0000       0.1705       0.1026       0.0699       2.3814     100.3751     303.5121     204.5875      52.4606       0.2085       0.2358       0.2876       5.3368    2534.6042       8.3835      43.6250    4256.0000
 2584.5516      40.9619      82.1854     156.4166     123.0348     257.3094       3.8864     216.0000       0.1810       0.1139       0.0817       2.6786     104.4941     299.3256     206.3828      52.4606       0.2120       0.2400       0.2916       5.4651    2515.1895       7.6652      33.8750    4456.0000
 2584.7040      43.5752      76.2468     161.7389     183.6006     468.0277       2.1366     216.0000       0.1776       0.1103       0.0779       2.6003     100.6685     298.7674     210.8006      52.4606       0.2027       0.2293       0.2811       5.5230    2521.4653       9.1887      28.4375    4415.0000
 2584.8564      46.6572      75.7944     182.6759     223.9870     455.9885       2.1930     216.0000       0.1681       0.1000       0.0672       2.0186     101.1905     303.2330     207.5412      52.4606       0.2113       0.2384       0.2905       5.5119    2539.0393      11.7819      33.0625    4269.0000
 2585.0088      51.6503      78.2705     188.6709     241.9366     395.3241       2.5296     216.0000       0.1729       0.1051       0.0726       2.2660      97.9386     280.8119     190.2385      52.4606       0.1650       0.1874       0.2384       5.4761    2530.2002      13.2713      30.0625    4244.0000
 2585.1612      47.5048      80.3230     196.3033     234.0262     347.7106       2.8760     216.0000       0.1869       0.1203       0.0883       2.3688      98.4040     292.5341     172.4160      52.4606       0.1582       0.1795       0.2304       5.4469    2504.2798      11.2431      32.3750    4158.0000
 2585.3136      48.3001      82.0154     222.8352     249.1975     315.6159       3.1684     216.0000       0.1901       0.1238       0.0919       2.4450      94.8468     296.5346     174.5298      52.4606       0.1935       0.2183       0.2704       5.4066    2498.3865       9.8962      24.8125    4238.0000
 2585.4660      43.1580      97.1558     302.1021     166.5826     181.3196       5.5151     216.0000       0.2055       0.1405       0.1092       2.9259      99.6881     323.0491     168.8862      52.4606       0.1687       0.1909       0.2424       5.3835    2469.7380       9.5670      24.1250    4312.0000
 2585.6184      41.1953      91.9949     365.1760     466.2989     361.2283       2.7683     216.0000       0.2132       0.1488       0.1178       3.0308      98.2790     271.8807     156.0011      52.4606       0.1727       0.1957       0.2471       5.3472    2455.5613       7.8891      20.5000    4260.0000
 2585.7708      42.2005      68.2257     238.4631     181.5840     241.2422       4.1452     216.0000       0.2359       0.1734       0.1433       2.8207     100.4137     285.0915     125.5100      52.7402       0.1922       0.2179       0.2694       5.3358    2413.5583       6.9381      17.0625    4293.0000
 2585.9232      42.5315      56.2694     198.3856     206.8578     215.0788       4.6495     216.0000       0.2342       0.1715       0.1413       2.3959      95.2472     311.3269     116.9326      52.6004       0.2356       0.2662       0.3177       5.3173    2416.7805       6.5131      14.3750    4272.0000
 2586.0756      47.7666      53.3783     197.8649     259.5214     298.0874       3.3547     216.0000       0.2229       0.1592       0.1287       1.7127      99.9811     313.0015     138.9473      52.4606       0.2412       0.2737       0.3242       5.3499    2437.7148       7.9470       8.1875    4399.0000
 2586.2280      61.0544      69.8151     178.9327     286.2505     335.2974       2.9824     216.0000       0.2204       0.1566       0.1259       1.8166     100.9899     316.9089     170.0623      52.4606       0.2180       0.2478       0.2986       5.4528    2442.1960       8.2221       4.5625    4340.0000
 2586.3804      63.1752      70.6117     159.8310     299.9703     366.8261       2.7261     216.0000       0.2091       0.1444       0.1132       2.7243     103.8823     285.0915     206.4149      52.4606       0.1939       0.2212       0.2717       5.5609    2463.1418       9.2614       4.5625    4254.0000
 2586.5328      43.5594      66.1193     133.6906     283.2974     325.7279       3.0700     216.0000       0.1896       0.1232       0.0913       2.8987      99.5820     271.8807     229.9852      52.6004       0.2195       0.2486       0.3000       5.5812    2499.3181       9.1974       4.5625    4182.0000
 2586.6852      33.6522      67.6632     134.7948     242.8704     267.4799       3.7386     216.0000       0.1581       0.0891       0.0560       2.5333     101.0996     265.3683     248.4603      52.6004       0.2072       0.2349       0.2863       5.5235    2557.5798      11.2116       2.0000    4208.0000
 2586.8376      29.3806      69.5367     105.3442     221.6568     208.2137       4.8028     216.0000       0.1452       0.0752       0.0416       2.4737     104.2773     277.2766     240.5288      52.7402       0.1900       0.2156       0.2670       5.4247    2581.3904      10.3397      -1.8125    4156.0000
 2586.9900      30.1468      65.6607      81.8591     200.7682     135.2803       7.3921     216.0000       0.1837       0.1169       0.0848       2.7053     107.8005     287.3243     202.9066      52.6004       0.1897       0.2152       0.2666       5.4018    2510.0762       9.5750      -4.7500    4239.0000
 2587.1424      33.9898      73.2547     104.2302     196.0844     162.5750       6.1510     216.0000       0.2404       0.1782       0.1483       2.8649     103.2170     307.2334     155.8878      52.7402       0.1985       0.2256       0.2767       5.4499    2405.3323       8.0628      -8.5625    4182.0000
 2587.2948      37.5119      87.7906     125.9521     223.9000     209.1892       4.7804     216.0000       0.2797       0.2207       0.1924       2.5305      99.4231     293.4644     121.5804      52.4606       0.2610       0.2953       0.3457       5.5130    2332.5708       7.7053     -14.9375    4221.0000
 2587.4472      37.9017      79.4721     135.6828     211.7298     220.4958       4.5352     216.0000       0.2717       0.2120       0.1834       2.3868      98.0007     300.1629     102.8075      52.7402       0.2696       0.3059       0.3552       5.4725    2347.4365       7.1722     -17.7500    4293.0000
 2587.5996      35.2335      56.2984     108.7862     165.9915     259.3130       3.8563     216.0000       0.2343       0.1716       0.1415       2.4305     100.4162     307.0474     103.5080      52.7402       0.2114       0.2413       0.2915       5.3821    2416.4958       8.2041     -19.0000    4220.0000
 2587.7520      46.4801      65.3581     128.3932     151.5315     379.0941       2.6379     216.0000       0.2015       0.1362       0.1048       2.5182      98.1086     316.3507     119.9431      52.7402       0.2330       0.2639       0.3150       5.4090    2477.1521      10.8983     -24.6875    4121.0000
 2587.9044      57.3074     104.8265     232.4732     302.7395     553.3203       1.8073     216.0000       0.1971       0.1314       0.0998       2.5758      95.0323     296.5346     152.8785      52.7402       0.2261       0.2558       0.3073       5.7021    2485.2935      13.5865     -24.6875    4157.0000
 2588.0568      55.9572     180.7215     416.6474     518.0552     980.2847       1.0201     216.0000       0.2283       0.1651       0.1348       2.5925      96.3330     305.7449     180.5305      52.7402       0.1906       0.2154       0.2673       6.2062    2427.6614      11.5528     -24.6875    4152.0000
 2588.2092      64.8803     275.1050    1911.7023    1950.0000    1950.0000       0.5008     216.0000       0.2587       0.1980       0.1689       2.4354      96.7980     259.2281     218.0347      52.7402       0.1753       0.1989       0.2502       6.7338    2371.3425       7.4225     -35.2500    4133.0000
 2588.3616      73.5021     376.6047    1059.4276    1131.2103    1636.7588       0.6110     216.0000       0.2727       0.2131       0.1845       2.2469      90.5268     258.2978     259.6609      52.7402       0.1868       0.2106       0.2628       7.1687    2345.5710       5.1384     -34.5000    4172.0000
 2588.5140      83.3089     446.3556    1320.8157    1181.1448    1575.3177       0.6348     216.0000       0.2435       0.1816       0.1518       2.5237      69.7010     263.3217     328.2344      52.7402       0.2384       0.2654       0.3192       7.4047    2399.4517       6.1071     -41.2500    4244.0000
 2588.6664      90.0969     466.4559    1950.0000    1809.8000    1887.5778       0.5298     216.0000       0.2283       0.1651       0.1347       2.5983      47.6965     256.6232     374.8250      52.7402       0.0990       0.1147       0.1600       7.5396    2427.7324       9.6007     -44.2500    4348.0000
 2588.8188      96.0896     464.2880    1681.6676     779.6278     973.0858       1.0277     216.0000       0.2020       0.1366       0.1052       2.4667      31.3128     279.8816     412.5390      52.7402      -0.0103      -0.0094       0.0200       7.5504    2476.3433      31.3170     -48.3750    4281.0000
 2588.9712     102.1657     483.0218    1596.4056     521.4713     655.1818       1.5263     216.0000       0.1842       0.1174       0.0853       2.2413      24.4975     261.3680     403.4059      52.7402      -0.0135      -0.0100       0.0164       7.4834    2509.2827      25.7868     -44.2500    4145.0000
 2589.1236     109.9725     570.6777    1243.5209     315.9099     348.3835       2.8704     216.0000       0.1322       0.0611       0.0270       2.4048      20.7037     256.6232     360.3609      52.7402      -0.0063       0.0007       0.0270       7.2317    2605.5056      15.9136     -45.7500    4139.0000
 2589.2760     118.7788     606.7621    1079.5991     226.0222     302.7944       3.3026     216.0000       0.0818       0.0066      -0.0295       2.2267      17.0182     253.2740     270.1028      52.7402      -0.0123      -0.0078       0.0183       6.7979    2698.6804      15.4716     -46.0625    4139.0000
 2589.4284     122.8225    1595.1265    1271.5524     231.8088     265.0195       3.7733     216.0000       0.0542      -0.0232      -0.0604       2.5355      15.2787     236.3419     161.2124      52.7402      -0.0080      -0.0027       0.0243       6.2492    2749.6987      24.9004     -47.3750    4101.0000
 2589.5808      99.8757     917.0749     585.4316     210.3340     193.3473       5.1720     216.0000       0.0625      -0.0143      -0.0512       2.5367      13.2191     224.8058      80.3633      52.7402      -0.0068      -0.0011       0.0260       5.8218    2734.4563     147.1376     -45.8750    4144.0000
 2589.7332      95.2119     881.0154     646.1580     196.9963     169.8624       5.8871     216.0000       0.0780       0.0025      -0.0338       2.3266      12.9678     225.3640      51.3124      52.7402      -0.0080      -0.0016       0.0246       5.6360    2705.7561    4709.0972     -52.8125    4133.0000
 2589.8856     105.7488     603.2993     826.7117     220.8018     170.0728       5.8798     216.0000       0.0786       0.0031      -0.0331       2.3048      12.6478     224.4336      57.0137      52.7402      -0.0091      -0.0025       0.0231       5.6395    2704.6255    1785.5349     -54.0000    4135.0000
 2590.0380      97.9066     366.9750     641.5251     233.2047     172.8435       5.7856     216.0000       0.0741      -0.0017      -0.0381       2.3051      12.3226     223.1312      56.3521      52.7402      -0.0126      -0.0068       0.0183       5.6439    2712.8289    1789.1367     -54.0000    4121.0000
 2590.1904      98.5793     258.8983     884.0956     293.4171     202.8440       4.9299     216.0000       0.0792       0.0038      -0.0324       2.7667      13.2197     222.7590      35.0182      52.7402      -0.0139      -0.0086       0.0164       5.6091    2703.4392    1797.1564     -54.0000    4147.0000
 2590.3428      99.1499     143.7222     653.5328     335.8328     218.4184       4.5784     216.0000       0.0897       0.0152      -0.0207       2.1585      12.8945     222.9451      40.6609      52.7402      -0.0126      -0.0069       0.0183       5.8057    2684.0781    4663.1382     -54.0000    4166.0000
 2590.4952      91.8437      86.5496     707.7737     421.4389     266.8592       3.7473     216.0000       0.0866       0.0119      -0.0241       2.3240      13.5405     222.8521      95.5694      52.7402      -0.0121      -0.0066       0.0188       6.2119    2689.7195    4681.6401     -55.1875    4165.0000
 2590.6476      89.6977      66.0459     589.4206     333.2954     174.9540       5.7158     216.0000       0.0813       0.0060      -0.0301       2.4080      13.9788     234.2952     184.0143      52.7402      -0.0141      -0.0088       0.0161       6.7409    2699.6624     953.9600     -54.5625    4212.0000
 2590.8000      83.0902      58.4045     866.5933     474.0989     267.8482       3.7335     216.0000       0.0846       0.0096      -0.0264       2.0057      13.4368     243.2264     260.5615      52.7402      -0.0133      -0.0077       0.0172       7.1220    2693.5054     416.6559     -57.0625    4206.0000
 2590.9524      81.6397      61.6296    1012.5569     542.7592     318.6785       3.1380     216.0000       0.1049       0.0316      -0.0036       2.3341      13.7663     240.6215     312.2056      52.7402      -0.0090      -0.0023       0.0233       7.3998    2656.0085     206.7002     -56.4375    4190.0000
 2591.1048      82.0563      74.8451    1191.1221     545.1857     334.5685       2.9889     216.0000       0.1169       0.0446       0.0099       2.8889      12.1229     246.7617     362.1559      52.7402      -0.0090      -0.0029       0.0232       7.5867    2633.7361     108.2933     -55.5625    4152.0000
 2591.2572      84.0511     104.4630    1927.6831     985.9368     621.9965       1.6077     216.0000       0.1231       0.0513       0.0168       2.3072      12.9901     246.9477     402.8244      52.7402      -0.0036       0.0035       0.0305       7.7035    2622.2280      64.4841     -54.0000    4239.0000
 2591.4096      88.4365     166.5536    1892.0284    1248.7635     458.5308       2.1809     216.0000       0.1359       0.0652       0.0312       2.2902      14.8328     253.0879     414.7017      52.7402      -0.0061      -0.0002       0.0269       7.7528    2598.5327      45.4153     -61.7500    4129.0000
 2591.5620      94.2108     302.0501    1879.4482    1270.4991     840.8960       1.1892     216.0000       0.1417       0.0714       0.0377       2.2314      15.3922     263.6007     405.7321      52.7402      -0.0095      -0.0040       0.0224       7.7407    2587.8423      37.0602     -61.5625    4125.0000
 2591.7144     101.5871     552.7029    1816.6593     784.7618     501.9119       1.9924     216.0000       0.1527       0.0833       0.0500       2.4482      14.4167     270.8573     376.5793      52.7402      -0.0100      -0.0039       0.0218       7.6873    2567.5405      37.1566     -63.6875    4215.0000
 2591.8668     107.1630     882.1169    1950.0000     867.8133     747.3843       1.3380     216.0000       0.1638       0.0954       0.0625       2.5768      13.4958     268.3454     352.4976      52.7402      -0.0108      -0.0042       0.0209       7.6422    2546.9026      34.1709     -63.7500    4197.0000
 2592.0192     110.9182    1024.9960    1950.0000    1424.7151    1068.8093       0.9356     216.0000       0.1578       0.0889       0.0558       2.2104      13.1706     283.6029     355.6537      52.7402      -0.0129      -0.0067       0.0180       7.6098    2558.0093      37.0319     -67.8125    4132.0000
 2592.1716     113.3086     942.0847    1932.7432    1044.3763     924.9604       1.0811     216.0000       0.1445       0.0745       0.0409       2.3620      14.7966     275.6021     368.9525      52.7402      -0.0085      -0.0015       0.0241       7.6004    2582.5894      30.3596     -64.9375    4100.0000
 2592.3240     114.6596     852.4076    1950.0000    1217.5001    1095.9894       0.9124     216.0000       0.1292       0.0580       0.0237       2.7532      14.6335     271.1364     374.5956      52.7402      -0.0117      -0.0061       0.0194       7.5792    2610.8943      17.7846     -70.7500    4235.0000
 2592.4764     115.0993     838.3814    1950.0000    1244.8937    1023.1925       0.9773     216.0000       0.1310       0.0599       0.0257       2.6167      14.8503     276.7184     363.3406      52.7402      -0.0159      -0.0104       0.0138       7.5619    2607.6465      15.2716     -71.2500    4362.0000
 2592.6288     114.5883     875.4762    1950.0000    1773.8939    1053.1824       0.9495     216.0000       0.1338       0.0629       0.0289       2.4968      13.5854     261.9261     363.1129      52.7402      -0.0149      -0.0094       0.0151       7.5673    2602.3806      15.0746     -73.5625    4367.0000
 2592.7812     113.1055     905.5467    1950.0000    1348.2343     886.0564       1.1286     216.0000       0.1273       0.0559       0.0216       2.5976      12.5014     272.5320     386.3831      52.7402      -0.0167      -0.0115       0.0127       7.5990    2614.4221      21.1475     -68.1875    4277.0000
 2592.9336     111.1112     846.7110    1950.0000    1633.3556     504.3125       1.9829     216.0000       0.1286       0.0572       0.0230       2.1307      14.4525     251.7855     403.0664      52.7402      -0.0111      -0.0055       0.0202       7.6469    2612.1094      23.9584     -75.4375    4187.0000
 2593.0860     109.6934     702.3365    1950.0000    1636.2299     486.1450       2.0570     216.0000       0.1292       0.0579       0.0236       2.0560      14.1999     241.7379     402.2405      52.7402      -0.0072      -0.0011       0.0255       7.6483    2611.0518      36.2243     -75.7500    4174.0000
 2593.2384     109.9644     557.5020    1950.0000    1582.1208     380.7271       2.6266     216.0000       0.1194       0.0473       0.0127       2.1988      13.3327     257.4605     390.1258      52.7402      -0.0091      -0.0030       0.0230       7.5695    2629.1003      48.9325     -73.5625    4247.0000
 2593.3908     112.5824     461.8768    1950.0000    1236.8793     307.9180       3.2476     216.0000       0.1083       0.0353       0.0002       2.1370      13.2652     248.4363     376.7998      52.7402      -0.0037       0.0034       0.0304       7.4591    2649.6587      45.1418     -73.5625    4207.0000
 2593.5432     117.6192     419.7652    1950.0000    1575.6334     358.8118       2.7870     216.0000       0.1159       0.0435       0.0087       2.8238      13.9156     263.5077     361.4926      52.7402      -0.0099      -0.0044       0.0218       7.3934    2635.5750      29.5258     -73.5625    4170.0000
 2593.6956     124.3302     424.9467    1950.0000    1715.7814     582.7198       1.7161     216.0000       0.1223       0.0504       0.0159       2.7509      14.8912     264.2520     359.3082      52.7402      -0.0051       0.0013       0.0283       7.3751    2623.7651      24.7348     -73.5625    4216.0000
 2593.8480     130.9141     480.0747    1950.0000    1799.9578     754.7979       1.3249     216.0000       0.1081       0.0351       0.0000       2.2014      13.1159     273.3693     365.1128      52.7402      -0.0071      -0.0012       0.0256       7.3380    2649.9944      28.6268     -73.5625    4233.0000
 2594.0004     134.8892     597.4072    1950.0000    1925.4930    1110.0311       0.9009     216.0000       0.0959       0.0219      -0.0137       2.5642      12.4655     271.1364     354.5668      52.7402      -0.0047       0.0019       0.0289       7.2718    2672.5764      39.9783     -76.6250    4303.0000
 2594.1528     134.6654     795.7205    1950.0000    1950.0000    1913.3246       0.5227     216.0000       0.1008       0.0271      -0.0082       2.4106      12.4611     268.3454     329.2418      52.7402      -0.0056       0.0009       0.0278       7.2092    2663.5913      49.8281     -75.3750    4271.0000
 2594.3052     131.1442    1080.2087    1950.0000    1950.0000    1683.3917       0.5940     216.0000       0.1285       0.0571       0.0228       2.3651      12.0065     275.9742     298.4610      52.7402      -0.0058       0.0010       0.0275       7.2109    2612.3569      62.6212     -76.1250    4191.0000
 2594.4576     127.0871    1405.5566    1950.0000    1923.9293    1219.1083       0.8203     216.0000       0.1259       0.0543       0.0200       2.5596      11.8981     279.3234     309.0127      52.7402      -0.0109      -0.0061       0.0203       7.2250    2617.0627      51.3495     -73.1875    4159.0000
 2594.6100     125.1721    1669.0522    1950.0000    1950.0000    1225.9667       0.8157     216.0000       0.1218       0.0499       0.0154       2.3593      12.0110     279.5095     328.0914      52.7402      -0.0058      -0.0005       0.0272       7.2500    2624.6143      57.0235     -73.5625    4168.0000
 2594.7624     126.9988    1787.5128    1950.0000    1890.5752    1181.0667       0.8467     216.0000       0.1370       0.0664       0.0324       2.3946      14.5251     273.0901     329.2785      52.7402      -0.0034       0.0022       0.0303       7.2741    2596.5254      35.0820     -73.1875    4244.0000
 2594.9148     133.2646    1775.1055    1950.0000    1950.0000    1242.7384       0.8047     216.0000       0.1533       0.0839       0.0506       2.4503      15.8206     273.1832     325.5742      52.7402      -0.0013       0.0049       0.0333       7.2679    2566.4792      41.6261     -73.5625    4337.0000
 2595.0672     144.1358    1709.1484    1950.0000    1950.0000    1489.3689       0.6714     216.0000       0.2044       0.1393       0.1080       2.4621      15.8206     275.0439     294.2557      52.7402       0.0017       0.0088       0.0375       7.3115    2471.8538      27.6180     -73.8750    4317.0000
 2595.2196     159.1302    1664.1412    1950.0000    1851.1335    1448.3228       0.6905     216.0000       0.2202       0.1564       0.1257       2.3785      16.0312     277.2766     304.4055      52.7402       0.0082       0.0160       0.0461       7.3227    2442.6057      33.2602     -73.5625    4279.0000
 2595.3720     176.2023    1679.8896    1896.4813    1778.4349    1497.2264       0.6679     216.0000       0.2252       0.1617       0.1312       2.4682      17.2403     271.9737     327.6238      52.7402       0.0064       0.0128       0.0434       7.3249    2433.4624      31.7699     -77.8125    4214.0000
 2595.5244     191.1657    1774.5845    1730.0688    1601.2051    1469.3799       0.6806     216.0000       0.1788       0.1116       0.0793       2.5954      18.9684     271.6946     383.2993      52.7402       0.0151       0.0231       0.0550       7.2378    2519.1543      42.6853     -71.1250    4233.0000
 2595.6768     198.5080    1828.4969    1817.9193    1562.0613    1400.5236       0.7140     216.0000       0.1632       0.0947       0.0618       2.5923      17.7823     273.0901     392.0779      52.7402       0.0128       0.0212       0.0521       7.1617    2548.0955      46.1393     -73.5625    4271.0000
 2595.8292     194.7311    1950.0000    1683.2854    1292.2589    1103.3960       0.9063     216.0000       0.1837       0.1169       0.0848       2.5290      17.9809     273.9275     345.0417      52.7402       0.0007       0.0066       0.0358       7.0907    2510.1021      21.9647     -72.1250    4235.0000
 2595.9816     179.0078    1698.0894    1369.8636    1050.3706     871.7280       1.1471     216.0000       0.1761       0.1087       0.0762       2.2361      18.8543     247.6920     281.5056      52.7402       0.0049       0.0117       0.0415       6.8680    2524.2070      12.5156     -73.5625    4168.0000
 2596.1340     162.4141    1356.1964    1579.0415     966.5091     739.8904       1.3516     216.0000       0.1329       0.0619       0.0278       2.1487      21.6726     230.7599     205.4749      52.7402       0.0055       0.0113       0.0421       6.4371    2604.1704      14.2814     -73.0625    4223.0000
 2596.2864     147.2879    1132.3400    1736.1755     934.2596     681.2249       1.4679     216.0000       0.0735      -0.0024      -0.0388       2.6852      22.9800     223.8754     135.6335      52.7402       0.0080       0.0143       0.0454       5.8823    2714.0376      28.1068     -75.3750    4180.0000
 2596.4388     160.0736    1082.9481    1687.1207     858.5763     719.7010       1.3895     216.0000       0.0619      -0.0150      -0.0519       2.5973      21.3540     220.5262      59.2518      52.7402       0.0027       0.0084       0.0384       5.4317    2735.5691     595.8148     -72.6250    4206.0000
 2596.5912     158.7603     839.2188    1624.6945     888.6849     636.4033       1.5713     216.0000       0.0743      -0.0015      -0.0379       2.6414      18.1105     220.7123      14.0634      52.7402       0.0001       0.0056       0.0350       5.2122    2712.5837    2090.8176     -70.2500    4261.0000
 2596.7436     165.2393     643.2908    1521.3296     703.0667     622.9727       1.6052     216.0000       0.0851       0.0102      -0.0258       3.0263      15.6173     220.3402      -1.0240      52.7402       0.0064       0.0140       0.0437       5.1485    2692.5125    1825.4314     -69.8750    4155.0000
 2596.8960     169.4852     547.8804    1513.2535     601.2300     471.4273       2.1212     216.0000       0.0854       0.0105      -0.0255       2.6996      15.7811     219.9680      -0.0606      52.7402       0.0028       0.0088       0.0386       5.1392    2691.9951    1577.6356     -70.1875    4217.0000
 2597.0484     179.2766     540.8701    1798.0444     923.6024     683.2129       1.4637     216.0000       0.0838       0.0088      -0.0273       2.2558      16.3951     220.3402       1.3695      52.7402       0.0047       0.0111       0.0412       5.1429    2695.0193    1547.4917     -67.6875    4193.0000
 2597.2008     185.4975     586.5699    1833.7815    1031.9490     873.9365       1.1442     216.0000       0.0798       0.0044      -0.0318       2.0887      15.3112     220.5262       2.4199      52.7402       0.0104       0.0179       0.0489       5.1422    2702.4282    1607.4705     -67.8750    4250.0000
 2597.3532     187.2091     658.8658    1900.0004    1130.6392    1138.3395       0.8785     216.0000       0.0809       0.0056      -0.0305       2.5709      16.0145     219.7820       1.4803      52.7402       0.0056       0.0119       0.0424       5.1778    2700.3789    1889.7889     -66.8125    4244.0000
 2597.5056     183.3183     736.4583    1943.9552    1811.6703    1663.6632       0.6011     216.0000       0.0863       0.0115      -0.0245       2.5144      16.7953     219.7820      -1.4923      52.7402       0.0049       0.0116       0.0415       5.1984    2690.3730    2133.7708     -65.9375    4183.0000
 2597.6580     174.2598     770.5392    1950.0000    1800.7698    1950.0000       0.5001     216.0000       0.0915       0.0171      -0.0187       2.1442      18.3129     220.0611      -4.2872      52.7402       0.0017       0.0080       0.0372       5.2045    2680.8013    2712.8682     -64.5625    4196.0000
 2597.8104     161.3403     716.4973    1950.0000    1543.5389    1927.6169       0.5188     216.0000       0.0894       0.0148      -0.0210       2.6836      16.3573     219.4098       3.0870      52.7402       0.0007       0.0074       0.0361       5.1751    2684.6653    2823.5481     -63.7500    4232.0000
 2597.9628     147.9762     618.8880    1513.4552    1395.7025     855.0668       1.1695     216.0000       0.0898       0.0153      -0.0205       2.5478      13.9787     219.5029      13.0043      52.7402      -0.0021       0.0036       0.0321       5.1686    2683.8767    3490.6028     -63.7500    4237.0000
 2598.1152     132.2787     458.2695    1159.8370    1137.2284     478.1569       2.0914     216.0000       0.1004       0.0267      -0.0087       2.5435      12.3926     219.5959      30.2846      52.7402      -0.0043       0.0009       0.0291       5.3200    2664.3059    3764.0115     -68.9375    4247.0000
 2598.2676     122.8130     359.3505     884.1443     785.8077     423.6422       2.3605     216.0000       0.1063       0.0332      -0.0020       2.4574      12.3970     219.9680      88.4080      52.7402      -0.0052       0.0003       0.0280       5.7390    2653.2681     639.9846     -63.7500    4200.0000
 2598.4200     122.0455     422.6426     890.8061     949.2241     529.1790       1.8897     216.0000       0.1113       0.0385       0.0036       2.1672      12.5016     223.6894     171.0377      52.7402      -0.0025       0.0044       0.0319       6.2133    2644.1340     134.6835     -64.8750    4158.0000
 2598.5724     133.6857     432.1659    1267.5315    1253.0851     741.7672       1.3481     216.0000       0.0914       0.0170      -0.0188       2.3750      13.1158     228.1550     269.1143      52.7402      -0.0030       0.0043       0.0314       6.5523    2680.9819      85.1674     -62.2500    4181.0000
 2598.7248     148.5764     471.2460    1393.1136    1346.8862     879.4358       1.1371     216.0000       0.0773       0.0018      -0.0345       2.6689      12.4654     229.8296     311.2953      52.7402      -0.0039       0.0023       0.0299       6.6319    2706.9158      95.0322     -62.8750    4224.0000
 2598.8772     166.8589     510.0896    1559.2562    1477.7527    1123.7064       0.8899     216.0000       0.0610      -0.0158      -0.0528       2.5872      12.7903     234.6673     313.0500      52.7402      -0.0043       0.0019       0.0294       6.5917    2737.0930     170.1368     -62.8125    4192.0000
 2599.0296     184.2579     601.8416    1723.9216    1580.4418    1355.0344       0.7380     216.0000       0.0756      -0.0001      -0.0364       2.5267      13.0034     234.4812     275.3088      52.7402      -0.0057       0.0001       0.0274       6.5281    2710.1255     132.4001     -63.1875    4174.0000
 2599.1820     197.8375     749.2952    1950.0000    1950.0000    1950.0000       0.5078     216.0000       0.0872       0.0125      -0.0234       2.5658      13.7576     246.2965     232.7168      52.7402      -0.0077      -0.0014       0.0249       6.4358    2688.6772      82.4557     -62.2500    4144.0000
 2599.3344     202.1274     940.4119    1950.0000    1648.1887    1950.0000       0.5000     216.0000       0.0862       0.0114      -0.0245       2.3926      13.3038     245.2731     189.5385      52.7402      -0.0055       0.0014       0.0280       6.2938    2690.4590      66.2440     -63.7500    4177.0000
 2599.4868     195.5699    1065.7139    1950.0000    1700.5610    1755.8502       0.5695     216.0000       0.0690      -0.0073      -0.0439       2.4783      13.5206     238.2026     152.1864      52.7402      -0.0096      -0.0044       0.0221       6.1187    2722.4336     105.9026     -60.8750    4175.0000
 2599.6392     182.8320     982.3687    1950.0000    1695.9968    1118.3062       0.8942     216.0000       0.0667      -0.0098      -0.0465       2.4585      13.5206     240.6215     129.8387      52.7402      -0.0076      -0.0020       0.0249       6.0169    2726.6821     271.4840     -63.7500    4235.0000
 2599.7916     169.8533     752.1063    1950.0000    1950.0000     849.5555       1.1771     216.0000       0.0742      -0.0016      -0.0380       2.4455      15.7524     229.6435     130.2853      52.7402      -0.0049       0.0013       0.0286       6.0330    2712.7151     795.6665     -65.0000    4283.0000
 2599.9440     159.7678     541.5281    1950.0000    1196.2793     782.9305       1.2773     216.0000       0.0758       0.0001      -0.0362       2.1610      15.2105     245.1801     142.0538      52.7402      -0.0053       0.0015       0.0282       6.0921    2709.7979     214.0121     -61.8750    4156.0000
 2600.0964     152.9849     407.6946    1950.0000    1664.7610     498.7185       2.0051     216.0000       0.0769       0.0013      -0.0350       2.3168      15.4318     239.5981     140.2991      52.7402      -0.0059       0.0003       0.0273       6.1300    2707.8152     188.6781     -63.7500    4236.0000
 2600.2488     148.6053     338.8047    1950.0000    1319.3926     680.1094       1.4704     216.0000       0.0943       0.0201      -0.0155       2.3685      15.4263     249.6457     130.7890      52.7402      -0.0086      -0.0039       0.0232       6.1823    2675.5815      56.9463     -63.5000    4221.0000
 2600.4012     145.6403     319.0279    1850.9753    1033.8052     729.4380       1.3709     216.0000       0.1118       0.0391       0.0041       2.6096      16.1851     251.9715     139.7610      52.7402      -0.0019       0.0048       0.0327       6.3000    2643.1941      52.9014     -63.3750    4175.0000
 2600.5536     142.0191     344.8309    1660.3551     766.5021     747.2975       1.3382     216.0000       0.1066       0.0335      -0.0017       2.3968      16.7270     246.9477     168.6120      52.7402       0.0037       0.0118       0.0404       6.3986    2652.7942      51.2512     -62.6250    4166.0000
 2600.7060     142.4234     403.8442    1425.9124     643.6195     708.3201       1.4118     216.0000       0.0880       0.0133      -0.0226       2.3010      15.9197     248.4363     189.0364      52.7402      -0.0044       0.0014       0.0292       6.4356    2687.2583     206.1509     -63.7500    4197.0000
 2600.8584     137.6195     614.5527    1950.0000     458.8827     759.0393       1.3175     216.0000       0.0819       0.0067      -0.0294       2.8178      14.8313     261.3680     196.6236      52.7402      -0.0090      -0.0045       0.0227       6.4522    2698.4690     323.3320     -63.7500    4250.0000
 2601.0108     131.2756     854.2017    1082.5920     500.9313     709.1035       1.4102     216.0000       0.1282       0.0569       0.0226       2.4396      13.0970     252.4367     196.9197      52.7402      -0.0038       0.0018       0.0299       6.6039    2612.7693      87.4923     -65.2500    4260.0000
 2601.1632     129.3819     893.5423    1161.2966     410.8497     728.0214       1.3736     216.0000       0.2163       0.1522       0.1213       2.4482      12.3527     257.4605     187.9995      52.7402      -0.0046       0.0016       0.0290       6.8513    2449.8025      14.7935     -64.0625    4202.0000
 2601.3156     125.0793    1061.9772    1044.3762     398.2774     663.4745       1.5072     216.0000       0.2383       0.1759       0.1459       2.6343      14.6187     255.5068     199.7151      52.7402       0.0106       0.0210       0.0500       6.9076    2409.1899       8.5012     -68.2500    4198.0000
 2601.4680     145.8146    1071.5820     840.3058     499.6277     684.1614       1.4616     216.0000       0.1944       0.1284       0.0967       2.3401      15.2648     222.9451     181.7815      52.7402       0.0190       0.0290       0.0606       6.6423    2490.4109       9.0597     -63.7500    4225.0000
 2601.6204     169.2224     767.9294    1068.4395     574.5411     795.5504       1.2570     216.0000       0.1023       0.0289      -0.0065       2.3900      16.6740     222.2008     147.9959      52.7402       0.0067       0.0125       0.0436       6.0789    2660.6609      20.0287     -66.9375    4190.0000
 2601.7728     166.4751     796.0184    1317.0900     847.6633     925.7389       1.0802     216.0000       0.0821       0.0069      -0.0292       2.3852      14.9544     221.2705      67.8937      52.7402      -0.0009       0.0034       0.0333       5.6250    2698.1548     245.2384     -63.7500    4268.0000
 2601.9252     162.8717     724.4935    1332.7739     993.8203     852.0081       1.1737     216.0000       0.0869       0.0121      -0.0238       2.4292      16.5225     220.8984      17.3969      52.7402      -0.0022       0.0030       0.0319       5.3472    2689.3254    2369.7332     -63.7500    4326.0000
 2602.0776     155.7485     594.5771    1642.5219    1360.0458     758.4927       1.3184     216.0000       0.1043       0.0309      -0.0043       2.5213      16.1974     220.8984      -1.7250      52.7402      -0.0054       0.0002       0.0277       5.3033    2657.1018    2250.8794     -63.7500    4382.0000
 2602.2300     150.3030     513.7101    1894.9476    1794.0066    1033.7415       0.9674     216.0000       0.1156       0.0431       0.0083       2.5904      18.0333     221.8287      26.6981      52.7402      -0.0082      -0.0032       0.0238       5.5343    2636.2261    2220.6992     -64.5625    4289.0000
 2602.3824     148.6245     452.9946    1950.0000    1950.0000    1950.0000       0.3827     216.0000       0.1228       0.0509       0.0164       2.3387      17.3366     239.5981      99.9174      52.7402      -0.0119      -0.0078       0.0187       5.9798    2622.9097     125.4888     -63.7500    4196.0000
 2602.5348     151.6965     407.0337    1950.0000    1950.0000    1440.9171       0.6940     216.0000       0.1441       0.0740       0.0403       2.5120      18.2037     249.3666     197.4518      52.7402       0.0027       0.0111       0.0391       6.5281    2583.5061      36.5048     -63.7500    4128.0000
 2602.6872     160.2617     383.8861    1950.0000    1950.0000    1339.7753       0.7464     216.0000       0.1489       0.0792       0.0457       2.6457      17.5793     262.7634     295.3572      52.7402       0.0020       0.0109       0.0384       6.8867    2574.5173      20.7436     -63.7500    4239.0000
 2602.8396     174.2993     393.1519    1950.0000    1950.0000    1532.9319       0.6523     216.0000       0.1350       0.0641       0.0301       2.5111      18.0129     258.2978     354.4953      52.7402      -0.0034       0.0034       0.0307       7.0114    2600.3401      19.2005     -61.7500    4196.0000
 2602.9920     191.3181     446.8128    1950.0000    1881.5424    1557.7166       0.6420     216.0000       0.1013       0.0277      -0.0077       2.4514      17.1403     259.1351     358.3031      52.7402       0.0017       0.0094       0.0376       6.9414    2662.6873      25.5193     -65.8125    4207.0000
 2603.1444     204.4083     563.5794    1950.0000    1950.0000    1950.0000       0.5083     216.0000       0.0801       0.0048      -0.0314       2.4941      16.0372     248.5293     313.5064      52.7402       0.0008       0.0072       0.0360       6.7370    2701.8550      42.5781     -56.0625    4226.0000
 2603.2968     205.6626     765.0561    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0791       0.0037      -0.0325       2.4648      15.4952     228.7132     243.6936      52.7402      -0.0011       0.0043       0.0334       6.4801    2703.6257      76.5091     -63.7500    4220.0000
 2603.4492     194.8076    1032.6833    1950.0000    1850.3101    1390.5022       0.7192     216.0000       0.0740      -0.0018      -0.0382       2.6683      16.6850     225.5500     181.3588      52.7402       0.0014       0.0077       0.0368       6.1666    2713.0645     109.8272     -60.5625    4249.0000
 2603.6016     179.1667    1227.5220    1950.0000    1451.7533     791.1172       1.2640     216.0000       0.0739      -0.0019      -0.0384       2.7854      15.5970     223.5033     111.1393      52.7402       0.0028       0.0099       0.0389       5.8253    2713.2820     223.5191     -61.3125    4264.0000
 2603.7540     165.0425    1169.2483    1950.0000    1195.5779     597.8421       1.6727     216.0000       0.0803       0.0050      -0.0311       2.3758      14.9466     222.3869      46.4470      52.7402      -0.0027       0.0034       0.0315       5.5457    2701.3745     729.2238     -61.0625    4231.0000
 2603.9064     155.0792     948.1112    1796.9503    1130.5885     518.4349       1.9289     216.0000       0.0846       0.0096      -0.0264       2.6266      13.7325     222.2939       7.9730      52.7402      -0.0082      -0.0032       0.0239       5.3894    2693.5483    3013.0647     -54.3125    4219.0000
 2604.0588     147.9790     717.2581    1950.0000    1176.6581     469.6873       2.1291     216.0000       0.0852       0.0103      -0.0257       2.5777      14.0573     222.0148      -4.3650      52.7402      -0.0062      -0.0001       0.0269       5.3633    2692.4148    2514.6965     -58.3750    4225.0000
 2604.2112     143.5476     557.5809    1928.4901     996.2055     474.4791       2.1076     216.0000       0.0825       0.0074      -0.0287       2.1108      14.9245     222.2939      -5.1949      52.7402      -0.0083      -0.0026       0.0240       5.3448    2697.3850    1990.0194     -59.5000    4248.0000
 2604.3636     139.3813     456.7658    1838.8175     993.7723     570.3477       1.7533     216.0000       0.0849       0.0100      -0.0260       2.6669      14.5158     222.5730      -6.4495      52.7402      -0.0066      -0.0004       0.0263       5.3581    2692.8904    1771.0419     -58.7500    4286.0000
 2604.5160     136.1216     393.7700    1773.4679    1009.8402     714.7957       1.3990     216.0000       0.0854       0.0105      -0.0255       2.9416      15.4725     222.3869      -5.7237      52.7402      -0.0057       0.0008       0.0276       5.3739    2692.0608    1549.3607     -54.7500    4207.0000
 2604.6684     131.9142     364.0345    1701.8776    1093.1334     904.5419       1.1055     216.0000       0.0901       0.0156      -0.0202       2.7830      15.2557     222.7590      -4.8025      52.7402      -0.0066      -0.0006       0.0263       5.4128    2683.2903    1629.9967     -54.0625    4269.0000
 2604.8208     128.8378     326.4693    1433.1237     907.5961     910.9106       1.0978     216.0000       0.1001       0.0264      -0.0090       2.5839      16.1220     223.1312      -2.0397      52.7402      -0.0082      -0.0026       0.0240       5.4398    2664.8708    1843.8074     -54.0000    4329.0000
 2604.9732     126.3831     369.8412    1530.7877    1062.2806    1047.9246       0.9543     216.0000       0.1033       0.0299      -0.0054       2.6580      15.6032     223.1312      30.0510      52.7402      -0.0055       0.0007       0.0278       5.6231    2658.9312    1012.2182     -55.5625    4277.0000
 2605.1256     121.9587     378.5545    1385.7384     782.5203     862.2697       1.1597     216.0000       0.0915       0.0171      -0.0186       2.8427      15.2734     224.8058      97.9886      52.7402      -0.0063      -0.0004       0.0266       5.9964    2680.6807     324.9375     -54.0000    4284.0000
 2605.2780     117.6550     380.6863    1238.9578     545.3066     596.7540       1.6757     216.0000       0.0675      -0.0089      -0.0456       2.5892      14.4120     224.6197     179.9686      52.7402      -0.0044       0.0016       0.0291       6.4325    2725.1992     200.8772     -54.0000    4233.0000
 2605.4304     111.3517     299.4305     804.3241     358.2704     299.3961       3.3401     216.0000       0.0590      -0.0180      -0.0550       2.2893      14.6288     227.3177     241.0395      52.7402      -0.0069      -0.0018       0.0256       6.7533    2740.7576     187.2050     -54.0000    4269.0000
 2605.5828     105.6616     299.6325     698.6299     191.5240     204.3334       4.8940     216.0000       0.0990       0.0252      -0.0103       2.6368      13.9831     237.6444     263.6425      52.7402      -0.0037       0.0031       0.0304       6.9865    2666.9395     158.4469     -54.5000    4252.0000
 2605.7352     129.1346     479.9050    1198.8832     282.9025     385.7992       2.5920     216.0000       0.1667       0.0985       0.0657       2.7861      14.7828     250.1109     270.1256      52.7402      -0.0027       0.0051       0.0319       7.2114    2541.5347      56.9526     -53.3125    4261.0000
 2605.8876     128.9705     536.4178    1836.1962     451.3502     431.8479       2.3156     216.0000       0.1696       0.1016       0.0689       2.8782      15.4332     254.5765     310.0357      52.7402      -0.0059       0.0004       0.0273       7.2996    2536.3311      49.6504     -55.6250    4255.0000
 2606.0400     130.3863     584.8511    1638.4681     462.0009     371.9099       2.6888     216.0000       0.1291       0.0578       0.0236       2.5091      17.0591     236.8071     330.4431      52.7402       0.0006       0.0069       0.0358       7.2136    2611.0779      57.1131     -53.6250    4235.0000
 2606.1924     111.4449     354.5082     612.8115     279.1243     233.1461       4.2892     216.0000       0.0692      -0.0070      -0.0436       2.5668      16.1510     225.3640     328.5038      52.7402       0.0025       0.0090       0.0383       6.9985    2721.9546     135.2814     -48.8750    4270.0000
 2606.3448     121.1869     525.5554    1360.5195     391.2757     239.0219       4.1837     216.0000       0.0659      -0.0106      -0.0473       2.6555      16.2041     237.0862     281.3759      52.7402      -0.0029       0.0028       0.0311       6.8784    2728.0808     172.5540     -54.0000    4235.0000
 2606.4972     115.5508     691.5214    1717.9531     807.2365     422.9896       2.3641     216.0000       0.0769       0.0013      -0.0350       2.7035      14.5742     256.3441     266.4595      52.7402      -0.0103      -0.0057       0.0210       6.9190    2707.7317      97.8306     -54.0000    4277.0000
 2606.6496     114.9486     732.3416    1950.0000    1700.8606     613.4772       1.6301     216.0000       0.1165       0.0442       0.0094       2.6013      14.0322     261.8331     276.9427      52.8800      -0.0120      -0.0085       0.0184       7.1341    2634.4397      42.3859     -61.0625    4207.0000
 2606.8020     118.0716     728.1918    1882.1949    1214.8429     688.1475       1.4532     216.0000       0.1936       0.1276       0.0959       2.6743      12.6783     271.5086     284.8694      52.7402      -0.0045       0.0016       0.0291       7.4324    2491.8264      21.9046     -57.0625    4276.0000
 2606.9544     124.5791     726.0082    1831.2775    1404.7946     649.9757       1.5385     216.0000       0.2531       0.1919       0.1626       2.7338      13.5495     283.9751     297.4737      52.8800       0.0050       0.0138       0.0422       7.6446    2381.7742      16.7821     -54.3125    4197.0000
 2607.1068     133.1396     768.0845    1928.2336    1713.8977    1137.1466       0.8794     216.0000       0.2392       0.1769       0.1470       2.5627      12.8991     284.5333     331.3544      53.0198       0.0147       0.0250       0.0551       7.6481    2407.5073      17.9916     -54.0000    4235.0000
 2607.2592     140.8183     876.7988    1950.0000    1852.2693    1473.3519       0.6787     216.0000       0.1911       0.1248       0.0930       2.7442      15.0670     297.6509     355.8657      52.7402       0.0086       0.0167       0.0467       7.5149    2496.5354      23.1805     -53.9375    4304.0000
 2607.4116     145.2630    1066.4517    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.1554       0.0862       0.0530       2.9278      14.9601     282.8586     358.3822      53.0198       0.0043       0.0104       0.0406       7.3544    2562.5146      19.6668     -56.0625    4289.0000
 2607.5640     146.7592    1326.6107    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.1537       0.0844       0.0511       2.7220      15.7188     285.8357     340.2433      53.0198       0.0064       0.0137       0.0436       7.2564    2565.6157      15.3385     -55.3750    4286.0000
 2607.7164     147.1827    1584.3584    1950.0000    1950.0000    1455.4476       0.6871     216.0000       0.1574       0.0884       0.0552       2.6971      13.8761     275.0439     316.8538      52.7402       0.0025       0.0097       0.0386       7.1615    2558.8442      13.4992     -55.0000    4250.0000
 2607.8688     147.8355    1706.6975    1950.0000    1860.6150    1035.1650       0.9660     216.0000       0.1443       0.0743       0.0406       2.6568      14.8503     272.8111     282.1271      52.8800      -0.0000       0.0073       0.0353       6.9753    2583.0215      12.9648     -55.9375    4215.0000
 2608.0212     148.4220    1592.5654    1950.0000    1697.9041     812.8428       1.2303     216.0000       0.1129       0.0403       0.0054       2.5863      15.7121     246.9477     222.2281      53.0198      -0.0036       0.0021       0.0302       6.6402    2641.1155      15.1557     -54.0000    4266.0000
 2608.1736     147.9672    1282.6622    1950.0000    1231.4702     723.3839       1.3824     216.0000       0.0766       0.0010      -0.0353       2.7628      15.9289     229.0853     149.1585      53.0198      -0.0037       0.0009       0.0297       6.1698    2708.3052      25.0313     -51.8125    4207.0000
 2608.3260     146.1943     924.5668    1950.0000    1367.8732     746.8171       1.3390     216.0000       0.0667      -0.0097      -0.0464       2.6177      13.5527     225.3640      77.3165      53.0198      -0.0020       0.0031       0.0321       5.7270    2726.6411     102.0673     -59.5000    4219.0000
 2608.4784     144.1362     649.0160    1950.0000    1014.3630     624.8853       1.6003     216.0000       0.0824       0.0072      -0.0289       2.5288      12.7992     225.3640      28.9547      53.0198      -0.0040       0.0009       0.0294       5.4829    2697.6086    3388.2366     -54.0000    4285.0000
 2608.6308     143.4015     478.7171    1950.0000    1333.3402     650.1063       1.5382     216.0000       0.0884       0.0137      -0.0221       2.3765      13.8772     228.1550      18.5003      53.0198      -0.0022       0.0042       0.0322       5.4337    2686.4946     341.4805     -54.0000    4280.0000
 2608.7832     145.1757     388.7600    1950.0000     971.8870     609.6806       1.6402     216.0000       0.0817       0.0065      -0.0297       2.4789      15.0611     227.2247      18.3489      53.0198       0.0024       0.0102       0.0386       5.4604    2698.9280     324.7131     -51.4375    4305.0000
 2608.9356     149.5777     354.9344    1950.0000     980.7963     674.6061       1.4823     216.0000       0.0804       0.0051      -0.0310       2.6556      15.5886     227.7828      13.3605      53.0198      -0.0004       0.0065       0.0347       5.4190    2701.2280     319.7955     -50.1250    4310.0000
 2609.0880     155.2068     365.9620    1950.0000     715.8379     547.4532       1.8266     216.0000       0.0848       0.0099      -0.0261       2.8426      14.1854     228.1550       2.6512      53.0198      -0.0023       0.0037       0.0319       5.3545    2693.1409    2240.5022     -48.8125    4301.0000
 2609.2404     159.2610     417.2718    1915.8553     614.7698     748.8101       1.3355     216.0000       0.0899       0.0154      -0.0204       2.6177      15.8989     228.1550      -2.6360      53.0198      -0.0006       0.0055       0.0342       5.2997    2683.7334    2818.2476     -48.8125    4334.0000
 2609.3928     158.6931     513.2947    1950.0000    1659.9954    1690.2809       0.5916     216.0000       0.0873       0.0125      -0.0234       2.3845      16.8889     231.1321      -2.0328      53.0198       0.0020       0.0090       0.0378       5.2761    2688.5447    3417.5288     -48.3125    4389.0000
 2609.5452     152.9519     610.6723    1950.0000    1751.0907    1617.4460       0.6183     216.0000       0.0858       0.0109      -0.0250       2.3954      17.5132     237.2723       5.6176      53.0198      -0.0061      -0.0012       0.0266       5.2878    2691.2888    3385.5173     -48.6875    4256.0000
 2609.6976     144.5258     650.4634    1950.0000    1591.0701    1330.9525       0.7513     216.0000       0.0815       0.0063      -0.0298       2.4823      15.5829     228.1550      28.0547      53.0198      -0.0029       0.0027       0.0310       5.3700    2699.1699     583.5583     -44.5000    4187.0000
 2609.8500     131.8652     550.0355    1389.5701     555.2242     588.1841       1.7001     216.0000       0.0832       0.0081      -0.0280       2.8289      14.7401     227.3177      51.3678      53.0198       0.0034       0.0107       0.0397       5.5043    2696.1594     530.1558     -44.2500    4225.0000
 2610.0024     130.8677     623.3429    1684.4022     477.3914     501.1587       1.9954     216.0000       0.0830       0.0079      -0.0282       2.5215      14.3326     227.2247      65.6469      53.0198       0.0014       0.0080       0.0369       5.6036    2696.4983     290.4461     -48.6875    4245.0000
 2610.1548     128.1535     653.6307    1610.5048     444.7168     555.8833       1.7989     216.0000       0.0855       0.0106      -0.0254       2.5672      15.3817     227.5968      59.9256      53.0198       0.0019       0.0086       0.0376       5.6003    2691.8958     461.1739     -44.2500    4181.0000
 2610.3072     126.2277     603.9198    1950.0000     596.4226     818.6447       1.2215     216.0000       0.0866       0.0118      -0.0241       2.5424      16.1884     224.2476      37.4744      53.0198       0.0026       0.0088       0.0384       5.4836    2689.7456     494.0529     -44.2500    4230.0000
 2610.4596     120.9090     513.5795    1931.1074     485.0849     471.4048       2.1213     216.0000       0.0921       0.0177      -0.0180       2.5050      18.0231     222.2939      15.7287      53.0198       0.0045       0.0103       0.0407       5.3291    2679.6914    2014.0255     -41.1250    4277.0000
 2610.6120     113.5902     397.6798    1478.7437     547.2378     628.9239       1.5900     216.0000       0.0922       0.0179      -0.0179       2.4674      19.7923     222.2939      28.4429      53.0198       0.0131       0.0203       0.0522       5.4711    2679.4727    1590.7742     -39.8750    4225.0000
 2610.7644     109.6574     350.8406    1841.3179     743.9302     727.8372       1.3739     216.0000       0.0823       0.0072      -0.0289       2.7349      20.4722     227.9689      87.5509      53.0198       0.0092       0.0155       0.0470       5.8590    2697.6758     947.8704     -34.5000    4221.0000
 2610.9168     104.9951     304.1432    1818.0854     747.7416     737.0439       1.3568     216.0000       0.0616      -0.0152      -0.0521       2.6882      22.3229     230.9460     181.0694      53.0198       0.0112       0.0181       0.0497       6.4360    2736.0361     786.1260     -36.0625    4280.0000
 2611.0692     102.6654     286.0180    1882.0641    1005.0198     839.8738       1.1907     216.0000       0.0568      -0.0204      -0.0575       2.5064      22.5397     235.4116     259.3787      53.0198       0.0092       0.0160       0.0471       6.8610    2744.8662     620.5740     -39.1250    4240.0000
 2611.2216     102.6654     300.4449    1936.9008    1340.1934    1052.5588       0.9501     216.0000       0.0798       0.0045      -0.0317       2.5484      22.7632     243.7846     303.6909      53.0198       0.0025       0.0081       0.0381       7.1892    2702.3115     433.2785     -34.5000    4246.0000
 2611.3740     104.2950     355.8546    1950.0000    1616.4496    1365.7128       0.7322     216.0000       0.1056       0.0324      -0.0028       2.3739      21.5708     253.2740     334.4853      53.0198       0.0082       0.0157       0.0460       7.3998    2654.6235     147.9560     -37.9375    4240.0000
 2611.5264     106.1003     471.9419    1950.0000    1950.0000    1950.0000       0.5035     216.0000       0.1101       0.0372       0.0022       2.2918      19.5798     260.3445     370.2755      53.0198       0.0064       0.0134       0.0436       7.5056    2646.3149     116.2974     -32.3750    4211.0000
 2611.6788     106.7893     680.1075    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0918       0.0174      -0.0183       2.3368      18.1706     261.6470     404.6002      53.0198       0.0056       0.0121       0.0424       7.5311    2680.2158     120.1890     -34.5000    4252.0000
 2611.8312     106.3452    1002.2766    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0730      -0.0028      -0.0393       2.2107      16.4363     260.1585     409.5361      53.0198       0.0045       0.0106       0.0409       7.4929    2714.8733     145.9251     -34.5000    4250.0000
 2611.9836     105.9705    1384.4297    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0645      -0.0121      -0.0489       2.4122      18.9693     265.2753     385.8125      53.0198       0.0036       0.0096       0.0396       7.4081    2730.7024     157.2588     -35.0000    4256.0000
 2612.1360     106.9309    1697.2708    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0634      -0.0133      -0.0502       2.6050      22.5464     270.0200     364.1281      53.0198       0.0067       0.0136       0.0439       7.3408    2732.7615     154.4538     -34.5000    4359.0000
 2612.2884     109.5937    1869.1034    1950.0000    1558.3813    1821.1534       0.5491     216.0000       0.0694      -0.0068      -0.0434       2.4079      23.6162     261.6470     349.0615      53.0198       0.0117       0.0192       0.0505       7.3066    2721.6113     137.4598     -34.5625    4268.0000
 2612.4408     113.1593    1886.4332    1950.0000    1270.5740    1549.2465       0.6455     216.0000       0.0795       0.0041      -0.0321       2.3479      23.3994     259.9724     340.5433      53.0198       0.0136       0.0220       0.0532       7.3245    2703.0112     123.1067     -34.5000    4145.0000
 2612.5932     116.1229    1779.0455    1950.0000    1018.9818    1288.3807       0.7762     216.0000       0.0802       0.0049      -0.0313       2.4169      21.7734     253.0879     334.2621      53.0198       0.0098       0.0171       0.0480       7.3374    2701.5781      98.4913     -39.3125    4191.0000
 2612.7456     116.9230    1571.3347    1950.0000     817.0282     979.4153       1.0210     216.0000       0.0746      -0.0011      -0.0375       2.5285      21.5708     253.6461     332.7451      53.0198       0.0011       0.0068       0.0363       7.3346    2711.9395     106.0758     -36.1875    4230.0000
 2612.8980     114.5968    1267.0085    1950.0000     787.2723     754.7757       1.3249     216.0000       0.0637      -0.0129      -0.0498       2.7881      19.5113     253.8322     334.6641      53.0198      -0.0021       0.0029       0.0319       7.3180    2732.1194     105.0433     -34.8125    4252.0000
 2613.0504     109.5732     952.5992    1950.0000     756.0633     486.3618       2.0561     216.0000       0.0566      -0.0207      -0.0578       2.4723      17.1215     256.3441     332.8829      53.0198      -0.0012       0.0045       0.0333       7.2973    2745.3418     146.6597     -34.5000    4416.0000
 2613.2028     103.5975     710.0425    1950.0000     521.1877     362.1821       2.7610     216.0000       0.0687      -0.0075      -0.0442       2.4842      17.5335     255.5068     322.2621      53.0198      -0.0033       0.0018       0.0304       7.2959    2722.8706     154.4999     -35.7500    4355.0000
 2613.3552      98.7380     552.2786    1950.0000     564.0602     271.7832       3.6794     216.0000       0.0783       0.0029      -0.0334       2.3465      17.7503     256.3441     325.5639      53.0198       0.0026       0.0090       0.0385       7.3128    2705.0542     129.2932     -36.3125    4338.0000
 2613.5076      96.1921     455.8353    1950.0000     768.5665     225.5406       4.4338     216.0000       0.1039       0.0306      -0.0047       2.2533      17.2134     256.0650     323.7479      53.0198       0.0073       0.0150       0.0449       7.3668    2657.7466     112.8003     -34.5000    4232.0000
 2613.6600      95.9166     395.8104    1950.0000     989.4107     462.2415       2.1634     216.0000       0.1158       0.0434       0.0086       2.4320      16.5980     262.5774     330.4572      53.0198       0.0008       0.0071       0.0361       7.4319    2635.7925      89.5613     -34.5000    4231.0000
 2613.8124      96.9177     357.0935    1950.0000    1808.9716    1067.5686       0.9367     216.0000       0.1156       0.0432       0.0084       2.4186      16.3812     262.5774     341.4764      53.0198      -0.0003       0.0059       0.0347       7.4553    2636.1274     104.8596     -34.5000    4281.0000
 2613.9648      97.9637     334.9192    1950.0000    1508.2046     806.6939       1.2396     216.0000       0.0990       0.0253      -0.0102       2.4128      17.3567     261.8331     368.8142      53.0198       0.0033       0.0100       0.0395       7.4382    2666.8179     133.9287     -34.5000    4222.0000
 2614.1172      98.6110     332.6439    1950.0000    1761.5504    1066.4597       0.9377     216.0000       0.0903       0.0158      -0.0200       2.5810      16.8014     266.6708     396.0946      53.0198       0.0069       0.0142       0.0443       7.4253    2683.0105     236.3329     -34.5000    4310.0000
 2614.2696      99.4764     358.5702    1950.0000    1910.9927    1382.0865       0.7235     216.0000       0.0929       0.0186      -0.0171       2.1640      15.9342     276.1603     411.3827      53.0198       0.0020       0.0076       0.0375       7.4354    2678.1833      88.7799     -39.1250    4277.0000
 2614.4220     101.2651     426.2857    1950.0000    1950.0000    1515.8611       0.6597     216.0000       0.1021       0.0286      -0.0068       2.2390      17.0182     273.9275     402.1497      53.0198       0.0050       0.0113       0.0416       7.4315    2661.1555      60.0123     -36.2500    4265.0000
 2614.5744     103.7530     557.3003    1950.0000    1950.0000    1950.0000       0.5039     216.0000       0.0990       0.0253      -0.0102       2.5966      15.8214     270.8573     383.5101      53.0198       0.0063       0.0130       0.0434       7.3670    2666.8049      62.9063     -35.3750    4250.0000
 2614.7268     105.6583     774.5182    1950.0000    1950.0000    1881.8988       0.5314     216.0000       0.0940       0.0198      -0.0158       2.1802      17.2497     272.5320     360.0724      53.0198       0.0097       0.0173       0.0480       7.2786    2676.1475     100.2959     -37.1250    4213.0000
 2614.8792     105.6077    1056.0127    1950.0000    1950.0000    1707.5463       0.5856     216.0000       0.0818       0.0067      -0.0294       2.3743      16.2741     261.3680     356.0183      53.0198       0.0055       0.0114       0.0422       7.2004    2698.5842     204.0320     -39.1250    4182.0000
 2615.0316     103.4499    1272.3400    1950.0000    1950.0000    1655.8866       0.6039     216.0000       0.0881       0.0134      -0.0224       2.4784      17.9045     262.4843     359.4759      53.0198       0.0071       0.0136       0.0444       7.1898    2687.0178     247.4794     -34.4375    4256.0000
 2615.1840     100.1780    1290.8386    1950.0000    1950.0000    1364.1033       0.7331     216.0000       0.1082       0.0352       0.0001       2.2801      17.2897     266.9500     359.6888      53.0198       0.0066       0.0135       0.0439       7.2340    2649.8906     148.0041     -31.7500    4263.0000
 2615.3364      97.0121    1166.8741    1950.0000    1950.0000    1493.0991       0.6697     216.0000       0.1143       0.0418       0.0070       2.3417      18.2652     265.8335     359.5481      53.0198       0.0069       0.0139       0.0442       7.2510    2638.4805     103.9393     -34.0000    4236.0000
 2615.4888      94.6279    1034.2369    1950.0000    1332.4980     890.1765       1.1234     216.0000       0.1002       0.0265      -0.0089       2.5557      16.7477     264.1589     349.3230      53.0198       0.0087       0.0156       0.0465       7.1942    2664.6172     103.2827     -28.6875    4256.0000
 2615.6412      93.1709     960.5268    1950.0000    1104.6696     705.2510       1.4179     216.0000       0.0732      -0.0027      -0.0391       2.4625      17.0182     259.1351     337.2645      53.0198       0.0078       0.0138       0.0451       7.0751    2714.5391     132.6282     -29.5000    4268.0000
 2615.7936      92.6175     963.1068    1950.0000     885.7297     586.5760       1.7048     216.0000       0.0615      -0.0153      -0.0522       2.6608      15.7174     259.4142     319.5085      53.0198       0.0131       0.0205       0.0524       6.9869    2736.1389     199.5863     -29.4375    4292.0000
 2615.9460      92.8177    1032.5497    1950.0000     783.6781     460.8421       2.1699     216.0000       0.0601      -0.0168      -0.0538       2.4420      17.2289     260.5306     313.2379      53.0198       0.0080       0.0142       0.0454       6.9653    2738.7612     303.7061     -25.5000    4292.0000
 2616.0984      93.0938    1158.2944    1950.0000     628.4817     442.8448       2.2581     216.0000       0.0658      -0.0107      -0.0474       2.5894      17.8781     250.4830     306.1747      53.0198       0.0102       0.0170       0.0485       6.9731    2728.2148     264.7026     -25.8125    4286.0000
 2616.2508      93.5755    1335.4019    1865.7867     430.2840     386.9536       2.5843     216.0000       0.0719      -0.0041      -0.0406       2.6214      17.7697     247.4129     296.9275      53.0198       0.0101       0.0168       0.0483       6.9660    2716.9668     192.7197     -25.9375    4289.0000
 2616.4032      95.5844    1034.6426    1152.5536     370.4275     322.0459       3.1051     216.0000       0.0742      -0.0016      -0.0380       2.3769      15.7162     255.7859     284.9491      53.0198       0.0030       0.0087       0.0389       6.9436    2712.6997     145.1773     -24.6875    4247.0000
 2616.5556      95.6607     711.0583     953.7277     326.2934     290.6292       3.4408     216.0000       0.0751      -0.0007      -0.0371       2.3362      15.7174     256.0650     286.7708      53.0198       0.0055       0.0118       0.0422       6.9650    2711.1487     161.0409     -24.0000    4280.0000
 2616.7080      99.9816    1133.1207     893.9250     280.9272     246.7592       4.0525     216.0000       0.0826       0.0075      -0.0286       2.6050      17.3366     256.9954     297.9724      53.0198       0.0116       0.0196       0.0505       7.0468    2697.2456     160.7798     -23.6250    4288.0000
 2616.8604      94.0785     789.1766     508.0997     278.0713     247.2481       4.0445     216.0000       0.0923       0.0180      -0.0177       2.3814      18.1012     259.6003     320.6899      53.0198       0.0039       0.0100       0.0400       7.1559    2679.1724     125.7828     -23.5000    4284.0000
 2617.0128      87.8340     404.9459     305.7097     398.1082     327.2110       3.0561     216.0000       0.1019       0.0284      -0.0069       2.5940      16.6921     258.6700     340.4431      53.0198       0.0032       0.0095       0.0392       7.2437    2661.4158      61.5978     -22.5625    4269.0000
 2617.1652     104.1328    1723.6799     923.7471     508.9182     402.1790       2.4865     216.0000       0.1047       0.0314      -0.0038       2.4689      14.3142     256.3441     352.3059      53.0198       0.0045       0.0112       0.0411       7.2736    2656.3352      54.1736     -18.4375    4296.0000
 2617.3176     118.3851    1632.1538    1392.1277     848.7791     644.1507       1.5524     216.0000       0.1044       0.0311      -0.0041       2.3160      15.6030     245.4592     348.4159      53.0198       0.0050       0.0112       0.0415       7.2409    2656.8054      57.7166     -18.8125    4294.0000
 2617.4700     128.7919    1864.6917    1695.7339    1246.8195     878.1929       1.1387     216.0000       0.1081       0.0350      -0.0001       2.5310      15.1694     243.5055     322.1696      53.0198       0.0088       0.0157       0.0466       7.1404    2650.0876      72.2595     -16.1875    4354.0000
 2617.6224     137.4061    1950.0000    1903.0646    1555.1584    1128.1851       0.8864     216.0000       0.1049       0.0316      -0.0036       2.2746      17.0059     250.8551     294.7364      53.0198       0.0051       0.0109       0.0416       7.0315    2655.9136      66.7297     -18.1250    4286.0000
 2617.7748     145.0055    1950.0000    1950.0000    1589.5154    1254.7345       0.7970     216.0000       0.0991       0.0254      -0.0101       2.2916      15.7215     248.6223     270.4234      53.0198       0.0124       0.0198       0.0514       6.9569    2666.6299      88.0881     -14.9375    4276.0000
 2617.9272     151.0279    1881.3191    1950.0000    1494.1332    1322.8358       0.7560     216.0000       0.0832       0.0081      -0.0280       2.4204      14.8543     245.4592     272.3305      53.0198       0.0153       0.0233       0.0554       6.9246    2696.1711     146.0645     -16.1250    4268.0000
 2618.0796     154.4761    1696.5923    1950.0000    1556.1471    1351.3484       0.7400     216.0000       0.0783       0.0029      -0.0334       2.3894      13.8797     251.8785     273.0789      53.0198       0.0055       0.0112       0.0420       6.8926    2705.1089     235.0171     -14.8125    4257.0000
 2618.2320     154.7738    1428.5807    1950.0000    1638.1678    1258.8911       0.7943     216.0000       0.0719      -0.0041      -0.0406       2.2596      16.0373     246.9477     257.7660      53.0198       0.0062       0.0122       0.0430       6.7762    2716.9597     235.3118     -14.9375    4304.0000
 2618.3844     152.2892    1120.9053    1950.0000    1335.7185    1121.2720       0.8918     216.0000       0.0675      -0.0089      -0.0456       2.3789      19.1739     240.4354     207.3765      53.0198       0.0118       0.0190       0.0506       6.5426    2725.1577     279.4578      -8.8750    4263.0000
 2618.5368     149.3616     867.9581    1950.0000    1950.0000    1448.8915       0.6902     216.0000       0.0645      -0.0121      -0.0489       2.3867      20.1548     233.7370     140.6631      53.0198       0.0097       0.0160       0.0477       6.1961    2730.6658     398.3723     -11.3750    4318.0000
 2618.6892     148.7011     701.6865    1950.0000    1070.3442     847.3211       1.1802     216.0000       0.0635      -0.0131      -0.0500       2.5691      18.7039     229.6435      91.0485      53.0198       0.0152       0.0227       0.0551       5.8763    2732.4424     434.9215      -9.0625    4256.0000
 2618.8416     152.4195     610.1019    1948.0881     974.0475     714.2269       1.4001     216.0000       0.0739      -0.0019      -0.0383       2.6175      18.6025     230.7599      66.4480      53.0198       0.0128       0.0199       0.0519       5.7008    2713.2412     548.5453      -5.9375    4195.0000
 2618.9940     161.4441     576.0558    1893.9995     873.8899     471.7036       2.1200     216.0000       0.0834       0.0083      -0.0277       2.5161      18.3796     235.4116      64.3783      53.0198       0.0068       0.0130       0.0439       5.6932    2695.7458     712.7061      -5.2500    4268.0000
 2619.1464     171.6396     582.7433    1604.4437     584.2097     473.4149       2.1123     216.0000       0.0895       0.0149      -0.0209       2.3515      17.2289     239.6911      65.2108      53.0198       0.0053       0.0115       0.0420       5.7318    2684.4402     913.2454      -5.1875    4263.0000
 2619.2988     186.3483     585.7006    1950.0000     970.4603     676.4646       1.4783     216.0000       0.0877       0.0130      -0.0229       2.3436      16.7953     240.0633      59.3901      53.0198       0.0082       0.0153       0.0459       5.6979    2687.8447     913.7920      -5.1875    4377.0000
 2619.4512     187.8699     552.6740    1950.0000    1514.0143     977.1477       1.0234     216.0000       0.0801       0.0047      -0.0315       2.4293      16.9098     235.2255      42.9456      53.0198       0.0067       0.0132       0.0438       5.5562    2701.8953    1141.8746      -5.1875    4322.0000
 2619.6036     175.0874     469.8549    1639.7142    1439.1644    1241.4042       0.8055     216.0000       0.0770       0.0014      -0.0349       2.6465      18.0605     232.4345      21.2374      53.0198       0.0076       0.0144       0.0450       5.3434    2707.5535    1333.0132      -5.1875    4304.0000
 2619.7560     123.6523     245.0669     438.3073     374.8792     377.1804       2.6513     216.0000       0.0809       0.0056      -0.0305       2.7321      16.8629     226.4804       5.1491      53.0198       0.0043       0.0101       0.0405       5.2098    2700.3984    1191.6611      -0.2500    4289.0000
 2619.9084     105.6758     174.8605     323.2036     278.5472     303.5510       3.2943     216.0000       0.0892       0.0146      -0.0212       2.5026      14.9118     226.4804      -0.7174      53.0198       0.0038       0.0097       0.0399       5.1712    2684.9871     936.0933      -1.3125    4294.0000
 2620.0608      89.6086     142.9101     195.6178     175.9437     189.2327       5.2845     216.0000       0.0905       0.0160      -0.0197       2.1306      15.3870     227.8759       3.5276      53.0198       0.0097       0.0175       0.0480       5.2433    2682.5657      85.5520       0.4375    4247.0000
 2620.2132      72.0050     110.4836     132.8122     124.6594     130.1475       7.6836     216.0000       0.0881       0.0134      -0.0224       2.5350      15.5006     227.5968       5.2648      53.0198       0.0064       0.0135       0.0435       5.2656    2687.0332      70.9159      -0.6875    4256.0000
 2620.3656      92.1524     140.3857     158.6353     143.1041     150.8460       6.6293     216.0000       0.0830       0.0079      -0.0282       2.6350      15.7437     227.5968       4.0627      53.0198       0.0017       0.0082       0.0373       5.2702    2696.5391      72.8721       4.5625    4236.0000
 2620.5180     103.7987     218.4294     342.7870     261.3718     298.5624       3.3494     216.0000       0.0868       0.0120      -0.0239       2.6140      14.1134     226.7595      -2.3351      53.0198      -0.0022       0.0039       0.0321       5.2513    2689.4856     331.6799       0.2500    4244.0000
 2620.6704     148.0428     396.1130     736.3696     562.4117     641.2615       1.5594     216.0000       0.0909       0.0165      -0.0193       2.3170      13.4630     226.6664      -4.7910      53.0198      -0.0080      -0.0029       0.0242       5.2398    2681.8000     839.8941       1.3750    4264.0000
 2620.8228     127.1929     621.9727     642.6594     398.7263     456.7879       2.1892     216.0000       0.0951       0.0210      -0.0146       2.6531      13.4368     227.2247      -5.1048      53.0198      -0.0074      -0.0014       0.0252       5.2242    2674.1294     813.8961       0.6875    4281.0000
 2620.9752     128.9903     382.4327     660.0916     375.6378     411.2682       2.4315     216.0000       0.0920       0.0176      -0.0181       2.7990      13.3726     228.5271      -3.2425      53.0198      -0.0070      -0.0005       0.0259       5.1560    2679.8291     895.9450      -2.3125    4206.0000
 2621.1276     133.9354     322.1765     720.2499     333.8809     360.1695       2.7765     216.0000       0.0862       0.0114      -0.0245       2.6390      12.1767     228.7132      -2.2981      53.0198      -0.0093      -0.0035       0.0227       5.1029    2690.4565     889.3657      -2.0625    4231.0000
 2621.2800     123.7216     315.0287     735.6962     260.3503     290.2820       3.4449     216.0000       0.0811       0.0059      -0.0303       2.8882      13.1523     228.7132      -1.9488      53.0198      -0.0086      -0.0027       0.0236       5.0985    2699.9182     764.9321      -6.5000    4240.0000
 2621.4324     117.3335     289.6882     633.8705     272.6647     260.9472       3.8322     216.0000       0.0884       0.0137      -0.0221       2.6267      14.7835     228.3410      -2.7578      53.0198      -0.0045       0.0025       0.0293       5.2051    2686.5076     785.0261      -5.1875    4269.0000
 2621.5848     110.0756     287.3000     691.5120     292.4142     261.8515       3.8190     216.0000       0.0905       0.0161      -0.0197       2.2324      17.7073     228.3410      12.0096      53.0198      -0.0077      -0.0020       0.0248       5.5401    2682.4832     720.6150      -5.1875    4238.0000
 2621.7372      99.9689     234.0907     771.0862     346.5381     282.9091       3.5347     216.0000       0.0817       0.0065      -0.0296       2.4051      19.6584     228.7132      58.6603      53.0198      -0.0069      -0.0015       0.0257       5.9766    2698.8521     674.9275      -7.6250    4222.0000
 2621.8896     101.6317     280.0603     922.5847     417.6441     283.6315       3.5257     216.0000       0.0654      -0.0111      -0.0479       2.7997      20.3655     230.6669     117.2240      53.0198      -0.0021       0.0043       0.0323       6.4481    2728.9951     315.4323      -8.5625    4229.0000
 2622.0420     102.7832     240.1575    1154.8954     637.1785     463.0661       2.1595     216.0000       0.0613      -0.0155      -0.0525       3.7267      20.9936     232.2484     176.3144      53.0198      -0.0027       0.0033       0.0314       6.7975    2736.5679     165.2571     -11.1250    4279.0000
 2622.1944      98.5755     201.6747    1332.4730     764.4255     400.9120       2.4943     216.0000       0.0777       0.0022      -0.0341       3.7955      19.2593     239.6911     216.5589      53.0198      -0.0057      -0.0007       0.0272       7.0962    2706.3130     100.1890     -14.1875    4198.0000
 2622.3468      97.8789     189.6068    1584.9313    1048.9818     423.6231       2.3606     216.0000       0.0943       0.0201      -0.0155       2.1942      18.1764     243.7846     264.2195      53.0198      -0.0002       0.0065       0.0349       7.3792    2675.5706      79.8730     -14.9375    4255.0000
 2622.4992      95.6480     183.6116    1807.0846    1425.6682     405.8228       2.4641     216.0000       0.1384       0.0679       0.0340       2.1270      16.9506     255.3208     288.7122      53.0198      -0.0011       0.0054       0.0336       7.6620    2593.9478      57.9045     -20.4375    4268.0000
 2622.6516      94.0217     193.9857    1931.7407    1728.7600     636.6909       1.5706     216.0000       0.1869       0.1203       0.0883       2.3483      17.0590     272.8111     302.8459      53.0198      -0.0045       0.0015       0.0290       7.9222    2504.2961      32.8135     -24.6875    4245.0000
 2622.8040      93.2870     224.7712    1950.0000    1886.3369     743.1533       1.3456     216.0000       0.2077       0.1429       0.1117       2.3367      17.6065     277.8349     325.1488      53.0198       0.0015       0.0095       0.0375       8.0865    2465.7170      26.1280     -24.6875    4281.0000
 2622.9564      93.5322     285.3542    1950.0000    1941.2153     923.9057       1.0824     216.0000       0.1944       0.1285       0.0968       2.2594      16.9047     277.4627     339.5386      53.0198      -0.0028       0.0038       0.0314       8.1507    2490.3184      28.4177     -27.3750    4250.0000
 2623.1088      94.2401     392.4854    1950.0000    1950.0000    1269.5541       0.7877     216.0000       0.1609       0.0922       0.0592       2.0928      16.7963     286.9521     339.7245      53.0198      -0.0089      -0.0034       0.0231       8.1325    2552.2588      28.9694     -30.6875    4256.0000
 2623.2612      94.3856     565.8941    1950.0000    1950.0000    1516.5563       0.6594     216.0000       0.1418       0.0716       0.0378       2.3200      16.5737     285.6496     320.4737      53.0198      -0.0071      -0.0009       0.0257       8.1129    2587.6284      31.5577     -34.5000    4240.0000
 2623.4136      93.1669     785.0222    1950.0000    1924.6168     887.0287       1.1274     216.0000       0.1307       0.0595       0.0253       2.6908      15.8571     278.0209     323.9117      53.0198      -0.0031       0.0037       0.0312       8.1183    2608.2344      41.9178     -39.6250    4248.0000
 2623.5660      90.6437     899.6312    1950.0000    1950.0000     832.1342       1.2017     216.0000       0.1237       0.0520       0.0175       2.9222      14.6648     280.6259     354.4450      53.0198      -0.0101      -0.0053       0.0213       8.1556    2621.1309      78.0552     -43.6250    4257.0000
 2623.7184      87.5262     784.2546    1950.0000    1950.0000     821.4627       1.2173     216.0000       0.1227       0.0509       0.0164       3.0046      13.9068     276.7184     390.8298      53.0198      -0.0066      -0.0010       0.0261       8.2184    2623.0200      52.6835     -44.2500    4231.0000
 2623.8708      84.3330     579.7430    1950.0000    1950.0000     642.6445       1.5561     216.0000       0.1291       0.0578       0.0235       2.7213      13.2192     271.8807     409.8940      53.0198      -0.0027       0.0045       0.0318       8.2980    2611.1621      47.7653     -45.0625    4231.0000
 2624.0232      81.0662     419.6761    1950.0000    1950.0000     707.8745       1.4127     216.0000       0.1430       0.0729       0.0392       2.2015      13.2455     270.0200     412.5385      53.0198      -0.0079      -0.0025       0.0244       8.3817    2585.3916      54.4458     -47.1250    4308.0000
 2624.1756      77.5833     320.5780    1950.0000    1950.0000     933.6179       1.0711     216.0000       0.1630       0.0944       0.0615       2.1229      12.2750     278.0209     408.7503      53.0198      -0.0079      -0.0022       0.0245       8.4719    2548.4971      66.8152     -52.6875    4230.0000
 2624.3280      74.0854     266.0439    1950.0000    1950.0000    1086.2035       0.9206     216.0000       0.1733       0.1056       0.0730       2.7675      14.3755     285.2775     415.9525      53.0198      -0.0069      -0.0008       0.0259       8.5210    2529.4849      56.8603     -54.0000    4233.0000
 2624.4804      71.0713     242.3902    1950.0000    1950.0000    1305.6887       0.7659     216.0000       0.1832       0.1163       0.0842       2.6326      14.5660     288.1616     418.4623      53.0198      -0.0051       0.0016       0.0284       8.5431    2511.1467      47.6460     -55.6250    4278.0000
 2624.6328      68.9227     242.8851    1950.0000    1950.0000    1561.1981       0.6405     216.0000       0.1990       0.1335       0.1020       2.8143      13.9156     283.4169     404.0847      53.0198      -0.0057       0.0005       0.0276       8.5302    2481.7742      40.6057     -55.4375    4246.0000
 2624.7852      67.6779     267.0352    1950.0000    1950.0000    1739.2231       0.5750     216.0000       0.2118       0.1472       0.1162       2.8678      12.3970     292.6272     388.1528      53.0198      -0.0074      -0.0009       0.0253       8.5229    2458.2322      35.8362     -55.4375    4235.0000
 2624.9376      67.1233     319.8063    1950.0000    1950.0000    1859.6060       0.5377     216.0000       0.2274       0.1641       0.1337       2.4159      12.1758     291.0456     373.2321      53.0198      -0.0093      -0.0037       0.0226       8.5282    2429.3354      33.0360     -55.8750    4215.0000
 2625.0900      67.0349     411.7184    1950.0000    1950.0000    1846.2914       0.5416     216.0000       0.2390       0.1766       0.1467       2.5889      14.1988     289.5571     369.0517      53.0198      -0.0120      -0.0076       0.0187       8.5326    2407.9382      31.0625     -60.7500    4228.0000
 2625.2424      67.3464     557.8596    1950.0000    1950.0000    1790.4774       0.5585     216.0000       0.2433       0.1813       0.1516       2.9539      15.1345     295.1391     369.1912      53.0198       0.0001       0.0071       0.0354       8.4984    2399.9360      30.0532     -61.4375    4250.0000
 2625.3948      68.0821     770.3920    1950.0000    1950.0000    1950.0000       0.4579     216.0000       0.2187       0.1547       0.1240       2.9143      15.3640     298.4883     388.8497      53.0198       0.0080       0.0171       0.0462       8.4276    2445.4417      35.8302     -60.4375    4309.0000
 2625.5472      69.1791    1031.8306    1950.0000    1950.0000    1533.7742       0.6520     216.0000       0.1845       0.1178       0.0857       2.8458      15.7257     295.6973     408.1733      53.0198      -0.0034       0.0021       0.0304       8.3295    2508.5925      52.9055     -63.7500    4246.0000
 2625.6996      70.4188    1252.1932    1950.0000    1950.0000    1499.1163       0.6671     216.0000       0.1666       0.0983       0.0656       2.9230      15.2980     290.9526     413.8408      53.0198      -0.0020       0.0038       0.0322       8.2504    2541.8376      69.6226     -63.7500    4262.0000
 2625.8520      71.5359    1305.9785    1950.0000    1950.0000    1616.8829       0.6185     216.0000       0.1641       0.0957       0.0628       2.5112      19.5697     286.9521     411.6058      53.0198       0.0020       0.0088       0.0378       8.1518    2546.4019      75.1119     -63.7500    4272.0000
 2626.0044      72.3519    1187.0277    1950.0000    1950.0000    1368.2338       0.7309     216.0000       0.1639       0.0955       0.0626       2.7170      23.0637     285.0915     412.6735      53.0198      -0.0008       0.0058       0.0341       8.0590    2546.7363      75.2743     -63.3125    4301.0000
 2626.1568      72.7310     986.9845    1950.0000    1950.0000     871.3010       1.1477     216.0000       0.1405       0.0701       0.0363       2.8544      27.4929     276.1603     425.4477      53.0198      -0.0003       0.0059       0.0346       7.9225    2590.1270      82.8784     -60.5625    4266.0000
 2626.3092      72.5004     785.4437    1950.0000    1942.3184     630.1382       1.5870     216.0000       0.1112       0.0385       0.0035       2.7571      26.2809     278.0209     424.4130      53.0198       0.0022       0.0087       0.0379       7.7809    2644.2300      93.8333     -63.0625    4247.0000
 2626.4616      71.5161     620.9592    1950.0000    1950.0000     654.6842       1.5275     216.0000       0.0851       0.0101      -0.0258       2.5027      25.8131     283.6029     405.3485      53.0198       0.0030       0.0090       0.0389       7.6396    2692.6506     100.9012     -60.5000    4303.0000
 2626.6140      69.8954     502.4204    1950.0000    1484.6481     411.5241       2.4300     216.0000       0.0683      -0.0080      -0.0447       2.8568      25.2448     278.1140     384.1603      53.0198       0.0073       0.0140       0.0447       7.5619    2723.7148     118.7977     -61.7500    4249.0000
 2626.7664      68.0178     422.8409    1950.0000    1112.6682     435.0993       2.2983     216.0000       0.0651      -0.0115      -0.0483       3.2354      26.4568     272.5320     379.2262      53.0198       0.0088       0.0155       0.0466       7.5772    2729.6558     186.2131     -63.3750    4223.0000
 2626.9188      66.3000     371.7056    1950.0000     889.1503     396.3093       2.5233     216.0000       0.0801       0.0048      -0.0314       3.3347      26.0321     271.3225     383.4710      53.0198       0.0081       0.0149       0.0457       7.6888    2701.7910     274.4123     -58.3125    4289.0000
 2627.0712      64.9960     341.2171    1950.0000     953.0682     538.3565       1.8575     216.0000       0.1060       0.0328      -0.0023       2.9808      28.1658     274.2066     381.5472      53.0198       0.0060       0.0128       0.0430       7.8386    2653.8342     181.1712     -62.6250    4259.0000
 2627.2236      64.1077     326.8232    1950.0000     514.9637     276.4838       3.6168     216.0000       0.1188       0.0466       0.0120       2.1096      25.8369     269.1827     377.6164      53.0198       0.0024       0.0081       0.0380       7.9799    2630.2358     130.9624     -64.0000    4309.0000
 2627.3760      63.4328     325.5991    1950.0000     272.8027     168.3120       5.9413     216.0000       0.1255       0.0539       0.0195       2.3864      23.5740     271.6946     380.0874      53.0198       0.0046       0.0110       0.0411       8.0937    2617.7927     109.3342     -59.8750    4283.0000
 2627.5284      62.7365     332.5187    1950.0000     676.4921     272.2556       3.6730     216.0000       0.1377       0.0671       0.0332       2.6640      17.1771     281.1841     394.6581      53.0198       0.0007       0.0068       0.0359       8.2255    2595.2615      67.5313     -60.2500    4263.0000
 2627.6808      61.9491     337.2722    1950.0000    1116.4519     603.2437       1.6577     216.0000       0.1627       0.0942       0.0612       2.6055      15.5462     285.4636     408.5677      53.0198      -0.0032       0.0023       0.0306       8.3614    2548.9827      44.0237     -59.5000    4290.0000
 2627.8332      61.1923     326.9464    1950.0000    1210.8018     623.8574       1.6029     216.0000       0.1931       0.1271       0.0953       2.6241      13.6215     270.8573     409.5247      53.0198       0.0071       0.0160       0.0449       8.4889    2492.6748      28.7559     -60.9375    4253.0000
 2627.9856      60.6369     299.2440    1950.0000    1379.6194     543.8588       1.8387     216.0000       0.2169       0.1528       0.1220       2.7845      14.1264     279.3234     400.1770      53.0198      -0.0073      -0.0021       0.0251       8.5585    2448.7405      13.0533     -60.5000    4246.0000
 2628.1380      60.3129     265.6578    1950.0000    1618.8835     773.3795       1.2930     216.0000       0.2275       0.1643       0.1339       3.0677      12.9009     280.4398     396.4586      53.0198      -0.0081      -0.0026       0.0241       8.5707    2429.0649       8.6680     -61.8125    4268.0000
 2628.2904      60.0789     239.1335    1950.0000    1818.0900    1011.9152       0.9882     216.0000       0.2222       0.1585       0.1279       2.7159      12.9049     292.3481     406.4290      53.0198      -0.0069      -0.0009       0.0259       8.5524    2438.8826       7.9335     -60.3750    4256.0000
 2628.4428      59.7036     225.4398    1950.0000    1950.0000    1295.6505       0.7718     216.0000       0.2035       0.1383       0.1070       2.6431      11.3873     285.6496     422.8256      53.0198      -0.0051       0.0013       0.0283       8.4917    2473.4773      11.0391     -56.4375    4241.0000
 2628.5952      59.1236     225.6929    1950.0000    1950.0000    1560.2198       0.6409     216.0000       0.1908       0.1245       0.0927       2.5978      11.4888     287.6964     423.9416      53.0198      -0.0072      -0.0011       0.0255       8.4215    2497.0791      17.4639     -60.5625    4233.0000
 2628.7476      58.5242     239.8516    1950.0000    1950.0000    1701.3896       0.5878     216.0000       0.1802       0.1131       0.0809       2.1328      12.5009     295.3252     419.9348      53.0198      -0.0111      -0.0059       0.0201       8.3453    2516.5559      23.9029     -63.3750    4252.0000
 2628.9000      58.2057     267.8584    1950.0000    1950.0000    1766.4934       0.5661     216.0000       0.1912       0.1249       0.0931       2.6293      14.3436     300.5350     405.2377      53.0198      -0.0126      -0.0077       0.0180       8.3248    2496.3611      26.6049     -61.1250    4268.0000
 2629.0524      58.4555     308.9482    1950.0000    1950.0000    1728.2827       0.5786     216.0000       0.2116       0.1471       0.1161       3.1129      16.9889     299.8838     387.0831      53.0198      -0.0091      -0.0040       0.0227       8.3268    2458.4917      15.4139     -58.1250    4295.0000
 2629.2048      59.4107     360.8548    1950.0000    1950.0000    1690.1696       0.5917     216.0000       0.2188       0.1548       0.1241       3.1679      18.0049     298.2092     377.9404      53.0198      -0.0018       0.0045       0.0327       8.3069    2445.2644      10.8626     -63.7500    4340.0000
 2629.3572      60.9860     417.8173    1950.0000    1950.0000    1276.7992       0.7832     216.0000       0.2254       0.1620       0.1315       2.4999      16.7003     302.0236     360.3554      53.0198       0.0092       0.0182       0.0477       8.2686    2432.9673       8.5802     -61.2500    4331.0000
 2629.5096      62.8229     467.1992    1950.0000    1950.0000    1619.0404       0.6176     216.0000       0.2202       0.1563       0.1256       0.0000      14.0622     305.5588     352.9337      53.0198       0.0092       0.0185       0.0478       8.2325    2442.7134       9.2038     -56.2500    4325.0000
 2629.6620      64.3066     489.2686    1950.0000    1950.0000    1782.8856       0.5609     216.0000       0.2106       0.1460       0.1149       0.0000      11.5529     302.6748     345.4180      53.0198      -0.0085      -0.0040       0.0233       8.2117    2460.3494      11.8974     -58.0000    4345.0000
 2629.8144      64.8166     474.3929    1950.0000    1950.0000    1832.7321       0.5456     216.0000       0.1871       0.1206       0.0886       3.0085      12.3283     290.3944     343.8384      53.0198      -0.0059      -0.0005       0.0270       8.1809    2503.7891      19.3531     -62.5000    4313.0000
 2629.9668      64.1502     438.3716    1950.0000    1950.0000     908.3874       1.1009     216.0000       0.1622       0.0936       0.0606       2.9311      13.6455     296.8137     336.1394      53.0198      -0.0048       0.0017       0.0287       8.1156    2549.9602      35.9607     -57.8750    4304.0000
 2630.1192      62.6767     404.0275    1950.0000    1950.0000     734.7263       1.3611     216.0000       0.1552       0.0861       0.0528       3.0211      15.0584     303.5121     329.6142      53.0198      -0.0075      -0.0013       0.0252       8.0814    2562.8164      46.0816     -66.1250    4301.0000
 2630.2716      61.0376     382.3461    1950.0000    1950.0000     542.1180       1.8446     216.0000       0.1610       0.0923       0.0593       3.0984      14.5504     301.0002     329.8335      53.0198      -0.0071      -0.0015       0.0255       8.0760    2552.1536      48.7544     -63.7500    4292.0000
 2630.4240      59.7464     371.8851    1950.0000    1950.0000     415.4799       2.4069     216.0000       0.1612       0.0925       0.0595       2.8683      14.0297     295.3252     339.5021      53.0198      -0.0049       0.0007       0.0284       8.0775    2551.7876      36.2384     -63.5625    4293.0000
 2630.5764      59.0793     365.0202    1950.0000    1950.0000     438.5841       2.2801     216.0000       0.1693       0.1013       0.0686       2.9684      12.1765     293.7436     329.3979      53.0198      -0.0037       0.0026       0.0302       8.0978    2536.7427      28.4524     -63.7500    4269.0000
 2630.7288      59.0661     353.3727    1950.0000    1950.0000     436.6199       2.2903     216.0000       0.1781       0.1108       0.0785       2.6422      13.9725     301.4653     313.6671      53.0198      -0.0062      -0.0002       0.0268       8.1283    2520.5098      26.9117     -62.8750    4281.0000
 2630.8812      59.5396     332.0336    1950.0000    1950.0000     487.2572       2.0523     216.0000       0.1913       0.1251       0.0933       2.6802      15.0013     295.1391     306.1280      53.0198      -0.0043       0.0020       0.0294       8.2008    2496.0205      26.3369     -63.1875    4279.0000
 2631.0336      60.2142     301.4375    1950.0000    1950.0000     575.7438       1.7369     216.0000       0.1908       0.1245       0.0927       2.2070      16.6377     292.3481     324.1544      53.0198      -0.0012       0.0056       0.0336       8.2622    2497.0730      29.6235     -60.0625    4332.0000
 2631.1860      60.7412     267.1532    1950.0000    1950.0000     812.0457       1.2315     216.0000       0.1957       0.1298       0.0982       2.2356      15.9593     292.3481     342.1690      53.0198      -0.0022       0.0045       0.0323       8.3455    2487.9866      37.5548     -63.7500    4294.0000
 2631.3384      60.8353     236.6213    1950.0000    1950.0000    1008.7439       0.9913     216.0000       0.2072       0.1423       0.1111       2.8345      15.1419     295.5112     345.3693      53.0198      -0.0020       0.0052       0.0327       8.4117    2466.6736      37.8085     -63.7500    4312.0000
 2631.4908      60.5115     214.9381    1950.0000    1950.0000    1250.9280       0.7994     216.0000       0.2100       0.1453       0.1142       3.1534      14.9251     299.2325     339.5800      53.0198      -0.0100      -0.0051       0.0215       8.4226    2461.5820      39.9916     -63.7500    4283.0000
 2631.6432      60.0437     203.5830    1950.0000    1950.0000    1435.6921       0.6965     216.0000       0.1958       0.1299       0.0983       2.7428      15.6036     302.3957     338.1240      53.0198      -0.0062      -0.0005       0.0267       8.3837    2487.8267      41.7894     -62.1250    4217.0000
 2631.7956      59.8158     201.5650    1950.0000    1950.0000    1577.2692       0.6340     216.0000       0.1861       0.1195       0.0875       2.7054      16.3193     311.8851     335.9351      53.1596      -0.0058       0.0002       0.0273       8.3773    2505.6680      55.0816     -61.2500    4253.0000
 2631.9480      60.1533     205.1166    1950.0000    1950.0000    1540.5592       0.6491     216.0000       0.1893       0.1230       0.0911       2.6748      16.8613     312.4433     330.7025      53.0198      -0.0110      -0.0064       0.0201       8.4281    2499.7034      55.6261     -62.3750    4310.0000
 2632.1004      61.2957     209.8321    1950.0000    1947.4066    1352.1987       0.7395     216.0000       0.1936       0.1276       0.0959       2.5957      16.6909     312.7224     330.2846      53.0198      -0.0023       0.0051       0.0324       8.5139    2491.7822      54.8658     -62.3750    4281.0000
 2632.2528      63.3605     214.2034    1950.0000    1861.0986    1109.1177       0.9016     216.0000       0.1955       0.1296       0.0980       2.5333      15.8722     314.1179     330.3926      53.1596      -0.0016       0.0052       0.0330       8.5947    2488.3601      51.5102     -60.8125    4316.0000
 2632.4052      65.5735     220.8750    1855.2196    1677.8278     958.2712       1.0435     216.0000       0.2051       0.1400       0.1088       2.8508      15.7376     314.3970     322.9117      53.0198      -0.0049       0.0002       0.0283       8.6818    2470.5249      40.4480     -63.7500    4229.0000
 2632.5576      66.2881     234.2609    1702.8177    1454.1057     476.5688       2.0983     216.0000       0.2297       0.1666       0.1363       2.6789      15.6913     314.1179     298.6538      53.0198       0.0072       0.0158       0.0451       8.7598    2425.1250      19.3444     -59.0625    4279.0000
 2632.7100      64.1389     253.8844    1493.7444    1215.5245     645.0479       1.5503     216.0000       0.2462       0.1844       0.1548       2.6091      15.1493     316.7228     282.2807      53.2995       0.0038       0.0120       0.0406       8.8220    2394.5906      13.1664     -60.6250    4295.0000
 2632.8624      59.7225     270.6228    1878.9926    1664.3441     987.3175       1.0128     216.0000       0.2628       0.2024       0.1734       2.4801      15.1541     304.6285     272.8500      53.2995      -0.0077      -0.0028       0.0245       8.8508    2363.8777      13.6807     -58.5625    4265.0000
 2633.0148      54.9794     261.5765    1589.7739    1785.2146     651.3956       1.5352     216.0000       0.2522       0.1910       0.1616       2.6563      14.3877     310.0244     302.3417      53.2995      -0.0059      -0.0007       0.0269       8.7862    2383.3733      21.6289     -63.7500    4305.0000
 2633.1672      51.5046     182.2268     667.6672     480.1563     262.5256       3.8092     216.0000       0.2353       0.1727       0.1427       2.5913      16.6640     310.4896     349.9663      53.2995      -0.0046       0.0009       0.0287       8.6817    2414.6162      32.7617     -63.3750    4287.0000
 2633.3196      53.3775     209.0091    1853.2737    1383.3158     311.9953       3.2052     216.0000       0.2087       0.1439       0.1128       2.8435      15.4411     307.9777     399.1652      53.2995      -0.0045       0.0010       0.0289       8.5767    2463.8645      30.3463     -63.7500    4279.0000
 2633.4720      56.1462     184.6356    1304.0437    1035.0808     399.6459       2.5022     216.0000       0.1913       0.1251       0.0933       2.8329      15.1236     305.9310     419.9798      53.2995      -0.0047       0.0007       0.0286       8.5090    2496.0247      28.8052     -54.0000    4307.0000
 2633.6244      59.1355     166.0143    1412.4972    1158.8604     393.2973       2.5426     216.0000       0.1905       0.1242       0.0924       2.5121      13.4967     306.3031     394.9561      53.2995       0.0004       0.0073       0.0357       8.4617    2497.5432      27.4999     -61.9375    4302.0000
 2633.7768      61.7036     155.7697    1615.6548    1411.6676     491.2572       2.0356     216.0000       0.1669       0.0987       0.0660       2.3845      13.1150     304.8145     369.3547      53.2995      -0.0005       0.0060       0.0344       8.3772    2541.1494      25.5988     -57.8125    4324.0000
 2633.9292      64.3927     156.1797    1797.8477    1668.2466     532.8494       1.8767     216.0000       0.1512       0.0817       0.0484       3.0825      14.1437     310.2105     340.9717      53.2995      -0.0015       0.0047       0.0331       8.3071    2570.2209      28.8104     -59.8750    4308.0000
 2634.0816      68.0882     168.5513    1914.5729    1852.1575     534.2719       1.8717     216.0000       0.1447       0.0747       0.0410       2.5810      13.6357     316.3507     344.7673      53.2995       0.0013       0.0082       0.0369       8.2869    2582.3342      28.9106     -63.7500    4290.0000
 2634.2340      73.2850     194.4825    1950.0000    1949.8834     541.1295       1.8480     216.0000       0.1409       0.0706       0.0368       2.1217      14.6067     316.9089     391.0801      53.2995       0.0000       0.0067       0.0352       8.3242    2589.3540      27.9621     -57.8125    4293.0000
 2634.3864      79.4398     236.9732    1950.0000    1950.0000     469.8652       2.1283     216.0000       0.1368       0.0662       0.0322       1.9229      12.6024     323.0491     446.5837      53.2995      -0.0018       0.0053       0.0329       8.4148    2596.8340      27.2599     -62.3125    4289.0000
 2634.5388      85.3292     297.8545    1950.0000    1950.0000     484.9834       2.0619     216.0000       0.1380       0.0674       0.0335       2.1451      13.2121     323.0491     466.5756      53.2995       0.0007       0.0080       0.0362       8.5240    2594.7097      31.1956     -55.6875    4302.0000
 2634.6912      89.3672     370.1079    1950.0000    1950.0000    1200.9159       0.8327     216.0000       0.1548       0.0856       0.0523       2.9523      13.1082     319.5138     445.2462      53.2995      -0.0043       0.0017       0.0293       8.6037    2563.6970      40.5399     -59.0625    4297.0000
 2634.8436      90.9624     429.7452    1950.0000    1950.0000    1463.3838       0.6833     216.0000       0.1992       0.1337       0.1022       3.0740      13.5884     315.4204     404.1061      53.2995      -0.0119      -0.0080       0.0186       8.7106    2481.4348      39.1656     -63.7500    4289.0000
 2634.9960      90.9452     456.5117    1905.3752    1912.8121    1147.8265       0.8712     216.0000       0.2349       0.1723       0.1422       3.3172      12.9458     304.0703     393.2965      53.2995      -0.0057       0.0006       0.0276       8.7888    2415.4128      28.9877     -56.6250    4303.0000
 2635.1484      89.8420     464.6479    1567.2773    1567.7059    1075.6771       0.9296     216.0000       0.2681       0.2082       0.1794       2.4850      12.9678     309.2802     394.6857      53.2995      -0.0039       0.0028       0.0301       8.8905    2353.9683      22.5530     -63.5625    4362.0000
 2635.3008      86.5327     481.7973    1245.3535    1205.1161    1115.2278       0.8967     216.0000       0.2521       0.1909       0.1614       2.3273      12.8128     316.7228     424.0732      53.2995      -0.0009       0.0062       0.0341       8.9248    2383.6162      23.9974     -62.6875    4333.0000
 2635.4532      79.3490     472.9751    1175.1495    1041.7006    1160.7157       0.8615     216.0000       0.2203       0.1564       0.1257       2.5580      12.5411     316.3507     446.0978      53.2995       0.0002       0.0070       0.0354       8.9024    2442.5217      27.8317     -59.2500    4328.0000
 2635.6056      69.0146     486.6715    1359.3335    1486.1200    1598.0645       0.6258     216.0000       0.2056       0.1406       0.1093       2.3210      11.5434     315.7925     445.7080      53.2995       0.0031       0.0105       0.0394       8.8573    2469.6191      31.3811     -62.6250    4263.0000
 2635.7580      55.5699     393.3471     649.3206     515.7919     649.6504       1.5393     216.0000       0.2010       0.1355       0.1041       2.4596      12.8389     312.7224     445.2231      53.2995      -0.0039       0.0015       0.0297       8.7889    2478.2292      30.9870     -61.3125    4217.0000
 2635.9104      49.2113     197.5144     288.6834     226.2004     296.0804       3.3775     216.0000       0.2110       0.1464       0.1154       2.7459      13.0461     318.2114     436.8732      53.2995      -0.0079      -0.0035       0.0241       8.7359    2459.6121      31.2220     -58.3750    4319.0000
 2636.0628      49.9691     465.5224     951.8788     424.1984     778.3578       1.2848     216.0000       0.2006       0.1352       0.1037       2.6768      15.9728     323.8864     444.6926      53.2995      -0.0025       0.0038       0.0317       8.6608    2478.8501      35.1923     -63.7500    4384.0000
 2636.2152      58.2937     378.4463     945.3013     673.2352     819.7981       1.2198     216.0000       0.1984       0.1327       0.1012       2.9124      14.6254     320.0721     442.5130      53.2995       0.0001       0.0071       0.0354       8.6169    2483.0239      35.8137     -55.6875    4281.0000
 2636.3676      64.1754     318.3764    1015.3144     705.2091     854.5367       1.1702     216.0000       0.1758       0.1083       0.0759       2.8106      15.0152     317.0950     463.4604      53.2995      -0.0044       0.0011       0.0291       8.5589    2524.7708      42.2295     -56.4375    4289.0000
 2636.5200      69.2717     265.7756    1206.9744     895.4983     975.6179       1.0250     216.0000       0.1603       0.0916       0.0585       2.4301      12.4807     304.6285     483.2487      53.2995       0.0018       0.0088       0.0376       8.5182    2553.4248      46.4267     -54.0000    4236.0000
 2636.6724      73.2363     241.2120    1420.9862    1206.2852    1145.4082       0.8731     216.0000       0.1394       0.0689       0.0350       2.3571      14.2612     306.1170     507.9329      53.2995       0.0002       0.0073       0.0356       8.4576    2592.1799      55.9920     -56.4375    4308.0000
 2636.8248      75.5966     209.8202    1594.1318    1602.2637    1422.6669       0.7029     216.0000       0.1317       0.0606       0.0265       2.7039      13.1595     306.3031     520.2505      53.2995      -0.0036       0.0032       0.0304       8.4162    2606.2932      62.9275     -56.0000    4268.0000
 2636.9772      75.2887     183.6987    1596.2301    1770.1322    1529.2622       0.6539     216.0000       0.1496       0.0800       0.0465       2.6552      13.7429     306.3031     508.8513      53.2995      -0.0080      -0.0018       0.0245       8.4170    2573.2410      59.2048     -54.0000    4279.0000
 2637.1296      74.1223     163.2834    1663.3656    1712.2872    1463.2980       0.6834     216.0000       0.1769       0.1095       0.0772       2.6066      11.7937     304.0703     484.0631      53.2995      -0.0099      -0.0043       0.0218       8.4368    2522.6797      44.7273     -54.0000    4285.0000
 2637.2820      72.3442     145.8348    1236.4152    1372.2646    1141.4523       0.8761     216.0000       0.1821       0.1151       0.0829       2.5846      13.2205     294.5809     469.2836      53.2995      -0.0066      -0.0005       0.0263       8.4015    2513.1411      40.1577     -51.1875    4246.0000
 2637.4344      68.4979     162.3819    1523.3369    1035.3041     843.6140       1.1854     216.0000       0.1612       0.0925       0.0595       2.7725      13.6532     294.5809     475.0018      53.2995      -0.0073      -0.0018       0.0252       8.3072    2551.7710      46.6406     -49.1250    4344.0000
 2637.5868      67.2156     192.0177    1610.5679     764.9632     589.5039       1.6963     216.0000       0.1420       0.0718       0.0380       2.8380      14.7409     294.9530     487.5638      53.2995      -0.0088      -0.0041       0.0230       8.2044    2587.2937      63.5918     -47.6875    4442.0000
 2637.7392      67.8022     252.3673    1834.0686     801.2249     594.4196       1.6823     216.0000       0.1563       0.0872       0.0540       2.6458      14.5256     286.2079     475.9123      53.2995       0.0000       0.0072       0.0353       8.1495    2560.8997      60.8087     -44.8750    4367.0000
 2637.8916      70.0367     362.9715    1950.0000     620.8991     355.8944       2.8098     216.0000       0.1646       0.0962       0.0633       2.7910      15.3407     282.3004     465.8918      53.2995       0.0006       0.0081       0.0362       8.0895    2545.5759      56.0122     -46.4375    4311.0000
 2638.0440      73.0856     540.0520    1950.0000    1241.1759     468.2663       2.1355     216.0000       0.1421       0.0719       0.0382       2.5866      15.3398     285.6496     470.8946      53.2995      -0.0028       0.0040       0.0315       7.9813    2587.0481      63.0005     -44.2500    4179.0000
 2638.1964      75.3784     716.0643    1950.0000     748.0662     378.0258       2.6453     216.0000       0.0944       0.0203      -0.0153       2.6479      15.8803     271.9737     492.4126      53.2995      -0.0016       0.0045       0.0328       7.8321    2675.3118      88.1612     -42.4375    4194.0000
 2638.3488      75.7687     724.3699    1950.0000     791.2758     307.2830       3.2543     216.0000       0.0594      -0.0176      -0.0546       2.8540      14.1990     273.7414     503.4521      53.2995      -0.0036       0.0016       0.0300       7.7072    2740.1230     131.9109     -35.6875    4744.0000
 2638.5012      74.5485     584.2764    1950.0000    1873.7943     463.3591       2.1582     216.0000       0.0543      -0.0231      -0.0603       2.8948      13.5453     269.2758     490.4642      53.2995      -0.0031       0.0027       0.0308       7.6400    2749.4839     174.3104     -38.0625    4782.0000
 2638.6536      73.0225     442.9617    1950.0000    1254.6143     405.1094       2.4685     216.0000       0.0580      -0.0191      -0.0561       2.6733      12.5697     256.0650     473.7582      53.2995       0.0006       0.0079       0.0361       7.6124    2742.6343     216.0340     -38.1250    4669.0000
 2638.8060      72.3221     352.1231    1950.0000    1440.1611     387.6285       2.5798     216.0000       0.0574      -0.0197      -0.0568       2.2811      13.1072     259.9724     464.5605      53.2995      -0.0089      -0.0035       0.0231       7.5973    2743.7441     249.7701     -37.6875    4629.0000
 2638.9584      72.8484     307.5105    1950.0000    1746.0562     408.5539       2.4477     216.0000       0.0576      -0.0196      -0.0566       2.3869      13.0535     265.3683     462.5936      53.2995      -0.0105      -0.0055       0.0209       7.6036    2743.4309     289.2043     -36.7500    4532.0000
 2639.1108      74.4375     299.5233    1950.0000    1920.7435     480.0441       2.0831     216.0000       0.0687      -0.0075      -0.0441       3.0556      14.8963     274.2066     458.1351      53.2995      -0.0048       0.0022       0.0290       7.6480    2722.8389     235.5928     -37.4375    4415.0000
 2639.2632      76.6824     325.4368    1950.0000    1950.0000     752.1923       1.3294     216.0000       0.0898       0.0153      -0.0205       2.7661      15.7626     284.7194     450.9585      53.2995      -0.0067      -0.0003       0.0263       7.7128    2683.8176     161.7734     -35.5625    4388.0000
 2639.4156      79.1713     390.2479    1950.0000    1946.6644    1028.6462       0.9722     216.0000       0.1137       0.0411       0.0063       2.4103      16.0372     285.3705     447.8266      53.2995      -0.0063      -0.0000       0.0267       7.7793    2639.6819      92.1242     -34.5000    4236.0000
 2639.5680      81.6244     502.7905    1950.0000    1950.0000    1950.0000       0.5096     216.0000       0.1394       0.0689       0.0351       2.5677      16.3612     283.7890     444.0591      53.2995      -0.0079      -0.0026       0.0244       7.8467    2592.1479      55.9186     -32.6250    4259.0000
 2639.7204      83.9350     664.1271    1950.0000    1933.8678    1822.7856       0.5486     216.0000       0.1511       0.0816       0.0482       2.8068      15.3910     285.4636     443.2247      53.2995      -0.0050       0.0013       0.0285       7.8690    2570.5471      38.4174     -34.3125    4298.0000
 2639.8728      86.1645     847.3723    1950.0000    1616.3701    1392.1736       0.7183     216.0000       0.1407       0.0704       0.0366       2.7409      15.4994     277.6488     444.1669      53.2995      -0.0014       0.0054       0.0333       7.8323    2589.6602      35.0394     -32.1250    4356.0000
 2640.0252      88.4029     994.2383    1950.0000    1459.0562    1281.0247       0.7806     216.0000       0.1287       0.0574       0.0231       2.7308      15.1693     284.5333     419.9548      53.2995      -0.0034       0.0028       0.0305       7.7303    2611.9114      33.9609     -31.9375    4454.0000
 2640.1776      90.4811    1036.3767    1950.0000     972.3179     887.2374       1.1271     216.0000       0.1230       0.0512       0.0167       2.4439      19.3967     287.0452     368.0148      53.2995      -0.0052       0.0004       0.0280       7.5827    2622.4033      21.0608     -32.5625    4377.0000
 2640.3300      91.6895     936.8759    1950.0000    1082.7755     865.7338       1.1551     216.0000       0.1054       0.0322      -0.0030       2.7291      24.2931     281.4631     310.2591      53.2995       0.0034       0.0111       0.0399       7.3946    2654.9204      15.6530     -32.5625    4259.0000
 2640.4824      91.1555     749.6345    1950.0000     967.3021     649.9091       1.5387     216.0000       0.0890       0.0145      -0.0214       2.6110      26.2504     258.0187     263.4234      53.2995       0.0054       0.0138       0.0427       7.1971    2685.2854      17.0592     -30.5000    4319.0000
 2640.6348      88.8394     574.1650    1950.0000     842.3182     574.7783       1.7398     216.0000       0.0831       0.0080      -0.0281       2.4571      23.8594     255.5068     245.6236      53.2995      -0.0096      -0.0045       0.0221       7.1105    2696.3350      28.6891     -29.3125    4240.0000
 2640.7872      85.8418     452.4330    1950.0000     386.1507     270.2341       3.7005     216.0000       0.0901       0.0156      -0.0202       2.6643      20.0470     244.9010     250.7794      53.2995      -0.0138      -0.0093       0.0163       7.1583    2683.3931      54.4968     -29.5000    4354.0000
 2640.9396      83.5327     378.5153    1950.0000     314.1181     234.4036       4.2661     216.0000       0.0858       0.0110      -0.0250       2.5212      16.6926     247.4129     279.8569      53.2995      -0.0085      -0.0022       0.0239       7.2860    2691.2681      74.7847     -28.6250    4449.0000
 2641.0920      82.6767     338.1137    1950.0000     611.2717     333.9137       2.9948     216.0000       0.0767       0.0011      -0.0352       2.6295      15.3981     250.2969     310.7242      53.2995      -0.0107      -0.0054       0.0207       7.4000    2708.0781     121.1369     -31.3750    4446.0000
 2641.2444      83.3374     320.5154    1950.0000     790.9801     453.4226       2.2054     216.0000       0.0845       0.0096      -0.0264       2.8236      14.3142     255.2277     330.2600      53.2995      -0.0098      -0.0043       0.0219       7.4851    2693.6221     208.8465     -29.6250    4372.0000
 2641.3968      85.1888     320.2790    1950.0000     904.7574     529.7436       1.8877     216.0000       0.0893       0.0147      -0.0211       2.5033      14.1067     254.1113     357.8329      53.2995      -0.0073      -0.0011       0.0254       7.5630    2684.7864     217.6098     -31.0000    4336.0000
 2641.5492      87.8569     336.7895    1950.0000     982.1125     753.1351       1.3278     216.0000       0.0916       0.0172      -0.0185       2.7148      14.5403     258.2978     383.1377      53.2995      -0.0097      -0.0042       0.0220       7.6184    2680.5571     235.3838     -27.7500    4318.0000
 2641.7016      91.1192     373.3054    1950.0000     909.6837     881.8308       1.1340     216.0000       0.0923       0.0180      -0.0177       2.7658      14.8654     261.9261     402.6749      53.2995      -0.0066      -0.0001       0.0264       7.6462    2679.1838     203.7381     -31.8750    4342.0000
 2641.8540      94.8140     434.8131    1950.0000     859.8138     983.5403       1.0167     216.0000       0.0899       0.0154      -0.0204       2.6697      14.8503     268.1594     418.6892      53.2995      -0.0033       0.0042       0.0310       7.6514    2683.7080     206.7256     -29.3125    4272.0000
 2642.0064      98.6577     526.5112    1950.0000     680.2538     926.2690       1.0796     216.0000       0.0921       0.0178      -0.0179       2.7379      14.9118     263.0425     424.3696      53.2995      -0.0062       0.0003       0.0270       7.6650    2679.6072     188.3889     -31.5625    4372.0000
 2642.1588     102.0006     641.9124    1950.0000     618.4635     671.9214       1.4883     216.0000       0.0897       0.0151      -0.0207       2.6951      13.9363     266.8569     424.2499      53.2995      -0.0104      -0.0053       0.0210       7.6687    2684.1016     153.9052     -31.8125    4349.0000
 2642.3112     103.7575     741.8459    1950.0000     685.1541     530.5007       1.8850     216.0000       0.0924       0.0181      -0.0176       2.5762      14.6951     270.5782     408.9422      53.2995      -0.0068      -0.0007       0.0261       7.6624    2678.9827     115.1424     -31.6875    4270.0000
 2642.4636     103.0479     761.5756    1950.0000     740.8052     547.5566       1.8263     216.0000       0.0848       0.0099      -0.0261       2.3453      14.0906     272.9971     401.2899      53.2995      -0.0052       0.0014       0.0283       7.6358    2693.1379     118.0397     -32.4375    4338.0000
 2642.6160     100.2383     695.7625    1950.0000    1324.5347     489.3198       2.0437     216.0000       0.0970       0.0231      -0.0125       2.9142      13.8701     261.3680     386.6351      53.2995      -0.0089      -0.0039       0.0230       7.6419    2670.5752      81.9599     -34.5000    4256.0000
 2642.7684      96.8917     609.9986    1950.0000     881.8015     279.0118       3.5841     216.0000       0.0998       0.0261      -0.0093       2.9529      11.9190     257.1814     396.7278      53.2995      -0.0065      -0.0005       0.0264       7.6517    2665.3831      88.2222     -31.8750    4285.0000
 2642.9208      94.6004     554.6730    1950.0000    1239.3229     215.6754       4.6366     216.0000       0.1023       0.0288      -0.0066       2.8292      12.4619     262.9495     411.4101      53.2995      -0.0040       0.0030       0.0300       7.6696    2660.8269      75.4290     -30.0000    4248.0000
 2643.0732      93.9096     543.9820    1950.0000    1548.6053     436.0647       2.2932     216.0000       0.0754      -0.0003      -0.0367       2.8574      13.0474     260.7167     437.5224      53.2995      -0.0074      -0.0019       0.0251       7.6164    2710.4941     127.7291     -31.3750    4328.0000
 2643.2256      94.0031     570.7963    1950.0000    1918.6102     888.0847       1.1260     216.0000       0.0729      -0.0029      -0.0394       2.9448      14.8901     259.1351     429.3656      53.2995      -0.0058      -0.0002       0.0273       7.5657    2715.0437     145.2191     -34.5000    4571.0000
 2643.3780      93.3713     616.6487    1950.0000    1950.0000    1386.6226       0.7212     216.0000       0.0775       0.0020      -0.0343       2.8289      14.1267     260.1585     415.1172      53.2995      -0.0010       0.0058       0.0339       7.5147    2706.6274     173.1173     -34.5000    4529.0000
 2643.5304      91.0878     659.4692    1950.0000    1950.0000    1146.0651       0.8726     216.0000       0.0896       0.0150      -0.0208       2.8707      14.9540     258.5769     410.6963      53.2995      -0.0008       0.0059       0.0341       7.5131    2684.2666     138.7183     -34.5000    4438.0000
 2643.6828      87.6920     691.5095    1950.0000    1950.0000    1158.8531       0.8629     216.0000       0.0837       0.0087      -0.0273       2.6828      15.7128     259.6933     429.8124      53.2995       0.0039       0.0116       0.0405       7.5328    2695.1067     109.2292     -34.5000    4355.0000
 2643.8352      84.6185     731.0793    1950.0000    1950.0000    1256.8646       0.7956     216.0000       0.0752      -0.0005      -0.0369       2.6579      15.3237     259.4142     452.0085      53.2995      -0.0028       0.0025       0.0311       7.5750    2710.8567      98.0269     -34.2500    4253.0000
 2643.9876      83.1482     807.5552    1950.0000    1950.0000     867.3036       1.1530     216.0000       0.0960       0.0220      -0.0136       2.8849      14.5606     261.9261     445.7517      53.2995      -0.0074      -0.0026       0.0249       7.6591    2672.3762      77.3542     -34.5000    4253.0000
 2644.1400      83.8802     941.2231    1950.0000    1950.0000    1860.5531       0.5375     216.0000       0.1174       0.0452       0.0104       2.8956      13.1752     261.4610     434.1855      53.2995      -0.0030       0.0034       0.0312       7.7089    2632.7859      68.5367     -33.8750    4314.0000
 2644.2924      86.6921    1122.1090    1950.0000    1950.0000    1580.9435       0.6325     216.0000       0.1396       0.0691       0.0353       2.8701      12.5934     265.5544     404.1719      53.2995      -0.0016       0.0059       0.0333       7.7051    2591.8157      53.4645     -34.5000    4253.0000
 2644.4448      90.7501    1287.9435    1950.0000    1950.0000    1184.4781       0.8443     216.0000       0.1374       0.0668       0.0329       2.8292      12.2685     259.7863     371.5186      53.2995      -0.0029       0.0035       0.0312       7.5991    2595.7395      52.4729     -34.1875    4404.0000
 2644.5972      94.5759    1328.4890    1950.0000    1950.0000    1478.2352       0.6765     216.0000       0.1215       0.0495       0.0150       2.9791      13.3287     252.9949     344.2514      53.2995      -0.0039       0.0016       0.0297       7.4540    2625.2966      65.8561     -34.5000    4383.0000
 2644.7496      96.7521    1218.8342    1950.0000    1950.0000    1462.7424       0.6836     216.0000       0.1000       0.0263      -0.0091       2.9129      14.7328     259.1351     341.7256      53.2995       0.0013       0.0079       0.0368       7.3383    2665.0142     119.5115     -34.5000    4351.0000
 2644.9020      97.0084    1060.3528    1950.0000    1950.0000    1827.9291       0.5471     216.0000       0.0821       0.0070      -0.0291       2.7757      16.2178     266.9500     363.5676      53.2995       0.0002       0.0068       0.0353       7.2844    2698.0479     162.6103     -34.5000    4343.0000
 2645.0544      96.3047     945.7825    1950.0000    1901.6804    1179.0806       0.8481     216.0000       0.0845       0.0095      -0.0265       2.6493      15.5674     261.4610     379.3526      53.2995      -0.0037       0.0016       0.0299       7.2893    2693.7246      93.2333     -34.2500    4320.0000
 2645.2068      95.7907     903.9982    1950.0000    1816.8641    1165.6962       0.8579     216.0000       0.0797       0.0044      -0.0319       2.6441      15.3508     267.7872     390.2290      53.2995       0.0001       0.0069       0.0353       7.2837    2702.5601      86.3164     -33.8125    4304.0000
 2645.3592      96.0590     944.3554    1950.0000    1688.9121    1034.9109       0.9663     216.0000       0.0664      -0.0100      -0.0468       2.8749      14.5156     251.8785     387.4328      53.2995      -0.0003       0.0064       0.0347       7.2369    2727.1655     120.7082     -32.4375    4353.0000
 2645.5116      97.0960    1068.4707    1950.0000    1950.0000    1182.6499       0.8456     216.0000       0.0605      -0.0165      -0.0534       2.9342      14.9193     253.2740     369.7002      53.2995      -0.0074      -0.0017       0.0251       7.1732    2738.1409     224.2767     -34.5000    4305.0000
 2645.6640      98.8608    1256.0493    1950.0000    1445.0092     815.8493       1.2257     216.0000       0.0873       0.0126      -0.0233       2.9302      15.6829     247.1338     337.0428      53.2995      -0.0079      -0.0018       0.0246       7.1632    2688.4570      70.1226     -32.1250    4376.0000
 2645.8164     101.7643    1432.4420    1950.0000    1321.7300     702.7903       1.4229     216.0000       0.1164       0.0441       0.0093       2.7444      16.4410     246.3895     327.5981      53.2995      -0.0083      -0.0017       0.0242       7.2203    2634.5969      43.4855     -33.9375    4415.0000
 2645.9688     106.3745    1470.3401    1950.0000    1082.7302     666.9944       1.4993     216.0000       0.1276       0.0562       0.0219       2.8243      15.7247     240.9936     345.2201      53.2995      -0.0120      -0.0068       0.0189       7.2843    2613.9438      40.8060     -32.8125    4319.0000
 2646.1212     112.4615    1302.7190    1950.0000    1158.1868     687.2917       1.4550     216.0000       0.1120       0.0392       0.0043       2.9023      14.5323     241.8309     370.4827      53.2995      -0.0104      -0.0042       0.0213       7.2878    2642.8838      64.2070     -30.3750    4281.0000
 2646.2736     118.2822    1038.0972    1950.0000     914.5668     663.5504       1.5070     216.0000       0.0854       0.0106      -0.0254       2.9405      14.5377     237.2723     374.2047      53.2995      -0.0085      -0.0023       0.0239       7.1867    2691.9426     115.8945     -28.3125    4297.0000
 2646.4260     121.2232     808.7241    1950.0000    1487.4534     894.1908       1.1183     216.0000       0.0634      -0.0133      -0.0502       3.0299      14.7364     239.3190     355.5880      53.2995      -0.0079      -0.0015       0.0247       7.0427    2732.7678     170.8929     -29.7500    4311.0000
 2646.5784     120.2549     663.1844    1950.0000     789.3542     604.7389       1.6536     216.0000       0.0462      -0.0319      -0.0694       2.8060      15.3868     232.0624     342.4854      53.2995      -0.0087      -0.0033       0.0234       6.9132    2764.5889     429.8800     -27.3125    4364.0000
 2646.7308     117.2539     597.4246    1950.0000     744.0566     614.8523       1.6264     216.0000       0.0557      -0.0216      -0.0588       2.7781      13.1104     237.3653     334.6164      53.2995      -0.0085      -0.0029       0.0237       6.8984    2746.9382     511.7341     -24.6875    4341.0000
 2646.8832     115.0803     598.7364    1950.0000     375.0642     336.6750       2.9702     216.0000       0.0694      -0.0068      -0.0434       2.9723      14.1310     232.8066     342.3505      53.2995      -0.0058       0.0002       0.0273       6.9480    2721.5457     238.7365     -26.7500    4356.0000
 2647.0356     115.6091     659.9297    1950.0000     661.0779     417.8516       2.3932     216.0000       0.0819       0.0067      -0.0294       2.9273      12.3933     248.2502     344.7897      53.2995      -0.0087      -0.0029       0.0234       6.9885    2698.4753     223.8417     -24.6875    4327.0000
 2647.1880     119.6021     764.9830    1950.0000    1127.1292     689.2041       1.4509     216.0000       0.0874       0.0127      -0.0232       2.7948      14.7781     246.5756     323.6909      53.2995      -0.0053       0.0012       0.0281       6.9398    2688.2905     131.5146     -27.7500    4305.0000
 2647.3404     127.2079     874.6406    1950.0000    1650.8788     700.9148       1.4267     216.0000       0.0974       0.0235      -0.0120       2.8402      13.0547     236.1559     273.0882      53.2995      -0.0009       0.0062       0.0341       6.8261    2669.8386      89.9650     -24.6875    4308.0000
 2647.4928     137.6962     907.2872    1950.0000    1392.1438     496.3266       2.0148     216.0000       0.1133       0.0407       0.0058       2.9161      14.8956     243.2264     212.8246      53.2995      -0.0034       0.0029       0.0306       6.6866    2640.4194      57.6421     -26.1875    4326.0000
 2647.6452     148.5549     820.0770    1950.0000    1866.2797     709.0387       1.4104     216.0000       0.1118       0.0391       0.0041       3.0940      14.2443     247.4129     188.0200      53.2995      -0.0052       0.0005       0.0280       6.5705    2643.1794      75.2602     -23.9375    4373.0000
 2647.7976     155.1479     673.9656    1950.0000    1950.0000    1192.9413       0.8383     216.0000       0.0972       0.0233      -0.0123       2.6393      14.5190     252.9949     183.6862      53.2995      -0.0025       0.0041       0.0318       6.4757    2670.2417     108.1726     -24.6875    4354.0000
 2647.9500     153.6946     537.3945    1935.5288    1592.6228    1034.5648       0.9666     216.0000       0.0821       0.0069      -0.0292       2.7974      13.8738     231.5042     177.8216      53.2995       0.0033       0.0107       0.0396       6.3753    2698.1753     230.5031     -23.5000    4328.0000
 2648.1024     144.1212     418.4398    1430.2552     955.1866     708.9672       1.4105     216.0000       0.0745      -0.0013      -0.0377       2.9238      14.4783     225.5500     165.8404      53.2995       0.0005       0.0067       0.0356       6.2814    2712.1936     272.1869     -24.6875    4268.0000
 2648.2548     135.0614     371.8584    1176.6548     595.2301     599.0369       1.6693     216.0000       0.0728      -0.0031      -0.0395       2.9061      15.3454     229.2714     168.1516      53.2995      -0.0039       0.0016       0.0297       6.2750    2715.2290     274.7561     -23.5000    4302.0000
 2648.4072     122.4244     421.4559     701.6143     333.4747     292.5214       3.4186     216.0000       0.0679      -0.0084      -0.0451       2.9872      15.6697     240.9936     192.1129      53.2995      -0.0067      -0.0013       0.0260       6.3749    2724.3638     184.9892     -24.6875    4356.0000
 2648.5596     133.9864     441.2762    1950.0000    1509.2744     624.9363       1.6002     216.0000       0.0560      -0.0213      -0.0585       2.7558      14.5241     240.9936     225.3838      53.2995      -0.0078      -0.0023       0.0245       6.5219    2746.4539     161.7248     -22.1875    4324.0000
 2648.7120     135.8771     485.0254    1950.0000    1683.5543    1270.9476       0.7868     216.0000       0.0558      -0.0215      -0.0586       2.7858      14.8437     234.4812     238.6310      53.2995      -0.0040       0.0023       0.0298       6.6324    2746.7427     231.8433     -22.1250    4378.0000
 2648.8644     138.0758     504.2405    1587.0624     752.1271     621.8508       1.6081     216.0000       0.0572      -0.0200      -0.0571       2.9440      14.5194     236.8071     245.4383      53.2995      -0.0032       0.0030       0.0308       6.6817    2744.1357     171.7841     -21.8125    4285.0000
 2649.0168     144.5027     519.2728    1771.9919     715.8401     598.3566       1.6712     216.0000       0.0927       0.0184      -0.0173       2.9944      15.8787     237.0862     229.4698      53.2995      -0.0012       0.0052       0.0336       6.7400    2678.5166     116.4120     -20.3750    4317.0000
 2649.1692     157.7044     549.1426    1844.1525     503.5648     414.8007       2.4108     216.0000       0.1226       0.0508       0.0163       2.7623      14.0378     244.9010     207.7310      53.2995      -0.0004       0.0066       0.0347       6.7405    2623.1033      32.9187     -22.1250    4295.0000
 2649.3216     176.7933     669.8937    1950.0000     447.7496     445.1526       2.2464     216.0000       0.1286       0.0572       0.0229       2.6597      15.7845     239.8772     179.2834      53.2995       0.0016       0.0089       0.0374       6.6161    2612.1604      23.4049     -22.1250    4316.0000
 2649.4740     192.9725     835.8885    1950.0000     819.4953     717.8051       1.3931     216.0000       0.1003       0.0266      -0.0088       2.7827      14.7504     239.8772     142.4177      53.2995      -0.0015       0.0049       0.0331       6.2970    2664.4668      24.1774     -21.3125    4401.0000
 2649.6264     196.8276    1031.3644    1950.0000     768.1151     938.0263       1.0661     216.0000       0.0747      -0.0011      -0.0375       2.8369      16.0357     228.1550      96.8926      53.2995      -0.0001       0.0066       0.0350       5.9165    2711.8455      65.3465     -20.0625    4369.0000
 2649.7788     187.6881    1178.9205    1950.0000    1110.6826     949.5491       1.0531     216.0000       0.0743      -0.0015      -0.0380       2.7942      14.9394     227.5968      45.7532      53.2995      -0.0026       0.0037       0.0316       5.6124    2712.6235     241.5089     -22.1250    4405.0000
 2649.9312     172.4019    1185.0918    1950.0000    1462.8151    1240.4451       0.8062     216.0000       0.0783       0.0029      -0.0334       2.7758      15.3632     227.0386       7.2105      53.2995      -0.0084      -0.0031       0.0238       5.4393    2705.0977     716.5923     -22.0000    4322.0000
 2650.0836     156.4019    1037.1952    1950.0000    1950.0000    1181.8202       0.8462     216.0000       0.0785       0.0031      -0.0332       2.7440      14.9443     227.5968      -7.0946      53.2995      -0.0067      -0.0008       0.0261       5.3414    2704.7434    1155.0914     -19.3125    4348.0000
 2650.2360     142.0159     820.8607    1950.0000    1950.0000     942.5540       1.0609     216.0000       0.0773       0.0017      -0.0346       2.6646      15.2694     227.7828      -9.1276      53.2995      -0.0061       0.0004       0.0271       5.2935    2707.0251    1169.1263     -24.6875    4305.0000
 2650.3884     130.4903     628.4381    1950.0000    1950.0000     919.0331       1.0881     216.0000       0.0742      -0.0016      -0.0381       2.5121      15.8743     228.3410      -1.8625      53.2995      -0.0093      -0.0040       0.0225       5.2376    2712.8098    1080.9517     -18.6875    4285.0000
 2650.5408     122.8818     495.2295    1950.0000    1876.3007     951.0267       1.0515     216.0000       0.0736      -0.0023      -0.0387       2.6876      16.7461     228.9923      -0.6905      53.2995      -0.0072      -0.0012       0.0254       5.2368    2713.8762    1172.4073     -22.1875    4273.0000
 2650.6932     119.8400     414.8109    1950.0000    1726.5175    1180.0096       0.8475     216.0000       0.0739      -0.0020      -0.0384       2.5031      15.9888     231.5042      -2.3036      53.2995      -0.0082      -0.0025       0.0241       5.2528    2713.3398    1148.5432     -20.3750    4341.0000
 2650.8456     121.4312     375.3770    1894.1699    1427.0911    1214.4502       0.8234     216.0000       0.0800       0.0047      -0.0315       2.5536      17.1280     231.5042      -5.3518      53.2995      -0.0090      -0.0034       0.0230       5.3209    2702.0337    1344.1271     -20.8125    4303.0000
 2650.9980     126.9511     370.3557    1783.4471    1101.9994    1198.1781       0.8346     216.0000       0.0835       0.0085      -0.0276       2.6953      17.9952     233.9230      -7.5519      53.2995      -0.0038       0.0036       0.0304       5.3598    2695.4751    1239.7255     -20.7500    4284.0000
 2651.1504     134.4930     398.2495    1655.3604     863.3995    1097.5099       0.9112     216.0000       0.0803       0.0050      -0.0312       2.8277      19.7269     237.3653      -7.1590      53.2995      -0.0057       0.0010       0.0277       5.3418    2701.4841    1213.7711     -19.1250    4413.0000
 2651.3028     139.7011     449.5060    1562.9440     696.9147     960.5309       1.0411     216.0000       0.0735      -0.0024      -0.0388       2.5861      20.1532     233.7370      -5.4333      53.2995      -0.0103      -0.0048       0.0213       5.2825    2714.0459    1144.5640     -21.3125    4404.0000
 2651.4552     143.0660     558.8560    1950.0000     478.1898    1889.0043       0.5294     216.0000       0.0682      -0.0081      -0.0448       2.4593      18.8427     235.7837      -3.5648      53.2995      -0.0091      -0.0033       0.0230       5.2355    2723.8977    1094.2468     -16.6875    4329.0000
 2651.6076     132.8481     743.0660    1531.0884     775.7581     889.3226       1.1245     216.0000       0.0704      -0.0057      -0.0423       2.4741      19.7038     236.5280      -4.0729      53.2995      -0.0087      -0.0021       0.0237       5.2586    2719.7676    1112.1287     -22.6875    4295.0000
 2651.7600     134.0159     873.9698    1727.3944     829.0280     679.2206       1.4723     216.0000       0.0756      -0.0001      -0.0364       2.5246      18.6270     233.1788      -5.4245      53.2995      -0.0123      -0.0068       0.0186       5.3024    2710.1340    1088.8557     -15.8750    4301.0000
 2651.9124     132.7098    1138.4196    1941.4342     800.6677     666.1668       1.5011     216.0000       0.0848       0.0099      -0.0262       2.4641      19.4351     230.7599      -5.8815      53.2995      -0.0142      -0.0090       0.0160       5.3455    2693.1479    1255.1537     -20.8125    4298.0000
 2652.0648     134.9879    1005.4621    1946.7062    1131.1418     688.1523       1.4532     216.0000       0.0938       0.0196      -0.0161       2.7018      18.6837     228.9923      -3.5803      53.2995      -0.0114      -0.0052       0.0200       5.3160    2676.5190     667.9127     -18.5625    4273.0000
 2652.2172     138.9818     888.1941    1751.7632     911.3127     473.8108       2.1105     216.0000       0.0961       0.0221      -0.0135       2.4111      18.5753     228.9923       1.1795      53.2995      -0.0111      -0.0051       0.0203       5.2719    2672.1960     333.7205     -20.1875    4285.0000
 2652.3696     144.8675     813.1693    1886.0289     937.0246     378.7653       2.6402     216.0000       0.0883       0.0137      -0.0222       2.5137      19.2803     228.4341       2.9962      53.2995      -0.0091      -0.0032       0.0229       5.1570    2686.5974     308.2162     -16.6875    4346.0000
 2652.5220     150.5551     807.3195    1950.0000     934.1008     521.4149       1.9179     216.0000       0.0754      -0.0002      -0.0366       2.5688      20.0391     225.1779       1.4000      53.2995      -0.0052       0.0005       0.0280       5.0989    2710.4246     368.7328     -22.9375    4311.0000
 2652.6744     153.9286     866.7727    1950.0000     788.4445     694.2805       1.4403     216.0000       0.0666      -0.0098      -0.0465       2.6166      18.0880     224.2476      -2.2733      53.2995       0.0006       0.0075       0.0360       5.0544    2726.8042     587.1860     -19.0625    4336.0000
 2652.8268     154.5542     978.2604    1950.0000     951.9717    1017.7874       0.9825     216.0000       0.0622      -0.0146      -0.0515       2.5382      16.5653     225.3640      -1.9457      53.2995      -0.0011       0.0053       0.0336       5.0938    2734.9990     692.9736     -19.8125    4325.0000
 2652.9792     153.6883    1103.0458    1950.0000    1263.4287    1804.3917       0.5542     216.0000       0.0652      -0.0113      -0.0481       2.4140      16.6737     225.9222       2.7330      53.2995      -0.0051       0.0009       0.0283       5.2037    2729.3611     841.8632     -19.4375    4305.0000
 2653.1316     152.7445    1177.0706    1950.0000    1308.7150    1950.0000       0.5000     216.0000       0.0729      -0.0031      -0.0395       2.5790      17.3241     224.5267      11.5056      53.2995      -0.0058      -0.0001       0.0273       5.3717    2715.2227     888.8648     -17.7500    4378.0000
 2653.2840     152.3167    1170.2675    1950.0000    1516.6613    1934.9567       0.5168     216.0000       0.0792       0.0038      -0.0324       2.4639      18.8609     225.7361      19.0663      53.2995      -0.0017       0.0052       0.0330       5.4999    2703.4480     304.6482     -21.3750    4284.0000
 2653.4364     151.9049    1120.3691    1950.0000    1324.5044    1177.1906       0.8495     216.0000       0.0783       0.0028      -0.0334       2.4190      17.4518     226.1082      20.7515      53.2995      -0.0012       0.0051       0.0334       5.4949    2705.1526     276.3422     -18.0000    4259.0000
 2653.5888     150.3296    1069.2335    1950.0000    1326.2559    1211.1774       0.8256     216.0000       0.0738      -0.0020      -0.0385       2.3593      18.9693     227.0386      13.6034      53.2995       0.0001       0.0064       0.0351       5.3325    2713.4539     285.3411     -22.6875    4283.0000
 2653.7412     146.5562    1024.9998    1950.0000    1403.4663    1146.1876       0.8725     216.0000       0.0696      -0.0065      -0.0431       2.5929      19.1581     227.0386       4.5981      53.2995       0.0025       0.0086       0.0382       5.1877    2721.1965     549.3671     -21.1875    4301.0000
 2653.8936     140.5144     967.3987    1950.0000    1645.9056    1302.4021       0.7678     216.0000       0.0620      -0.0148      -0.0517       2.4227      18.8330     227.5968      -0.0970      53.2995       0.0079       0.0148       0.0455       5.0206    2735.2842     725.9247     -20.3125    4293.0000
 2654.0460     133.2128     876.6951    1950.0000     904.0682     867.3832       1.1529     216.0000       0.0581      -0.0190      -0.0560       2.1669      20.1337     228.1550      -1.6019      53.2995       0.0100       0.0167       0.0481       4.9775    2742.4270     751.0692     -20.3125    4378.0000
 2654.1984     125.9558     762.0496    1950.0000     832.8281     777.6146       1.2860     216.0000       0.0550      -0.0224      -0.0596       2.5474      19.5113     228.1550      -1.3237      53.2995       0.0130       0.0202       0.0522       4.9033    2748.3401     716.0107     -23.9375    4328.0000
 2654.3508     119.4983     650.1462    1950.0000     791.1420     778.8336       1.2840     216.0000       0.0610      -0.0159      -0.0529       2.6150      21.6792     228.1550      -2.6338      53.2995       0.0111       0.0179       0.0496       4.9317    2737.2244     604.0316     -19.3125    4292.0000
 2654.5032     113.8536     558.9280    1950.0000     709.3962     693.1812       1.4426     216.0000       0.0626      -0.0142      -0.0510       2.3926      23.0794     228.1550      -2.3069      53.2995       0.0096       0.0165       0.0477       4.9137    2734.2249     502.4939     -21.0625    4308.0000
 2654.6556     108.7000     491.7064    1950.0000     615.9567     604.3304       1.6547     216.0000       0.0670      -0.0094      -0.0461       2.2811      25.3338     228.1550      -4.1430      53.2995       0.0116       0.0189       0.0503       4.9216    2726.0186     499.6433     -17.5000    4319.0000
 2654.8080     103.8875     444.3605    1950.0000     590.1875     554.2292       1.8043     216.0000       0.0678      -0.0085      -0.0452       2.4676      23.7079     228.7132      -1.0016      53.2995       0.0080       0.0149       0.0456       4.8837    2724.5122     500.8759     -22.8750    4355.0000
 2654.9604      99.6280     411.6642    1950.0000     670.0198     585.2372       1.7087     216.0000       0.0684      -0.0079      -0.0445       2.4828      21.8741     228.7132      -0.6049      53.2995       0.0035       0.0097       0.0396       4.8771    2723.4373     607.5760     -18.3750    4359.0000
 2655.1128      96.3135     389.3345    1950.0000     803.8140     644.7490       1.5510     216.0000       0.0773       0.0018      -0.0345       2.2433      20.7037     229.5505       2.8656      53.2995      -0.0033       0.0019       0.0304       4.9522    2706.9636     700.3174     -19.0000    4305.0000
 2655.2652      94.2011     373.9270    1950.0000    1010.0790     718.0275       1.3927     216.0000       0.0722      -0.0037      -0.0402       2.6889      20.2642     230.5739      32.2301      53.2995      -0.0015       0.0053       0.0332       5.2710    2716.4023     669.0463     -20.5000    4327.0000
 2655.4176      93.2068     362.6468    1950.0000    1269.4440     805.9579       1.2408     216.0000       0.0671      -0.0093      -0.0460       2.5111      19.5055     232.2484      71.4295      53.2995      -0.0043       0.0023       0.0294       5.6702    2725.8994     618.8912     -24.5625    4333.0000
 2655.5700      92.9739     354.4086    1950.0000    1500.3263     897.5081       1.1142     216.0000       0.0581      -0.0190      -0.0561       2.5381      17.3230     237.8305     120.6548      53.2995      -0.0101      -0.0048       0.0214       6.0790    2742.4875     675.4748     -25.0000    4335.0000
 2655.7224      93.1534     351.8383    1950.0000    1537.3123    1102.5032       0.9070     216.0000       0.0645      -0.0121      -0.0489       2.2622      17.4373     239.3190     161.8438      53.2995      -0.0103      -0.0049       0.0212       6.3487    2730.6765     485.8166     -27.3125    4250.0000
 2655.8748      93.6324     361.1025    1950.0000    1508.6793    1132.1885       0.8832     216.0000       0.0732      -0.0027      -0.0391       2.3822      14.8320     243.0403     214.4947      53.2995      -0.0076      -0.0013       0.0250       6.6006    2714.5847     256.7878     -24.6875    4309.0000
 2656.0272      94.5043     391.2922    1950.0000    1461.8977    1210.6050       0.8260     216.0000       0.0765       0.0009      -0.0354       2.7780      15.0352     246.3895     260.1924      53.2995      -0.0081      -0.0019       0.0243       6.8041    2708.4302     162.4806     -26.8750    4302.0000
 2656.1796      95.7991     455.1238    1950.0000    1383.8129    1193.4102       0.8379     216.0000       0.0746      -0.0012      -0.0376       2.5246      15.4688     250.2039     290.4296      53.2995      -0.0075      -0.0011       0.0253       6.9332    2712.0144     190.1892     -34.5000    4350.0000
 2656.3320      97.2705     569.6901    1950.0000     826.5541     856.9071       1.1670     216.0000       0.0730      -0.0029      -0.0393       2.3162      18.3992     256.2511     304.8589      53.2995      -0.0093      -0.0035       0.0226       7.0008    2714.8770     298.3831     -20.5000    4331.0000
 2656.4844      98.4809     751.9103    1950.0000    1950.0000    1482.5450       0.6745     216.0000       0.0708      -0.0052      -0.0418       2.2892      18.1913     254.1113     319.8903      53.2995      -0.0095      -0.0036       0.0224       7.0397    2718.9705     523.4738     -27.8750    4365.0000
 2656.6368      99.0981     988.7128    1950.0000    1636.9828    1514.7852       0.6602     216.0000       0.0683      -0.0080      -0.0447       2.3384      16.6737     263.3217     331.6872      53.2995      -0.0101      -0.0038       0.0218       7.0578    2723.6787     471.8046     -26.3125    4364.0000
 2656.7892      99.0877    1184.0353    1950.0000    1910.9919    1828.0239       0.5470     216.0000       0.0616      -0.0153      -0.0522       2.7072      14.0722     254.3904     342.9580      53.4393      -0.0114      -0.0056       0.0199       7.0699    2736.0813     593.1266     -34.1875    4368.0000
 2656.9416      98.6081    1219.6227    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0556      -0.0217      -0.0588       2.6840      13.5495     257.5536     349.2768      53.4393      -0.0127      -0.0070       0.0181       7.0772    2747.0500     504.6361     -24.6875    4359.0000
 2657.0940      97.8104    1126.5627    1950.0000    1950.0000    1656.2023       0.6038     216.0000       0.0517      -0.0259      -0.0632       2.5386      13.3410     259.2281     358.1388      53.4393      -0.0119      -0.0057       0.0193       7.0941    2754.3311     340.7997     -24.9375    4338.0000
 2657.2464      96.7708    1021.3630    1950.0000    1937.3710    1881.0742       0.5316     216.0000       0.0496      -0.0282      -0.0656       2.4812      13.3410     258.5769     368.2916      53.2995      -0.0104      -0.0036       0.0215       7.1116    2758.1699     318.2532     -30.3750    4325.0000
 2657.3988      95.5685     971.0941    1950.0000    1950.0000    1888.9114       0.5294     216.0000       0.0474      -0.0305      -0.0680       2.5984      14.7502     266.1126     377.2946      53.5791      -0.0150      -0.0094       0.0150       7.1164    2762.2202     400.3453     -28.9375    4304.0000
 2657.5512      94.3306     996.2228    1950.0000    1950.0000    1826.4075       0.5475     216.0000       0.0507      -0.0270      -0.0644       2.4728      14.9586     263.3217     378.6469      53.5791      -0.0153      -0.0101       0.0145       7.0995    2756.2417     610.4363     -32.0625    4318.0000
 2657.7036      93.1804    1102.0225    1950.0000    1950.0000    1754.1609       0.5701     216.0000       0.0550      -0.0223      -0.0595       2.4083      16.1229     262.0192     377.8358      53.5791      -0.0113      -0.0052       0.0201       7.0574    2748.2085     613.3932     -40.7500    4328.0000
 2657.8560      92.1843    1276.3827    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0540      -0.0235      -0.0607       2.6107      15.2507     257.5536     373.9524      53.5791      -0.0092      -0.0032       0.0228       6.9744    2750.1467     718.0976     -34.5000    4308.0000
 2658.0084      91.3619    1469.7546    1950.0000    1950.0000    1739.7938       0.5748     216.0000       0.0479      -0.0301      -0.0676       2.5342      17.5270     253.2740     358.7856      53.5791      -0.0076      -0.0019       0.0249       6.8343    2761.4741     882.8902     -34.5000    4318.0000
 2658.1608      90.7192    1579.1641    1950.0000    1950.0000    1254.9927       0.7968     216.0000       0.0384      -0.0403      -0.0782       2.6945      19.4642     259.2281     332.1102      53.5791      -0.0068      -0.0012       0.0259       6.6541    2778.9521     722.4004     -34.5000    4324.0000
 2658.3132      90.2650    1517.8513    1950.0000    1950.0000    1208.7935       0.8273     216.0000       0.0382      -0.0405      -0.0784       2.5387      21.2210     254.2043     294.0481      53.5791      -0.0017       0.0046       0.0329       6.4676    2779.2961     679.2287     -35.0625    4302.0000
 2658.4656      89.9905    1310.7972    1950.0000    1950.0000    1184.6683       0.8441     216.0000       0.0395      -0.0391      -0.0769       2.5860      19.5534     250.2039     261.7319      53.5791       0.0050       0.0128       0.0420       6.3088    2776.8691     635.1968     -34.5000    4298.0000
 2658.6180      89.8767    1063.8317    1950.0000    1950.0000    1331.9622       0.7508     216.0000       0.0464      -0.0316      -0.0691       2.4735      21.5373     251.8785     230.6814      53.5791      -0.0007       0.0050       0.0339       6.1730    2764.0676     484.3443     -39.1250    4305.0000
 2658.7704      89.9185     865.2669    1950.0000    1950.0000    1114.8157       0.8970     216.0000       0.0540      -0.0234      -0.0606       2.3386      23.7963     249.1805     206.0509      53.5791       0.0048       0.0115       0.0414       6.0669    2750.0354     420.4607     -37.4375    4307.0000
 2658.9228      90.0915     738.6298    1950.0000    1725.3389     905.4286       1.1044     216.0000       0.0638      -0.0128      -0.0496       2.6330      25.6807     249.3666     186.4932      53.5791       0.0097       0.0175       0.0480       6.0009    2731.9060     370.5484     -34.2500    4305.0000
 2659.0752      90.3773     678.2256    1950.0000    1524.8026     971.2935       1.0296     216.0000       0.0684      -0.0079      -0.0446       2.6719      22.7756     247.6920     180.7075      53.5791       0.0008       0.0068       0.0360       5.9647    2723.5320     537.2738     -30.8125    4289.0000
 2659.2276      90.8335     673.3776    1950.0000    1314.3014     903.5894       1.1067     216.0000       0.0636      -0.0131      -0.0499       2.5661      20.7090     245.4592     185.9584      53.5791      -0.0037       0.0014       0.0298       5.9424    2732.3489     510.9738     -32.3750    4300.0000
 2659.3800      91.6032     715.2610    1950.0000    1392.2443    1084.2855       0.9223     216.0000       0.0650      -0.0115      -0.0483       2.6266      22.4433     251.3203     182.5225      53.5791      -0.0003       0.0059       0.0346       5.9163    2729.7000     476.7289     -36.5625    4334.0000
 2659.5324      92.7808     794.3178    1950.0000    1059.3990     750.2253       1.3329     216.0000       0.0663      -0.0101      -0.0469       2.5280      24.9241     250.2039     174.0603      53.5791       0.0042       0.0110       0.0407       5.9080    2727.3367     350.9923     -27.6875    4295.0000
 2659.6848      94.1717     888.1385    1950.0000     647.4006     507.8327       1.9692     216.0000       0.0681      -0.0082      -0.0449       2.7459      26.5571     251.3203     168.8738      53.5791       0.0067       0.0137       0.0440       5.9431    2724.0383     384.8609     -35.3125    4318.0000
 2659.8372      95.2038     944.8489    1950.0000     958.3254     658.9374       1.5176     216.0000       0.0571      -0.0201      -0.0572       2.8418      27.0990     253.2740     183.1021      53.5791       0.0053       0.0119       0.0421       6.0249    2744.4487     499.3361     -30.3750    4311.0000
 2659.9896      95.2187     906.9246    1950.0000    1221.8048     802.0036       1.2469     216.0000       0.0445      -0.0338      -0.0714       2.6604      28.6727     254.2043     207.1106      53.5791       0.0048       0.0115       0.0414       6.1276    2767.7620     737.1848     -34.8750    4304.0000
 2660.1420      94.0181     785.7000    1950.0000    1950.0000     910.1605       1.0987     216.0000       0.0304      -0.0490      -0.0871       2.6250      29.1063     249.3666     237.8724      53.5791       0.0038       0.0103       0.0400       6.2339    2793.7219     740.6780     -34.5000    4356.0000
 2660.2944      92.1277     653.0665    1950.0000    1449.9165     595.2863       1.6799     216.0000       0.0244      -0.0555      -0.0939       2.5897      28.0223     251.5994     268.1289      53.5791      -0.0000       0.0059       0.0349       6.3611    2804.8855     785.7807     -34.6875    4329.0000
 2660.4468      90.4417     557.9258    1950.0000     930.3354     366.0966       2.7315     216.0000       0.0286      -0.0509      -0.0891       2.6693      26.7739     249.6457     293.2687      53.5791       0.0012       0.0075       0.0366       6.5165    2797.0962     859.2932     -31.1875    4358.0000
 2660.5992      89.6423     509.6732    1950.0000     969.2490     344.2160       2.9052     216.0000       0.0424      -0.0360      -0.0736       2.5655      26.6655     252.9949     299.8385      53.5791       0.0032       0.0102       0.0394       6.6357    2771.4929    1003.1161     -32.9375    4354.0000
 2660.7516      89.8553     500.7833    1950.0000    1165.3729     525.0797       1.9045     216.0000       0.0458      -0.0324      -0.0699       2.7257      27.4242     250.7621     296.3638      53.5791      -0.0001       0.0058       0.0348       6.6685    2765.3567    1055.6361     -27.0000    4318.0000
 2660.9040      90.6767     518.2098    1950.0000    1196.0718     546.0018       1.8315     216.0000       0.0503      -0.0274      -0.0648       2.5947      28.2815     256.6232     273.1760      53.5791       0.0009       0.0071       0.0362       6.6111    2756.8689     929.1259     -34.4375    4326.0000
 2661.0564      91.4003     544.5560    1950.0000    1108.8458     532.0270       1.8796     216.0000       0.0548      -0.0225      -0.0597       2.7954      28.2256     254.5765     249.2294      53.5791       0.0018       0.0080       0.0373       6.5397    2748.5605     581.8553     -29.6875    4318.0000
 2661.2088      91.3465     560.0617    1950.0000    1814.8699     539.1849       1.8547     216.0000       0.0626      -0.0142      -0.0511       2.6090      27.0332     258.0187     235.5609      53.5791       0.0034       0.0100       0.0396       6.5342    2734.2466     519.1568     -29.4375    4310.0000
 2661.3612      90.1865     556.8198    1950.0000    1490.1266     398.0000       2.5126     216.0000       0.0633      -0.0134      -0.0502       2.4243      26.1760     254.6695     243.5007      53.5791       0.0032       0.0096       0.0392       6.6126    2732.8799     609.9618     -34.1875    4324.0000
 2661.5136      88.0408     546.2464    1950.0000    1409.8063     298.0219       3.3555     216.0000       0.0597      -0.0173      -0.0543       2.7432      24.0571     261.6470     264.0326      53.5791       0.0009       0.0074       0.0363       6.7297    2739.5369    1434.3623     -29.1250    4279.0000
 2661.6660      85.3087     546.6222    1950.0000    1430.0983     230.0559       4.3468     216.0000       0.0580      -0.0191      -0.0562       2.7188      23.5152     259.0421     278.7831      53.5791      -0.0013       0.0054       0.0334       6.8176    2742.7029    1717.3838     -34.5000    4274.0000
 2661.8184      82.4029     570.2340    1950.0000    1628.0126     190.3943       5.2523     216.0000       0.0501      -0.0277      -0.0651       2.7015      20.9072     262.4843     285.3186      53.5791      -0.0056       0.0009       0.0278       6.8415    2757.3928    1030.6614     -31.9375    4331.0000
 2661.9708      79.5594     619.0952    1840.0645    1641.3610     201.5478       4.9616     216.0000       0.0431      -0.0353      -0.0729       2.7463      19.9835     263.3217     282.5916      53.5791      -0.0085      -0.0024       0.0238       6.8363    2770.3125     509.8084     -34.4375    4297.0000
 2662.1232      76.6132     665.7887    1871.9244    1859.6750     231.7761       4.3145     216.0000       0.0394      -0.0393      -0.0770       2.8144      17.3819     263.8798     280.9088      53.5791      -0.0079      -0.0018       0.0246       6.8514    2777.1206     554.8821     -32.0625    4331.0000
 2662.2756      73.2279     639.3497    1900.3805    1151.3430     235.5609       4.2452     216.0000       0.0402      -0.0383      -0.0761       2.6611      16.4074     258.8560     287.0712      53.5791      -0.0073      -0.0012       0.0254       6.9101    2775.5581     868.1112     -34.5000    4355.0000
 2662.4280      68.5205     475.9605    1220.2246    1816.5834     391.8988       2.5517     216.0000       0.0378      -0.0410      -0.0788       2.7486      16.1455     252.3437     300.0500      53.5791      -0.0103      -0.0051       0.0212       6.9704    2780.0273    2823.9434     -33.5000    4293.0000
 2662.5804      60.8641     309.9887     765.1479    1702.9989     421.5889       2.3720     216.0000       0.0464      -0.0317      -0.0692       2.7082      16.2488     260.9027     305.6641      53.5791      -0.0116      -0.0057       0.0196       7.0220    2764.2268    1600.9150     -34.9375    4336.0000
 2662.7328      52.8549     178.8209     576.3364    1445.1118     433.9191       2.3046     216.0000       0.0602      -0.0168      -0.0537       2.6558      16.1459     263.5077     303.9296      53.5791      -0.0111      -0.0050       0.0203       7.0625    2738.6653    1141.6489     -34.5000    4369.0000
 2662.8852      43.5768     116.1305     214.4083     975.2833     262.4178       3.8107     216.0000       0.0806       0.0053      -0.0309       2.5601      17.7299     264.9962     299.7336      53.5791      -0.0145      -0.0099       0.0154       7.1168    2700.9736     746.8285     -37.3125    4336.0000
 2663.0376      35.8026      70.3361     195.3988     615.5928     271.7863       3.6794     216.0000       0.1064       0.0332      -0.0019       2.5194      19.5708     262.4843     301.2874      53.5791      -0.0147      -0.0124       0.0145       7.2017    2653.1792     287.2956     -34.5000    4366.0000
 2663.1900      31.7830      66.5828     149.2296     391.3339     304.9941       3.2788     216.0000       0.1883       0.1218       0.0899       2.8575      22.9310     268.6245     275.4702      53.5791      -0.0024       0.0018       0.0313       7.3782    2501.7358      79.7149     -39.5000    4308.0000
 2663.3424      25.0872      33.4270     120.6220     290.4882     282.8939       3.5349     216.0000       0.2763       0.2171       0.1886       2.5625      26.2145     271.6946     243.9261      53.5791       0.0291       0.0408       0.0738       7.5730    2338.7847       7.2679     -34.5000    4304.0000
 2663.4948      20.2701      24.7300      54.4844     198.7816     276.5280       3.6163     216.0000       0.2836       0.2249       0.1967       2.4674      31.0810     276.9976     242.3625      53.5791       0.0536       0.0697       0.1052       7.6171    2325.3689       5.8436     -36.8750    4334.0000
 2663.6472      31.7212      38.9826     100.8948     173.7565     279.4471       3.5785     216.0000       0.1904       0.1241       0.0923       2.7672      27.1738     257.7396     277.8239      53.5791       0.0873       0.1086       0.1470       7.4207    2497.7747       6.7183     -37.3125    4320.0000
 2663.7996      46.2700      69.3192     185.5981    1406.9679     616.3974       1.6223     216.0000       0.0839       0.0089      -0.0272       2.8177      20.6805     254.0183     315.4232      53.5791      -0.0094      -0.0061       0.0217       7.1613    2694.8516      56.5232     -39.3750    4334.0000
 2663.9520      68.0482     129.4472     806.2454     637.3633    1124.8562       0.8890     216.0000       0.0416      -0.0368      -0.0745       2.6937      13.4557     256.8093     319.6430      53.5791      -0.0310      -0.0313      -0.0085       6.9952    2773.0068    1412.1632     -41.6250    4372.0000
 2664.1044      82.6612     242.7516    1950.0000    1838.6752    1950.0000       0.5013     216.0000       0.0358      -0.0432      -0.0811       2.9174      13.2438     254.9486     319.6902      53.5791      -0.0228      -0.0182       0.0042       6.9421    2783.8486     909.5936     -40.0625    4365.0000
 2664.2568      81.8694     403.3706    1950.0000    1950.0000    1087.5948       0.9195     216.0000       0.0352      -0.0438      -0.0817       2.6298      14.1109     263.8798     321.8210      53.5791      -0.0183      -0.0120       0.0108       6.9159    2784.8547     897.5944     -44.1875    4382.0000
 2664.4092      85.1087     535.5949    1930.8057    1931.2599     441.6602       2.2642     216.0000       0.0361      -0.0428      -0.0808       2.6274      14.9532     270.7643     320.4944      53.5791      -0.0194      -0.0136       0.0092       6.8976    2783.2395    1129.4661     -44.2500    4358.0000
 2664.5616      83.7028     553.5101    1717.0979    1558.5425     256.7709       3.8945     216.0000       0.0342      -0.0448      -0.0828       2.8146      15.0675     270.3922     319.0465      53.5791      -0.0209      -0.0158       0.0070       6.8907    2786.6736    1774.0104     -44.2500    4360.0000
 2664.7140      83.8664     515.7747    1943.8973    1485.2747     189.0701       5.2890     216.0000       0.0301      -0.0493      -0.0874       2.9032      15.5011     271.3225     321.4402      53.5791      -0.0182      -0.0127       0.0107       6.8983    2794.2280    2390.6074     -44.2500    4423.0000
 2664.8664      85.5315     496.4702    1950.0000    1410.9199     163.5829       6.1131     216.0000       0.0313      -0.0480      -0.0861       2.5008      15.9401     268.0663     328.1066      53.5791      -0.0163      -0.0105       0.0133       6.9126    2792.0244    2449.0049     -49.1875    4359.0000
 2665.0188      88.0819     520.3325    1950.0000    1073.4935     230.6069       4.3364     216.0000       0.0345      -0.0445      -0.0825       2.6649      17.7628     266.6708     336.2551      53.5791      -0.0119      -0.0058       0.0193       6.9327    2786.1189    1580.5692     -44.2500    4417.0000
 2665.1712      90.5884     586.8806    1950.0000    1107.1079     330.6469       3.0244     216.0000       0.0336      -0.0455      -0.0835       2.9681      20.5811     264.4380     333.2062      53.5791      -0.0087      -0.0025       0.0236       6.9210    2787.8521    1207.6846     -53.3125    4421.0000
 2665.3236      92.3109     663.1237    1950.0000    1226.1372     414.0074       2.4154     216.0000       0.0261      -0.0536      -0.0919       2.8153      24.7863     262.7634     321.2068      53.5791      -0.0058      -0.0001       0.0273       6.8836    2801.6897    1263.4772     -49.6875    4405.0000
 2665.4760      92.8513     681.0673    1950.0000     942.3879     422.9487       2.3644     216.0000       0.0252      -0.0546      -0.0929       2.6882      27.2936     256.2511     302.7310      53.5791       0.0006       0.0074       0.0360       6.8558    2803.3157    1480.1544     -51.5000    4392.0000
 2665.6284      92.3709     616.8425    1950.0000    1115.1895     461.9160       2.1649     216.0000       0.0334      -0.0457      -0.0837       2.5976      27.3938     254.3904     294.2910      53.5791       0.0032       0.0106       0.0396       6.8979    2788.1582    1562.8251     -51.7500    4351.0000
 2665.7808      91.3938     533.2703    1950.0000     938.9076     479.0877       2.0873     216.0000       0.0371      -0.0418      -0.0796       2.6319      23.9473     263.8798     307.9131      53.5791      -0.0031       0.0034       0.0310       7.0090    2781.4148    1624.1097     -53.1875    4393.0000
 2665.9332      90.5691     484.3138    1950.0000     845.1960     453.0876       2.2071     216.0000       0.0394      -0.0393      -0.0771       2.4944      19.1133     264.9962     332.4685      53.5791      -0.0079      -0.0015       0.0247       7.1537    2777.1555    1496.4949     -54.0000    4354.0000
 2666.0856      90.4487     487.7299    1950.0000     949.7023     488.0078       2.0491     216.0000       0.0462      -0.0319      -0.0694       2.6898      16.2978     266.1126     360.7175      53.5791      -0.0130      -0.0075       0.0177       7.2916    2764.5649    1112.7101     -54.0000    4361.0000
 2666.2380      91.2724     551.9023    1950.0000     616.7714     265.2607       3.7699     216.0000       0.0634      -0.0133      -0.0501       3.0469      13.6963     270.2061     384.5150      53.5791      -0.0173      -0.0123       0.0118       7.4125    2732.6965     694.5308     -56.1250    4402.0000
 2666.3904      92.8515     692.5360    1950.0000    1950.0000     617.8060       1.6186     216.0000       0.0803       0.0050      -0.0312       2.7799      13.3234     268.7176     402.7963      53.5791      -0.0159      -0.0104       0.0138       7.4963    2701.4233     429.2254     -57.0625    4409.0000
 2666.5428      94.5902     923.8997    1950.0000    1724.8484     664.3130       1.5053     216.0000       0.0795       0.0041      -0.0321       2.8702      12.5700     273.1832     416.6546      53.5791      -0.0116      -0.0045       0.0200       7.5176    2702.9053     298.6236     -59.7500    4314.0000
 2666.6952      95.7639    1214.8341    1950.0000    1904.2396    1148.2322       0.8709     216.0000       0.0704      -0.0057      -0.0423       2.9173      12.8267     271.9737     416.9280      53.5791      -0.0138      -0.0080       0.0166       7.4832    2719.7993     233.5424     -55.9375    4398.0000
 2666.8476      96.0323    1455.8114    1950.0000    1950.0000    1393.1278       0.7178     216.0000       0.0615      -0.0153      -0.0523       2.8747      14.4565     272.8111     412.6162      53.5791      -0.0144      -0.0089       0.0158       7.4374    2736.2378     277.8018     -63.7500    4375.0000
 2667.0000      95.6843    1562.4849    1950.0000    1950.0000    1576.8831       0.6342     216.0000       0.0626      -0.0142      -0.0510       2.6640      15.2099     268.6245     408.5543      53.5791      -0.0110      -0.0047       0.0206       7.4125    2734.2153     372.5507     -61.1875    4349.0000
 2667.1524      95.3050    1578.7449    1950.0000    1930.1665    1596.3253       0.6264     216.0000       0.0665      -0.0100      -0.0467       2.7478      15.4173     270.9504     411.5212      53.5791      -0.0131      -0.0074       0.0176       7.4209    2727.0581     433.0913     -63.7500    4367.0000
 2667.3048      95.2682    1569.6771    1950.0000    1950.0000    1815.3855       0.5508     216.0000       0.0721      -0.0039      -0.0404       2.4582      15.7425     270.3922     409.8558      53.5791      -0.0114      -0.0053       0.0199       7.4228    2716.6953     329.4482     -63.5625    4374.0000
 2667.4572      95.5254    1586.0944    1950.0000    1950.0000    1869.2397       0.5350     216.0000       0.0786       0.0032      -0.0331       2.6464      14.8762     273.7414     399.6227      53.5791      -0.0143      -0.0092       0.0158       7.4135    2704.5674     201.2800     -62.8125    4406.0000
 2667.6096      95.8141    1641.4960    1950.0000    1950.0000    1950.0000       0.5022     216.0000       0.0766       0.0010      -0.0353       2.8104      14.8457     270.2991     393.9009      53.5791      -0.0088      -0.0021       0.0235       7.3808    2708.2144     192.2562     -63.6250    4440.0000
 2667.7620      96.0178    1710.6377    1950.0000    1950.0000    1873.9716       0.5336     216.0000       0.0723      -0.0036      -0.0401       2.9975      14.1901     268.9037     393.5301      53.5791      -0.0087      -0.0025       0.0235       7.3571    2716.2368     218.7249     -63.7500    4398.0000
 2667.9144      96.2570    1766.9709    1950.0000    1950.0000    1506.5043       0.6638     216.0000       0.0643      -0.0123      -0.0492       2.9449      15.0619     275.8812     399.8826      53.5791      -0.0095      -0.0035       0.0225       7.3400    2731.1152     380.6918     -63.7500    4381.0000
 2668.0668      96.6349    1780.9973    1950.0000    1950.0000    1294.7766       0.7723     216.0000       0.0615      -0.0153      -0.0523       2.7339      14.9906     269.4618     395.6478      53.5791      -0.0055       0.0015       0.0280       7.3251    2736.2148     510.3916     -63.7500    4402.0000
 2668.2192      96.9541    1732.7220    1950.0000    1907.4413    1039.4797       0.9620     216.0000       0.0543      -0.0232      -0.0604       2.6995      13.4746     265.2753     391.8474      53.5791      -0.0103      -0.0045       0.0213       7.2978    2749.6350     676.9037     -66.6250    4385.0000
 2668.3716      96.8273    1632.2607    1950.0000    1681.5461     800.5087       1.2492     216.0000       0.0498      -0.0280      -0.0654       2.9350      14.0165     272.9971     386.1210      53.5791      -0.0125      -0.0068       0.0184       7.2701    2757.8501     764.9805     -63.7500    4407.0000
 2668.5240      96.1048    1517.0419    1950.0000    1709.2583     678.9095       1.4730     216.0000       0.0455      -0.0327      -0.0702       2.7589      14.8253     270.5782     386.5216      53.5791      -0.0108      -0.0047       0.0207       7.2417    2765.8447     761.3145     -65.8125    4390.0000
 2668.6764      95.0692    1429.7080    1950.0000    1334.5179     594.6166       1.6818     216.0000       0.0403      -0.0383      -0.0761       2.5586      16.4549     267.2290     384.9406      53.5791      -0.0124      -0.0070       0.0184       7.2034    2775.5071     641.7633     -63.7500    4348.0000
 2668.8288      94.1128    1387.1282    1950.0000    1767.6447     692.6688       1.4437     216.0000       0.0350      -0.0440      -0.0820       2.8796      15.1624     267.2290     376.8406      53.5791      -0.0098      -0.0035       0.0221       7.1456    2785.2244     846.1498     -65.6250    4429.0000
 2668.9812      93.3132    1384.2802    1950.0000    1713.7704     732.2499       1.3657     216.0000       0.0352      -0.0438      -0.0817       2.8134      16.3761     266.2987     363.6968      53.5791      -0.0109      -0.0047       0.0207       7.1052    2784.8228    1321.3092     -65.9375    4343.0000
 2669.1336      92.3756    1375.8398    1950.0000    1950.0000     867.7738       1.1524     216.0000       0.0482      -0.0297      -0.0671       2.6921      16.5929     265.7405     349.2475      53.5791      -0.0149      -0.0098       0.0150       7.1058    2760.7903    2066.4968     -63.7500    4399.0000
 2669.2860      90.9938    1303.6917    1950.0000    1950.0000    1136.0236       0.8803     216.0000       0.0558      -0.0215      -0.0587       2.7761      17.7770     267.5081     350.9745      53.5791      -0.0140      -0.0085       0.0163       7.1339    2746.8494     891.7862     -63.7500    4394.0000
 2669.4384      89.2658    1163.5344    1950.0000    1950.0000    1670.1140       0.5988     216.0000       0.0531      -0.0244      -0.0617       2.6075      18.4871     268.1594     361.8653      53.5791      -0.0123      -0.0065       0.0187       7.1457    2751.7773     613.9927     -64.0000    4356.0000
 2669.5908      87.6806    1015.6024    1950.0000    1950.0000    1763.1660       0.5672     216.0000       0.0464      -0.0316      -0.0691       2.7060      18.9207     265.5544     368.1207      53.5791      -0.0072      -0.0002       0.0258       7.1241    2764.0942     487.9524     -63.7500    4380.0000
 2669.7432      86.7375     912.7885    1950.0000    1950.0000    1659.0570       0.6028     216.0000       0.0431      -0.0353      -0.0729       2.8462      18.8123     265.2753     364.9058      53.5791      -0.0070       0.0001       0.0261       7.0926    2770.2986     631.9780     -63.7500    4396.0000
 2669.8956      86.6230     873.2610    1950.0000    1950.0000    1844.4745       0.5422     216.0000       0.0442      -0.0340      -0.0716       2.5145      19.5302     264.0659     354.3844      53.5791      -0.0103      -0.0045       0.0214       7.0652    2768.1763     765.6780     -63.7500    4351.0000
 2670.0480      87.0323     886.5012    1950.0000    1950.0000    1914.5691       0.5223     216.0000       0.0451      -0.0330      -0.0706       2.8415      19.9574     262.0192     344.5175      53.5791      -0.0089      -0.0026       0.0233       7.0475    2766.5024    1006.1013     -63.7500    4376.0000
 2670.2004      87.2888     914.2951    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0497      -0.0281      -0.0655       2.6892      20.1108     263.1356     327.7059      53.5791      -0.0146      -0.0103       0.0151       7.0152    2758.1262    1159.1122     -63.7500    4380.0000
 2670.3528      86.8204     905.7304    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0543      -0.0231      -0.0604       2.7354      18.4660     258.5769     309.5629      53.5791      -0.0087      -0.0024       0.0236       6.9705    2749.5811    1597.8430     -63.7500    4373.0000
 2670.5052      85.6790     846.3788    1950.0000    1950.0000    1950.0000       0.5012     216.0000       0.0567      -0.0206      -0.0577       2.7707      18.6826     258.2978     297.8706      53.5791      -0.0069      -0.0006       0.0260       6.9180    2745.1487    2015.5006     -63.7500    4380.0000
 2670.6576      84.5623     778.8795    1950.0000    1950.0000    1666.0731       0.6002     216.0000       0.0697      -0.0064      -0.0430       2.6347      19.3963     264.2520     290.8697      53.5791      -0.0085      -0.0026       0.0238       6.9036    2721.0142    1183.3802     -63.7500    4370.0000
 2670.8100      84.3028     749.4405    1950.0000    1950.0000    1499.7457       0.6668     216.0000       0.0797       0.0044      -0.0318       2.9211      20.3299     266.6708     295.5773      53.5791      -0.0042       0.0026       0.0296       6.9412    2702.5237     491.1114     -63.7500    4421.0000
 2670.9624      85.3149     781.7565    1950.0000    1950.0000    1501.9266       0.6658     216.0000       0.0798       0.0045      -0.0317       2.9052      19.9029     267.9733     306.3760      53.5791      -0.0043       0.0025       0.0295       7.0020    2702.2949     337.8718     -63.1875    4357.0000
 2671.1148      87.3242     885.1154    1950.0000    1950.0000    1231.4117       0.8121     216.0000       0.0597      -0.0172      -0.0542       2.6326      21.2037     263.3217     326.7667      53.5791      -0.0091      -0.0040       0.0227       7.0618    2739.4749     409.9444     -63.6875    4382.0000
 2671.2672      89.4673    1053.5287    1950.0000    1950.0000    1429.0873       0.6997     216.0000       0.0480      -0.0299      -0.0674       2.7694      19.0654     264.4380     336.1828      53.5791      -0.0086      -0.0027       0.0236       7.1028    2761.1697     793.9642     -63.3125    4325.0000
 2671.4196      90.8251    1247.8451    1950.0000    1950.0000    1231.3499       0.8121     216.0000       0.0496      -0.0282      -0.0656       2.6758      17.6562     263.1356     336.5090      53.5791      -0.0058       0.0015       0.0277       7.1573    2758.2795    1235.9470     -63.0000    4377.0000
 2671.5720      91.0299    1390.6891    1950.0000    1950.0000    1434.8427       0.6969     216.0000       0.0510      -0.0267      -0.0640       2.5741      15.9219     264.2520     334.3306      53.5791      -0.0134      -0.0081       0.0171       7.2015    2755.6638    1099.3214     -63.0000    4362.0000
 2671.7244      90.4880    1445.4202    1950.0000    1950.0000    1239.2765       0.8069     216.0000       0.0468      -0.0312      -0.0687       2.6438      17.1399     268.9037     339.5583      53.5791      -0.0119      -0.0061       0.0192       7.2302    2763.4250    1012.5496     -63.7500    4361.0000
 2671.8768      90.0258    1459.7422    1950.0000    1950.0000    1007.7924       0.9923     216.0000       0.0443      -0.0339      -0.0715       2.5889      17.2483     264.4380     358.8503      53.5791      -0.0099      -0.0038       0.0219       7.2831    2767.9824    1202.9601     -63.5000    4358.0000
 2672.0292      90.3159    1492.1586    1950.0000    1950.0000     885.3298       1.1295     216.0000       0.0539      -0.0236      -0.0608       2.5317      15.1888     266.1126     387.4807      53.5791      -0.0118      -0.0060       0.0194       7.3750    2750.2998     767.9105     -63.6875    4349.0000
 2672.1816      91.6204    1564.9176    1950.0000    1950.0000    1201.0338       0.8326     216.0000       0.0648      -0.0117      -0.0485       2.5855      14.6866     268.7176     416.8491      53.5791      -0.0139      -0.0081       0.0166       7.4847    2730.0588     421.3019     -63.3750    4326.0000
 2672.3340      93.7374    1675.9832    1950.0000    1950.0000    1273.3043       0.7854     216.0000       0.0653      -0.0112      -0.0480       2.7148      15.1202     268.1594     428.8349      53.5791      -0.0122      -0.0058       0.0190       7.5311    2729.1716     336.0374     -62.3750    4393.0000
 2672.4864      96.0171    1797.2655    1950.0000    1950.0000    1365.7235       0.7322     216.0000       0.0580      -0.0192      -0.0562       2.8272      16.0812     270.2991     418.6003      53.5791      -0.0160      -0.0105       0.0137       7.5017    2742.7661     387.1542     -63.7500    4367.0000
 2672.6388      97.6265    1895.3302    1950.0000    1950.0000    1307.5785       0.7648     216.0000       0.0544      -0.0230      -0.0602       2.6360      15.2693     271.1364     398.2181      53.5791      -0.0136      -0.0071       0.0172       7.4406    2749.3362     633.0638     -61.5000    4380.0000
 2672.7912      97.8489    1940.6987    1950.0000    1900.3552    1113.9893       0.8977     216.0000       0.0598      -0.0172      -0.0542       2.4864      14.5060     269.8340     379.5147      53.5791      -0.0152      -0.0089       0.0150       7.4008    2739.4136     694.1828     -63.7500    4341.0000
 2672.9436      96.4248    1878.1523    1950.0000    1798.0182     896.3098       1.1157     216.0000       0.0578      -0.0193      -0.0564       2.4359      13.8964     271.9737     372.6172      53.5791      -0.0206      -0.0160       0.0072       7.3934    2743.0083     506.1431     -63.7500    4343.0000
 2673.0960      93.5483    1686.9894    1950.0000    1686.2413     686.7178       1.4562     216.0000       0.0462      -0.0319      -0.0694       2.6283      13.5712     271.1364     369.0116      53.5791      -0.0142      -0.0074       0.0165       7.3755    2764.5359     533.8241     -63.7500    4325.0000
 2673.2484      89.6938    1371.4725    1950.0000    1394.1130     651.0054       1.5361     216.0000       0.0358      -0.0431      -0.0810       2.6701      14.7129     270.0200     373.4443      53.5791      -0.0162      -0.0108       0.0133       7.3667    2783.7209     780.8286     -63.7500    4349.0000
 2673.4008      85.4672    1012.8712    1950.0000    1255.5145     484.5448       2.0638     216.0000       0.0426      -0.0358      -0.0735       2.7151      15.7650     263.3217     380.9977      53.5791      -0.0184      -0.0151       0.0098       7.3893    2771.1990     820.3246     -63.7500    4375.0000
 2673.5532      80.5882     706.8466    1950.0000    1426.6238     525.1838       1.9041     216.0000       0.0636      -0.0130      -0.0499       2.6906      18.4750     270.3922     392.1869      53.5791      -0.0120      -0.0077       0.0187       7.4567    2732.3049     543.3362     -63.7500    4367.0000
 2673.7056      78.3554     486.2738    1654.4033     805.3039     450.0570       2.2219     216.0000       0.0838       0.0088      -0.0273       2.3746      23.0567     271.5086     391.8350      53.5791       0.0056       0.0140       0.0429       7.5076    2694.9956      98.7382     -66.3750    4416.0000
 2673.8580      74.9384     346.8404     970.1747     273.2242     206.0387       4.8535     216.0000       0.0784       0.0029      -0.0333       2.3931      29.1208     265.5544     394.1378      53.5791       0.0200       0.0312       0.0622       7.4974    2705.0027      71.0323     -64.8750    4390.0000
 2674.0104      72.1079     285.4762     670.7418     190.0763     129.7921       7.7046     216.0000       0.0528      -0.0247      -0.0620       2.3790      29.9865     269.2758     399.7820      53.5791       0.0112       0.0211       0.0506       7.4542    2752.3132      72.6200     -63.7500    4322.0000
 2674.1628      82.4757     422.6537    1253.4413     762.7540     553.1936       1.8077     216.0000       0.0338      -0.0454      -0.0834       2.3903      27.3028     268.7176     411.1128      53.5791      -0.0143      -0.0109       0.0153       7.4470    2787.5518     313.8041     -63.7500    4364.0000
 2674.3152      87.5488     573.1885    1950.0000    1336.3276     900.5862       1.1104     216.0000       0.0331      -0.0460      -0.0841       2.5413      21.9079     270.5782     423.2278      53.5791      -0.0150      -0.0105       0.0147       7.4779    2788.6868     517.8662     -64.0625    4378.0000
 2674.4676      90.7763     811.6634    1950.0000    1950.0000    1694.0319       0.5903     216.0000       0.0522      -0.0254      -0.0627       2.5267      20.6086     273.9275     426.4197      53.5791      -0.0086      -0.0017       0.0239       7.5353    2753.4724     248.7218     -65.3125    4392.0000
 2674.6200      91.8607    1133.3586    1950.0000    1950.0000    1655.8804       0.6039     216.0000       0.0673      -0.0091      -0.0458       2.6059      17.7903     268.6245     421.2756      53.5791      -0.0108      -0.0045       0.0208       7.5515    2725.5637     159.0356     -66.3750    4433.0000
 2674.7724      91.8819    1486.8375    1950.0000    1950.0000    1562.1213       0.6402     216.0000       0.0714      -0.0047      -0.0412       2.7029      17.4913     269.8340     412.6425      53.5791      -0.0144      -0.0087       0.0159       7.5316    2717.9800     169.5514     -68.5000    4400.0000
 2674.9248      91.9323    1768.0784    1950.0000    1950.0000    1417.9509       0.7052     216.0000       0.0695      -0.0067      -0.0433       2.7248      14.7814     271.3225     400.6851      53.5791      -0.0155      -0.0102       0.0143       7.4738    2721.4128     262.2458     -70.1250    4461.0000
 2675.0772      92.4899    1932.9244    1950.0000    1950.0000    1330.0848       0.7518     216.0000       0.0575      -0.0196      -0.0567       2.4131      15.7017     271.4155     398.8626      53.5791      -0.0115      -0.0052       0.0199       7.3981    2743.5747     452.6034     -70.7500    4337.0000
 2675.2296      93.3929    1950.0000    1950.0000    1950.0000    1255.0300       0.7968     216.0000       0.0565      -0.0208      -0.0579       2.3574      15.3370     265.5544     386.7948      53.5791      -0.0107      -0.0048       0.0208       7.3375    2745.5627     480.5009     -70.3125    4367.0000
 2675.3820      94.1583    1950.0000    1950.0000    1950.0000    1196.3866       0.8359     216.0000       0.0571      -0.0201      -0.0572       2.4204      16.3948     272.4389     372.8261      53.5791      -0.0141      -0.0089       0.0161       7.2865    2744.3091     431.4942     -72.6875    4402.0000
 2675.5344      94.3508    1912.3181    1950.0000    1950.0000    1143.6655       0.8744     216.0000       0.0621      -0.0147      -0.0516       2.6217      17.2088     270.5782     354.3670      53.5791      -0.0122      -0.0060       0.0189       7.2514    2735.1267     412.7453     -71.5625    4302.0000
 2675.6868      93.8293    1819.8925    1950.0000    1950.0000    1074.5894       0.9306     216.0000       0.0583      -0.0188      -0.0558       2.4750      17.3704     268.3454     344.7671      53.5791      -0.0111      -0.0045       0.0206       7.2098    2742.0735     476.4097     -71.6875    4349.0000
 2675.8392      92.8921    1695.6180    1950.0000    1950.0000    1077.7554       0.9279     216.0000       0.0514      -0.0262      -0.0635       2.2792      17.3752     265.9265     340.3564      53.5791      -0.0134      -0.0077       0.0172       7.1687    2754.8357     706.2996     -73.5625    4398.0000
 2675.9916      92.1303    1570.2987    1950.0000    1950.0000    1005.7686       0.9943     216.0000       0.0472      -0.0308      -0.0683       2.4204      15.5325     261.3680     343.5988      53.5791      -0.0134      -0.0076       0.0172       7.1478    2762.6169     998.6323     -72.3125    4389.0000
 2676.1440      92.0637    1480.8726    1950.0000    1950.0000    1087.4183       0.9196     216.0000       0.0468      -0.0312      -0.0687       2.7187      14.0702     262.2052     357.4660      53.5791      -0.0147      -0.0090       0.0154       7.1777    2763.3816    1121.0773     -73.5625    4423.0000
 2676.2964      92.8873    1452.0273    1950.0000    1950.0000    1302.0575       0.7680     216.0000       0.0492      -0.0287      -0.0661       2.6731      13.9638     266.2987     381.6879      53.5791      -0.0167      -0.0115       0.0126       7.2542    2758.9919    1021.7548     -73.5625    4470.0000
 2676.4488      94.3770    1491.0051    1950.0000    1950.0000     983.5186       1.0168     216.0000       0.0509      -0.0268      -0.0641       2.8554      14.3974     263.8798     400.9788      53.5791      -0.0127      -0.0067       0.0182       7.3248    2755.8430     802.7405     -73.5625    4439.0000
 2676.6012      95.9760    1587.9895    1950.0000    1950.0000    1275.7639       0.7838     216.0000       0.0606      -0.0163      -0.0533       2.6975      13.1164     263.6007     396.5111      53.5791      -0.0118      -0.0056       0.0195       7.3561    2737.9409     600.9169     -73.9375    4418.0000
 2676.7536      97.1309    1714.4698    1950.0000    1950.0000    1696.7076       0.5894     216.0000       0.0678      -0.0085      -0.0452       2.2085      13.4609     265.5544     380.4414      53.5791      -0.0132      -0.0070       0.0176       7.3445    2724.5715     311.9162     -73.5625    4353.0000
 2676.9060      97.6179    1829.9313    1950.0000    1950.0000    1837.5577       0.5442     216.0000       0.0715      -0.0046      -0.0411       2.5098      13.2432     271.8807     369.5371      53.5791      -0.0133      -0.0069       0.0175       7.3158    2717.8074     321.8118     -74.9375    4351.0000
 2677.0584      97.5422    1902.3107    1950.0000    1950.0000    1821.7407       0.5489     216.0000       0.0795       0.0041      -0.0321       2.5643      14.9577     264.9962     363.1458      53.5791      -0.0135      -0.0073       0.0172       7.2953    2702.9355     204.7756     -77.7500    4455.0000
 2677.2108      97.0527    1920.4832    1950.0000    1950.0000    1736.4584       0.5759     216.0000       0.0732      -0.0026      -0.0391       2.7769      13.8012     264.1589     368.7823      53.5791      -0.0151      -0.0095       0.0149       7.2701    2714.5127     229.6658     -77.1250    4391.0000
 2677.3632      96.1781    1895.3320    1950.0000    1950.0000    1575.3326       0.6348     216.0000       0.0687      -0.0075      -0.0442       3.0820      13.2602     263.1356     366.8320      53.5791      -0.0132      -0.0065       0.0177       7.2529    2722.9063     252.8821     -78.3750    4455.0000
 2677.5156      95.0243    1841.8590    1950.0000    1950.0000    1366.3726       0.7319     216.0000       0.0562      -0.0211      -0.0582       2.7208      13.7809     261.6470     374.8140      53.5791      -0.0176      -0.0123       0.0115       7.2492    2746.1118     771.5421     -80.6875    4420.0000
 2677.6680      93.9856    1782.2841    1950.0000    1950.0000    1072.9961       0.9320     216.0000       0.0571      -0.0200      -0.0571       2.2436      14.3954     262.3913     380.9495      53.5791      -0.0212      -0.0172       0.0062       7.2788    2744.2834     819.6882     -78.2500    4378.0000
 2677.8204      93.6056    1735.6805    1950.0000    1950.0000     962.3513       1.0391     216.0000       0.0633      -0.0134      -0.0503       2.4337      14.6316     262.3913     384.9824      53.5791      -0.0155      -0.0097       0.0144       7.3100    2732.9197     386.8187     -78.7500    4360.0000
 2677.9728      94.1757    1704.9177    1950.0000    1898.7706     913.2178       1.0950     216.0000       0.0669      -0.0095      -0.0462       2.6412      15.0865     260.2515     381.5565      53.5791      -0.0098      -0.0019       0.0227       7.3000    2726.2886     262.8459     -79.0625    4380.0000
 2678.1252      95.4692    1684.2538    1950.0000    1950.0000     999.2808       1.0007     216.0000       0.0679      -0.0084      -0.0450       2.4786      14.2193     259.2281     371.7399      53.5791      -0.0160      -0.0102       0.0138       7.2552    2724.3091     226.6506     -79.5000    4380.0000
 2678.2776      96.8699    1668.5605    1950.0000    1884.6582    1017.8281       0.9825     216.0000       0.0662      -0.0103      -0.0470       2.4774      14.8241     257.7396     358.2540      53.5791      -0.0156      -0.0103       0.0141       7.2023    2727.5369     209.0833     -79.9375    4470.0000
 2678.4300      97.8393    1657.9775    1950.0000    1573.2552     942.9821       1.0605     216.0000       0.0560      -0.0213      -0.0584       2.2882      15.5829     261.0888     346.8699      53.5791      -0.0108      -0.0044       0.0209       7.1340    2746.3462     237.8204     -82.2500    4425.0000
 2678.5824      98.2710    1662.4757    1950.0000    1828.6711     943.7421       1.0596     216.0000       0.0428      -0.0356      -0.0732       2.4414      16.6669     264.2520     339.0844      53.5791      -0.0115      -0.0054       0.0199       7.0686    2770.8152     374.7911     -83.3125    4424.0000
 2678.7348      98.4057    1678.4358    1950.0000    1427.6521     866.8382       1.1536     216.0000       0.0374      -0.0414      -0.0793       2.4246      15.6518     258.2978     332.1216      53.5791      -0.0138      -0.0082       0.0167       7.0376    2780.8091     845.1021     -82.0625    4393.0000
 2678.8872      98.4715    1688.2860    1950.0000    1612.3633     868.6973       1.1511     216.0000       0.0364      -0.0425      -0.0804       2.8039      13.2671     254.7625     332.6335      53.5791      -0.0150      -0.0097       0.0150       7.0546    2782.7090    1394.4290     -81.5625    4426.0000
 2679.0396      98.5244    1674.2834    1950.0000    1589.0883     824.3721       1.2130     216.0000       0.0432      -0.0352      -0.0728       2.7246      12.6167     260.2515     332.3271      53.5791      -0.0136      -0.0073       0.0171       7.0999    2770.1074    1065.3372     -83.1875    4399.0000
 2679.1920      98.5713    1636.8904    1950.0000    1862.0850     750.3289       1.3327     216.0000       0.0368      -0.0421      -0.0800       2.6025      14.1446     258.4839     345.5391      53.5791      -0.0132      -0.0073       0.0176       7.1310    2781.9702     812.9500     -83.1875    4405.0000
 2679.3444      98.6914    1604.4354    1950.0000    1706.3601     659.0021       1.5174     216.0000       0.0409      -0.0376      -0.0754       2.6243      16.4209     256.3441     353.1642      53.5791      -0.0131      -0.0073       0.0176       7.1616    2774.3394     516.7663     -82.5000    4305.0000
 2679.4968      98.9416    1604.5067    1950.0000    1850.2399     597.7546       1.6729     216.0000       0.0481      -0.0298      -0.0672       2.5902      17.9325     261.6470     358.0098      53.5791      -0.0114      -0.0049       0.0200       7.1881    2760.9355     354.9507     -82.7500    4429.0000
 2679.6492      99.2035    1649.2466    1950.0000    1919.6754     697.4844       1.4337     216.0000       0.0586      -0.0185      -0.0555       2.4811      17.4294     262.0192     358.0804      53.5791      -0.0126      -0.0062       0.0184       7.2109    2741.6162     333.0900     -83.1875    4340.0000
 2679.8016      99.2705    1728.0240    1950.0000    1950.0000     880.0306       1.1363     216.0000       0.0603      -0.0167      -0.0536       2.6506      16.0154     264.1589     361.8479      53.5791      -0.0153      -0.0096       0.0147       7.2192    2738.5063     498.6729     -82.6875    4361.0000
 2679.9540      99.0764    1816.9377    1950.0000    1950.0000    1048.2980       0.9539     216.0000       0.0543      -0.0231      -0.0603       2.5772      14.7061     265.1823     365.8958      53.5791      -0.0154      -0.0095       0.0146       7.2116    2749.4968     637.0734     -83.3125    4434.0000
 2680.1064      98.7800    1890.6174    1950.0000    1950.0000    1198.1167       0.8346     216.0000       0.0465      -0.0316      -0.0691       2.5384      14.8994     263.0425     360.5709      53.5791      -0.0153      -0.0093       0.0148       7.1747    2763.9648     610.3447     -80.5625    4457.0000
 2680.2588      98.5797    1928.0643    1950.0000    1950.0000    1307.6532       0.7647     216.0000       0.0403      -0.0383      -0.0760       2.6483      14.2539     264.2520     345.3627      53.5791      -0.0183      -0.0130       0.0105       7.1314    2775.4419     764.3413     -83.3125    4415.0000
 2680.4112      98.4659    1923.2986    1950.0000    1950.0000    1291.4178       0.7743     216.0000       0.0420      -0.0364      -0.0741       2.7442      14.3767     262.7634     322.2549      53.5791      -0.0170      -0.0110       0.0125       7.0872    2772.3076    1216.8496     -83.3125    4412.0000
 2680.5636      98.1520    1870.0355    1950.0000    1950.0000    1252.5083       0.7984     216.0000       0.0444      -0.0339      -0.0715       2.6383      13.2243     263.3217     305.6910      53.5791      -0.0156      -0.0088       0.0146       7.0608    2767.9382    2329.6216     -83.3125    4380.0000
 2680.7160      97.2876    1754.2849    1950.0000    1950.0000    1140.1211       0.8771     216.0000       0.0525      -0.0251      -0.0624       2.6639      12.8991     265.1823     288.1863      53.5791      -0.0203      -0.0148       0.0080       7.0484    2752.9573    1328.1802     -83.3125    4388.0000
 2680.8684      95.8044    1591.8213    1950.0000    1950.0000     993.8095       1.0062     216.0000       0.0573      -0.0199      -0.0570       2.5765      12.2915     263.8798     276.1400      53.5791      -0.0192      -0.0132       0.0095       7.0484    2743.9790     823.8501     -83.3125    4397.0000
 2681.0208      94.0055    1421.7528    1950.0000    1950.0000     925.4496       1.0806     216.0000       0.0616      -0.0152      -0.0522       2.4610      11.4243     263.1356     271.5535      53.5791      -0.0223      -0.0169       0.0052       7.0609    2736.0598     875.1272     -84.6250    4341.0000
 2681.1732      92.3668    1284.1313    1950.0000    1950.0000     679.5370       1.4716     216.0000       0.0707      -0.0054      -0.0420       2.6845      10.6655     263.8798     274.7715      53.5791      -0.0250      -0.0203       0.0013       7.0953    2719.2817    1117.2592     -83.3125    4332.0000
 2681.3256      91.2834    1201.3112    1950.0000    1950.0000     540.7781       1.8492     216.0000       0.0737      -0.0021      -0.0386       2.7959      10.6694     264.8102     288.9540      53.5791      -0.0210      -0.0147       0.0072       7.1389    2713.6272    1201.9644     -88.0625    4319.0000
 2681.4780      90.9074    1174.1659    1950.0000    1950.0000     709.8682       1.4087     216.0000       0.0769       0.0013      -0.0350       2.7188      11.7490     266.1126     301.5049      53.7189      -0.0224      -0.0170       0.0051       7.1963    2707.7554     557.4974     -84.3125    4391.0000
 2681.6304      91.0900    1194.1686    1950.0000    1950.0000     886.3595       1.1282     216.0000       0.0741      -0.0017      -0.0381       2.7005      12.3993     267.6012     312.9003      53.8587      -0.0216      -0.0165       0.0060       7.2430    2712.8311     513.7092     -88.1250    4380.0000
 2681.7828      91.4266    1235.7439    1950.0000    1950.0000     871.6158       1.1473     216.0000       0.0744      -0.0014      -0.0378       2.5620      12.6779     269.0897     319.5403      53.7189      -0.0166      -0.0101       0.0132       7.2922    2712.3286     489.9808     -84.6875    4357.0000
 2681.9352      91.4245    1259.3530    1950.0000    1950.0000    1089.8567       0.9176     216.0000       0.0653      -0.0113      -0.0480       2.6242      12.0319     269.4618     334.5616      53.7189      -0.0168      -0.0106       0.0128       7.3178    2729.2502     629.1016     -93.0625    4367.0000
 2682.0876      90.7783    1229.7767    1950.0000    1950.0000    1356.1704       0.7374     216.0000       0.0539      -0.0236      -0.0608       2.4956      12.1403     275.0439     357.2455      53.5791      -0.0189      -0.0133       0.0098       7.3537    2750.3149     632.7332     -83.7500    4383.0000
 2682.2400      89.5682    1153.2336    1950.0000    1950.0000    1231.1488       0.8122     216.0000       0.0490      -0.0289      -0.0663       2.6396      12.1624     271.3225     379.8244      53.8587      -0.0174      -0.0115       0.0119       7.4067    2759.3699     613.9963     -88.1875    4301.0000
 2682.3924      88.1547    1068.4294    1950.0000    1950.0000     776.6514       1.2876     216.0000       0.0579      -0.0193      -0.0563       2.5318      13.4632     271.4155     392.1976      53.8587      -0.0180      -0.0124       0.0110       7.4725    2742.9485     514.2560     -86.0625    4328.0000
 2682.5448      86.8536     995.8135    1950.0000    1950.0000     543.2791       1.8407     216.0000       0.0610      -0.0159      -0.0528       2.6099      14.7639     276.3463     399.1833      53.8587      -0.0170      -0.0108       0.0125       7.4995    2737.1729     455.1991     -86.8750    4349.0000
 2682.6972      85.7379     935.6024    1950.0000    1950.0000    1083.6472       0.9228     216.0000       0.0573      -0.0199      -0.0570       2.5369      15.9342     271.6946     399.0066      53.8587      -0.0141      -0.0077       0.0164       7.4792    2743.9761     414.4839     -85.3750    4342.0000
 2682.8496      84.6810     882.3735    1950.0000    1950.0000    1307.0208       0.7651     216.0000       0.0472      -0.0308      -0.0683       2.5989      15.5133     273.3693     398.7558      53.8587      -0.0155      -0.0099       0.0144       7.4392    2762.7034     391.9378     -84.7500    4342.0000
 2683.0020      83.5266     841.3715    1950.0000    1950.0000    1099.3810       0.9096     216.0000       0.0447      -0.0336      -0.0711       2.6476      16.5910     279.7886     399.0152      53.8587      -0.0147      -0.0093       0.0154       7.4301    2767.3796     292.4016     -90.1875    4390.0000
 2683.1544      82.2360     828.0243    1950.0000    1950.0000     410.5160       2.4360     216.0000       0.0475      -0.0305      -0.0680       2.5849      16.5910     272.9971     402.2336      53.8587      -0.0119      -0.0056       0.0193       7.4637    2762.1714     236.6141     -87.8125    4361.0000
 2683.3068      80.9373     857.7244    1950.0000    1950.0000     567.4286       1.7623     216.0000       0.0514      -0.0262      -0.0636       2.6424      16.5783     282.0214     406.1210      53.8587      -0.0132      -0.0067       0.0177       7.5114    2754.8789     188.3775     -88.9375    4434.0000
 2683.4592      79.8458     933.2394    1950.0000    1950.0000    1251.4031       0.7991     216.0000       0.0562      -0.0211      -0.0582       2.4562      14.4633     284.5333     404.4919      53.8587      -0.0182      -0.0128       0.0107       7.5562    2745.9980     189.8862     -87.8125    4374.0000
 2683.6116      79.1474    1038.3851    1950.0000    1950.0000    1661.8883       0.6017     216.0000       0.0585      -0.0186      -0.0556       2.5933      13.8080     280.6259     406.8618      53.8587      -0.0181      -0.0128       0.0108       7.5750    2741.7771     136.1815     -87.8125    4463.0000
 2683.7640      78.9436    1135.0127    1950.0000    1950.0000    1507.3015       0.6634     216.0000       0.0658      -0.0107      -0.0474       2.5728      14.2318     279.6955     407.3799      53.8587      -0.0161      -0.0104       0.0135       7.6031    2728.2825      90.3299     -83.5625    4409.0000
 2683.9164      79.1854    1195.6112    1950.0000    1950.0000    1267.4790       0.7890     216.0000       0.0751      -0.0006      -0.0370       2.3279      13.9684     278.0209     410.6805      53.8587      -0.0118      -0.0047       0.0197       7.6428    2711.0154      76.0142     -90.1250    4394.0000
 2684.0688      79.6159    1231.4500    1950.0000    1950.0000    1347.7001       0.7420     216.0000       0.0735      -0.0024      -0.0388       2.3875      13.7518     281.7422     421.0320      53.8587      -0.0161      -0.0106       0.0136       7.6694    2714.0388      92.9245     -83.3125    4429.0000
 2684.2212      79.8735    1272.1696    1950.0000    1950.0000    1521.3171       0.6573     216.0000       0.0730      -0.0029      -0.0393       2.7632      14.3566     284.5333     431.7985      53.8587      -0.0149      -0.0092       0.0152       7.6824    2714.8813     133.7915     -92.0625    4441.0000
 2684.3736      79.7091    1325.6135    1950.0000    1950.0000    1657.1550       0.6034     216.0000       0.0724      -0.0035      -0.0400       2.6255      15.6574     288.6267     437.4275      53.8587      -0.0144      -0.0095       0.0156       7.6784    2715.9863     129.6531     -87.5625    4448.0000
 2684.5260      79.1451    1360.4622    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0748      -0.0010      -0.0374       2.5227      16.0957     284.8124     432.2591      53.8587      -0.0114      -0.0064       0.0196       7.6680    2711.6384     124.8151     -93.0625    4368.0000
 2684.6784      78.4477    1346.4852    1950.0000    1950.0000    1950.0000       0.5034     216.0000       0.0726      -0.0033      -0.0398       2.2714      14.1999     290.1153     421.0050      53.8587      -0.0047       0.0023       0.0291       7.6273    2715.6741     144.8671     -87.7500    4452.0000
 2684.8308      77.9077    1282.5615    1950.0000    1950.0000    1700.3009       0.5881     216.0000       0.0680      -0.0083      -0.0449       2.0571      13.1587     287.8825     416.2133      53.8587      -0.0070       0.0001       0.0261       7.5739    2724.1560     273.7854     -91.3750    4511.0000
 2684.9832      77.6577    1205.8453    1950.0000    1950.0000     994.5167       1.0055     216.0000       0.0668      -0.0096      -0.0463       2.3192      11.7495     285.3705     419.5194      53.8587      -0.0111      -0.0046       0.0205       7.5488    2726.4541     290.5515     -87.4375    4383.0000
 2685.1356      77.6529    1146.5065    1950.0000    1950.0000     658.9017       1.5177     216.0000       0.0671      -0.0093      -0.0460       2.8456      11.9663     282.4865     425.5960      53.8587      -0.0141      -0.0079       0.0164       7.5576    2725.8306     249.7904     -86.3125    4365.0000
 2685.2880      77.7679    1101.1578    1950.0000    1950.0000     770.1781       1.2984     216.0000       0.0699      -0.0062      -0.0428       2.6940      11.5984     285.3705     423.5833      53.8587      -0.0173      -0.0117       0.0120       7.5806    2720.6697     252.7647     -83.3125    4391.0000
 2685.4404      77.9230    1048.9712    1950.0000    1950.0000     998.5871       1.0014     216.0000       0.0865       0.0117      -0.0242       2.4918      12.7857     283.4169     406.3599      53.8587      -0.0186      -0.0132       0.0102       7.6012    2689.9548     163.0659     -88.1875    4405.0000
 2685.5928      78.1295     982.9099    1950.0000    1950.0000    1065.9034       0.9382     216.0000       0.1057       0.0325      -0.0027       2.6319      13.0025     290.9526     391.3982      53.8587      -0.0184      -0.0127       0.0105       7.6163    2654.4116     113.2524     -88.3750    4452.0000
 2685.7452      78.4435     925.1346    1950.0000    1950.0000     572.3714       1.7471     216.0000       0.1193       0.0472       0.0126       2.6005      14.3904     284.5333     383.6494      53.8587      -0.0169      -0.0108       0.0127       7.5960    2629.2371      65.5903     -83.8750    4428.0000
 2685.8976      78.8751     906.0449    1950.0000    1950.0000     378.7025       2.6406     216.0000       0.1158       0.0434       0.0086       2.6995      13.8534     290.3944     388.6960      53.8587      -0.0176      -0.0119       0.0115       7.5489    2635.8152      67.5260     -87.5000    4508.0000
 2686.0500      79.3562     947.7217    1950.0000    1950.0000     516.6548       1.9355     216.0000       0.1061       0.0329      -0.0023       2.6517      14.3954     292.1620     388.9253      53.8587      -0.0141      -0.0075       0.0166       7.4932    2653.7793      75.2936     -86.3125    4477.0000
 2686.2024      79.8097    1062.0658    1950.0000    1950.0000    1066.2698       0.9378     216.0000       0.0944       0.0202      -0.0154       2.5586      14.1949     294.2088     383.0376      53.8587      -0.0150      -0.0091       0.0151       7.4522    2675.4265     119.1709     -87.7500    4417.0000
 2686.3548      80.1768    1243.5222    1950.0000    1950.0000     939.4854       1.0644     216.0000       0.0914       0.0171      -0.0187       2.4193      15.9292     295.6973     367.3632      53.8587      -0.0171      -0.0116       0.0122       7.4101    2680.8291     152.4076     -89.9375    4378.0000
 2686.5072      80.4631    1451.2273    1950.0000    1950.0000    1258.9572       0.7943     216.0000       0.0989       0.0251      -0.0103       2.4437      15.9351     296.8137     357.3248      53.8587      -0.0174      -0.0117       0.0119       7.3988    2667.0586     153.9482     -86.8750    4380.0000
 2686.6596      80.7807    1604.3995    1950.0000    1950.0000    1357.1697       0.7368     216.0000       0.1145       0.0420       0.0071       2.5966      15.6149     288.7198     352.2880      53.8587      -0.0160      -0.0100       0.0139       7.4090    2638.2346     118.6062     -91.2500    4367.0000
 2686.8120      81.3421    1635.1417    1950.0000    1950.0000    1394.0017       0.7174     216.0000       0.1218       0.0499       0.0153       2.5912      15.7233     284.9054     359.0414      53.8587      -0.0139      -0.0078       0.0167       7.4427    2624.6843      97.3794     -83.3125    4388.0000
 2686.9644      82.4211    1563.7144    1950.0000    1950.0000    1321.2155       0.7569     216.0000       0.1254       0.0538       0.0193       2.5598      15.6044     286.5800     357.2030      53.8587      -0.0123      -0.0057       0.0190       7.4438    2618.0752     105.7664     -85.3125    4304.0000
 2687.1168      84.2108    1461.8196    1950.0000    1950.0000    1154.2491       0.8664     216.0000       0.1357       0.0650       0.0310       2.5882      16.7967     294.0227     343.6566      53.8587      -0.0145      -0.0086       0.0158       7.4271    2598.8867     100.2893     -91.1875    4400.0000
 2687.2692      86.5591    1388.8315    1950.0000    1896.1199    1092.9091       0.9150     216.0000       0.1434       0.0733       0.0396       2.5020      14.9803     294.8600     333.0867      53.8587      -0.0173      -0.0122       0.0118       7.3913    2584.7251      88.8871     -84.2500    4410.0000
 2687.4216      88.8550    1375.9557    1950.0000    1764.0544    1129.2511       0.8855     216.0000       0.1334       0.0624       0.0283       2.5748      15.9605     297.5580     342.7575      53.8587      -0.0144      -0.0078       0.0161       7.3486    2603.2363      84.3503     -86.0000    4402.0000
 2687.5740      90.0424    1430.3506    1950.0000    1564.5135    1049.5756       0.9528     216.0000       0.0980       0.0242      -0.0113       2.5432      15.1966     290.1153     371.9518      53.8587      -0.0166      -0.0105       0.0131       7.2794    2668.6953     145.6460     -88.1875    4431.0000
 2687.7264      89.0426    1567.7675    1950.0000    1665.9546     923.8904       1.0824     216.0000       0.0695      -0.0066      -0.0432       2.5360      15.6039     288.4407     383.6048      53.8587      -0.0193      -0.0137       0.0093       7.1874    2721.3328     289.3239     -83.3125    4453.0000
 2687.8788      85.9163    1837.1339    1950.0000    1316.3945     762.7477       1.3110     216.0000       0.0562      -0.0211      -0.0582       2.5915      14.1330     279.5095     372.9417      53.8587      -0.0188      -0.0131       0.0100       7.0679    2746.0974     527.4061     -87.5000    4334.0000
 2688.0312      81.1724    1866.5619    1556.7067    1191.5763     648.5569       1.5419     216.0000       0.0704      -0.0057      -0.0423       2.6188      13.9213     282.5796     329.6564      53.8587      -0.0210      -0.0159       0.0068       6.9480    2719.7639     151.2079     -83.3125    4348.0000
 2688.1836      75.5746    1940.5613    1199.3503     958.6995     630.7007       1.5855     216.0000       0.0939       0.0197      -0.0159       2.5989      13.2709     279.1374     260.3674      53.8587      -0.0191      -0.0134       0.0095       6.7837    2676.3167      27.4924     -87.5000    4352.0000
 2688.3360      73.0999    1950.0000     869.0121     846.2515     621.0015       1.6103     216.0000       0.0882       0.0136      -0.0223       2.6388      13.1655     282.3004     193.8407      53.8587      -0.0185      -0.0122       0.0106       6.5371    2686.7883      26.2147     -83.3125    4307.0000
 2688.4884      67.5913    1940.7633     671.7554     901.0513     786.1886       1.2720     216.0000       0.0809       0.0056      -0.0305       2.6347      11.7564     231.5042     118.2168      53.8587      -0.0145      -0.0087       0.0157       6.2043    2700.3877      39.7713     -93.0625    4356.0000
 2688.6408      65.9290     707.8076     404.8370     719.4467     670.0323       1.4925     216.0000       0.0687      -0.0075      -0.0441       2.6612      11.1866     222.5730      60.1687      53.8587      -0.0145      -0.0090       0.0157       5.8531    2722.8423     475.6063     -83.3125    4342.0000
 2688.7932      62.6571     414.6899     353.7669     676.8317     805.9837       1.2407     216.0000       0.0879       0.0133      -0.0226       2.6210      12.2159     222.2008       9.5391      53.8587      -0.0131      -0.0070       0.0177       5.6328    2687.3074    2923.0430     -87.5625    4360.0000
 2688.9456      65.5950     260.1392     375.5100    1144.3032    1904.2875       0.5251     216.0000       0.0961       0.0221      -0.0135       2.5406      12.3243     221.2705      -7.6268      53.8587      -0.0123      -0.0060       0.0188       5.5160    2672.2629    4669.4316     -84.4375    4426.0000
 2689.0980      75.6544     152.8471     204.2709     628.7180     727.4272       1.3747     216.0000       0.0970       0.0230      -0.0125       2.5861      11.9185     221.4566      -6.8240      53.8587      -0.0134      -0.0072       0.0173       5.4443    2670.6091    4461.6743     -86.3125    4358.0000
 2689.2504      83.1404     129.8696     242.5265     523.4398    1088.6344       0.9186     216.0000       0.0886       0.0139      -0.0219       2.6538      10.1818     221.4566      -3.9775      53.8587      -0.0139      -0.0081       0.0165       5.3493    2686.1521    3797.6465     -83.3750    4348.0000
 2689.4028      93.8733     125.1119     346.4303     417.7809    1268.4214       0.7884     216.0000       0.0755      -0.0002      -0.0366       2.6635      10.0734     221.2705       0.0563      53.8587      -0.0147      -0.0096       0.0153       5.2807    2710.3423    3878.2446     -83.3750    4376.0000
 2689.5552     100.3952     124.4340     437.9185     547.3961    1444.4811       0.6923     216.0000       0.0715      -0.0046      -0.0411       2.6700      11.4779     221.1775      -0.2108      53.8587      -0.0113      -0.0050       0.0202       5.2902    2717.7830    4297.1240     -83.3125    4353.0000
 2689.7076     102.3542     129.1480     614.6785     636.4896    1518.9144       0.6584     216.0000       0.0722      -0.0037      -0.0402       2.5726      11.4810     220.8984      -2.0356      53.8587      -0.0101      -0.0035       0.0219       5.3300    2716.3584    4883.9492     -85.3125    4384.0000
 2689.8600     105.6005     145.8065     851.5413     610.9489    1469.1083       0.6807     216.0000       0.0749      -0.0009      -0.0373       2.5367      11.3726     220.8984      -4.4165      53.8587      -0.0136      -0.0077       0.0170       5.3372    2711.5103    4847.3906     -83.3125    4401.0000
 2690.0124     108.1364     170.0868    1210.6787     861.6880    1402.4440       0.7130     216.0000       0.0688      -0.0075      -0.0441       2.5944      10.7229     221.1775      -3.4873      53.8587      -0.0124      -0.0062       0.0186       5.2733    2722.7849    4825.0239     -83.6250    4331.0000
 2690.1648     114.6648     203.3483    1462.6888    1096.3402    1277.7551       0.7826     216.0000       0.0677      -0.0087      -0.0453       2.6057      10.8356     221.1775      -4.0226      53.8587      -0.0146      -0.0088       0.0157       5.2469    2724.8076    4852.1440     -87.2500    4380.0000
 2690.3172     123.6135     244.9742    1570.5537    1275.5944    1245.3552       0.8030     216.0000       0.0626      -0.0142      -0.0510       2.6858      11.2654     220.8984      -1.5624      53.8587      -0.0157      -0.0104       0.0140       5.2080    2734.2222    4892.1348     -83.2500    4272.0000
 2690.4696     123.5173     311.2202    1732.7271    1402.3409     974.9241       1.0257     216.0000       0.0628      -0.0140      -0.0508       2.6013      10.1854     220.8984      -0.7045      53.8587      -0.0141      -0.0080       0.0164       5.2067    2733.8818    4918.1523     -84.0000    4317.0000
 2690.6220     124.8622     364.5774    1607.3773    1233.4744     911.7379       1.0968     216.0000       0.0609      -0.0160      -0.0529       2.7113      10.2728     220.7123       0.4888      53.8587      -0.0143      -0.0086       0.0160       5.1894    2737.3315    4901.1318     -82.5000    4322.0000
 2690.7744     126.2368     434.2007    1580.7349    1060.4701     803.6612       1.2443     216.0000       0.0664      -0.0100      -0.0467       2.7600      10.7102     220.8984      -2.8436      53.8587      -0.0133      -0.0071       0.0175       5.2238    2727.0959    4897.4678     -84.4375    4342.0000
 2690.9268     128.2040     517.3774    1630.4739     945.3852     724.7346       1.3798     216.0000       0.0702      -0.0060      -0.0425       2.8224      11.5736     220.8984      -5.9390      53.8587      -0.0149      -0.0095       0.0150       5.2416    2720.2012    4841.4678     -82.6250    4391.0000
 2691.0792     130.1517     545.1165    1950.0000     722.6823     539.7457       1.8527     216.0000       0.0660      -0.0105      -0.0472       2.6332      13.7126     220.8984      -5.2023      53.8587      -0.0104      -0.0038       0.0214       5.1876    2727.9255    4839.3672     -83.3125    4319.0000
 2691.2316     128.5270     481.6534    1371.7062     761.1005     605.4018       1.6518     216.0000       0.0596      -0.0174      -0.0544       2.7252      14.1461     220.7123      -2.3096      53.8587      -0.0119      -0.0059       0.0193       5.1024    2739.7966    4850.9199     -82.3750    4375.0000
 2691.3840     127.7438     454.1165    1013.8638     737.3206     531.7533       1.8806     216.0000       0.0567      -0.0205      -0.0576       2.6086      16.4202     220.8984      -0.0870      53.8587      -0.0143      -0.0093       0.0158       5.0740    2745.0334    4880.6636     -83.0000    4398.0000
 2691.5364     122.2469     369.1289     939.1576     877.1761     694.7922       1.4393     216.0000       0.0572      -0.0200      -0.0571       2.6199      16.0085     220.8984       0.0319      53.8587      -0.0097      -0.0032       0.0223       5.0681    2744.2612    4905.1050     -83.3125    4349.0000
 2691.6888     119.8892     377.7134     972.0137     867.8506     717.0106       1.3947     216.0000       0.0586      -0.0185      -0.0556       2.6514      15.7917     220.8984      -1.0097      53.8587      -0.0114      -0.0057       0.0198       5.0776    2741.6733    4859.6670     -83.3125    4330.0000
 2691.8412     124.1259     448.2238    1181.5253    1173.6605     899.1448       1.1122     216.0000       0.0566      -0.0207      -0.0578       2.7841      15.3641     220.8984      -1.5247      53.8587      -0.0106      -0.0049       0.0209       5.0368    2745.3516    4870.0815     -80.5000    4399.0000
 2691.9936     127.4762     581.3444    1679.3271    1692.8455    1630.8881       0.6132     216.0000       0.0569      -0.0203      -0.0575       2.7865      14.4456     220.8984      -2.6922      53.8587      -0.0075      -0.0011       0.0252       5.0146    2744.7969    4832.7363     -81.0000    4305.0000
 2692.1460     133.2184     723.7192    1940.7579    1937.8544    1947.9011       0.5134     216.0000       0.0539      -0.0235      -0.0607       2.7282      14.6624     220.8984      -1.9212      53.8587      -0.0059       0.0004       0.0273       4.9806    2750.2283    4859.4829     -83.3125    4369.0000
 2692.2984     138.9896     809.9527    1933.4214    1914.5449    1950.0000       0.5099     216.0000       0.0617      -0.0151      -0.0520       2.7743      14.2288     220.8984      -4.3170      53.8587      -0.0055       0.0010       0.0279       5.0571    2735.7761    4832.9170     -81.8750    4324.0000
 2692.4508     141.0799     767.1718    1950.0000    1950.0000    1950.0000       0.5023     216.0000       0.0694      -0.0067      -0.0433       2.7341      15.2838     221.0844      -5.7635      53.8587      -0.0078      -0.0019       0.0247       5.1623    2721.5203    4850.0469     -79.8750    4354.0000
 2692.6032     139.8015     599.6219    1148.2747    1002.2084    1583.8375       0.6314     216.0000       0.0801       0.0047      -0.0315       2.7030      16.7132     220.8984      -6.3612      53.8587      -0.0089      -0.0030       0.0232       5.2903    2701.9055    4884.3379     -77.8125    4405.0000
 2692.7556     120.7038     321.8401     902.5303     585.1321    1367.6324       0.7312     216.0000       0.0816       0.0064      -0.0297       2.7939      15.4125     221.2705      -1.7960      53.8587      -0.0084      -0.0021       0.0240       5.3606    2699.0132    4909.8848     -78.6875    4429.0000
 2692.9080     112.6555     234.8404     384.0222     316.0044     773.0599       1.2936     216.0000       0.0834       0.0083      -0.0277       2.8546      14.8742     221.0844      -1.8730      53.8587      -0.0069      -0.0001       0.0262       5.4287    2695.7478    4909.9561     -81.0000    4409.0000
 2693.0604     126.5719     306.3073     467.4674     549.4073    1309.7495       0.7635     216.0000       0.0835       0.0085      -0.0276       2.9028      11.9241     220.8984      -3.8269      53.8587      -0.0065       0.0002       0.0266       5.4659    2695.5483    4886.6699     -80.1250    4388.0000
 2693.2128     163.5725     668.9491    1192.0869    1063.6255    1628.4163       0.6141     216.0000       0.0827       0.0076      -0.0285       2.7657      12.5744     221.4566      -8.0411      53.8587      -0.0118      -0.0066       0.0191       5.4557    2697.0691    4879.8643     -78.9375    4308.0000
 2693.3652     180.3505     993.7656    1950.0000    1950.0000    1950.0000       0.5001     216.0000       0.0812       0.0059      -0.0302       2.6723      12.1635     221.0844      -8.0106      53.8587      -0.0138      -0.0087       0.0164       5.4088    2699.8721    4900.2583     -76.1250    4360.0000
 2693.5176     188.5229    1297.0386    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0742      -0.0016      -0.0380       2.7188      12.7086     221.4566      -5.8403      53.8587      -0.0117      -0.0058       0.0195       5.3149    2712.7007    4894.1182     -74.8125    4436.0000
 2693.6700     183.6676    1525.9949    1950.0000    1950.0000    1663.0417       0.6013     216.0000       0.0702      -0.0059      -0.0425       2.8195      13.6786     221.1775      -4.0112      53.8587      -0.0100      -0.0038       0.0218       5.2602    2720.0881    4889.4990     -73.8750    4518.0000
 2693.8224     184.1282    1655.2290    1950.0000    1603.3671    1132.7446       0.8828     216.0000       0.0691      -0.0071      -0.0437       2.9897      14.0850     221.4566      -3.6011      53.8587      -0.0107      -0.0048       0.0208       5.2511    2722.1694    4882.8706     -74.0625    4533.0000
 2693.9748     181.4493    1713.7925    1899.6287    1127.4640     881.5357       1.1344     216.0000       0.0719      -0.0040      -0.0405       2.7784      16.5782     220.8984      -4.7786      53.8587      -0.0096      -0.0036       0.0223       5.2890    2716.9048    4915.2676     -77.6875    4422.0000
 2694.1272     180.7247    1723.4570    1950.0000    1296.8041     941.1410       1.0625     216.0000       0.0678      -0.0086      -0.0452       2.7645      15.0661     221.1775      -3.4919      53.8587      -0.0093      -0.0033       0.0227       5.2698    2724.6428    4911.4614     -75.1250    4408.0000
 2694.2796     181.4870    1706.0051    1950.0000    1313.7816    1026.8872       0.9738     216.0000       0.0631      -0.0136      -0.0505       2.8969      13.1159     221.0844      -1.5116      53.8587      -0.0100      -0.0043       0.0217       5.2553    2733.3262    4890.3179     -76.5000    4455.0000
 2694.4320     182.4930    1651.9707    1950.0000    1365.2324    1117.8031       0.8946     216.0000       0.0659      -0.0106      -0.0473       2.7591      11.5052     221.1775      -1.9438      53.8587      -0.0050       0.0022       0.0288       5.3015    2728.1267    4876.9502     -75.2500    4409.0000
 2694.5844     182.6489    1583.0609    1950.0000    1387.0332    1143.1182       0.8748     216.0000       0.0757       0.0000      -0.0363       3.0425      11.6135     221.1775      -5.3115      53.8587      -0.0095      -0.0037       0.0224       5.3927    2709.9412    4893.6572     -75.2500    4367.0000
 2694.7368     181.3502    1529.1223    1950.0000    1440.0461    1318.5461       0.7584     216.0000       0.0808       0.0056      -0.0306       2.8907      13.5638     221.2705      -7.6048      53.8587      -0.0090      -0.0035       0.0229       5.4043    2700.4546    4905.8003     -75.6250    4343.0000
 2694.8892     178.9466    1518.2721    1950.0000    1642.7142    1472.7671       0.6790     216.0000       0.0808       0.0056      -0.0306       2.7666      13.1109     221.0844      -7.9305      53.8587      -0.0073      -0.0012       0.0254       5.3597    2700.4873    4923.7588     -75.1250    4346.0000
 2695.0416     176.6093    1562.4633    1950.0000    1639.8397    1514.7932       0.6602     216.0000       0.0748      -0.0009      -0.0373       3.0128      13.6529     220.8984      -5.8978      53.8587      -0.0075      -0.0016       0.0251       5.2679    2711.5291    4935.2549     -75.0000    4381.0000
 2695.1940     175.5670    1653.3955    1950.0000    1950.0000    1844.5493       0.5421     216.0000       0.0689      -0.0073      -0.0439       2.9847      13.1489     221.0844      -3.7081      53.8587      -0.0054       0.0017       0.0282       5.1998    2722.4678    4939.7896     -74.3750    4388.0000
 2695.3464     176.4029    1765.4510    1950.0000    1950.0000    1642.5703       0.6088     216.0000       0.0696      -0.0066      -0.0432       2.7880      13.1489     221.4566      -4.4792      53.8587      -0.0110      -0.0055       0.0203       5.2164    2721.2852    4934.3940     -74.8125    4417.0000
 2695.4988     178.8470    1867.4800    1950.0000    1923.7489    1670.7013       0.5986     216.0000       0.0722      -0.0037      -0.0402       2.9842      13.4664     221.4566      -6.6791      53.8587      -0.0104      -0.0043       0.0213       5.2635    2716.3843    4932.1787     -74.0000    4429.0000
 2695.6512     182.0644    1938.0990    1950.0000    1941.3867    1643.5576       0.6084     216.0000       0.0750      -0.0007      -0.0371       2.8399      13.7545     221.4566      -9.0539      53.8587      -0.0090      -0.0027       0.0231       5.3061    2711.2190    4935.0005     -73.5625    4392.0000
 2695.8036     185.1553    1950.0000    1950.0000    1893.6760    1668.8383       0.5992     216.0000       0.0754      -0.0002      -0.0366       2.8686      14.5174     221.4566      -9.3265      53.8587      -0.0091      -0.0029       0.0230       5.3021    2710.4177    4906.4810     -73.5625    4415.0000
 2695.9560     187.5695    1950.0000    1950.0000    1786.2847    1709.4263       0.5850     216.0000       0.0768       0.0012      -0.0351       2.9090      14.5127     221.2705      -8.5020      53.8587      -0.0094      -0.0033       0.0226       5.3130    2707.9773    4900.8696     -73.5625    4369.0000
 2696.1084     189.2159    1950.0000    1950.0000    1657.9412    1731.4509       0.5776     216.0000       0.0817       0.0065      -0.0296       2.9546      13.8623     221.0844      -8.6982      53.8587      -0.0110      -0.0055       0.0203       5.3712    2698.8174    4893.5044     -73.5625    4364.0000
 2696.2608     190.3014    1950.0000    1950.0000    1532.8712    1721.6385       0.5808     216.0000       0.0825       0.0074      -0.0287       3.0253      14.0791     221.4566      -8.5721      53.8587      -0.0087      -0.0025       0.0235       5.3929    2697.3228    4923.0269     -72.9375    4415.0000
 2696.4132     191.1051    1950.0000    1950.0000    1442.6460    1691.3655       0.5912     216.0000       0.0826       0.0074      -0.0286       2.9140      13.5758     221.1775      -8.9896      53.9985      -0.0081      -0.0019       0.0244       5.3881    2697.2654    4903.5181     -73.0625    4404.0000
 2696.5656     191.8764    1950.0000    1950.0000    1407.4410    1662.0659       0.6017     216.0000       0.0806       0.0053      -0.0308       2.9056      12.9220     221.4566      -8.4333      53.9985      -0.0086      -0.0023       0.0238       5.3566    2700.8640    4899.5952     -73.5625    4381.0000
 2696.7180     192.7703    1950.0000    1950.0000    1430.6533    1636.8906       0.6109     216.0000       0.0773       0.0018      -0.0345       2.9781      12.0549     221.4566      -6.9847      54.1383      -0.0094      -0.0035       0.0226       5.3197    2706.9543    4890.4175     -73.5625    4374.0000
 2696.8704     193.6934    1950.0000    1950.0000    1495.3185    1590.0602       0.6289     216.0000       0.0737      -0.0021      -0.0386       2.9321      13.3811     221.7357      -5.4681      54.1383      -0.0098      -0.0040       0.0220       5.2834    2713.6304    4905.8135     -72.5625    4380.0000
 2697.0228     194.3830    1950.0000    1950.0000    1570.8806    1502.3641       0.6656     216.0000       0.0732      -0.0026      -0.0391       3.0496      14.8971     221.4566      -5.8048      54.1383      -0.0085      -0.0023       0.0238       5.2704    2714.5149    4904.3799     -73.5625    4402.0000
 2697.1752     194.6932    1950.0000    1950.0000    1626.5221    1386.2706       0.7214     216.0000       0.0736      -0.0023      -0.0387       2.9925      14.8971     221.8287      -6.0203      54.1383      -0.0101      -0.0043       0.0216       5.2899    2713.8726    4900.3447     -71.9375    4401.0000
 2697.3276     194.7647    1950.0000    1950.0000    1653.8127    1282.8389       0.7795     216.0000       0.0742      -0.0016      -0.0381       3.0004      13.3236     221.6427      -5.7759      54.1383      -0.0097      -0.0033       0.0223       5.3311    2712.8069    4908.7793     -70.8750    4358.0000
 2697.4800     194.9821    1950.0000    1950.0000    1670.6724    1229.4984       0.8133     216.0000       0.0766       0.0010      -0.0354       2.9088      13.7389     221.8287      -5.6646      54.1383      -0.0112      -0.0055       0.0201       5.4076    2708.3701    4914.0767     -72.9375    4372.0000
 2697.6324     195.7162    1950.0000    1950.0000    1702.5397    1245.4004       0.8030     216.0000       0.0773       0.0018      -0.0345       2.9198      14.4977     221.8287      -4.9713      54.1383      -0.0099      -0.0035       0.0220       5.4455    2706.9739    4919.3027     -73.5625    4338.0000
 2697.7848     197.0563    1950.0000    1950.0000    1757.0939    1333.2755       0.7500     216.0000       0.0840       0.0090      -0.0271       2.9457      14.6060     221.4566      -4.7324      54.1383      -0.0124      -0.0068       0.0185       5.5102    2694.6721    4912.6494     -73.2500    4389.0000
 2697.9372     198.7247    1950.0000    1950.0000    1826.6765    1479.8597       0.6757     216.0000       0.0857       0.0108      -0.0252       2.9974      13.8658     222.0148      -4.6909      54.1383      -0.0121      -0.0061       0.0190       5.5128    2691.5305    4910.5942     -72.1250    4400.0000
 2698.0896     200.1629    1950.0000    1950.0000    1895.7047    1649.8689       0.6061     216.0000       0.0866       0.0119      -0.0241       2.9543      14.9814     221.6427      -5.3959      54.1383      -0.0122      -0.0064       0.0188       5.5045    2689.7297    4860.8716     -73.5625    4381.0000
 2698.2420     200.7332    1950.0000    1950.0000    1942.6953    1791.0267       0.5583     216.0000       0.0808       0.0055      -0.0306       2.9731      15.4194     221.4566      -5.8970      54.1383      -0.0109      -0.0047       0.0207       5.4314    2700.5620    4822.6152     -71.3125    4367.0000
 2698.3944     200.0197    1950.0000    1950.0000    1950.0000    1861.8014       0.5371     216.0000       0.0770       0.0015      -0.0349       2.6809      14.7285     221.7357      -5.2440      54.1383      -0.0126      -0.0070       0.0182       5.3665    2707.5154    4812.4268     -70.5000    4429.0000
 2698.5468     198.0672    1950.0000    1950.0000    1939.4282    1855.6035       0.5389     216.0000       0.0760       0.0003      -0.0360       2.8777      13.3961     222.0148      -4.5531      54.1383      -0.0112      -0.0052       0.0201       5.3386    2709.4377    4800.5410     -69.8125    4405.0000
 2698.6992     195.4133    1950.0000    1950.0000    1884.3693    1792.1016       0.5580     216.0000       0.0763       0.0007      -0.0357       2.9516      12.9956     222.0148      -3.8359      54.1383      -0.0101      -0.0038       0.0217       5.3502    2708.8333    4814.0938     -71.1250    4421.0000
 2698.8516     192.8059    1950.0000    1950.0000    1795.4075    1699.2523       0.5885     216.0000       0.0784       0.0030      -0.0333       3.0126      12.7154     221.4566      -3.5715      54.1383      -0.0111      -0.0049       0.0203       5.4107    2704.8953    4804.0361     -70.1875    4385.0000
 2699.0040     190.7903    1950.0000    1950.0000    1700.2327    1612.1135       0.6203     216.0000       0.0798       0.0044      -0.0318       2.9306      13.1438     222.0148      -3.1569      54.1383      -0.0129      -0.0070       0.0179       5.4679    2702.4575    4848.9346     -70.9375    4388.0000
 2699.1564     189.5126    1950.0000    1950.0000    1632.7506    1551.8296       0.6444     216.0000       0.0795       0.0041      -0.0321       2.9544      13.1479     222.0148      -3.0038      54.1383      -0.0141      -0.0084       0.0162       5.4910    2702.9600    4786.7559     -70.7500    4413.0000
 2699.3088     188.7048    1903.7109    1950.0000    1629.5167    1480.9730       0.6752     216.0000       0.0772       0.0017      -0.0346       2.9938      13.6857     222.2939      -3.2377      54.1383      -0.0143      -0.0087       0.0159       5.4679    2707.1375    4769.2588     -70.6250    4405.0000
 2699.4612     187.8671    1800.2297    1950.0000    1720.9193    1493.3893       0.6696     216.0000       0.0770       0.0015      -0.0348       2.9012      13.2573     222.5730      -5.4207      54.1383      -0.0105      -0.0037       0.0214       5.4368    2707.4656    4757.5708     -70.5000    4392.0000
 2699.6136     186.3546    1658.8827    1950.0000    1649.3231    1450.5642       0.6894     216.0000       0.0800       0.0047      -0.0315       3.0067      12.2413     222.2939      -8.4181      54.1383      -0.0146      -0.0092       0.0154       5.4347    2701.9231    4792.8433     -70.8125    4385.0000
 2699.7660     183.5703    1512.0667    1950.0000    1940.5195    1475.9961       0.6775     216.0000       0.0775       0.0019      -0.0344       2.9112      11.8891     222.2939      -8.1918      54.1383      -0.0142      -0.0086       0.0161       5.3902    2706.7173    4777.4683     -69.5000    4321.0000
 2699.9184     179.3960    1398.6195    1950.0000    1576.6031    1049.7610       0.9526     216.0000       0.0768       0.0012      -0.0351       2.8524       9.2876     222.2008      -8.1811      54.1383      -0.0119      -0.0055       0.0194       5.3705    2707.9841    4797.1187     -68.2500    4346.0000
 2700.0708     174.5117    1344.2753    1950.0000    1510.2565     891.2358       1.1220     216.0000       0.0742      -0.0016      -0.0381       2.9307       9.1789     222.5730      -7.3729      54.1383      -0.0142      -0.0085       0.0162       5.3300    2712.8145    4777.8721     -69.3750    4377.0000
 2700.2232     170.2605    1357.9401    1950.0000    1320.2979    1047.5457       0.9546     216.0000       0.0743      -0.0015      -0.0379       2.9899       9.1016     222.5730      -7.4654      54.1383      -0.0147      -0.0092       0.0154       5.3279    2712.6133    4753.7896     -68.2500    4327.0000
 2700.3756     167.9233    1434.0197    1950.0000    1396.6774    1199.9702       0.8334     216.0000       0.0691      -0.0071      -0.0437       2.8917      11.8106     222.5730      -4.8668      54.1383      -0.0128      -0.0069       0.0181       5.2922    2722.1074    4708.6606     -68.2500    4399.0000
 2700.5280     167.9445    1550.3055    1950.0000    1180.9850    1075.9309       0.9294     216.0000       0.0680      -0.0083      -0.0449       2.7983      12.7856     222.8521      -3.2470      54.1383      -0.0099      -0.0034       0.0220       5.2950    2724.1428    4738.3286     -68.7500    4376.0000
 2700.6804     169.5889    1664.4664    1950.0000    1111.0182    1094.3408       0.9138     216.0000       0.0697      -0.0064      -0.0430       2.9513      13.1680     231.8763      -2.7351      54.1383      -0.0117      -0.0053       0.0197       5.2940    2721.0234    4743.6631     -70.3125    4368.0000
 2700.8328     171.2496    1718.6268    1950.0000    1127.8455    1119.3447       0.8934     216.0000       0.0702      -0.0059      -0.0425       3.0635      11.1094     223.5033      -2.0103      54.1383      -0.0137      -0.0084       0.0167       5.2690    2720.1030    4674.7993     -69.2500    4369.0000
 2700.9852     171.3620    1672.6357    1950.0000    1136.2720    1105.8497       0.9043     216.0000       0.0635      -0.0132      -0.0500       2.9693      12.3006     223.6894       0.4575      54.1383      -0.0101      -0.0036       0.0218       5.2430    2732.5637    4588.9839     -70.2500    4332.0000
 2701.1376     169.3033    1536.0807    1950.0000    1405.6810    1354.3754       0.7383     216.0000       0.0541      -0.0233      -0.0606       2.8747      13.7192     223.6894       3.7365      54.1383      -0.0113      -0.0051       0.0201       5.2165    2749.9204    4570.2661     -65.1250    4373.0000
 2701.2900     165.4712    1362.9503    1950.0000    1359.7302    1396.6974       0.7160     216.0000       0.0522      -0.0254      -0.0627       2.8285      14.1528     224.8058       4.0653      54.1383      -0.0140      -0.0086       0.0163       5.2065    2753.3738    4653.5396     -73.5625    4378.0000
 2701.4424     160.5061    1206.7113    1950.0000    1101.9553    1094.3735       0.9138     216.0000       0.0566      -0.0206      -0.0577       3.0527      14.1183     223.6894       2.1949      54.1383      -0.0118      -0.0058       0.0194       5.1872    2745.2749    4721.4365     -70.4375    4345.0000
 2701.5948     154.7498    1097.7202    1934.9763     805.9387     871.3468       1.1476     216.0000       0.0584      -0.0187      -0.0558       2.9252      13.5132     224.6197       1.6496      54.1383      -0.0094      -0.0029       0.0228       5.1903    2742.0242    4722.9082     -70.6250    4375.0000
 2701.7472     148.2533    1034.4812    1878.0466     603.9991     722.2106       1.3846     216.0000       0.0602      -0.0168      -0.0538       2.7800      15.1392     224.4336       1.4985      54.1383      -0.0127      -0.0072       0.0180       5.2224    2738.7117    4739.6543     -70.8125    4366.0000
 2701.8996     140.8185     980.5397    1825.5126     565.1137     669.6170       1.4934     216.0000       0.0591      -0.0180      -0.0550       3.0448      13.8196     226.2943       4.1721      54.1383      -0.0130      -0.0068       0.0179       5.2841    2740.7332    4758.9819     -71.1875    4350.0000
 2702.0520     133.7412     916.1711    1901.1066     569.0102     560.9676       1.7826     216.0000       0.0618      -0.0150      -0.0519       2.7424      14.5747     225.0849       5.0652      54.1383      -0.0148      -0.0081       0.0156       5.3264    2735.6025    1725.8572     -65.4375    4400.0000
 2702.2044     123.7577     725.4734    1950.0000     697.4359     593.9738       1.6836     216.0000       0.0653      -0.0112      -0.0480       3.0296      14.3706     225.6431       4.0901      54.1383      -0.0182      -0.0120       0.0110       5.3666    2729.1892    1707.2927     -71.6250    4360.0000
 2702.3568     118.8800     609.4692    1333.7120     576.8887     575.5491       1.7375     216.0000       0.0760       0.0003      -0.0360       2.8705      13.8838     225.7361      -0.0415      54.1383      -0.0213      -0.0162       0.0065       5.4041    2709.4614    1710.3038     -69.8125    4351.0000
 2702.5092     111.0418     469.6363    1874.7585     815.1829     561.2729       1.7817     216.0000       0.0855       0.0106      -0.0254       2.7125      12.7219     226.4804      11.0579      54.1383      -0.0211      -0.0163       0.0066       5.6391    2691.8301    4773.4072     -71.5000    4346.0000
 2702.6616     106.5074     387.5895    1822.1938     896.9385     628.1440       1.5920     216.0000       0.0920       0.0177      -0.0181       2.7512      12.8190     226.7595      67.0729      54.1383      -0.0210      -0.0163       0.0067       6.1506    2679.7866    4813.4316     -70.8125    4366.0000
 2702.8140     104.2159     342.2964    1879.1169    1148.1166     714.2662       1.4000     216.0000       0.0954       0.0213      -0.0142       2.7773      13.0394     230.3878     156.6484      54.1383      -0.0196      -0.0140       0.0089       6.7968    2673.4980     356.8885     -71.8125    4355.0000
 2702.9664     104.2046     330.3794    1935.6053    1427.8846     862.1164       1.1599     216.0000       0.0964       0.0224      -0.0131       2.5585      13.4462     245.8313     261.6219      54.1383      -0.0187      -0.0121       0.0104       7.3394    2671.6748     109.9010     -72.3750    4393.0000
 2703.1188     105.9850     352.2104    1950.0000    1622.1742    1014.4782       0.9857     216.0000       0.0963       0.0223      -0.0133       2.9257      13.5477     259.1351     341.2802      54.1383      -0.0182      -0.0114       0.0111       7.6709    2671.8647      82.8525     -73.5625    4415.0000
 2703.2712     108.4693     413.7154    1950.0000    1755.0433    1091.3295       0.9163     216.0000       0.0905       0.0160      -0.0198       2.8056      14.7400     265.2753     400.1510      54.1383      -0.0190      -0.0130       0.0099       7.8532    2682.6580      92.8530     -73.5625    4397.0000
 2703.4236     109.8885     528.3177    1950.0000    1398.5931     980.8331       1.0195     216.0000       0.0803       0.0050      -0.0312       2.8472      13.7194     260.9027     439.7798      54.1383      -0.0197      -0.0148       0.0085       7.9386    2701.4697     139.0236     -73.5625    4392.0000
 2703.5760     109.2546     711.7195    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0764       0.0008      -0.0355       2.4342      12.7454     269.2758     455.0619      54.1383      -0.0161      -0.0098       0.0138       7.9805    2708.6226     180.1936     -73.6875    4408.0000
 2703.7284     106.5736     949.5377    1950.0000    1950.0000    1935.8112       0.5166     216.0000       0.0760       0.0003      -0.0361       2.1451      11.1195     269.7409     454.9117      54.1383      -0.0146      -0.0075       0.0161       7.9885    2709.4834     231.0562     -73.5625    4434.0000
 2703.8808     102.6190    1133.1898    1950.0000    1950.0000    1353.9578       0.7386     216.0000       0.0823       0.0072      -0.0289       2.4811      11.6316     265.8335     439.5893      54.1383      -0.0180      -0.0124       0.0110       7.9795    2697.6780     313.9236     -79.7500    4415.0000
 2704.0332      98.3349    1117.6871    1950.0000    1950.0000     804.5468       1.2429     216.0000       0.0752      -0.0006      -0.0369       3.0578      12.1730     263.3217     434.3269      54.1383      -0.0193      -0.0142       0.0091       7.9248    2710.9609     421.9300     -73.5625    4430.0000
 2704.1856      94.4253     941.8116    1950.0000    1950.0000     662.3436       1.5098     216.0000       0.0707      -0.0054      -0.0419       3.6414      12.1730     257.1814     430.0818      54.1383      -0.0164      -0.0105       0.0132       7.8739    2719.1743     518.9820     -76.8750    4416.0000
 2704.3380      91.2426     748.5571    1950.0000    1950.0000     642.0475       1.5575     216.0000       0.0723      -0.0036      -0.0401       3.3630      12.4738     253.6461     430.0837      54.1383      -0.0179      -0.0127       0.0111       7.8555    2716.2222     486.4667     -75.0000    4436.0000
 2704.4904      88.8054     602.0379    1950.0000    1865.1190     523.7712       1.9092     216.0000       0.0788       0.0034      -0.0328       2.0461      12.4782     269.1827     431.4024      54.1383      -0.0174      -0.0112       0.0120       7.8564    2704.1858     342.2075     -73.3750    4449.0000
 2704.6428      86.8681     507.8105    1950.0000    1749.3143     593.6553       1.6845     216.0000       0.0818       0.0066      -0.0295       2.1334      13.3412     269.0897     437.7911      54.1383      -0.0177      -0.0120       0.0114       7.8541    2698.6602     315.8189     -80.5625    4429.0000
 2704.7952      85.2278     457.6320    1950.0000    1608.9493     608.3681       1.6437     216.0000       0.0840       0.0090      -0.0270       2.1872      14.7376     270.9504     438.2153      54.1383      -0.0172      -0.0110       0.0122       7.8376    2694.5771     253.3992     -77.4375    4421.0000
 2704.9476      83.9661     441.9628    1856.7432    1485.1733     589.3835       1.6967     216.0000       0.0840       0.0090      -0.0270       2.3971      14.7639     279.5095     428.3874      54.1383      -0.0169      -0.0103       0.0128       7.8156    2694.6177     242.8229     -77.0000    4465.0000
 2705.1000      83.1559     454.3801    1650.4889    1383.9783     359.7469       2.7797     216.0000       0.0790       0.0036      -0.0327       2.7118      15.0933     276.7184     416.5571      54.1383      -0.0175      -0.0112       0.0119       7.7927    2703.9026     250.7900     -78.4375    4453.0000
 2705.2524      82.7494     483.0490    1487.7435    1049.4395     482.1317       2.0741     216.0000       0.0799       0.0045      -0.0316       2.4848      13.2506     281.3701     406.9641      54.1383      -0.0195      -0.0141       0.0090       7.7886    2702.2212     329.0826     -77.3750    4447.0000
 2705.4048      81.7289     489.2477    1904.3052    1870.6787     924.1837       1.0820     216.0000       0.0860       0.0112      -0.0248       2.4495      12.3536     280.2537     402.9248      54.1383      -0.0194      -0.0143       0.0089       7.7964    2690.8621     211.4937     -77.0625    4446.0000
 2705.5572      77.7484     420.3018    1732.5659    1717.9823     616.8977       1.6210     216.0000       0.0894       0.0149      -0.0209       2.6562      10.3410     276.9045     402.9276      54.1383      -0.0180      -0.0127       0.0110       7.8086    2684.5554     159.3260     -81.5000    4432.0000
 2705.7096      73.4205     281.1697    1081.6566     908.9798     276.9205       3.6111     216.0000       0.0854       0.0105      -0.0255       2.6838       9.4738     268.9037     404.0365      54.1383      -0.0139      -0.0072       0.0168       7.8072    2692.0066     156.8157     -78.8125    4474.0000
 2705.8620      62.2571     179.7420     398.0648     421.7978     159.6450       6.2639     216.0000       0.0943       0.0201      -0.0155       2.9862      10.4529     263.3217     395.3076      54.1383      -0.0185      -0.0132       0.0102       7.8163    2675.5623     228.9844     -78.4375    4455.0000
 2706.0144      53.1504     161.7105     369.4115     303.7358      74.8701      13.3565     216.0000       0.1188       0.0467       0.0120       2.6553      13.3943     272.9971     382.6480      54.1383      -0.0215      -0.0170       0.0060       7.8755    2630.2046     216.1074     -75.9375    4446.0000
 2706.1668      56.1867     188.5659     418.0647     371.9091     183.6983       5.4437     216.0000       0.1349       0.0640       0.0300       2.6538      16.4294     280.6259     373.0659      54.1383      -0.0180      -0.0133       0.0107       7.9112    2600.4946     100.9983     -78.0625    4424.0000
 2706.3192      60.8018     185.5080     642.2429     550.5766     264.2690       3.7840     216.0000       0.1509       0.0814       0.0480       2.6697      23.4752     281.7422     361.9747      54.1383      -0.0185      -0.0154       0.0095       7.9382    2570.8318      22.0392     -77.1875    4448.0000
 2706.4716      56.1073     158.2190     430.4678     462.1243     279.4315       3.5787     216.0000       0.1494       0.0798       0.0463       2.5793      29.7006     284.8124     366.7600      54.1383       0.0142       0.0249       0.0546       7.9243    2573.6028      13.8604     -79.6250    4445.0000
 2706.6240      50.8334     110.7799     192.5625     105.2127      92.2337      10.8420     216.0000       0.1400       0.0696       0.0358       2.8581      31.4349     278.0209     390.8319      54.1383       0.0499       0.0666       0.1009       7.9283    2590.9561      15.0652     -78.8750    4470.0000
 2706.7764      73.6906     267.7199     509.6393     309.8522     232.9367       4.2930     216.0000       0.1195       0.0474       0.0127       2.7525      24.7088     263.1356     428.1502      54.1383       0.0039       0.0103       0.0401       7.9359    2628.9783      55.6366     -78.8125    4467.0000
 2706.9288      82.2310     325.1151    1113.1058     597.7318     511.8974       1.9535     216.0000       0.1035       0.0301      -0.0051       2.6907      16.4707     272.8111     451.1092      54.1383      -0.0192      -0.0164       0.0086       7.9300    2658.4927     138.3300     -77.5000    4464.0000
 2707.0812      85.6133     499.3364    1950.0000    1698.7455    1546.2432       0.6467     216.0000       0.0947       0.0206      -0.0150       2.3727      12.7852     270.7643     452.6091      54.1383      -0.0221      -0.0179       0.0050       7.8967    2674.7295     160.9948     -74.2500    4543.0000
 2707.2336      84.7157     671.5173    1950.0000    1950.0000    1809.3834       0.5527     216.0000       0.0838       0.0088      -0.0273       2.5754      12.3571     269.2758     448.2880      54.1383      -0.0214      -0.0162       0.0063       7.8495    2695.0034     231.1053     -78.9375    4506.0000
 2707.3860      83.4743     785.7944    1950.0000    1932.6964     917.0991       1.0904     216.0000       0.0712      -0.0048      -0.0414       2.6680      13.0075     272.8111     447.5172      54.1383      -0.0205      -0.0147       0.0077       7.8100    2718.2756     326.4925     -77.7500    4519.0000
 2707.5384      82.3268     841.4682    1733.0995    1434.5723     550.7198       1.8158     216.0000       0.0660      -0.0105      -0.0472       2.8313      11.4870     266.8569     446.5606      54.1383      -0.0202      -0.0144       0.0081       7.8002    2727.8940     346.6844     -78.0625    4476.0000
 2707.6908      82.6101     885.9674    1931.8857    1580.3760     342.6287       2.9186     216.0000       0.0612      -0.0157      -0.0526       2.8159      11.5133     268.3454     448.9355      54.1383      -0.0192      -0.0129       0.0097       7.7905    2736.8450     328.0297     -81.9375    4518.0000
 2707.8432      83.8569     963.3998    1950.0000    1389.7665     373.2911       2.6789     216.0000       0.0646      -0.0120      -0.0488       3.0220      12.1637     269.2758     445.8032      54.1383      -0.0202      -0.0142       0.0082       7.7911    2730.5474     311.7357     -79.9375    4432.0000
 2707.9956      85.2996    1072.8459    1950.0000    1769.1400     602.6103       1.6594     216.0000       0.0676      -0.0087      -0.0454       2.6639      13.9009     264.7171     443.9991      54.1383      -0.0229      -0.0185       0.0041       7.7951    2724.9419     290.9867     -83.3125    4413.0000
 2708.1480      86.2628    1205.2683    1950.0000    1299.7131     606.5416       1.6487     216.0000       0.0763       0.0007      -0.0356       2.3030      14.4167     265.9265     440.7585      54.1383      -0.0182      -0.0124       0.0108       7.8086    2708.7844     238.6269     -83.3125    4449.0000
 2708.3004      86.5696    1319.8682    1950.0000     824.3528     542.9033       1.8419     216.0000       0.0846       0.0097      -0.0263       2.2684      14.3166     265.1823     439.2495      54.1383      -0.0166      -0.0102       0.0131       7.8068    2693.4285     178.4543     -93.0625    4429.0000
 2708.4528      86.5014    1381.0156    1950.0000     601.3562     438.4117       2.2810     216.0000       0.0966       0.0227      -0.0129       2.5917      13.3410     266.9500     431.2062      54.1383      -0.0217      -0.0164       0.0060       7.7946    2671.2559     162.6055     -94.4375    4434.0000
 2708.6052      86.3549    1363.0016    1950.0000     756.4920     535.4029       1.8678     216.0000       0.0968       0.0229      -0.0127       2.6778      12.5822     270.3922     425.1702      54.1383      -0.0183      -0.0115       0.0110       7.7580    2670.8845     183.5712     -95.0625    4492.0000
 2708.7576      86.2042    1245.0503    1950.0000     901.1447     575.9826       1.7362     216.0000       0.0911       0.0167      -0.0190       2.9131      12.6823     271.1364     414.5064      54.1383      -0.0180      -0.0108       0.0116       7.7136    2681.3809     256.7280     -97.4375    4460.0000
 2708.9100      86.0243    1045.1699    1950.0000    1346.9171     695.5684       1.4377     216.0000       0.0797       0.0043      -0.0319       2.9047      12.4481     263.8798     402.8680      54.1383      -0.0239      -0.0190       0.0029       7.6575    2702.6155     357.0515     -96.0000    4441.0000
 2709.0624      85.8788     846.1461    1950.0000    1950.0000     783.7219       1.2760     216.0000       0.0755      -0.0002      -0.0365       2.7954      13.7489     260.9027     385.9031      54.1383      -0.0216      -0.0158       0.0063       7.6238    2710.2861     416.5429     -95.5000    4480.0000
 2709.2148      85.8073     706.5416    1950.0000    1387.8434     451.6655       2.2140     216.0000       0.0800       0.0047      -0.0315       2.2099      13.5321     260.8097     366.9658      54.1383      -0.0229      -0.0179       0.0042       7.6060    2701.9583     385.6279     -94.7500    4474.0000
 2709.3672      85.5600     636.5042    1950.0000    1725.9514     339.2692       2.9475     216.0000       0.0883       0.0136      -0.0222       2.0855      14.9586     264.1589     352.7741      54.1383      -0.0234      -0.0186       0.0035       7.6173    2686.6995     353.7460     -94.3750    4484.0000
 2709.5196      84.6755     629.5433    1950.0000    1893.6749     471.1373       2.1225     216.0000       0.0857       0.0108      -0.0251       2.5509      14.0998     271.5086     351.8651      54.1383      -0.0189      -0.0125       0.0100       7.6188    2691.4949     364.6866     -94.3750    4506.0000
 2709.6720      82.8359     673.9641    1950.0000    1950.0000     802.9928       1.2453     216.0000       0.0773       0.0017      -0.0346       2.5963      14.5334     273.6484     362.9630      54.1383      -0.0191      -0.0130       0.0097       7.6301    2707.0342     367.5548     -94.3125    4501.0000
 2709.8244      80.1970     739.2114    1950.0000    1950.0000    1852.8042       0.5397     216.0000       0.0697      -0.0064      -0.0430       2.9832      13.9914     272.8111     379.8990      54.1383      -0.0203      -0.0156       0.0077       7.6394    2721.0042     439.6874     -93.6250    4466.0000
 2709.9768      77.3459     762.4564    1950.0000    1950.0000    1663.7517       0.6011     216.0000       0.0732      -0.0027      -0.0391       2.7376      13.8747     272.6250     400.0981      54.1383      -0.0151      -0.0095       0.0149       7.6750    2714.5605     381.6798     -93.3125    4436.0000
 2710.1292      74.8944     704.9009    1950.0000    1950.0000    1293.7565       0.7729     216.0000       0.0976       0.0237      -0.0118       2.5900      13.9831     269.4618     405.3514      54.1383      -0.0087      -0.0015       0.0238       7.7434    2669.4622     261.7301     -94.9375    4472.0000
 2710.2816      73.1401     607.2046    1950.0000    1950.0000     623.6560       1.6034     216.0000       0.1167       0.0444       0.0096       2.5799      14.8451     268.5315     410.1398      54.1383      -0.0119      -0.0054       0.0194       7.8074    2634.0952     136.9589     -93.3125    4456.0000
 2710.4340      72.0460     527.2616    1950.0000    1950.0000     599.6480       1.6676     216.0000       0.1251       0.0535       0.0191       2.5637      13.8695     274.6717     411.5941      54.1383      -0.0172      -0.0115       0.0122       7.8412    2618.5398     112.8538     -93.0625    4444.0000
 2710.5864      71.3852     485.4535    1950.0000    1950.0000    1187.9143       0.8418     216.0000       0.1239       0.0522       0.0177       2.5661      12.7374     267.2290     410.0363      54.1383      -0.0151      -0.0092       0.0150       7.8412    2620.7180     101.4774     -93.0625    4437.0000
 2710.7388      70.9171     482.3427    1950.0000    1950.0000    1244.9698       0.8032     216.0000       0.1243       0.0526       0.0181       2.4784      11.3334     275.6021     389.8301      54.1383      -0.0161      -0.0097       0.0138       7.7809    2620.0850      60.7386     -89.7500    4449.0000
 2710.8912      70.4723     515.7139    1950.0000    1950.0000    1413.6003       0.7074     216.0000       0.1153       0.0429       0.0080       2.5871      11.7670     278.6721     361.5296      54.1383      -0.0195      -0.0141       0.0089       7.6644    2636.7222      61.5053     -83.3125    4448.0000
 2711.0436      69.9851     581.8410    1950.0000    1950.0000    1686.5415       0.5929     216.0000       0.1014       0.0278      -0.0075       3.0664      11.7029     281.5562     330.1792      54.1383      -0.0189      -0.0129       0.0099       7.5164    2662.4102      84.5464     -84.5625    4474.0000
 2711.1960      69.4668     666.4686    1950.0000    1950.0000    1950.0000       0.5092     216.0000       0.0867       0.0119      -0.0240       3.2036      12.3532     281.1841     318.8682      54.1383      -0.0191      -0.0138       0.0095       7.4231    2689.6096     152.8295     -77.4375    4448.0000
 2711.3484      69.0098     739.9016    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0840       0.0090      -0.0271       2.8538      13.9307     285.3705     319.6421      54.1383      -0.0199      -0.0154       0.0081       7.4196    2694.6526     157.1728    -101.4375    4461.0000
 2711.5008      68.7991     779.5141    1950.0000    1950.0000    1950.0000       0.5082     216.0000       0.0721      -0.0039      -0.0404       2.2247      14.2598     274.6717     337.1265      54.1383      -0.0134      -0.0079       0.0171       7.4451    2716.6116     141.2431     -98.3125    4523.0000
 2711.6532      68.9945     799.0626    1950.0000    1950.0000    1772.4326       0.5642     216.0000       0.0610      -0.0158      -0.0528       0.1600      15.0186     278.1140     354.0726      54.1383      -0.0063       0.0015       0.0272       7.4791    2737.0757     190.1853    -101.5625    4484.0000
 2711.8056      69.5879     832.6252    1950.0000    1950.0000    1645.8188       0.6076     216.0000       0.0670      -0.0094      -0.0461       1.8949      13.4907     282.5796     362.3927      54.1383      -0.0104      -0.0036       0.0215       7.5442    2726.1016     168.0796     -96.3750    4463.0000
 2711.9580      70.3376     908.9415    1950.0000    1950.0000    1334.9287       0.7491     216.0000       0.0793       0.0039      -0.0323       3.1429      13.4907     281.1841     374.5992      54.1383      -0.0102   